import { Component, ViewChild } from '@angular/core';
import { trigger, state, transition, animate, style, keyframes } from '@angular/animations';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/helper.service";
import * as i3 from "../services/controller.service";
import * as i4 from "@angular/common";
export class BookmarksPanelComponent {
    constructor(model, helper, controller) {
        this.model = model;
        this.helper = helper;
        this.controller = controller;
        controller.getMessage().subscribe((message) => {
            if (message.action === 'GetReport' || message.action === 'OpenReport') {
                setTimeout(() => {
                    if (this.model.reportParams.bookmarksContent != null) {
                        this.create();
                    }
                    this.model.controls.bookmarksPanel.visible = this.model.reportParams.bookmarksContent !== null && !this.model.options.isMobileDevice && !(this.model.options.toolbar?.showBookmarksButton === false);
                });
            }
            else {
                // Go to the bookmark, if it present
                setTimeout(() => {
                    if (this.model.options.bookmarkAnchor != null) {
                        this.helper.scrollToAnchor(this.model.options.bookmarkAnchor, this.model.options.componentGuid);
                        this.model.options.bookmarkAnchor = null;
                        this.model.options.componentGuid = null;
                    }
                });
            }
        });
        this.model.controls.bookmarksPanel.getVisibility().subscribe((value) => {
            if (!value) {
                this.helper.removeBookmarksLabel();
                this.clearSelected();
            }
        });
    }
    ngAfterViewInit() {
        this.model.controls.bookmarksPanel.el = this.element;
    }
    ngOnInit() { }
    getImg1(node, i) {
        if (node.nodes?.length === 0) {
            return i !== this.model.nodes.length - 1 ? this.model.imagesForBookmark['join'] : this.model.imagesForBookmark['joinBottom'];
        }
        return node.open ? (i === this.model.nodes.length - 1 ? this.model.imagesForBookmark['minusBottom'] : this.model.imagesForBookmark['minus']) :
            (i === this.model.nodes.length - 1 ? this.model.imagesForBookmark['plusBottom'] : this.model.imagesForBookmark['plus']);
    }
    postAction(node) {
        this.clearSelected();
        this.controller.postBookmarkNodeAction(node);
    }
    clearSelected() {
        this.model.nodes?.forEach((n) => {
            n.selected = false;
            n.nodes.forEach(element => element.selected = false);
        });
    }
    create() {
        let bookmarks = JSON.parse(this.model.reportParams.bookmarksContent);
        this.rootName = bookmarks.bookmarksTree[0].title;
        const nodes = [];
        this.parseNodes(bookmarks, 0, nodes);
        this.model.nodes = nodes;
    }
    parseNodes(bookmarks, index, nodes) {
        let folder;
        bookmarks.bookmarksTree.splice(1).forEach((bookmark) => {
            let page = bookmark.componentGuid != null && bookmarks.bookmarksPageIndexes != null ? (bookmarks.bookmarksPageIndexes[bookmark.componentGuid] - 1 ?? 0) : 0;
            const node = { name: bookmark.title, url: bookmark.url, page: page, compunentGuid: bookmark.componentGuid, nodes: [], open: false, selected: false };
            if (bookmark.parent === 0) {
                nodes.push(node);
                folder = node;
            }
            else {
                folder.nodes.push(node);
            }
        });
    }
    unescape(str) {
        return str.replace(/\\&apos;/g, '\'')
            .replace(/\\&quot;/g, '"')
            .replace(/\\&gt;/g, '>')
            .replace(/\\&lt;/g, '<')
            .replace(/\\&amp;/g, '&');
    }
    get bottom() {
        if (this.model.options.isMobileDevice) {
            return this.model.options.toolbar.autoHide ? '0' : '0.5in';
        }
        else {
            return this.model.options.toolbar.displayMode === 'Separated' && this.model.options.toolbar.visible ? '35px' : '0';
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: BookmarksPanelComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }, { token: i3.ControllerService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: BookmarksPanelComponent, selector: "sti-bookmarks-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }, { propertyName: "bookmarksPanel", first: true, predicate: ["bookmarksPanel"], descendants: true }], ngImport: i0, template: `
    <div #element [style]="{fontFamily: model.options.toolbar.fontFamily, fontColor: helper.val(model.options.toolbar.fontColor)}"
      [class]="'stiJsViewerBookmarksPanel' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerBookmarksPanelSeparated' : '')"
      [style.width.px]="model.options.appearance.bookmarksTreeWidth - (model.options.toolbar.displayMode == 'Simple' ? 0 : 1)"
      [style.bottom]="bottom"
      [style.top.px]="model.controls.bookmarksPanel.layout.top"
      [style.transition]="model.options.isMobileDevice ? 'opacity 300ms ease' : null"
      [style.display]="!this.model.options.isMobileDevice ? (model.controls.bookmarksPanel.visible ? '' : 'none') : null"
      [@visibility]="!this.model.options.isMobileDevice ? null : (model.controls.bookmarksPanel.visible ? 'visible' : 'hidden')">
      <div #bookmarksPanel [class]="'stiJsViewerBookmarksContainer' + (model.options.toolbar.displayMode == 'Simple' ? ' stiJsViewerBookmarksContainerSimple' : '')"
           [style.background]="helper.val(model.options.toolbar.backgroundColor)"
           [style.border]="helper.val(model.options.toolbar.borderColor) != '' ? '1px solid ' + helper.val(model.options.toolbar.borderColor): ''">
           <div class="stiTree">
              <div class="stiTreeNode">
                <img [style.width.px]="16" [style.height.px]="16" [src]="model.imagesForBookmark['root']"/>
                <a class="node">{{rootName}}</a>
              </div>
              <div class="clip" [style.display]="'block'">
                <ng-container *ngFor="let node of model.nodes; index as i">
                    <div class="stiTreeNode">
                        <a (click)="node.open = !node.open">
                            <img [style.width.px]="18" [style.height.px]="18"
                             [src]="getImg1(node, i)"/>
                        </a>
                        <img [style.width.px]="16" [style.height.px]="16" [src]="node.nodes?.length == 0 ? model.imagesForBookmark['node'] :(node.open ? model.imagesForBookmark['folderOpen'] : model.imagesForBookmark['folder'])"/>
                        <a [class]="node.selected ? 'nodeSel' : 'node'" (click)="postAction(node)">{{node.name}}</a>
                    </div>
                    <div class="clip" [style.display]="node.open ? 'block' : 'none'">
                      <div *ngFor="let subNode of node.nodes; index as k" class="stiTreeNode">
                        <img [style.width.px]="18" [style.height.px]="18" [src]="i != model.nodes.length - 1 ? model.imagesForBookmark['line'] : model.imagesForBookmark['empty']"/>
                        <img [style.width.px]="18" [style.height.px]="18" [src]="k == node.nodes.length - 1 ? model.imagesForBookmark['joinBottom'] : model.imagesForBookmark['join']"/>
                        <img [style.width.px]="16" [style.height.px]="16" [src]="model.imagesForBookmark['node']" />
                        <a [class]="subNode.selected ? 'nodeSel' : 'node'" (click)="postAction(subNode)">{{subNode.name}}</a>
                      </div>
                    </div>
                </ng-container>
              </div>
          </div>
      </div>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }], animations: [
            trigger('visibility', [
                state('visible', style({ opacity: 1, display: 'block' })),
                state('hidden', style({ opacity: 0, display: 'none' })),
                transition('hidden => visible', [
                    animate('300ms ease-in-out', keyframes([
                        style({ display: 'block', opacity: 0, offset: 0 }),
                        style({ display: 'block', opacity: 1, offset: 1 }),
                    ]))
                ]),
                transition('visible => hidden', [
                    animate('300ms ease-in-out', keyframes([
                        style({ display: 'block', opacity: 1, offset: 0 }),
                        style({ display: 'none', opacity: 0, offset: 1 }),
                    ]))
                ])
            ])
        ] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: BookmarksPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-bookmarks-panel',
                    template: `
    <div #element [style]="{fontFamily: model.options.toolbar.fontFamily, fontColor: helper.val(model.options.toolbar.fontColor)}"
      [class]="'stiJsViewerBookmarksPanel' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerBookmarksPanelSeparated' : '')"
      [style.width.px]="model.options.appearance.bookmarksTreeWidth - (model.options.toolbar.displayMode == 'Simple' ? 0 : 1)"
      [style.bottom]="bottom"
      [style.top.px]="model.controls.bookmarksPanel.layout.top"
      [style.transition]="model.options.isMobileDevice ? 'opacity 300ms ease' : null"
      [style.display]="!this.model.options.isMobileDevice ? (model.controls.bookmarksPanel.visible ? '' : 'none') : null"
      [@visibility]="!this.model.options.isMobileDevice ? null : (model.controls.bookmarksPanel.visible ? 'visible' : 'hidden')">
      <div #bookmarksPanel [class]="'stiJsViewerBookmarksContainer' + (model.options.toolbar.displayMode == 'Simple' ? ' stiJsViewerBookmarksContainerSimple' : '')"
           [style.background]="helper.val(model.options.toolbar.backgroundColor)"
           [style.border]="helper.val(model.options.toolbar.borderColor) != '' ? '1px solid ' + helper.val(model.options.toolbar.borderColor): ''">
           <div class="stiTree">
              <div class="stiTreeNode">
                <img [style.width.px]="16" [style.height.px]="16" [src]="model.imagesForBookmark['root']"/>
                <a class="node">{{rootName}}</a>
              </div>
              <div class="clip" [style.display]="'block'">
                <ng-container *ngFor="let node of model.nodes; index as i">
                    <div class="stiTreeNode">
                        <a (click)="node.open = !node.open">
                            <img [style.width.px]="18" [style.height.px]="18"
                             [src]="getImg1(node, i)"/>
                        </a>
                        <img [style.width.px]="16" [style.height.px]="16" [src]="node.nodes?.length == 0 ? model.imagesForBookmark['node'] :(node.open ? model.imagesForBookmark['folderOpen'] : model.imagesForBookmark['folder'])"/>
                        <a [class]="node.selected ? 'nodeSel' : 'node'" (click)="postAction(node)">{{node.name}}</a>
                    </div>
                    <div class="clip" [style.display]="node.open ? 'block' : 'none'">
                      <div *ngFor="let subNode of node.nodes; index as k" class="stiTreeNode">
                        <img [style.width.px]="18" [style.height.px]="18" [src]="i != model.nodes.length - 1 ? model.imagesForBookmark['line'] : model.imagesForBookmark['empty']"/>
                        <img [style.width.px]="18" [style.height.px]="18" [src]="k == node.nodes.length - 1 ? model.imagesForBookmark['joinBottom'] : model.imagesForBookmark['join']"/>
                        <img [style.width.px]="16" [style.height.px]="16" [src]="model.imagesForBookmark['node']" />
                        <a [class]="subNode.selected ? 'nodeSel' : 'node'" (click)="postAction(subNode)">{{subNode.name}}</a>
                      </div>
                    </div>
                </ng-container>
              </div>
          </div>
      </div>
    </div>
  `,
                    animations: [
                        trigger('visibility', [
                            state('visible', style({ opacity: 1, display: 'block' })),
                            state('hidden', style({ opacity: 0, display: 'none' })),
                            transition('hidden => visible', [
                                animate('300ms ease-in-out', keyframes([
                                    style({ display: 'block', opacity: 0, offset: 0 }),
                                    style({ display: 'block', opacity: 1, offset: 1 }),
                                ]))
                            ]),
                            transition('visible => hidden', [
                                animate('300ms ease-in-out', keyframes([
                                    style({ display: 'block', opacity: 1, offset: 0 }),
                                    style({ display: 'none', opacity: 0, offset: 1 }),
                                ]))
                            ])
                        ])
                    ]
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.HelperService }, { type: i3.ControllerService }], propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], bookmarksPanel: [{
                type: ViewChild,
                args: ['bookmarksPanel']
            }] } });
//# sourceMappingURL=data:application/json;base64,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