import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/controller.service";
import * as i3 from "../services/helper.service";
import * as i4 from "../forms/form.service";
export class AboutPanelComponent {
    constructor(model, controller, helper, formService) {
        this.model = model;
        this.controller = controller;
        this.helper = helper;
        this.formService = formService;
        this.year = new Date().getFullYear();
        this.top = 0;
        this.left = 0;
        this.opacity = 0;
        controller.getActionMessage().subscribe((message) => {
            if (message.action === 'About') {
                this.formService.form = { name: 'about', left: 0, top: 0, isMooving: false, level: 2 };
                this.opacity = 0;
                setTimeout(() => {
                    this.top = this.model.viewerSize.height / 2 - this.element.nativeElement.offsetHeight / 2;
                    this.left = this.model.viewerSize.width / 2 - this.element.nativeElement.offsetWidth / 2;
                    this.opacity = 1;
                });
            }
        });
    }
    ngOnInit() { }
    close() {
        this.formService.closeForm('about');
    }
    click(event) {
        if (event) {
            event.stopPropagation();
            event.preventDefault();
        }
        this.helper.openNewWindow('https://www.stimulsoft.com');
    }
    isLicensed() {
        return !this.model.options.cloudMode && !this.model.options.serverMode && !this.model.options.standaloneJsMode &&
            !this.model.options.reportDesignerMode && !this.model.options.licenseIsValid;
    }
    get userLabel() {
        let userName = this.model.options.licenseUserName || '';
        if (this.isLicensed()) {
            if (userName) {
                userName += ', ';
            }
            return userName + this.helper.getBackText(true) + ' Version';
        }
        else {
            return userName;
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: AboutPanelComponent, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }, { token: i3.HelperService }, { token: i4.FormService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: AboutPanelComponent, selector: "sti-about-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element class="stiJsViewerAboutPanel" [style.backgroundSize]="'contain'"
      [style.display]="formService.form?.name == 'about' ? '' : 'none'"
      [style.left.px]="left"
      [style.top.px]="top"
      [style.opacity]="opacity"
      (click)="close()" >
      <div class="stiJsViewerAboutPanelHeader">
        Stimulsoft Reports
      </div>
      <img src="{{model.img('About.png')}}"
          [style.marginTop.px]="30"
          [style.height.px]="94"
          [style.width.px]="94">
      <div class="stiJsViewerAboutPanelCopyright">
        {{'Copyright 2003-' + year + ' Stimulsoft'}}
      </div>
      <div class="stiJsViewerAboutPanelVersion">
        {{model.options.productVersion?.trim()}}, {{model.options?.frameworkType}}, Angular
      </div>
      <div class="stiJsViewerAboutPanelVersion">
        All rights reserved
      </div>
      <div class="stiJsViewerAboutPanelVersion"
        [style.marginTop.px]="20"
        [style.fontWeight]="'bold'"
        [style.color]="isLicensed() ? 'red' : '#444444'"
        [style.display]="isLicensed() || userLabel ? '' : 'none'">
        {{userLabel}}
      </div>
      <div class="stiJsViewerFormSeparator" [style.marginTop.px]="20">
      </div>
      <div class="stiJsViewerAboutPanelStiLink" (click)='click($event)'>
        www.stimulsoft.com
      </div>
    </div>
  `, isInline: true }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: AboutPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-about-panel',
                    template: `
    <div #element class="stiJsViewerAboutPanel" [style.backgroundSize]="'contain'"
      [style.display]="formService.form?.name == 'about' ? '' : 'none'"
      [style.left.px]="left"
      [style.top.px]="top"
      [style.opacity]="opacity"
      (click)="close()" >
      <div class="stiJsViewerAboutPanelHeader">
        Stimulsoft Reports
      </div>
      <img src="{{model.img('About.png')}}"
          [style.marginTop.px]="30"
          [style.height.px]="94"
          [style.width.px]="94">
      <div class="stiJsViewerAboutPanelCopyright">
        {{'Copyright 2003-' + year + ' Stimulsoft'}}
      </div>
      <div class="stiJsViewerAboutPanelVersion">
        {{model.options.productVersion?.trim()}}, {{model.options?.frameworkType}}, Angular
      </div>
      <div class="stiJsViewerAboutPanelVersion">
        All rights reserved
      </div>
      <div class="stiJsViewerAboutPanelVersion"
        [style.marginTop.px]="20"
        [style.fontWeight]="'bold'"
        [style.color]="isLicensed() ? 'red' : '#444444'"
        [style.display]="isLicensed() || userLabel ? '' : 'none'">
        {{userLabel}}
      </div>
      <div class="stiJsViewerFormSeparator" [style.marginTop.px]="20">
      </div>
      <div class="stiJsViewerAboutPanelStiLink" (click)='click($event)'>
        www.stimulsoft.com
      </div>
    </div>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.ControllerService }, { type: i3.HelperService }, { type: i4.FormService }], propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });
//# sourceMappingURL=data:application/json;base64,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