import Color from "./Color";
import { DateTime } from "./DateTime";
import List from "./List";
export default class StiJson {
    static prettyPrint: boolean;
    options: any;
    static dateToJsonDate(date: DateTime): string;
    static jsonDateFormatToDate(jsonDate: string): DateTime;
    name: string;
    value: any;
    private isProperty;
    private isArray;
    properties(): List<StiJson>;
    removeProperty(propertyName: string): void;
    addPropertyNumber(propertyName: string, value: number): void;
    addPropertyNumberNotNull(propertyName: string, value: number): void;
    addPropertyNumberNoDefaultValue(propertyName: string, value: number): void;
    addPropertyJObject(propertyName: string, value: StiJson): void;
    addPropertyArray(propertyName: string, elements: any[]): void;
    addPropertyIdent(propertyName: string, value: string): void;
    addPropertyBool(propertyName: string, value: boolean): void;
    addPropertyEnum(propertyName: string, enumType: any, value: any, defaultValue?: any): void;
    addPropertyColor(propertyName: string, color: Color, defColor?: Color): void;
    addPropertyString(propertyName: string, value: string, defaultValue?: string): void;
    addPropertyStringNullOrEmpty(propertyName: string, value: string): void;
    get count(): number;
    getArray(): any[];
    serialize(indent?: number): string;
    deserialize(text: any): void;
    private deserializeFromObject;
    toString(): string;
    constructor(name?: string, value?: any, isProperty?: boolean, options?: any);
}
