import { Subject } from "rxjs";
import { StiSignatureElement } from "../elements/StiSignatureElement";
import { StiModelService } from "./model.service";
import { StiTextItem } from "../elements/text/StiTextItem";
import { StiImageEditorResult } from "../elements/signature/StiImageEditorResult";
import { StiHorizontalAlignment, StiVerticalAlignment } from "../system/enums";
import * as i0 from "@angular/core";
export declare class SignatureService {
    model: StiModelService;
    private _editorComponentX;
    private _editorComponentY;
    textMode: boolean;
    selectedMode: string;
    previewFonts: string[];
    currentPreviewFont: string;
    drawingMode: boolean;
    showFontsPreview: boolean;
    loadedImage: Subject<any>;
    clearButtonClick: Subject<boolean>;
    updateSignature: Subject<any>;
    getInsertedInformation: Subject<any>;
    currentEditableText: StiTextItem;
    currentEditableImage: any | StiImageEditorResult;
    currentEditableFullName: string;
    currentEditableInitials: string;
    currentCanvasContent: any;
    editorComponentHeight: number;
    editorComponentWidth: number;
    fontsPreviewX: number;
    fontsPreviewY: number;
    templatesPreviewX: number;
    templatesPreviewY: number;
    showSavedTemplates: boolean;
    savedTemplates: any[];
    currentActiveLoadingImages: number;
    completedLoadingImages: number;
    completedLoading: Subject<any>;
    currentSignatureElement: StiSignatureElement | null;
    currentEditableSignatureElement: StiSignatureElement | null;
    checkLoading(): void;
    getVerticalPosition(verticalAlignment: StiVerticalAlignment): "top" | "bottom" | "center";
    getHorizontalPosition(horizontalAlignment: StiHorizontalAlignment): "center" | "left" | "right";
    getClass(item: any): typeof StiTextItem | typeof StiImageEditorResult;
    setTemplate(template: any): void;
    getTemplateImage(template: any): string;
    getTemplateDrawedImage(template: any): string;
    deleteTemplate(index: any): void;
    getTemplateHorizontalAlignment(template: any): "center" | "start" | "end";
    getTemplateBackgroundSize(template: any, container: any): string;
    getTemplateBackgroundPosition(template: any): "center" | "center center" | "top center" | "bottom center";
    cloneProperty(property: StiTextItem | StiImageEditorResult, propertyClass: any): any;
    get editorComponentX(): number;
    set editorComponentX(value: number);
    get editorComponentY(): number;
    set editorComponentY(value: number);
    get y(): number;
    get x(): number;
    changeDrawingMode(): void;
    changeTextMode(): void;
    clear(): void;
    onFileSelected(): void;
    get isSignature(): boolean;
    constructor(model: StiModelService);
    static ɵfac: i0.ɵɵFactoryDeclaration<SignatureService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<SignatureService>;
}
