import { StiUsedFontsList } from "../services/objects";
import Color from "../system/Color";
import { StiHorizontalAlignment, StiNumberType, StiThousandSeparator, StiNumberRangeFormat, StiUnitAlignment, StiDisplayCurrencyAs, StiLineWeight } from "../system/enums";
import { Font } from "../system/Font";
import { StiLabel, StiDescription, StiEditableContent, StiValueElement, StiNumberElement, StiTabIndex } from "../system/interfaces";
import StiJson from "../system/StiJson";
import { StiFormElement } from "./base/StiFormElement";
import { StiTextItem } from "./text/StiTextItem";
export declare class StiNumberBoxElement extends StiFormElement implements StiLabel, StiDescription, StiEditableContent, StiValueElement, StiNumberElement, StiTabIndex {
    private _decimalDigits;
    private _maximum;
    type: string;
    tooltip: string;
    required: boolean;
    description: StiTextItem;
    font: Font;
    contentAlignment: StiHorizontalAlignment;
    backgroundColor: Color;
    textColor: Color;
    value: number;
    allowNegative: boolean;
    numberType: StiNumberType;
    thousandSeparator: StiThousandSeparator;
    useRange: boolean;
    private _minimum;
    rangeFormat: StiNumberRangeFormat;
    unitLabel: string;
    unitAlignment: StiUnitAlignment;
    unitForeground: Color;
    currencyLabelFormat: StiDisplayCurrencyAs;
    currency: string;
    borderColor: Color;
    borderWeight: StiLineWeight;
    tabIndex: number;
    constructor();
    setDefaultValues(): void;
    setTabIndex(value: number): number;
    getDefaultEditableContent(): StiEditableContent;
    get isCurrency(): boolean;
    get eValue(): string;
    get decimalDigits(): number;
    set decimalDigits(value: number);
    get maximum(): number;
    set maximum(value: number);
    get minimum(): number;
    set minimum(value: number);
    set eValue(value: string);
    get eFont(): Font;
    set eFont(value: Font);
    get eBackgroundColor(): Color;
    set eBackgroundColor(value: Color);
    get eContentAlignment(): StiHorizontalAlignment;
    set eContentAlignment(value: StiHorizontalAlignment);
    haveContentAlignment(): boolean;
    haveVerticalAlignment(): boolean;
    getUsedFonts(usedFonts: StiUsedFontsList): void;
    haveBackgoundColor(): boolean;
    get eColor(): Color;
    set eColor(value: Color);
    htmlStyle(): string;
    setProperty(propName: string, value: any, oldObject: any): void;
    saveToJsonObject(options: any): StiJson;
    loadFromJsonObject(json: StiJson): void;
}
