import { StiUsedFontsList } from "../services/objects";
import Color from "../system/Color";
import { StiHorizontalAlignment, StiLineWeight, StiDateTimeBoxType, StiDateTimeBoxValueChoise } from "../system/enums";
import { Font } from "../system/Font";
import { StiLabel, StiDescription, StiValueElement, StiEditableContent, StiTabIndex, UpdateToViewerMode } from "../system/interfaces";
import StiJson from "../system/StiJson";
import { StiFormElement } from "./base/StiFormElement";
import { StiForm } from "./StiForm";
import { StiTextItem } from "./text/StiTextItem";
export declare class StiDateTimeBoxElement extends StiFormElement implements StiLabel, StiDescription, StiValueElement, StiTabIndex, UpdateToViewerMode {
    type: string;
    tooltip: string;
    required: boolean;
    description: StiTextItem;
    font: Font;
    contentAlignment: StiHorizontalAlignment;
    backgroundColor: Color;
    textColor: Color;
    borderColor: Color;
    borderWeight: StiLineWeight;
    allowNull: boolean;
    tabIndex: number;
    private _dateTimeValueIsNotNull;
    private _form;
    private _dateTimeFormat;
    private _dateFomat;
    private _timeFormat;
    private _initialState;
    private _dateValue;
    private _valueType;
    private _dateValueString;
    constructor(form?: StiForm);
    updateToViewerMode(): void;
    get dateValueString(): string;
    get dateTimeValueIsNotNull(): boolean;
    set dateTimeValueIsNotNull(value: boolean);
    set form(value: StiForm);
    get form(): StiForm;
    get initialState(): StiDateTimeBoxValueChoise;
    get dateValue(): Date;
    set dateValue(value: Date);
    updateDateValueString(): void;
    set initialState(value: StiDateTimeBoxValueChoise);
    setDefaultValues(): void;
    get valueType(): StiDateTimeBoxType;
    set valueType(value: StiDateTimeBoxType);
    get value(): any;
    get format(): string;
    get dateTimeFormat(): string;
    set dateTimeFormat(value: string);
    get dateFormat(): string;
    set dateFormat(value: string);
    get timeFormat(): string;
    set timeFormat(value: string);
    setTabIndex(value: number): number;
    getUsedFonts(usedFonts: StiUsedFontsList): void;
    getDefaultEditableContent(): StiEditableContent;
    htmlStyle(): string;
    saveToJsonObject(options: any): StiJson;
    loadFromJsonObject(json: StiJson): void;
}
