import { AfterContentChecked, AfterViewInit, ChangeDetectorRef, ElementRef, OnDestroy, OnInit } from "@angular/core";
import { StiModelService } from "../../services/model.service";
import { StiTableElement } from "../../elements/StiTableElement";
import { StiPen } from "../../properties/StiPen";
import { StiDraggableService } from "../../services/sti-draggable.service";
import { StiMouseService } from "../../services/mouse.service";
import { StiColumnDraggableService } from "../../services/sti-column-draggable.service";
import { StiEditableContentService } from "../../services/sti-editable-content.service";
import * as i0 from "@angular/core";
export declare class StiTableComponent implements OnInit, AfterViewInit, OnDestroy, AfterContentChecked {
    model: StiModelService;
    draggableService: StiDraggableService;
    columnDraggableService: StiColumnDraggableService;
    editableContentService: StiEditableContentService;
    private cdr;
    mouseService?: StiMouseService;
    element: StiTableElement;
    isClone: boolean;
    minWidth: number;
    isDrag: boolean;
    canDrag: boolean;
    draggableItemIndex: number;
    mouseDownX: number;
    mouseDownY: number;
    isInitialized: boolean;
    isActive: boolean;
    private _canAddRow;
    private _canDeleteRow;
    tableTr: ElementRef;
    tBody: ElementRef;
    totals: ElementRef;
    table: ElementRef;
    tableRow: ElementRef;
    componentDescription: ElementRef;
    componentLabel: ElementRef;
    innerMargin: number;
    get selected(): boolean;
    get canAddRow(): boolean;
    set canAddRow(value: boolean);
    get canDeleteRow(): boolean;
    set canDeleteRow(value: boolean);
    checkAbilityToAddRow(): void;
    getMaxHeight(): number;
    checkAbilityToDeleteRow(): void;
    canDeleteColumn(): boolean;
    getSizeWithZoom(size: number): number;
    isOverMaxHeight(): boolean;
    updatePropertyGrid(column: any, event: any): void;
    get totalsWidth(): number;
    getPageColor(): string;
    get align(): string;
    get contentAlign(): "start" | "flex-end";
    get width(): string;
    get margin(): "0" | "10";
    get headerAlignment(): string;
    get rowAlignment(): string;
    get totalVerticalAlignment(): "center" | "flex-end" | "flex-start";
    get totalHorizontalAlignment(): "center" | "flex-end" | "flex-start";
    onHeaderClick(event: MouseEvent, item: any): void;
    changeStyle(elem: any): void;
    get tableBackColor(): string;
    addColumn(): void;
    addRow(): void;
    deleteColumn(): void;
    deleteRow(): void;
    getColumnAlignment(column: any): string;
    getBorder(pen: StiPen, isVisible: boolean, isDragPreview?: boolean): string;
    getBorderWidth(pen: StiPen, isDragPreview: boolean): string;
    getColumnBackColor(column: any, index: any): any;
    getColumnForeColor(column: any, index: any): any;
    constructor(model: StiModelService, draggableService: StiDraggableService, columnDraggableService: StiColumnDraggableService, editableContentService: StiEditableContentService, cdr: ChangeDetectorRef, mouseService?: StiMouseService);
    ngAfterContentChecked(): void;
    ngOnDestroy(): void;
    ngAfterViewInit(): void;
    ngOnInit(): void;
    changeState(column: any, i: any): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<StiTableComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<StiTableComponent, "sti-table-component", never, { "element": { "alias": "element"; "required": false; }; "isClone": { "alias": "isClone"; "required": false; }; }, {}, never, never, false, never>;
}
