import { Component, ViewChild, } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../services/sti-column-draggable.service";
import * as i2 from "../services/model.service";
import * as i3 from "@angular/common";
import * as i4 from "../components/sti-table/sti-table-column/sti-table-column.component";
export class StiDraggableColumnContainerComponent {
    constructor(draggableService, model, cdref) {
        this.draggableService = draggableService;
        this.model = model;
        this.cdref = cdref;
    }
    ngOnInit() { }
    getBorder(pen) {
        return pen.toHtmlBorder();
    }
    get columnWidth() {
        let booleanButton = document.querySelector(".boolean-button");
        return booleanButton ? booleanButton.clientWidth : "max-content";
    }
    getColumnHeight(type) {
        if (this.draggableService?.fromTable) {
            if (type == "td") {
                let parentElement = document.getElementById(this.draggableService.parentElement.guid);
                let tdElements = parentElement.getElementsByClassName("sti-table-td");
                return tdElements[0].clientHeight;
            }
            else {
                let parentElement = document.getElementById(this.draggableService.parentElement.guid);
                let thElements = parentElement.getElementsByClassName("sti-table-th");
                return thElements[0].clientHeight;
            }
        }
        else {
            return;
        }
    }
    ngAfterViewChecked() {
        // setTimeout(() => {
        this.draggableService.containerHeight = this.container?.nativeElement.offsetHeight;
        this.draggableService.containerWidth = this.container?.nativeElement.offsetWidth;
        this.cdref.detectChanges();
        // }, 0);
    }
    ngAfterViewInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiDraggableColumnContainerComponent, deps: [{ token: i1.StiColumnDraggableService }, { token: i2.StiModelService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiDraggableColumnContainerComponent, selector: "sti-draggable-column-container", viewQueries: [{ propertyName: "container", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div
      #element
      style="position: absolute; z-index: 999; background-color:rgb(226,226,226); opacity:0.7; userSelect:none;"
      *ngIf="draggableService.isDragging"
      [style.visibility]="draggableService.isDragging ? 'visible' : 'hidden'"
      [style.transform]="model.getScale()"
      [style.transform-origin]="'left top'"
      [style.left]="draggableService.left"
      [style.top]="draggableService.top"
      [style.width.px]="draggableService.fromTable ? draggableService?.item?.width : columnWidth"
      [style.height]="draggableService.fromTable ? 'auto' : '22px'"
      [style.pointer-events]="'none'"
    >
      <div *ngIf="draggableService.fromTable">
        <table [style.border]="getBorder(draggableService?.parentElement?.gridLines?.pen)">
          <tr>
            <th
              [style.border]="getBorder(draggableService?.parentElement?.gridLines?.pen)"
              [style]="draggableService.parentElement.font.htmlStyle()"
              [style.height.px]="getColumnHeight('th')"
            >
              {{ draggableService.itemLabel }}
            </th>
          </tr>
          <tr *ngFor="let row of draggableService.parentElement.rowLabelsContentEditable; index as i">
            <td
              [style]="draggableService.parentElement.font.htmlStyle()"
              [style.border]="getBorder(draggableService?.parentElement?.gridLines?.pen)"
              [style.height.px]="getColumnHeight('td')"
            >
              <sti-table-column-component
                [column]="draggableService.item"
                [index]="i"
                [element]="draggableService.parentElement"
              ></sti-table-column-component>
            </td>
          </tr>
        </table>
      </div>
      <div *ngIf="!draggableService.fromTable" class="boolean-button">
        <div class="arrow">></div>
        <div class="content">
          {{ draggableService.itemLabel }}
        </div>
      </div>
    </div>
  `, isInline: true, styles: ["table{width:100%;border-collapse:collapse}th{padding:5px}td{padding:4px}.arrow{width:30px;text-align:center;cursor:default;-webkit-touch-callout:none;-webkit-user-select:none}.content{cursor:default;-webkit-touch-callout:none;-webkit-user-select:none;flex:1}.boolean-button{width:100%;font-size:12px;height:100%;font-weight:600;display:flex;padding-top:2px;flex-direction:row;color:var(--text-color);background-color:var(--hover-color)}\n"], dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.StiTableColumnComponent, selector: "sti-table-column-component", inputs: ["column", "index", "element"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiDraggableColumnContainerComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-draggable-column-container", template: `
    <div
      #element
      style="position: absolute; z-index: 999; background-color:rgb(226,226,226); opacity:0.7; userSelect:none;"
      *ngIf="draggableService.isDragging"
      [style.visibility]="draggableService.isDragging ? 'visible' : 'hidden'"
      [style.transform]="model.getScale()"
      [style.transform-origin]="'left top'"
      [style.left]="draggableService.left"
      [style.top]="draggableService.top"
      [style.width.px]="draggableService.fromTable ? draggableService?.item?.width : columnWidth"
      [style.height]="draggableService.fromTable ? 'auto' : '22px'"
      [style.pointer-events]="'none'"
    >
      <div *ngIf="draggableService.fromTable">
        <table [style.border]="getBorder(draggableService?.parentElement?.gridLines?.pen)">
          <tr>
            <th
              [style.border]="getBorder(draggableService?.parentElement?.gridLines?.pen)"
              [style]="draggableService.parentElement.font.htmlStyle()"
              [style.height.px]="getColumnHeight('th')"
            >
              {{ draggableService.itemLabel }}
            </th>
          </tr>
          <tr *ngFor="let row of draggableService.parentElement.rowLabelsContentEditable; index as i">
            <td
              [style]="draggableService.parentElement.font.htmlStyle()"
              [style.border]="getBorder(draggableService?.parentElement?.gridLines?.pen)"
              [style.height.px]="getColumnHeight('td')"
            >
              <sti-table-column-component
                [column]="draggableService.item"
                [index]="i"
                [element]="draggableService.parentElement"
              ></sti-table-column-component>
            </td>
          </tr>
        </table>
      </div>
      <div *ngIf="!draggableService.fromTable" class="boolean-button">
        <div class="arrow">></div>
        <div class="content">
          {{ draggableService.itemLabel }}
        </div>
      </div>
    </div>
  `, styles: ["table{width:100%;border-collapse:collapse}th{padding:5px}td{padding:4px}.arrow{width:30px;text-align:center;cursor:default;-webkit-touch-callout:none;-webkit-user-select:none}.content{cursor:default;-webkit-touch-callout:none;-webkit-user-select:none;flex:1}.boolean-button{width:100%;font-size:12px;height:100%;font-weight:600;display:flex;padding-top:2px;flex-direction:row;color:var(--text-color);background-color:var(--hover-color)}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiColumnDraggableService }, { type: i2.StiModelService }, { type: i0.ChangeDetectorRef }], propDecorators: { container: [{
                type: ViewChild,
                args: ["element"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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