/*
{*******************************************************************}
{                                                                   }

{                                                                   }
{                                                                   }
{   Copyright (C)  Stimulsoft                                       }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
import Hashtable from './Hashtable';
import Dictionary from './Dictionary';
import { StiObject } from './StiObject';
export default class List extends Array {
    constructor(items) {
        super();
        if (typeof items == "number") {
        }
        else if (items)
            items.forEach(item => this.push(item));
        try {
            this.__proto__ = List.prototype;
            Object.defineProperty(this, "__proto__", { enumerable: false });
        }
        catch (e) {
            Object.defineProperty(this, "__proto__", { enumerable: false, writable: true });
            this.__proto__ = List.prototype;
        }
    }
    /*static create<T>(t: Type, ...values: any[]): List<T> {
        let isStructure = false;
        if (typeof values[values.length - 1] == "boolean") isStructure = !!values.pop();

        if (values.length == 0) {
            if (t == Number) return <any>0;
            if (t == Boolean) return <any>false;
            if (isStructure) return new (<any>t);
            else return null;
        }

        let newList = new List<T>();
        let count: number = values.shift();
        for (let i = 0; i < count; i++) {
            let value: any = List.create.apply(this, (<any[]>[t]).concat(values, [isStructure]));
            newList.push(value);
        }

        return newList;
    }*/
    get countItems() {
        let properties = StiObject.keys(this);
        return properties.length;
    }
    //#region Range
    addRange(items) {
        for (let item of items)
            this.push(item);
    }
    removeRange(index, count) {
        this.splice(index, count);
    }
    getRange(index, count) {
        if (index == null || index < 0)
            index = 0;
        if (index + count > this.length)
            count = this.length - index;
        return new List(this.slice(index, index + count));
    }
    //#endregion
    add(item) {
        this.push(item);
    }
    insert(index, item) {
        this.splice(index, 0, item);
    }
    getKeys() {
        return StiObject.keys(this).sort((a, b) => {
            if (a < b)
                return -1;
            else if (a > b)
                return 1;
            else
                return 0;
        });
    }
    getByIndex(index, keys = null) {
        if (keys == null)
            keys = this.getKeys();
        return this[keys[index]];
    }
    setByIndex(index, item) {
        let properties = StiObject.keys(this);
        this[properties[index]] = item;
    }
    removeByIndex(index) {
        let removeIndex = this.indexOf(this.getByIndex(index, null));
        delete this[removeIndex];
        return this;
    }
    copyTo(array, index = 0) {
        let destIndex = index;
        for (let sourceIndex = 0; sourceIndex < this.length; sourceIndex++) {
            array[destIndex] = this[sourceIndex];
            destIndex++;
        }
    }
    /** Removes all elements from the List. */
    clear() {
        this.splice(0, this.length);
    }
    peek() {
        return this[this.length - 1];
    }
    remove(item) {
        let index = this.indexOf(item);
        if (index >= 0)
            this.removeAt(index);
    }
    /** Removes the element at the specified index of the Lis.
     * @param index The zero-based index of the element to remove.
     * @throw index is less than 0. -or- index is equal to or greater than Count.
     */
    removeAt(index) {
        this.splice(index, 1);
    }
    exists(predicate) {
        for (let value of this) {
            if (predicate(value))
                return true;
        }
        return false;
    }
    fullOuterJoin(inner, outerKeySelector, innerKeySelector, resultSelector, __this) {
        let innerLookup = inner.toLookup(innerKeySelector, __this);
        let outerLookup = this.toLookup(outerKeySelector, __this);
        let innerJoinItems = inner
            .where(innerItem => !outerLookup.contains(innerKeySelector.apply(__this, [innerItem])))
            .select(innerItem => resultSelector.apply(__this, [null, innerItem]));
        return this
            .selectMany2(outerItem => {
            let innerItems = innerLookup.get(outerKeySelector.apply(__this, [outerItem]));
            return innerItems.any() ? innerItems : new List();
        }, resultSelector, __this)
            .concat(innerJoinItems);
    }
    toList() {
        return new List(this);
    }
    findIndex2(match) {
        for (let index = 0; index < this.length; index++) {
            if (match(this[index]))
                return index;
        }
        return -1;
    }
    findLastIndex2(match) {
        let lastIndex = -1;
        for (let index = 0; index < this.length; index++) {
            if (match(this[index]))
                lastIndex = index;
        }
        return lastIndex;
    }
    zip(second, resultSelector) {
        let result = new List();
        for (let index = 0; index < this.length; index++) {
            result.add(resultSelector(this[index], second[index]));
        }
        return result;
    }
    static repeat(element, count) {
        let list = new List();
        for (let i = 0; i < count; i++) {
            list.push(element);
        }
        return list;
    }
    //#region Filtering
    /** Filters a sequence of values based on a predicate.
     * @param predicate A function to test each element for a condition.
     * @returns An List that contains elements from the input sequence that satisfy the condition.
     */
    where(predicate, __this) {
        let filter = new List();
        for (let index = 0; index < this.length; index++) {
            let value = this[index];
            predicate.apply(__this, [value, index]) ? filter.push(value) : null;
        }
        return filter;
    }
    //#endregion
    //#region Join
    /** Correlates the elements of two sequences based on matching keys. The default
     * equality comparer is used to compare keys.
     * @param inner The sequence to join to the first sequence.
     * @param outerKeySelector A function to extract the join key from each element of the first sequence.
     * @param innerKeySelector A function to extract the join key from each element of the second sequence.
     * @param resultSelector A function to create a result element from two matching elements.
     * @returns An List that has elements of type V
     * that are obtained by performing an inner join on two sequences.
     */
    join2(inner, outerKeySelector, innerKeySelector, resultSelector, __this) {
        let result = new List();
        let innerKeys = new Hashtable();
        for (let i of inner) {
            let innerKey = innerKeySelector.apply(__this, [i]);
            innerKeys.set(innerKey, i);
        }
        for (let o of this) {
            let outerKey = outerKeySelector.apply(__this, [o]);
            let i = innerKeys.get(outerKey);
            if (i != null)
                result.push(resultSelector.apply(__this, [o, i]));
        }
        return result;
    }
    /** Correlates the elements of two sequences based on equality of keys and groups
     * the results. The default equality comparer is used to compare keys.
     * @param inner The sequence to join to the first sequence.
     * @param outerKeySelector A function to extract the join key from each element of the first sequence.
     * @param innerKeySelector A function to extract the join key from each element of the second sequence.
     * @param resultSelector A function to create a result element from an element from the first sequence
     * and a collection of matching elements from the second sequence.
     * @returns An List that contains elements of type V
     * that are obtained by performing a grouped join on two sequences.
     */
    groupJoin(inner, outerKeySelector, innerKeySelector, resultSelector, __this) {
        let result = new List();
        let innerKeys = new Hashtable();
        for (let i of inner) {
            let key = innerKeySelector.apply(__this, [i]);
            let innerResult = innerKeys.get(key);
            if (innerResult == null) {
                innerResult = new List();
                innerKeys.set(key, innerResult);
            }
            innerResult.push(i);
        }
        for (let o of this) {
            let key = outerKeySelector.apply(__this, [o]);
            let innerResult = innerKeys.get(key);
            if (innerResult == null)
                innerResult = new List();
            result.push(resultSelector.apply(__this, [o, innerResult]));
        }
        return result;
    }
    //#endregion
    //#region Projection
    /**
     * Projects each element of a sequence into a new form.
     * @param selector A transform function to apply to each element.
     * @returns An List whose elements are the result of invoking the transform function on each element of source.
     */
    select(selector, __this) {
        let filter = new List();
        this.forEach(value => filter.push(selector.apply(__this, [value])));
        return filter;
    }
    selectMany(selector, __this) {
        let filter = new List();
        this.forEach(value => {
            let result = selector.apply(__this, [value]);
            if (result != null)
                result.forEach(item => filter.push(item));
        });
        return filter;
    }
    selectMany2(collectionSelector, resultSelector, __this) {
        let filter = new List();
        this.forEach(value => {
            let result = collectionSelector.apply(__this, [value]);
            if (result != null)
                result.forEach(item => filter.push(resultSelector.apply(__this, [value, item])));
        });
        return filter;
    }
    //#endregion
    //#region Sorting
    /** Sorts the elements of a sequence in ascending order according to a key or by using a specified comparer.
     * @param keySelector A function to extract a key from an element.
     * @param comparer An System.Collections.Generic.IComparer`1 to compare keys.
     * @returns An System.Linq.IOrderedEnumerable`1 whose elements are sorted according to a key.
     */
    /*orderBy<K>(keySelector: (value: T) => K, comparer?: IComparer<K>): List<T> {
         let sort: T[] = this.ss.toArray();
         if (comparer == null) comparer = {
             compare: (x: K, y: K) => {
                 if (x != null && y == null) return 1;
                 if (x == null && y != null) return -1;
                 if (x == null && y == null) return 0;

                 return x.ss.compareTo(y);
             }
         };

         sort.sort((a: T, b: T) => comparer.compare(keySelector(a), keySelector(b)));

         return new List<T>(sort);
     }

     orderByDescending<K>(keySelector: (value: T) => K, comparer?: IComparer<K>): List<T> {
         let sort: T[] = this.ss.toArray();
         if (comparer == null) comparer = {
             compare: (x: K, y: K) => {
                 if (x != null && y == null) return -1;
                 if (x == null && y != null) return 1;
                 if (x == null && y == null) return 0;

                 return y.ss.compareTo(x);
             }
         };

         sort.sort((a: T, b: T) => comparer.compare(keySelector(a), keySelector(b)));

         return new List<T>(sort);
     }*/
    //#endregion
    //#region Grouping
    /** Groups the elements of a sequence according to a specified key selector function
     * and compares the keys by using a specified comparer.
     * @param keySelector A function to extract the key for each element.
     * @param comparer An System.Collections.Generic.IEqualityComparer`1 to compare keys.
     * @returns An IEnumerable<IGrouping<TKey, TSource>> in C# or IEnumerable(Of IGrouping(Of
     * TKey, TSource)) in Visual Basic where each System.Linq.IGrouping`2 object contains
     * a collection of objects and a key.
     */
    /*-groupBy<K>(keySelector: (value: T) => K, comparer?: IEqualityComparer<K>, __this?: any): List<Grouping<K, T>> {
        let result = new List<Grouping<K, T>>();
        if (comparer == null) comparer = {
            equals: (x: K, y: K) => {
                if (x == y) return true;
                return false;
            },
            getHashCode: () => 0
        };

        for (let item of this) {
            let key = keySelector.apply(__this, [item]);
            let group = result.firstOrDefault(g => comparer.equals(g.key, key));
            if (group == null) {
                group = new Grouping(new List<T>([]));
                group.key = key;
                result.push(group);
            }
            group.push(item);
        }

        return result;
    }*/
    //#endregion
    //#region Conversions
    /** Converts the elements of an List to the specified type.
     * @returns An List that contains each element of the source sequence converted to the specified type.
     */
    cast() {
        let cast = new List();
        let castFunction;
        /*if (typeof <S>{} == "string") castFunction = (value: T) => value.s.toString();
        else if (typeof <S>{} == "number") castFunction = (value: T) => value.s.ss.toNumber();
        else if (typeof <S>{} == "boolean") castFunction = (value: T) => value.s.ss.toBoolean();
        else*/ castFunction = (value) => value;
        this.forEach(value => cast.push(castFunction(value)));
        return cast;
    }
    toDictionary(keySelector, elementSelector) {
        let dictionary = new Dictionary();
        for (let index = 0; index < this.length; index++) {
            dictionary.add(keySelector(this[index]), elementSelector(this[index]));
        }
        return dictionary;
    }
    /** Creates a Lookup from an List
     * according to a specified key selector function.
     * @param keySelector A function to extract a key from each element.
     * @returns A Lookup that contains keys and values.
     */
    toLookup(keySelector, __this) {
        let hashtable = new Hashtable();
        for (let item of this) {
            let key = keySelector.apply(__this, [item]);
            let lookup = hashtable.get(key);
            if (lookup == null) {
                lookup = new List();
                hashtable.set(key, lookup);
            }
            lookup.push(item);
        }
        return hashtable;
    }
    //#endregion
    //#region Concatenation
    /** Concatenates two sequences.
     * @param second The sequence to concatenate to the first sequence.
     * @returns An List that contains the concatenated elements
     * of the two input sequences.
     */
    concat(second) {
        let concatedList = new List();
        for (let item of this)
            concatedList.push(item);
        for (let item of second)
            concatedList.push(item);
        return concatedList;
    }
    //#endregion
    //#region Aggregation
    /**
     * Applies an accumulator function over a sequence.
     * @param func An accumulator function to be invoked on each element.
     * @returns The final accumulator value.
     */
    aggregate(func) {
        let seed = this[0];
        for (let index = 1; index < this.length; index++) {
            seed = func(seed, this[index]);
        }
        return seed;
    }
    aggregate2(seed, func) {
        for (let index = 0; index < this.length; index++) {
            seed = func(seed, this[index]);
        }
        return seed;
    }
    count2(selector, __this) {
        if (selector == null)
            selector = (value) => true;
        let count = 0;
        this.forEach(item => selector.apply(__this, [item]) ? count++ : null);
        return count;
    }
    /** Invokes a transform function on each element of a sequence and returns the maximum value.
     * @param selector A transform function to apply to each element.
     * @returns The maximum value in the sequence.
     */
    /*max<S>(selector?: (value: T) => S): S {
        if (selector == null) selector = (value: T) => <S><any>value;
        if (this.length == 0) return null;
        let max = selector(this[0]);
        let maxFunc: Function;
        if (typeof max == "string") maxFunc = function (strA: string, strB: string): string { return strA.ss.compareTo(strB) >= 0 ? strA : strB; };
        if (typeof max == "number") maxFunc = Math.max;
        if (max instanceof DateTime) maxFunc = function (dateA: DateTime, dateB: DateTime): DateTime { return DateTime.compare(dateA, dateB) >= 0 ? dateA : dateB; };

        for (let index = 1; index < this.length; index++) {
            max = maxFunc(selector(this[index]), max);
        }

        return max;
    }*/
    /** Invokes a transform function on each element of a sequence and returns the minimum value.
     * @parm selector A transform function to apply to each element.
     * @returns The minimum value in the sequence.
     */
    /*min<S>(selector?: (value: T) => S): S {
        if (selector == null) selector = (value: T) => <S><any>value;
        if (this.length == 0) return null;
        let min = selector(this[0]);
        let minFunc: Function;
        if (typeof min == "string") minFunc = function (strA: string, strB: string): string { return strA.ss.compareTo(strB) <= 0 ? strA : strB; };
        if (typeof min == "number") minFunc = Math.min;
        if (min instanceof DateTime) minFunc = function (dateA: DateTime, dateB: DateTime): DateTime { return DateTime.compare(dateA, dateB) <= 0 ? dateA : dateB; };

        for (let index = 1; index < this.length; index++) {
            min = minFunc(selector(this[index]), min);
        }

        return min;
    }*/
    /** Computes the sum of the sequence of System.Decimal values that are obtained by
     * invoking a transform function on each element of the input sequence.
     * @param selector A transform function to apply to each element.
     * @returns The sum of the projected values.
     */
    /*sum(selector?: (value: T) => number): number {
        if (selector == null) selector = (value: T) => value.ss.toNumber();
        let sum = 0;
        this.forEach(value => sum += selector(value));
        return sum;
    }*/
    //#endregion
    //#region Quantifier Operations
    all(predicate, __this) {
        if (predicate == null)
            predicate = (value) => true;
        for (let value of this)
            if (!predicate.apply(__this, [value]))
                return false;
        return true;
    }
    /** Determines whether any element of a sequence satisfies a condition.
     * @param predicate A function to test each element for a condition.
     * @returns true if any elements in the source sequence pass the test in the specified predicate; otherwise, false.
     */
    any(predicate, __this) {
        if (predicate == null)
            predicate = (value) => true;
        for (let value of this)
            if (predicate.apply(__this, [value]))
                return true;
        return false;
    }
    /** Determines whether an element is in the List.
     * @param item The object to locate in the List. The value can be null for reference types.
     * @returns true if item is found in the List otherwise, false.
     */
    contains(item) {
        return this.indexOf(item) >= 0;
    }
    //#endregion
    //#region Partition Operations
    skip(count) {
        let result = new List();
        for (let index = count; index < this.length; index++) {
            result.add(this[index]);
        }
        return result;
    }
    take(count) {
        let result = new List();
        if (count > this.length)
            count = this.length;
        for (let index = 0; index < count; index++) {
            result.add(this[index]);
        }
        return result;
    }
    //#endregion
    //#region Generation Operations
    defaultIfEmpty() {
        if (this.length > 0)
            return this;
        return new List([null]);
    }
    //#endregion
    //#region Set Operations
    /** Returns distinct elements from a sequence by using the default equality comparer to compare values.
     * @returns An List that contains distinct elements from the source sequence.
     */
    distinct() {
        let filter = new List();
        this.forEach(value => filter.indexOf(value) < 0 ? filter.push(value) : null);
        return filter;
    }
    except(second) {
        let result = new List();
        for (let item of this) {
            if (second.indexOf(item) == -1)
                result.add(item);
        }
        return result;
    }
    union(second) {
        let union = new List();
        this.forEach(element => union.add(element));
        second.forEach(element => union.add(element));
        return union.distinct();
    }
    //#endregion
    //#region Equality
    sequenceEqual(second) {
        if (this.length != second.length)
            return false;
        for (let index = 0; index < this.length; index++) {
            if (this[index] != second[index])
                return false;
        }
        return true;
    }
    //#endregion
    //#region Element
    first(selector, __this) {
        if (selector == null)
            selector = (value) => true;
        for (let item of this) {
            if (selector.apply(__this, [item]))
                return item;
        }
        return null;
    }
    /** Returns the first element of the sequence that satisfies a condition or a default value if no such element is found.
     * @param predicate A function to test each element for a condition.
     * @returns if source is empty or if no element passes the test specified by predicate;
     * otherwise, the first element in source that passes the test specified by predicate.
     */
    firstOrDefault(predicate) {
        for (let value of this) {
            if (predicate == null)
                return value;
            if (predicate(value))
                return value;
        }
        return null;
    }
    lastOrDefault() {
        let item;
        for (let value of this) {
            item = value;
        }
        return item;
    }
}
StiObject.disableAllEnumerable(List.prototype, new List());
//# sourceMappingURL=data:application/json;base64,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