/*
{*******************************************************************}
{                                                                   }

{                                                                   }
{                                                                   }
{   Copyright (C)  Stimulsoft                                       }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
export default class Color {
    constructor() {
        this.propertyName = "color";
        this.name = Color.customName;
    }
    static aliceBlue() {
        let color = Color.fromArgb(0xf0, 0xf8, 0xff);
        color.name = "Alice Blue";
        return color;
    }
    static antiqueWhite() {
        let color = Color.fromArgb(0xfa, 0xeb, 0xd7);
        color.name = "Antique White";
        return color;
    }
    static aqua() {
        let color = Color.fromArgb(0x00, 0xff, 0xff);
        color.name = "Aqua";
        return color;
    }
    static aquamarine() {
        let color = Color.fromArgb(0x7f, 0xff, 0xd4);
        color.name = "Aquamarine";
        return color;
    }
    static azure() {
        let color = Color.fromArgb(0xf0, 0xff, 0xff);
        color.name = "Azure";
        return color;
    }
    static beige() {
        let color = Color.fromArgb(0xf5, 0xf5, 0xdc);
        color.name = "Beige";
        return color;
    }
    static bisque() {
        let color = Color.fromArgb(0xff, 0xe4, 0xc4);
        color.name = "Bisque";
        return color;
    }
    static black() {
        let color = Color.fromArgb(0x00, 0x00, 0x00);
        color.name = "Black";
        return color;
    }
    static blanchedAlmond() {
        let color = Color.fromArgb(0xff, 0xeb, 0xcd);
        color.name = "Blanched Almond";
        return color;
    }
    static blue() {
        let color = Color.fromArgb(0x00, 0x00, 0xff);
        color.name = "Blue";
        return color;
    }
    static blueViolet() {
        let color = Color.fromArgb(0x8a, 0x2b, 0xe2);
        color.name = "Blue Violet";
        return color;
    }
    static brown() {
        let color = Color.fromArgb(0xa5, 0x2a, 0x2a);
        color.name = "Brown";
        return color;
    }
    static burlyWood() {
        let color = Color.fromArgb(0xde, 0xb8, 0x87);
        color.name = "Burly Wood";
        return color;
    }
    static cadetBlue() {
        let color = Color.fromArgb(0x5f, 0x9e, 0xa0);
        color.name = "Cadet Blue";
        return color;
    }
    static chartreuse() {
        let color = Color.fromArgb(0x7f, 0xff, 0x00);
        color.name = "Chartreuse";
        return color;
    }
    static chocolate() {
        let color = Color.fromArgb(0xd2, 0x69, 0x1e);
        color.name = "Chocolate";
        return color;
    }
    static coral() {
        let color = Color.fromArgb(0xff, 0x7f, 0x50);
        color.name = "Coral";
        return color;
    }
    static cornflowerBlue() {
        let color = Color.fromArgb(0x64, 0x95, 0xed);
        color.name = "Cornflower Blue";
        return color;
    }
    static cornsilk() {
        let color = Color.fromArgb(0xff, 0xf8, 0xdc);
        color.name = "Cornsilk";
        return color;
    }
    static crimson() {
        let color = Color.fromArgb(0xdc, 0x14, 0x3c);
        color.name = "Crimson";
        return color;
    }
    static cyan() {
        let color = Color.fromArgb(0x00, 0xff, 0xff);
        color.name = "Cyan";
        return color;
    }
    static darkBlue() {
        let color = Color.fromArgb(0x00, 0x00, 0x8b);
        color.name = "Dark Blue";
        return color;
    }
    static darkCyan() {
        let color = Color.fromArgb(0x00, 0x8b, 0x8b);
        color.name = "Dark Cyan";
        return color;
    }
    static darkGoldenrod() {
        let color = Color.fromArgb(0xb8, 0x86, 0x0b);
        color.name = "Dark Goldenrod";
        return color;
    }
    static darkGray() {
        let color = Color.fromArgb(0xa9, 0xa9, 0xa9);
        color.name = "Dark Gray";
        return color;
    }
    static darkGreen() {
        let color = Color.fromArgb(0x00, 0x64, 0x00);
        color.name = "Dark Green";
        return color;
    }
    static darkKhaki() {
        let color = Color.fromArgb(0xbd, 0xb7, 0x6b);
        color.name = "Dark Khaki";
        return color;
    }
    static darkMagenta() {
        let color = Color.fromArgb(0x8b, 0x00, 0x8b);
        color.name = "Dark Magenta";
        return color;
    }
    static darkOliveGreen() {
        let color = Color.fromArgb(0x55, 0x6b, 0x2f);
        color.name = "Dark Olive Green";
        return color;
    }
    static darkOrange() {
        let color = Color.fromArgb(0xff, 0x8c, 0x00);
        color.name = "Dark Orange";
        return color;
    }
    static darkOrchid() {
        let color = Color.fromArgb(0x99, 0x32, 0xcc);
        color.name = "Dark Orchid";
        return color;
    }
    static darkRed() {
        let color = Color.fromArgb(0x8b, 0x00, 0x00);
        color.name = "Dark Red";
        return color;
    }
    static darkSalmon() {
        let color = Color.fromArgb(0xe9, 0x96, 0x7a);
        color.name = "Dark Salmon";
        return color;
    }
    static darkSeaGreen() {
        let color = Color.fromArgb(0x8f, 0xbc, 0x8f);
        color.name = "Dark Sea Green";
        return color;
    }
    static darkSlateBlue() {
        let color = Color.fromArgb(0x48, 0x3d, 0x8b);
        color.name = "Dark Slate Blue";
        return color;
    }
    static darkSlateGray() {
        let color = Color.fromArgb(0x2f, 0x4f, 0x4f);
        color.name = "Dark Slate Gray";
        return color;
    }
    static darkTurquoise() {
        let color = Color.fromArgb(0x00, 0xce, 0xd1);
        color.name = "Dark Turquoise";
        return color;
    }
    static darkViolet() {
        let color = Color.fromArgb(0x94, 0x00, 0xd3);
        color.name = "Dark Violet";
        return color;
    }
    static deepPink() {
        let color = Color.fromArgb(0xff, 0x14, 0x93);
        color.name = "Deep Pink";
        return color;
    }
    static deepSkyBlue() {
        let color = Color.fromArgb(0x00, 0xbf, 0xff);
        color.name = "Deep Sky Blue";
        return color;
    }
    static dimGray() {
        let color = Color.fromArgb(0x69, 0x69, 0x69);
        color.name = "Dim Gray";
        return color;
    }
    static dodgerBlue() {
        let color = Color.fromArgb(0x1e, 0x90, 0xff);
        color.name = "Dodger Blue";
        return color;
    }
    static firebrick() {
        let color = Color.fromArgb(0xb2, 0x22, 0x22);
        color.name = "Firebrick";
        return color;
    }
    static floralWhite() {
        let color = Color.fromArgb(0xff, 0xfa, 0xf0);
        color.name = "Floral White";
        return color;
    }
    static forestGreen() {
        let color = Color.fromArgb(0x22, 0x8b, 0x22);
        color.name = "Forest Green";
        return color;
    }
    static fuchsia() {
        let color = Color.fromArgb(0xff, 0x00, 0xff);
        color.name = "Fuchsia";
        return color;
    }
    static gainsboro() {
        let color = Color.fromArgb(0xdc, 0xdc, 0xdc);
        color.name = "Gainsboro";
        return color;
    }
    static ghostWhite() {
        let color = Color.fromArgb(0xf8, 0xf8, 0xff);
        color.name = "Ghost White";
        return color;
    }
    static gold() {
        let color = Color.fromArgb(0xff, 0xd7, 0x00);
        color.name = "Gold";
        return color;
    }
    static goldenrod() {
        let color = Color.fromArgb(0xda, 0xa5, 0x20);
        color.name = "Goldenrod";
        return color;
    }
    static gray() {
        let color = Color.fromArgb(0x80, 0x80, 0x80);
        color.name = "Gray";
        return color;
    }
    static green() {
        let color = Color.fromArgb(0x00, 0x80, 0x00);
        color.name = "Green";
        return color;
    }
    static greenYellow() {
        let color = Color.fromArgb(0xad, 0xff, 0x2f);
        color.name = "Green Yellow";
        return color;
    }
    static honeydew() {
        let color = Color.fromArgb(0xf0, 0xff, 0xf0);
        color.name = "Honeydew";
        return color;
    }
    static hotPink() {
        let color = Color.fromArgb(0xff, 0x69, 0xb4);
        color.name = "Hot Pink";
        return color;
    }
    static indianRed() {
        let color = Color.fromArgb(0xcd, 0x5c, 0x5c);
        color.name = "Indian Red";
        return color;
    }
    static indigo() {
        let color = Color.fromArgb(0x4b, 0x00, 0x82);
        color.name = "Indigo";
        return color;
    }
    static ivory() {
        let color = Color.fromArgb(0xff, 0xff, 0xf0);
        color.name = "Ivory";
        return color;
    }
    static khaki() {
        let color = Color.fromArgb(0xf0, 0xe6, 0x8c);
        color.name = "Khaki";
        return color;
    }
    static lavender() {
        let color = Color.fromArgb(0xe6, 0xe6, 0xfa);
        color.name = "Lavender";
        return color;
    }
    static lavenderBlush() {
        let color = Color.fromArgb(0xff, 0xf0, 0xf5);
        color.name = "Lavender Blush";
        return color;
    }
    static lawnGreen() {
        let color = Color.fromArgb(0x7c, 0xfc, 0x00);
        color.name = "Lawn Green";
        return color;
    }
    static lemonChiffon() {
        let color = Color.fromArgb(0xff, 0xfa, 0xcd);
        color.name = "Lemon Chiffon";
        return color;
    }
    static lightBlue() {
        let color = Color.fromArgb(0xad, 0xd8, 0xe6);
        color.name = "Light Blue";
        return color;
    }
    static lightCoral() {
        let color = Color.fromArgb(0xf0, 0x80, 0x80);
        color.name = "Light Coral";
        return color;
    }
    static lightCyan() {
        let color = Color.fromArgb(0xe0, 0xff, 0xff);
        color.name = "Light Cyan";
        return color;
    }
    static lightGoldenrodYellow() {
        let color = Color.fromArgb(0xfa, 0xfa, 0xd2);
        color.name = "Light Goldenrod Yellow";
        return color;
    }
    static lightGray() {
        let color = Color.fromArgb(0xd3, 0xd3, 0xd3);
        color.name = "Light Gray";
        return color;
    }
    static lightGreen() {
        let color = Color.fromArgb(0x90, 0xee, 0x90);
        color.name = "Light Green";
        return color;
    }
    static lightPink() {
        let color = Color.fromArgb(0xff, 0xb6, 0xc1);
        color.name = "Light Pink";
        return color;
    }
    static lightSalmon() {
        let color = Color.fromArgb(0xff, 0xa0, 0x7a);
        color.name = "Light Salmon";
        return color;
    }
    static lightSeaGreen() {
        let color = Color.fromArgb(0x20, 0xb2, 0xaa);
        color.name = "Light Sea Green";
        return color;
    }
    static lightSkyBlue() {
        let color = Color.fromArgb(0x87, 0xce, 0xfa);
        color.name = "Light Sky Blue";
        return color;
    }
    static lightSlateGray() {
        let color = Color.fromArgb(0x77, 0x88, 0x99);
        color.name = "Light Slate Gray";
        return color;
    }
    static lightSteelBlue() {
        let color = Color.fromArgb(0xb0, 0xc4, 0xde);
        color.name = "Light Steel Blue";
        return color;
    }
    static lightYellow() {
        let color = Color.fromArgb(0xff, 0xff, 0xe0);
        color.name = "Light Yellow";
        return color;
    }
    static lime() {
        let color = Color.fromArgb(0x00, 0xff, 0x00);
        color.name = "Lime";
        return color;
    }
    static limeGreen() {
        let color = Color.fromArgb(0x32, 0xcd, 0x32);
        color.name = "Lime Green";
        return color;
    }
    static linen() {
        let color = Color.fromArgb(0xfa, 0xf0, 0xe6);
        color.name = "Linen";
        return color;
    }
    static magenta() {
        let color = Color.fromArgb(0xff, 0x00, 0xff);
        color.name = "Magenta";
        return color;
    }
    static maroon() {
        let color = Color.fromArgb(0x80, 0x00, 0x00);
        color.name = "Maroon";
        return color;
    }
    static mediumAquamarine() {
        let color = Color.fromArgb(0x66, 0xcd, 0xaa);
        color.name = "Medium Aquamarine";
        return color;
    }
    static mediumBlue() {
        let color = Color.fromArgb(0x00, 0x00, 0xcd);
        color.name = "Medium Blue";
        return color;
    }
    static mediumOrchid() {
        let color = Color.fromArgb(0xba, 0x55, 0xd3);
        color.name = "Medium Orchid";
        return color;
    }
    static mediumPurple() {
        let color = Color.fromArgb(0x93, 0x70, 0xdb);
        color.name = "Medium Purple";
        return color;
    }
    static mediumSeaGreen() {
        let color = Color.fromArgb(0x3c, 0xb3, 0x71);
        color.name = "Medium Sea Green";
        return color;
    }
    static mediumSlateBlue() {
        let color = Color.fromArgb(0x7b, 0x68, 0xee);
        color.name = "Medium Slate Blue";
        return color;
    }
    static mediumSpringGreen() {
        let color = Color.fromArgb(0x00, 0xfa, 0x9a);
        color.name = "Medium Spring Green";
        return color;
    }
    static mediumTurquoise() {
        let color = Color.fromArgb(0x48, 0xd1, 0xcc);
        color.name = "Medium Turquoise";
        return color;
    }
    static mediumVioletRed() {
        let color = Color.fromArgb(0xc7, 0x15, 0x85);
        color.name = "Medium Violet Red";
        return color;
    }
    static midnightBlue() {
        let color = Color.fromArgb(0x19, 0x19, 0x70);
        color.name = "Midnight Blue";
        return color;
    }
    static mintCream() {
        let color = Color.fromArgb(0xf5, 0xff, 0xfa);
        color.name = "Mint Cream";
        return color;
    }
    static mistyRose() {
        let color = Color.fromArgb(0xff, 0xe4, 0xe1);
        color.name = "Misty Rose";
        return color;
    }
    static moccasin() {
        let color = Color.fromArgb(0xff, 0xe4, 0xb5);
        color.name = "Moccasin";
        return color;
    }
    static navajoWhite() {
        let color = Color.fromArgb(0xff, 0xde, 0xad);
        color.name = "Navajo White";
        return color;
    }
    static navy() {
        let color = Color.fromArgb(0x00, 0x00, 0x80);
        color.name = "Navy";
        return color;
    }
    static oldLace() {
        let color = Color.fromArgb(0xfd, 0xf5, 0xe6);
        color.name = "Old Lace";
        return color;
    }
    static olive() {
        let color = Color.fromArgb(0x80, 0x80, 0x00);
        color.name = "Olive";
        return color;
    }
    static oliveDrab() {
        let color = Color.fromArgb(0x6b, 0x8e, 0x23);
        color.name = "Olive Drab";
        return color;
    }
    static orange() {
        let color = Color.fromArgb(0xff, 0xa5, 0x00);
        color.name = "Orange";
        return color;
    }
    static orangeRed() {
        let color = Color.fromArgb(0xff, 0x45, 0x00);
        color.name = "Orange Red";
        return color;
    }
    static orchid() {
        let color = Color.fromArgb(0xda, 0x70, 0xd6);
        color.name = "Orchid";
        return color;
    }
    static paleGoldenrod() {
        let color = Color.fromArgb(0xee, 0xe8, 0xaa);
        color.name = "Pale Goldenrod";
        return color;
    }
    static paleGreen() {
        let color = Color.fromArgb(0x98, 0xfb, 0x98);
        color.name = "Pale Green";
        return color;
    }
    static paleTurquoise() {
        let color = Color.fromArgb(0xaf, 0xee, 0xee);
        color.name = "Pale Turquoise";
        return color;
    }
    static paleVioletRed() {
        let color = Color.fromArgb(0xdb, 0x70, 0x93);
        color.name = "Pale Violet Red";
        return color;
    }
    static papayaWhip() {
        let color = Color.fromArgb(0xff, 0xef, 0xd5);
        color.name = "Papaya Whip";
        return color;
    }
    static peachPuff() {
        let color = Color.fromArgb(0xff, 0xda, 0xb9);
        color.name = "Peach Puff";
        return color;
    }
    static peru() {
        let color = Color.fromArgb(0xcd, 0x85, 0x3f);
        color.name = "Peru";
        return color;
    }
    static pink() {
        let color = Color.fromArgb(0xff, 0xc0, 0xcb);
        color.name = "Pink";
        return color;
    }
    static plum() {
        let color = Color.fromArgb(0xdd, 0xa0, 0xdd);
        color.name = "Plum";
        return color;
    }
    static powderBlue() {
        let color = Color.fromArgb(0xb0, 0xe0, 0xe6);
        color.name = "Powder Blue";
        return color;
    }
    static purple() {
        let color = Color.fromArgb(0x80, 0x00, 0x80);
        color.name = "Purple";
        return color;
    }
    static red() {
        let color = Color.fromArgb(0xff, 0x00, 0x00);
        color.name = "Red";
        return color;
    }
    static rosyBrown() {
        let color = Color.fromArgb(0xbc, 0x8f, 0x8f);
        color.name = "Rosy Brown";
        return color;
    }
    static royalBlue() {
        let color = Color.fromArgb(0x41, 0x69, 0xe1);
        color.name = "Royal Blue";
        return color;
    }
    static saddleBrown() {
        let color = Color.fromArgb(0x8b, 0x45, 0x13);
        color.name = "Saddle Brown";
        return color;
    }
    static salmon() {
        let color = Color.fromArgb(0xfa, 0x80, 0x72);
        color.name = "Salmon";
        return color;
    }
    static sandyBrown() {
        let color = Color.fromArgb(0xf4, 0xa4, 0x60);
        color.name = "Sandy Brown";
        return color;
    }
    static seaGreen() {
        let color = Color.fromArgb(0x2e, 0x8b, 0x57);
        color.name = "Sea Green";
        return color;
    }
    static seaShell() {
        let color = Color.fromArgb(0xff, 0xf5, 0xee);
        color.name = "Sea Shell";
        return color;
    }
    static sienna() {
        let color = Color.fromArgb(0xa0, 0x52, 0x2d);
        color.name = "Sienna";
        return color;
    }
    static silver() {
        let color = Color.fromArgb(0xc0, 0xc0, 0xc0);
        color.name = "Silver";
        return color;
    }
    static skyBlue() {
        let color = Color.fromArgb(0x87, 0xce, 0xeb);
        color.name = "Sky Blue";
        return color;
    }
    static slateBlue() {
        let color = Color.fromArgb(0x6a, 0x5a, 0xcd);
        color.name = "Slate Blue";
        return color;
    }
    static slateGray() {
        let color = Color.fromArgb(0x70, 0x80, 0x90);
        color.name = "Slate Gray";
        return color;
    }
    static snow() {
        let color = Color.fromArgb(0xff, 0xfa, 0xfa);
        color.name = "Snow";
        return color;
    }
    static springGreen() {
        let color = Color.fromArgb(0x00, 0xff, 0x7f);
        color.name = "Spring Green";
        return color;
    }
    static steelBlue() {
        let color = Color.fromArgb(0x46, 0x82, 0xb4);
        color.name = "Steel Blue";
        return color;
    }
    static tan() {
        let color = Color.fromArgb(0xd2, 0xb4, 0x8c);
        color.name = "Tan";
        return color;
    }
    static teal() {
        let color = Color.fromArgb(0x00, 0x80, 0x80);
        color.name = "Teal";
        return color;
    }
    static thistle() {
        let color = Color.fromArgb(0xd8, 0xbf, 0xd8);
        color.name = "Thistle";
        return color;
    }
    static tomato() {
        let color = Color.fromArgb(0xff, 0x63, 0x47);
        color.name = "Tomato";
        return color;
    }
    static turquoise() {
        let color = Color.fromArgb(0x40, 0xe0, 0xd0);
        color.name = "Turquoise";
        return color;
    }
    static violet() {
        let color = Color.fromArgb(0xee, 0x82, 0xee);
        color.name = "Violet";
        return color;
    }
    static wheat() {
        let color = Color.fromArgb(0xf5, 0xde, 0xb3);
        color.name = "Wheat";
        return color;
    }
    static white() {
        let color = Color.fromArgb(0xff, 0xff, 0xff);
        color.name = "White";
        return color;
    }
    static whiteSmoke() {
        let color = Color.fromArgb(0xf5, 0xf5, 0xf5);
        color.name = "White Smoke";
        return color;
    }
    static yellow() {
        let color = Color.fromArgb(0xff, 0xff, 0x00);
        color.name = "Yellow";
        return color;
    }
    static yellowGreen() {
        let color = Color.fromArgb(0x9a, 0xcd, 0x32);
        color.name = "Yellow Green";
        return color;
    }
    static transparent() {
        let color = Color.fromArgb(0x00, 0xff, 0xff, 0xff);
        color.name = "Transparent";
        return color;
    }
    static empty() {
        let color = Color.fromArgb(0x00, 0xff, 0xff, 0xff);
        color.name = "Empty";
        return color;
    }
    static fromName(name) {
        name = name.replace(/ /gi, "");
        if (this.isNullOrEmpty(name)) {
            return null; // Color.empty;
        }
        name = name.charAt(0).toLowerCase() + name.substr(1);
        let color = Color[name];
        if (color && typeof color == "function") {
            return color();
        }
        return null; //Color.empty;
    }
    static isNullOrEmpty(value) {
        return value == null || value === "" || value === undefined;
    }
    clone() {
        let color = new Color();
        color.r = this.r;
        color.g = this.g;
        color.b = this.b;
        color.a = this._a;
        color.name = this.name;
        return color;
    }
    isChanged() {
        return this.savedColor == null || !this.savedColor.equals(this);
    }
    resetChanged() {
        this.savedColor = this.clone();
    }
    get a() {
        return this._a;
    }
    set a(value) {
        this._a = value;
        this.name = Color.customName;
    }
    get r() {
        return this._r;
    }
    set r(value) {
        this._r = value;
        this.name = Color.customName;
    }
    get g() {
        return this._g;
    }
    set g(value) {
        this._g = value;
        this.name = Color.customName;
    }
    get b() {
        return this._b;
    }
    set b(value) {
        this._b = value;
        this.name = Color.customName;
    }
    static { this.customName = "Custom"; }
    get isNamedColor() {
        return this.name != Color.customName;
    }
    equals(color) {
        if (color != null) {
            if ((color._a == 0x00 && color._r == 0xff && color._g == 0xff && color._b == 0xff) ||
                (this._a == 0x00 && this._r == 0xff && this._g == 0xff && this._b == 0xff))
                return this._a == color._a;
            else
                return this._a == color._a && this._r == color._r && this._g == color._g && this._b == color._b;
        }
        return false;
    }
    static fromArgb(alpha, red, green, blue) {
        if (typeof red == "undefined") {
            blue = alpha & 0xff;
            green = (alpha >> 8) & 0xff;
            red = (alpha >> 16) & 0xff;
            alpha = (alpha >> 24) & 0xff;
        }
        else if (typeof green == "undefined") {
            blue = red._b;
            green = red._g;
            red = red._r;
        }
        else if (typeof blue == "undefined") {
            blue = green;
            green = red;
            red = alpha;
            alpha = 255;
        }
        let color = new Color();
        color._a = alpha;
        color._r = red;
        color._g = green;
        color._b = blue;
        color.name = Color.customName;
        return color;
    }
    toArgb() {
        let argb = this._a << 24;
        argb += this._r << 16;
        argb += this._g << 8;
        argb += this._b;
        return argb;
    }
    componentToHex(c) {
        let hex = c.toString(16);
        return hex.length == 1 ? "0" + hex : hex;
    }
    getHashCode() {
        return this.toArgb();
    }
    toHtmlColor() {
        return `rgba(${this.r}, ${this.g}, ${this.b}, ${Math.round((100 * this.a) / 255) / 100})`;
    }
    toHexColor() {
        return "#" + this.componentToHex(this.r) + this.componentToHex(this.g) + this.componentToHex(this.b);
    }
    get hexColor() {
        return this.toHtmlColor();
    }
    getStringName() {
        if (this.a == 0) {
            return "Transparent";
        }
        else {
            return `${this.a != 255 ? this.a + "," : ""}${this.r + ","}${this.g + ","}${this.b}`;
        }
    }
    set hexColor(value) {
        let oldColor = this.changesInterceptor ? this.clone() : null;
        let num = parseInt(value.substring(1), 16);
        if (num || num == 0) {
            this.b = num & 0xff;
            this.g = (num >> 8) & 0xff;
            this.r = (num >> 16) & 0xff;
            this.a = 255;
        }
        else {
            let num = value.replace("rgba(", "").replace(")", "");
            let array = num.split(",");
            this.r = isNaN(Number(array[0])) ? 0 : Number(array[0]);
            this.g = isNaN(Number(array[1])) ? 0 : Number(array[1]);
            this.b = isNaN(Number(array[2])) ? 0 : Number(array[2]);
            this.a = isNaN(Math.round(255 * Number(array[3]))) ? 255 : Math.round(255 * Number(array[3]));
        }
        this.name = Color.customName;
        if (this.changesInterceptor) {
            this.changesInterceptor.propertyChanged(this.propertyName, this.clone(), oldColor);
        }
    }
    toString() {
        return this.name != Color.customName ? this.name : this.hexColor;
    }
    deserializeFromString(value) {
        let result;
        if (value.indexOf(",") != -1) {
            let strs = value.split(",");
            if (strs.length == 4) {
                result = Color.fromArgb(parseFloat(strs[0].trim()), parseFloat(strs[1].trim()), parseFloat(strs[2].trim()), parseFloat(strs[3].trim()));
            }
            else {
                result = Color.fromArgb(parseFloat(strs[0].trim()), parseFloat(strs[1].trim()), parseFloat(strs[2].trim()));
            }
        }
        else if (value.indexOf("[") == 0 && value.indexOf("]") == value.length - 1 && value.indexOf(":") != -1) {
            let strs = value.substring(1, value.length - 1).split(":");
            if (strs.length == 4) {
                result = Color.fromArgb(parseFloat(strs[0].trim()), parseFloat(strs[1].trim()), parseFloat(strs[2].trim()), parseFloat(strs[3].trim()));
            }
            else {
                result = Color.fromArgb(parseFloat(strs[0].trim()), parseFloat(strs[1].trim()), parseFloat(strs[2].trim()));
            }
        }
        else {
            result = Color.fromName(value);
        }
        this._r = result._r;
        this._b = result._b;
        this._g = result._g;
        this._a = result._a;
        this.name = result.name;
    }
}
//# sourceMappingURL=data:application/json;base64,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