import { Component, EventEmitter, Input, Output, ViewChild, } from "@angular/core";
import StiRectangleGeometryLayout from "./computed/StiRectangleGeometryLayout";
import { StiLocalizationService } from "./services/sti-localization.service";
import { StiModelService } from "./services/model.service";
import { StiMouseService } from "./services/mouse.service";
import { StiComponentResizerService } from "./services/sti-component-resizer.service";
import { StiEditableContentService } from "./services/sti-editable-content.service";
import { StiDraggableService } from "./services/sti-draggable.service";
import { StiHelperService } from "./services/sti-helper.service";
import { StiNameService } from "./services/sti-name.service";
import { StiToolbarResizerService } from "./services/sti-toolbar-resizer.service";
import { StiToolboxService } from "./services/sti-toolbox.service";
import { StiThemeService } from "./services/theme.service";
import { StiControllerService } from "./services/sti-controller.service";
import { StiHttpClientService } from "./services/http-client.service";
import { StiBarcodeService } from "./services/sti-barcode.service";
import { StiColumnDraggableService } from "./services/sti-column-draggable.service";
import { StiForm } from "./elements/StiForm";
import { StiRichTextService } from "./services/sti-rich-text.service";
import { StiChangesService } from "./services/sti-changes-service";
import { StiUndoService } from "./services/sti-undo-service";
import { StiExportService } from "./services/sti-export.service";
import { StiFontService } from "./services/sti-font.service";
import { StiUserService } from "./services/sti-user-service";
import { StiExpressionService } from "./services/sti-expression.service";
import { StiButtonElement } from "./elements/StiButtonElement";
import { FormEventsService } from "./services/sti-form-events-service";
import { SignatureService } from "./services/sti-signature.service";
import { StiColorDialogService } from "./services/sti-color-dialog.service";
import { StiStaticHelperService } from "./services/sti-static-helper.service";
import { StiTabIndexService } from "./services/sti-tabindex.service";
import { StiDropdownService } from "./components/sti-dropdown-component/sti-dropdown-service";
import { StiFormCheckerService } from "./services/sti-form-checker.service";
import { StiLocalStorageService } from "./services/sti-local-storage.service";
import { StiDraggableModalWindowService } from "./services/sti-draggable-modal-window.service";
import { StiTooltipService } from "./components/sti-tooltip/sti-tooltip.service";
import { StiClipboardService } from "./services/sti-clipboard-sevice";
import * as i0 from "@angular/core";
import * as i1 from "./services/sti-toolbar-resizer.service";
import * as i2 from "./services/model.service";
import * as i3 from "./services/theme.service";
import * as i4 from "./services/sti-controller.service";
import * as i5 from "./services/sti-barcode.service";
import * as i6 from "./services/sti-editable-content.service";
import * as i7 from "./services/sti-changes-service";
import * as i8 from "./services/sti-export.service";
import * as i9 from "./services/sti-font.service";
import * as i10 from "./services/sti-toolbox.service";
import * as i11 from "./services/sti-undo-service";
import * as i12 from "./services/sti-user-service";
import * as i13 from "./services/sti-expression.service";
import * as i14 from "./services/sti-helper.service";
import * as i15 from "./services/sti-localization.service";
import * as i16 from "./services/http-client.service";
import * as i17 from "./services/sti-signature.service";
import * as i18 from "./services/sti-tabindex.service";
import * as i19 from "./services/mouse.service";
import * as i20 from "./services/sti-form-events-service";
import * as i21 from "./components/sti-dropdown-component/sti-dropdown-service";
import * as i22 from "./services/sti-form-checker.service";
import * as i23 from "./services/sti-local-storage.service";
import * as i24 from "./components/sti-tooltip/sti-tooltip.service";
import * as i25 from "./services/sti-clipboard-sevice";
import * as i26 from "@angular/common";
import * as i27 from "./components/navbar.component/navbar.component";
import * as i28 from "./components/workspace.component/sti-workspace.component";
import * as i29 from "./components/properties.component/properties.component";
import * as i30 from "./toolbox/sti-draggable-element-container.component";
import * as i31 from "./toolbox/sti-toolbox.component";
import * as i32 from "./components/footer.component/footer.component";
import * as i33 from "./toolbox/sti-clone-element-container.component";
import * as i34 from "./components/modal-agree-window/modal-agree-window.component";
import * as i35 from "./components/sti-progress.component";
import * as i36 from "./toolbox/sti-draggable-column-container.component";
import * as i37 from "./components/sti-about-window/sti-about-window.component";
import * as i38 from "./components/propertyGrid/editors/sti-barcode-style-editor/sti-barcodes-styles-preview.component";
import * as i39 from "./components/workspace.component/sti-pdf-preview.component";
import * as i40 from "./components/navbar.component/navbar.group-preview.component";
import * as i41 from "./toolbox/sti-setup-toolbox.component";
import * as i42 from "./components/sti-localization-preview.component";
import * as i43 from "./components/sti-user-info.component";
import * as i44 from "./components/sti-trial-alerts/sti-trial-bar.component";
import * as i45 from "./components/sti-trial-alerts/sti-trial-modal-window.component";
import * as i46 from "./components/sti-file-menu/sti-file-menu.component";
import * as i47 from "./components/sti-file-menu/sti-file-menu-navigation.component";
import * as i48 from "./components/sti-file-menu/sti-file-save-dialog.component";
import * as i49 from "./components/sti-button/sti-button-message-window.component";
import * as i50 from "./components/navbar.component/sti-cloud-navbar.component";
import * as i51 from "./components/context-menu.component/context-menu-window.component";
import * as i52 from "./components/sti-expression-editor/sti-expression-help-window.component";
import * as i53 from "./components/sti-login.component";
import * as i54 from "./components/sti-expression-editor/sti-expression-editor.component";
import * as i55 from "./components/sti-color-dialog/sti-color-dialog.component";
import * as i56 from "./components/sti-color-dialog/sti-color-options-dialog.component";
import * as i57 from "./components/sti-expression-editor/sti-expression-draggable-container.component";
import * as i58 from "./components/sti-dropdown-component/sti-dropdown-list.component";
import * as i59 from "./components/sti-form-checker/sti-form-checker.component";
import * as i60 from "./components/sti-signature/sti-electronic-signature-editor.component";
import * as i61 from "./components/sti-draggable-modal-window/sti-draggable-modal-window.component";
import * as i62 from "./components/sti-tooltip/sti-tooltip.component";
import * as i63 from "./components/sti-trial-alerts/sti-trial-timer-window.component";
import * as i64 from "./components/sti-tiered-menu/sti-tiered-menu.component";
import * as i65 from "./components/properties.component/sti-forms-tree/sti-form-tree-warning-window.component";
export class StimulsoftFormsComponent {
    constructor(toolbarResizerService, model, theme, controller, barcodeService, render, editableContentService, changesService, exportService, font, toolboxService, undoService, userService, expressionService, helper, localizationService, httpService, signatureService, tabIndexService, mouseService, formEvents, dropdownService, formCheckerService, stiLocalStorage, tooltipService, clipboardService) {
        this.toolbarResizerService = toolbarResizerService;
        this.model = model;
        this.theme = theme;
        this.controller = controller;
        this.barcodeService = barcodeService;
        this.render = render;
        this.editableContentService = editableContentService;
        this.changesService = changesService;
        this.exportService = exportService;
        this.font = font;
        this.toolboxService = toolboxService;
        this.undoService = undoService;
        this.userService = userService;
        this.expressionService = expressionService;
        this.helper = helper;
        this.localizationService = localizationService;
        this.httpService = httpService;
        this.signatureService = signatureService;
        this.tabIndexService = tabIndexService;
        this.mouseService = mouseService;
        this.formEvents = formEvents;
        this.dropdownService = dropdownService;
        this.formCheckerService = formCheckerService;
        this.stiLocalStorage = stiLocalStorage;
        this.tooltipService = tooltipService;
        this.clipboardService = clipboardService;
        this.viewerMode = false;
        this.readonlyMode = false;
        this.form = new StiForm();
        this.interfaceEvent = new EventEmitter();
        this.init = false;
        this.distance = 0;
        this.isDoubleTouch = false;
        this.model.interfaceEvent.subscribe((e) => this.interfaceEvent.emit(e));
        this.model.component = this;
        barcodeService.init();
        changesService.start();
        expressionService.start();
    }
    get pointerEvents() {
        return this.model.showModalWindow ||
            this.model.showAboutWindow ||
            this.exportService.showModalWindow ||
            this.model.showTrialModalWindow ||
            this.model.showButtonMessageWindow ||
            this.model.showErrorWindow ||
            this.model.showHelpWindow ||
            this.model.showMoreColorDialog ||
            this.model.showProgress ||
            this.model.showExpressionEditor ||
            this.formCheckerService.showFormCheckerWindow ||
            this.model.showSignatureEditor ||
            this.model.showDraggableModalWindow ||
            this.model.showTrialTimerWindow ||
            this.model.showFormTreeWarningWindow
            ? "none"
            : "";
    }
    get cursor() {
        return this.model.cursor;
    }
    get toolbarWidth() {
        return this.toolbarResizerService.isMaximizeMode ? 200 : 45;
    }
    hasParentHeight() {
        let root = document.getElementsByClassName("sti-root-form");
        return root[0].parentElement.style.height ? true : false;
    }
    hasParentWidth() {
        let root = document.getElementsByClassName("sti-root-form");
        return root[0].parentElement.style.width ? true : false;
    }
    ngOnInit() {
        this.model.settings = this.settings;
        this.mouseService.getDocumentTouchStart().subscribe((event) => {
            this.startTouch(event);
        });
        this.mouseService.getDocumentTouchMove().subscribe((event) => {
            this.touchMove(event);
        });
        this.mouseService.getDocumentTouchEnd().subscribe((event) => {
            this.touchEnd(event);
        });
        this.toolboxService.unusedElements = JSON.parse(this.stiLocalStorage.getItem("StiToolboxSetup"));
        let showInsertTab = JSON.parse(this.stiLocalStorage.getItem("StiShowInsertTab"));
        let showToolbox = JSON.parse(this.stiLocalStorage.getItem("StiShowToolbox"));
        let buttonLinks = this.stiLocalStorage.getItem("StiButtonLinks");
        if (buttonLinks) {
            this.model.enteredUrls = buttonLinks.split(",");
        }
        this.model.showInsertTab = showInsertTab != null ? showInsertTab : true;
        this.toolboxService.showToolbox = showToolbox != null ? showToolbox : true;
        this.model.viewerMode = this.viewerMode;
        if (this.viewerMode) {
            this.model.ribbon = "Preview";
        }
        if (this.properties?.cloudPlanIdent?.length > 0 &&
            (this.properties.cloudPlanIdent == "Trial" ||
                this.properties.cloudPlanIdent == "Expiried" ||
                this.properties.cloudPlanIdent == "Developer" ||
                this.properties.cloudPlanIdent.indexOf("Base") > 0 ||
                this.properties.cloudPlanIdent.indexOf("Single") > 0 ||
                this.properties.cloudPlanIdent.indexOf("Team") > 0 ||
                this.properties.cloudPlanIdent.indexOf("Enterprise") > 0)) {
            if (this.properties?.cloudPlanIdent == "Trial" || this.properties?.cloudPlanIdent == "Expiried") {
                this.model.basePlanIsTrial = true;
                if (!this.viewerMode) {
                    this.model.showTrialBar = true;
                }
                else {
                    this.model.showTrialTitle = true;
                }
            }
            this.model.form.additionalFormFields;
            this.model.isCloudMode = true;
            if (this.model.enteredUrls.indexOf("cloud.stimulsoft.com") == -1) {
                this.model.enteredUrls.push("cloud.stimulsoft.com");
            }
        }
        if (this.viewerMode && this.readonlyMode) {
            this.setReadOnlyMode();
        }
        this.toolboxService.elements.forEach((element) => {
            if (this.toolboxService.unusedElements?.find((item) => item == element.id)) {
                element.enabled = false;
            }
        });
        this.theme.currentTheme = "Light";
        const zoomByWheel = (event) => {
            if (event.ctrlKey) {
                event.stopPropagation();
                event.preventDefault();
                if (event.deltaY < 0) {
                    if (this.model.zoom > 0.1 && this.model.zoom < 4.9) {
                        this.model.zoom += 0.1;
                    }
                }
                else {
                    if (this.model.zoom > 0.2 && this.model.zoom < 5) {
                        this.model.zoom -= 0.1;
                    }
                }
            }
            else {
                let workspace = document.getElementsByTagName("sti-workspace")[0];
                // workspace.scrollTop = 10;
                if (this.model.draggingElement) {
                    if (event.deltaY < 0) {
                        workspace.scrollTop -= 300;
                    }
                    else {
                        workspace.scrollTop += 300;
                    }
                }
            }
        };
        let this_ = this;
        window.oncontextmenu = function ($event) {
            if (this_.model.getPageFromPoint(event["clientX"], event["clientY"]) &&
                document.activeElement.tagName.toLocaleLowerCase() == "body") {
                event.preventDefault();
                this_.model.contextMenuX = event["clientX"];
                if (window.outerHeight - event["clientY"] <= 255) {
                    this_.model.contextMenuY = event["clientY"] - 150;
                }
                else {
                    this_.model.contextMenuY = event["clientY"];
                }
                this_.model.showContextMenu = true;
            }
        };
        window.onbeforeunload = function (event) {
            this_.model.currentFormState = this_.model.form.saveToReportJsonObject().serialize();
            if (this_.model?.currentFormState !== this_.model?.lastSavedFormState &&
                this_.undoService?.undos?.length > 1 &&
                !this_.model.viewerMode) {
                setTimeout(() => {
                    this_.model.showProgress = false;
                }, 3000);
                event.returnValue = "";
                return event.returnValue;
            }
        };
        const deletingComponents = (event) => {
            let selection = window.getSelection().toString();
            if (event.key === "Escape" && this.model.lastFormState != null) {
                let form = new StiForm();
                form.loadFormJsonString(this.model.lastFormState);
                this.model.form = form;
                this.model.draggingElement = null;
                this.model.lastFormState = null;
            }
            else if (event.key === "Delete" && this.model.canDelete()) {
                if (this.model.selectedComponent) {
                    this.helper.deleteSelectedComponent();
                }
                else if (this.model.selectedPage && this.model?.form?.pages?.length > 1) {
                    this.model.showModalWindow = true;
                }
            }
            else if (event.key === "PageDown" || event.key === "PageUp") {
                event.preventDefault();
            }
            else if (event.ctrlKey && event.code === "KeyC") {
                if (this.model.showExpressionEditor) {
                    return;
                }
                if (this.model.selectedComponent && document.activeElement.tagName.toLocaleLowerCase() == "body") {
                    this.clipboardService.copyElement();
                }
            }
            else if (event.ctrlKey && event.code === "KeyV") {
                if (this.model.showExpressionEditor) {
                    return;
                }
                if (this.clipboardService.hasCopy && document.activeElement.tagName.toLocaleLowerCase() == "body") {
                    let mouseEvent = new MouseEvent("mousemove");
                    this.clipboardService.pasteElement(mouseEvent);
                }
            }
            else if (event.ctrlKey && event.code === "KeyZ") {
                if (this.model.showExpressionEditor) {
                    return;
                }
                event.preventDefault();
                if (this.undoService.undos.length >= 2) {
                    this.undoService.undo();
                }
            }
            else if (event.ctrlKey && event.code === "KeyX") {
                if (this.model.showExpressionEditor) {
                    return;
                }
                if (this.model.selectedComponent && document.activeElement.tagName.toLocaleLowerCase() == "body") {
                    this.clipboardService.cutElement();
                }
            }
        };
        const disableDeleting = (event) => {
            let isWorkspace = false;
            let isBarcodePreview = false;
            let elements = document.elementsFromPoint(event.clientX, event.clientY);
            elements.forEach((element) => {
                if (element?.classList.contains("sti-page") || element?.classList.contains("sti-component")) {
                    isWorkspace = true;
                }
                if (element?.classList.contains("container")) {
                    isBarcodePreview = true;
                }
            });
            if (!isBarcodePreview) {
                this.barcodeService.showBarcodePreview = false;
            }
        };
        document.querySelector(".sti-root-form")?.addEventListener("wheel", zoomByWheel);
        document.addEventListener("keydown", deletingComponents);
        document.addEventListener("mousedown", disableDeleting);
    }
    needToScroll() {
        let workspace = document.getElementsByTagName("sti-workspace")[0];
        let pageElem = document.querySelectorAll(".sti-page")[0];
        let rect = this.model.getPositionRelativeToForm(pageElem);
        return workspace?.clientWidth < rect?.width;
    }
    ngOnChanges(changes) {
        if (Object.keys(changes).length == 1) {
            if (changes["form"]) {
                this.model.form = changes["form"].currentValue;
                this.model.fileName = this.formName;
                if (this.viewerMode) {
                    this.model.form.updateToViewerMode();
                }
            }
            else if (changes["localization"]) {
                this.localizationService.loadLocalization(this.localization);
            }
        }
        else {
            this.initialize();
        }
    }
    startTouch(event) {
        if (this.isMobileViewer) {
            if (event.touches.length === 2) {
                this.startZoomValue = this.model.zoom;
                this.distance = Math.hypot(event.touches[0].pageX - event.touches[1].pageX, event.touches[0].pageY - event.touches[1].pageY);
                this.isDoubleTouch = true;
            }
        }
    }
    get isMobileViewer() {
        return this.model.viewerMode && this.model.isMobile();
    }
    touchMove(event) {
        if (this.isMobileViewer && this.isDoubleTouch) {
            event.preventDefault();
            let dist2 = Math.hypot(event.touches[0].pageX - event.touches[1].pageX, event.touches[0].pageY - event.touches[1].pageY);
            let delta = Math.abs(dist2 - this.distance);
            if (this.distance < dist2) {
                this.model.zoom = this.startZoomValue + Number((delta / 200).toFixed(2));
            }
            else if (this.distance > dist2) {
                this.model.zoom = this.startZoomValue - Number((delta / 200).toFixed(2));
            }
            if (this.model.zoom < this.minimalZoomValue()) {
                this.model.zoom = this.minimalZoomValue();
                let workspace = document.getElementsByTagName("sti-workspace")[0];
                let pageElem = document.querySelectorAll(".page-container")[0];
                setTimeout(() => {
                    let rect = this.model.getPositionRelativeToForm(pageElem);
                    if (workspace.scrollLeft != workspace.scrollWidth - rect.width - 6) {
                        workspace.scrollLeft = workspace.scrollWidth - rect.width - 6;
                    }
                });
            }
        }
    }
    touchEnd(event) {
        if (this.isMobileViewer && this.isDoubleTouch) {
            if (event.targetTouches.length < 2) {
                this.isDoubleTouch = false;
            }
        }
    }
    minimalZoomValue() {
        let workspace = document.getElementsByTagName("sti-workspace")[0];
        let width = workspace["offsetWidth"];
        let pagetWithMaxWidth = this.model.form.pages.reduce((acc, curr) => (acc.width > curr.width ? acc : curr));
        return width / (pagetWithMaxWidth.width + 30);
    }
    setReadOnlyMode() {
        this.model?.form?.pages.forEach((page) => {
            page.allElements.forEach((element) => {
                if (element["readOnly"]) {
                    element["readOnly"] = true;
                }
                else {
                    if (!(element instanceof StiButtonElement)) {
                        element.readOnly = false;
                    }
                }
            });
        });
    }
    ngAfterViewInit() {
        this.init = true;
        setTimeout(() => {
            this.initialize();
            this.rootFormElementRef.nativeElement.component = this;
            this.model.rootFormElement = this.rootFormElementRef.nativeElement;
            this.model.addTotalMenu = this.addTotalMenu;
        }, 0);
    }
    containerHeight() {
        let showfooter = this.model.getBooleanSetting("showFooter");
        let isModeWithPreview = this.model.previewMode || this.model.pdfPreviewMode || this.viewerMode;
        if (isModeWithPreview) {
            if (this.viewerMode) {
                return "calc(100% - 32px)";
            }
            else {
                return this.model.pdfPreviewMode || !showfooter ? "calc(100% - 38px)" : "calc(100% - 70px)";
            }
        }
        else {
            if (showfooter) {
                return this.model.showTrialBar ? "calc(100% - 155px)" : "calc(100% - 125px)";
            }
            else {
                return this.model.showTrialBar ? "calc(100% - 123px)" : "calc(100% - 93px)";
            }
        }
    }
    initialize() {
        if (this.init) {
            this.model.requestUrl = this.requestUrl;
            this.model.properties = this.properties;
            this.model.fileName = this.formName;
            if (this.form) {
                this.model.form = this.form;
            }
            if (this.localization) {
                this.localizationService.loadLocalization(this.localization);
            }
            this.controller.initialize();
        }
    }
    cloudLogin(event) {
        delete this.model.properties.cloudLoginInfo;
        delete this.model.login;
        this.model.properties["cloudLogin"] = event.login;
        this.model.properties["cloudPassword"] = event.password;
        this.controller.initialize();
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StimulsoftFormsComponent, deps: [{ token: i1.StiToolbarResizerService }, { token: i2.StiModelService }, { token: i3.StiThemeService }, { token: i4.StiControllerService }, { token: i5.StiBarcodeService }, { token: StiRectangleGeometryLayout }, { token: i6.StiEditableContentService }, { token: i7.StiChangesService }, { token: i8.StiExportService }, { token: i9.StiFontService }, { token: i10.StiToolboxService }, { token: i11.StiUndoService }, { token: i12.StiUserService }, { token: i13.StiExpressionService }, { token: i14.StiHelperService }, { token: i15.StiLocalizationService }, { token: i16.StiHttpClientService }, { token: i17.SignatureService }, { token: i18.StiTabIndexService }, { token: i19.StiMouseService }, { token: i20.FormEventsService }, { token: i21.StiDropdownService }, { token: i22.StiFormCheckerService }, { token: i23.StiLocalStorageService }, { token: i24.StiTooltipService }, { token: i25.StiClipboardService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StimulsoftFormsComponent, selector: "stimulsoft-forms", inputs: { requestUrl: "requestUrl", style: "style", viewerMode: "viewerMode", readonlyMode: "readonlyMode", form: "form", localization: "localization", formName: "formName", settings: "settings", properties: "properties" }, outputs: { interfaceEvent: "interfaceEvent" }, providers: [
            StiModelService,
            StiToolboxService,
            StiMouseService,
            StiComponentResizerService,
            StiDraggableService,
            StiHelperService,
            StiLocalizationService,
            StiToolbarResizerService,
            StiNameService,
            StiRectangleGeometryLayout,
            StiThemeService,
            StiEditableContentService,
            StiControllerService,
            StiHttpClientService,
            StiBarcodeService,
            StiColumnDraggableService,
            StiRichTextService,
            StiChangesService,
            StiUndoService,
            StiExportService,
            StiFontService,
            StiUserService,
            StiExpressionService,
            FormEventsService,
            SignatureService,
            StiColorDialogService,
            StiStaticHelperService,
            StiTabIndexService,
            StiDropdownService,
            StiFormCheckerService,
            StiLocalStorageService,
            StiDraggableModalWindowService,
            StiTooltipService,
            StiClipboardService
        ], viewQueries: [{ propertyName: "addTotalMenu", first: true, predicate: ["addTotalMenu"], descendants: true }, { propertyName: "rootFormElementRef", first: true, predicate: ["rootForm"], descendants: true }], usesOnChanges: true, ngImport: i0, template: `
    <div
      class="sti-root-form"
      [style.position]="'relative'"
      [style]="style"
      [style.cursor]="cursor"
      [style.width]="hasParentWidth() ? 'inherit' : '100%'"
      [style.height]="hasParentHeight() ? 'inherit' : '100%'"
      #rootForm
    >
      <sti-navbar [style.pointer-events]="pointerEvents" [style.opacity]="model.isInitialized ? 1 : 0"></sti-navbar>
      <sti-cloud-navbar
        [style.opacity]="model.isInitialized ? 1 : 0"
        *ngIf="model.isCloudMode && model.viewerMode && model.basePlanIsTrial"
      ></sti-cloud-navbar>
      <sti-trial-bar
        [style.opacity]="model.isInitialized ? 1 : 0"
        *ngIf="!viewerMode && !model.previewMode && !model.pdfPreviewMode && model.showTrialBar"
      ></sti-trial-bar>
      <div
        class="flex-container"
        [style.opacity]="model.isInitialized ? 1 : 0"
        [style.height]="containerHeight()"
        [style.pointer-events]="pointerEvents"
      >
        <!-- elements -->

        <sti-toolbox
          *ngIf="
            !viewerMode &&
            !model.previewMode &&
            !model.pdfPreviewMode &&
            toolboxService.showToolbox &&
            model.getBooleanSetting('showToolbox')
          "
          class="elements"
          [style.min-width.px]="toolbarWidth"
        ></sti-toolbox>

        <!-- workspace -->
        <sti-pdf-preview *ngIf="model.pdfPreviewMode" style="width:100%;height:100%"></sti-pdf-preview>
        <sti-workspace
          *ngIf="!model.pdfPreviewMode"
          class="workspace"
          [style.overflow-x]="model.viewerMode && model.isMobile() && !needToScroll() ? 'hidden' : 'auto'"
        ></sti-workspace>
        <!-- properties -->
        <app-properties
          class="properties"
          [style.min-width.px]="
            viewerMode || model.previewMode || model.pdfPreviewMode || !model.getBooleanSetting('showProperties')
              ? '0'
              : model.propertyGridWidth
          "
          [style.max-width.px]="
            viewerMode || model.previewMode || model.pdfPreviewMode || !model.getBooleanSetting('showProperties')
              ? '0'
              : model.propertyGridWidth
          "
          [style.visibility]="
            viewerMode || model.previewMode || model.pdfPreviewMode || !model.getBooleanSetting('showProperties')
              ? 'hidden'
              : ''
          "
        ></app-properties>
        <sti-draggable-element-container></sti-draggable-element-container>
        <sti-clone-element-container></sti-clone-element-container>
        <sti-draggable-column-container></sti-draggable-column-container>
        <sti-barcode-styles-preview></sti-barcode-styles-preview>
        <sti-navbar-group-preview-component></sti-navbar-group-preview-component>
        <sti-user-info></sti-user-info>
        <sti-localization-preview></sti-localization-preview>
      </div>
      <sti-electronic-signature-editor *ngIf="model.showSignatureEditor"></sti-electronic-signature-editor>
      <sti-footer
        [style.opacity]="model.isInitialized ? 1 : 0"
        *ngIf="!model.pdfPreviewMode && model.getBooleanSetting('showFooter')"
        [style.pointer-events]="pointerEvents"
      ></sti-footer>
      <sti-file-menu *ngIf="model.fileMenuMode && model.isInitialized"></sti-file-menu>
      <sti-file-menu-navigation [style.visibility]="model.isInitialized ? '' : 'hidden'"></sti-file-menu-navigation>
      <sti-about-window-component *ngIf="model.showAboutWindow"></sti-about-window-component>
      <sti-progress [display]="model.showProgress"></sti-progress>
      <expression-draggable-container></expression-draggable-container>
      <sti-color-options-dialog *ngIf="model.showMoreColorDialog"></sti-color-options-dialog>
      <sti-color-dialog *ngIf="model.showColorDialog"></sti-color-dialog>
      <sti-expression-editor *ngIf="model.showExpressionEditor"></sti-expression-editor>
      <sti-trial-modal-window *ngIf="model.showTrialModalWindow"></sti-trial-modal-window>
      <sti-file-save-dialog *ngIf="model.showSaveDialog || model.showSaveDialogFromCloud"></sti-file-save-dialog>
      <sti-setup-toolbox-component *ngIf="model.showToolboxSetup"></sti-setup-toolbox-component>
      <button-message-window *ngIf="model.showButtonMessageWindow || model.showErrorWindow"></button-message-window>
      <sti-modal-agree-window *ngIf="model.showModalWindow || exportService.showModalWindow"></sti-modal-agree-window>
      <expression-help-window *ngIf="model.showHelpWindow"></expression-help-window>
      <sti-context-menu-window
        *ngIf="model.showContextMenu && !viewerMode && !model.previewMode"
      ></sti-context-menu-window>
      <sti-login *ngIf="model.login != null" [loginInfo]="model.login" (onLogin)="cloudLogin($event)"></sti-login>
      <sti-dropdown-list-component *ngIf="dropdownService.showDropdownList"></sti-dropdown-list-component>
      <sti-form-checker *ngIf="formCheckerService.showFormCheckerWindow"></sti-form-checker>
      <sti-draggable-modal-window *ngIf="model.showDraggableModalWindow"></sti-draggable-modal-window>
      <sti-tooltip *ngIf="tooltipService.showTooltip"></sti-tooltip>
      <sti-trial-timer-window *ngIf="model.showTrialTimerWindow"></sti-trial-timer-window>
      <sti-tiered-menu *ngIf="model.showTieredMenu" [menu]="helper.getAddTotalMenuItems()"></sti-tiered-menu>
      <form-tree-warning-window *ngIf="model.showFormTreeWarningWindow"></form-tree-warning-window>
    </div>
  `, isInline: true, styles: ["sti-file-menu{height:inherit;width:inherit}sti-file-menu-navigation{height:inherit}.flex-container{display:flex;justify-content:center;background:var(--back-color);height:calc(100% - 117px);width:100%;font-family:Segoe UI}.workspace{background-color:var(--workspace-color);display:block;justify-content:center;font-size:2.5rem;color:#000;overflow-y:auto;scroll-behavior:smooth;height:100%;flex-grow:1}*{scrollbar-width:thin;scrollbar-color:var(--thumb-color),var(--back-color)}*::-webkit-scrollbar{-webkit-appearance:none;background-color:var(--back-color);height:10px;width:10px;outline:none}*::-webkit-scrollbar-button{-webkit-appearance:none;height:3px;width:3px}*::-webkit-scrollbar-thumb{-webkit-appearance:none;background-color:var(--thumb-color);height:10px;min-width:25px;max-width:80%;border-radius:4px;border:2px solid var(--back-color)}*::-webkit-scrollbar-thumb:hover{background-color:var(--trackHover-color);height:10px}*::-webkit-scrollbar-track{-webkit-appearance:none;background-color:var(--back-color);border:1px solid var(--back-color)}*::-webkit-scrollbar-corner{background-color:var(--back-color)}.elements{background-color:var(--back-color);font-size:2.5rem;color:#000;visibility:visible;overflow-y:auto;scroll-behavior:smooth;border-right:1px solid var(--formBorder-color);padding:7px;transition:min-width .2s}.properties{background-color:var(--back-color);font-size:2.5rem;color:#000;scroll-behavior:smooth;display:flex;min-width:360px;max-width:360px;border-left:1px solid var(--formBorder-color);font-size:18px}.hovered{background-color:#d1d8e2}.sti-root-form{height:inherit;width:inherit}\n"], dependencies: [{ kind: "directive", type: i26.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i27.NavbarComponent, selector: "sti-navbar" }, { kind: "component", type: i28.WorkspaceComponent, selector: "sti-workspace" }, { kind: "component", type: i29.PropertiesComponent, selector: "app-properties" }, { kind: "component", type: i30.StiDraggableElementContainerComponent, selector: "sti-draggable-element-container" }, { kind: "component", type: i31.StiToolboxComponent, selector: "sti-toolbox" }, { kind: "component", type: i32.StiFooterComponent, selector: "sti-footer" }, { kind: "component", type: i33.StiCloneElementContainerComponent, selector: "sti-clone-element-container" }, { kind: "component", type: i34.StiModalAgreeWindowComponent, selector: "sti-modal-agree-window" }, { kind: "component", type: i35.StiProgressComponent, selector: "sti-progress", inputs: ["display"] }, { kind: "component", type: i36.StiDraggableColumnContainerComponent, selector: "sti-draggable-column-container" }, { kind: "component", type: i37.StiAboutWindowComponent, selector: "sti-about-window-component" }, { kind: "component", type: i38.StiBarcodeStylesPreviewComponent, selector: "sti-barcode-styles-preview" }, { kind: "component", type: i39.StiPdfPreviewComponent, selector: "sti-pdf-preview" }, { kind: "component", type: i40.NavbarGroupPreviewComponent, selector: "sti-navbar-group-preview-component" }, { kind: "component", type: i41.StiSetupToolboxComponent, selector: "sti-setup-toolbox-component" }, { kind: "component", type: i42.StiLocalizationPreviewComponent, selector: "sti-localization-preview" }, { kind: "component", type: i43.StiUserInfoComponent, selector: "sti-user-info" }, { kind: "component", type: i44.StiTrialBarComponent, selector: "sti-trial-bar" }, { kind: "component", type: i45.StiTrialModalWindowComponent, selector: "sti-trial-modal-window" }, { kind: "component", type: i46.StiFileMenuComponent, selector: "sti-file-menu" }, { kind: "component", type: i47.StiFileMenuNavigationComponent, selector: "sti-file-menu-navigation" }, { kind: "component", type: i48.StiFileSaveDialogComponent, selector: "sti-file-save-dialog" }, { kind: "component", type: i49.StiButtonMessageWindowComponent, selector: "button-message-window" }, { kind: "component", type: i50.StiCloudNavbarComponent, selector: "sti-cloud-navbar" }, { kind: "component", type: i51.ContextMenuWindowComponent, selector: "sti-context-menu-window" }, { kind: "component", type: i52.StiExpressionHelpWindowComponent, selector: "expression-help-window" }, { kind: "component", type: i53.StiLoginComponent, selector: "sti-login", inputs: ["loginInfo"], outputs: ["onLogin"] }, { kind: "component", type: i54.StiExpressionEditorComponent, selector: "sti-expression-editor" }, { kind: "component", type: i55.StiColorDialogComponent, selector: "sti-color-dialog" }, { kind: "component", type: i56.StiColorOptionsDialogComponent, selector: "sti-color-options-dialog" }, { kind: "component", type: i57.StiExpressionDraggableContainerComponent, selector: "expression-draggable-container" }, { kind: "component", type: i58.StiDropdownListComponent, selector: "sti-dropdown-list-component" }, { kind: "component", type: i59.StiFormCheckerComponent, selector: "sti-form-checker" }, { kind: "component", type: i60.StiElectronicSignatureEditorComponent, selector: "sti-electronic-signature-editor" }, { kind: "component", type: i61.StiDraggableModalWindowComponent, selector: "sti-draggable-modal-window" }, { kind: "component", type: i62.StiTooltipComponent, selector: "sti-tooltip" }, { kind: "component", type: i63.StiTrialTimerWindowComponent, selector: "sti-trial-timer-window" }, { kind: "component", type: i64.StiTieredMenuComponent, selector: "sti-tiered-menu", inputs: ["menu", "parentElement", "baseZIndex"] }, { kind: "component", type: i65.StiFormTreeWarningWindowComponent, selector: "form-tree-warning-window" }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StimulsoftFormsComponent, decorators: [{
            type: Component,
            args: [{ selector: "stimulsoft-forms", template: `
    <div
      class="sti-root-form"
      [style.position]="'relative'"
      [style]="style"
      [style.cursor]="cursor"
      [style.width]="hasParentWidth() ? 'inherit' : '100%'"
      [style.height]="hasParentHeight() ? 'inherit' : '100%'"
      #rootForm
    >
      <sti-navbar [style.pointer-events]="pointerEvents" [style.opacity]="model.isInitialized ? 1 : 0"></sti-navbar>
      <sti-cloud-navbar
        [style.opacity]="model.isInitialized ? 1 : 0"
        *ngIf="model.isCloudMode && model.viewerMode && model.basePlanIsTrial"
      ></sti-cloud-navbar>
      <sti-trial-bar
        [style.opacity]="model.isInitialized ? 1 : 0"
        *ngIf="!viewerMode && !model.previewMode && !model.pdfPreviewMode && model.showTrialBar"
      ></sti-trial-bar>
      <div
        class="flex-container"
        [style.opacity]="model.isInitialized ? 1 : 0"
        [style.height]="containerHeight()"
        [style.pointer-events]="pointerEvents"
      >
        <!-- elements -->

        <sti-toolbox
          *ngIf="
            !viewerMode &&
            !model.previewMode &&
            !model.pdfPreviewMode &&
            toolboxService.showToolbox &&
            model.getBooleanSetting('showToolbox')
          "
          class="elements"
          [style.min-width.px]="toolbarWidth"
        ></sti-toolbox>

        <!-- workspace -->
        <sti-pdf-preview *ngIf="model.pdfPreviewMode" style="width:100%;height:100%"></sti-pdf-preview>
        <sti-workspace
          *ngIf="!model.pdfPreviewMode"
          class="workspace"
          [style.overflow-x]="model.viewerMode && model.isMobile() && !needToScroll() ? 'hidden' : 'auto'"
        ></sti-workspace>
        <!-- properties -->
        <app-properties
          class="properties"
          [style.min-width.px]="
            viewerMode || model.previewMode || model.pdfPreviewMode || !model.getBooleanSetting('showProperties')
              ? '0'
              : model.propertyGridWidth
          "
          [style.max-width.px]="
            viewerMode || model.previewMode || model.pdfPreviewMode || !model.getBooleanSetting('showProperties')
              ? '0'
              : model.propertyGridWidth
          "
          [style.visibility]="
            viewerMode || model.previewMode || model.pdfPreviewMode || !model.getBooleanSetting('showProperties')
              ? 'hidden'
              : ''
          "
        ></app-properties>
        <sti-draggable-element-container></sti-draggable-element-container>
        <sti-clone-element-container></sti-clone-element-container>
        <sti-draggable-column-container></sti-draggable-column-container>
        <sti-barcode-styles-preview></sti-barcode-styles-preview>
        <sti-navbar-group-preview-component></sti-navbar-group-preview-component>
        <sti-user-info></sti-user-info>
        <sti-localization-preview></sti-localization-preview>
      </div>
      <sti-electronic-signature-editor *ngIf="model.showSignatureEditor"></sti-electronic-signature-editor>
      <sti-footer
        [style.opacity]="model.isInitialized ? 1 : 0"
        *ngIf="!model.pdfPreviewMode && model.getBooleanSetting('showFooter')"
        [style.pointer-events]="pointerEvents"
      ></sti-footer>
      <sti-file-menu *ngIf="model.fileMenuMode && model.isInitialized"></sti-file-menu>
      <sti-file-menu-navigation [style.visibility]="model.isInitialized ? '' : 'hidden'"></sti-file-menu-navigation>
      <sti-about-window-component *ngIf="model.showAboutWindow"></sti-about-window-component>
      <sti-progress [display]="model.showProgress"></sti-progress>
      <expression-draggable-container></expression-draggable-container>
      <sti-color-options-dialog *ngIf="model.showMoreColorDialog"></sti-color-options-dialog>
      <sti-color-dialog *ngIf="model.showColorDialog"></sti-color-dialog>
      <sti-expression-editor *ngIf="model.showExpressionEditor"></sti-expression-editor>
      <sti-trial-modal-window *ngIf="model.showTrialModalWindow"></sti-trial-modal-window>
      <sti-file-save-dialog *ngIf="model.showSaveDialog || model.showSaveDialogFromCloud"></sti-file-save-dialog>
      <sti-setup-toolbox-component *ngIf="model.showToolboxSetup"></sti-setup-toolbox-component>
      <button-message-window *ngIf="model.showButtonMessageWindow || model.showErrorWindow"></button-message-window>
      <sti-modal-agree-window *ngIf="model.showModalWindow || exportService.showModalWindow"></sti-modal-agree-window>
      <expression-help-window *ngIf="model.showHelpWindow"></expression-help-window>
      <sti-context-menu-window
        *ngIf="model.showContextMenu && !viewerMode && !model.previewMode"
      ></sti-context-menu-window>
      <sti-login *ngIf="model.login != null" [loginInfo]="model.login" (onLogin)="cloudLogin($event)"></sti-login>
      <sti-dropdown-list-component *ngIf="dropdownService.showDropdownList"></sti-dropdown-list-component>
      <sti-form-checker *ngIf="formCheckerService.showFormCheckerWindow"></sti-form-checker>
      <sti-draggable-modal-window *ngIf="model.showDraggableModalWindow"></sti-draggable-modal-window>
      <sti-tooltip *ngIf="tooltipService.showTooltip"></sti-tooltip>
      <sti-trial-timer-window *ngIf="model.showTrialTimerWindow"></sti-trial-timer-window>
      <sti-tiered-menu *ngIf="model.showTieredMenu" [menu]="helper.getAddTotalMenuItems()"></sti-tiered-menu>
      <form-tree-warning-window *ngIf="model.showFormTreeWarningWindow"></form-tree-warning-window>
    </div>
  `, providers: [
                        StiModelService,
                        StiToolboxService,
                        StiMouseService,
                        StiComponentResizerService,
                        StiDraggableService,
                        StiHelperService,
                        StiLocalizationService,
                        StiToolbarResizerService,
                        StiNameService,
                        StiRectangleGeometryLayout,
                        StiThemeService,
                        StiEditableContentService,
                        StiControllerService,
                        StiHttpClientService,
                        StiBarcodeService,
                        StiColumnDraggableService,
                        StiRichTextService,
                        StiChangesService,
                        StiUndoService,
                        StiExportService,
                        StiFontService,
                        StiUserService,
                        StiExpressionService,
                        FormEventsService,
                        SignatureService,
                        StiColorDialogService,
                        StiStaticHelperService,
                        StiTabIndexService,
                        StiDropdownService,
                        StiFormCheckerService,
                        StiLocalStorageService,
                        StiDraggableModalWindowService,
                        StiTooltipService,
                        StiClipboardService
                    ], styles: ["sti-file-menu{height:inherit;width:inherit}sti-file-menu-navigation{height:inherit}.flex-container{display:flex;justify-content:center;background:var(--back-color);height:calc(100% - 117px);width:100%;font-family:Segoe UI}.workspace{background-color:var(--workspace-color);display:block;justify-content:center;font-size:2.5rem;color:#000;overflow-y:auto;scroll-behavior:smooth;height:100%;flex-grow:1}*{scrollbar-width:thin;scrollbar-color:var(--thumb-color),var(--back-color)}*::-webkit-scrollbar{-webkit-appearance:none;background-color:var(--back-color);height:10px;width:10px;outline:none}*::-webkit-scrollbar-button{-webkit-appearance:none;height:3px;width:3px}*::-webkit-scrollbar-thumb{-webkit-appearance:none;background-color:var(--thumb-color);height:10px;min-width:25px;max-width:80%;border-radius:4px;border:2px solid var(--back-color)}*::-webkit-scrollbar-thumb:hover{background-color:var(--trackHover-color);height:10px}*::-webkit-scrollbar-track{-webkit-appearance:none;background-color:var(--back-color);border:1px solid var(--back-color)}*::-webkit-scrollbar-corner{background-color:var(--back-color)}.elements{background-color:var(--back-color);font-size:2.5rem;color:#000;visibility:visible;overflow-y:auto;scroll-behavior:smooth;border-right:1px solid var(--formBorder-color);padding:7px;transition:min-width .2s}.properties{background-color:var(--back-color);font-size:2.5rem;color:#000;scroll-behavior:smooth;display:flex;min-width:360px;max-width:360px;border-left:1px solid var(--formBorder-color);font-size:18px}.hovered{background-color:#d1d8e2}.sti-root-form{height:inherit;width:inherit}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiToolbarResizerService }, { type: i2.StiModelService }, { type: i3.StiThemeService }, { type: i4.StiControllerService }, { type: i5.StiBarcodeService }, { type: StiRectangleGeometryLayout }, { type: i6.StiEditableContentService }, { type: i7.StiChangesService }, { type: i8.StiExportService }, { type: i9.StiFontService }, { type: i10.StiToolboxService }, { type: i11.StiUndoService }, { type: i12.StiUserService }, { type: i13.StiExpressionService }, { type: i14.StiHelperService }, { type: i15.StiLocalizationService }, { type: i16.StiHttpClientService }, { type: i17.SignatureService }, { type: i18.StiTabIndexService }, { type: i19.StiMouseService }, { type: i20.FormEventsService }, { type: i21.StiDropdownService }, { type: i22.StiFormCheckerService }, { type: i23.StiLocalStorageService }, { type: i24.StiTooltipService }, { type: i25.StiClipboardService }], propDecorators: { addTotalMenu: [{
                type: ViewChild,
                args: ["addTotalMenu"]
            }], requestUrl: [{
                type: Input
            }], style: [{
                type: Input
            }], viewerMode: [{
                type: Input
            }], readonlyMode: [{
                type: Input
            }], form: [{
                type: Input
            }], localization: [{
                type: Input
            }], formName: [{
                type: Input
            }], settings: [{
                type: Input
            }], interfaceEvent: [{
                type: Output
            }], properties: [{
                type: Input
            }], rootFormElementRef: [{
                type: ViewChild,
                args: ["rootForm"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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