import { Injectable } from "@angular/core";
import * as _ from "lodash";
import * as i0 from "@angular/core";
export class StiStaticHelperService {
    static { this.browserLanguage = navigator["defaultLocalization"] || navigator.language || navigator["browserLanguage"]; }
    static dateToJsonDate(date) {
        let offset = date.getTimezoneOffset() * -1;
        let hoursOffset = Math.abs(Math.floor(offset / 60)).toString();
        let minutesOffset = Math.abs(offset % 60).toString();
        if (hoursOffset.length == 1)
            hoursOffset = "0" + hoursOffset;
        if (minutesOffset.length == 1)
            minutesOffset = "0" + minutesOffset;
        return ("/Date(" + Date.parse(date.toString()).toString() + (offset >= 0 ? "+" : "-") + hoursOffset + minutesOffset + ")/");
    }
    static jsonDateFormatToDate(dateJSONFormat, format) {
        if (dateJSONFormat.substring(0, 6) == "/Date(") {
            var dateStr = dateJSONFormat.replace("/Date(", "").replace(")/", "");
            return typeof format == "boolean"
                ? this.formatDate2(new Date(parseInt(dateStr)), "m/d/yy h:MM tt")
                : format
                    ? this.formatDate2(new Date(parseInt(dateStr)), format)
                    : new Date(parseInt(dateStr));
        }
        else {
            return dateJSONFormat;
        }
    }
    static formatDate2(formatDate, formatString) {
        let yyyy = formatDate.getFullYear();
        let yy = yyyy.toString().substring(2);
        let m = formatDate.getMonth() + 1;
        let mm = m < 10 ? "0" + m : m;
        let d = formatDate.getDate();
        let dd = d < 10 ? "0" + d : d;
        let h = formatDate.getHours();
        let hh = h < 10 ? "0" + h : h;
        let n = formatDate.getMinutes();
        let nn = n < 10 ? "0" + n : n;
        let s = formatDate.getSeconds();
        let ss = s < 10 ? "0" + s : s;
        formatString = formatString.replace(/yyyy/i, yyyy);
        formatString = formatString.replace(/yy/i, yy);
        formatString = formatString.replace(/mm/i, mm);
        formatString = formatString.replace(/m/i, m);
        formatString = formatString.replace(/dd/i, dd);
        formatString = formatString.replace(/d/i, d);
        formatString = formatString.replace(/hh/i, hh);
        formatString = formatString.replace(/h/i, h);
        formatString = formatString.replace(/nn/i, nn);
        formatString = formatString.replace(/n/i, n);
        formatString = formatString.replace(/ss/i, ss);
        formatString = formatString.replace(/s/i, s);
        return formatString;
    }
    static { this.formats = [
        { format: "mmmm", option: "month", options: { month: "long" } },
        { format: "mmm", option: "month", options: { month: "short" } },
        { format: "mm", option: "month", options: { month: "2-digit" }, digits: 2 },
        { format: "m", option: "month", options: { month: "numeric" } },
        { format: "dd", option: "day", options: { day: "2-digit" }, digits: 2 },
        { format: "d", option: "day", options: { day: "numeric" } },
        { format: "yyyy", option: "year", options: { year: "numeric" } },
        { format: "yy", option: "year", options: { year: "2-digit" }, digits: 2 },
        { format: "HH", option: "hour", options: { hour: "2-digit", hour12: false }, digits: 2 },
        { format: "h", option: "hour", options: { hour: "numeric", hour12: true } },
        { format: "MM", option: "minute", options: { minute: "2-digit", hourCycle: "h24" }, digits: 2 },
        { format: "ss", option: "second", options: { second: "2-digit", hour12: false }, digits: 2 },
        { format: "tt", option: "dayPeriod", options: { dayPeriod: "narrow", hourCycle: "h12", hour12: true } }
    ]; }
    static formatDate(date, format, locale) {
        var result = [];
        locale = locale?.length > 0 ? locale : (this.browserLanguage ?? "en-us");
        var parseFormat = format;
        try {
            this.formats.forEach((dtFormat) => {
                if (parseFormat.indexOf(dtFormat.format) >= 0) {
                    var formatResult = dtFormat.format == "tt" ? (date.getHours() < 12 ? [{ value: "am" }] : [{ value: "pm" }]) :
                        new Intl.DateTimeFormat(locale, dtFormat.options).formatToParts(date);
                    result.push({ format: dtFormat.format, result: this.fixParsedValue(formatResult[0].value, dtFormat) });
                    parseFormat = parseFormat.replace(new RegExp(dtFormat.format, "g"), "");
                }
            });
        }
        catch (e) {
            console.error(e);
        }
        result.forEach((option) => {
            format = format.replace(new RegExp(option.format, "g"), option.result);
        });
        return format;
    }
    static fixParsedValue(value, format) {
        if (format.digits)
            value = _.padStart(value, format.digits, "0");
        return value;
    }
    constructor() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiStaticHelperService, deps: [], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiStaticHelperService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiStaticHelperService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [] });
//# sourceMappingURL=data:application/json;base64,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