import { Injectable } from "@angular/core";
import StiRectangleGeometryLayout from "../computed/StiRectangleGeometryLayout";
import { StiAddressElement } from "../elements/StiAddressElement";
import { StiBarcodeElement } from "../elements/StiBarcodeElement";
import { StiButtonElement } from "../elements/StiButtonElement";
import { StiCheckBoxElement } from "../elements/StiCheckBoxElement";
import { StiComboBoxElement } from "../elements/StiComboBoxElement";
import { StiDateTimeBoxElement } from "../elements/StiDateTimeBoxElement";
import { StiForm } from "../elements/StiForm";
import { StiFormPageElement } from "../elements/StiFormPageElement";
import { StiImageElement } from "../elements/StiImageElement";
import { StiLabelElement } from "../elements/StiLabelElement";
import StiLineElement from "../elements/StiLineElement";
import { StiListBoxElement } from "../elements/StiListBoxElement";
import { StiMultipleSelectionElement } from "../elements/StiMultipleSelectionElement";
import { StiNumberBoxElement } from "../elements/StiNumberBoxElement";
import { StiPanelElement } from "../elements/StiPanelElement";
import { StiPDFSignatureElement } from "../elements/StiPDFSignatureElement";
import { StiSignatureElement } from "../elements/StiSignatureElement";
import { StiSingleSelectionElement } from "../elements/StiSingleSelectionElement";
import { StiTableElement } from "../elements/StiTableElement";
import { StiTextBoxElement } from "../elements/StiTextBoxElement";
import { StiTextElement } from "../elements/StiTextElement";
import { StiLabelColumnItem } from "../elements/table/columns/StiLabelColumnItem";
import { StiNumberBoxColumnItem } from "../elements/table/columns/StiNumberBoxColumnItem";
import { StiTotalsFieldItem } from "../elements/table/StiTotalsFieldItem";
import { Enum } from "../system/Enum";
import { StiBarcodeType } from "../system/enums";
import Guid from "../system/Guid";
import StiJson from "../system/StiJson";
import { StiLocalizationService } from "./sti-localization.service";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./sti-localization.service";
export class StiHelperService {
    getProperty(element, prop) {
        let props = prop.split(".");
        return prop.indexOf(".") == -1
            ? element[prop]
            : this.getProperty(element[props[0]], props.splice(1, props.length).join("."));
    }
    setProperty(element, prop, value) {
        let props = prop.split(".");
        if (prop.indexOf(".") == -1) {
            element[prop] = value;
        }
        else {
            element[props[0]][props[1]] = value;
        }
    }
    constructor(model, render, loc, zone) {
        this.model = model;
        this.render = render;
        this.loc = loc;
        this.zone = zone;
        this._fonts = [];
        this._numberTypes = [];
        this._rangeFormats = [];
        this._signatureTypes = [];
        this._dateTimeTypes = [];
        this._buttonTypes = [];
        this._columnTypes = [];
        this._buttonSendTypes = [];
        this._thousandSeparators = [];
        this._barcodeTypes = [];
        this._dateTimeValues = [];
        this._themes = [];
        this._borderWeights = [];
        this._unitAlignment = [];
        this._minUnitAlignment = [];
        this._labelFormat = [];
        this._penStyles = [];
        this._algorithmExpressions = [];
        this._dateTimeFormats = [];
        this._dateFormats = [];
        this._timeFormats = [];
        this._cultures = [];
        this._signatureEditorModes = [];
        this._signatureSpecialFonts = [];
        this._fontSizes = [5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 18, 20, 22, 24, 26, 28, 36, 44, 58, 72];
        this._richTextFontSizes = [];
        this._errorCorrectionLevel = ["Level1", "Level2", "Level3", "Level4"];
        this._fileMenuItems = [];
        this._dataMatrixSize = [
            "Automatic",
            "v1",
            "v2",
            "v3",
            "v4",
            "v5",
            "v6",
            "v7",
            "v8",
            "v9",
            "v10",
            "v11",
            "v12",
            "v13",
            "v14",
            "v15",
            "v16",
            "v17",
            "v18",
            "v19",
            "v20",
            "v21",
            "v22",
            "v23",
            "v24",
            "v25",
            "v26",
            "v27",
            "v28",
            "v29",
            "v30",
            "v31",
            "v32",
            "v33",
            "v34",
            "v35",
            "v36",
            "v37",
            "v38",
            "v39",
            "v40",
        ];
        this._bodyShapeType = [
            "Square",
            "RoundedSquare",
            "Dot",
            "Circle",
            "Diamond",
            "Star",
            "ZebraHorizontal",
            "ZebraVertical",
            "ZebraCross1",
            "ZebraCross2",
            "Circular",
            "DockedDiamonds",
        ];
        this._eyeFrameShapeType = ["Square", "Dots", "Circle", "Round", "Round1", "Round3"];
        this._eyeBallShapeType = [
            "Square",
            "Dots",
            "Circle",
            "Round",
            "Round1",
            "Round3",
            "Star",
            "ZebraHorizontal",
            "ZebraVertical",
        ];
        this._brushIdent = ["Empty", "Solid", "Gradient", "Glare", "Glass", "Hatch", "Default", "Style"];
        this._bodyBrush = ["Empty", "Solid", "Hatch", "Gradient", "Glare", "Glass"];
        this.hatchStyle = [
            { name: "Horizontal", value: 0 },
            { name: "Vertical", value: 1 },
            { name: "ForwardDiagonal", value: 2 },
            { name: "BackwardDiagonal", value: 3 },
            { name: "Cross", value: 4 },
            { name: "DiagonalCross", value: 5 },
            { name: "Percent05", value: 6 },
            { name: "Percent10", value: 7 },
            { name: "Percent20", value: 8 },
            { name: "Percent25", value: 9 },
            { name: "Percent30", value: 10 },
            { name: "Percent40", value: 11 },
            { name: "Percent50", value: 12 },
            { name: "Percent60", value: 13 },
            { name: "Percent70", value: 14 },
            { name: "Percent75", value: 0xf },
            { name: "Percent80", value: 0x10 },
            { name: "Percent90", value: 17 },
            { name: "LightDownwardDiagonal", value: 18 },
            { name: "LightUpwardDiagonal", value: 19 },
            { name: "DarkDownwardDiagonal", value: 20 },
            { name: "DarkUpwardDiagonal", value: 21 },
            { name: "WideDownwardDiagonal", value: 22 },
            { name: "WideUpwardDiagonal", value: 23 },
            { name: "LightVertical", value: 24 },
            { name: "LightHorizontal", value: 25 },
            { name: "NarrowVertical", value: 26 },
            { name: "NarrowHorizontal", value: 27 },
            { name: "DarkVertical", value: 28 },
            { name: "DarkHorizontal", value: 29 },
            { name: "DashedDownwardDiagonal", value: 30 },
            { name: "DashedUpwardDiagonal", value: 0x1f },
            { name: "DashedHorizontal", value: 0x20 },
            { name: "DashedVertical", value: 33 },
            { name: "SmallConfetti", value: 34 },
            { name: "LargeConfetti", value: 35 },
            { name: "ZigZag", value: 36 },
            { name: "Wave", value: 37 },
            { name: "DiagonalBrick", value: 38 },
            { name: "HorizontalBrick", value: 39 },
            { name: "Weave", value: 40 },
            { name: "Plaid", value: 41 },
            { name: "Divot", value: 42 },
            { name: "DottedGrid", value: 43 },
            { name: "DottedDiamond", value: 44 },
            { name: "Shingle", value: 45 },
            { name: "Trellis", value: 46 },
            { name: "Sphere", value: 47 },
            { name: "SmallGrid", value: 48 },
            { name: "SmallCheckerBoard", value: 49 },
            { name: "LargeCheckerBoard", value: 50 },
            { name: "OutlinedDiamond", value: 51 },
            { name: "SolidDiamond", value: 52 },
            { name: "LargeGrid", value: 4 },
            { name: "Min", value: 0 },
            { name: "Max", value: 4 },
        ];
        this.justifyOptions = [
            {
                image: "images.Properties.AlignLeft.png",
                value: 1,
                name: "Left",
            },
            {
                image: "images.Properties.AlignCenter.png",
                value: 2,
                name: "Center",
            },
            {
                image: "images.Properties.AlignRight.png",
                value: 3,
                name: "Right",
            },
        ];
        this.labelAlignment = [
            {
                image: "images.Properties.Left.png",
                value: 1,
                name: "Left",
            },
            {
                image: "images.Properties.Right.png",
                value: 2,
                name: "Right",
            },
            {
                image: "images.Properties.Top.png",
                value: 3,
                name: "Top",
            },
        ];
        this.verticalAlignment = [
            {
                image: "images.Properties.AlignTop.png",
                value: 1,
                name: "Top",
            },
            {
                image: "images.Properties.AlignMiddle.png",
                value: 2,
                name: "Center",
            },
            {
                image: "images.Properties.AlignBottom.png",
                value: 3,
                name: "Bottom",
            },
        ];
        this.styleOptions = [
            {
                name: "B",
                value: "Bold",
                image: "images.Properties.FontStyleBold.png",
            },
            {
                name: "I",
                value: "Italic",
                image: "images.Properties.FontStyleItalic.png",
            },
            {
                name: "U",
                value: "Underline",
                image: "images.Properties.FontStyleUnderline.png",
            },
        ];
        this.countries = [
            { name: "Afghanistan", code: "AF" },
            { name: "Åland Islands", code: "AX" },
            { name: "Albania", code: "AL" },
            { name: "Algeria", code: "DZ" },
            { name: "American Samoa", code: "AS" },
            { name: "AndorrA", code: "AD" },
            { name: "Angola", code: "AO" },
            { name: "Anguilla", code: "AI" },
            { name: "Antarctica", code: "AQ" },
            { name: "Antigua and Barbuda", code: "AG" },
            { name: "Argentina", code: "AR" },
            { name: "Armenia", code: "AM" },
            { name: "Aruba", code: "AW" },
            { name: "Australia", code: "AU" },
            { name: "Austria", code: "AT" },
            { name: "Azerbaijan", code: "AZ" },
            { name: "Bahamas", code: "BS" },
            { name: "Bahrain", code: "BH" },
            { name: "Bangladesh", code: "BD" },
            { name: "Barbados", code: "BB" },
            { name: "Belarus", code: "BY" },
            { name: "Belgium", code: "BE" },
            { name: "Belize", code: "BZ" },
            { name: "Benin", code: "BJ" },
            { name: "Bermuda", code: "BM" },
            { name: "Bhutan", code: "BT" },
            { name: "Bolivia", code: "BO" },
            { name: "Bosnia and Herzegovina", code: "BA" },
            { name: "Botswana", code: "BW" },
            { name: "Bouvet Island", code: "BV" },
            { name: "Brazil", code: "BR" },
            { name: "British Indian Ocean Territory", code: "IO" },
            { name: "Brunei Darussalam", code: "BN" },
            { name: "Bulgaria", code: "BG" },
            { name: "Burkina Faso", code: "BF" },
            { name: "Burundi", code: "BI" },
            { name: "Cambodia", code: "KH" },
            { name: "Cameroon", code: "CM" },
            { name: "Canada", code: "CA" },
            { name: "Cape Verde", code: "CV" },
            { name: "Cayman Islands", code: "KY" },
            { name: "Central African Republic", code: "CF" },
            { name: "Chad", code: "TD" },
            { name: "Chile", code: "CL" },
            { name: "China", code: "CN" },
            { name: "Christmas Island", code: "CX" },
            { name: "Cocos (Keeling) Islands", code: "CC" },
            { name: "Colombia", code: "CO" },
            { name: "Comoros", code: "KM" },
            { name: "Congo", code: "CG" },
            { name: "Congo, The Democratic Republic of the", code: "CD" },
            { name: "Cook Islands", code: "CK" },
            { name: "Costa Rica", code: "CR" },
            { name: "Cote D'Ivoire", code: "CI" },
            { name: "Croatia", code: "HR" },
            { name: "Cuba", code: "CU" },
            { name: "Cyprus", code: "CY" },
            { name: "Czech Republic", code: "CZ" },
            { name: "Denmark", code: "DK" },
            { name: "Djibouti", code: "DJ" },
            { name: "Dominica", code: "DM" },
            { name: "Dominican Republic", code: "DO" },
            { name: "Ecuador", code: "EC" },
            { name: "Egypt", code: "EG" },
            { name: "El Salvador", code: "SV" },
            { name: "Equatorial Guinea", code: "GQ" },
            { name: "Eritrea", code: "ER" },
            { name: "Estonia", code: "EE" },
            { name: "Ethiopia", code: "ET" },
            { name: "Falkland Islands (Malvinas)", code: "FK" },
            { name: "Faroe Islands", code: "FO" },
            { name: "Fiji", code: "FJ" },
            { name: "Finland", code: "FI" },
            { name: "France", code: "FR" },
            { name: "French Guiana", code: "GF" },
            { name: "French Polynesia", code: "PF" },
            { name: "French Southern Territories", code: "TF" },
            { name: "Gabon", code: "GA" },
            { name: "Gambia", code: "GM" },
            { name: "Georgia", code: "GE" },
            { name: "Germany", code: "DE" },
            { name: "Ghana", code: "GH" },
            { name: "Gibraltar", code: "GI" },
            { name: "Greece", code: "GR" },
            { name: "Greenland", code: "GL" },
            { name: "Grenada", code: "GD" },
            { name: "Guadeloupe", code: "GP" },
            { name: "Guam", code: "GU" },
            { name: "Guatemala", code: "GT" },
            { name: "Guernsey", code: "GG" },
            { name: "Guinea", code: "GN" },
            { name: "Guinea-Bissau", code: "GW" },
            { name: "Guyana", code: "GY" },
            { name: "Haiti", code: "HT" },
            { name: "Heard Island and Mcdonald Islands", code: "HM" },
            { name: "Holy See (Vatican City State)", code: "VA" },
            { name: "Honduras", code: "HN" },
            { name: "Hong Kong", code: "HK" },
            { name: "Hungary", code: "HU" },
            { name: "Iceland", code: "IS" },
            { name: "India", code: "IN" },
            { name: "Indonesia", code: "ID" },
            { name: "Iran, Islamic Republic Of", code: "IR" },
            { name: "Iraq", code: "IQ" },
            { name: "Ireland", code: "IE" },
            { name: "Isle of Man", code: "IM" },
            { name: "Israel", code: "IL" },
            { name: "Italy", code: "IT" },
            { name: "Jamaica", code: "JM" },
            { name: "Japan", code: "JP" },
            { name: "Jersey", code: "JE" },
            { name: "Jordan", code: "JO" },
            { name: "Kazakhstan", code: "KZ" },
            { name: "Kenya", code: "KE" },
            { name: "Kiribati", code: "KI" },
            { name: "Korea, Democratic People'S Republic of", code: "KP" },
            { name: "Korea, Republic of", code: "KR" },
            { name: "Kuwait", code: "KW" },
            { name: "Kyrgyzstan", code: "KG" },
            { name: "Lao People'S Democratic Republic", code: "LA" },
            { name: "Latvia", code: "LV" },
            { name: "Lebanon", code: "LB" },
            { name: "Lesotho", code: "LS" },
            { name: "Liberia", code: "LR" },
            { name: "Libyan Arab Jamahiriya", code: "LY" },
            { name: "Liechtenstein", code: "LI" },
            { name: "Lithuania", code: "LT" },
            { name: "Luxembourg", code: "LU" },
            { name: "Macao", code: "MO" },
            { name: "Macedonia, The Former Yugoslav Republic of", code: "MK" },
            { name: "Madagascar", code: "MG" },
            { name: "Malawi", code: "MW" },
            { name: "Malaysia", code: "MY" },
            { name: "Maldives", code: "MV" },
            { name: "Mali", code: "ML" },
            { name: "Malta", code: "MT" },
            { name: "Marshall Islands", code: "MH" },
            { name: "Martinique", code: "MQ" },
            { name: "Mauritania", code: "MR" },
            { name: "Mauritius", code: "MU" },
            { name: "Mayotte", code: "YT" },
            { name: "Mexico", code: "MX" },
            { name: "Micronesia, Federated States of", code: "FM" },
            { name: "Moldova, Republic of", code: "MD" },
            { name: "Monaco", code: "MC" },
            { name: "Mongolia", code: "MN" },
            { name: "Montserrat", code: "MS" },
            { name: "Morocco", code: "MA" },
            { name: "Mozambique", code: "MZ" },
            { name: "Myanmar", code: "MM" },
            { name: "Namibia", code: "NA" },
            { name: "Nauru", code: "NR" },
            { name: "Nepal", code: "NP" },
            { name: "Netherlands", code: "NL" },
            { name: "Netherlands Antilles", code: "AN" },
            { name: "New Caledonia", code: "NC" },
            { name: "New Zealand", code: "NZ" },
            { name: "Nicaragua", code: "NI" },
            { name: "Niger", code: "NE" },
            { name: "Nigeria", code: "NG" },
            { name: "Niue", code: "NU" },
            { name: "Norfolk Island", code: "NF" },
            { name: "Northern Mariana Islands", code: "MP" },
            { name: "Norway", code: "NO" },
            { name: "Oman", code: "OM" },
            { name: "Pakistan", code: "PK" },
            { name: "Palau", code: "PW" },
            { name: "Palestinian Territory, Occupied", code: "PS" },
            { name: "Panama", code: "PA" },
            { name: "Papua New Guinea", code: "PG" },
            { name: "Paraguay", code: "PY" },
            { name: "Peru", code: "PE" },
            { name: "Philippines", code: "PH" },
            { name: "Pitcairn", code: "PN" },
            { name: "Poland", code: "PL" },
            { name: "Portugal", code: "PT" },
            { name: "Puerto Rico", code: "PR" },
            { name: "Qatar", code: "QA" },
            { name: "Reunion", code: "RE" },
            { name: "Romania", code: "RO" },
            { name: "Russian Federation", code: "RU" },
            { name: "RWANDA", code: "RW" },
            { name: "Saint Helena", code: "SH" },
            { name: "Saint Kitts and Nevis", code: "KN" },
            { name: "Saint Lucia", code: "LC" },
            { name: "Saint Pierre and Miquelon", code: "PM" },
            { name: "Saint Vincent and the Grenadines", code: "VC" },
            { name: "Samoa", code: "WS" },
            { name: "San Marino", code: "SM" },
            { name: "Sao Tome and Principe", code: "ST" },
            { name: "Saudi Arabia", code: "SA" },
            { name: "Senegal", code: "SN" },
            { name: "Serbia and Montenegro", code: "CS" },
            { name: "Seychelles", code: "SC" },
            { name: "Sierra Leone", code: "SL" },
            { name: "Singapore", code: "SG" },
            { name: "Slovakia", code: "SK" },
            { name: "Slovenia", code: "SI" },
            { name: "Solomon Islands", code: "SB" },
            { name: "Somalia", code: "SO" },
            { name: "South Africa", code: "ZA" },
            { name: "South Georgia and the South Sandwich Islands", code: "GS" },
            { name: "Spain", code: "ES" },
            { name: "Sri Lanka", code: "LK" },
            { name: "Sudan", code: "SD" },
            { name: "Suriname", code: "SR" },
            { name: "Svalbard and Jan Mayen", code: "SJ" },
            { name: "Swaziland", code: "SZ" },
            { name: "Sweden", code: "SE" },
            { name: "Switzerland", code: "CH" },
            { name: "Syrian Arab Republic", code: "SY" },
            { name: "Taiwan, Province of China", code: "TW" },
            { name: "Tajikistan", code: "TJ" },
            { name: "Tanzania, United Republic of", code: "TZ" },
            { name: "Thailand", code: "TH" },
            { name: "Timor-Leste", code: "TL" },
            { name: "Togo", code: "TG" },
            { name: "Tokelau", code: "TK" },
            { name: "Tonga", code: "TO" },
            { name: "Trinidad and Tobago", code: "TT" },
            { name: "Tunisia", code: "TN" },
            { name: "Turkey", code: "TR" },
            { name: "Turkmenistan", code: "TM" },
            { name: "Turks and Caicos Islands", code: "TC" },
            { name: "Tuvalu", code: "TV" },
            { name: "Uganda", code: "UG" },
            { name: "Ukraine", code: "UA" },
            { name: "United Arab Emirates", code: "AE" },
            { name: "United Kingdom", code: "GB" },
            { name: "United States", code: "US" },
            { name: "United States Minor Outlying Islands", code: "UM" },
            { name: "Uruguay", code: "UY" },
            { name: "Uzbekistan", code: "UZ" },
            { name: "Vanuatu", code: "VU" },
            { name: "Venezuela", code: "VE" },
            { name: "Viet Nam", code: "VN" },
            { name: "Virgin Islands, British", code: "VG" },
            { name: "Virgin Islands, U.S.", code: "VI" },
            { name: "Wallis and Futuna", code: "WF" },
            { name: "Western Sahara", code: "EH" },
            { name: "Yemen", code: "YE" },
            { name: "Zambia", code: "ZM" },
            { name: "Zimbabwe", code: "ZW" },
        ];
        this.currencyInfo = [
            {
                englishName: "Afghan Afghani (\u060B)",
                nativeName: "\u0627\u0641\u063A\u0627\u0646\u06CC \u0627\u0641\u063A\u0627\u0646\u0633\u062A\u0627\u0646",
                code: "AFN",
                symbol: "\u060B",
            },
            {
                englishName: "Albanian Lek (Lek\u00EB)",
                nativeName: "Leku shqiptar",
                code: "ALL",
                symbol: "Lek\u00EB",
            },
            {
                englishName: "Algerian Dinar (\u062F.\u062C.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u062C\u0632\u0627\u0626\u0631\u064A",
                code: "DZD",
                symbol: "\u062F.\u062C.\u200F",
            },
            {
                englishName: "Angolan Kwanza (Kz)",
                nativeName: "Kwanza ya Ang\u00F3la",
                code: "AOA",
                symbol: "Kz",
            },
            {
                englishName: "Argentine Peso ($)",
                nativeName: "peso argentino",
                code: "ARS",
                symbol: "$",
            },
            {
                englishName: "Armenian Dram (\u058F)",
                nativeName: "\u0570\u0561\u0575\u056F\u0561\u056F\u0561\u0576 \u0564\u0580\u0561\u0574",
                code: "AMD",
                symbol: "\u058F",
            },
            {
                englishName: "Aruban Florin (Afl.)",
                nativeName: "Arubaanse gulden",
                code: "AWG",
                symbol: "Afl.",
            },
            {
                englishName: "Australian Dollar ($)",
                nativeName: "Australian Dollar",
                code: "AUD",
                symbol: "$",
            },
            {
                englishName: "Azerbaijani Manat (\u20BC)",
                nativeName: "AZN",
                code: "AZN",
                symbol: "\u20BC",
            },
            {
                englishName: "Bahamian Dollar ($)",
                nativeName: "Bahamian Dollar",
                code: "BSD",
                symbol: "$",
            },
            {
                englishName: "Bahraini Dinar (\u062F.\u0628.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0628\u062D\u0631\u064A\u0646\u064A",
                code: "BHD",
                symbol: "\u062F.\u0628.\u200F",
            },
            {
                englishName: "Bangladeshi Taka (\u09F3)",
                nativeName: "\u09AC\u09BE\u0982\u09B2\u09BE\u09A6\u09C7\u09B6\u09C0 \u099F\u09BE\u0995\u09BE",
                code: "BDT",
                symbol: "\u09F3",
            },
            {
                englishName: "Barbadian Dollar ($)",
                nativeName: "Barbadian Dollar",
                code: "BBD",
                symbol: "$",
            },
            {
                englishName: "Belarusian Ruble (Br)",
                nativeName: "\u0431\u0435\u043B\u0430\u0440\u0443\u0441\u043A\u0456 \u0440\u0443\u0431\u0435\u043B\u044C",
                code: "BYN",
                symbol: "Br",
            },
            {
                englishName: "Belize Dollar ($)",
                nativeName: "Belize Dollar",
                code: "BZD",
                symbol: "$",
            },
            {
                englishName: "Bermudan Dollar ($)",
                nativeName: "Bermudan Dollar",
                code: "BMD",
                symbol: "$",
            },
            {
                englishName: "Bhutanese Ngultrum (Nu.)",
                nativeName: "\u0F51\u0F44\u0F74\u0F63\u0F0B\u0F40\u0FB2\u0F58",
                code: "BTN",
                symbol: "Nu.",
            },
            {
                englishName: "Bolivian Boliviano (Bs)",
                nativeName: "boliviano",
                code: "BOB",
                symbol: "Bs",
            },
            {
                englishName: "Bosnia-Herzegovina Convertible Mark (\u041A\u041C)",
                nativeName: "\u041A\u043E\u043D\u0432\u0435\u0440\u0442\u0438\u0431\u0438\u043B\u043D\u0430 \u043C\u0430\u0440\u043A\u0430",
                code: "BAM",
                symbol: "\u041A\u041C",
            },
            {
                englishName: "Botswanan Pula (P)",
                nativeName: "Botswanan Pula",
                code: "BWP",
                symbol: "P",
            },
            {
                englishName: "Brazilian Real (R$)",
                nativeName: "real brasile\u00F1o",
                code: "BRL",
                symbol: "R$",
            },
            {
                englishName: "British Pound (\u00A3)",
                nativeName: "Punt Prydain",
                code: "GBP",
                symbol: "\u00A3",
            },
            {
                englishName: "Brunei Dollar ($)",
                nativeName: "Dolar Brunei",
                code: "BND",
                symbol: "$",
            },
            {
                englishName: "Bulgarian Lev (\u043B\u0432.)",
                nativeName: "\u0411\u044A\u043B\u0433\u0430\u0440\u0441\u043A\u0438 \u043B\u0435\u0432",
                code: "BGN",
                symbol: "\u043B\u0432.",
            },
            {
                englishName: "Burundian Franc (FBu)",
                nativeName: "Burundian Franc",
                code: "BIF",
                symbol: "FBu",
            },
            {
                englishName: "Cambodian Riel (\u17DB)",
                nativeName: "\u179A\u17C0\u179B\u200B\u1780\u1798\u17D2\u1796\u17BB\u1787\u17B6",
                code: "KHR",
                symbol: "\u17DB",
            },
            {
                englishName: "Canadian Dollar ($)",
                nativeName: "Canadian Dollar",
                code: "CAD",
                symbol: "$",
            },
            {
                englishName: "Cape Verdean Escudo (\u200B)",
                nativeName: "Skudu Kabuverdianu",
                code: "CVE",
                symbol: "\u200B",
            },
            {
                englishName: "Cayman Islands Dollar ($)",
                nativeName: "Cayman Islands Dollar",
                code: "KYD",
                symbol: "$",
            },
            {
                englishName: "Central African CFA Franc (FCFA)",
                nativeName: "CFA F\u00E0l\u00E2\u014B BEAC",
                code: "XAF",
                symbol: "FCFA",
            },
            {
                englishName: "CFP Franc (FCFP)",
                nativeName: "franc CFP",
                code: "XPF",
                symbol: "FCFP",
            },
            {
                englishName: "Chilean Peso (CLP)",
                nativeName: "CLP",
                code: "CLP",
                symbol: "CLP",
            },
            {
                englishName: "Chinese Yuan (\u00A5)",
                nativeName: "\u0F61\u0F74\u0F0B\u0F68\u0F53\u0F0B",
                code: "CNY",
                symbol: "\u00A5",
            },
            {
                englishName: "Colombian Peso ($)",
                nativeName: "peso colombiano",
                code: "COP",
                symbol: "$",
            },
            {
                englishName: "Comorian Franc (CF)",
                nativeName: "\u0641\u0631\u0646\u0643 \u062C\u0632\u0631 \u0627\u0644\u0642\u0645\u0631",
                code: "KMF",
                symbol: "CF",
            },
            {
                englishName: "Congolese Franc (FC)",
                nativeName: "franc congolais",
                code: "CDF",
                symbol: "FC",
            },
            {
                englishName: "Costa Rican Col\u00F3n (\u20A1)",
                nativeName: "col\u00F3n costarricense",
                code: "CRC",
                symbol: "\u20A1",
            },
            {
                englishName: "Croatian Kuna (HRK)",
                nativeName: "hrvatska kuna",
                code: "HRK",
                symbol: "HRK",
            },
            {
                englishName: "Cuban Peso ($)",
                nativeName: "peso cubano",
                code: "CUP",
                symbol: "$",
            },
            {
                englishName: "Czech Koruna (K\u010D)",
                nativeName: "\u010Desk\u00E1 koruna",
                code: "CZK",
                symbol: "K\u010D",
            },
            {
                englishName: "Danish Krone (kr.)",
                nativeName: "dansk krone",
                code: "DKK",
                symbol: "kr.",
            },
            {
                englishName: "Djiboutian Franc (Fdj)",
                nativeName: "DJF",
                code: "DJF",
                symbol: "Fdj",
            },
            {
                englishName: "Dominican Peso (RD$)",
                nativeName: "peso dominicano",
                code: "DOP",
                symbol: "RD$",
            },
            {
                englishName: "East Caribbean Dollar ($)",
                nativeName: "East Caribbean Dollar",
                code: "XCD",
                symbol: "$",
            },
            {
                englishName: "Egyptian Pound (\u062C.\u0645.\u200F)",
                nativeName: "\u062C\u0646\u064A\u0647 \u0645\u0635\u0631\u064A",
                code: "EGP",
                symbol: "\u062C.\u0645.\u200F",
            },
            {
                englishName: "Eritrean Nakfa (Nfk)",
                nativeName: "ERN",
                code: "ERN",
                symbol: "Nfk",
            },
            {
                englishName: "Ethiopian Birr (Br)",
                nativeName: "ETB",
                code: "ETB",
                symbol: "Br",
            },
            {
                englishName: "Euro (\u20AC)",
                nativeName: "euro",
                code: "EUR",
                symbol: "\u20AC",
            },
            {
                englishName: "Falkland Islands Pound (\u00A3)",
                nativeName: "Falkland Islands Pound",
                code: "FKP",
                symbol: "\u00A3",
            },
            {
                englishName: "Fijian Dollar ($)",
                nativeName: "Fijian Dollar",
                code: "FJD",
                symbol: "$",
            },
            {
                englishName: "Gambian Dalasi (D)",
                nativeName: "Gambian Dalasi",
                code: "GMD",
                symbol: "D",
            },
            {
                englishName: "Georgian Lari (\u20BE)",
                nativeName: "\u10E5\u10D0\u10E0\u10D7\u10E3\u10DA\u10D8 \u10DA\u10D0\u10E0\u10D8",
                code: "GEL",
                symbol: "\u20BE",
            },
            {
                englishName: "Ghanaian Cedi (GH\u20B5)",
                nativeName: "Ghana Sidi",
                code: "GHS",
                symbol: "GH\u20B5",
            },
            {
                englishName: "Gibraltar Pound (\u00A3)",
                nativeName: "Gibraltar Pound",
                code: "GIP",
                symbol: "\u00A3",
            },
            {
                englishName: "Guatemalan Quetzal (Q)",
                nativeName: "quetzal",
                code: "GTQ",
                symbol: "Q",
            },
            {
                englishName: "Guinean Franc (FG)",
                nativeName: "GNF",
                code: "GNF",
                symbol: "FG",
            },
            {
                englishName: "Guyanaese Dollar ($)",
                nativeName: "Guyanaese Dollar",
                code: "GYD",
                symbol: "$",
            },
            {
                englishName: "Haitian Gourde (G)",
                nativeName: "gourde ha\u00EFtienne",
                code: "HTG",
                symbol: "G",
            },
            {
                englishName: "Honduran Lempira (L)",
                nativeName: "lempira hondure\u00F1o",
                code: "HNL",
                symbol: "L",
            },
            {
                englishName: "Hong Kong Dollar (HK$)",
                nativeName: "Hong Kong Dollar",
                code: "HKD",
                symbol: "HK$",
            },
            {
                englishName: "Hungarian Forint (Ft)",
                nativeName: "magyar forint",
                code: "HUF",
                symbol: "Ft",
            },
            {
                englishName: "Icelandic Kr\u00F3na (ISK)",
                nativeName: "\u00EDslensk kr\u00F3na",
                code: "ISK",
                symbol: "ISK",
            },
            {
                englishName: "Indian Rupee (\u20B9)",
                nativeName: "\u09AD\u09BE\u09F0\u09A4\u09C0\u09AF\u09BC \u09F0\u09C1\u09AA\u09C0",
                code: "INR",
                symbol: "\u20B9",
            },
            {
                englishName: "Indonesian Rupiah (Rp)",
                nativeName: "Rupiah Indonesia",
                code: "IDR",
                symbol: "Rp",
            },
            {
                englishName: "Iranian Rial (IRR)",
                nativeName: "IRR",
                code: "IRR",
                symbol: "IRR",
            },
            {
                englishName: "Iraqi Dinar (\u062F.\u0639.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0639\u0631\u0627\u0642\u064A",
                code: "IQD",
                symbol: "\u062F.\u0639.\u200F",
            },
            {
                englishName: "Israeli New Shekel (\u20AA)",
                nativeName: "\u0634\u064A\u0643\u0644 \u0625\u0633\u0631\u0627\u0626\u064A\u0644\u064A \u062C\u062F\u064A\u062F",
                code: "ILS",
                symbol: "\u20AA",
            },
            {
                englishName: "Jamaican Dollar ($)",
                nativeName: "Jamaican Dollar",
                code: "JMD",
                symbol: "$",
            },
            {
                englishName: "Japanese Yen (\uFFE5)",
                nativeName: "\u65E5\u672C\u5186",
                code: "JPY",
                symbol: "\uFFE5",
            },
            {
                englishName: "Jordanian Dinar (\u062F.\u0623.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0623\u0631\u062F\u0646\u064A",
                code: "JOD",
                symbol: "\u062F.\u0623.\u200F",
            },
            {
                englishName: "Kazakhstani Tenge (\u20B8)",
                nativeName: "\u049A\u0430\u0437\u0430\u049B\u0441\u0442\u0430\u043D \u0442\u0435\u04A3\u0433\u0435\u0441\u0456",
                code: "KZT",
                symbol: "\u20B8",
            },
            {
                englishName: "Kenyan Shilling (Ksh)",
                nativeName: "Shilingi ya Kenya",
                code: "KES",
                symbol: "Ksh",
            },
            {
                englishName: "Kuwaiti Dinar (\u062F.\u0643.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0643\u0648\u064A\u062A\u064A",
                code: "KWD",
                symbol: "\u062F.\u0643.\u200F",
            },
            {
                englishName: "Kyrgystani Som (\u0441\u043E\u043C)",
                nativeName: "\u041A\u044B\u0440\u0433\u044B\u0437\u0441\u0442\u0430\u043D \u0441\u043E\u043C\u0443",
                code: "KGS",
                symbol: "\u0441\u043E\u043C",
            },
            {
                englishName: "Laotian Kip (\u20AD)",
                nativeName: "\u0EA5\u0EB2\u0EA7 \u0E81\u0EB5\u0E9A",
                code: "LAK",
                symbol: "\u20AD",
            },
            {
                englishName: "Lebanese Pound (\u0644.\u0644.\u200F)",
                nativeName: "\u062C\u0646\u064A\u0647 \u0644\u0628\u0646\u0627\u0646\u064A",
                code: "LBP",
                symbol: "\u0644.\u0644.\u200F",
            },
            {
                englishName: "Liberian Dollar ($)",
                nativeName: "Liberian Dollar",
                code: "LRD",
                symbol: "$",
            },
            {
                englishName: "Libyan Dinar (\u062F.\u0644.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0644\u064A\u0628\u064A",
                code: "LYD",
                symbol: "\u062F.\u0644.\u200F",
            },
            {
                englishName: "Macanese Pataca (MOP$)",
                nativeName: "Macanese Pataca",
                code: "MOP",
                symbol: "MOP$",
            },
            {
                englishName: "Macedonian Denar (\u0434\u0435\u043D)",
                nativeName: "\u041C\u0430\u043A\u0435\u0434\u043E\u043D\u0441\u043A\u0438 \u0434\u0435\u043D\u0430\u0440",
                code: "MKD",
                symbol: "\u0434\u0435\u043D",
            },
            {
                englishName: "Malagasy Ariary (Ar)",
                nativeName: "Malagasy Ariary",
                code: "MGA",
                symbol: "Ar",
            },
            {
                englishName: "Malawian Kwacha (MK)",
                nativeName: "Malawian Kwacha",
                code: "MWK",
                symbol: "MK",
            },
            {
                englishName: "Malaysian Ringgit (RM)",
                nativeName: "Malaysian Ringgit",
                code: "MYR",
                symbol: "RM",
            },
            {
                englishName: "Maldivian Rufiyaa (\u0783.)",
                nativeName: "MVR",
                code: "MVR",
                symbol: "\u0783.",
            },
            {
                englishName: "Mauritanian Ouguiya (\u0623.\u0645.)",
                nativeName: "\u0623\u0648\u0642\u064A\u0629 \u0645\u0648\u0631\u064A\u062A\u0627\u0646\u064A\u0629",
                code: "MRU",
                symbol: "\u0623.\u0645.",
            },
            {
                englishName: "Mauritian Rupee (Rs)",
                nativeName: "Mauritian Rupee",
                code: "MUR",
                symbol: "Rs",
            },
            {
                englishName: "Mexican Peso ($)",
                nativeName: "peso mexicano",
                code: "MXN",
                symbol: "$",
            },
            {
                englishName: "Moldovan Leu (L)",
                nativeName: "leu moldovenesc",
                code: "MDL",
                symbol: "L",
            },
            {
                englishName: "Mongolian Tugrik (\u20AE)",
                nativeName: "\u0442\u04E9\u0433\u0440\u04E9\u0433",
                code: "MNT",
                symbol: "\u20AE",
            },
            {
                englishName: "Moroccan Dirham (\u062F.\u0645.\u200F)",
                nativeName: "\u062F\u0631\u0647\u0645 \u0645\u063A\u0631\u0628\u064A",
                code: "MAD",
                symbol: "\u062F.\u0645.\u200F",
            },
            {
                englishName: "Mozambican Metical (MTn)",
                nativeName: "MZN",
                code: "MZN",
                symbol: "MTn",
            },
            {
                englishName: "Myanmar Kyat (K)",
                nativeName: "\u1019\u103C\u1014\u103A\u1019\u102C \u1000\u103B\u1015\u103A",
                code: "MMK",
                symbol: "K",
            },
            {
                englishName: "Namibian Dollar ($)",
                nativeName: "Namibiese dollar",
                code: "NAD",
                symbol: "$",
            },
            {
                englishName: "Nepalese Rupee (\u0928\u0947\u0930\u0942)",
                nativeName: "\u0928\u0947\u092A\u093E\u0932\u0940 \u0930\u0942\u092A\u0948\u092F\u093E\u0901",
                code: "NPR",
                symbol: "\u0928\u0947\u0930\u0942",
            },
            {
                englishName: "Netherlands Antillean Guilder (NAf.)",
                nativeName: "Netherlands Antillean Guilder",
                code: "ANG",
                symbol: "NAf.",
            },
            {
                englishName: "New Taiwan Dollar ($)",
                nativeName: "\u65B0\u53F0\u5E63",
                code: "TWD",
                symbol: "$",
            },
            {
                englishName: "New Zealand Dollar ($)",
                nativeName: "New Zealand Dollar",
                code: "NZD",
                symbol: "$",
            },
            {
                englishName: "Nicaraguan C\u00F3rdoba (C$)",
                nativeName: "c\u00F3rdoba nicarag\u00FCense",
                code: "NIO",
                symbol: "C$",
            },
            {
                englishName: "Nigerian Naira (\u20A6)",
                nativeName: "Nigerian Naira",
                code: "NGN",
                symbol: "\u20A6",
            },
            {
                englishName: "North Korean Won (KPW)",
                nativeName: "\uC870\uC120 \uBBFC\uC8FC\uC8FC\uC758 \uC778\uBBFC \uACF5\uD654\uAD6D \uC6D0",
                code: "KPW",
                symbol: "KPW",
            },
            {
                englishName: "Norwegian Krone (kr)",
                nativeName: "norske kroner",
                code: "NOK",
                symbol: "kr",
            },
            {
                englishName: "Omani Rial (\u0631.\u0639.\u200F)",
                nativeName: "\u0631\u064A\u0627\u0644 \u0639\u0645\u0627\u0646\u064A",
                code: "OMR",
                symbol: "\u0631.\u0639.\u200F",
            },
            {
                englishName: "Pakistani Rupee (Rs)",
                nativeName: "Pakistani Rupee",
                code: "PKR",
                symbol: "Rs",
            },
            {
                englishName: "Panamanian Balboa (B/.)",
                nativeName: "balboa paname\u00F1o",
                code: "PAB",
                symbol: "B/.",
            },
            {
                englishName: "Papua New Guinean Kina (K)",
                nativeName: "Papua New Guinean Kina",
                code: "PGK",
                symbol: "K",
            },
            {
                englishName: "Paraguayan Guarani (Gs.)",
                nativeName: "guaran\u00ED paraguayo",
                code: "PYG",
                symbol: "Gs.",
            },
            {
                englishName: "Peruvian Sol (S/)",
                nativeName: "sol peruano",
                code: "PEN",
                symbol: "S/",
            },
            {
                englishName: "Philippine Piso (\u20B1)",
                nativeName: "PHP",
                code: "PHP",
                symbol: "\u20B1",
            },
            {
                englishName: "Polish Zloty (z\u0142)",
                nativeName: "z\u0142oty polski",
                code: "PLN",
                symbol: "z\u0142",
            },
            {
                englishName: "Qatari Rial (\u0631.\u0642.\u200F)",
                nativeName: "\u0631\u064A\u0627\u0644 \u0642\u0637\u0631\u064A",
                code: "QAR",
                symbol: "\u0631.\u0642.\u200F",
            },
            {
                englishName: "Romanian Leu (RON)",
                nativeName: "leu rom\u00E2nesc",
                code: "RON",
                symbol: "RON",
            },
            {
                englishName: "Russian Ruble (RUB)",
                nativeName: "RUB",
                code: "RUB",
                symbol: "RUB",
            },
            {
                englishName: "Rwandan Franc (RF)",
                nativeName: "Rwandan Franc",
                code: "RWF",
                symbol: "RF",
            },
            {
                englishName: "Samoan Tala (WS$)",
                nativeName: "Samoan Tala",
                code: "WST",
                symbol: "WS$",
            },
            {
                englishName: "S\u00E3o Tom\u00E9 \u0026 Pr\u00EDncipe Dobra (Db)",
                nativeName: "dobra de S\u00E3o Tom\u00E9 e Pr\u00EDncipe",
                code: "STN",
                symbol: "Db",
            },
            {
                englishName: "Saudi Riyal (\u0631.\u0633.\u200F)",
                nativeName: "\u0631\u064A\u0627\u0644 \u0633\u0639\u0648\u062F\u064A",
                code: "SAR",
                symbol: "\u0631.\u0633.\u200F",
            },
            {
                englishName: "Serbian Dinar (RSD)",
                nativeName: "\u0421\u0440\u043F\u0441\u043A\u0438 \u0434\u0438\u043D\u0430\u0440",
                code: "RSD",
                symbol: "RSD",
            },
            {
                englishName: "Seychellois Rupee (SR)",
                nativeName: "Seychellois Rupee",
                code: "SCR",
                symbol: "SR",
            },
            {
                englishName: "Sierra Leonean Leone (Le)",
                nativeName: "Sierra Leonean Leone",
                code: "SLL",
                symbol: "Le",
            },
            {
                englishName: "Singapore Dollar ($)",
                nativeName: "Singapore Dollar",
                code: "SGD",
                symbol: "$",
            },
            {
                englishName: "Solomon Islands Dollar ($)",
                nativeName: "Solomon Islands Dollar",
                code: "SBD",
                symbol: "$",
            },
            {
                englishName: "Somali Shilling (S)",
                nativeName: "\u0634\u0644\u0646 \u0635\u0648\u0645\u0627\u0644\u064A",
                code: "SOS",
                symbol: "S",
            },
            {
                englishName: "South African Rand (R)",
                nativeName: "Suid-Afrikaanse rand",
                code: "ZAR",
                symbol: "R",
            },
            {
                englishName: "South Korean Won (\u20A9)",
                nativeName: "\uB300\uD55C\uBBFC\uAD6D \uC6D0",
                code: "KRW",
                symbol: "\u20A9",
            },
            {
                englishName: "South Sudanese Pound (\u00A3)",
                nativeName: "\u062C\u0646\u064A\u0647 \u062C\u0646\u0648\u0628 \u0627\u0644\u0633\u0648\u062F\u0627\u0646",
                code: "SSP",
                symbol: "\u00A3",
            },
            {
                englishName: "Sri Lankan Rupee (\u0DBB\u0DD4.)",
                nativeName: "\u0DC1\u0DCA\u200D\u0DBB\u0DD3 \u0DBD\u0D82\u0D9A\u0DCF \u0DBB\u0DD4\u0DB4\u0DD2\u0DBA\u0DBD",
                code: "LKR",
                symbol: "\u0DBB\u0DD4.",
            },
            {
                englishName: "St. Helena Pound (\u00A3)",
                nativeName: "St. Helena Pound",
                code: "SHP",
                symbol: "\u00A3",
            },
            {
                englishName: "Sudanese Pound (\u062C.\u0633.)",
                nativeName: "\u062C\u0646\u064A\u0647 \u0633\u0648\u062F\u0627\u0646\u064A",
                code: "SDG",
                symbol: "\u062C.\u0633.",
            },
            {
                englishName: "Surinamese Dollar ($)",
                nativeName: "Surinaamse dollar",
                code: "SRD",
                symbol: "$",
            },
            {
                englishName: "Swazi Lilangeni (E)",
                nativeName: "Swazi Lilangeni",
                code: "SZL",
                symbol: "E",
            },
            {
                englishName: "Swedish Krona (kr)",
                nativeName: "Swedish Krona",
                code: "SEK",
                symbol: "kr",
            },
            {
                englishName: "Swiss Franc (CHF)",
                nativeName: "Schweizer Franken",
                code: "CHF",
                symbol: "CHF",
            },
            {
                englishName: "Syrian Pound (\u0644.\u0633.\u200F)",
                nativeName: "\u0644\u064A\u0631\u0629 \u0633\u0648\u0631\u064A\u0629",
                code: "SYP",
                symbol: "\u0644.\u0633.\u200F",
            },
            {
                englishName: "Tajikistani Somoni (\u0441\u043E\u043C.)",
                nativeName: "\u0421\u043E\u043C\u043E\u043D\u04E3",
                code: "TJS",
                symbol: "\u0441\u043E\u043C.",
            },
            {
                englishName: "Tanzanian Shilling (TSh)",
                nativeName: "shilingi ya Tandhania",
                code: "TZS",
                symbol: "TSh",
            },
            {
                englishName: "Thai Baht (\u0E3F)",
                nativeName: "\u0E1A\u0E32\u0E17",
                code: "THB",
                symbol: "\u0E3F",
            },
            {
                englishName: "Tongan Pa\u02BBanga (T$)",
                nativeName: "Tongan Pa\u02BBanga",
                code: "TOP",
                symbol: "T$",
            },
            {
                englishName: "Trinidad \u0026 Tobago Dollar ($)",
                nativeName: "Trinidad \u0026 Tobago Dollar",
                code: "TTD",
                symbol: "$",
            },
            {
                englishName: "Tunisian Dinar (\u062F.\u062A.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u062A\u0648\u0646\u0633\u064A",
                code: "TND",
                symbol: "\u062F.\u062A.\u200F",
            },
            {
                englishName: "Turkish Lira (\u20BA)",
                nativeName: "T\u00FCrk Liras\u0131",
                code: "TRY",
                symbol: "\u20BA",
            },
            {
                englishName: "Turkmenistani Manat (TMT)",
                nativeName: "T\u00FCrkmen manady",
                code: "TMT",
                symbol: "TMT",
            },
            {
                englishName: "Ugandan Shilling (USh)",
                nativeName: "Eshiringi ya Uganda",
                code: "UGX",
                symbol: "USh",
            },
            {
                englishName: "Ukrainian Hryvnia (\u20B4)",
                nativeName: "\u0443\u043A\u0440\u0430\u0438\u043D\u0441\u043A\u0430\u044F \u0433\u0440\u0438\u0432\u043D\u0430",
                code: "UAH",
                symbol: "\u20B4",
            },
            {
                englishName: "United Arab Emirates Dirham (\u062F.\u0625.\u200F)",
                nativeName: "\u062F\u0631\u0647\u0645 \u0625\u0645\u0627\u0631\u0627\u062A\u064A",
                code: "AED",
                symbol: "\u062F.\u0625.\u200F",
            },
            {
                englishName: "Uruguayan Peso ($)",
                nativeName: "peso uruguayo",
                code: "UYU",
                symbol: "$",
            },
            {
                englishName: "US Dollar ($)",
                nativeName: "US \u13A0\u13D5\u13B3",
                code: "USD",
                symbol: "$",
            },
            {
                englishName: "Uzbekistani Som (\u0441\u045E\u043C)",
                nativeName: "\u040E\u0437\u0431\u0435\u043A\u0438\u0441\u0442\u043E\u043D \u0441\u045E\u043C",
                code: "UZS",
                symbol: "\u0441\u045E\u043C",
            },
            {
                englishName: "Vanuatu Vatu (VT)",
                nativeName: "Vanuatu Vatu",
                code: "VUV",
                symbol: "VT",
            },
            {
                englishName: "Venezuelan Bol\u00EDvar (Bs.S)",
                nativeName: "bol\u00EDvar soberano",
                code: "VES",
                symbol: "Bs.S",
            },
            {
                englishName: "Vietnamese Dong (\u20AB)",
                nativeName: "\u0110\u1ED3ng Vi\u1EC7t Nam",
                code: "VND",
                symbol: "\u20AB",
            },
            {
                englishName: "West African CFA Franc (CFA)",
                nativeName: "sefa Fra\u014B (BCEAO)",
                code: "XOF",
                symbol: "CFA",
            },
            {
                englishName: "Yemeni Rial (\u0631.\u064A.\u200F)",
                nativeName: "\u0631\u064A\u0627\u0644 \u064A\u0645\u0646\u064A",
                code: "YER",
                symbol: "\u0631.\u064A.\u200F",
            },
            {
                englishName: "Zambian Kwacha (K)",
                nativeName: "ZMW",
                code: "ZMW",
                symbol: "K",
            },
        ];
        this.elementTypes = {
            AddressElement: "Address",
            Text_BoxElement: "StiTextBoxControl",
            TextElement: "StiText",
            TableElement: "StiTable",
            Single_SelectionElement: "StiSingleSelection",
            SignatureElement: "StiElectronicSignature",
            PDFSignatureElement: "StiPdfDigitalSignature",
            PanelElement: "StiPanel",
            Number_BoxElement: "StiNumberBox",
            Multiple_SelectionElement: "StiMultipleSelection",
            List_BoxElement: "StiListBox",
            LabelElement: "StiLabelControl",
            ImageElement: "StiImage",
            LineElement: "Line",
            DateTime_BoxElement: "StiDateTimePickerControl",
            Combo_BoxElement: "StiComboBox",
            Check_BoxElement: "StiCheckBox",
            ButtonElement: "StiButton",
            BarCodeElement: "StiBarCode",
            StiPageElement: "StiPage",
        };
        this.elementCategories = {
            AddressElement: "Report",
            Text_BoxElement: "Dialogs",
            LineElement: "Chart",
            DateTime_BoxElement: "Dialogs",
            LabelElement: "Dialogs",
        };
        StiLocalizationService.needToRefresh.subscribe(() => {
            this.updateHelper();
        });
    }
    get richTextFontSizes() {
        if (this._richTextFontSizes.length === 0) {
            this._richTextFontSizes.push({ name: "8", value: 1 });
            this._richTextFontSizes.push({ name: "10", value: 2 });
            this._richTextFontSizes.push({ name: "12", value: 3 });
            this._richTextFontSizes.push({ name: "14", value: 4 });
            this._richTextFontSizes.push({ name: "18", value: 5 });
            this._richTextFontSizes.push({ name: "24", value: 6 });
            this._richTextFontSizes.push({ name: "36", value: 7 });
        }
        return this._richTextFontSizes;
    }
    get fontSizes() {
        return this._fontSizes;
    }
    getLocalizationKey(type) {
        return this.elementTypes[type];
    }
    getLocalizationCategory(type) {
        return this.elementCategories[type] ? this.elementCategories[type] : "Components";
    }
    get errorCorrectionLevel() {
        return this._errorCorrectionLevel;
    }
    get bodyShapeType() {
        return this._bodyShapeType;
    }
    get eyeFrameShapeType() {
        return this._eyeFrameShapeType;
    }
    get eyeBallShapeType() {
        return this._eyeBallShapeType;
    }
    get brushIdent() {
        return this._brushIdent;
    }
    get bodyBrush() {
        return this._bodyBrush;
    }
    get dataMatrixSize() {
        return this._dataMatrixSize;
    }
    get numberTypes() {
        if (this._numberTypes.length === 0) {
            this._numberTypes.push({
                name: StiLocalizationService.get("FormFormatEditor", "Number"),
                value: "Decimal",
            });
            this._numberTypes.push({
                name: StiLocalizationService.get("FormFormatEditor", "Currency"),
                value: "Currency",
            });
        }
        return this._numberTypes;
    }
    get rangeFormats() {
        if (this._rangeFormats.length === 0) {
            this._rangeFormats.push({
                name: StiLocalizationService.get("PropertyEnum", "Digits"),
                value: "Digits",
            });
            this._rangeFormats.push({
                name: StiLocalizationService.get("PropertyEnum", "Values"),
                value: "Values",
            });
        }
        return this._rangeFormats;
    }
    get signatureTypes() {
        if (this._signatureTypes.length === 0) {
            this._signatureTypes.push({
                name: StiLocalizationService.get("Components", "StiElectronicSignature"),
                value: "Signature",
            });
            this._signatureTypes.push({
                name: StiLocalizationService.get("Components", "StiPdfDigitalSignature"),
                value: "DigitalSignature",
            });
        }
        return this._signatureTypes;
    }
    get columnTypes() {
        if (this._columnTypes.length === 0) {
            this._columnTypes.push({ name: StiLocalizationService.get("Components", "StiCheckBox"), value: "CheckBox" });
            this._columnTypes.push({ name: StiLocalizationService.get("Components", "StiComboBox"), value: "ComboBox" });
            this._columnTypes.push({ name: StiLocalizationService.get("Dialogs", "StiLabelControl"), value: "Label" });
            this._columnTypes.push({
                name: StiLocalizationService.get("Components", "StiSingleSelection"),
                value: "RadioButton",
            });
            this._columnTypes.push({ name: StiLocalizationService.get("Dialogs", "StiTextBoxControl"), value: "TextBox" });
            this._columnTypes.push({ name: StiLocalizationService.get("Components", "StiNumberBox"), value: "NumberBox" });
        }
        return this._columnTypes;
    }
    get buttonTypes() {
        if (this._buttonTypes.length === 0) {
            this._buttonTypes.push({
                name: StiLocalizationService.get("Gui", "monthcalendar_clearbutton"),
                value: "ClearForm",
            });
            this._buttonTypes.push({
                name: StiLocalizationService.get("A_WebViewer", "ButtonSend"),
                value: "SendForm",
            });
            this._buttonTypes.push({
                name: StiLocalizationService.get("Buttons", "Attach"),
                value: "AttachFiles",
            });
        }
        return this._buttonTypes;
    }
    get algorithmExpressions() {
        if (this._algorithmExpressions.length === 0) {
            this._algorithmExpressions.push({ name: "Constant", value: "Constant" });
            this._algorithmExpressions.push({ name: "Number cell value", value: "NumberCellValue" });
            this._algorithmExpressions.push({ name: "Number column max", value: "NumberColumnMax" });
            this._algorithmExpressions.push({ name: "Number column sum", value: "NumberColumnSum" });
        }
        return this._algorithmExpressions;
    }
    get buttonSendTypes() {
        if (this._buttonSendTypes.length === 0) {
            this._buttonSendTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiButtonSendTypeFDF"),
                value: "FDF",
            });
            this._buttonSendTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiButtonSendTypeHTML"),
                value: "HTML",
            });
            this._buttonSendTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiButtonSendTypeXFDF"),
                value: "XFDF",
            });
            this._buttonSendTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiButtonSendTypePDF"),
                value: "PDF",
            });
        }
        return this._buttonSendTypes;
    }
    get barcodeTypes() {
        if (this._barcodeTypes.length === 0) {
            Enum.getValues(StiBarcodeType).forEach((t) => {
                let name = Enum.getName(StiBarcodeType, t);
                this._barcodeTypes.push({ name: name, value: name });
            });
        }
        return this._barcodeTypes;
    }
    get dateTimeTypes() {
        if (this._dateTimeTypes.length === 0) {
            this._dateTimeTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiDateTimeTypeDateAndTime"),
                value: "DateTime",
            });
            this._dateTimeTypes.push({ name: StiLocalizationService.get("FormFormatEditor", "Date"), value: "Date" });
            this._dateTimeTypes.push({ name: StiLocalizationService.get("FormFormatEditor", "Time"), value: "Time" });
        }
        return this._dateTimeTypes;
    }
    get penStyles() {
        if (this._penStyles.length === 0) {
            this._penStyles.push({ name: StiLocalizationService.get("PropertyEnum", "StiPenStyleSolid"), value: "Solid" });
            this._penStyles.push({ name: StiLocalizationService.get("PropertyEnum", "StiPenStyleDash"), value: "Dash" });
            this._penStyles.push({ name: StiLocalizationService.get("PropertyEnum", "StiPenStyleDot"), value: "Dot" });
        }
        return this._penStyles;
    }
    get dateTimeFormats() {
        if (this._dateTimeFormats.length === 0) {
            this._dateTimeFormats.push({ name: "m/d/yy h:MM tt", value: "m/d/yy h:MM tt" });
            this._dateTimeFormats.push({ name: "m/d/yyyy h:MM tt", value: "m/d/yyyy h:MM tt" });
            this._dateTimeFormats.push({ name: "m/d/yy HH:MM", value: "m/d/yy HH:MM" });
            this._dateTimeFormats.push({ name: "m/d/yyyy HH:MM", value: "m/d/yyyy HH:MM" });
            this._dateTimeFormats.push({ name: "m/d", value: "m/d" });
            this._dateTimeFormats.push({ name: "m/d/yy", value: "m/d/yy" });
            this._dateTimeFormats.push({ name: "m/d/yyyy", value: "m/d/yyyy" });
            this._dateTimeFormats.push({ name: "mm/dd/yy", value: "mm/dd/yy" });
            this._dateTimeFormats.push({ name: "mm/dd/yyyy", value: "mm/dd/yyyy" });
            this._dateTimeFormats.push({ name: "mm/yy", value: "mm/yy" });
            this._dateTimeFormats.push({ name: "mm/yyyy", value: "mm/yyyy" });
            this._dateTimeFormats.push({ name: "mmm-yy", value: "mmm-yy" });
            this._dateTimeFormats.push({ name: "mmm-yyyy", value: "mmm-yyyy" });
            this._dateTimeFormats.push({ name: "mmmm-yy", value: "mmmm-yy" });
            this._dateTimeFormats.push({ name: "mmmm-yyyy", value: "mmmm-yyyy" });
            this._dateTimeFormats.push({ name: "mmm d, yyyy", value: "mmm d, yyyy" });
            this._dateTimeFormats.push({ name: "mmmm d, yyyy", value: "mmmm d, yyyy" });
            this._dateTimeFormats.push({ name: "dd.mm.yyyy HH:MM", value: "dd.mm.yyyy HH:MM" });
            this._dateTimeFormats.push({ name: "d-mmm", value: "d-mmm" });
            this._dateTimeFormats.push({ name: "d-mmm-yy", value: "d-mmm-yy" });
            this._dateTimeFormats.push({ name: "d-mmm-yyyy", value: "d-mmm-yyyy" });
            this._dateTimeFormats.push({ name: "dd-mmm-yy", value: "dd-mmm-yy" });
            this._dateTimeFormats.push({ name: "dd-mmm-yyyy", value: "dd-mmm-yyyy" });
            this._dateTimeFormats.push({ name: "dd.mm.yyyy", value: "dd.mm.yyyy" });
            this._dateTimeFormats.push({ name: "yy-mm-dd", value: "yy-mm-dd" });
            this._dateTimeFormats.push({ name: "yyyy-mm-dd", value: "yyyy-mm-dd" });
            this._dateTimeFormats.push({ name: "HH:MM", value: "HH:MM" });
            this._dateTimeFormats.push({ name: "h:MM tt", value: "h:MM tt" });
            this._dateTimeFormats.push({ name: "HH:MM:ss", value: "HH:MM:ss" });
            this._dateTimeFormats.push({ name: "h:MM:ss tt", value: "h:MM:ss tt" });
        }
        return this._dateTimeFormats;
    }
    get dateFormats() {
        if (this._dateFormats.length === 0) {
            this._dateFormats.push({ name: "m/d", value: "m/d" });
            this._dateFormats.push({ name: "m/d/yy", value: "m/d/yy" });
            this._dateFormats.push({ name: "m/d/yyyy", value: "m/d/yyyy" });
            this._dateFormats.push({ name: "mm/dd/yy", value: "mm/dd/yy" });
            this._dateFormats.push({ name: "mm/dd/yyyy", value: "mm/dd/yyyy" });
            this._dateFormats.push({ name: "mm/yy", value: "mm/yy" });
            this._dateFormats.push({ name: "mm/yyyy", value: "mm/yyyy" });
            this._dateFormats.push({ name: "mmm-yy", value: "mmm-yy" });
            this._dateFormats.push({ name: "mmm-yyyy", value: "mmm-yyyy" });
            this._dateFormats.push({ name: "mmmm-yy", value: "mmmm-yy" });
            this._dateFormats.push({ name: "mmmm-yyyy", value: "mmmm-yyyy" });
            this._dateFormats.push({ name: "mmm d, yyyy", value: "mmm d, yyyy" });
            this._dateFormats.push({ name: "mmmm d, yyyy", value: "mmmm d, yyyy" });
            this._dateFormats.push({ name: "d-mmm", value: "d-mmm" });
            this._dateFormats.push({ name: "d-mmm-yy", value: "d-mmm-yy" });
            this._dateFormats.push({ name: "d-mmm-yyyy", value: "d-mmm-yyyy" });
            this._dateFormats.push({ name: "dd-mmm-yy", value: "dd-mmm-yy" });
            this._dateFormats.push({ name: "dd-mmm-yyyy", value: "dd-mmm-yyyy" });
            this._dateFormats.push({ name: "dd.mm.yyyy", value: "dd.mm.yyyy" });
            this._dateFormats.push({ name: "yy-mm-dd", value: "yy-mm-dd" });
            this._dateFormats.push({ name: "yyyy-mm-dd", value: "yyyy-mm-dd" });
        }
        return this._dateFormats;
    }
    get timeFormats() {
        if (this._timeFormats.length === 0) {
            this._timeFormats.push({ name: "HH:MM", value: "HH:MM" });
            this._timeFormats.push({ name: "h:MM tt", value: "h:MM tt" });
            this._timeFormats.push({ name: "HH:MM:ss", value: "HH:MM:ss" });
            this._timeFormats.push({ name: "h:MM:ss tt", value: "h:MM:ss tt" });
        }
        return this._timeFormats;
    }
    get signatureEditorModes() {
        if (this._signatureEditorModes.length === 0) {
            this._signatureEditorModes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiSignatureTypeType"),
                value: "Type",
            });
            this._signatureEditorModes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiSignatureTypeDraw"),
                value: "Draw",
            });
        }
        return this._signatureEditorModes;
    }
    get signatureSpecialFonts() {
        if (this._signatureSpecialFonts.length === 0) {
            this._signatureSpecialFonts.push({
                name: `${StiLocalizationService.get("PropertyMain", "Style")}${1}`,
                value: "Teddy Bear",
            });
            this._signatureSpecialFonts.push({
                name: `${StiLocalizationService.get("PropertyMain", "Style")}${2}`,
                value: "MADE Likes Script",
            });
            this._signatureSpecialFonts.push({
                name: `${StiLocalizationService.get("PropertyMain", "Style")}${3}`,
                value: "Denistina",
            });
        }
        return this._signatureSpecialFonts;
    }
    get dateTimeValues() {
        if (this._dateTimeValues.length === 0) {
            this._dateTimeValues.push({
                name: StiLocalizationService.get("Gui", "colorpickerdialog_currentcolorlabel"),
                value: "Current",
            });
            this._dateTimeValues.push({
                name: StiLocalizationService.get("PropertyEnum", "DateTimePickerFormatCustom"),
                value: "Custom",
            });
        }
        return this._dateTimeValues;
    }
    get themes() {
        if (this._themes.length === 0) {
            this._themes.push({ name: "Light" });
            this._themes.push({ name: "Dark" });
        }
        return this._themes;
    }
    get borderWeights() {
        if (this._borderWeights.length === 0) {
            this._borderWeights.push({
                name: StiLocalizationService.get("PropertyEnum", "StiLineWeightThin"),
                value: "Thin",
            });
            this._borderWeights.push({
                name: StiLocalizationService.get("PropertyEnum", "StiLineWeightNormal"),
                value: "Normal",
            });
            this._borderWeights.push({
                name: StiLocalizationService.get("PropertyEnum", "StiLineWeightThick"),
                value: "Thick",
            });
        }
        return this._borderWeights;
    }
    get unitAlignment() {
        if (this._unitAlignment.length === 0) {
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentPrefix"),
                value: 1,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentSuffix"),
                value: 2,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentPrefixInside"),
                value: 3,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentPrefixInsideWithSpace"),
                value: 4,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentSuffixInside"),
                value: 5,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentSuffixInsideWithSpace"),
                value: 6,
            });
        }
        return this._unitAlignment;
    }
    get minUnitAlignment() {
        if (this._minUnitAlignment.length === 0) {
            this._minUnitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentPrefix"),
                value: 1,
            });
            this._minUnitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentSuffix"),
                value: 2,
            });
        }
        return this._minUnitAlignment;
    }
    get labelFormat() {
        if (this._labelFormat.length === 0) {
            this._labelFormat.push({ name: "Symbol", value: 1 });
            this._labelFormat.push({ name: "Code", value: 2 });
        }
        return this._labelFormat;
    }
    get thousandSeparators() {
        if (this._thousandSeparators.length === 0) {
            this._thousandSeparators.push({ name: "1234567.89", value: "None" });
            this._thousandSeparators.push({ name: "1234567,89", value: "NoneComma" });
            this._thousandSeparators.push({ name: "1,234,567.89", value: "Comma" });
            this._thousandSeparators.push({ name: "1.234.567,89", value: "Dot" });
            this._thousandSeparators.push({ name: "1`234`567.89", value: "Apostrophe" });
        }
        return this._thousandSeparators;
    }
    updateHelper() {
        this._minUnitAlignment = [];
        this._unitAlignment = [];
        this._borderWeights = [];
        this._dateTimeValues = [];
        this._penStyles = [];
        this._dateTimeTypes = [];
        this._buttonSendTypes = [];
        this._buttonTypes = [];
        this._signatureTypes = [];
        this._numberTypes = [];
    }
    deleteSelectedComponent() {
        let fromPanel = true;
        if (this.model.selectedComponent) {
            let container = this.model.getElementPage(this.model.selectedComponent.element) ??
                this.model.getElementPanel(this.model.selectedComponent.element);
            container.elements.splice(container.elements.indexOf(this.model.selectedComponent.element), 1);
            this.render.removeElement(this.model.selectedComponent.element, container.elements);
            this.model.selectedComponent = null;
            this.model.formEvents.next({ name: "ComponentDeleted" });
            this.model.cursor = "default";
        }
    }
    getElementClass(type) {
        if (type == "TextElement" || type == "Text") {
            return StiTextElement;
        }
        else if (type == "Text_BoxElement" || type == "TextBox") {
            return StiTextBoxElement;
        }
        else if (type == "TableElement" || type == "Table") {
            return StiTableElement;
        }
        else if (type == "Single_SelectionElement" || type == "SingleSelection") {
            return StiSingleSelectionElement;
        }
        else if (type == "SignatureElement" || type == "Signature") {
            return StiSignatureElement;
        }
        else if (type == "PDFSignatureElement" || type == "PDFSignature") {
            return StiPDFSignatureElement;
        }
        else if (type == "PanelElement" || type == "Panel") {
            return StiPanelElement;
        }
        else if (type == "Number_BoxElement" || type == "NumberBox") {
            return StiNumberBoxElement;
        }
        else if (type == "Multiple_SelectionElement" || type == "MultipleSelection") {
            return StiMultipleSelectionElement;
        }
        else if (type == "List_BoxElement" || type == "ListBox") {
            return StiListBoxElement;
        }
        else if (type == "LineElement" || type == "Line") {
            return StiLineElement;
        }
        else if (type == "LabelElement" || type == "Label") {
            return StiLabelElement;
        }
        else if (type == "ImageElement" || type == "Image") {
            return StiImageElement;
        }
        else if (type == "DateTime_BoxElement" || type == "DateTimeBox") {
            return StiDateTimeBoxElement;
        }
        else if (type == "Combo_BoxElement" || type == "ComboBox") {
            return StiComboBoxElement;
        }
        else if (type == "Check_BoxElement" || type == "CheckBox") {
            return StiCheckBoxElement;
        }
        else if (type == "ButtonElement" || type == "Button") {
            return StiButtonElement;
        }
        else if (type == "BarCodeElement" || type == "BarCode") {
            return StiBarcodeElement;
        }
        else if (type == "AddressElement" || type == "Address") {
            return StiAddressElement;
        }
        else if (type == "Page") {
            return StiFormPageElement;
        }
        else if (type == "Form") {
            return StiForm;
        }
        // return this.pageElement.getElementTypes()[type] ?? StiPanelElement;
    }
    clone(element) {
        let clazz = this.getElementClass(element.type);
        let result = new clazz();
        let jObject = new StiJson();
        jObject.deserialize(element.saveToJsonObject({}).serialize());
        result.loadFromJsonObject(jObject);
        result.guid = Guid.newGuid().toString();
        if ("displayValue" in element) {
            result["displayValue"] = element["displayValue"];
        }
        if ("form" in element) {
            result["form"] = element["form"];
        }
        return result;
    }
    clonePage(page) {
        let result = new StiFormPageElement(page.form);
        let jObject = new StiJson();
        jObject.deserialize(page.saveToJsonObject({}).serialize());
        result.loadFromJsonObject(jObject);
        result.guid = Guid.newGuid().toString();
        result.form = page.form;
        return result;
    }
    get fileMenuItems() {
        if (this._fileMenuItems.length == 0) {
            this._fileMenuItems = [
                // { caption: StiLocalizationService.get("PropertyMain", "Info"), image: "assets/Images/Other/FileMenu/Home.png" },
                {
                    caption: StiLocalizationService.get("MainMenu", "menuFileNew").replace("&amp", "").replace(";", ""),
                    image: "images.Other.FileMenu.Report.png",
                    name: "New",
                },
                {
                    caption: StiLocalizationService.get("MainMenu", "menuFileOpen")
                        .replace("&amp", "")
                        .replace(";", "")
                        .replace("...", ""),
                    image: "images.Other.FileMenu.Folder.png",
                    name: "Open",
                },
                { name: "Divider" },
                {
                    caption: StiLocalizationService.get("MainMenu", "menuFileSave").replace("&amp", "").replace(";", ""),
                    name: "Save",
                },
                { caption: StiLocalizationService.get("MainMenu", "menuFileSaveAs").replace("...", ""), name: "SaveAs" },
                /*  { caption: StiLocalizationService.get("PropertyMain", "Share") },
                { caption: StiLocalizationService.get("PropertyMain", "Help") },
                { caption: StiLocalizationService.get("PropertyMain", "Close") }, */
                { name: "Divider" },
                /*  { caption: StiLocalizationService.get("PropertyMain", "Account") },
                { caption: StiLocalizationService.get("PropertyMain", "Options") }, */
                {
                    caption: StiLocalizationService.get("MainMenu", "menuHelpAboutProgramm")
                        .replace("&amp", "")
                        .replace(";", "")
                        .replace("...", ""),
                    name: "About",
                },
            ];
        }
        return this._fileMenuItems;
    }
    getAddTotalMenuItems() {
        let table = this.model.selectedComponent?.element;
        let this_ = this;
        if (!this.addTotalMenuItems && table?.columns?.length > 0) {
            this.addTotalMenuItems = [];
            let commands = [
                { name: this.loc.getP("Summary"), type: "Sum" },
                { name: this.loc.getP("Minimum"), type: "Min" },
                { name: this.loc.getP("Maximum"), type: "Max" },
                { name: this.loc.getP("Count"), type: "Count" },
            ];
            commands.forEach((command) => {
                let items = [];
                table.columns.forEach((column, index) => {
                    if (column instanceof StiNumberBoxColumnItem || column instanceof StiLabelColumnItem) {
                        items.push({
                            label: column.label?.length > 0 ? column.label : `${this.loc.get2("PropertyMain", "Column")} ${index + 1}`,
                            command: () => {
                                this_.zone.run(() => {
                                    table.totalsFields.push(new StiTotalsFieldItem(command.type, `{${command.type}(Col(${index + 1}))}`, this.model.form));
                                    this.model.showColumnPreview(table.totalsFields.length - 1, "totals");
                                });
                            },
                        });
                    }
                });
                if (items.length > 0) {
                    this.addTotalMenuItems.push({ label: command.name, items: items });
                }
            });
            let items = [];
            table.columns.forEach((column, index) => {
                let rowItems = [];
                table.rowLabels.forEach((rowLabel, rowIndex) => {
                    rowItems.push({
                        label: `Row ${rowIndex + 1}`,
                        command: () => {
                            this_.zone.run(() => {
                                table.totalsFields.push(new StiTotalsFieldItem("Cell", `{Cell(${index + 1}, ${rowIndex + 1})}`, this.model.form));
                                this.model.showColumnPreview(table.totalsFields.length - 1, "totals");
                            });
                        },
                    });
                });
                items.push({
                    label: column.label?.length > 0 ? column.label : `${this.loc.get2("PropertyMain", "Column")} ${index + 1}`,
                    items: rowItems,
                });
            });
            this.addTotalMenuItems.push({ label: this.loc.get2("PropertyCategory", "CellCategory"), items: items });
            this.addTotalMenuItems.push({
                label: this.loc.get2("Report", "StiEmptyBrush"),
                command: () => {
                    this_.zone.run(() => {
                        table.totalsFields.push(new StiTotalsFieldItem("", "", this.model.form));
                        this.model.showColumnPreview(table.totalsFields.length - 1, "totals");
                    });
                }
            });
        }
        return this.addTotalMenuItems;
    }
    base64Encode(input) {
        if (input == null)
            return "";
        // Decode from UTF-8 text
        if (typeof unescape != "undefined") {
            input = unescape(encodeURIComponent(input));
        }
        else {
            input = input.replace(/\r\n/g, "\n");
            var utftext = "";
            for (var n = 0; n < input.length; n++) {
                var c = input.charCodeAt(n);
                if (c < 128) {
                    utftext += String.fromCharCode(c);
                }
                else if (c > 127 && c < 2048) {
                    utftext += String.fromCharCode((c >> 6) | 192);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
                else {
                    utftext += String.fromCharCode((c >> 12) | 224);
                    utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
            }
            input = utftext;
        }
        // Encode to Base64 string
        if (typeof window.btoa != "undefined")
            return window.btoa(input);
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;
        while (i < input.length) {
            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);
            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;
            if (isNaN(chr2))
                enc3 = enc4 = 64;
            else if (isNaN(chr3))
                enc4 = 64;
            output =
                output +
                    this._keyStr.charAt(enc1) +
                    this._keyStr.charAt(enc2) +
                    this._keyStr.charAt(enc3) +
                    this._keyStr.charAt(enc4);
        }
        return output;
    }
    base64Decode(input) {
        if (input == null)
            return "";
        var output = "";
        // Decode from Base64 string
        if (typeof window.atob != "undefined") {
            output = window.atob(input);
        }
        else {
            var chr1, chr2, chr3;
            var enc1, enc2, enc3, enc4;
            var i = 0;
            input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
            while (i < input.length) {
                enc1 = this._keyStr.indexOf(input.charAt(i++));
                enc2 = this._keyStr.indexOf(input.charAt(i++));
                enc3 = this._keyStr.indexOf(input.charAt(i++));
                enc4 = this._keyStr.indexOf(input.charAt(i++));
                chr1 = (enc1 << 2) | (enc2 >> 4);
                chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                chr3 = ((enc3 & 3) << 6) | enc4;
                output = output + String.fromCharCode(chr1);
                if (enc3 != 64) {
                    output = output + String.fromCharCode(chr2);
                }
                if (enc4 != 64) {
                    output = output + String.fromCharCode(chr3);
                }
            }
        }
        // Encode to UTF-8 string
        if (typeof escape != "undefined")
            return decodeURIComponent(escape(output));
        var string = "";
        var i = 0;
        var c = 0;
        var c1 = 0;
        var c2 = 0;
        var c3 = 0;
        while (i < output.length) {
            c = output.charCodeAt(i);
            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            }
            else if (c > 191 && c < 224) {
                c2 = output.charCodeAt(i + 1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else {
                c2 = output.charCodeAt(i + 1);
                c3 = output.charCodeAt(i + 2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
        }
        return string;
    }
    get cultures() {
        if (this._cultures.length == 0)
            this._cultures = [
                {
                    "name": " ",
                    "value": ""
                },
                {
                    "name": "Afar (Djibouti)  (aa-DJ)",
                    "value": "aa-DJ"
                },
                {
                    "name": "Afar (Eritrea)  (aa-ER)",
                    "value": "aa-ER"
                },
                {
                    "name": "Afar (Ethiopia)  (aa-ET)",
                    "value": "aa-ET"
                },
                {
                    "name": "Afrikaans (Namibia)  (af-NA)",
                    "value": "af-NA"
                },
                {
                    "name": "Afrikaans (South Africa)  (af-ZA)",
                    "value": "af-ZA"
                },
                {
                    "name": "Aghem (Cameroon)  (agq-CM)",
                    "value": "agq-CM"
                },
                {
                    "name": "Akan (Ghana)  (ak-GH)",
                    "value": "ak-GH"
                },
                {
                    "name": "Albanian (Albania)  (sq-AL)",
                    "value": "sq-AL"
                },
                {
                    "name": "Albanian (Kosovo)  (sq-XK)",
                    "value": "sq-XK"
                },
                {
                    "name": "Albanian (North Macedonia)  (sq-MK)",
                    "value": "sq-MK"
                },
                {
                    "name": "Alsatian (France)  (gsw-FR)",
                    "value": "gsw-FR"
                },
                {
                    "name": "Alsatian (Liechtenstein)  (gsw-LI)",
                    "value": "gsw-LI"
                },
                {
                    "name": "Alsatian (Switzerland)  (gsw-CH)",
                    "value": "gsw-CH"
                },
                {
                    "name": "Amharic (Ethiopia)  (am-ET)",
                    "value": "am-ET"
                },
                {
                    "name": "Arabic (Algeria)  (ar-DZ)",
                    "value": "ar-DZ"
                },
                {
                    "name": "Arabic (Bahrain)  (ar-BH)",
                    "value": "ar-BH"
                },
                {
                    "name": "Arabic (Chad)  (ar-TD)",
                    "value": "ar-TD"
                },
                {
                    "name": "Arabic (Comoros)  (ar-KM)",
                    "value": "ar-KM"
                },
                {
                    "name": "Arabic (Djibouti)  (ar-DJ)",
                    "value": "ar-DJ"
                },
                {
                    "name": "Arabic (Egypt)  (ar-EG)",
                    "value": "ar-EG"
                },
                {
                    "name": "Arabic (Eritrea)  (ar-ER)",
                    "value": "ar-ER"
                },
                {
                    "name": "Arabic (Iraq)  (ar-IQ)",
                    "value": "ar-IQ"
                },
                {
                    "name": "Arabic (Israel)  (ar-IL)",
                    "value": "ar-IL"
                },
                {
                    "name": "Arabic (Jordan)  (ar-JO)",
                    "value": "ar-JO"
                },
                {
                    "name": "Arabic (Kuwait)  (ar-KW)",
                    "value": "ar-KW"
                },
                {
                    "name": "Arabic (Lebanon)  (ar-LB)",
                    "value": "ar-LB"
                },
                {
                    "name": "Arabic (Libya)  (ar-LY)",
                    "value": "ar-LY"
                },
                {
                    "name": "Arabic (Mauritania)  (ar-MR)",
                    "value": "ar-MR"
                },
                {
                    "name": "Arabic (Morocco)  (ar-MA)",
                    "value": "ar-MA"
                },
                {
                    "name": "Arabic (Oman)  (ar-OM)",
                    "value": "ar-OM"
                },
                {
                    "name": "Arabic (Palestinian Authority)  (ar-PS)",
                    "value": "ar-PS"
                },
                {
                    "name": "Arabic (Qatar)  (ar-QA)",
                    "value": "ar-QA"
                },
                {
                    "name": "Arabic (Saudi Arabia)  (ar-SA)",
                    "value": "ar-SA"
                },
                {
                    "name": "Arabic (Somalia)  (ar-SO)",
                    "value": "ar-SO"
                },
                {
                    "name": "Arabic (South Sudan)  (ar-SS)",
                    "value": "ar-SS"
                },
                {
                    "name": "Arabic (Sudan)  (ar-SD)",
                    "value": "ar-SD"
                },
                {
                    "name": "Arabic (Syria)  (ar-SY)",
                    "value": "ar-SY"
                },
                {
                    "name": "Arabic (Tunisia)  (ar-TN)",
                    "value": "ar-TN"
                },
                {
                    "name": "Arabic (U.A.E.)  (ar-AE)",
                    "value": "ar-AE"
                },
                {
                    "name": "Arabic (World)  (ar-001)",
                    "value": "ar-001"
                },
                {
                    "name": "Arabic (Yemen)  (ar-YE)",
                    "value": "ar-YE"
                },
                {
                    "name": "Armenian (Armenia)  (hy-AM)",
                    "value": "hy-AM"
                },
                {
                    "name": "Assamese (India)  (as-IN)",
                    "value": "as-IN"
                },
                {
                    "name": "Asturian (Spain)  (ast-ES)",
                    "value": "ast-ES"
                },
                {
                    "name": "Asu (Tanzania)  (asa-TZ)",
                    "value": "asa-TZ"
                },
                {
                    "name": "Azerbaijani (Cyrillic, Azerbaijan)  (az-Cyrl-AZ)",
                    "value": "az-Cyrl-AZ"
                },
                {
                    "name": "Azerbaijani (Latin, Azerbaijan)  (az-Latn-AZ)",
                    "value": "az-Latn-AZ"
                },
                {
                    "name": "Bafia (Cameroon)  (ksf-CM)",
                    "value": "ksf-CM"
                },
                {
                    "name": "Bambara (Latin, Mali)  (bm-Latn-ML)",
                    "value": "bm-Latn-ML"
                },
                {
                    "name": "Bangla (Bangladesh)  (bn-BD)",
                    "value": "bn-BD"
                },
                {
                    "name": "Bangla (India)  (bn-IN)",
                    "value": "bn-IN"
                },
                {
                    "name": "Basaa (Cameroon)  (bas-CM)",
                    "value": "bas-CM"
                },
                {
                    "name": "Bashkir (Russia)  (ba-RU)",
                    "value": "ba-RU"
                },
                {
                    "name": "Basque (Basque)  (eu-ES)",
                    "value": "eu-ES"
                },
                {
                    "name": "Belarusian (Belarus)  (be-BY)",
                    "value": "be-BY"
                },
                {
                    "name": "Bemba (Zambia)  (bem-ZM)",
                    "value": "bem-ZM"
                },
                {
                    "name": "Bena (Tanzania)  (bez-TZ)",
                    "value": "bez-TZ"
                },
                {
                    "name": "Blin (Eritrea)  (byn-ER)",
                    "value": "byn-ER"
                },
                {
                    "name": "Bodo (India)  (brx-IN)",
                    "value": "brx-IN"
                },
                {
                    "name": "Bosnian (Cyrillic, Bosnia and Herzegovina)  (bs-Cyrl-BA)",
                    "value": "bs-Cyrl-BA"
                },
                {
                    "name": "Bosnian (Latin, Bosnia and Herzegovina)  (bs-Latn-BA)",
                    "value": "bs-Latn-BA"
                },
                {
                    "name": "Breton (France)  (br-FR)",
                    "value": "br-FR"
                },
                {
                    "name": "Bulgarian (Bulgaria)  (bg-BG)",
                    "value": "bg-BG"
                },
                {
                    "name": "Burmese (Myanmar)  (my-MM)",
                    "value": "my-MM"
                },
                {
                    "name": "Catalan (Andorra)  (ca-AD)",
                    "value": "ca-AD"
                },
                {
                    "name": "Catalan (Catalan)  (ca-ES)",
                    "value": "ca-ES"
                },
                {
                    "name": "Catalan (France)  (ca-FR)",
                    "value": "ca-FR"
                },
                {
                    "name": "Catalan (Italy)  (ca-IT)",
                    "value": "ca-IT"
                },
                {
                    "name": "Cebuano (Latin, Philippines)  (ceb-Latn-PH)",
                    "value": "ceb-Latn-PH"
                },
                {
                    "name": "Central Atlas Tamazight (Arabic, Morocco)  (tzm-Arab-MA)",
                    "value": "tzm-Arab-MA"
                },
                {
                    "name": "Central Atlas Tamazight (Latin, Morocco)  (tzm-Latn-MA)",
                    "value": "tzm-Latn-MA"
                },
                {
                    "name": "Central Atlas Tamazight (Tifinagh, Morocco)  (tzm-Tfng-MA)",
                    "value": "tzm-Tfng-MA"
                },
                {
                    "name": "Central Kurdish (Iraq)  (ku-Arab-IQ)",
                    "value": "ku-Arab-IQ"
                },
                {
                    "name": "Chakma (Chakma, Bangladesh)  (ccp-Cakm-BD)",
                    "value": "ccp-Cakm-BD"
                },
                {
                    "name": "Chakma (Chakma, India)  (ccp-Cakm-IN)",
                    "value": "ccp-Cakm-IN"
                },
                {
                    "name": "Chechen (Russia)  (ce-RU)",
                    "value": "ce-RU"
                },
                {
                    "name": "Cherokee (Cherokee)  (chr-Cher-US)",
                    "value": "chr-Cher-US"
                },
                {
                    "name": "Chiga (Uganda)  (cgg-UG)",
                    "value": "cgg-UG"
                },
                {
                    "name": "Chinese (Simplified Han, Hong Kong SAR)  (zh-Hans-HK)",
                    "value": "zh-Hans-HK"
                },
                {
                    "name": "Chinese (Simplified Han, Macao SAR)  (zh-Hans-MO)",
                    "value": "zh-Hans-MO"
                },
                {
                    "name": "Chinese (Simplified, PRC)  (zh-CN)",
                    "value": "zh-CN"
                },
                {
                    "name": "Chinese (Simplified, Singapore)  (zh-SG)",
                    "value": "zh-SG"
                },
                {
                    "name": "Chinese (Traditional, Hong Kong S.A.R.)  (zh-HK)",
                    "value": "zh-HK"
                },
                {
                    "name": "Chinese (Traditional, Macao S.A.R.)  (zh-MO)",
                    "value": "zh-MO"
                },
                {
                    "name": "Chinese (Traditional, Taiwan)  (zh-TW)",
                    "value": "zh-TW"
                },
                {
                    "name": "Church Slavic (Russia)  (cu-RU)",
                    "value": "cu-RU"
                },
                {
                    "name": "Cornish (United Kingdom)  (kw-GB)",
                    "value": "kw-GB"
                },
                {
                    "name": "Corsican (France)  (co-FR)",
                    "value": "co-FR"
                },
                {
                    "name": "Croatian (Croatia)  (hr-HR)",
                    "value": "hr-HR"
                },
                {
                    "name": "Croatian (Latin, Bosnia and Herzegovina)  (hr-BA)",
                    "value": "hr-BA"
                },
                {
                    "name": "Czech (Czech Republic)  (cs-CZ)",
                    "value": "cs-CZ"
                },
                {
                    "name": "Danish (Denmark)  (da-DK)",
                    "value": "da-DK"
                },
                {
                    "name": "Danish (Greenland)  (da-GL)",
                    "value": "da-GL"
                },
                {
                    "name": "Dari (Afghanistan)  (prs-AF)",
                    "value": "prs-AF"
                },
                {
                    "name": "Divehi (Maldives)  (dv-MV)",
                    "value": "dv-MV"
                },
                {
                    "name": "Duala (Cameroon)  (dua-CM)",
                    "value": "dua-CM"
                },
                {
                    "name": "Dutch (Aruba)  (nl-AW)",
                    "value": "nl-AW"
                },
                {
                    "name": "Dutch (Belgium)  (nl-BE)",
                    "value": "nl-BE"
                },
                {
                    "name": "Dutch (Bonaire, Sint Eustatius and Saba)  (nl-BQ)",
                    "value": "nl-BQ"
                },
                {
                    "name": "Dutch (Curaçao)  (nl-CW)",
                    "value": "nl-CW"
                },
                {
                    "name": "Dutch (Netherlands)  (nl-NL)",
                    "value": "nl-NL"
                },
                {
                    "name": "Dutch (Sint Maarten)  (nl-SX)",
                    "value": "nl-SX"
                },
                {
                    "name": "Dutch (Suriname)  (nl-SR)",
                    "value": "nl-SR"
                },
                {
                    "name": "Dzongkha (Bhutan)  (dz-BT)",
                    "value": "dz-BT"
                },
                {
                    "name": "Edo (Nigeria)  (bin-NG)",
                    "value": "bin-NG"
                },
                {
                    "name": "Embu (Kenya)  (ebu-KE)",
                    "value": "ebu-KE"
                },
                {
                    "name": "English (American Samoa)  (en-AS)",
                    "value": "en-AS"
                },
                {
                    "name": "English (Anguilla)  (en-AI)",
                    "value": "en-AI"
                },
                {
                    "name": "English (Antigua and Barbuda)  (en-AG)",
                    "value": "en-AG"
                },
                {
                    "name": "English (Australia)  (en-AU)",
                    "value": "en-AU"
                },
                {
                    "name": "English (Austria)  (en-AT)",
                    "value": "en-AT"
                },
                {
                    "name": "English (Bahamas)  (en-BS)",
                    "value": "en-BS"
                },
                {
                    "name": "English (Barbados)  (en-BB)",
                    "value": "en-BB"
                },
                {
                    "name": "English (Belgium)  (en-BE)",
                    "value": "en-BE"
                },
                {
                    "name": "English (Belize)  (en-BZ)",
                    "value": "en-BZ"
                },
                {
                    "name": "English (Bermuda)  (en-BM)",
                    "value": "en-BM"
                },
                {
                    "name": "English (Botswana)  (en-BW)",
                    "value": "en-BW"
                },
                {
                    "name": "English (British Indian Ocean Territory)  (en-IO)",
                    "value": "en-IO"
                },
                {
                    "name": "English (British Virgin Islands)  (en-VG)",
                    "value": "en-VG"
                },
                {
                    "name": "English (Burundi)  (en-BI)",
                    "value": "en-BI"
                },
                {
                    "name": "English (Cameroon)  (en-CM)",
                    "value": "en-CM"
                },
                {
                    "name": "English (Canada)  (en-CA)",
                    "value": "en-CA"
                },
                {
                    "name": "English (Caribbean)  (en-029)",
                    "value": "en-029"
                },
                {
                    "name": "English (Cayman Islands)  (en-KY)",
                    "value": "en-KY"
                },
                {
                    "name": "English (Christmas Island)  (en-CX)",
                    "value": "en-CX"
                },
                {
                    "name": "English (Cocos [Keeling] Islands)  (en-CC)",
                    "value": "en-CC"
                },
                {
                    "name": "English (Cook Islands)  (en-CK)",
                    "value": "en-CK"
                },
                {
                    "name": "English (Cyprus)  (en-CY)",
                    "value": "en-CY"
                },
                {
                    "name": "English (Denmark)  (en-DK)",
                    "value": "en-DK"
                },
                {
                    "name": "English (Dominica)  (en-DM)",
                    "value": "en-DM"
                },
                {
                    "name": "English (Eritrea)  (en-ER)",
                    "value": "en-ER"
                },
                {
                    "name": "English (Europe)  (en-150)",
                    "value": "en-150"
                },
                {
                    "name": "English (Falkland Islands)  (en-FK)",
                    "value": "en-FK"
                },
                {
                    "name": "English (Fiji)  (en-FJ)",
                    "value": "en-FJ"
                },
                {
                    "name": "English (Finland)  (en-FI)",
                    "value": "en-FI"
                },
                {
                    "name": "English (Gambia)  (en-GM)",
                    "value": "en-GM"
                },
                {
                    "name": "English (Germany)  (en-DE)",
                    "value": "en-DE"
                },
                {
                    "name": "English (Ghana)  (en-GH)",
                    "value": "en-GH"
                },
                {
                    "name": "English (Gibraltar)  (en-GI)",
                    "value": "en-GI"
                },
                {
                    "name": "English (Grenada)  (en-GD)",
                    "value": "en-GD"
                },
                {
                    "name": "English (Guam)  (en-GU)",
                    "value": "en-GU"
                },
                {
                    "name": "English (Guernsey)  (en-GG)",
                    "value": "en-GG"
                },
                {
                    "name": "English (Guyana)  (en-GY)",
                    "value": "en-GY"
                },
                {
                    "name": "English (Hong Kong SAR)  (en-HK)",
                    "value": "en-HK"
                },
                {
                    "name": "English (India)  (en-IN)",
                    "value": "en-IN"
                },
                {
                    "name": "English (Indonesia)  (en-ID)",
                    "value": "en-ID"
                },
                {
                    "name": "English (Ireland)  (en-IE)",
                    "value": "en-IE"
                },
                {
                    "name": "English (Isle of Man)  (en-IM)",
                    "value": "en-IM"
                },
                {
                    "name": "English (Israel)  (en-IL)",
                    "value": "en-IL"
                },
                {
                    "name": "English (Jamaica)  (en-JM)",
                    "value": "en-JM"
                },
                {
                    "name": "English (Jersey)  (en-JE)",
                    "value": "en-JE"
                },
                {
                    "name": "English (Kenya)  (en-KE)",
                    "value": "en-KE"
                },
                {
                    "name": "English (Kiribati)  (en-KI)",
                    "value": "en-KI"
                },
                {
                    "name": "English (Lesotho)  (en-LS)",
                    "value": "en-LS"
                },
                {
                    "name": "English (Liberia)  (en-LR)",
                    "value": "en-LR"
                },
                {
                    "name": "English (Macao SAR)  (en-MO)",
                    "value": "en-MO"
                },
                {
                    "name": "English (Madagascar)  (en-MG)",
                    "value": "en-MG"
                },
                {
                    "name": "English (Malawi)  (en-MW)",
                    "value": "en-MW"
                },
                {
                    "name": "English (Malaysia)  (en-MY)",
                    "value": "en-MY"
                },
                {
                    "name": "English (Malta)  (en-MT)",
                    "value": "en-MT"
                },
                {
                    "name": "English (Marshall Islands)  (en-MH)",
                    "value": "en-MH"
                },
                {
                    "name": "English (Mauritius)  (en-MU)",
                    "value": "en-MU"
                },
                {
                    "name": "English (Micronesia)  (en-FM)",
                    "value": "en-FM"
                },
                {
                    "name": "English (Montserrat)  (en-MS)",
                    "value": "en-MS"
                },
                {
                    "name": "English (Namibia)  (en-NA)",
                    "value": "en-NA"
                },
                {
                    "name": "English (Nauru)  (en-NR)",
                    "value": "en-NR"
                },
                {
                    "name": "English (Netherlands)  (en-NL)",
                    "value": "en-NL"
                },
                {
                    "name": "English (New Zealand)  (en-NZ)",
                    "value": "en-NZ"
                },
                {
                    "name": "English (Nigeria)  (en-NG)",
                    "value": "en-NG"
                },
                {
                    "name": "English (Niue)  (en-NU)",
                    "value": "en-NU"
                },
                {
                    "name": "English (Norfolk Island)  (en-NF)",
                    "value": "en-NF"
                },
                {
                    "name": "English (Northern Mariana Islands)  (en-MP)",
                    "value": "en-MP"
                },
                {
                    "name": "English (Pakistan)  (en-PK)",
                    "value": "en-PK"
                },
                {
                    "name": "English (Palau)  (en-PW)",
                    "value": "en-PW"
                },
                {
                    "name": "English (Papua New Guinea)  (en-PG)",
                    "value": "en-PG"
                },
                {
                    "name": "English (Pitcairn Islands)  (en-PN)",
                    "value": "en-PN"
                },
                {
                    "name": "English (Puerto Rico)  (en-PR)",
                    "value": "en-PR"
                },
                {
                    "name": "English (Republic of the Philippines)  (en-PH)",
                    "value": "en-PH"
                },
                {
                    "name": "English (Rwanda)  (en-RW)",
                    "value": "en-RW"
                },
                {
                    "name": "English (Saint Kitts and Nevis)  (en-KN)",
                    "value": "en-KN"
                },
                {
                    "name": "English (Saint Lucia)  (en-LC)",
                    "value": "en-LC"
                },
                {
                    "name": "English (Saint Vincent and the Grenadines)  (en-VC)",
                    "value": "en-VC"
                },
                {
                    "name": "English (Samoa)  (en-WS)",
                    "value": "en-WS"
                },
                {
                    "name": "English (Seychelles)  (en-SC)",
                    "value": "en-SC"
                },
                {
                    "name": "English (Sierra Leone)  (en-SL)",
                    "value": "en-SL"
                },
                {
                    "name": "English (Singapore)  (en-SG)",
                    "value": "en-SG"
                },
                {
                    "name": "English (Sint Maarten)  (en-SX)",
                    "value": "en-SX"
                },
                {
                    "name": "English (Slovenia)  (en-SI)",
                    "value": "en-SI"
                },
                {
                    "name": "English (Solomon Islands)  (en-SB)",
                    "value": "en-SB"
                },
                {
                    "name": "English (South Africa)  (en-ZA)",
                    "value": "en-ZA"
                },
                {
                    "name": "English (South Sudan)  (en-SS)",
                    "value": "en-SS"
                },
                {
                    "name": "English (St Helena, Ascension, Tristan da Cunha)  (en-SH)",
                    "value": "en-SH"
                },
                {
                    "name": "English (Sudan)  (en-SD)",
                    "value": "en-SD"
                },
                {
                    "name": "English (Swaziland)  (en-SZ)",
                    "value": "en-SZ"
                },
                {
                    "name": "English (Sweden)  (en-SE)",
                    "value": "en-SE"
                },
                {
                    "name": "English (Switzerland)  (en-CH)",
                    "value": "en-CH"
                },
                {
                    "name": "English (Tanzania)  (en-TZ)",
                    "value": "en-TZ"
                },
                {
                    "name": "English (Tokelau)  (en-TK)",
                    "value": "en-TK"
                },
                {
                    "name": "English (Tonga)  (en-TO)",
                    "value": "en-TO"
                },
                {
                    "name": "English (Trinidad and Tobago)  (en-TT)",
                    "value": "en-TT"
                },
                {
                    "name": "English (Turks and Caicos Islands)  (en-TC)",
                    "value": "en-TC"
                },
                {
                    "name": "English (Tuvalu)  (en-TV)",
                    "value": "en-TV"
                },
                {
                    "name": "English (Uganda)  (en-UG)",
                    "value": "en-UG"
                },
                {
                    "name": "English (United Arab Emirates)  (en-AE)",
                    "value": "en-AE"
                },
                {
                    "name": "English (United Kingdom)  (en-GB)",
                    "value": "en-GB"
                },
                {
                    "name": "English (United States)  (en-US)",
                    "value": "en-US"
                },
                {
                    "name": "English (US Minor Outlying Islands)  (en-UM)",
                    "value": "en-UM"
                },
                {
                    "name": "English (US Virgin Islands)  (en-VI)",
                    "value": "en-VI"
                },
                {
                    "name": "English (Vanuatu)  (en-VU)",
                    "value": "en-VU"
                },
                {
                    "name": "English (World)  (en-001)",
                    "value": "en-001"
                },
                {
                    "name": "English (Zambia)  (en-ZM)",
                    "value": "en-ZM"
                },
                {
                    "name": "English (Zimbabwe)  (en-ZW)",
                    "value": "en-ZW"
                },
                {
                    "name": "Esperanto (World)  (eo-001)",
                    "value": "eo-001"
                },
                {
                    "name": "Estonian (Estonia)  (et-EE)",
                    "value": "et-EE"
                },
                {
                    "name": "Ewe (Ghana)  (ee-GH)",
                    "value": "ee-GH"
                },
                {
                    "name": "Ewe (Togo)  (ee-TG)",
                    "value": "ee-TG"
                },
                {
                    "name": "Ewondo (Cameroon)  (ewo-CM)",
                    "value": "ewo-CM"
                },
                {
                    "name": "Faroese (Denmark)  (fo-DK)",
                    "value": "fo-DK"
                },
                {
                    "name": "Faroese (Faroe Islands)  (fo-FO)",
                    "value": "fo-FO"
                },
                {
                    "name": "Filipino (Philippines)  (fil-PH)",
                    "value": "fil-PH"
                },
                {
                    "name": "Finnish (Finland)  (fi-FI)",
                    "value": "fi-FI"
                },
                {
                    "name": "French (Algeria)  (fr-DZ)",
                    "value": "fr-DZ"
                },
                {
                    "name": "French (Belgium)  (fr-BE)",
                    "value": "fr-BE"
                },
                {
                    "name": "French (Benin)  (fr-BJ)",
                    "value": "fr-BJ"
                },
                {
                    "name": "French (Burkina Faso)  (fr-BF)",
                    "value": "fr-BF"
                },
                {
                    "name": "French (Burundi)  (fr-BI)",
                    "value": "fr-BI"
                },
                {
                    "name": "French (Cameroon)  (fr-CM)",
                    "value": "fr-CM"
                },
                {
                    "name": "French (Canada)  (fr-CA)",
                    "value": "fr-CA"
                },
                {
                    "name": "French (Caribbean)  (fr-029)",
                    "value": "fr-029"
                },
                {
                    "name": "French (Central African Republic)  (fr-CF)",
                    "value": "fr-CF"
                },
                {
                    "name": "French (Chad)  (fr-TD)",
                    "value": "fr-TD"
                },
                {
                    "name": "French (Comoros)  (fr-KM)",
                    "value": "fr-KM"
                },
                {
                    "name": "French (Congo DRC)  (fr-CD)",
                    "value": "fr-CD"
                },
                {
                    "name": "French (Congo)  (fr-CG)",
                    "value": "fr-CG"
                },
                {
                    "name": "French (Côte d’Ivoire)  (fr-CI)",
                    "value": "fr-CI"
                },
                {
                    "name": "French (Djibouti)  (fr-DJ)",
                    "value": "fr-DJ"
                },
                {
                    "name": "French (Equatorial Guinea)  (fr-GQ)",
                    "value": "fr-GQ"
                },
                {
                    "name": "French (France)  (fr-FR)",
                    "value": "fr-FR"
                },
                {
                    "name": "French (French Guiana)  (fr-GF)",
                    "value": "fr-GF"
                },
                {
                    "name": "French (French Polynesia)  (fr-PF)",
                    "value": "fr-PF"
                },
                {
                    "name": "French (Gabon)  (fr-GA)",
                    "value": "fr-GA"
                },
                {
                    "name": "French (Guadeloupe)  (fr-GP)",
                    "value": "fr-GP"
                },
                {
                    "name": "French (Guinea)  (fr-GN)",
                    "value": "fr-GN"
                },
                {
                    "name": "French (Haiti)  (fr-HT)",
                    "value": "fr-HT"
                },
                {
                    "name": "French (Luxembourg)  (fr-LU)",
                    "value": "fr-LU"
                },
                {
                    "name": "French (Madagascar)  (fr-MG)",
                    "value": "fr-MG"
                },
                {
                    "name": "French (Mali)  (fr-ML)",
                    "value": "fr-ML"
                },
                {
                    "name": "French (Martinique)  (fr-MQ)",
                    "value": "fr-MQ"
                },
                {
                    "name": "French (Mauritania)  (fr-MR)",
                    "value": "fr-MR"
                },
                {
                    "name": "French (Mauritius)  (fr-MU)",
                    "value": "fr-MU"
                },
                {
                    "name": "French (Mayotte)  (fr-YT)",
                    "value": "fr-YT"
                },
                {
                    "name": "French (Monaco)  (fr-MC)",
                    "value": "fr-MC"
                },
                {
                    "name": "French (Morocco)  (fr-MA)",
                    "value": "fr-MA"
                },
                {
                    "name": "French (New Caledonia)  (fr-NC)",
                    "value": "fr-NC"
                },
                {
                    "name": "French (Niger)  (fr-NE)",
                    "value": "fr-NE"
                },
                {
                    "name": "French (Reunion)  (fr-RE)",
                    "value": "fr-RE"
                },
                {
                    "name": "French (Rwanda)  (fr-RW)",
                    "value": "fr-RW"
                },
                {
                    "name": "French (Saint Barthélemy)  (fr-BL)",
                    "value": "fr-BL"
                },
                {
                    "name": "French (Saint Martin)  (fr-MF)",
                    "value": "fr-MF"
                },
                {
                    "name": "French (Saint Pierre and Miquelon)  (fr-PM)",
                    "value": "fr-PM"
                },
                {
                    "name": "French (Senegal)  (fr-SN)",
                    "value": "fr-SN"
                },
                {
                    "name": "French (Seychelles)  (fr-SC)",
                    "value": "fr-SC"
                },
                {
                    "name": "French (Switzerland)  (fr-CH)",
                    "value": "fr-CH"
                },
                {
                    "name": "French (Syria)  (fr-SY)",
                    "value": "fr-SY"
                },
                {
                    "name": "French (Togo)  (fr-TG)",
                    "value": "fr-TG"
                },
                {
                    "name": "French (Tunisia)  (fr-TN)",
                    "value": "fr-TN"
                },
                {
                    "name": "French (Vanuatu)  (fr-VU)",
                    "value": "fr-VU"
                },
                {
                    "name": "French (Wallis and Futuna)  (fr-WF)",
                    "value": "fr-WF"
                },
                {
                    "name": "Frisian (Netherlands)  (fy-NL)",
                    "value": "fy-NL"
                },
                {
                    "name": "Friulian (Italy)  (fur-IT)",
                    "value": "fur-IT"
                },
                {
                    "name": "Fulah (Latin, Burkina Faso)  (ff-Latn-BF)",
                    "value": "ff-Latn-BF"
                },
                {
                    "name": "Fulah (Latin, Cameroon)  (ff-Latn-CM)",
                    "value": "ff-Latn-CM"
                },
                {
                    "name": "Fulah (Latin, Gambia)  (ff-Latn-GM)",
                    "value": "ff-Latn-GM"
                },
                {
                    "name": "Fulah (Latin, Ghana)  (ff-Latn-GH)",
                    "value": "ff-Latn-GH"
                },
                {
                    "name": "Fulah (Latin, Guinea)  (ff-Latn-GN)",
                    "value": "ff-Latn-GN"
                },
                {
                    "name": "Fulah (Latin, Guinea-Bissau)  (ff-Latn-GW)",
                    "value": "ff-Latn-GW"
                },
                {
                    "name": "Fulah (Latin, Liberia)  (ff-Latn-LR)",
                    "value": "ff-Latn-LR"
                },
                {
                    "name": "Fulah (Latin, Mauritania)  (ff-Latn-MR)",
                    "value": "ff-Latn-MR"
                },
                {
                    "name": "Fulah (Latin, Niger)  (ff-Latn-NE)",
                    "value": "ff-Latn-NE"
                },
                {
                    "name": "Fulah (Latin, Nigeria)  (ff-Latn-NG)",
                    "value": "ff-Latn-NG"
                },
                {
                    "name": "Fulah (Latin, Senegal)  (ff-Latn-SN)",
                    "value": "ff-Latn-SN"
                },
                {
                    "name": "Fulah (Latin, Sierra Leone)  (ff-Latn-SL)",
                    "value": "ff-Latn-SL"
                },
                {
                    "name": "Galician (Galician)  (gl-ES)",
                    "value": "gl-ES"
                },
                {
                    "name": "Ganda (Uganda)  (lg-UG)",
                    "value": "lg-UG"
                },
                {
                    "name": "Georgian (Georgia)  (ka-GE)",
                    "value": "ka-GE"
                },
                {
                    "name": "German (Austria)  (de-AT)",
                    "value": "de-AT"
                },
                {
                    "name": "German (Belgium)  (de-BE)",
                    "value": "de-BE"
                },
                {
                    "name": "German (Germany)  (de-DE)",
                    "value": "de-DE"
                },
                {
                    "name": "German (Italy)  (de-IT)",
                    "value": "de-IT"
                },
                {
                    "name": "German (Liechtenstein)  (de-LI)",
                    "value": "de-LI"
                },
                {
                    "name": "German (Luxembourg)  (de-LU)",
                    "value": "de-LU"
                },
                {
                    "name": "German (Switzerland)  (de-CH)",
                    "value": "de-CH"
                },
                {
                    "name": "Greek (Cyprus)  (el-CY)",
                    "value": "el-CY"
                },
                {
                    "name": "Greek (Greece)  (el-GR)",
                    "value": "el-GR"
                },
                {
                    "name": "Greenlandic (Greenland)  (kl-GL)",
                    "value": "kl-GL"
                },
                {
                    "name": "Guarani (Paraguay)  (gn-PY)",
                    "value": "gn-PY"
                },
                {
                    "name": "Gujarati (India)  (gu-IN)",
                    "value": "gu-IN"
                },
                {
                    "name": "Gusii (Kenya)  (guz-KE)",
                    "value": "guz-KE"
                },
                {
                    "name": "Hausa (Latin, Ghana)  (ha-Latn-GH)",
                    "value": "ha-Latn-GH"
                },
                {
                    "name": "Hausa (Latin, Niger)  (ha-Latn-NE)",
                    "value": "ha-Latn-NE"
                },
                {
                    "name": "Hausa (Latin, Nigeria)  (ha-Latn-NG)",
                    "value": "ha-Latn-NG"
                },
                {
                    "name": "Hawaiian (United States)  (haw-US)",
                    "value": "haw-US"
                },
                {
                    "name": "Hebrew (Israel)  (he-IL)",
                    "value": "he-IL"
                },
                {
                    "name": "Hindi (India)  (hi-IN)",
                    "value": "hi-IN"
                },
                {
                    "name": "Hungarian (Hungary)  (hu-HU)",
                    "value": "hu-HU"
                },
                {
                    "name": "Ibibio (Nigeria)  (ibb-NG)",
                    "value": "ibb-NG"
                },
                {
                    "name": "Icelandic (Iceland)  (is-IS)",
                    "value": "is-IS"
                },
                {
                    "name": "Igbo (Nigeria)  (ig-NG)",
                    "value": "ig-NG"
                },
                {
                    "name": "Indonesian (Indonesia)  (id-ID)",
                    "value": "id-ID"
                },
                {
                    "name": "Interlingua (World)  (ia-001)",
                    "value": "ia-001"
                },
                {
                    "name": "Inuktitut (Latin, Canada)  (iu-Latn-CA)",
                    "value": "iu-Latn-CA"
                },
                {
                    "name": "Inuktitut (Syllabics, Canada)  (iu-Cans-CA)",
                    "value": "iu-Cans-CA"
                },
                {
                    "name": "Irish (Ireland)  (ga-IE)",
                    "value": "ga-IE"
                },
                {
                    "name": "isiXhosa (South Africa)  (xh-ZA)",
                    "value": "xh-ZA"
                },
                {
                    "name": "isiZulu (South Africa)  (zu-ZA)",
                    "value": "zu-ZA"
                },
                {
                    "name": "Italian (Italy)  (it-IT)",
                    "value": "it-IT"
                },
                {
                    "name": "Italian (San Marino)  (it-SM)",
                    "value": "it-SM"
                },
                {
                    "name": "Italian (Switzerland)  (it-CH)",
                    "value": "it-CH"
                },
                {
                    "name": "Italian (Vatican City)  (it-VA)",
                    "value": "it-VA"
                },
                {
                    "name": "Japanese (Japan)  (ja-JP)",
                    "value": "ja-JP"
                },
                {
                    "name": "Javanese (Indonesia)  (jv-Latn-ID)",
                    "value": "jv-Latn-ID"
                },
                {
                    "name": "Javanese (Javanese, Indonesia)  (jv-Java-ID)",
                    "value": "jv-Java-ID"
                },
                {
                    "name": "Jola-Fonyi (Senegal)  (dyo-SN)",
                    "value": "dyo-SN"
                },
                {
                    "name": "Kabuverdianu (Cabo Verde)  (kea-CV)",
                    "value": "kea-CV"
                },
                {
                    "name": "Kabyle (Algeria)  (kab-DZ)",
                    "value": "kab-DZ"
                },
                {
                    "name": "Kako (Cameroon)  (kkj-CM)",
                    "value": "kkj-CM"
                },
                {
                    "name": "Kalenjin (Kenya)  (kln-KE)",
                    "value": "kln-KE"
                },
                {
                    "name": "Kamba (Kenya)  (kam-KE)",
                    "value": "kam-KE"
                },
                {
                    "name": "Kannada (India)  (kn-IN)",
                    "value": "kn-IN"
                },
                {
                    "name": "Kanuri (Nigeria)  (kr-Latn-NG)",
                    "value": "kr-Latn-NG"
                },
                {
                    "name": "Kashmiri (Devanagari, India)  (ks-Deva-IN)",
                    "value": "ks-Deva-IN"
                },
                {
                    "name": "Kashmiri (Perso-Arabic)  (ks-Arab-IN)",
                    "value": "ks-Arab-IN"
                },
                {
                    "name": "Kazakh (Kazakhstan)  (kk-KZ)",
                    "value": "kk-KZ"
                },
                {
                    "name": "Khmer (Cambodia)  (km-KH)",
                    "value": "km-KH"
                },
                {
                    "name": "K'iche' (Guatemala)  (quc-Latn-GT)",
                    "value": "quc-Latn-GT"
                },
                {
                    "name": "Kikuyu (Kenya)  (ki-KE)",
                    "value": "ki-KE"
                },
                {
                    "name": "Kinyarwanda (Rwanda)  (rw-RW)",
                    "value": "rw-RW"
                },
                {
                    "name": "Kiswahili (Congo DRC)  (sw-CD)",
                    "value": "sw-CD"
                },
                {
                    "name": "Kiswahili (Kenya)  (sw-KE)",
                    "value": "sw-KE"
                },
                {
                    "name": "Kiswahili (Tanzania)  (sw-TZ)",
                    "value": "sw-TZ"
                },
                {
                    "name": "Kiswahili (Uganda)  (sw-UG)",
                    "value": "sw-UG"
                },
                {
                    "name": "Konkani (India)  (kok-IN)",
                    "value": "kok-IN"
                },
                {
                    "name": "Korean (Korea)  (ko-KR)",
                    "value": "ko-KR"
                },
                {
                    "name": "Korean (North Korea)  (ko-KP)",
                    "value": "ko-KP"
                },
                {
                    "name": "Koyra Chiini (Mali)  (khq-ML)",
                    "value": "khq-ML"
                },
                {
                    "name": "Koyraboro Senni (Mali)  (ses-ML)",
                    "value": "ses-ML"
                },
                {
                    "name": "Kurdish (Perso-Arabic, Iran)  (ku-Arab-IR)",
                    "value": "ku-Arab-IR"
                },
                {
                    "name": "Kwasio (Cameroon)  (nmg-CM)",
                    "value": "nmg-CM"
                },
                {
                    "name": "Kyrgyz (Kyrgyzstan)  (ky-KG)",
                    "value": "ky-KG"
                },
                {
                    "name": "Lakota (United States)  (lkt-US)",
                    "value": "lkt-US"
                },
                {
                    "name": "Langi (Tanzania)  (lag-TZ)",
                    "value": "lag-TZ"
                },
                {
                    "name": "Lao (Lao P.D.R.)  (lo-LA)",
                    "value": "lo-LA"
                },
                {
                    "name": "Latin (World)  (la-001)",
                    "value": "la-001"
                },
                {
                    "name": "Latvian (Latvia)  (lv-LV)",
                    "value": "lv-LV"
                },
                {
                    "name": "Lingala (Angola)  (ln-AO)",
                    "value": "ln-AO"
                },
                {
                    "name": "Lingala (Central African Republic)  (ln-CF)",
                    "value": "ln-CF"
                },
                {
                    "name": "Lingala (Congo DRC)  (ln-CD)",
                    "value": "ln-CD"
                },
                {
                    "name": "Lingala (Congo)  (ln-CG)",
                    "value": "ln-CG"
                },
                {
                    "name": "Lithuanian (Lithuania)  (lt-LT)",
                    "value": "lt-LT"
                },
                {
                    "name": "Low German (Germany)  (nds-DE)",
                    "value": "nds-DE"
                },
                {
                    "name": "Low German (Netherlands)  (nds-NL)",
                    "value": "nds-NL"
                },
                {
                    "name": "Lower Sorbian (Germany)  (dsb-DE)",
                    "value": "dsb-DE"
                },
                {
                    "name": "Luba-Katanga (Congo DRC)  (lu-CD)",
                    "value": "lu-CD"
                },
                {
                    "name": "Luo (Kenya)  (luo-KE)",
                    "value": "luo-KE"
                },
                {
                    "name": "Luxembourgish (Luxembourg)  (lb-LU)",
                    "value": "lb-LU"
                },
                {
                    "name": "Luyia (Kenya)  (luy-KE)",
                    "value": "luy-KE"
                },
                {
                    "name": "Macedonian (North Macedonia)  (mk-MK)",
                    "value": "mk-MK"
                },
                {
                    "name": "Machame (Tanzania)  (jmc-TZ)",
                    "value": "jmc-TZ"
                },
                {
                    "name": "Makhuwa-Meetto (Mozambique)  (mgh-MZ)",
                    "value": "mgh-MZ"
                },
                {
                    "name": "Makonde (Tanzania)  (kde-TZ)",
                    "value": "kde-TZ"
                },
                {
                    "name": "Malagasy (Madagascar)  (mg-MG)",
                    "value": "mg-MG"
                },
                {
                    "name": "Malay (Brunei Darussalam)  (ms-BN)",
                    "value": "ms-BN"
                },
                {
                    "name": "Malay (Latin, Singapore)  (ms-SG)",
                    "value": "ms-SG"
                },
                {
                    "name": "Malay (Malaysia)  (ms-MY)",
                    "value": "ms-MY"
                },
                {
                    "name": "Malayalam (India)  (ml-IN)",
                    "value": "ml-IN"
                },
                {
                    "name": "Maltese (Malta)  (mt-MT)",
                    "value": "mt-MT"
                },
                {
                    "name": "Manipuri (India)  (mni-IN)",
                    "value": "mni-IN"
                },
                {
                    "name": "Manx (Isle of Man)  (gv-IM)",
                    "value": "gv-IM"
                },
                {
                    "name": "Maori (New Zealand)  (mi-NZ)",
                    "value": "mi-NZ"
                },
                {
                    "name": "Mapudungun (Chile)  (arn-CL)",
                    "value": "arn-CL"
                },
                {
                    "name": "Marathi (India)  (mr-IN)",
                    "value": "mr-IN"
                },
                {
                    "name": "Masai (Kenya)  (mas-KE)",
                    "value": "mas-KE"
                },
                {
                    "name": "Masai (Tanzania)  (mas-TZ)",
                    "value": "mas-TZ"
                },
                {
                    "name": "Mazanderani (Iran)  (mzn-IR)",
                    "value": "mzn-IR"
                },
                {
                    "name": "Meru (Kenya)  (mer-KE)",
                    "value": "mer-KE"
                },
                {
                    "name": "Meta' (Cameroon)  (mgo-CM)",
                    "value": "mgo-CM"
                },
                {
                    "name": "Mohawk (Mohawk)  (moh-CA)",
                    "value": "moh-CA"
                },
                {
                    "name": "Mongolian (Cyrillic, Mongolia)  (mn-MN)",
                    "value": "mn-MN"
                },
                {
                    "name": "Mongolian (Traditional Mongolian, Mongolia)  (mn-Mong-MN)",
                    "value": "mn-Mong-MN"
                },
                {
                    "name": "Mongolian (Traditional Mongolian, PRC)  (mn-Mong-CN)",
                    "value": "mn-Mong-CN"
                },
                {
                    "name": "Morisyen (Mauritius)  (mfe-MU)",
                    "value": "mfe-MU"
                },
                {
                    "name": "Mundang (Cameroon)  (mua-CM)",
                    "value": "mua-CM"
                },
                {
                    "name": "Nama (Namibia)  (naq-NA)",
                    "value": "naq-NA"
                },
                {
                    "name": "Nepali (India)  (ne-IN)",
                    "value": "ne-IN"
                },
                {
                    "name": "Nepali (Nepal)  (ne-NP)",
                    "value": "ne-NP"
                },
                {
                    "name": "Ngiemboon (Cameroon)  (nnh-CM)",
                    "value": "nnh-CM"
                },
                {
                    "name": "Ngomba (Cameroon)  (jgo-CM)",
                    "value": "jgo-CM"
                },
                {
                    "name": "N'ko (Guinea)  (nqo-GN)",
                    "value": "nqo-GN"
                },
                {
                    "name": "North Ndebele (Zimbabwe)  (nd-ZW)",
                    "value": "nd-ZW"
                },
                {
                    "name": "Northern Luri (Iran)  (lrc-IR)",
                    "value": "lrc-IR"
                },
                {
                    "name": "Northern Luri (Iraq)  (lrc-IQ)",
                    "value": "lrc-IQ"
                },
                {
                    "name": "Norwegian, Bokmål (Norway)  (nb-NO)",
                    "value": "nb-NO"
                },
                {
                    "name": "Norwegian, Bokmål (Svalbard and Jan Mayen)  (nb-SJ)",
                    "value": "nb-SJ"
                },
                {
                    "name": "Norwegian, Nynorsk (Norway)  (nn-NO)",
                    "value": "nn-NO"
                },
                {
                    "name": "Nuer (South Sudan)  (nus-SS)",
                    "value": "nus-SS"
                },
                {
                    "name": "Nyankole (Uganda)  (nyn-UG)",
                    "value": "nyn-UG"
                },
                {
                    "name": "Occitan (France)  (oc-FR)",
                    "value": "oc-FR"
                },
                {
                    "name": "Odia (India)  (or-IN)",
                    "value": "or-IN"
                },
                {
                    "name": "Oromo (Ethiopia)  (om-ET)",
                    "value": "om-ET"
                },
                {
                    "name": "Oromo (Kenya)  (om-KE)",
                    "value": "om-KE"
                },
                {
                    "name": "Ossetian (Cyrillic, Georgia)  (os-GE)",
                    "value": "os-GE"
                },
                {
                    "name": "Ossetian (Cyrillic, Russia)  (os-RU)",
                    "value": "os-RU"
                },
                {
                    "name": "Papiamento (Caribbean)  (pap-029)",
                    "value": "pap-029"
                },
                {
                    "name": "Pashto (Afghanistan)  (ps-AF)",
                    "value": "ps-AF"
                },
                {
                    "name": "Pashto (Pakistan)  (ps-PK)",
                    "value": "ps-PK"
                },
                {
                    "name": "Persian (Iran)  (fa-IR)",
                    "value": "fa-IR"
                },
                {
                    "name": "Polish (Poland)  (pl-PL)",
                    "value": "pl-PL"
                },
                {
                    "name": "Portuguese (Angola)  (pt-AO)",
                    "value": "pt-AO"
                },
                {
                    "name": "Portuguese (Brazil)  (pt-BR)",
                    "value": "pt-BR"
                },
                {
                    "name": "Portuguese (Cabo Verde)  (pt-CV)",
                    "value": "pt-CV"
                },
                {
                    "name": "Portuguese (Equatorial Guinea)  (pt-GQ)",
                    "value": "pt-GQ"
                },
                {
                    "name": "Portuguese (Guinea-Bissau)  (pt-GW)",
                    "value": "pt-GW"
                },
                {
                    "name": "Portuguese (Luxembourg)  (pt-LU)",
                    "value": "pt-LU"
                },
                {
                    "name": "Portuguese (Macao SAR)  (pt-MO)",
                    "value": "pt-MO"
                },
                {
                    "name": "Portuguese (Mozambique)  (pt-MZ)",
                    "value": "pt-MZ"
                },
                {
                    "name": "Portuguese (Portugal)  (pt-PT)",
                    "value": "pt-PT"
                },
                {
                    "name": "Portuguese (São Tomé and Príncipe)  (pt-ST)",
                    "value": "pt-ST"
                },
                {
                    "name": "Portuguese (Switzerland)  (pt-CH)",
                    "value": "pt-CH"
                },
                {
                    "name": "Portuguese (Timor-Leste)  (pt-TL)",
                    "value": "pt-TL"
                },
                {
                    "name": "Prussian (World)  (prg-001)",
                    "value": "prg-001"
                },
                {
                    "name": "Punjabi (India)  (pa-IN)",
                    "value": "pa-IN"
                },
                {
                    "name": "Punjabi (Islamic Republic of Pakistan)  (pa-Arab-PK)",
                    "value": "pa-Arab-PK"
                },
                {
                    "name": "Quechua (Bolivia)  (quz-BO)",
                    "value": "quz-BO"
                },
                {
                    "name": "Quechua (Ecuador)  (quz-EC)",
                    "value": "quz-EC"
                },
                {
                    "name": "Quechua (Peru)  (quz-PE)",
                    "value": "quz-PE"
                },
                {
                    "name": "Ripuarian (Germany)  (ksh-DE)",
                    "value": "ksh-DE"
                },
                {
                    "name": "Romanian (Moldova)  (ro-MD)",
                    "value": "ro-MD"
                },
                {
                    "name": "Romanian (Romania)  (ro-RO)",
                    "value": "ro-RO"
                },
                {
                    "name": "Romansh (Switzerland)  (rm-CH)",
                    "value": "rm-CH"
                },
                {
                    "name": "Rombo (Tanzania)  (rof-TZ)",
                    "value": "rof-TZ"
                },
                {
                    "name": "Rundi (Burundi)  (rn-BI)",
                    "value": "rn-BI"
                },
                {
                    "name": "Russian (Belarus)  (ru-BY)",
                    "value": "ru-BY"
                },
                {
                    "name": "Russian (Kazakhstan)  (ru-KZ)",
                    "value": "ru-KZ"
                },
                {
                    "name": "Russian (Kyrgyzstan)  (ru-KG)",
                    "value": "ru-KG"
                },
                {
                    "name": "Russian (Moldova)  (ru-MD)",
                    "value": "ru-MD"
                },
                {
                    "name": "Russian (Russia)  (ru-RU)",
                    "value": "ru-RU"
                },
                {
                    "name": "Russian (Ukraine)  (ru-UA)",
                    "value": "ru-UA"
                },
                {
                    "name": "Rwa (Tanzania)  (rwk-TZ)",
                    "value": "rwk-TZ"
                },
                {
                    "name": "Saho (Eritrea)  (ssy-ER)",
                    "value": "ssy-ER"
                },
                {
                    "name": "Sakha (Russia)  (sah-RU)",
                    "value": "sah-RU"
                },
                {
                    "name": "Samburu (Kenya)  (saq-KE)",
                    "value": "saq-KE"
                },
                {
                    "name": "Sami, Inari (Finland)  (smn-FI)",
                    "value": "smn-FI"
                },
                {
                    "name": "Sami, Lule (Norway)  (smj-NO)",
                    "value": "smj-NO"
                },
                {
                    "name": "Sami, Lule (Sweden)  (smj-SE)",
                    "value": "smj-SE"
                },
                {
                    "name": "Sami, Northern (Finland)  (se-FI)",
                    "value": "se-FI"
                },
                {
                    "name": "Sami, Northern (Norway)  (se-NO)",
                    "value": "se-NO"
                },
                {
                    "name": "Sami, Northern (Sweden)  (se-SE)",
                    "value": "se-SE"
                },
                {
                    "name": "Sami, Skolt (Finland)  (sms-FI)",
                    "value": "sms-FI"
                },
                {
                    "name": "Sami, Southern (Norway)  (sma-NO)",
                    "value": "sma-NO"
                },
                {
                    "name": "Sami, Southern (Sweden)  (sma-SE)",
                    "value": "sma-SE"
                },
                {
                    "name": "Sango (Central African Republic)  (sg-CF)",
                    "value": "sg-CF"
                },
                {
                    "name": "Sangu (Tanzania)  (sbp-TZ)",
                    "value": "sbp-TZ"
                },
                {
                    "name": "Sanskrit (India)  (sa-IN)",
                    "value": "sa-IN"
                },
                {
                    "name": "Scottish Gaelic (United Kingdom)  (gd-GB)",
                    "value": "gd-GB"
                },
                {
                    "name": "Sena (Mozambique)  (seh-MZ)",
                    "value": "seh-MZ"
                },
                {
                    "name": "Serbian (Cyrillic, Bosnia and Herzegovina)  (sr-Cyrl-BA)",
                    "value": "sr-Cyrl-BA"
                },
                {
                    "name": "Serbian (Cyrillic, Kosovo)  (sr-Cyrl-XK)",
                    "value": "sr-Cyrl-XK"
                },
                {
                    "name": "Serbian (Cyrillic, Montenegro)  (sr-Cyrl-ME)",
                    "value": "sr-Cyrl-ME"
                },
                {
                    "name": "Serbian (Cyrillic, Serbia)  (sr-Cyrl-RS)",
                    "value": "sr-Cyrl-RS"
                },
                {
                    "name": "Serbian (Latin, Bosnia and Herzegovina)  (sr-Latn-BA)",
                    "value": "sr-Latn-BA"
                },
                {
                    "name": "Serbian (Latin, Kosovo)  (sr-Latn-XK)",
                    "value": "sr-Latn-XK"
                },
                {
                    "name": "Serbian (Latin, Montenegro)  (sr-Latn-ME)",
                    "value": "sr-Latn-ME"
                },
                {
                    "name": "Serbian (Latin, Serbia)  (sr-Latn-RS)",
                    "value": "sr-Latn-RS"
                },
                {
                    "name": "Sesotho (Lesotho)  (st-LS)",
                    "value": "st-LS"
                },
                {
                    "name": "Sesotho sa Leboa (South Africa)  (nso-ZA)",
                    "value": "nso-ZA"
                },
                {
                    "name": "Setswana (Botswana)  (tn-BW)",
                    "value": "tn-BW"
                },
                {
                    "name": "Setswana (South Africa)  (tn-ZA)",
                    "value": "tn-ZA"
                },
                {
                    "name": "Shambala (Tanzania)  (ksb-TZ)",
                    "value": "ksb-TZ"
                },
                {
                    "name": "Shona (Latin, Zimbabwe)  (sn-Latn-ZW)",
                    "value": "sn-Latn-ZW"
                },
                {
                    "name": "Sindhi (Devanagari, India)  (sd-Deva-IN)",
                    "value": "sd-Deva-IN"
                },
                {
                    "name": "Sindhi (Islamic Republic of Pakistan)  (sd-Arab-PK)",
                    "value": "sd-Arab-PK"
                },
                {
                    "name": "Sinhala (Sri Lanka)  (si-LK)",
                    "value": "si-LK"
                },
                {
                    "name": "Slovak (Slovakia)  (sk-SK)",
                    "value": "sk-SK"
                },
                {
                    "name": "Slovenian (Slovenia)  (sl-SI)",
                    "value": "sl-SI"
                },
                {
                    "name": "Soga (Uganda)  (xog-UG)",
                    "value": "xog-UG"
                },
                {
                    "name": "Somali (Djibouti)  (so-DJ)",
                    "value": "so-DJ"
                },
                {
                    "name": "Somali (Ethiopia)  (so-ET)",
                    "value": "so-ET"
                },
                {
                    "name": "Somali (Kenya)  (so-KE)",
                    "value": "so-KE"
                },
                {
                    "name": "Somali (Somalia)  (so-SO)",
                    "value": "so-SO"
                },
                {
                    "name": "South Ndebele (South Africa)  (nr-ZA)",
                    "value": "nr-ZA"
                },
                {
                    "name": "Southern Sotho (South Africa)  (st-ZA)",
                    "value": "st-ZA"
                },
                {
                    "name": "Spanish (Argentina)  (es-AR)",
                    "value": "es-AR"
                },
                {
                    "name": "Spanish (Belize)  (es-BZ)",
                    "value": "es-BZ"
                },
                {
                    "name": "Spanish (Bolivarian Republic of Venezuela)  (es-VE)",
                    "value": "es-VE"
                },
                {
                    "name": "Spanish (Bolivia)  (es-BO)",
                    "value": "es-BO"
                },
                {
                    "name": "Spanish (Brazil)  (es-BR)",
                    "value": "es-BR"
                },
                {
                    "name": "Spanish (Chile)  (es-CL)",
                    "value": "es-CL"
                },
                {
                    "name": "Spanish (Colombia)  (es-CO)",
                    "value": "es-CO"
                },
                {
                    "name": "Spanish (Costa Rica)  (es-CR)",
                    "value": "es-CR"
                },
                {
                    "name": "Spanish (Cuba)  (es-CU)",
                    "value": "es-CU"
                },
                {
                    "name": "Spanish (Dominican Republic)  (es-DO)",
                    "value": "es-DO"
                },
                {
                    "name": "Spanish (Ecuador)  (es-EC)",
                    "value": "es-EC"
                },
                {
                    "name": "Spanish (El Salvador)  (es-SV)",
                    "value": "es-SV"
                },
                {
                    "name": "Spanish (Equatorial Guinea)  (es-GQ)",
                    "value": "es-GQ"
                },
                {
                    "name": "Spanish (Guatemala)  (es-GT)",
                    "value": "es-GT"
                },
                {
                    "name": "Spanish (Honduras)  (es-HN)",
                    "value": "es-HN"
                },
                {
                    "name": "Spanish (Latin America)  (es-419)",
                    "value": "es-419"
                },
                {
                    "name": "Spanish (Mexico)  (es-MX)",
                    "value": "es-MX"
                },
                {
                    "name": "Spanish (Nicaragua)  (es-NI)",
                    "value": "es-NI"
                },
                {
                    "name": "Spanish (Panama)  (es-PA)",
                    "value": "es-PA"
                },
                {
                    "name": "Spanish (Paraguay)  (es-PY)",
                    "value": "es-PY"
                },
                {
                    "name": "Spanish (Peru)  (es-PE)",
                    "value": "es-PE"
                },
                {
                    "name": "Spanish (Philippines)  (es-PH)",
                    "value": "es-PH"
                },
                {
                    "name": "Spanish (Puerto Rico)  (es-PR)",
                    "value": "es-PR"
                },
                {
                    "name": "Spanish (Spain)  (es-ES)",
                    "value": "es-ES"
                },
                {
                    "name": "Spanish (United States)  (es-US)",
                    "value": "es-US"
                },
                {
                    "name": "Spanish (Uruguay)  (es-UY)",
                    "value": "es-UY"
                },
                {
                    "name": "Standard Moroccan Tamazight (Tifinagh, Morocco)  (zgh-Tfng-MA)",
                    "value": "zgh-Tfng-MA"
                },
                {
                    "name": "Swati (South Africa)  (ss-ZA)",
                    "value": "ss-ZA"
                },
                {
                    "name": "Swati (Swaziland)  (ss-SZ)",
                    "value": "ss-SZ"
                },
                {
                    "name": "Swedish (Åland Islands)  (sv-AX)",
                    "value": "sv-AX"
                },
                {
                    "name": "Swedish (Finland)  (sv-FI)",
                    "value": "sv-FI"
                },
                {
                    "name": "Swedish (Sweden)  (sv-SE)",
                    "value": "sv-SE"
                },
                {
                    "name": "Syriac (Syria)  (syr-SY)",
                    "value": "syr-SY"
                },
                {
                    "name": "Tachelhit (Latin, Morocco)  (shi-Latn-MA)",
                    "value": "shi-Latn-MA"
                },
                {
                    "name": "Tachelhit (Tifinagh, Morocco)  (shi-Tfng-MA)",
                    "value": "shi-Tfng-MA"
                },
                {
                    "name": "Taita (Kenya)  (dav-KE)",
                    "value": "dav-KE"
                },
                {
                    "name": "Tajik (Cyrillic, Tajikistan)  (tg-Cyrl-TJ)",
                    "value": "tg-Cyrl-TJ"
                },
                {
                    "name": "Tamazight (Latin, Algeria)  (tzm-Latn-DZ)",
                    "value": "tzm-Latn-DZ"
                },
                {
                    "name": "Tamil (India)  (ta-IN)",
                    "value": "ta-IN"
                },
                {
                    "name": "Tamil (Malaysia)  (ta-MY)",
                    "value": "ta-MY"
                },
                {
                    "name": "Tamil (Singapore)  (ta-SG)",
                    "value": "ta-SG"
                },
                {
                    "name": "Tamil (Sri Lanka)  (ta-LK)",
                    "value": "ta-LK"
                },
                {
                    "name": "Tasawaq (Niger)  (twq-NE)",
                    "value": "twq-NE"
                },
                {
                    "name": "Tatar (Russia)  (tt-RU)",
                    "value": "tt-RU"
                },
                {
                    "name": "Telugu (India)  (te-IN)",
                    "value": "te-IN"
                },
                {
                    "name": "Teso (Kenya)  (teo-KE)",
                    "value": "teo-KE"
                },
                {
                    "name": "Teso (Uganda)  (teo-UG)",
                    "value": "teo-UG"
                },
                {
                    "name": "Thai (Thailand)  (th-TH)",
                    "value": "th-TH"
                },
                {
                    "name": "Tibetan (India)  (bo-IN)",
                    "value": "bo-IN"
                },
                {
                    "name": "Tibetan (PRC)  (bo-CN)",
                    "value": "bo-CN"
                },
                {
                    "name": "Tigre (Eritrea)  (tig-ER)",
                    "value": "tig-ER"
                },
                {
                    "name": "Tigrinya (Eritrea)  (ti-ER)",
                    "value": "ti-ER"
                },
                {
                    "name": "Tigrinya (Ethiopia)  (ti-ET)",
                    "value": "ti-ET"
                },
                {
                    "name": "Tongan (Tonga)  (to-TO)",
                    "value": "to-TO"
                },
                {
                    "name": "Tsonga (South Africa)  (ts-ZA)",
                    "value": "ts-ZA"
                },
                {
                    "name": "Turkish (Cyprus)  (tr-CY)",
                    "value": "tr-CY"
                },
                {
                    "name": "Turkish (Turkey)  (tr-TR)",
                    "value": "tr-TR"
                },
                {
                    "name": "Turkmen (Turkmenistan)  (tk-TM)",
                    "value": "tk-TM"
                },
                {
                    "name": "Ukrainian (Ukraine)  (uk-UA)",
                    "value": "uk-UA"
                },
                {
                    "name": "Upper Sorbian (Germany)  (hsb-DE)",
                    "value": "hsb-DE"
                },
                {
                    "name": "Urdu (India)  (ur-IN)",
                    "value": "ur-IN"
                },
                {
                    "name": "Urdu (Islamic Republic of Pakistan)  (ur-PK)",
                    "value": "ur-PK"
                },
                {
                    "name": "Uyghur (PRC)  (ug-CN)",
                    "value": "ug-CN"
                },
                {
                    "name": "Uzbek (Cyrillic, Uzbekistan)  (uz-Cyrl-UZ)",
                    "value": "uz-Cyrl-UZ"
                },
                {
                    "name": "Uzbek (Latin, Uzbekistan)  (uz-Latn-UZ)",
                    "value": "uz-Latn-UZ"
                },
                {
                    "name": "Uzbek (Perso-Arabic, Afghanistan)  (uz-Arab-AF)",
                    "value": "uz-Arab-AF"
                },
                {
                    "name": "Vai (Latin, Liberia)  (vai-Latn-LR)",
                    "value": "vai-Latn-LR"
                },
                {
                    "name": "Vai (Vai, Liberia)  (vai-Vaii-LR)",
                    "value": "vai-Vaii-LR"
                },
                {
                    "name": "Valencian (Spain)  (ca-ES-valencia)",
                    "value": "ca-ES-valencia"
                },
                {
                    "name": "Venda (South Africa)  (ve-ZA)",
                    "value": "ve-ZA"
                },
                {
                    "name": "Vietnamese (Vietnam)  (vi-VN)",
                    "value": "vi-VN"
                },
                {
                    "name": "Volapük (World)  (vo-001)",
                    "value": "vo-001"
                },
                {
                    "name": "Vunjo (Tanzania)  (vun-TZ)",
                    "value": "vun-TZ"
                },
                {
                    "name": "Walser (Switzerland)  (wae-CH)",
                    "value": "wae-CH"
                },
                {
                    "name": "Welsh (United Kingdom)  (cy-GB)",
                    "value": "cy-GB"
                },
                {
                    "name": "Wolaytta (Ethiopia)  (wal-ET)",
                    "value": "wal-ET"
                },
                {
                    "name": "Wolof (Senegal)  (wo-SN)",
                    "value": "wo-SN"
                },
                {
                    "name": "Yangben (Cameroon)  (yav-CM)",
                    "value": "yav-CM"
                },
                {
                    "name": "Yi (PRC)  (ii-CN)",
                    "value": "ii-CN"
                },
                {
                    "name": "Yiddish (World)  (yi-001)",
                    "value": "yi-001"
                },
                {
                    "name": "Yoruba (Benin)  (yo-BJ)",
                    "value": "yo-BJ"
                },
                {
                    "name": "Yoruba (Nigeria)  (yo-NG)",
                    "value": "yo-NG"
                },
                {
                    "name": "Zarma (Niger)  (dje-NE)",
                    "value": "dje-NE"
                }
            ];
        return this._cultures;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiHelperService, deps: [{ token: i1.StiModelService }, { token: StiRectangleGeometryLayout }, { token: i2.StiLocalizationService }, { token: i0.NgZone }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiHelperService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiHelperService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: StiRectangleGeometryLayout }, { type: i2.StiLocalizationService }, { type: i0.NgZone }] });
//# sourceMappingURL=data:application/json;base64,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