import { Injectable } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./sti-helper.service";
import * as i3 from "./sti-draggable.service";
import * as i4 from "./sti-name.service";
export class FormEventsService {
    static dateToJsonDate(date) {
        let offset = date.getTimezoneOffset() * -1;
        let hoursOffset = Math.abs(Math.floor(offset / 60)).toString();
        let minutesOffset = Math.abs(offset % 60).toString();
        if (hoursOffset.length == 1)
            hoursOffset = "0" + hoursOffset;
        if (minutesOffset.length == 1)
            minutesOffset = "0" + minutesOffset;
        return ("/Date(" + Date.parse(date.toString()).toString() + (offset >= 0 ? "+" : "-") + hoursOffset + minutesOffset + ")/");
    }
    get canMoveUp() {
        let state = true;
        this.model.form.pages.forEach((page, index) => {
            if (page === this.currentPage && index == 0) {
                state = false;
            }
        });
        return state;
    }
    get currentPage() {
        return this.model.selectedPage ? this.model.selectedPage : null;
    }
    get canMoveDown() {
        let state = true;
        this.model.form.pages.forEach((page, index) => {
            if (page === this.currentPage && index == this.model.form.pages.length - 1) {
                state = false;
            }
        });
        return state;
    }
    get canDelete() {
        return this.model?.form?.pages?.length > 1 ? true : false;
    }
    get canClear() {
        return this.currentPage.allElements.length > 0 ? true : false;
    }
    deleteComponent() {
        this.helper.deleteSelectedComponent();
        if (this.model.showContextMenu) {
            this.model.showContextMenu = false;
        }
    }
    moveUp() {
        let index = this.model.form.pages.indexOf(this.currentPage);
        this.model.form.pages.splice(index, 1);
        this.model.form.pages.splice(index - 1, 0, this.currentPage);
        setTimeout(() => {
            let workspace = document.getElementsByTagName("sti-workspace")[0];
            workspace.scrollTop = workspace.scrollTop - (this.currentPage?.height + 20) * this.model.zoom;
        }, 0);
        if (this.model.showContextMenu) {
            this.model.showContextMenu = false;
        }
    }
    moveDown() {
        let index = this.model.form.pages.indexOf(this.currentPage);
        this.model.form.pages.splice(index, 1);
        this.model.form.pages.splice(index + 1, 0, this.currentPage);
        setTimeout(() => {
            let workspace = document.getElementsByTagName("sti-workspace")[0];
            workspace.scrollTop = workspace.scrollTop + (this.currentPage?.height + 20) * this.model.zoom;
        }, 0);
        if (this.model.showContextMenu) {
            this.model.showContextMenu = false;
        }
    }
    insertAfter() {
        let newPage = this.helper.clonePage(this.currentPage);
        newPage.elements = [];
        newPage.name = this.nameService.getElementName(newPage);
        this.model.form.pages.splice(this.model.form.pages.indexOf(this.currentPage) + 1, 0, newPage);
        setTimeout(() => {
            this.model.selectedPage = newPage;
        });
        setTimeout(() => {
            let workspace = document.getElementsByTagName("sti-workspace")[0];
            workspace.scrollTop = workspace.scrollTop + (newPage.height + 20) * this.model.zoom;
        }, 0);
        if (this.model.showContextMenu) {
            this.model.showContextMenu = false;
        }
    }
    insertBefore() {
        let newPage = this.helper.clonePage(this.currentPage);
        newPage.name = this.nameService.getElementName(newPage);
        newPage.elements = [];
        this.model.form.pages.splice(this.model.form.pages.indexOf(this.currentPage), 0, newPage);
        setTimeout(() => {
            this.model.selectedPage = newPage;
        });
        if (this.model.showContextMenu) {
            this.model.showContextMenu = false;
        }
    }
    clear() {
        this.currentPage.elements = [];
        if (this.model.showContextMenu) {
            this.model.showContextMenu = false;
        }
    }
    delete() {
        this.model.showModalWindow = true;
        if (this.model.showContextMenu) {
            this.model.showContextMenu = false;
        }
    }
    constructor(model, helper, draggableService, nameService) {
        this.model = model;
        this.helper = helper;
        this.draggableService = draggableService;
        this.nameService = nameService;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: FormEventsService, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiDraggableService }, { token: i4.StiNameService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: FormEventsService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: FormEventsService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiDraggableService }, { type: i4.StiNameService }] });
//# sourceMappingURL=data:application/json;base64,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