import { Injectable } from "@angular/core";
import { StiButtonElement } from "../elements/StiButtonElement";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class StiFormCheckerService {
    isRibbonWithPreview(ribbon) {
        return ribbon == "Preview" || ribbon == "PDFPreview";
    }
    haveStiCloudSubmitButton() {
        let state = false;
        this.model.form?.pages.forEach((page) => {
            page.allElements.forEach((element) => {
                if (element instanceof StiButtonElement &&
                    (element.formSendURL?.trim().toLocaleLowerCase() == "stimulsoft cloud" ||
                        element.formSendURL?.trim().toLocaleLowerCase() == "cloud.stimulsoft.com")) {
                    state = true;
                }
            });
        });
        return state;
    }
    needToDisplayFormsChecker() {
        return (this.haveStiCloudSubmitButton() && (this.model.form.versionKey == null || this.model.form.versionKey.length == 0));
    }
    check(ribbon) {
        let state = (this.model.isWebView || this.model.isCloudMode) && this.needToDisplayFormsChecker();
        if (state) {
            // this.hasIssue = true;
            // this.currentPressedButton = ribbon;
            // this.displayFormsChecker(ribbon);
        }
        return true;
    }
    get hasIssue() {
        return ((this.model.isWebView || this.model.isCloudMode) && this.needToDisplayFormsChecker() && !this.model.previewMode);
    }
    displayFormsChecker() {
        this.showFormCheckerWindow = true;
    }
    updateFormAfterSaving(form) {
        if (form) {
            if (typeof form != "boolean") {
                this.model.setFormFromString(JSON.stringify(form));
            }
            this.showFormCheckerWindow = false;
            this.model.saveLastFormState();
            this.model.saveSettings();
            this.model.formEvents.next({ name: this.model.ribbon });
        }
    }
    getButtonNames() {
        let buttonElements = [];
        this.model.form?.pages.forEach((page) => {
            page.allElements.forEach((element) => {
                if (element.type == "ButtonElement" &&
                    element.formSendURL?.trim().toLocaleLowerCase() == "stimulsoft cloud") {
                    buttonElements.push(element.name);
                }
            });
        });
        this.buttonNames = buttonElements.join().length > 0 ? "(" + buttonElements.join() + ")" : "";
    }
    constructor(model) {
        this.model = model;
        this.showFormCheckerWindow = false;
        this.formMessages = [];
        this.buttonNames = "";
        this.componentWidth = 700;
        this.componentHeight = 482;
        this.currentPressedButton = "";
        this.issuesCount = 1;
        let newItem = {
            type: "warning",
            label: "Form not saved in Stimulsoft Cloud",
            content: "To submit the form data to the Stimulsoft server, you can use the Submit button {0} on the form. Once the data is sent, you will be able to view all submissions for that particular form. To ensure that the data is processed correctly, it is important to save the form to the cloud. You can modify the URL of the Stimulsoft Cloud button.",
        };
        this.formMessages.push(newItem);
        window.onresize = (event) => {
            if (window.innerWidth > this.componentWidth) {
                if (window.innerWidth < this.componentX + this.componentWidth) {
                    this.componentX = (window.innerWidth - this.componentWidth) / 2;
                }
            }
            else {
                this.componentX = 0;
            }
            if (window.innerHeight > this.componentHeight) {
                if (window.innerHeight < this.componentY + this.componentHeight) {
                    this.componentY = (window.innerHeight - this.componentHeight) / 2;
                }
            }
            else {
                this.componentY = 0;
            }
        };
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFormCheckerService, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFormCheckerService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFormCheckerService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiModelService }] });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLWZvcm0tY2hlY2tlci5zZXJ2aWNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3RpbXVsc29mdC1mb3Jtcy9zcmMvbGliL3NlcnZpY2VzL3N0aS1mb3JtLWNoZWNrZXIuc2VydmljZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsVUFBVSxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBRzNDLE9BQU8sRUFBRSxnQkFBZ0IsRUFBRSxNQUFNLDhCQUE4QixDQUFDOzs7QUFHaEUsTUFBTSxPQUFPLHFCQUFxQjtJQVdoQyxtQkFBbUIsQ0FBQyxNQUFNO1FBQ3hCLE9BQU8sTUFBTSxJQUFJLFNBQVMsSUFBSSxNQUFNLElBQUksWUFBWSxDQUFDO0lBQ3ZELENBQUM7SUFDRCx3QkFBd0I7UUFDdEIsSUFBSSxLQUFLLEdBQVksS0FBSyxDQUFDO1FBQzNCLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRTtZQUN0QyxJQUFJLENBQUMsV0FBVyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFBRSxFQUFFO2dCQUNuQyxJQUNFLE9BQU8sWUFBWSxnQkFBZ0I7b0JBQ25DLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxJQUFJLEVBQUUsQ0FBQyxpQkFBaUIsRUFBRSxJQUFJLGtCQUFrQjt3QkFDcEUsT0FBTyxDQUFDLFdBQVcsRUFBRSxJQUFJLEVBQUUsQ0FBQyxpQkFBaUIsRUFBRSxJQUFJLHNCQUFzQixDQUFDLEVBQzVFLENBQUM7b0JBQ0QsS0FBSyxHQUFHLElBQUksQ0FBQztnQkFDZixDQUFDO1lBQ0gsQ0FBQyxDQUFDLENBQUM7UUFDTCxDQUFDLENBQUMsQ0FBQztRQUNILE9BQU8sS0FBSyxDQUFDO0lBQ2YsQ0FBQztJQUVELHlCQUF5QjtRQUN2QixPQUFPLENBQ0wsSUFBSSxDQUFDLHdCQUF3QixFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxVQUFVLElBQUksSUFBSSxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxNQUFNLElBQUksQ0FBQyxDQUFDLENBQ2xILENBQUM7SUFDSixDQUFDO0lBQ00sS0FBSyxDQUFDLE1BQWM7UUFDekIsSUFBSSxLQUFLLEdBQUcsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxJQUFJLElBQUksQ0FBQyx5QkFBeUIsRUFBRSxDQUFDO1FBQ2pHLElBQUksS0FBSyxFQUFFLENBQUM7WUFDVix3QkFBd0I7WUFDeEIsc0NBQXNDO1lBQ3RDLG9DQUFvQztRQUN0QyxDQUFDO1FBQ0QsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sQ0FDTCxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsV0FBVyxDQUFDLElBQUksSUFBSSxDQUFDLHlCQUF5QixFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FDaEgsQ0FBQztJQUNKLENBQUM7SUFFTSxtQkFBbUI7UUFDeEIsSUFBSSxDQUFDLHFCQUFxQixHQUFHLElBQUksQ0FBQztJQUNwQyxDQUFDO0lBRUQscUJBQXFCLENBQUMsSUFBSTtRQUN4QixJQUFJLElBQUksRUFBRSxDQUFDO1lBQ1QsSUFBSSxPQUFPLElBQUksSUFBSSxTQUFTLEVBQUUsQ0FBQztnQkFDN0IsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7WUFDckQsQ0FBQztZQUNELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUM7WUFDbkMsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO1lBQy9CLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDMUIsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLEVBQUUsSUFBSSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxFQUFFLENBQUMsQ0FBQztRQUMxRCxDQUFDO0lBQ0gsQ0FBQztJQUVNLGNBQWM7UUFDbkIsSUFBSSxjQUFjLEdBQUcsRUFBRSxDQUFDO1FBQ3hCLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRTtZQUN0QyxJQUFJLENBQUMsV0FBVyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFBRSxFQUFFO2dCQUNuQyxJQUNFLE9BQU8sQ0FBQyxJQUFJLElBQUksZUFBZTtvQkFDOUIsT0FBNEIsQ0FBQyxXQUFXLEVBQUUsSUFBSSxFQUFFLENBQUMsaUJBQWlCLEVBQUUsSUFBSSxrQkFBa0IsRUFDM0YsQ0FBQztvQkFDRCxjQUFjLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQztnQkFDcEMsQ0FBQztZQUNILENBQUMsQ0FBQyxDQUFDO1FBQ0wsQ0FBQyxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsV0FBVyxHQUFHLGNBQWMsQ0FBQyxJQUFJLEVBQUUsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxHQUFHLEdBQUcsY0FBYyxDQUFDLElBQUksRUFBRSxHQUFHLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO0lBQy9GLENBQUM7SUFDRCxZQUFtQixLQUFzQjtRQUF0QixVQUFLLEdBQUwsS0FBSyxDQUFpQjtRQWhGbEMsMEJBQXFCLEdBQVksS0FBSyxDQUFDO1FBQ3ZDLGlCQUFZLEdBQXlCLEVBQUUsQ0FBQztRQUN4QyxnQkFBVyxHQUFXLEVBQUUsQ0FBQztRQUd6QixtQkFBYyxHQUFXLEdBQUcsQ0FBQztRQUM3QixvQkFBZSxHQUFXLEdBQUcsQ0FBQztRQUM5Qix5QkFBb0IsR0FBVyxFQUFFLENBQUM7UUFDbEMsZ0JBQVcsR0FBVyxDQUFDLENBQUM7UUF5RTdCLElBQUksT0FBTyxHQUF1QjtZQUNoQyxJQUFJLEVBQUUsU0FBUztZQUNmLEtBQUssRUFBRSxvQ0FBb0M7WUFDM0MsT0FBTyxFQUNMLGtWQUFrVjtTQUNyVixDQUFDO1FBQ0YsSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDaEMsTUFBTSxDQUFDLFFBQVEsR0FBRyxDQUFDLEtBQUssRUFBRSxFQUFFO1lBQzFCLElBQUksTUFBTSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsY0FBYyxFQUFFLENBQUM7Z0JBQzVDLElBQUksTUFBTSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQyxjQUFjLEVBQUUsQ0FBQztvQkFDOUQsSUFBSSxDQUFDLFVBQVUsR0FBRyxDQUFDLE1BQU0sQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQyxHQUFHLENBQUMsQ0FBQztnQkFDbEUsQ0FBQztZQUNILENBQUM7aUJBQU0sQ0FBQztnQkFDTixJQUFJLENBQUMsVUFBVSxHQUFHLENBQUMsQ0FBQztZQUN0QixDQUFDO1lBQ0QsSUFBSSxNQUFNLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQztnQkFDOUMsSUFBSSxNQUFNLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDLGVBQWUsRUFBRSxDQUFDO29CQUNoRSxJQUFJLENBQUMsVUFBVSxHQUFHLENBQUMsTUFBTSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsZUFBZSxDQUFDLEdBQUcsQ0FBQyxDQUFDO2dCQUNwRSxDQUFDO1lBQ0gsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLElBQUksQ0FBQyxVQUFVLEdBQUcsQ0FBQyxDQUFDO1lBQ3RCLENBQUM7UUFDSCxDQUFDLENBQUM7SUFDSixDQUFDOytHQXpHVSxxQkFBcUI7bUhBQXJCLHFCQUFxQjs7NEZBQXJCLHFCQUFxQjtrQkFEakMsVUFBVSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEluamVjdGFibGUgfSBmcm9tIFwiQGFuZ3VsYXIvY29yZVwiO1xyXG5pbXBvcnQgeyBTdGlGb3JtQ2hlY2tlckl0ZW0gfSBmcm9tIFwiLi4vc3lzdGVtL2ludGVyZmFjZXNcIjtcclxuaW1wb3J0IHsgU3RpTW9kZWxTZXJ2aWNlIH0gZnJvbSBcIi4vbW9kZWwuc2VydmljZVwiO1xyXG5pbXBvcnQgeyBTdGlCdXR0b25FbGVtZW50IH0gZnJvbSBcIi4uL2VsZW1lbnRzL1N0aUJ1dHRvbkVsZW1lbnRcIjtcclxuXHJcbkBJbmplY3RhYmxlKClcclxuZXhwb3J0IGNsYXNzIFN0aUZvcm1DaGVja2VyU2VydmljZSB7XHJcbiAgcHVibGljIHNob3dGb3JtQ2hlY2tlcldpbmRvdzogYm9vbGVhbiA9IGZhbHNlO1xyXG4gIHB1YmxpYyBmb3JtTWVzc2FnZXM6IFN0aUZvcm1DaGVja2VySXRlbVtdID0gW107XHJcbiAgcHVibGljIGJ1dHRvbk5hbWVzOiBzdHJpbmcgPSBcIlwiO1xyXG4gIHB1YmxpYyBjb21wb25lbnRYOiBudW1iZXI7XHJcbiAgcHVibGljIGNvbXBvbmVudFk6IG51bWJlcjtcclxuICBwdWJsaWMgY29tcG9uZW50V2lkdGg6IG51bWJlciA9IDcwMDtcclxuICBwdWJsaWMgY29tcG9uZW50SGVpZ2h0OiBudW1iZXIgPSA0ODI7XHJcbiAgcHVibGljIGN1cnJlbnRQcmVzc2VkQnV0dG9uOiBzdHJpbmcgPSBcIlwiO1xyXG4gIHB1YmxpYyBpc3N1ZXNDb3VudDogbnVtYmVyID0gMTtcclxuXHJcbiAgaXNSaWJib25XaXRoUHJldmlldyhyaWJib24pOiBib29sZWFuIHtcclxuICAgIHJldHVybiByaWJib24gPT0gXCJQcmV2aWV3XCIgfHwgcmliYm9uID09IFwiUERGUHJldmlld1wiO1xyXG4gIH1cclxuICBoYXZlU3RpQ2xvdWRTdWJtaXRCdXR0b24oKTogYm9vbGVhbiB7XHJcbiAgICBsZXQgc3RhdGU6IGJvb2xlYW4gPSBmYWxzZTtcclxuICAgIHRoaXMubW9kZWwuZm9ybT8ucGFnZXMuZm9yRWFjaCgocGFnZSkgPT4ge1xyXG4gICAgICBwYWdlLmFsbEVsZW1lbnRzLmZvckVhY2goKGVsZW1lbnQpID0+IHtcclxuICAgICAgICBpZiAoXHJcbiAgICAgICAgICBlbGVtZW50IGluc3RhbmNlb2YgU3RpQnV0dG9uRWxlbWVudCAmJlxyXG4gICAgICAgICAgKGVsZW1lbnQuZm9ybVNlbmRVUkw/LnRyaW0oKS50b0xvY2FsZUxvd2VyQ2FzZSgpID09IFwic3RpbXVsc29mdCBjbG91ZFwiIHx8XHJcbiAgICAgICAgICAgIGVsZW1lbnQuZm9ybVNlbmRVUkw/LnRyaW0oKS50b0xvY2FsZUxvd2VyQ2FzZSgpID09IFwiY2xvdWQuc3RpbXVsc29mdC5jb21cIilcclxuICAgICAgICApIHtcclxuICAgICAgICAgIHN0YXRlID0gdHJ1ZTtcclxuICAgICAgICB9XHJcbiAgICAgIH0pO1xyXG4gICAgfSk7XHJcbiAgICByZXR1cm4gc3RhdGU7XHJcbiAgfVxyXG5cclxuICBuZWVkVG9EaXNwbGF5Rm9ybXNDaGVja2VyKCk6IGJvb2xlYW4ge1xyXG4gICAgcmV0dXJuIChcclxuICAgICAgdGhpcy5oYXZlU3RpQ2xvdWRTdWJtaXRCdXR0b24oKSAmJiAodGhpcy5tb2RlbC5mb3JtLnZlcnNpb25LZXkgPT0gbnVsbCB8fCB0aGlzLm1vZGVsLmZvcm0udmVyc2lvbktleS5sZW5ndGggPT0gMClcclxuICAgICk7XHJcbiAgfVxyXG4gIHB1YmxpYyBjaGVjayhyaWJib246IHN0cmluZyk6IGJvb2xlYW4ge1xyXG4gICAgbGV0IHN0YXRlID0gKHRoaXMubW9kZWwuaXNXZWJWaWV3IHx8IHRoaXMubW9kZWwuaXNDbG91ZE1vZGUpICYmIHRoaXMubmVlZFRvRGlzcGxheUZvcm1zQ2hlY2tlcigpO1xyXG4gICAgaWYgKHN0YXRlKSB7XHJcbiAgICAgIC8vIHRoaXMuaGFzSXNzdWUgPSB0cnVlO1xyXG4gICAgICAvLyB0aGlzLmN1cnJlbnRQcmVzc2VkQnV0dG9uID0gcmliYm9uO1xyXG4gICAgICAvLyB0aGlzLmRpc3BsYXlGb3Jtc0NoZWNrZXIocmliYm9uKTtcclxuICAgIH1cclxuICAgIHJldHVybiB0cnVlO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBoYXNJc3N1ZSgpOiBib29sZWFuIHtcclxuICAgIHJldHVybiAoXHJcbiAgICAgICh0aGlzLm1vZGVsLmlzV2ViVmlldyB8fCB0aGlzLm1vZGVsLmlzQ2xvdWRNb2RlKSAmJiB0aGlzLm5lZWRUb0Rpc3BsYXlGb3Jtc0NoZWNrZXIoKSAmJiAhdGhpcy5tb2RlbC5wcmV2aWV3TW9kZVxyXG4gICAgKTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBkaXNwbGF5Rm9ybXNDaGVja2VyKCkge1xyXG4gICAgdGhpcy5zaG93Rm9ybUNoZWNrZXJXaW5kb3cgPSB0cnVlO1xyXG4gIH1cclxuXHJcbiAgdXBkYXRlRm9ybUFmdGVyU2F2aW5nKGZvcm0pIHtcclxuICAgIGlmIChmb3JtKSB7XHJcbiAgICAgIGlmICh0eXBlb2YgZm9ybSAhPSBcImJvb2xlYW5cIikge1xyXG4gICAgICAgIHRoaXMubW9kZWwuc2V0Rm9ybUZyb21TdHJpbmcoSlNPTi5zdHJpbmdpZnkoZm9ybSkpO1xyXG4gICAgICB9XHJcbiAgICAgIHRoaXMuc2hvd0Zvcm1DaGVja2VyV2luZG93ID0gZmFsc2U7XHJcbiAgICAgIHRoaXMubW9kZWwuc2F2ZUxhc3RGb3JtU3RhdGUoKTtcclxuICAgICAgdGhpcy5tb2RlbC5zYXZlU2V0dGluZ3MoKTtcclxuICAgICAgdGhpcy5tb2RlbC5mb3JtRXZlbnRzLm5leHQoeyBuYW1lOiB0aGlzLm1vZGVsLnJpYmJvbiB9KTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBnZXRCdXR0b25OYW1lcygpIHtcclxuICAgIGxldCBidXR0b25FbGVtZW50cyA9IFtdO1xyXG4gICAgdGhpcy5tb2RlbC5mb3JtPy5wYWdlcy5mb3JFYWNoKChwYWdlKSA9PiB7XHJcbiAgICAgIHBhZ2UuYWxsRWxlbWVudHMuZm9yRWFjaCgoZWxlbWVudCkgPT4ge1xyXG4gICAgICAgIGlmIChcclxuICAgICAgICAgIGVsZW1lbnQudHlwZSA9PSBcIkJ1dHRvbkVsZW1lbnRcIiAmJlxyXG4gICAgICAgICAgKGVsZW1lbnQgYXMgU3RpQnV0dG9uRWxlbWVudCkuZm9ybVNlbmRVUkw/LnRyaW0oKS50b0xvY2FsZUxvd2VyQ2FzZSgpID09IFwic3RpbXVsc29mdCBjbG91ZFwiXHJcbiAgICAgICAgKSB7XHJcbiAgICAgICAgICBidXR0b25FbGVtZW50cy5wdXNoKGVsZW1lbnQubmFtZSk7XHJcbiAgICAgICAgfVxyXG4gICAgICB9KTtcclxuICAgIH0pO1xyXG4gICAgdGhpcy5idXR0b25OYW1lcyA9IGJ1dHRvbkVsZW1lbnRzLmpvaW4oKS5sZW5ndGggPiAwID8gXCIoXCIgKyBidXR0b25FbGVtZW50cy5qb2luKCkgKyBcIilcIiA6IFwiXCI7XHJcbiAgfVxyXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBtb2RlbDogU3RpTW9kZWxTZXJ2aWNlKSB7XHJcbiAgICBsZXQgbmV3SXRlbTogU3RpRm9ybUNoZWNrZXJJdGVtID0ge1xyXG4gICAgICB0eXBlOiBcIndhcm5pbmdcIixcclxuICAgICAgbGFiZWw6IFwiRm9ybSBub3Qgc2F2ZWQgaW4gU3RpbXVsc29mdCBDbG91ZFwiLFxyXG4gICAgICBjb250ZW50OlxyXG4gICAgICAgIFwiVG8gc3VibWl0IHRoZSBmb3JtIGRhdGEgdG8gdGhlIFN0aW11bHNvZnQgc2VydmVyLCB5b3UgY2FuIHVzZSB0aGUgU3VibWl0IGJ1dHRvbiB7MH0gb24gdGhlIGZvcm0uIE9uY2UgdGhlIGRhdGEgaXMgc2VudCwgeW91IHdpbGwgYmUgYWJsZSB0byB2aWV3IGFsbCBzdWJtaXNzaW9ucyBmb3IgdGhhdCBwYXJ0aWN1bGFyIGZvcm0uIFRvIGVuc3VyZSB0aGF0IHRoZSBkYXRhIGlzIHByb2Nlc3NlZCBjb3JyZWN0bHksIGl0IGlzIGltcG9ydGFudCB0byBzYXZlIHRoZSBmb3JtIHRvIHRoZSBjbG91ZC4gWW91IGNhbiBtb2RpZnkgdGhlIFVSTCBvZiB0aGUgU3RpbXVsc29mdCBDbG91ZCBidXR0b24uXCIsXHJcbiAgICB9O1xyXG4gICAgdGhpcy5mb3JtTWVzc2FnZXMucHVzaChuZXdJdGVtKTtcclxuICAgIHdpbmRvdy5vbnJlc2l6ZSA9IChldmVudCkgPT4ge1xyXG4gICAgICBpZiAod2luZG93LmlubmVyV2lkdGggPiB0aGlzLmNvbXBvbmVudFdpZHRoKSB7XHJcbiAgICAgICAgaWYgKHdpbmRvdy5pbm5lcldpZHRoIDwgdGhpcy5jb21wb25lbnRYICsgdGhpcy5jb21wb25lbnRXaWR0aCkge1xyXG4gICAgICAgICAgdGhpcy5jb21wb25lbnRYID0gKHdpbmRvdy5pbm5lcldpZHRoIC0gdGhpcy5jb21wb25lbnRXaWR0aCkgLyAyO1xyXG4gICAgICAgIH1cclxuICAgICAgfSBlbHNlIHtcclxuICAgICAgICB0aGlzLmNvbXBvbmVudFggPSAwO1xyXG4gICAgICB9XHJcbiAgICAgIGlmICh3aW5kb3cuaW5uZXJIZWlnaHQgPiB0aGlzLmNvbXBvbmVudEhlaWdodCkge1xyXG4gICAgICAgIGlmICh3aW5kb3cuaW5uZXJIZWlnaHQgPCB0aGlzLmNvbXBvbmVudFkgKyB0aGlzLmNvbXBvbmVudEhlaWdodCkge1xyXG4gICAgICAgICAgdGhpcy5jb21wb25lbnRZID0gKHdpbmRvdy5pbm5lckhlaWdodCAtIHRoaXMuY29tcG9uZW50SGVpZ2h0KSAvIDI7XHJcbiAgICAgICAgfVxyXG4gICAgICB9IGVsc2Uge1xyXG4gICAgICAgIHRoaXMuY29tcG9uZW50WSA9IDA7XHJcbiAgICAgIH1cclxuICAgIH07XHJcbiAgfVxyXG59XHJcbiJdfQ==