import { StiFormSaveMode } from "../system/enums";
export class StiToolboxElement {
    constructor(caption, image, component, element, setForm) {
        this.caption = caption;
        this.image = image;
        this.component = component;
        this.element = element;
        this.setForm = setForm;
    }
}
export class StiEvent {
    constructor(name, value) {
        this.name = name;
        this.value = value;
    }
}
export class StiEditorProperty {
    constructor(type, property, label, tooltip) {
        this.type = type;
        this.property = property;
        this.label = label;
        this.tooltip = tooltip;
    }
}
export class Item {
    constructor(name, caption, imageName, key, haveSubMenu, imageSizes, selected, type) {
        this.name = name;
        this.caption = caption;
        this.imageName = imageName;
        this.key = key;
        this.haveSubMenu = haveSubMenu;
        this.imageSizes = imageSizes;
        this.selected = selected;
        this.type = type;
    }
}
export class MenuItem {
    constructor(name, caption, img, type, selected, imageSize, value) {
        this.name = name;
        this.caption = caption;
        this.img = img;
        this.type = type;
        this.selected = selected;
        this.imageSize = imageSize;
        this.value = value;
    }
}
export class Menu {
    constructor(name, items, parent, type, state, menuEl, top, left, innerContent, width, height, menuStyleName, verticalItems, action, itemStyleName, value, sizeStyle) {
        this.name = name;
        this.items = items;
        this.parent = parent;
        this.type = type;
        this.state = state;
        this.menuEl = menuEl;
        this.top = top;
        this.left = left;
        this.innerContent = innerContent;
        this.width = width;
        this.height = height;
        this.menuStyleName = menuStyleName;
        this.verticalItems = verticalItems;
        this.action = action;
        this.itemStyleName = itemStyleName;
        this.value = value;
        this.sizeStyle = sizeStyle;
    }
}
export class StiWebFormOptions {
    constructor() {
        this.saveMode = StiFormSaveMode.Automatic;
    }
}
export class StiLocalizationObject {
}
export class FormEvent {
    constructor(name, value) {
        this.name = name;
        this.value = value;
    }
}
export class UsedFont {
    constructor(fontFamily, fontStyle, fontSize) {
        this.fontFamily = fontFamily;
        this.fontStyle = fontStyle;
        this.fontSize = fontSize;
    }
}
export class StiUsedFontsList {
    constructor() {
        this.fonts = [];
    }
    add(fontFamily, fontStyle, fontSize) {
        if (!this.fonts.find((u) => u.fontFamily == fontFamily &&
            u.fontStyle.length == fontStyle.length &&
            u.fontStyle == fontStyle &&
            u.fontSize == fontSize)) {
            this.fonts.push({ fontFamily: fontFamily, fontStyle: fontStyle, fontSize: fontSize });
        }
    }
}
export class StiInterfaceEvent {
    constructor(name, data) {
        this.name = name;
        this.data = data;
    }
}
export class StiClipboardData {
    constructor(value, type, displayValue, clipboardId = "StiFormsClipboard") {
        this.value = value;
        this.type = type;
        this.displayValue = displayValue;
        this.clipboardId = clipboardId;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib2JqZWN0cy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtZm9ybXMvc3JjL2xpYi9zZXJ2aWNlcy9vYmplY3RzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUNBLE9BQU8sRUFBRSxlQUFlLEVBQUUsTUFBTSxpQkFBaUIsQ0FBQztBQUVsRCxNQUFNLE9BQU8saUJBQWlCO0lBQzVCLFlBQW1CLE9BQWUsRUFBUyxLQUFhLEVBQVMsU0FBb0IsRUFBUyxPQUFrQixFQUFTLE9BQWdCO1FBQXRILFlBQU8sR0FBUCxPQUFPLENBQVE7UUFBUyxVQUFLLEdBQUwsS0FBSyxDQUFRO1FBQVMsY0FBUyxHQUFULFNBQVMsQ0FBVztRQUFTLFlBQU8sR0FBUCxPQUFPLENBQVc7UUFBUyxZQUFPLEdBQVAsT0FBTyxDQUFTO0lBQUksQ0FBQztDQUMvSTtBQUVELE1BQU0sT0FBTyxRQUFRO0lBQ25CLFlBQW1CLElBQVksRUFBUyxLQUFXO1FBQWhDLFNBQUksR0FBSixJQUFJLENBQVE7UUFBUyxVQUFLLEdBQUwsS0FBSyxDQUFNO0lBQUksQ0FBQztDQUN6RDtBQUVELE1BQU0sT0FBTyxpQkFBaUI7SUFDNUIsWUFBbUIsSUFBWSxFQUFTLFFBQWdCLEVBQVMsS0FBYSxFQUFTLE9BQWdCO1FBQXBGLFNBQUksR0FBSixJQUFJLENBQVE7UUFBUyxhQUFRLEdBQVIsUUFBUSxDQUFRO1FBQVMsVUFBSyxHQUFMLEtBQUssQ0FBUTtRQUFTLFlBQU8sR0FBUCxPQUFPLENBQVM7SUFBSSxDQUFDO0NBQzdHO0FBRUQsTUFBTSxPQUFPLElBQUk7SUFDZixZQUNTLElBQWEsRUFDYixPQUFnQixFQUNoQixTQUFrQixFQUNsQixHQUFTLEVBQ1QsV0FBcUIsRUFDckIsVUFBZ0IsRUFDaEIsUUFBa0IsRUFDbEIsSUFBYTtRQVBiLFNBQUksR0FBSixJQUFJLENBQVM7UUFDYixZQUFPLEdBQVAsT0FBTyxDQUFTO1FBQ2hCLGNBQVMsR0FBVCxTQUFTLENBQVM7UUFDbEIsUUFBRyxHQUFILEdBQUcsQ0FBTTtRQUNULGdCQUFXLEdBQVgsV0FBVyxDQUFVO1FBQ3JCLGVBQVUsR0FBVixVQUFVLENBQU07UUFDaEIsYUFBUSxHQUFSLFFBQVEsQ0FBVTtRQUNsQixTQUFJLEdBQUosSUFBSSxDQUFTO0lBQ2xCLENBQUM7Q0FDTjtBQUVELE1BQU0sT0FBTyxRQUFRO0lBQ25CLFlBQ1MsSUFBYSxFQUNiLE9BQWdCLEVBQ2hCLEdBQVksRUFDWixJQUFhLEVBQ2IsUUFBa0IsRUFDbEIsU0FBa0IsRUFDbEIsS0FBVztRQU5YLFNBQUksR0FBSixJQUFJLENBQVM7UUFDYixZQUFPLEdBQVAsT0FBTyxDQUFTO1FBQ2hCLFFBQUcsR0FBSCxHQUFHLENBQVM7UUFDWixTQUFJLEdBQUosSUFBSSxDQUFTO1FBQ2IsYUFBUSxHQUFSLFFBQVEsQ0FBVTtRQUNsQixjQUFTLEdBQVQsU0FBUyxDQUFTO1FBQ2xCLFVBQUssR0FBTCxLQUFLLENBQU07SUFDaEIsQ0FBQztDQUNOO0FBRUQsTUFBTSxPQUFPLElBQUk7SUFDZixZQUNTLElBQVksRUFDWixLQUFpQixFQUNqQixNQUFrQixFQUNsQixJQUFZLEVBQ1osS0FBYyxFQUNkLE1BQW1CLEVBQ25CLEdBQVksRUFDWixJQUFhLEVBQ2IsWUFBeUIsRUFDekIsS0FBYyxFQUNkLE1BQWUsRUFDZixhQUFzQixFQUN0QixhQUFzQixFQUN0QixNQUEwQixFQUMxQixhQUFzQixFQUN0QixLQUFXLEVBQ1gsU0FBa0I7UUFoQmxCLFNBQUksR0FBSixJQUFJLENBQVE7UUFDWixVQUFLLEdBQUwsS0FBSyxDQUFZO1FBQ2pCLFdBQU0sR0FBTixNQUFNLENBQVk7UUFDbEIsU0FBSSxHQUFKLElBQUksQ0FBUTtRQUNaLFVBQUssR0FBTCxLQUFLLENBQVM7UUFDZCxXQUFNLEdBQU4sTUFBTSxDQUFhO1FBQ25CLFFBQUcsR0FBSCxHQUFHLENBQVM7UUFDWixTQUFJLEdBQUosSUFBSSxDQUFTO1FBQ2IsaUJBQVksR0FBWixZQUFZLENBQWE7UUFDekIsVUFBSyxHQUFMLEtBQUssQ0FBUztRQUNkLFdBQU0sR0FBTixNQUFNLENBQVM7UUFDZixrQkFBYSxHQUFiLGFBQWEsQ0FBUztRQUN0QixrQkFBYSxHQUFiLGFBQWEsQ0FBUztRQUN0QixXQUFNLEdBQU4sTUFBTSxDQUFvQjtRQUMxQixrQkFBYSxHQUFiLGFBQWEsQ0FBUztRQUN0QixVQUFLLEdBQUwsS0FBSyxDQUFNO1FBQ1gsY0FBUyxHQUFULFNBQVMsQ0FBUztJQUN2QixDQUFDO0NBQ047QUFFRCxNQUFNLE9BQU8saUJBQWlCO0lBQTlCO1FBRVMsYUFBUSxHQUFHLGVBQWUsQ0FBQyxTQUFTLENBQUM7SUFXOUMsQ0FBQztDQUFBO0FBRUQsTUFBTSxPQUFPLHFCQUFxQjtDQUtqQztBQUNELE1BQU0sT0FBTyxTQUFTO0lBQ3BCLFlBQW1CLElBQVksRUFBUyxLQUFXO1FBQWhDLFNBQUksR0FBSixJQUFJLENBQVE7UUFBUyxVQUFLLEdBQUwsS0FBSyxDQUFNO0lBQUksQ0FBQztDQUN6RDtBQUVELE1BQU0sT0FBTyxRQUFRO0lBQ25CLFlBQW1CLFVBQWtCLEVBQVMsU0FBaUIsRUFBUyxRQUFnQjtRQUFyRSxlQUFVLEdBQVYsVUFBVSxDQUFRO1FBQVMsY0FBUyxHQUFULFNBQVMsQ0FBUTtRQUFTLGFBQVEsR0FBUixRQUFRLENBQVE7SUFBSSxDQUFDO0NBQzlGO0FBRUQsTUFBTSxPQUFPLGdCQUFnQjtJQUE3QjtRQUNFLFVBQUssR0FBZSxFQUFFLENBQUM7SUFlekIsQ0FBQztJQWJRLEdBQUcsQ0FBQyxVQUFrQixFQUFFLFNBQWlCLEVBQUUsUUFBZ0I7UUFDaEUsSUFDRSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUNkLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FDSixDQUFDLENBQUMsVUFBVSxJQUFJLFVBQVU7WUFDMUIsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxNQUFNLElBQUksU0FBUyxDQUFDLE1BQU07WUFDdEMsQ0FBQyxDQUFDLFNBQVMsSUFBSSxTQUFTO1lBQ3hCLENBQUMsQ0FBQyxRQUFRLElBQUksUUFBUSxDQUN6QixFQUNELENBQUM7WUFDRCxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxFQUFFLFVBQVUsRUFBRSxVQUFVLEVBQUUsU0FBUyxFQUFFLFNBQVMsRUFBRSxRQUFRLEVBQUUsUUFBUSxFQUFFLENBQUMsQ0FBQztRQUN4RixDQUFDO0lBQ0gsQ0FBQztDQUNGO0FBRUQsTUFBTSxPQUFPLGlCQUFpQjtJQUM1QixZQUFtQixJQUFZLEVBQVMsSUFBVTtRQUEvQixTQUFJLEdBQUosSUFBSSxDQUFRO1FBQVMsU0FBSSxHQUFKLElBQUksQ0FBTTtJQUFJLENBQUM7Q0FDeEQ7QUFFRCxNQUFNLE9BQU8sZ0JBQWdCO0lBQzNCLFlBQW1CLEtBQWEsRUFBUyxJQUFZLEVBQVMsWUFBb0IsRUFBUyxjQUFzQixtQkFBbUI7UUFBakgsVUFBSyxHQUFMLEtBQUssQ0FBUTtRQUFTLFNBQUksR0FBSixJQUFJLENBQVE7UUFBUyxpQkFBWSxHQUFaLFlBQVksQ0FBUTtRQUFTLGdCQUFXLEdBQVgsV0FBVyxDQUE4QjtJQUFJLENBQUM7Q0FDMUkiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBFbGVtZW50UmVmLCBFdmVudEVtaXR0ZXIsIFR5cGUgfSBmcm9tIFwiQGFuZ3VsYXIvY29yZVwiO1xyXG5pbXBvcnQgeyBTdGlGb3JtU2F2ZU1vZGUgfSBmcm9tIFwiLi4vc3lzdGVtL2VudW1zXCI7XHJcblxyXG5leHBvcnQgY2xhc3MgU3RpVG9vbGJveEVsZW1lbnQge1xyXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBjYXB0aW9uOiBTdHJpbmcsIHB1YmxpYyBpbWFnZTogU3RyaW5nLCBwdWJsaWMgY29tcG9uZW50OiBUeXBlPGFueT4sIHB1YmxpYyBlbGVtZW50OiBUeXBlPGFueT4sIHB1YmxpYyBzZXRGb3JtOiBib29sZWFuKSB7IH1cclxufVxyXG5cclxuZXhwb3J0IGNsYXNzIFN0aUV2ZW50IHtcclxuICBjb25zdHJ1Y3RvcihwdWJsaWMgbmFtZTogU3RyaW5nLCBwdWJsaWMgdmFsdWU/OiBhbnkpIHsgfVxyXG59XHJcblxyXG5leHBvcnQgY2xhc3MgU3RpRWRpdG9yUHJvcGVydHkge1xyXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyB0eXBlOiBzdHJpbmcsIHB1YmxpYyBwcm9wZXJ0eTogc3RyaW5nLCBwdWJsaWMgbGFiZWw6IHN0cmluZywgcHVibGljIHRvb2x0aXA/OiBzdHJpbmcpIHsgfVxyXG59XHJcblxyXG5leHBvcnQgY2xhc3MgSXRlbSB7XHJcbiAgY29uc3RydWN0b3IoXHJcbiAgICBwdWJsaWMgbmFtZT86IHN0cmluZyxcclxuICAgIHB1YmxpYyBjYXB0aW9uPzogc3RyaW5nLFxyXG4gICAgcHVibGljIGltYWdlTmFtZT86IHN0cmluZyxcclxuICAgIHB1YmxpYyBrZXk/OiBhbnksXHJcbiAgICBwdWJsaWMgaGF2ZVN1Yk1lbnU/OiBib29sZWFuLFxyXG4gICAgcHVibGljIGltYWdlU2l6ZXM/OiBhbnksXHJcbiAgICBwdWJsaWMgc2VsZWN0ZWQ/OiBib29sZWFuLFxyXG4gICAgcHVibGljIHR5cGU/OiBzdHJpbmdcclxuICApIHsgfVxyXG59XHJcblxyXG5leHBvcnQgY2xhc3MgTWVudUl0ZW0ge1xyXG4gIGNvbnN0cnVjdG9yKFxyXG4gICAgcHVibGljIG5hbWU/OiBzdHJpbmcsXHJcbiAgICBwdWJsaWMgY2FwdGlvbj86IHN0cmluZyxcclxuICAgIHB1YmxpYyBpbWc/OiBzdHJpbmcsXHJcbiAgICBwdWJsaWMgdHlwZT86IHN0cmluZyxcclxuICAgIHB1YmxpYyBzZWxlY3RlZD86IGJvb2xlYW4sXHJcbiAgICBwdWJsaWMgaW1hZ2VTaXplPzogc3RyaW5nLFxyXG4gICAgcHVibGljIHZhbHVlPzogYW55XHJcbiAgKSB7IH1cclxufVxyXG5cclxuZXhwb3J0IGNsYXNzIE1lbnUge1xyXG4gIGNvbnN0cnVjdG9yKFxyXG4gICAgcHVibGljIG5hbWU6IHN0cmluZyxcclxuICAgIHB1YmxpYyBpdGVtczogTWVudUl0ZW1bXSxcclxuICAgIHB1YmxpYyBwYXJlbnQ6IEVsZW1lbnRSZWYsXHJcbiAgICBwdWJsaWMgdHlwZTogc3RyaW5nLFxyXG4gICAgcHVibGljIHN0YXRlPzogc3RyaW5nLFxyXG4gICAgcHVibGljIG1lbnVFbD86IEVsZW1lbnRSZWYsXHJcbiAgICBwdWJsaWMgdG9wPzogbnVtYmVyLFxyXG4gICAgcHVibGljIGxlZnQ/OiBudW1iZXIsXHJcbiAgICBwdWJsaWMgaW5uZXJDb250ZW50PzogRWxlbWVudFJlZixcclxuICAgIHB1YmxpYyB3aWR0aD86IG51bWJlcixcclxuICAgIHB1YmxpYyBoZWlnaHQ/OiBudW1iZXIsXHJcbiAgICBwdWJsaWMgbWVudVN0eWxlTmFtZT86IHN0cmluZyxcclxuICAgIHB1YmxpYyB2ZXJ0aWNhbEl0ZW1zPzogSXRlbVtdLFxyXG4gICAgcHVibGljIGFjdGlvbj86IEV2ZW50RW1pdHRlcjxhbnk+LFxyXG4gICAgcHVibGljIGl0ZW1TdHlsZU5hbWU/OiBzdHJpbmcsXHJcbiAgICBwdWJsaWMgdmFsdWU/OiBhbnksXHJcbiAgICBwdWJsaWMgc2l6ZVN0eWxlPzogc3RyaW5nXHJcbiAgKSB7IH1cclxufVxyXG5cclxuZXhwb3J0IGNsYXNzIFN0aVdlYkZvcm1PcHRpb25zIHtcclxuICBwdWJsaWMgbG9jYWxpemF0aW9uOiBzdHJpbmc7XHJcbiAgcHVibGljIHNhdmVNb2RlID0gU3RpRm9ybVNhdmVNb2RlLkF1dG9tYXRpYztcclxuICBwdWJsaWMgZm9ybTogc3RyaW5nO1xyXG4gIHB1YmxpYyBmb250RmFtaWxpZXM6IHN0cmluZ1tdO1xyXG4gIHB1YmxpYyBpbWFnZXNBcnJheTogYW55W107XHJcbiAgcHVibGljIGFzc2VtYmx5SW5mbzogYW55O1xyXG4gIHB1YmxpYyBhY2NvdW50VXNlclByb3BlcnRpZXM6IGFueTtcclxuICBwdWJsaWMgbG9jYWxpemF0aW9uTGlzdDogU3RpTG9jYWxpemF0aW9uT2JqZWN0W107XHJcbiAgcHVibGljIGxpY2Vuc2VQcm9kdWN0czogYW55O1xyXG4gIHB1YmxpYyB2ZXJzaW9uOiBzdHJpbmc7XHJcbiAgcHVibGljIGNyZWF0aW9uRGF0ZTogc3RyaW5nO1xyXG4gIHB1YmxpYyB1c2VyTmFtZTogc3RyaW5nO1xyXG59XHJcblxyXG5leHBvcnQgY2xhc3MgU3RpTG9jYWxpemF0aW9uT2JqZWN0IHtcclxuICBwdWJsaWMgZGVzY3JpcHRpb246IHN0cmluZztcclxuICBwdWJsaWMgbGFuZ3VhZ2U6IHN0cmluZztcclxuICBwdWJsaWMgZmlsZU5hbWU6IHN0cmluZztcclxuICBwdWJsaWMgY3VsdHVyZU5hbWU6IHN0cmluZztcclxufVxyXG5leHBvcnQgY2xhc3MgRm9ybUV2ZW50IHtcclxuICBjb25zdHJ1Y3RvcihwdWJsaWMgbmFtZTogc3RyaW5nLCBwdWJsaWMgdmFsdWU/OiBhbnkpIHsgfVxyXG59XHJcblxyXG5leHBvcnQgY2xhc3MgVXNlZEZvbnQge1xyXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBmb250RmFtaWx5OiBzdHJpbmcsIHB1YmxpYyBmb250U3R5bGU6IHN0cmluZywgcHVibGljIGZvbnRTaXplOiBudW1iZXIpIHsgfVxyXG59XHJcblxyXG5leHBvcnQgY2xhc3MgU3RpVXNlZEZvbnRzTGlzdCB7XHJcbiAgZm9udHM6IFVzZWRGb250W10gPSBbXTtcclxuXHJcbiAgcHVibGljIGFkZChmb250RmFtaWx5OiBzdHJpbmcsIGZvbnRTdHlsZTogc3RyaW5nLCBmb250U2l6ZTogbnVtYmVyKSB7XHJcbiAgICBpZiAoXHJcbiAgICAgICF0aGlzLmZvbnRzLmZpbmQoXHJcbiAgICAgICAgKHUpID0+XHJcbiAgICAgICAgICB1LmZvbnRGYW1pbHkgPT0gZm9udEZhbWlseSAmJlxyXG4gICAgICAgICAgdS5mb250U3R5bGUubGVuZ3RoID09IGZvbnRTdHlsZS5sZW5ndGggJiZcclxuICAgICAgICAgIHUuZm9udFN0eWxlID09IGZvbnRTdHlsZSAmJlxyXG4gICAgICAgICAgdS5mb250U2l6ZSA9PSBmb250U2l6ZVxyXG4gICAgICApXHJcbiAgICApIHtcclxuICAgICAgdGhpcy5mb250cy5wdXNoKHsgZm9udEZhbWlseTogZm9udEZhbWlseSwgZm9udFN0eWxlOiBmb250U3R5bGUsIGZvbnRTaXplOiBmb250U2l6ZSB9KTtcclxuICAgIH1cclxuICB9XHJcbn1cclxuXHJcbmV4cG9ydCBjbGFzcyBTdGlJbnRlcmZhY2VFdmVudCB7XHJcbiAgY29uc3RydWN0b3IocHVibGljIG5hbWU6IHN0cmluZywgcHVibGljIGRhdGE/OiBhbnkpIHsgfVxyXG59XHJcblxyXG5leHBvcnQgY2xhc3MgU3RpQ2xpcGJvYXJkRGF0YSB7XHJcbiAgY29uc3RydWN0b3IocHVibGljIHZhbHVlOiBzdHJpbmcsIHB1YmxpYyB0eXBlOiBzdHJpbmcsIHB1YmxpYyBkaXNwbGF5VmFsdWU6IHN0cmluZywgcHVibGljIGNsaXBib2FyZElkOiBzdHJpbmcgPSBcIlN0aUZvcm1zQ2xpcGJvYXJkXCIpIHsgfVxyXG59XHJcbiJdfQ==