import StiJson from "../system/StiJson";
export default class StiRectangleGeometry {
    static { this.DELTA = 1; }
    isChanged() {
        return this.savedGeometry == null || !this.savedGeometry.equals(this);
    }
    resetChanged() {
        this.savedGeometry = this.clone();
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyNumber("X", this.x);
        json.addPropertyNumber("Y", this.y);
        json.addPropertyNumber("Width", this.width);
        json.addPropertyNumber("Height", this.height);
        json.addPropertyNumber("MinWidth", this.minWidth);
        json.addPropertyNumber("MinHeight", this.minHeight);
        json.addPropertyNumber("MaxWidth", this.width);
        json.addPropertyNumber("MaxHeight", this.height);
        return json;
    }
    equals(geometry) {
        return (this.x == geometry.x &&
            this.y == geometry.y &&
            this.width == geometry.width &&
            this.height == geometry.height &&
            this.minHeight == geometry.minHeight &&
            this.minWidth == geometry.minWidth);
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "X":
                    this._x = property.value;
                    break;
                case "Y":
                    this._y = property.value;
                    break;
                case "Width":
                    this._width = property.value;
                    break;
                case "Height":
                    this._height = property.value;
                    break;
                case "MinWidth":
                    this._minWidth = property.value;
                    break;
                case "MinHeight":
                    this._minHeight = property.value;
                    break;
                case "MaxWidth":
                    this._maxWidth = property.value;
                    break;
                case "MaxHeight":
                    //this._minHeight = property.value;
                    break;
            }
        }
    }
    clone() {
        let result = new StiRectangleGeometry(this.width, this.height);
        result._x = this.x;
        result._y = this.y;
        result._minWidth = this.minWidth;
        result._minHeight = this.minHeight;
        return result;
    }
    get x() {
        return this._x;
    }
    set x(value) {
        this._x = value;
    }
    get y() {
        return this._y;
    }
    set y(value) {
        this._y = value;
    }
    get width() {
        return this._width;
    }
    set width(value) {
        let oldGeometry = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._width;
        this._width = Math.max(value, this._minWidth);
        if (this.changesInterceptor && oldValue != this._width) {
            this.changesInterceptor.propertyChanged("geometry.width", value, oldGeometry);
        }
    }
    get height() {
        return this._height;
    }
    set height(value) {
        let oldGeometry = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._height;
        this._height = Math.max(value, this.minHeight);
        if (this.changesInterceptor && oldValue != this._height) {
            this.changesInterceptor.propertyChanged("geometry.height", value, oldGeometry);
        }
    }
    get minWidth() {
        return this._minWidth;
    }
    set minWidth(value) {
        let oldGeometry = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._minWidth;
        this._minWidth = Math.min(value, this._maxWidth);
        this._width = Math.max(this._minWidth, this._width);
        if (this.changesInterceptor && oldValue != this._minWidth) {
            this.changesInterceptor.propertyChanged("geometry.minWidth", value, oldGeometry);
        }
    }
    get minHeight() {
        return this._minHeight;
    }
    set minHeight(value) {
        let oldValue = this._minHeight;
        let oldGeometry = this.changesInterceptor ? this.clone() : null;
        this._minHeight = Math.min(value, this._maxHeight);
        this._height = Math.max(this._minHeight, this._height);
        if (this.changesInterceptor && oldValue != this._minHeight) {
            this.changesInterceptor.propertyChanged("geometry.minHeight", value, oldGeometry);
        }
    }
    /*public get maxWidth(): number {
      return this._maxWidth;
    }
  
    public set maxWidth(value: number) {
      let oldValue = this._maxWidth;
      this._maxWidth = Math.max(value, this._minWidth);
      this._width = Math.min(this._maxWidth, this.width);
      if (this.changesInterceptor && oldValue != this._maxWidth) {
        this.changesInterceptor.propertyChanged("geometry.maxWidth", value);
      }
    }
  
    public get maxHeight(): number {
      return this._maxHeight;
    }
  
    public set maxHeight(value: number) {
      let oldValue = this._maxHeight;
      this._maxHeight = Math.max(value, this._minHeight);
      this._height = Math.min(this._maxHeight, this.height);
      if (this.changesInterceptor && oldValue != this._maxHeight) {
        this.changesInterceptor.propertyChanged("geometry.maxHeight", value);
      }
    }*/
    get right() {
        return this._x + this._width;
    }
    get bottom() {
        return this._y + this._height;
    }
    get centerX() {
        return this._x + this._width / 2;
    }
    get centerY() {
        return this._y + this._height / 2;
    }
    constructor(width = 0, height = 0, changesInterceptor) {
        this._x = 0;
        this._y = 0;
        this._minWidth = 0;
        this._minHeight = 0;
        this._maxWidth = 10000000;
        this._maxHeight = 10000000;
        this.width = width;
        this.height = height;
        this._minWidth = 5;
        this._minHeight = height;
        this.changesInterceptor = changesInterceptor;
    }
    withY(newY) {
        let copy = this.clone();
        copy.y = newY;
        return copy;
    }
    xProjectionIntersectsWith(other) {
        return (this.x < other.right &&
            this.right > other.x &&
            Math.abs(this.right - other.x) > StiRectangleGeometry.DELTA &&
            Math.abs(this.x - other.right) > StiRectangleGeometry.DELTA);
    }
    intersectWith(geometry) {
        let aLeftOfB = geometry.right - StiRectangleGeometry.DELTA < this.x;
        let aRightOfB = geometry.x > this.right - StiRectangleGeometry.DELTA;
        let aAboveB = geometry.y > this.bottom - StiRectangleGeometry.DELTA;
        let aBelowB = geometry.bottom - StiRectangleGeometry.DELTA < this.y;
        return !(aLeftOfB || aRightOfB || aAboveB || aBelowB);
    }
}
//# sourceMappingURL=data:application/json;base64,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