import StiJson from "../system/StiJson";
import { StiPen } from "./StiPen";
export default class StiInnerBorder {
    constructor(pen, drawHorizontal, drawVertical) {
        this.pen = pen;
        this.drawHorizontal = drawHorizontal;
        this.drawVertical = drawVertical;
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyJObject("Pen", this.pen?.saveToJsonObject(options));
        json.addPropertyBool("DrawHorizontal", this.drawHorizontal);
        json.addPropertyBool("DrawVertical", this.drawVertical);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Pen":
                    this.pen = new StiPen();
                    this.pen.loadFromJsonObject(property.value);
                    break;
                case "DrawHorizontal":
                    this.drawHorizontal = property.value;
                    break;
                case "DrawVertical":
                    this.drawVertical = property.value;
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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