import Color from "../../system/Color";
import { Enum } from "../../system/Enum";
import { StiHorizontalAlignment, StiVerticalAlignment } from "../../system/enums";
import { Font } from "../../system/Font";
import { StiBackgroundedTextItem } from "./StiBackgroundedTextItem";
export class StiBackgroundedAlignedTextItem extends StiBackgroundedTextItem {
    constructor(value = "", font = new Font("Segoe UI", 15), color = Color.black(), backgroundColor = Color.white(), horizontalAlignment = StiHorizontalAlignment.Center, verticalAlignment = StiVerticalAlignment.Center) {
        super(value, font, color, backgroundColor);
        this.font = font;
        this.color = color;
        this.backgroundColor = backgroundColor;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
    }
    get eContentAlignment() {
        return this.horizontalAlignment;
    }
    set eContentAlignment(value) {
        this.horizontalAlignment = value;
    }
    get eVerticalAlignment() {
        return this.verticalAlignment;
    }
    set eVerticalAlignment(value) {
        this.verticalAlignment = value;
    }
    haveVerticalAlignment() {
        return true;
    }
    haveContentAlignment() {
        return true;
    }
    saveToJsonObject(options) {
        let json = super.saveToJsonObject(options);
        json.addPropertyEnum("HorizontalAlignment", StiHorizontalAlignment, this.horizontalAlignment);
        json.addPropertyEnum("VerticalAlignment", StiVerticalAlignment, this.verticalAlignment);
        return json;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "HorizontalAlignment":
                    this.horizontalAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "VerticalAlignment":
                    this.verticalAlignment = Enum.parse(StiVerticalAlignment, property.value);
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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