import { StiTextBoxCellItem } from "../cells/StiTextBoxCellItem";
import { StiColumnItem } from "../StiColumnItem";
export class StiTextBoxColumnItem extends StiColumnItem {
    constructor() {
        super(...arguments);
        this.type = "TextBoxColumn";
        this.cells = [];
    }
    get value() {
        let result = [];
        this.cells.forEach((c) => result.push(c.text));
        return result;
    }
    setDefaultValues() {
        this.cells.forEach((cell) => {
            cell.text = "";
        });
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyArray("Cells", this.cells);
        return jObject;
    }
    createCell() {
        return new StiTextBoxCellItem("", "");
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Cells":
                    this.cells = [];
                    for (let cellJson of property.value.value) {
                        let cell = new StiTextBoxCellItem();
                        cell.loadFromJsonObject(cellJson);
                        this.cells.push(cell);
                    }
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU3RpVGV4dEJveENvbHVtbkl0ZW0uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zdGltdWxzb2Z0LWZvcm1zL3NyYy9saWIvZWxlbWVudHMvdGFibGUvY29sdW1ucy9TdGlUZXh0Qm94Q29sdW1uSXRlbS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFHQSxPQUFPLEVBQUUsa0JBQWtCLEVBQUUsTUFBTSw2QkFBNkIsQ0FBQztBQUNqRSxPQUFPLEVBQUUsYUFBYSxFQUFFLE1BQU0sa0JBQWtCLENBQUM7QUFFakQsTUFBTSxPQUFPLG9CQUFxQixTQUFRLGFBQWE7SUFBdkQ7O1FBQ1MsU0FBSSxHQUFHLGVBQWUsQ0FBQztRQUN2QixVQUFLLEdBQXlCLEVBQUUsQ0FBQztJQXFDMUMsQ0FBQztJQW5DQyxJQUFXLEtBQUs7UUFDZCxJQUFJLE1BQU0sR0FBRyxFQUFFLENBQUM7UUFDaEIsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7UUFDL0MsT0FBTyxNQUFNLENBQUM7SUFDaEIsQ0FBQztJQUNELGdCQUFnQjtRQUNkLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsSUFBSSxFQUFFLEVBQUU7WUFDMUIsSUFBSSxDQUFDLElBQUksR0FBRyxFQUFFLENBQUM7UUFDakIsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBQ0QsZ0JBQWdCLENBQUMsT0FBWTtRQUMzQixJQUFJLE9BQU8sR0FBRyxLQUFLLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDOUMsT0FBTyxDQUFDLGdCQUFnQixDQUFDLE9BQU8sRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDOUMsT0FBTyxPQUFPLENBQUM7SUFDakIsQ0FBQztJQUVNLFVBQVU7UUFDZixPQUFPLElBQUksa0JBQWtCLENBQUMsRUFBRSxFQUFFLEVBQUUsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFFTSxrQkFBa0IsQ0FBQyxJQUFhO1FBQ3JDLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUMvQixLQUFLLElBQUksUUFBUSxJQUFJLElBQUksQ0FBQyxVQUFVLEVBQUUsRUFBRSxDQUFDO1lBQ3ZDLFFBQVEsUUFBUSxDQUFDLElBQUksRUFBRSxDQUFDO2dCQUN0QixLQUFLLE9BQU87b0JBQ1YsSUFBSSxDQUFDLEtBQUssR0FBRyxFQUFFLENBQUM7b0JBQ2hCLEtBQUssSUFBSSxRQUFRLElBQUksUUFBUSxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQzt3QkFDMUMsSUFBSSxJQUFJLEdBQUcsSUFBSSxrQkFBa0IsRUFBRSxDQUFDO3dCQUNwQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLENBQUM7d0JBQ2xDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO29CQUN4QixDQUFDO29CQUNELE1BQU07WUFDVixDQUFDO1FBQ0gsQ0FBQztJQUNILENBQUM7Q0FDRiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFN0aVZhbHVlRWxlbWVudCB9IGZyb20gXCIuLi8uLi8uLi9zeXN0ZW0vaW50ZXJmYWNlc1wiO1xyXG5pbXBvcnQgU3RpSnNvbiBmcm9tIFwiLi4vLi4vLi4vc3lzdGVtL1N0aUpzb25cIjtcclxuaW1wb3J0IHsgU3RpVGFibGVFbGVtZW50IH0gZnJvbSBcIi4uLy4uL1N0aVRhYmxlRWxlbWVudFwiO1xyXG5pbXBvcnQgeyBTdGlUZXh0Qm94Q2VsbEl0ZW0gfSBmcm9tIFwiLi4vY2VsbHMvU3RpVGV4dEJveENlbGxJdGVtXCI7XHJcbmltcG9ydCB7IFN0aUNvbHVtbkl0ZW0gfSBmcm9tIFwiLi4vU3RpQ29sdW1uSXRlbVwiO1xyXG5cclxuZXhwb3J0IGNsYXNzIFN0aVRleHRCb3hDb2x1bW5JdGVtIGV4dGVuZHMgU3RpQ29sdW1uSXRlbSBpbXBsZW1lbnRzIFN0aVZhbHVlRWxlbWVudCB7XHJcbiAgcHVibGljIHR5cGUgPSBcIlRleHRCb3hDb2x1bW5cIjtcclxuICBwdWJsaWMgY2VsbHM6IFN0aVRleHRCb3hDZWxsSXRlbVtdID0gW107XHJcblxyXG4gIHB1YmxpYyBnZXQgdmFsdWUoKTogT2JqZWN0IHtcclxuICAgIGxldCByZXN1bHQgPSBbXTtcclxuICAgIHRoaXMuY2VsbHMuZm9yRWFjaCgoYykgPT4gcmVzdWx0LnB1c2goYy50ZXh0KSk7XHJcbiAgICByZXR1cm4gcmVzdWx0O1xyXG4gIH1cclxuICBzZXREZWZhdWx0VmFsdWVzKCkge1xyXG4gICAgdGhpcy5jZWxscy5mb3JFYWNoKChjZWxsKSA9PiB7XHJcbiAgICAgIGNlbGwudGV4dCA9IFwiXCI7XHJcbiAgICB9KTtcclxuICB9XHJcbiAgc2F2ZVRvSnNvbk9iamVjdChvcHRpb25zOiBhbnkpOiBTdGlKc29uIHtcclxuICAgIGxldCBqT2JqZWN0ID0gc3VwZXIuc2F2ZVRvSnNvbk9iamVjdChvcHRpb25zKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlBcnJheShcIkNlbGxzXCIsIHRoaXMuY2VsbHMpO1xyXG4gICAgcmV0dXJuIGpPYmplY3Q7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgY3JlYXRlQ2VsbCgpOiBhbnkge1xyXG4gICAgcmV0dXJuIG5ldyBTdGlUZXh0Qm94Q2VsbEl0ZW0oXCJcIiwgXCJcIik7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgbG9hZEZyb21Kc29uT2JqZWN0KGpzb246IFN0aUpzb24pIHtcclxuICAgIHN1cGVyLmxvYWRGcm9tSnNvbk9iamVjdChqc29uKTtcclxuICAgIGZvciAobGV0IHByb3BlcnR5IG9mIGpzb24ucHJvcGVydGllcygpKSB7XHJcbiAgICAgIHN3aXRjaCAocHJvcGVydHkubmFtZSkge1xyXG4gICAgICAgIGNhc2UgXCJDZWxsc1wiOlxyXG4gICAgICAgICAgdGhpcy5jZWxscyA9IFtdO1xyXG4gICAgICAgICAgZm9yIChsZXQgY2VsbEpzb24gb2YgcHJvcGVydHkudmFsdWUudmFsdWUpIHtcclxuICAgICAgICAgICAgbGV0IGNlbGwgPSBuZXcgU3RpVGV4dEJveENlbGxJdGVtKCk7XHJcbiAgICAgICAgICAgIGNlbGwubG9hZEZyb21Kc29uT2JqZWN0KGNlbGxKc29uKTtcclxuICAgICAgICAgICAgdGhpcy5jZWxscy5wdXNoKGNlbGwpO1xyXG4gICAgICAgICAgfVxyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgIH1cclxuICAgIH1cclxuICB9XHJcbn1cclxuIl19