import { StiRadioButtonCellItem } from "../cells/StiRadioButtonCellItem";
import { StiColumnItem } from "../StiColumnItem";
export class StiRadioButtonColumnItem extends StiColumnItem {
    constructor() {
        super(...arguments);
        this.type = "RadioButtonColumn";
        this.cells = [];
    }
    get value() {
        let result = [];
        this.cells.forEach((c) => result.push(c.isChecked));
        return result;
    }
    setDefaultValues() {
        this.cells.forEach((cell) => {
            cell.isChecked = false;
        });
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyArray("Cells", this.cells);
        jObject.addPropertyString("Name", this.name);
        return jObject;
    }
    createCell() {
        return new StiRadioButtonCellItem("", false);
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Cells":
                    this.cells = [];
                    for (let cellJson of property.value.value) {
                        let cell = new StiRadioButtonCellItem();
                        cell.loadFromJsonObject(cellJson);
                        this.cells.push(cell);
                    }
                    break;
                case "Name":
                    this.name = property.value;
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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