import { Enum } from "../../../system/Enum";
import { StiDisplayCurrencyAs, StiHorizontalAlignment, StiNumberType, StiThousandSeparator, StiUnitAlignment, } from "../../../system/enums";
import { StiNumberBoxCellItem } from "../cells/StiNumberBoxCellItem";
import { StiColumnItem } from "../StiColumnItem";
export class StiNumberBoxColumnItem extends StiColumnItem {
    constructor(label, form) {
        super(label, form);
        this.label = label;
        this.form = form;
        this._decimalDigits = 2;
        this.type = "NumberBoxColumn";
        this.unitLabel = "";
        this.cells = [];
        this.thousandSeparator = StiThousandSeparator.None;
        this.numberType = StiNumberType.Decimal;
        this.unitAlignment = StiUnitAlignment.Suffix;
        this.currencyLabelFormat = StiDisplayCurrencyAs.Code;
        this.currency = "USD";
        if (form) {
            this._decimalDigits = form.settings.decimalDigits;
            this.thousandSeparator = form.settings.thousandSeparator;
            this.unitAlignment = form.settings.unitAlignment;
            this.currency = form.settings.currency;
            this.currencyLabelFormat = form.settings.currencyFormat;
        }
    }
    copyFrom(parentItem) {
        super.copyFrom(parentItem);
        if (parentItem instanceof StiNumberBoxColumnItem) {
            let numberBox = parentItem;
            this.unitLabel = numberBox.unitLabel;
            this.thousandSeparator = numberBox.thousandSeparator;
            this.numberType = numberBox.numberType;
            this.unitAlignment = numberBox.unitAlignment;
            this.currencyLabelFormat = numberBox.currencyLabelFormat;
            this.currency = numberBox.currency;
        }
    }
    createCell() {
        return new StiNumberBoxCellItem("", 0);
    }
    setDefaultValues() {
        this.cells.forEach((cell) => {
            cell.number = 0;
        });
    }
    get decimalDigits() {
        return this._decimalDigits;
    }
    set decimalDigits(value) {
        if (value <= 0) {
            this._decimalDigits = 0;
        }
        else {
            this._decimalDigits = value;
        }
    }
    get value() {
        let result = [];
        this.cells.forEach((c) => result.push(c.number));
        return result;
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyArray("Cells", this.cells);
        jObject.addPropertyEnum("CurrencyLabelFormat", StiDisplayCurrencyAs, this.currencyLabelFormat);
        jObject.addPropertyString("Currency", this.currency);
        jObject.addPropertyString("UnitLabel", this.unitLabel);
        jObject.addPropertyEnum("UnitAlignment", StiUnitAlignment, this.unitAlignment);
        jObject.addPropertyEnum("NumberType", StiNumberType, this.numberType);
        jObject.addPropertyEnum("ThousandSeparator", StiThousandSeparator, this.thousandSeparator);
        jObject.addPropertyNumber("DecimalDigits", this.decimalDigits);
        return jObject;
    }
    htmlStyle() {
        if (this.eParent) {
            return super.htmlStyle();
        }
        else
            return `${this.eParent ? super.htmlStyle() + ";" : ""}color:${this.cellForeColor?.toHtmlColor()};text-align:${Enum.getName(StiHorizontalAlignment, this.cellAlignment)}`;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Cells":
                    this.cells = [];
                    for (let cellJson of property.value.value) {
                        let cell = new StiNumberBoxCellItem("", 0);
                        cell.loadFromJsonObject(cellJson);
                        this.cells.push(cell);
                    }
                    break;
                case "NumberType":
                    this.numberType = Enum.parse(StiNumberType, property.value);
                    break;
                case "ThousandSeparator":
                    this.thousandSeparator = Enum.parse(StiThousandSeparator, property.value);
                    break;
                case "DecimalDigits":
                    this.decimalDigits = property.value;
                    break;
                case "UnitLabel":
                    this.unitLabel = property.value;
                    break;
                case "UnitAlignment":
                    this.unitAlignment = Enum.parse(StiUnitAlignment, property.value);
                    break;
                case "CurrencyLabelFormat":
                    this.currencyLabelFormat = Enum.parse(StiDisplayCurrencyAs, property.value);
                    break;
                case "Currency":
                    this.currency = property.value;
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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