import { StiComboBoxCellItem } from "../cells/StiComboBoxCellItem";
import { StiColumnItem } from "../StiColumnItem";
export class StiComboBoxColumnItem extends StiColumnItem {
    constructor() {
        super(...arguments);
        this.type = "ComboBoxColumn";
        this.cells = [];
        this.comboBoxOptions = [];
    }
    get value() {
        let result = [];
        this.cells.forEach((c) => result.push(c.selectedIndex > 0 && this.comboBoxOptions.length < c.selectedIndex
            ? this.comboBoxOptions[c.selectedIndex]
            : null));
        return result;
    }
    setDefaultValues() {
        this.cells.forEach((cell) => {
            cell.selectedIndex = 0;
        });
    }
    createCell() {
        return new StiComboBoxCellItem("", 0);
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyArray("Cells", this.cells);
        jObject.addPropertyArray("ComboBoxOptions", this.comboBoxOptions);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Cells":
                    this.cells = [];
                    for (let cellJson of property.value.value) {
                        let cell = new StiComboBoxCellItem();
                        cell.loadFromJsonObject(cellJson);
                        this.cells.push(cell);
                    }
                    break;
                case "ComboBoxOptions":
                    this.comboBoxOptions = [];
                    property.value.properties().forEach((p) => this.comboBoxOptions.push(p.value));
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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