import Color from "../../system/Color";
import { Enum } from "../../system/Enum";
import { StiLabelAlignment, StiVerticalAlignment } from "../../system/enums";
import { Font } from "../../system/Font";
import { StiDescriptionSettings } from "./StiDescriptionSettings";
export class StiLabelSettings extends StiDescriptionSettings {
    constructor(changesInterceptor) {
        super(changesInterceptor);
        this.changesInterceptor = changesInterceptor;
        this._alignment = StiLabelAlignment.Left;
        this._verticalAlignment = StiVerticalAlignment.Center;
        this._width = 150;
        this._font = new Font("Segoe UI", 10, [], this);
        this._color = Color.black();
        this._color.changesInterceptor = this;
    }
    propertyChanged(propName, value, oldObject) {
        this.changesInterceptor.propertyChanged(`label.${propName}`, value, oldObject);
    }
    get alignment() {
        return this._alignment;
    }
    set alignment(value) {
        let oldValue = this._alignment;
        this._alignment = value;
        if (oldValue != value) {
            this.propertyChanged("alignment", value, oldValue);
        }
    }
    get verticalAlignment() {
        return this._verticalAlignment;
    }
    set verticalAlignment(value) {
        let oldValue = this._verticalAlignment;
        this._verticalAlignment = value;
        if (oldValue != value) {
            this.propertyChanged("verticalAlignment", value, oldValue);
        }
    }
    get width() {
        return this._width;
    }
    set width(value) {
        let oldValue = this._width;
        this._width = value;
        if (oldValue != value) {
            this.propertyChanged("width", value, oldValue);
        }
    }
    saveToJsonObject(options) {
        let json = super.saveToJsonObject(options);
        json.addPropertyEnum("Alignment", StiLabelAlignment, this.alignment);
        json.addPropertyEnum("VerticalAlignment", StiVerticalAlignment, this.verticalAlignment);
        json.addPropertyNumber("Width", this.width);
        return json;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Alignment":
                    this._alignment = Enum.parse(StiLabelAlignment, property.value);
                    break;
                case "VerticalAlignment":
                    this._verticalAlignment = Enum.parse(StiVerticalAlignment, property.value);
                    break;
                case "Width":
                    this._width = property.value;
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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