import Color from "../../system/Color";
import { Font } from "../../system/Font";
import StiJson from "../../system/StiJson";
export class StiDescriptionSettings {
    constructor(changesInterceptor) {
        this.changesInterceptor = changesInterceptor;
        this._font = new Font("Segoe UI", 9, [], this);
        this._color = Color.gray();
        this._color.changesInterceptor = this;
    }
    propertyChanged(propName, value, oldObject) {
        this.changesInterceptor.propertyChanged(`description.${propName}`, value, oldObject);
    }
    get color() {
        return this._color;
    }
    set color(value) {
        let oldValue = this._color.clone();
        this._color = value;
        value.changesInterceptor = this;
        if (oldValue && !oldValue.equals(value)) {
            this.propertyChanged("color", value, oldValue);
        }
    }
    get font() {
        return this._font;
    }
    set font(value) {
        let oldValue = this._font;
        this._font = value;
        if (oldValue && oldValue.equals(oldValue)) {
            this._font.changesInterceptor = this;
        }
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyJObject("Font", this.font.saveToJsonObject(options));
        json.addPropertyColor("Color", this.color);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Font":
                    this._font = new Font("Segoe UI", 9, [], this);
                    this._font.loadFromJsonObject(property.value);
                    break;
                case "Color":
                    this._color = new Color();
                    this._color.changesInterceptor = this;
                    this._color.deserializeFromString(property.value);
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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