import StiInnerBorder from "../properties/StiInnerBorder";
import { StiBorder } from "../properties/StiBorder";
import { StiPen } from "../properties/StiPen";
import StiRectangleGeometry from "../properties/StiRectangleGeometry";
import { StiLocalizationService } from "../services/sti-localization.service";
import Color from "../system/Color";
import { Enum } from "../system/Enum";
import { StiHorizontalAlignment, StiVerticalAlignment, StiLabelAlignment } from "../system/enums";
import { Font } from "../system/Font";
import { StiFormElement } from "./base/StiFormElement";
import { StiCheckBoxColumnItem } from "./table/columns/StiCheckBoxColumnItem";
import { StiComboBoxColumnItem } from "./table/columns/StiComboBoxColumnItem";
import { StiLabelColumnItem } from "./table/columns/StiLabelColumnItem";
import { StiNumberBoxColumnItem } from "./table/columns/StiNumberBoxColumnItem";
import { StiRadioButtonColumnItem } from "./table/columns/StiRadioButtonColumnItem";
import { StiTextBoxColumnItem } from "./table/columns/StiTextBoxColumnItem";
import { StiColumnItem } from "./table/StiColumnItem";
import { StiRowLabel } from "./table/StiRowLabel";
import { StiTotalsFieldItem } from "./table/StiTotalsFieldItem";
import { StiTotalsRowHeaderEditableContent } from "./table/StiTotalsRowHeaderEditableContent";
import { StiLabelItem } from "./text/StiLabelItem";
import { StiTextItem } from "./text/StiTextItem";
import { StiInputTextItem } from "../helper/StiInputTextItem";
export class StiTableElement extends StiFormElement {
    get showRowLabels() {
        return this._showRowLabels;
    }
    set showRowLabels(value) {
        let previousValue = this._showRowLabels;
        if (previousValue != value) {
            this._showRowLabels = value;
            this.fitTable();
        }
    }
    get showHeaderEditor() {
        return this._showHeaderEditor;
    }
    set showHeaderEditor(value) {
        this._showHeaderEditor = value;
        if (value == true) {
            this._showColumnsEditor = false;
            this._showRowsEditor = false;
            this._showTotalsEditor = false;
        }
    }
    set name(value) {
        let oldName = this.name;
        super.name = value;
        this.nameChanged(oldName);
    }
    get name() {
        return super.name;
    }
    get totalsValuesWidth() {
        return this._totalsValuesWidth;
    }
    set totalsValuesWidth(value) {
        if (value > 0) {
            this._totalsValuesWidth = value;
        }
        else {
            this._totalsValuesWidth = 0;
        }
    }
    get totalsHeadersWidth() {
        return this._totalsHeadersWidth;
    }
    set totalsHeadersWidth(value) {
        if (value > 0) {
            this._totalsHeadersWidth = value;
        }
        else {
            this._totalsHeadersWidth = 0;
        }
    }
    get showColumnsEditor() {
        return this._showColumnsEditor;
    }
    set showColumnsEditor(value) {
        this._showColumnsEditor = value;
        if (value == true) {
            this._showHeaderEditor = false;
            this._showRowsEditor = false;
            this._showTotalsEditor = false;
        }
    }
    get showRowsEditor() {
        return this._showRowsEditor;
    }
    set showRowsEditor(value) {
        this._showRowsEditor = value;
        if (value == true) {
            this._showHeaderEditor = false;
            this._showColumnsEditor = false;
            this._showTotalsEditor = false;
        }
    }
    get showTotalsEditor() {
        return this._showTotalsEditor;
    }
    set showTotalsEditor(value) {
        this._showTotalsEditor = value;
        if (value == true) {
            this._showHeaderEditor = false;
            this._showColumnsEditor = false;
            this._showRowsEditor = false;
        }
    }
    getDefaultEditableContent() {
        let textItem = new StiInputTextItem("", this.font);
        textItem.element = this;
        return textItem;
    }
    constructor(form) {
        super();
        this.type = "TableElement";
        this.description = new StiTextItem();
        this.font = new Font("Segoe UI", 10);
        this.border = new StiBorder(StiPen.dimGraySolid(), true, true, true, true);
        this.gridLines = new StiInnerBorder(StiPen.dimGraySolid(), true, true);
        this.backgroundColor = Color.transparent();
        this.alternateRowColors = false;
        this.evenRowsStyle = Color.fromArgb(0xff, 0xf9, 0xf9, 0xf9);
        this.evenRowsTextColor = Color.black();
        this.oddRowsStyle = Color.fromArgb(0xff, 0xf3, 0xf3, 0xf3);
        this.oddRowsTextColor = Color.black();
        this.tableHeaderText = "";
        this.tableHeaderAlignment = StiHorizontalAlignment.Left;
        this.tableHeaderColor = Color.black();
        this.tableHeaderHeight = 0;
        this.tableHeaderBackgroundColor = Color.transparent();
        this.rowLabelsWidth = 100;
        this._showRowLabels = false;
        this.dynamicRows = false;
        this.useWordWrap = false;
        this.rowLabelsContentEditable = [];
        this.rowLabelsHorizontalAlignment = StiHorizontalAlignment.Left;
        this.rowHeadersBackground = Color.transparent();
        this.rowHeadersColor = Color.black();
        this.rowHeadersBorder = new StiBorder(StiPen.dimGraySolid(), true, true, true, true);
        this.columnHeadersBorder = new StiBorder(StiPen.dimGraySolid(), true, true, true, true);
        this._columns = [];
        this.useTotals = true;
        this.totalsRowHeader = StiLocalizationService.get("PropertyMain", "Totals");
        this.totalsRowHeaderHorizontalAlignment = StiHorizontalAlignment.Left;
        this.totalsRowHeaderVerticalAlignment = StiVerticalAlignment.Top;
        this.totalsRowHeaderColor = Color.black();
        this._totalsValuesWidth = 100;
        this._totalsHeadersWidth = 100;
        this.totalsFields = [];
        this.showBorderEditor = false;
        this.showGridLinesEditor = false;
        this._showHeaderEditor = true;
        this._showColumnsEditor = false;
        this._showRowsEditor = false;
        this._showTotalsEditor = false;
        this.stopFit = false;
        this.showColumnsBorderEditor = true;
        this.showRowsBorderEditor = false;
        this.minColumnWidth = 40;
        this.totalsRowHeaderEditableContent = new StiTotalsRowHeaderEditableContent(this);
        this.form = form;
        this.geometry = new StiRectangleGeometry(320, 245);
        this.label = new StiLabelItem(this, StiLocalizationService.get("Components", "StiTable"));
        this.columns = [];
        this.rowLabels = ["", "", ""];
        this.columns.push(this.createColumn("textbox"));
        /*this.columns.push(new StiComboBoxColumnItem(StiLocalizationService.get("PropertyMain", "Second")));
        this.columns.push(new StiRadioButtonColumnItem(StiLocalizationService.get("PropertyMain", "Third")));
        this.columns.push(new StiTextBoxColumnItem(StiLocalizationService.get("PropertyMain", "Fourth")));
        this.columns.push(new StiNumberBoxColumnItem(StiLocalizationService.get("PropertyMain", "Fifth")));
        this.columns.push(new StiLabelColumnItem(StiLocalizationService.get("PropertyMain", "Labels")));
        this.rowLabels = [];
        this.rowLabels.push(StiLocalizationService.get("PropertyMain", "First"));
        this.rowLabels.push(StiLocalizationService.get("PropertyMain", "Second"));
        this.rowLabels.push(StiLocalizationService.get("PropertyMain", "Third"));
        this.totalsFields.push(new StiTotalsFieldItem(StiLocalizationService.get("PropertyMain", "First"), "{Cell(5,1)}", this.form));
        this.totalsFields.push(
          new StiTotalsFieldItem(StiLocalizationService.get("PropertyMain", "Maximum"), "{Max(Col(5))}", this.form)
        );
        this.totalsFields.push(
          new StiTotalsFieldItem(StiLocalizationService.get("PropertyMain", "Summary"), "{Sum(Col(5))}", this.form)
        );
        this.totalsFields.push(
          new StiTotalsFieldItem(StiLocalizationService.get("PropertyMain", "Count"), "{Count(Col(5))}", this.form)
        );
        this.columns.forEach((column) => {
          if (column.type == "CheckBoxColumn" && column instanceof StiCheckBoxColumnItem) {
            this.rowLabels.forEach((row) => {
              column.cells.push(new StiCheckBoxCellItem("", false));
            });
          } else if (column.type == "ComboBoxColumn" && column instanceof StiComboBoxColumnItem) {
            column.comboBoxOptions.push("yes");
            column.comboBoxOptions.push("no");
            this.rowLabels.forEach((row) => {
              column.cells.push(new StiComboBoxCellItem("", 0));
            });
          } else if (column.type == "RadioButtonColumn" && column instanceof StiRadioButtonColumnItem) {
            this.rowLabels.forEach((row) => {
              column.cells.push(new StiRadioButtonCellItem("", false));
            });
          } else if (column.type == "TextBoxColumn" && column instanceof StiTextBoxColumnItem) {
            this.rowLabels.forEach((row) => {
              column.cells.push(new StiTextBoxCellItem("", ""));
            });
          } else if (column.type == "NumberBoxColumn" && column instanceof StiNumberBoxColumnItem) {
            this.rowLabels.forEach((row) => {
              column.cells.push(new StiNumberBoxCellItem("", 0));
            });
          } else if (column.type == "LabelColumn" && column instanceof StiLabelColumnItem) {
            this.rowLabels.forEach((row) => {
              column.cells.push("");
            });
          }
        });*/
    }
    createColumn(type, label, parentItem) {
        type = type.toLocaleLowerCase();
        label = label ?? "";
        let columnItem;
        if (type.startsWith("checkbox")) {
            columnItem = new StiCheckBoxColumnItem(label, this.form);
        }
        else if (type.startsWith("combobox")) {
            columnItem = new StiComboBoxColumnItem(label, this.form);
        }
        else if (type.startsWith("numberbox")) {
            columnItem = new StiNumberBoxColumnItem(label, this.form);
        }
        else if (type.startsWith("radiobutton")) {
            columnItem = new StiRadioButtonColumnItem(label, this.form);
        }
        else if (type.startsWith("textbox")) {
            columnItem = new StiTextBoxColumnItem(label, this.form);
        }
        else if (type.startsWith("label")) {
            columnItem = new StiLabelColumnItem(label, this.form);
        }
        if (parentItem) {
            columnItem.copyFrom(parentItem);
        }
        return columnItem;
    }
    setTabIndex(value) {
        this.tabIndex = value;
        return value + (this.columns?.length * this._rowLabels?.length ?? 0);
    }
    get maxTableWidth() {
        return (this.width -
            this.padding.left -
            this.padding.right -
            (this.label.alignment != StiLabelAlignment.Top && this.label.value.length > 0 ? this.label.width : 0));
    }
    set rowLabels(value) {
        this.nativeRowLabels = value;
        let this_ = this;
        this._rowLabels = new Proxy(value, {
            deleteProperty: function (target, property) {
                setTimeout(() => {
                    this_.updateRowLabelsContentEditable();
                }, 0);
                return true;
            },
            set: function (target, property, value, receiver) {
                target[property] = value;
                this_.updateRowLabelsContentEditable();
                return true;
            },
        });
        this.updateRowLabelsContentEditable();
    }
    get rowLabels() {
        return this._rowLabels;
    }
    setDefaultValues() {
        this.columns.forEach((column) => {
            column.setDefaultValues();
        });
        this.totalsFields.forEach((total) => {
            total.setDefaultValues();
        });
    }
    set columns(value) {
        let this_ = this;
        this._columns = new Proxy(value, {
            deleteProperty: function (target, property) {
                setTimeout(() => {
                    this_.fitTable();
                }, 0);
                return true;
            },
            set: function (target, property, value, receiver) {
                target[property] = value;
                let column = value;
                if (column instanceof StiColumnItem && !column.width) {
                    column.width = this_.maxTableWidth / (this_.columns.length + (this_.showRowLabels ? 1 : 0));
                }
                if (value.cells && value.cells.length < this_.rowLabels.length) {
                    for (let i = value.cells.length; i < this_.rowLabels.length; i++)
                        value.cells.push(column.createCell());
                }
                if (!target.stopFit) {
                    this_.fitTable();
                }
                return true;
            },
        });
        this_.fitTable();
    }
    fitTable() {
        if (this.stopFit) {
            return;
        }
        let currentWidth = this.showRowLabels ? this.rowLabelsWidth : 0;
        this.columns.forEach((c) => (currentWidth += c.width));
        let pc = this.maxTableWidth / currentWidth;
        if (currentWidth != 0 && currentWidth && pc) {
            if (this.showRowLabels) {
                this.rowLabelsWidth *= pc;
            }
            this.columns.forEach((c) => (c.width *= pc));
        }
        pc = this.maxTableWidth / (this.totalsHeadersWidth + this.totalsValuesWidth);
        if (pc < 1) {
            this.totalsHeadersWidth *= pc;
            this.totalsValuesWidth *= pc;
        }
    }
    deleteLastRow() {
        this.rowLabels.splice(this.rowLabels.length - 1, 1);
    }
    deleteLastColumn() {
        this.columns.splice(this.columns.length - 1, 1);
    }
    addColumnLikeLast() {
        let newColumnWidth = (this.maxTableWidth - this.rowLabelsWidth) / (this.columns.length + 1);
        let maxChangeableWidth = 0;
        if (this.columns.length > 0) {
            this.columns.forEach((column) => {
                if (column.width > this.minColumnWidth) {
                    maxChangeableWidth += column.width - this.minColumnWidth;
                }
            });
        }
        else {
            maxChangeableWidth = this.maxTableWidth - this.rowLabelsWidth;
        }
        if (newColumnWidth <= maxChangeableWidth) {
            if (this.columns.length > 0) {
                let lastColumn = this.columns[this.columns.length - 1];
                this.columns.push(this.createColumn(lastColumn.type, "", lastColumn));
            }
            else {
                this.columns.push(new StiNumberBoxColumnItem("", this.form));
            }
        }
    }
    addRow() {
        this.rowLabels.push("");
        this.columns.forEach((column) => column.cells.push(column.createCell()));
    }
    setProperty(propName, value, oldValue) {
        super.setProperty(propName, value, oldValue);
        if (propName == "thousandSeparator") {
            this.columns.forEach((column) => {
                if ((column instanceof StiNumberBoxColumnItem || column instanceof StiLabelColumnItem) &&
                    (oldValue === null || column.thousandSeparator == oldValue)) {
                    column.thousandSeparator = value;
                }
            });
            this.totalsFields.forEach((field) => {
                if (oldValue === null || oldValue == field.thousandSeparator) {
                    field.thousandSeparator = value;
                }
            });
        }
        else if (propName == "decimalDigits") {
            this.columns.forEach((column) => {
                if ((column instanceof StiNumberBoxColumnItem || column instanceof StiLabelColumnItem) &&
                    (oldValue === null || column.decimalDigits == oldValue)) {
                    column.decimalDigits = value;
                }
            });
            this.totalsFields.forEach((field) => {
                if (oldValue === null || oldValue == field.decimalDigits) {
                    field.decimalDigits = value;
                }
            });
        }
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.font.family, this.arrayOfStylesToString(this.font.style), this.font.size);
        usedFonts.add(this.description.font.family, this.arrayOfStylesToString(this.description.font.style), this.description.font.size);
    }
    propertyChanged(propName) {
        this.fitTable();
    }
    get columns() {
        return this._columns;
    }
    get eValue() {
        return this.tableHeaderText;
    }
    set eValue(value) {
        this.tableHeaderText = value;
    }
    get eFont() {
        return this.font;
    }
    set eFont(value) {
        this.font = value;
    }
    get eColor() {
        return this.tableHeaderColor;
    }
    set eColor(value) {
        this.tableHeaderColor = value;
    }
    get eBackgroundColor() {
        return this.tableHeaderBackgroundColor;
    }
    set eBackgroundColor(value) {
        this.tableHeaderBackgroundColor = value;
    }
    haveBackgoundColor() {
        return true;
    }
    get eContentAlignment() {
        return this.tableHeaderAlignment;
    }
    set eContentAlignment(value) {
        this.tableHeaderAlignment = value;
    }
    haveContentAlignment() {
        return true;
    }
    haveVerticalAlignment() {
        return false;
    }
    htmlStyle() {
        return `${this.eFont.htmlStyle()};color:${this.eColor.toHtmlColor()};`;
    }
    updateRowLabelsContentEditable() {
        this.rowLabelsContentEditable = [];
        this.rowLabels.forEach((l, index) => this.rowLabelsContentEditable.push(new StiRowLabel(l, this, index)));
    }
    set width(value) {
        let needToFit = this.geometry.width != value;
        this.geometry.width = value;
        if (needToFit) {
            this.fitTable();
        }
    }
    get width() {
        return this.geometry.width;
    }
    nameChanged(oldName) {
        this.columns.filter(c => c instanceof StiLabelColumnItem).forEach((column) => {
            column.expression = column.expression ? column.expression.replace(new RegExp(oldName, "g"), this.name) : column.expression;
        });
        this.totalsFields.forEach((total) => {
            total.expression = total.expression ? total.expression.replace(new RegExp(oldName, "g"), this.name) : total.expression;
        });
    }
    saveToJsonObject(options) {
        this.tableHeaderHeight = this.element?.nativeElement?.offsetHeight ?? this.tableHeaderHeight;
        this.columns?.forEach((column) => {
            if (column["cells"] && column["cells"].length != this.rowLabels.length) {
                column["cells"].splice(this.rowLabels.length, column["cells"].length);
            }
        });
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyJObject("Font", this.font.saveToJsonObject(options));
        jObject.addPropertyJObject("Border", this.border.saveToJsonObject(options));
        jObject.addPropertyJObject("GridLines", this.gridLines.saveToJsonObject(options));
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyBool("AlternateRowColors", this.alternateRowColors);
        jObject.addPropertyColor("EvenRowsStyle", this.evenRowsStyle);
        jObject.addPropertyColor("EvenRowsTextColor", this.evenRowsTextColor);
        jObject.addPropertyColor("OddRowsStyle", this.oddRowsStyle);
        jObject.addPropertyColor("OddRowsTextColor", this.oddRowsTextColor);
        jObject.addPropertyNumber("TableHeaderHeight", this.tableHeaderHeight);
        jObject.addPropertyString("TableHeaderText", this.tableHeaderText);
        jObject.addPropertyEnum("TableHeaderAlignment", StiHorizontalAlignment, this.tableHeaderAlignment);
        jObject.addPropertyColor("TableHeaderColor", this.tableHeaderColor);
        jObject.addPropertyColor("TableHeaderBackgroundColor", this.tableHeaderBackgroundColor);
        jObject.addPropertyBool("ShowRowLabels", this.showRowLabels);
        jObject.addPropertyArray("RowLabels", this.rowLabels);
        jObject.addPropertyEnum("RowLabelsHorizontalAlignment", StiHorizontalAlignment, this.rowLabelsHorizontalAlignment);
        jObject.addPropertyColor("RowHeadersBackground", this.rowHeadersBackground);
        jObject.addPropertyColor("RowHeadersColor", this.rowHeadersColor);
        jObject.addPropertyJObject("RowHeadersBorder", this.rowHeadersBorder.saveToJsonObject(options));
        jObject.addPropertyJObject("ColumnHeadersBorder", this.columnHeadersBorder.saveToJsonObject(options));
        jObject.addPropertyArray("Columns", this.columns);
        jObject.addPropertyBool("UseTotals", this.useTotals);
        // jObject.addPropertyBool("DynamicRows", this.dynamicRows);
        jObject.addPropertyBool("UseWordWrap", this.useWordWrap);
        jObject.addPropertyString("TotalsRowHeader", this.totalsRowHeader);
        jObject.addPropertyNumber("RowLabelsWidth", this.rowLabelsWidth);
        jObject.addPropertyEnum("TotalsRowHeaderHorizontalAlignment", StiHorizontalAlignment, this.totalsRowHeaderHorizontalAlignment);
        jObject.addPropertyEnum("TotalsRowHeaderVerticalAlignment", StiVerticalAlignment, this.totalsRowHeaderVerticalAlignment);
        jObject.addPropertyColor("TotalsRowHeaderColor", this.totalsRowHeaderColor);
        jObject.addPropertyNumber("TotalsValuesWidth", this.totalsValuesWidth);
        jObject.addPropertyNumber("TotalsHeadersWidth", this.totalsHeadersWidth);
        jObject.addPropertyArray("TotalsFields", this.totalsFields);
        return jObject;
    }
    loadFromJsonObject(json) {
        this.stopFit = true;
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "Font":
                    this.font = new Font();
                    this.font.loadFromJsonObject(property.value);
                    break;
                case "Border":
                    this.border = new StiBorder();
                    this.border.loadFromJsonObject(property.value);
                    break;
                case "GridLines":
                    this.gridLines = new StiInnerBorder();
                    this.gridLines.loadFromJsonObject(property.value);
                    break;
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
                case "AlternateRowColors":
                    this.alternateRowColors = property.value;
                    break;
                case "EvenRowsStyle":
                    this.evenRowsStyle = new Color();
                    this.evenRowsStyle.deserializeFromString(property.value);
                    break;
                case "EvenRowsTextColor":
                    this.evenRowsTextColor = new Color();
                    this.evenRowsTextColor.deserializeFromString(property.value);
                    break;
                case "OddRowsStyle":
                    this.oddRowsStyle = new Color();
                    this.oddRowsStyle.deserializeFromString(property.value);
                    break;
                case "OddRowsTextColor":
                    this.oddRowsTextColor = new Color();
                    this.oddRowsTextColor.deserializeFromString(property.value);
                    break;
                case "TableHeaderText":
                    this.tableHeaderText = property.value;
                    break;
                case "TableHeaderAlignment":
                    this.tableHeaderAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "TableHeaderColor":
                    this.tableHeaderColor = new Color();
                    this.tableHeaderColor.deserializeFromString(property.value);
                    break;
                case "TableHeaderBackgroundColor":
                    this.tableHeaderBackgroundColor = new Color();
                    this.tableHeaderBackgroundColor.deserializeFromString(property.value);
                    break;
                case "ShowRowLabels":
                    this.showRowLabels = property.value;
                    break;
                /* case "DynamicRows":
                  this.dynamicRows = property.value;
                  break; */
                case "RowLabels":
                    this.rowLabels = [];
                    property.value.properties().forEach((p) => this.rowLabels.push(p.value));
                    break;
                case "RowLabelsHorizontalAlignment":
                    this.rowLabelsHorizontalAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "RowLabelsWidth":
                    this.rowLabelsWidth = property.value;
                    break;
                case "RowHeadersBackground":
                    this.rowHeadersBackground = new Color();
                    this.rowHeadersBackground.deserializeFromString(property.value);
                    break;
                case "RowHeadersColor":
                    this.rowHeadersColor = new Color();
                    this.rowHeadersColor.deserializeFromString(property.value);
                    break;
                case "RowHeadersBorder":
                    this.rowHeadersBorder = new StiBorder();
                    this.rowHeadersBorder.loadFromJsonObject(property.value);
                    break;
                case "ColumnHeadersBorder":
                    this.columnHeadersBorder = new StiBorder();
                    this.columnHeadersBorder.loadFromJsonObject(property.value);
                    break;
                case "Columns":
                case "ColumnCollection":
                    this.columns = [];
                    for (let colJson of property.value.value) {
                        let type = colJson.properties().find((p) => p.name == "Type").value;
                        let column = this.createColumn(type);
                        column.eParent = this;
                        column.loadFromJsonObject(colJson);
                        this.columns.push(column);
                    }
                    break;
                case "UseTotals":
                    this.useTotals = property.value;
                    break;
                case "UseWordWrap":
                    this.useWordWrap = property.value;
                    break;
                case "TotalsRowHeader":
                    this.totalsRowHeader = property.value;
                    break;
                case "TotalsRowHeaderHorizontalAlignment":
                    this.totalsRowHeaderHorizontalAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "TotalsRowHeaderVerticalAlignment":
                    this.totalsRowHeaderVerticalAlignment = Enum.parse(StiVerticalAlignment, property.value);
                    break;
                case "TotalsRowHeaderColor":
                    this.totalsRowHeaderColor = new Color();
                    this.totalsRowHeaderColor.deserializeFromString(property.value);
                    break;
                case "TotalsValuesWidth":
                    this.totalsValuesWidth = property.value;
                    break;
                case "TotalsHeadersWidth":
                    this.totalsHeadersWidth = property.value;
                    break;
                case "TotalsFields":
                    this.totalsFields = [];
                    for (let totalJson of property.value.value) {
                        let total = new StiTotalsFieldItem("", "", this.form);
                        total.loadFromJsonObject(totalJson);
                        this.totalsFields.push(total);
                    }
                    break;
            }
        }
        this.stopFit = false;
        this.fitTable();
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU3RpVGFibGVFbGVtZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3RpbXVsc29mdC1mb3Jtcy9zcmMvbGliL2VsZW1lbnRzL1N0aVRhYmxlRWxlbWVudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLGNBQWMsTUFBTSw4QkFBOEIsQ0FBQztBQUMxRCxPQUFPLEVBQUUsU0FBUyxFQUFFLE1BQU0seUJBQXlCLENBQUM7QUFDcEQsT0FBTyxFQUFFLE1BQU0sRUFBRSxNQUFNLHNCQUFzQixDQUFDO0FBQzlDLE9BQU8sb0JBQW9CLE1BQU0sb0NBQW9DLENBQUM7QUFFdEUsT0FBTyxFQUFFLHNCQUFzQixFQUFFLE1BQU0sc0NBQXNDLENBQUM7QUFDOUUsT0FBTyxLQUFLLE1BQU0saUJBQWlCLENBQUM7QUFDcEMsT0FBTyxFQUFFLElBQUksRUFBRSxNQUFNLGdCQUFnQixDQUFDO0FBQ3RDLE9BQU8sRUFBRSxzQkFBc0IsRUFBRSxvQkFBb0IsRUFBRSxpQkFBaUIsRUFBRSxNQUFNLGlCQUFpQixDQUFDO0FBQ2xHLE9BQU8sRUFBRSxJQUFJLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQztBQUd0QyxPQUFPLEVBQUUsY0FBYyxFQUFFLE1BQU0sdUJBQXVCLENBQUM7QUFNdkQsT0FBTyxFQUFFLHFCQUFxQixFQUFFLE1BQU0sdUNBQXVDLENBQUM7QUFDOUUsT0FBTyxFQUFFLHFCQUFxQixFQUFFLE1BQU0sdUNBQXVDLENBQUM7QUFDOUUsT0FBTyxFQUFFLGtCQUFrQixFQUFFLE1BQU0sb0NBQW9DLENBQUM7QUFDeEUsT0FBTyxFQUFFLHNCQUFzQixFQUFFLE1BQU0sd0NBQXdDLENBQUM7QUFDaEYsT0FBTyxFQUFFLHdCQUF3QixFQUFFLE1BQU0sMENBQTBDLENBQUM7QUFDcEYsT0FBTyxFQUFFLG9CQUFvQixFQUFFLE1BQU0sc0NBQXNDLENBQUM7QUFDNUUsT0FBTyxFQUFFLGFBQWEsRUFBRSxNQUFNLHVCQUF1QixDQUFDO0FBQ3RELE9BQU8sRUFBRSxXQUFXLEVBQUUsTUFBTSxxQkFBcUIsQ0FBQztBQUNsRCxPQUFPLEVBQUUsa0JBQWtCLEVBQUUsTUFBTSw0QkFBNEIsQ0FBQztBQUNoRSxPQUFPLEVBQUUsaUNBQWlDLEVBQUUsTUFBTSwyQ0FBMkMsQ0FBQztBQUM5RixPQUFPLEVBQUUsWUFBWSxFQUFFLE1BQU0scUJBQXFCLENBQUM7QUFDbkQsT0FBTyxFQUFFLFdBQVcsRUFBRSxNQUFNLG9CQUFvQixDQUFDO0FBQ2pELE9BQU8sRUFBRSxnQkFBZ0IsRUFBRSxNQUFNLDRCQUE0QixDQUFDO0FBSTlELE1BQU0sT0FBTyxlQUFnQixTQUFRLGNBQWM7SUFzRGpELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUM7SUFDN0IsQ0FBQztJQUNELElBQVcsYUFBYSxDQUFDLEtBQWM7UUFDckMsSUFBSSxhQUFhLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQztRQUN4QyxJQUFJLGFBQWEsSUFBSSxLQUFLLEVBQUUsQ0FBQztZQUMzQixJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQztZQUM1QixJQUFJLENBQUMsUUFBUSxFQUFFLENBQUM7UUFDbEIsQ0FBQztJQUNILENBQUM7SUFFRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztJQUNoQyxDQUFDO0lBQ0QsSUFBVyxnQkFBZ0IsQ0FBQyxLQUFjO1FBQ3hDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUM7UUFDL0IsSUFBSSxLQUFLLElBQUksSUFBSSxFQUFFLENBQUM7WUFDbEIsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQztZQUNoQyxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQztZQUM3QixJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDO1FBQ2pDLENBQUM7SUFDSCxDQUFDO0lBRUQsSUFBVyxJQUFJLENBQUMsS0FBYTtRQUMzQixJQUFJLE9BQU8sR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDO1FBQ3hCLEtBQUssQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDO1FBQ25CLElBQUksQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDNUIsQ0FBQztJQUVELElBQVcsSUFBSTtRQUNiLE9BQU8sS0FBSyxDQUFDLElBQUksQ0FBQztJQUNwQixDQUFDO0lBRUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUVELElBQVcsaUJBQWlCLENBQUMsS0FBYTtRQUN4QyxJQUFJLEtBQUssR0FBRyxDQUFDLEVBQUUsQ0FBQztZQUNkLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7UUFDbEMsQ0FBQzthQUFNLENBQUM7WUFDTixJQUFJLENBQUMsa0JBQWtCLEdBQUcsQ0FBQyxDQUFDO1FBQzlCLENBQUM7SUFDSCxDQUFDO0lBQ0QsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUM7SUFDbEMsQ0FBQztJQUVELElBQVcsa0JBQWtCLENBQUMsS0FBYTtRQUN6QyxJQUFJLEtBQUssR0FBRyxDQUFDLEVBQUUsQ0FBQztZQUNkLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUM7UUFDbkMsQ0FBQzthQUFNLENBQUM7WUFDTixJQUFJLENBQUMsbUJBQW1CLEdBQUcsQ0FBQyxDQUFDO1FBQy9CLENBQUM7SUFDSCxDQUFDO0lBRUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUNELElBQVcsaUJBQWlCLENBQUMsS0FBYztRQUN6QyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDO1FBQ2hDLElBQUksS0FBSyxJQUFJLElBQUksRUFBRSxDQUFDO1lBQ2xCLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUM7WUFDL0IsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7WUFDN0IsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQztRQUNqQyxDQUFDO0lBQ0gsQ0FBQztJQUNELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDOUIsQ0FBQztJQUNELElBQVcsY0FBYyxDQUFDLEtBQWM7UUFDdEMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7UUFDN0IsSUFBSSxLQUFLLElBQUksSUFBSSxFQUFFLENBQUM7WUFDbEIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQztZQUMvQixJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDO1lBQ2hDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUM7UUFDakMsQ0FBQztJQUNILENBQUM7SUFDRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztJQUNoQyxDQUFDO0lBQ0QsSUFBVyxnQkFBZ0IsQ0FBQyxLQUFjO1FBQ3hDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUM7UUFDL0IsSUFBSSxLQUFLLElBQUksSUFBSSxFQUFFLENBQUM7WUFDbEIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQztZQUMvQixJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDO1lBQ2hDLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO1FBQy9CLENBQUM7SUFDSCxDQUFDO0lBQ00seUJBQXlCO1FBQzlCLElBQUksUUFBUSxHQUFHLElBQUksZ0JBQWdCLENBQUMsRUFBRSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNuRCxRQUFRLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQztRQUN4QixPQUFPLFFBQVEsQ0FBQztJQUNsQixDQUFDO0lBRUQsWUFBWSxJQUFhO1FBQ3ZCLEtBQUssRUFBRSxDQUFDO1FBckpILFNBQUksR0FBVyxjQUFjLENBQUM7UUFDOUIsZ0JBQVcsR0FBZ0IsSUFBSSxXQUFXLEVBQUUsQ0FBQztRQUM3QyxTQUFJLEdBQVMsSUFBSSxJQUFJLENBQUMsVUFBVSxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ3RDLFdBQU0sR0FBYyxJQUFJLFNBQVMsQ0FBQyxNQUFNLENBQUMsWUFBWSxFQUFFLEVBQUUsSUFBSSxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDakYsY0FBUyxHQUFtQixJQUFJLGNBQWMsQ0FBQyxNQUFNLENBQUMsWUFBWSxFQUFFLEVBQUUsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ2xGLG9CQUFlLEdBQVUsS0FBSyxDQUFDLFdBQVcsRUFBRSxDQUFDO1FBQzdDLHVCQUFrQixHQUFHLEtBQUssQ0FBQztRQUMzQixrQkFBYSxHQUFVLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDOUQsc0JBQWlCLEdBQVUsS0FBSyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQ3pDLGlCQUFZLEdBQVUsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLEVBQUUsSUFBSSxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsQ0FBQztRQUM3RCxxQkFBZ0IsR0FBVSxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDeEMsb0JBQWUsR0FBVyxFQUFFLENBQUM7UUFDN0IseUJBQW9CLEdBQTJCLHNCQUFzQixDQUFDLElBQUksQ0FBQztRQUMzRSxxQkFBZ0IsR0FBVSxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDeEMsc0JBQWlCLEdBQVcsQ0FBQyxDQUFDO1FBQzlCLCtCQUEwQixHQUFVLEtBQUssQ0FBQyxXQUFXLEVBQUUsQ0FBQztRQUN4RCxtQkFBYyxHQUFXLEdBQUcsQ0FBQztRQUM1QixtQkFBYyxHQUFZLEtBQUssQ0FBQztRQUNqQyxnQkFBVyxHQUFHLEtBQUssQ0FBQztRQUNwQixnQkFBVyxHQUFHLEtBQUssQ0FBQztRQUdwQiw2QkFBd0IsR0FBa0IsRUFBRSxDQUFDO1FBQzdDLGlDQUE0QixHQUEyQixzQkFBc0IsQ0FBQyxJQUFJLENBQUM7UUFDbkYseUJBQW9CLEdBQVUsS0FBSyxDQUFDLFdBQVcsRUFBRSxDQUFDO1FBQ2xELG9CQUFlLEdBQVUsS0FBSyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQ3ZDLHFCQUFnQixHQUFjLElBQUksU0FBUyxDQUFDLE1BQU0sQ0FBQyxZQUFZLEVBQUUsRUFBRSxJQUFJLEVBQUUsSUFBSSxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsQ0FBQztRQUMzRix3QkFBbUIsR0FBYyxJQUFJLFNBQVMsQ0FBQyxNQUFNLENBQUMsWUFBWSxFQUFFLEVBQUUsSUFBSSxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDN0YsYUFBUSxHQUFvQixFQUFFLENBQUM7UUFDaEMsY0FBUyxHQUFZLElBQUksQ0FBQztRQUMxQixvQkFBZSxHQUFHLHNCQUFzQixDQUFDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsUUFBUSxDQUFDLENBQUM7UUFDdkUsdUNBQWtDLEdBQTJCLHNCQUFzQixDQUFDLElBQUksQ0FBQztRQUN6RixxQ0FBZ0MsR0FBeUIsb0JBQW9CLENBQUMsR0FBRyxDQUFDO1FBQ2xGLHlCQUFvQixHQUFVLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUMzQyx1QkFBa0IsR0FBVyxHQUFHLENBQUM7UUFDakMsd0JBQW1CLEdBQVcsR0FBRyxDQUFDO1FBQ25DLGlCQUFZLEdBQXlCLEVBQUUsQ0FBQztRQUN4QyxxQkFBZ0IsR0FBWSxLQUFLLENBQUM7UUFDbEMsd0JBQW1CLEdBQVksS0FBSyxDQUFDO1FBRXBDLHNCQUFpQixHQUFZLElBQUksQ0FBQztRQUNsQyx1QkFBa0IsR0FBWSxLQUFLLENBQUM7UUFDcEMsb0JBQWUsR0FBWSxLQUFLLENBQUM7UUFDakMsc0JBQWlCLEdBQVksS0FBSyxDQUFDO1FBQ25DLFlBQU8sR0FBRyxLQUFLLENBQUM7UUFFakIsNEJBQXVCLEdBQVksSUFBSSxDQUFDO1FBQ3hDLHlCQUFvQixHQUFZLEtBQUssQ0FBQztRQUN0QyxtQkFBYyxHQUFXLEVBQUUsQ0FBQztRQUM1QixtQ0FBOEIsR0FBRyxJQUFJLGlDQUFpQyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBcUdsRixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztRQUNqQixJQUFJLENBQUMsUUFBUSxHQUFHLElBQUksb0JBQW9CLENBQUMsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBQ25ELElBQUksQ0FBQyxLQUFLLEdBQUcsSUFBSSxZQUFZLENBQUMsSUFBSSxFQUFFLHNCQUFzQixDQUFDLEdBQUcsQ0FBQyxZQUFZLEVBQUUsVUFBVSxDQUFDLENBQUMsQ0FBQztRQUMxRixJQUFJLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQztRQUNsQixJQUFJLENBQUMsU0FBUyxHQUFHLENBQUMsRUFBRSxFQUFFLEVBQUUsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM5QixJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7UUFFaEQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O2FBK0NLO0lBQ1AsQ0FBQztJQUVNLFlBQVksQ0FBQyxJQUFZLEVBQUUsS0FBYyxFQUFFLFVBQTBCO1FBQzFFLElBQUksR0FBRyxJQUFJLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztRQUNoQyxLQUFLLEdBQUcsS0FBSyxJQUFJLEVBQUUsQ0FBQztRQUNwQixJQUFJLFVBQXlCLENBQUM7UUFDOUIsSUFBSSxJQUFJLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFLENBQUM7WUFDaEMsVUFBVSxHQUFHLElBQUkscUJBQXFCLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUMzRCxDQUFDO2FBQU0sSUFBSSxJQUFJLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFLENBQUM7WUFDdkMsVUFBVSxHQUFHLElBQUkscUJBQXFCLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUMzRCxDQUFDO2FBQU0sSUFBSSxJQUFJLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxFQUFFLENBQUM7WUFDeEMsVUFBVSxHQUFHLElBQUksc0JBQXNCLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUM1RCxDQUFDO2FBQU0sSUFBSSxJQUFJLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxFQUFFLENBQUM7WUFDMUMsVUFBVSxHQUFHLElBQUksd0JBQXdCLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUM5RCxDQUFDO2FBQU0sSUFBSSxJQUFJLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxFQUFFLENBQUM7WUFDdEMsVUFBVSxHQUFHLElBQUksb0JBQW9CLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUMxRCxDQUFDO2FBQU0sSUFBSSxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7WUFDcEMsVUFBVSxHQUFHLElBQUksa0JBQWtCLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUN4RCxDQUFDO1FBRUQsSUFBSSxVQUFVLEVBQUUsQ0FBQztZQUNmLFVBQVUsQ0FBQyxRQUFRLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDbEMsQ0FBQztRQUVELE9BQU8sVUFBVSxDQUFDO0lBQ3BCLENBQUM7SUFFRCxXQUFXLENBQUMsS0FBYTtRQUN2QixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztRQUN0QixPQUFPLEtBQUssR0FBRyxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsTUFBTSxHQUFHLElBQUksQ0FBQyxVQUFVLEVBQUUsTUFBTSxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ3ZFLENBQUM7SUFDRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxDQUNMLElBQUksQ0FBQyxLQUFLO1lBQ1YsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJO1lBQ2pCLElBQUksQ0FBQyxPQUFPLENBQUMsS0FBSztZQUNsQixDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxJQUFJLGlCQUFpQixDQUFDLEdBQUcsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQ3RHLENBQUM7SUFDSixDQUFDO0lBQ0QsSUFBSSxTQUFTLENBQUMsS0FBZTtRQUMzQixJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQztRQUM3QixJQUFJLEtBQUssR0FBRyxJQUFJLENBQUM7UUFDakIsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLEtBQUssQ0FBQyxLQUFLLEVBQUU7WUFDakMsY0FBYyxFQUFFLFVBQVUsTUFBTSxFQUFFLFFBQVE7Z0JBQ3hDLFVBQVUsQ0FBQyxHQUFHLEVBQUU7b0JBQ2QsS0FBSyxDQUFDLDhCQUE4QixFQUFFLENBQUM7Z0JBQ3pDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztnQkFDTixPQUFPLElBQUksQ0FBQztZQUNkLENBQUM7WUFDRCxHQUFHLEVBQUUsVUFBVSxNQUFNLEVBQUUsUUFBUSxFQUFFLEtBQUssRUFBRSxRQUFRO2dCQUM5QyxNQUFNLENBQUMsUUFBUSxDQUFDLEdBQUcsS0FBSyxDQUFDO2dCQUN6QixLQUFLLENBQUMsOEJBQThCLEVBQUUsQ0FBQztnQkFDdkMsT0FBTyxJQUFJLENBQUM7WUFDZCxDQUFDO1NBQ0YsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLDhCQUE4QixFQUFFLENBQUM7SUFDeEMsQ0FBQztJQUVELElBQUksU0FBUztRQUNYLE9BQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQztJQUN6QixDQUFDO0lBQ0QsZ0JBQWdCO1FBQ2QsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQyxNQUFNLEVBQUUsRUFBRTtZQUM5QixNQUFNLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztRQUM1QixDQUFDLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxZQUFZLENBQUMsT0FBTyxDQUFDLENBQUMsS0FBSyxFQUFFLEVBQUU7WUFDbEMsS0FBSyxDQUFDLGdCQUFnQixFQUFFLENBQUM7UUFDM0IsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBQ0QsSUFBSSxPQUFPLENBQUMsS0FBc0I7UUFDaEMsSUFBSSxLQUFLLEdBQUcsSUFBSSxDQUFDO1FBQ2pCLElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxLQUFLLENBQUMsS0FBSyxFQUFFO1lBQy9CLGNBQWMsRUFBRSxVQUFVLE1BQU0sRUFBRSxRQUFRO2dCQUN4QyxVQUFVLENBQUMsR0FBRyxFQUFFO29CQUNkLEtBQUssQ0FBQyxRQUFRLEVBQUUsQ0FBQztnQkFDbkIsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO2dCQUNOLE9BQU8sSUFBSSxDQUFDO1lBQ2QsQ0FBQztZQUNELEdBQUcsRUFBRSxVQUFVLE1BQVcsRUFBRSxRQUFRLEVBQUUsS0FBSyxFQUFFLFFBQVE7Z0JBQ25ELE1BQU0sQ0FBQyxRQUFRLENBQUMsR0FBRyxLQUFLLENBQUM7Z0JBQ3pCLElBQUksTUFBTSxHQUFHLEtBQXNCLENBQUM7Z0JBQ3BDLElBQUksTUFBTSxZQUFZLGFBQWEsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsQ0FBQztvQkFDckQsTUFBTSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsYUFBYSxHQUFHLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxNQUFNLEdBQUcsQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7Z0JBQzlGLENBQUM7Z0JBRUQsSUFBSSxLQUFLLENBQUMsS0FBSyxJQUFJLEtBQUssQ0FBQyxLQUFLLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUMsTUFBTSxFQUFFLENBQUM7b0JBQy9ELEtBQUssSUFBSSxDQUFDLEdBQUcsS0FBSyxDQUFDLEtBQUssQ0FBQyxNQUFNLEVBQUUsQ0FBQyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUMsTUFBTSxFQUFFLENBQUMsRUFBRTt3QkFDOUQsS0FBSyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFVBQVUsRUFBRSxDQUFDLENBQUM7Z0JBQzFDLENBQUM7Z0JBRUQsSUFBSSxDQUFDLE1BQU0sQ0FBQyxPQUFPLEVBQUUsQ0FBQztvQkFDcEIsS0FBSyxDQUFDLFFBQVEsRUFBRSxDQUFDO2dCQUNuQixDQUFDO2dCQUNELE9BQU8sSUFBSSxDQUFDO1lBQ2QsQ0FBQztTQUNGLENBQUMsQ0FBQztRQUNILEtBQUssQ0FBQyxRQUFRLEVBQUUsQ0FBQztJQUNuQixDQUFDO0lBRU0sUUFBUTtRQUNiLElBQUksSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDO1lBQ2pCLE9BQU87UUFDVCxDQUFDO1FBQ0QsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ2hFLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLFlBQVksSUFBSSxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztRQUN2RCxJQUFJLEVBQUUsR0FBRyxJQUFJLENBQUMsYUFBYSxHQUFHLFlBQVksQ0FBQztRQUMzQyxJQUFJLFlBQVksSUFBSSxDQUFDLElBQUksWUFBWSxJQUFJLEVBQUUsRUFBRSxDQUFDO1lBQzVDLElBQUksSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDO2dCQUN2QixJQUFJLENBQUMsY0FBYyxJQUFJLEVBQUUsQ0FBQztZQUM1QixDQUFDO1lBQ0QsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssSUFBSSxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBQy9DLENBQUM7UUFFRCxFQUFFLEdBQUcsSUFBSSxDQUFDLGFBQWEsR0FBRyxDQUFDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUMsaUJBQWlCLENBQUMsQ0FBQztRQUM3RSxJQUFJLEVBQUUsR0FBRyxDQUFDLEVBQUUsQ0FBQztZQUNYLElBQUksQ0FBQyxrQkFBa0IsSUFBSSxFQUFFLENBQUM7WUFDOUIsSUFBSSxDQUFDLGlCQUFpQixJQUFJLEVBQUUsQ0FBQztRQUMvQixDQUFDO0lBQ0gsQ0FBQztJQUNNLGFBQWE7UUFDbEIsSUFBSSxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO0lBQ3RELENBQUM7SUFDTSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO0lBQ2xELENBQUM7SUFDTSxpQkFBaUI7UUFDdEIsSUFBSSxjQUFjLEdBQUcsQ0FBQyxJQUFJLENBQUMsYUFBYSxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDO1FBQzVGLElBQUksa0JBQWtCLEdBQUcsQ0FBQyxDQUFDO1FBQzNCLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUM7WUFDNUIsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQyxNQUFNLEVBQUUsRUFBRTtnQkFDOUIsSUFBSSxNQUFNLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxjQUFjLEVBQUUsQ0FBQztvQkFDdkMsa0JBQWtCLElBQUksTUFBTSxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsY0FBYyxDQUFDO2dCQUMzRCxDQUFDO1lBQ0gsQ0FBQyxDQUFDLENBQUM7UUFDTCxDQUFDO2FBQU0sQ0FBQztZQUNOLGtCQUFrQixHQUFHLElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQztRQUNoRSxDQUFDO1FBQ0QsSUFBSSxjQUFjLElBQUksa0JBQWtCLEVBQUUsQ0FBQztZQUN6QyxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRSxDQUFDO2dCQUM1QixJQUFJLFVBQVUsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFBO2dCQUN0RCxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLFVBQVUsQ0FBQyxJQUFJLEVBQUUsRUFBRSxFQUFFLFVBQVUsQ0FBQyxDQUFDLENBQUM7WUFDeEUsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLElBQUksc0JBQXNCLENBQUMsRUFBRSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO1lBQy9ELENBQUM7UUFDSCxDQUFDO0lBQ0gsQ0FBQztJQUVNLE1BQU07UUFDWCxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsQ0FBQztRQUN4QixJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE1BQU0sRUFBRSxFQUFFLENBQUUsTUFBYyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFVBQVUsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUNwRixDQUFDO0lBRUQsV0FBVyxDQUFDLFFBQWdCLEVBQUUsS0FBVSxFQUFFLFFBQWE7UUFDckQsS0FBSyxDQUFDLFdBQVcsQ0FBQyxRQUFRLEVBQUUsS0FBSyxFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBQzdDLElBQUksUUFBUSxJQUFJLG1CQUFtQixFQUFFLENBQUM7WUFDcEMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQyxNQUFNLEVBQUUsRUFBRTtnQkFDOUIsSUFDRSxDQUFDLE1BQU0sWUFBWSxzQkFBc0IsSUFBSSxNQUFNLFlBQVksa0JBQWtCLENBQUM7b0JBQ2xGLENBQUMsUUFBUSxLQUFLLElBQUksSUFBSSxNQUFNLENBQUMsaUJBQWlCLElBQUksUUFBUSxDQUFDLEVBQzNELENBQUM7b0JBQ0QsTUFBTSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQztnQkFDbkMsQ0FBQztZQUNILENBQUMsQ0FBQyxDQUFDO1lBQ0gsSUFBSSxDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUMsQ0FBQyxLQUFLLEVBQUUsRUFBRTtnQkFDbEMsSUFBSSxRQUFRLEtBQUssSUFBSSxJQUFJLFFBQVEsSUFBSSxLQUFLLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztvQkFDN0QsS0FBSyxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQztnQkFDbEMsQ0FBQztZQUNILENBQUMsQ0FBQyxDQUFDO1FBQ0wsQ0FBQzthQUFNLElBQUksUUFBUSxJQUFJLGVBQWUsRUFBRSxDQUFDO1lBQ3ZDLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLENBQUMsTUFBTSxFQUFFLEVBQUU7Z0JBQzlCLElBQ0UsQ0FBQyxNQUFNLFlBQVksc0JBQXNCLElBQUksTUFBTSxZQUFZLGtCQUFrQixDQUFDO29CQUNsRixDQUFDLFFBQVEsS0FBSyxJQUFJLElBQUksTUFBTSxDQUFDLGFBQWEsSUFBSSxRQUFRLENBQUMsRUFDdkQsQ0FBQztvQkFDRCxNQUFNLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztnQkFDL0IsQ0FBQztZQUNILENBQUMsQ0FBQyxDQUFDO1lBQ0gsSUFBSSxDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUMsQ0FBQyxLQUFLLEVBQUUsRUFBRTtnQkFDbEMsSUFBSSxRQUFRLEtBQUssSUFBSSxJQUFJLFFBQVEsSUFBSSxLQUFLLENBQUMsYUFBYSxFQUFFLENBQUM7b0JBQ3pELEtBQUssQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO2dCQUM5QixDQUFDO1lBQ0gsQ0FBQyxDQUFDLENBQUM7UUFDTCxDQUFDO0lBQ0gsQ0FBQztJQUNNLFlBQVksQ0FBQyxTQUEyQjtRQUM3QyxLQUFLLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQzlCLFNBQVMsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLHFCQUFxQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUM3RixTQUFTLENBQUMsR0FBRyxDQUNYLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFDNUIsSUFBSSxDQUFDLHFCQUFxQixDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxFQUN2RCxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQzNCLENBQUM7SUFDSixDQUFDO0lBQ0QsZUFBZSxDQUFDLFFBQWdCO1FBQzlCLElBQUksQ0FBQyxRQUFRLEVBQUUsQ0FBQztJQUNsQixDQUFDO0lBRUQsSUFBSSxPQUFPO1FBQ1QsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7SUFFRCxJQUFJLE1BQU07UUFDUixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDOUIsQ0FBQztJQUVELElBQUksTUFBTSxDQUFDLEtBQWE7UUFDdEIsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7SUFDL0IsQ0FBQztJQUVELElBQUksS0FBSztRQUNQLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQztJQUNuQixDQUFDO0lBRUQsSUFBSSxLQUFLLENBQUMsS0FBVztRQUNuQixJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBRUQsSUFBSSxNQUFNO1FBQ1IsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7SUFDL0IsQ0FBQztJQUVELElBQUksTUFBTSxDQUFDLEtBQVk7UUFDckIsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQztJQUNoQyxDQUFDO0lBRUQsSUFBSSxnQkFBZ0I7UUFDbEIsT0FBTyxJQUFJLENBQUMsMEJBQTBCLENBQUM7SUFDekMsQ0FBQztJQUVELElBQUksZ0JBQWdCLENBQUMsS0FBWTtRQUMvQixJQUFJLENBQUMsMEJBQTBCLEdBQUcsS0FBSyxDQUFDO0lBQzFDLENBQUM7SUFDRCxrQkFBa0I7UUFDaEIsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBQ0QsSUFBSSxpQkFBaUI7UUFDbkIsT0FBTyxJQUFJLENBQUMsb0JBQW9CLENBQUM7SUFDbkMsQ0FBQztJQUNELElBQUksaUJBQWlCLENBQUMsS0FBNkI7UUFDakQsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQztJQUNwQyxDQUFDO0lBQ0Qsb0JBQW9CO1FBQ2xCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUNELHFCQUFxQjtRQUNuQixPQUFPLEtBQUssQ0FBQztJQUNmLENBQUM7SUFFRCxTQUFTO1FBQ1AsT0FBTyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxFQUFFLFVBQVUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDO0lBQ3pFLENBQUM7SUFFRCw4QkFBOEI7UUFDNUIsSUFBSSxDQUFDLHdCQUF3QixHQUFHLEVBQUUsQ0FBQztRQUNuQyxJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSxLQUFLLEVBQUUsRUFBRSxDQUFDLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxJQUFJLENBQUMsSUFBSSxXQUFXLENBQUMsQ0FBQyxFQUFFLElBQUksRUFBRSxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDNUcsQ0FBQztJQUVELElBQVcsS0FBSyxDQUFDLEtBQWE7UUFDNUIsSUFBSSxTQUFTLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLElBQUksS0FBSyxDQUFDO1FBQzdDLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztRQUM1QixJQUFJLFNBQVMsRUFBRSxDQUFDO1lBQ2QsSUFBSSxDQUFDLFFBQVEsRUFBRSxDQUFDO1FBQ2xCLENBQUM7SUFDSCxDQUFDO0lBRUQsSUFBVyxLQUFLO1FBQ2QsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBRU8sV0FBVyxDQUFDLE9BQWU7UUFDakMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLFlBQVksa0JBQWtCLENBQUMsQ0FBQyxPQUFPLENBQUMsQ0FBQyxNQUEwQixFQUFFLEVBQUU7WUFDL0YsTUFBTSxDQUFDLFVBQVUsR0FBRyxNQUFNLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLEVBQUUsR0FBRyxDQUFDLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDO1FBQzdILENBQUMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUMsQ0FBQyxLQUF5QixFQUFFLEVBQUU7WUFDdEQsS0FBSyxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLEVBQUUsR0FBRyxDQUFDLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDO1FBQ3pILENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVELGdCQUFnQixDQUFDLE9BQVk7UUFDM0IsSUFBSSxDQUFDLGlCQUFpQixHQUFHLElBQUksQ0FBQyxPQUFPLEVBQUUsYUFBYSxFQUFFLFlBQVksSUFBSSxJQUFJLENBQUMsaUJBQWlCLENBQUM7UUFDN0YsSUFBSSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQyxNQUFNLEVBQUUsRUFBRTtZQUMvQixJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUMsTUFBTSxJQUFJLElBQUksQ0FBQyxTQUFTLENBQUMsTUFBTSxFQUFFLENBQUM7Z0JBQ3ZFLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxNQUFNLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1lBQ3hFLENBQUM7UUFDSCxDQUFDLENBQUMsQ0FBQztRQUNILElBQUksT0FBTyxHQUFHLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUM5QyxPQUFPLENBQUMsa0JBQWtCLENBQUMsT0FBTyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztRQUMxRSxPQUFPLENBQUMsa0JBQWtCLENBQUMsYUFBYSxFQUFFLElBQUksQ0FBQyxXQUFXLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztRQUN0RixPQUFPLENBQUMsa0JBQWtCLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztRQUN4RSxPQUFPLENBQUMsa0JBQWtCLENBQUMsUUFBUSxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztRQUM1RSxPQUFPLENBQUMsa0JBQWtCLENBQUMsV0FBVyxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztRQUNsRixPQUFPLENBQUMsZ0JBQWdCLENBQUMsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBQ2xFLE9BQU8sQ0FBQyxlQUFlLENBQUMsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDdkUsT0FBTyxDQUFDLGdCQUFnQixDQUFDLGVBQWUsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7UUFDOUQsT0FBTyxDQUFDLGdCQUFnQixDQUFDLG1CQUFtQixFQUFFLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBQ3RFLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxjQUFjLEVBQUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxDQUFDO1FBQzVELE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxrQkFBa0IsRUFBRSxJQUFJLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztRQUNwRSxPQUFPLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLENBQUM7UUFDdkUsT0FBTyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLElBQUksQ0FBQyxlQUFlLENBQUMsQ0FBQztRQUNuRSxPQUFPLENBQUMsZUFBZSxDQUFDLHNCQUFzQixFQUFFLHNCQUFzQixFQUFFLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO1FBQ25HLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxrQkFBa0IsRUFBRSxJQUFJLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztRQUNwRSxPQUFPLENBQUMsZ0JBQWdCLENBQUMsNEJBQTRCLEVBQUUsSUFBSSxDQUFDLDBCQUEwQixDQUFDLENBQUM7UUFDeEYsT0FBTyxDQUFDLGVBQWUsQ0FBQyxlQUFlLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBQzdELE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxXQUFXLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQ3RELE9BQU8sQ0FBQyxlQUFlLENBQUMsOEJBQThCLEVBQUUsc0JBQXNCLEVBQUUsSUFBSSxDQUFDLDRCQUE0QixDQUFDLENBQUM7UUFDbkgsT0FBTyxDQUFDLGdCQUFnQixDQUFDLHNCQUFzQixFQUFFLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO1FBQzVFLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxpQkFBaUIsRUFBRSxJQUFJLENBQUMsZUFBZSxDQUFDLENBQUM7UUFDbEUsT0FBTyxDQUFDLGtCQUFrQixDQUFDLGtCQUFrQixFQUFFLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO1FBQ2hHLE9BQU8sQ0FBQyxrQkFBa0IsQ0FBQyxxQkFBcUIsRUFBRSxJQUFJLENBQUMsbUJBQW1CLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztRQUN0RyxPQUFPLENBQUMsZ0JBQWdCLENBQUMsU0FBUyxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUNsRCxPQUFPLENBQUMsZUFBZSxDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUM7UUFDckQsNERBQTREO1FBQzVELE9BQU8sQ0FBQyxlQUFlLENBQUMsYUFBYSxFQUFFLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQztRQUN6RCxPQUFPLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBQ25FLE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsY0FBYyxDQUFDLENBQUM7UUFDakUsT0FBTyxDQUFDLGVBQWUsQ0FDckIsb0NBQW9DLEVBQ3BDLHNCQUFzQixFQUN0QixJQUFJLENBQUMsa0NBQWtDLENBQ3hDLENBQUM7UUFDRixPQUFPLENBQUMsZUFBZSxDQUNyQixrQ0FBa0MsRUFDbEMsb0JBQW9CLEVBQ3BCLElBQUksQ0FBQyxnQ0FBZ0MsQ0FDdEMsQ0FBQztRQUNGLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxzQkFBc0IsRUFBRSxJQUFJLENBQUMsb0JBQW9CLENBQUMsQ0FBQztRQUM1RSxPQUFPLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLENBQUM7UUFDdkUsT0FBTyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQ3pFLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxjQUFjLEVBQUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxDQUFDO1FBQzVELE9BQU8sT0FBTyxDQUFDO0lBQ2pCLENBQUM7SUFFTSxrQkFBa0IsQ0FBQyxJQUFhO1FBQ3JDLElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDO1FBQ3BCLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUMvQixLQUFLLElBQUksUUFBUSxJQUFJLElBQUksQ0FBQyxVQUFVLEVBQUUsRUFBRSxDQUFDO1lBQ3ZDLFFBQVEsUUFBUSxDQUFDLElBQUksRUFBRSxDQUFDO2dCQUN0QixLQUFLLE9BQU87b0JBQ1YsSUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLFlBQVksQ0FBQyxJQUFJLENBQUMsQ0FBQztvQkFDcEMsSUFBSSxDQUFDLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQzlDLE1BQU07Z0JBQ1IsS0FBSyxhQUFhO29CQUNoQixJQUFJLENBQUMsV0FBVyxHQUFHLElBQUksV0FBVyxFQUFFLENBQUM7b0JBQ3JDLElBQUksQ0FBQyxXQUFXLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUNwRCxNQUFNO2dCQUNSLEtBQUssTUFBTTtvQkFDVCxJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksSUFBSSxFQUFFLENBQUM7b0JBQ3ZCLElBQUksQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUM3QyxNQUFNO2dCQUNSLEtBQUssUUFBUTtvQkFDWCxJQUFJLENBQUMsTUFBTSxHQUFHLElBQUksU0FBUyxFQUFFLENBQUM7b0JBQzlCLElBQUksQ0FBQyxNQUFNLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUMvQyxNQUFNO2dCQUNSLEtBQUssV0FBVztvQkFDZCxJQUFJLENBQUMsU0FBUyxHQUFHLElBQUksY0FBYyxFQUFFLENBQUM7b0JBQ3RDLElBQUksQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUNsRCxNQUFNO2dCQUNSLEtBQUssaUJBQWlCO29CQUNwQixJQUFJLENBQUMsZUFBZSxHQUFHLElBQUksS0FBSyxFQUFFLENBQUM7b0JBQ25DLElBQUksQ0FBQyxlQUFlLENBQUMscUJBQXFCLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUMzRCxNQUFNO2dCQUNSLEtBQUssb0JBQW9CO29CQUN2QixJQUFJLENBQUMsa0JBQWtCLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDekMsTUFBTTtnQkFDUixLQUFLLGVBQWU7b0JBQ2xCLElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSxLQUFLLEVBQUUsQ0FBQztvQkFDakMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxxQkFBcUIsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQ3pELE1BQU07Z0JBQ1IsS0FBSyxtQkFBbUI7b0JBQ3RCLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLEtBQUssRUFBRSxDQUFDO29CQUNyQyxJQUFJLENBQUMsaUJBQWlCLENBQUMscUJBQXFCLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUM3RCxNQUFNO2dCQUNSLEtBQUssY0FBYztvQkFDakIsSUFBSSxDQUFDLFlBQVksR0FBRyxJQUFJLEtBQUssRUFBRSxDQUFDO29CQUNoQyxJQUFJLENBQUMsWUFBWSxDQUFDLHFCQUFxQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDeEQsTUFBTTtnQkFDUixLQUFLLGtCQUFrQjtvQkFDckIsSUFBSSxDQUFDLGdCQUFnQixHQUFHLElBQUksS0FBSyxFQUFFLENBQUM7b0JBQ3BDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxxQkFBcUIsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQzVELE1BQU07Z0JBQ1IsS0FBSyxpQkFBaUI7b0JBQ3BCLElBQUksQ0FBQyxlQUFlLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDdEMsTUFBTTtnQkFDUixLQUFLLHNCQUFzQjtvQkFDekIsSUFBSSxDQUFDLG9CQUFvQixHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsc0JBQXNCLEVBQUUsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUMvRSxNQUFNO2dCQUNSLEtBQUssa0JBQWtCO29CQUNyQixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsSUFBSSxLQUFLLEVBQUUsQ0FBQztvQkFDcEMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLHFCQUFxQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDNUQsTUFBTTtnQkFDUixLQUFLLDRCQUE0QjtvQkFDL0IsSUFBSSxDQUFDLDBCQUEwQixHQUFHLElBQUksS0FBSyxFQUFFLENBQUM7b0JBQzlDLElBQUksQ0FBQywwQkFBMEIsQ0FBQyxxQkFBcUIsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQ3RFLE1BQU07Z0JBQ1IsS0FBSyxlQUFlO29CQUNsQixJQUFJLENBQUMsYUFBYSxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQ3BDLE1BQU07Z0JBQ1I7OzJCQUVXO2dCQUNYLEtBQUssV0FBVztvQkFDZCxJQUFJLENBQUMsU0FBUyxHQUFHLEVBQUUsQ0FBQztvQkFDbkIsUUFBUSxDQUFDLEtBQWlCLENBQUMsVUFBVSxFQUFFLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztvQkFDdEYsTUFBTTtnQkFDUixLQUFLLDhCQUE4QjtvQkFDakMsSUFBSSxDQUFDLDRCQUE0QixHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsc0JBQXNCLEVBQUUsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUN2RixNQUFNO2dCQUNSLEtBQUssZ0JBQWdCO29CQUNuQixJQUFJLENBQUMsY0FBYyxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQ3JDLE1BQU07Z0JBQ1IsS0FBSyxzQkFBc0I7b0JBQ3pCLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxJQUFJLEtBQUssRUFBRSxDQUFDO29CQUN4QyxJQUFJLENBQUMsb0JBQW9CLENBQUMscUJBQXFCLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUNoRSxNQUFNO2dCQUNSLEtBQUssaUJBQWlCO29CQUNwQixJQUFJLENBQUMsZUFBZSxHQUFHLElBQUksS0FBSyxFQUFFLENBQUM7b0JBQ25DLElBQUksQ0FBQyxlQUFlLENBQUMscUJBQXFCLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUMzRCxNQUFNO2dCQUNSLEtBQUssa0JBQWtCO29CQUNyQixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsSUFBSSxTQUFTLEVBQUUsQ0FBQztvQkFDeEMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDekQsTUFBTTtnQkFDUixLQUFLLHFCQUFxQjtvQkFDeEIsSUFBSSxDQUFDLG1CQUFtQixHQUFHLElBQUksU0FBUyxFQUFFLENBQUM7b0JBQzNDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQzVELE1BQU07Z0JBQ1IsS0FBSyxTQUFTLENBQUM7Z0JBQ2YsS0FBSyxrQkFBa0I7b0JBQ3JCLElBQUksQ0FBQyxPQUFPLEdBQUcsRUFBRSxDQUFDO29CQUNsQixLQUFLLElBQUksT0FBTyxJQUFJLFFBQVEsQ0FBQyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7d0JBQ3pDLElBQUksSUFBSSxHQUFHLE9BQU8sQ0FBQyxVQUFVLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxJQUFJLElBQUksTUFBTSxDQUFDLENBQUMsS0FBSyxDQUFDO3dCQUNwRSxJQUFJLE1BQU0sR0FBa0IsSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsQ0FBQzt3QkFDcEQsTUFBTSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUM7d0JBQ3RCLE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQyxPQUFPLENBQUMsQ0FBQzt3QkFDbkMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7b0JBQzVCLENBQUM7b0JBQ0QsTUFBTTtnQkFDUixLQUFLLFdBQVc7b0JBQ2QsSUFBSSxDQUFDLFNBQVMsR0FBRyxRQUFRLENBQUMsS0FBSyxDQUFDO29CQUNoQyxNQUFNO2dCQUNSLEtBQUssYUFBYTtvQkFDaEIsSUFBSSxDQUFDLFdBQVcsR0FBRyxRQUFRLENBQUMsS0FBSyxDQUFDO29CQUNsQyxNQUFNO2dCQUNSLEtBQUssaUJBQWlCO29CQUNwQixJQUFJLENBQUMsZUFBZSxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQ3RDLE1BQU07Z0JBQ1IsS0FBSyxvQ0FBb0M7b0JBQ3ZDLElBQUksQ0FBQyxrQ0FBa0MsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLHNCQUFzQixFQUFFLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDN0YsTUFBTTtnQkFDUixLQUFLLGtDQUFrQztvQkFDckMsSUFBSSxDQUFDLGdDQUFnQyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsb0JBQW9CLEVBQUUsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUN6RixNQUFNO2dCQUNSLEtBQUssc0JBQXNCO29CQUN6QixJQUFJLENBQUMsb0JBQW9CLEdBQUcsSUFBSSxLQUFLLEVBQUUsQ0FBQztvQkFDeEMsSUFBSSxDQUFDLG9CQUFvQixDQUFDLHFCQUFxQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDaEUsTUFBTTtnQkFDUixLQUFLLG1CQUFtQjtvQkFDdEIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQ3hDLE1BQU07Z0JBQ1IsS0FBSyxvQkFBb0I7b0JBQ3ZCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxRQUFRLENBQUMsS0FBSyxDQUFDO29CQUN6QyxNQUFNO2dCQUNSLEtBQUssY0FBYztvQkFDakIsSUFBSSxDQUFDLFlBQVksR0FBRyxFQUFFLENBQUM7b0JBQ3ZCLEtBQUssSUFBSSxTQUFTLElBQUksUUFBUSxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQzt3QkFDM0MsSUFBSSxLQUFLLEdBQUcsSUFBSSxrQkFBa0IsQ0FBQyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQzt3QkFDdEQsS0FBSyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxDQUFDO3dCQUNwQyxJQUFJLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDaEMsQ0FBQztvQkFDRCxNQUFNO1lBQ1YsQ0FBQztRQUNILENBQUM7UUFDRCxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztRQUNyQixJQUFJLENBQUMsUUFBUSxFQUFFLENBQUM7SUFDbEIsQ0FBQztDQUNGIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFN0aUlubmVyQm9yZGVyIGZyb20gXCIuLi9wcm9wZXJ0aWVzL1N0aUlubmVyQm9yZGVyXCI7XHJcbmltcG9ydCB7IFN0aUJvcmRlciB9IGZyb20gXCIuLi9wcm9wZXJ0aWVzL1N0aUJvcmRlclwiO1xyXG5pbXBvcnQgeyBTdGlQZW4gfSBmcm9tIFwiLi4vcHJvcGVydGllcy9TdGlQZW5cIjtcclxuaW1wb3J0IFN0aVJlY3RhbmdsZUdlb21ldHJ5IGZyb20gXCIuLi9wcm9wZXJ0aWVzL1N0aVJlY3RhbmdsZUdlb21ldHJ5XCI7XHJcbmltcG9ydCB7IFN0aVVzZWRGb250c0xpc3QgfSBmcm9tIFwiLi4vc2VydmljZXMvb2JqZWN0c1wiO1xyXG5pbXBvcnQgeyBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlIH0gZnJvbSBcIi4uL3NlcnZpY2VzL3N0aS1sb2NhbGl6YXRpb24uc2VydmljZVwiO1xyXG5pbXBvcnQgQ29sb3IgZnJvbSBcIi4uL3N5c3RlbS9Db2xvclwiO1xyXG5pbXBvcnQgeyBFbnVtIH0gZnJvbSBcIi4uL3N5c3RlbS9FbnVtXCI7XHJcbmltcG9ydCB7IFN0aUhvcml6b250YWxBbGlnbm1lbnQsIFN0aVZlcnRpY2FsQWxpZ25tZW50LCBTdGlMYWJlbEFsaWdubWVudCB9IGZyb20gXCIuLi9zeXN0ZW0vZW51bXNcIjtcclxuaW1wb3J0IHsgRm9udCB9IGZyb20gXCIuLi9zeXN0ZW0vRm9udFwiO1xyXG5pbXBvcnQgeyBTdGlFZGl0YWJsZUNvbnRlbnQsIFN0aVRhYkluZGV4IH0gZnJvbSBcIi4uL3N5c3RlbS9pbnRlcmZhY2VzXCI7XHJcbmltcG9ydCBTdGlKc29uIGZyb20gXCIuLi9zeXN0ZW0vU3RpSnNvblwiO1xyXG5pbXBvcnQgeyBTdGlGb3JtRWxlbWVudCB9IGZyb20gXCIuL2Jhc2UvU3RpRm9ybUVsZW1lbnRcIjtcclxuaW1wb3J0IHsgU3RpQ2hlY2tCb3hDZWxsSXRlbSB9IGZyb20gXCIuL3RhYmxlL2NlbGxzL1N0aUNoZWNrQm94Q2VsbEl0ZW1cIjtcclxuaW1wb3J0IHsgU3RpQ29tYm9Cb3hDZWxsSXRlbSB9IGZyb20gXCIuL3RhYmxlL2NlbGxzL1N0aUNvbWJvQm94Q2VsbEl0ZW1cIjtcclxuaW1wb3J0IHsgU3RpTnVtYmVyQm94Q2VsbEl0ZW0gfSBmcm9tIFwiLi90YWJsZS9jZWxscy9TdGlOdW1iZXJCb3hDZWxsSXRlbVwiO1xyXG5pbXBvcnQgeyBTdGlSYWRpb0J1dHRvbkNlbGxJdGVtIH0gZnJvbSBcIi4vdGFibGUvY2VsbHMvU3RpUmFkaW9CdXR0b25DZWxsSXRlbVwiO1xyXG5pbXBvcnQgeyBTdGlUZXh0Qm94Q2VsbEl0ZW0gfSBmcm9tIFwiLi90YWJsZS9jZWxscy9TdGlUZXh0Qm94Q2VsbEl0ZW1cIjtcclxuaW1wb3J0IHsgU3RpQ2hlY2tCb3hDb2x1bW5JdGVtIH0gZnJvbSBcIi4vdGFibGUvY29sdW1ucy9TdGlDaGVja0JveENvbHVtbkl0ZW1cIjtcclxuaW1wb3J0IHsgU3RpQ29tYm9Cb3hDb2x1bW5JdGVtIH0gZnJvbSBcIi4vdGFibGUvY29sdW1ucy9TdGlDb21ib0JveENvbHVtbkl0ZW1cIjtcclxuaW1wb3J0IHsgU3RpTGFiZWxDb2x1bW5JdGVtIH0gZnJvbSBcIi4vdGFibGUvY29sdW1ucy9TdGlMYWJlbENvbHVtbkl0ZW1cIjtcclxuaW1wb3J0IHsgU3RpTnVtYmVyQm94Q29sdW1uSXRlbSB9IGZyb20gXCIuL3RhYmxlL2NvbHVtbnMvU3RpTnVtYmVyQm94Q29sdW1uSXRlbVwiO1xyXG5pbXBvcnQgeyBTdGlSYWRpb0J1dHRvbkNvbHVtbkl0ZW0gfSBmcm9tIFwiLi90YWJsZS9jb2x1bW5zL1N0aVJhZGlvQnV0dG9uQ29sdW1uSXRlbVwiO1xyXG5pbXBvcnQgeyBTdGlUZXh0Qm94Q29sdW1uSXRlbSB9IGZyb20gXCIuL3RhYmxlL2NvbHVtbnMvU3RpVGV4dEJveENvbHVtbkl0ZW1cIjtcclxuaW1wb3J0IHsgU3RpQ29sdW1uSXRlbSB9IGZyb20gXCIuL3RhYmxlL1N0aUNvbHVtbkl0ZW1cIjtcclxuaW1wb3J0IHsgU3RpUm93TGFiZWwgfSBmcm9tIFwiLi90YWJsZS9TdGlSb3dMYWJlbFwiO1xyXG5pbXBvcnQgeyBTdGlUb3RhbHNGaWVsZEl0ZW0gfSBmcm9tIFwiLi90YWJsZS9TdGlUb3RhbHNGaWVsZEl0ZW1cIjtcclxuaW1wb3J0IHsgU3RpVG90YWxzUm93SGVhZGVyRWRpdGFibGVDb250ZW50IH0gZnJvbSBcIi4vdGFibGUvU3RpVG90YWxzUm93SGVhZGVyRWRpdGFibGVDb250ZW50XCI7XHJcbmltcG9ydCB7IFN0aUxhYmVsSXRlbSB9IGZyb20gXCIuL3RleHQvU3RpTGFiZWxJdGVtXCI7XHJcbmltcG9ydCB7IFN0aVRleHRJdGVtIH0gZnJvbSBcIi4vdGV4dC9TdGlUZXh0SXRlbVwiO1xyXG5pbXBvcnQgeyBTdGlJbnB1dFRleHRJdGVtIH0gZnJvbSBcIi4uL2hlbHBlci9TdGlJbnB1dFRleHRJdGVtXCI7XHJcbmltcG9ydCB7IFN0aU1vZGVsU2VydmljZSB9IGZyb20gXCIuLi9zZXJ2aWNlcy9tb2RlbC5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aUZvcm0gfSBmcm9tIFwiLi9TdGlGb3JtXCI7XHJcblxyXG5leHBvcnQgY2xhc3MgU3RpVGFibGVFbGVtZW50IGV4dGVuZHMgU3RpRm9ybUVsZW1lbnQgaW1wbGVtZW50cyBTdGlFZGl0YWJsZUNvbnRlbnQsIFN0aVRhYkluZGV4IHtcclxuICBwdWJsaWMgdHlwZTogc3RyaW5nID0gXCJUYWJsZUVsZW1lbnRcIjtcclxuICBwdWJsaWMgZGVzY3JpcHRpb246IFN0aVRleHRJdGVtID0gbmV3IFN0aVRleHRJdGVtKCk7XHJcbiAgcHVibGljIGZvbnQ6IEZvbnQgPSBuZXcgRm9udChcIlNlZ29lIFVJXCIsIDEwKTtcclxuICBwdWJsaWMgYm9yZGVyOiBTdGlCb3JkZXIgPSBuZXcgU3RpQm9yZGVyKFN0aVBlbi5kaW1HcmF5U29saWQoKSwgdHJ1ZSwgdHJ1ZSwgdHJ1ZSwgdHJ1ZSk7XHJcbiAgcHVibGljIGdyaWRMaW5lczogU3RpSW5uZXJCb3JkZXIgPSBuZXcgU3RpSW5uZXJCb3JkZXIoU3RpUGVuLmRpbUdyYXlTb2xpZCgpLCB0cnVlLCB0cnVlKTtcclxuICBwdWJsaWMgYmFja2dyb3VuZENvbG9yOiBDb2xvciA9IENvbG9yLnRyYW5zcGFyZW50KCk7XHJcbiAgcHVibGljIGFsdGVybmF0ZVJvd0NvbG9ycyA9IGZhbHNlO1xyXG4gIHB1YmxpYyBldmVuUm93c1N0eWxlOiBDb2xvciA9IENvbG9yLmZyb21BcmdiKDB4ZmYsIDB4ZjksIDB4ZjksIDB4ZjkpO1xyXG4gIHB1YmxpYyBldmVuUm93c1RleHRDb2xvcjogQ29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG4gIHB1YmxpYyBvZGRSb3dzU3R5bGU6IENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMHhmZiwgMHhmMywgMHhmMywgMHhmMyk7XHJcbiAgcHVibGljIG9kZFJvd3NUZXh0Q29sb3I6IENvbG9yID0gQ29sb3IuYmxhY2soKTtcclxuICBwdWJsaWMgdGFibGVIZWFkZXJUZXh0OiBzdHJpbmcgPSBcIlwiO1xyXG4gIHB1YmxpYyB0YWJsZUhlYWRlckFsaWdubWVudDogU3RpSG9yaXpvbnRhbEFsaWdubWVudCA9IFN0aUhvcml6b250YWxBbGlnbm1lbnQuTGVmdDtcclxuICBwdWJsaWMgdGFibGVIZWFkZXJDb2xvcjogQ29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG4gIHB1YmxpYyB0YWJsZUhlYWRlckhlaWdodDogbnVtYmVyID0gMDtcclxuICBwdWJsaWMgdGFibGVIZWFkZXJCYWNrZ3JvdW5kQ29sb3I6IENvbG9yID0gQ29sb3IudHJhbnNwYXJlbnQoKTtcclxuICBwdWJsaWMgcm93TGFiZWxzV2lkdGg6IG51bWJlciA9IDEwMDtcclxuICBwcml2YXRlIF9zaG93Um93TGFiZWxzOiBib29sZWFuID0gZmFsc2U7XHJcbiAgcHVibGljIGR5bmFtaWNSb3dzID0gZmFsc2U7XHJcbiAgcHVibGljIHVzZVdvcmRXcmFwID0gZmFsc2U7XHJcbiAgcHJpdmF0ZSBfcm93TGFiZWxzOiBzdHJpbmdbXTtcclxuICBwdWJsaWMgbmF0aXZlUm93TGFiZWxzOiBzdHJpbmdbXTtcclxuICBwdWJsaWMgcm93TGFiZWxzQ29udGVudEVkaXRhYmxlOiBTdGlSb3dMYWJlbFtdID0gW107XHJcbiAgcHVibGljIHJvd0xhYmVsc0hvcml6b250YWxBbGlnbm1lbnQ6IFN0aUhvcml6b250YWxBbGlnbm1lbnQgPSBTdGlIb3Jpem9udGFsQWxpZ25tZW50LkxlZnQ7XHJcbiAgcHVibGljIHJvd0hlYWRlcnNCYWNrZ3JvdW5kOiBDb2xvciA9IENvbG9yLnRyYW5zcGFyZW50KCk7XHJcbiAgcHVibGljIHJvd0hlYWRlcnNDb2xvcjogQ29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG4gIHB1YmxpYyByb3dIZWFkZXJzQm9yZGVyOiBTdGlCb3JkZXIgPSBuZXcgU3RpQm9yZGVyKFN0aVBlbi5kaW1HcmF5U29saWQoKSwgdHJ1ZSwgdHJ1ZSwgdHJ1ZSwgdHJ1ZSk7XHJcbiAgcHVibGljIGNvbHVtbkhlYWRlcnNCb3JkZXI6IFN0aUJvcmRlciA9IG5ldyBTdGlCb3JkZXIoU3RpUGVuLmRpbUdyYXlTb2xpZCgpLCB0cnVlLCB0cnVlLCB0cnVlLCB0cnVlKTtcclxuICBwcml2YXRlIF9jb2x1bW5zOiBTdGlDb2x1bW5JdGVtW10gPSBbXTtcclxuICBwdWJsaWMgdXNlVG90YWxzOiBib29sZWFuID0gdHJ1ZTtcclxuICBwdWJsaWMgdG90YWxzUm93SGVhZGVyID0gU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJQcm9wZXJ0eU1haW5cIiwgXCJUb3RhbHNcIik7XHJcbiAgcHVibGljIHRvdGFsc1Jvd0hlYWRlckhvcml6b250YWxBbGlnbm1lbnQ6IFN0aUhvcml6b250YWxBbGlnbm1lbnQgPSBTdGlIb3Jpem9udGFsQWxpZ25tZW50LkxlZnQ7XHJcbiAgcHVibGljIHRvdGFsc1Jvd0hlYWRlclZlcnRpY2FsQWxpZ25tZW50OiBTdGlWZXJ0aWNhbEFsaWdubWVudCA9IFN0aVZlcnRpY2FsQWxpZ25tZW50LlRvcDtcclxuICBwdWJsaWMgdG90YWxzUm93SGVhZGVyQ29sb3I6IENvbG9yID0gQ29sb3IuYmxhY2soKTtcclxuICBwcml2YXRlIF90b3RhbHNWYWx1ZXNXaWR0aDogbnVtYmVyID0gMTAwO1xyXG4gIHByaXZhdGUgX3RvdGFsc0hlYWRlcnNXaWR0aDogbnVtYmVyID0gMTAwO1xyXG4gIHB1YmxpYyB0b3RhbHNGaWVsZHM6IFN0aVRvdGFsc0ZpZWxkSXRlbVtdID0gW107XHJcbiAgcHVibGljIHNob3dCb3JkZXJFZGl0b3I6IGJvb2xlYW4gPSBmYWxzZTtcclxuICBwdWJsaWMgc2hvd0dyaWRMaW5lc0VkaXRvcjogYm9vbGVhbiA9IGZhbHNlO1xyXG5cclxuICBwcml2YXRlIF9zaG93SGVhZGVyRWRpdG9yOiBib29sZWFuID0gdHJ1ZTtcclxuICBwcml2YXRlIF9zaG93Q29sdW1uc0VkaXRvcjogYm9vbGVhbiA9IGZhbHNlO1xyXG4gIHByaXZhdGUgX3Nob3dSb3dzRWRpdG9yOiBib29sZWFuID0gZmFsc2U7XHJcbiAgcHJpdmF0ZSBfc2hvd1RvdGFsc0VkaXRvcjogYm9vbGVhbiA9IGZhbHNlO1xyXG4gIHByaXZhdGUgc3RvcEZpdCA9IGZhbHNlO1xyXG5cclxuICBwdWJsaWMgc2hvd0NvbHVtbnNCb3JkZXJFZGl0b3I6IGJvb2xlYW4gPSB0cnVlO1xyXG4gIHB1YmxpYyBzaG93Um93c0JvcmRlckVkaXRvcjogYm9vbGVhbiA9IGZhbHNlO1xyXG4gIHB1YmxpYyBtaW5Db2x1bW5XaWR0aDogbnVtYmVyID0gNDA7XHJcbiAgcHVibGljIHRvdGFsc1Jvd0hlYWRlckVkaXRhYmxlQ29udGVudCA9IG5ldyBTdGlUb3RhbHNSb3dIZWFkZXJFZGl0YWJsZUNvbnRlbnQodGhpcyk7XHJcbiAgcHVibGljIHRhYkluZGV4OiBudW1iZXI7XHJcbiAgcHVibGljIGZvcm06IFN0aUZvcm07XHJcblxyXG4gIHB1YmxpYyBnZXQgc2hvd1Jvd0xhYmVscygpOiBib29sZWFuIHtcclxuICAgIHJldHVybiB0aGlzLl9zaG93Um93TGFiZWxzO1xyXG4gIH1cclxuICBwdWJsaWMgc2V0IHNob3dSb3dMYWJlbHModmFsdWU6IGJvb2xlYW4pIHtcclxuICAgIGxldCBwcmV2aW91c1ZhbHVlID0gdGhpcy5fc2hvd1Jvd0xhYmVscztcclxuICAgIGlmIChwcmV2aW91c1ZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMuX3Nob3dSb3dMYWJlbHMgPSB2YWx1ZTtcclxuICAgICAgdGhpcy5maXRUYWJsZSgpO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBzaG93SGVhZGVyRWRpdG9yKCk6IGJvb2xlYW4ge1xyXG4gICAgcmV0dXJuIHRoaXMuX3Nob3dIZWFkZXJFZGl0b3I7XHJcbiAgfVxyXG4gIHB1YmxpYyBzZXQgc2hvd0hlYWRlckVkaXRvcih2YWx1ZTogYm9vbGVhbikge1xyXG4gICAgdGhpcy5fc2hvd0hlYWRlckVkaXRvciA9IHZhbHVlO1xyXG4gICAgaWYgKHZhbHVlID09IHRydWUpIHtcclxuICAgICAgdGhpcy5fc2hvd0NvbHVtbnNFZGl0b3IgPSBmYWxzZTtcclxuICAgICAgdGhpcy5fc2hvd1Jvd3NFZGl0b3IgPSBmYWxzZTtcclxuICAgICAgdGhpcy5fc2hvd1RvdGFsc0VkaXRvciA9IGZhbHNlO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBuYW1lKHZhbHVlOiBzdHJpbmcpIHtcclxuICAgIGxldCBvbGROYW1lID0gdGhpcy5uYW1lO1xyXG4gICAgc3VwZXIubmFtZSA9IHZhbHVlO1xyXG4gICAgdGhpcy5uYW1lQ2hhbmdlZChvbGROYW1lKTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBnZXQgbmFtZSgpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIHN1cGVyLm5hbWU7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0IHRvdGFsc1ZhbHVlc1dpZHRoKCk6IG51bWJlciB7XHJcbiAgICByZXR1cm4gdGhpcy5fdG90YWxzVmFsdWVzV2lkdGg7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IHRvdGFsc1ZhbHVlc1dpZHRoKHZhbHVlOiBudW1iZXIpIHtcclxuICAgIGlmICh2YWx1ZSA+IDApIHtcclxuICAgICAgdGhpcy5fdG90YWxzVmFsdWVzV2lkdGggPSB2YWx1ZTtcclxuICAgIH0gZWxzZSB7XHJcbiAgICAgIHRoaXMuX3RvdGFsc1ZhbHVlc1dpZHRoID0gMDtcclxuICAgIH1cclxuICB9XHJcbiAgcHVibGljIGdldCB0b3RhbHNIZWFkZXJzV2lkdGgoKTogbnVtYmVyIHtcclxuICAgIHJldHVybiB0aGlzLl90b3RhbHNIZWFkZXJzV2lkdGg7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IHRvdGFsc0hlYWRlcnNXaWR0aCh2YWx1ZTogbnVtYmVyKSB7XHJcbiAgICBpZiAodmFsdWUgPiAwKSB7XHJcbiAgICAgIHRoaXMuX3RvdGFsc0hlYWRlcnNXaWR0aCA9IHZhbHVlO1xyXG4gICAgfSBlbHNlIHtcclxuICAgICAgdGhpcy5fdG90YWxzSGVhZGVyc1dpZHRoID0gMDtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBnZXQgc2hvd0NvbHVtbnNFZGl0b3IoKTogYm9vbGVhbiB7XHJcbiAgICByZXR1cm4gdGhpcy5fc2hvd0NvbHVtbnNFZGl0b3I7XHJcbiAgfVxyXG4gIHB1YmxpYyBzZXQgc2hvd0NvbHVtbnNFZGl0b3IodmFsdWU6IGJvb2xlYW4pIHtcclxuICAgIHRoaXMuX3Nob3dDb2x1bW5zRWRpdG9yID0gdmFsdWU7XHJcbiAgICBpZiAodmFsdWUgPT0gdHJ1ZSkge1xyXG4gICAgICB0aGlzLl9zaG93SGVhZGVyRWRpdG9yID0gZmFsc2U7XHJcbiAgICAgIHRoaXMuX3Nob3dSb3dzRWRpdG9yID0gZmFsc2U7XHJcbiAgICAgIHRoaXMuX3Nob3dUb3RhbHNFZGl0b3IgPSBmYWxzZTtcclxuICAgIH1cclxuICB9XHJcbiAgcHVibGljIGdldCBzaG93Um93c0VkaXRvcigpOiBib29sZWFuIHtcclxuICAgIHJldHVybiB0aGlzLl9zaG93Um93c0VkaXRvcjtcclxuICB9XHJcbiAgcHVibGljIHNldCBzaG93Um93c0VkaXRvcih2YWx1ZTogYm9vbGVhbikge1xyXG4gICAgdGhpcy5fc2hvd1Jvd3NFZGl0b3IgPSB2YWx1ZTtcclxuICAgIGlmICh2YWx1ZSA9PSB0cnVlKSB7XHJcbiAgICAgIHRoaXMuX3Nob3dIZWFkZXJFZGl0b3IgPSBmYWxzZTtcclxuICAgICAgdGhpcy5fc2hvd0NvbHVtbnNFZGl0b3IgPSBmYWxzZTtcclxuICAgICAgdGhpcy5fc2hvd1RvdGFsc0VkaXRvciA9IGZhbHNlO1xyXG4gICAgfVxyXG4gIH1cclxuICBwdWJsaWMgZ2V0IHNob3dUb3RhbHNFZGl0b3IoKTogYm9vbGVhbiB7XHJcbiAgICByZXR1cm4gdGhpcy5fc2hvd1RvdGFsc0VkaXRvcjtcclxuICB9XHJcbiAgcHVibGljIHNldCBzaG93VG90YWxzRWRpdG9yKHZhbHVlOiBib29sZWFuKSB7XHJcbiAgICB0aGlzLl9zaG93VG90YWxzRWRpdG9yID0gdmFsdWU7XHJcbiAgICBpZiAodmFsdWUgPT0gdHJ1ZSkge1xyXG4gICAgICB0aGlzLl9zaG93SGVhZGVyRWRpdG9yID0gZmFsc2U7XHJcbiAgICAgIHRoaXMuX3Nob3dDb2x1bW5zRWRpdG9yID0gZmFsc2U7XHJcbiAgICAgIHRoaXMuX3Nob3dSb3dzRWRpdG9yID0gZmFsc2U7XHJcbiAgICB9XHJcbiAgfVxyXG4gIHB1YmxpYyBnZXREZWZhdWx0RWRpdGFibGVDb250ZW50KCk6IFN0aUVkaXRhYmxlQ29udGVudCB7XHJcbiAgICBsZXQgdGV4dEl0ZW0gPSBuZXcgU3RpSW5wdXRUZXh0SXRlbShcIlwiLCB0aGlzLmZvbnQpO1xyXG4gICAgdGV4dEl0ZW0uZWxlbWVudCA9IHRoaXM7XHJcbiAgICByZXR1cm4gdGV4dEl0ZW07XHJcbiAgfVxyXG5cclxuICBjb25zdHJ1Y3Rvcihmb3JtOiBTdGlGb3JtKSB7XHJcbiAgICBzdXBlcigpO1xyXG4gICAgdGhpcy5mb3JtID0gZm9ybTtcclxuICAgIHRoaXMuZ2VvbWV0cnkgPSBuZXcgU3RpUmVjdGFuZ2xlR2VvbWV0cnkoMzIwLCAyNDUpO1xyXG4gICAgdGhpcy5sYWJlbCA9IG5ldyBTdGlMYWJlbEl0ZW0odGhpcywgU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJDb21wb25lbnRzXCIsIFwiU3RpVGFibGVcIikpO1xyXG4gICAgdGhpcy5jb2x1bW5zID0gW107XHJcbiAgICB0aGlzLnJvd0xhYmVscyA9IFtcIlwiLCBcIlwiLCBcIlwiXTtcclxuICAgIHRoaXMuY29sdW1ucy5wdXNoKHRoaXMuY3JlYXRlQ29sdW1uKFwidGV4dGJveFwiKSk7XHJcblxyXG4gICAgLyp0aGlzLmNvbHVtbnMucHVzaChuZXcgU3RpQ29tYm9Cb3hDb2x1bW5JdGVtKFN0aUxvY2FsaXphdGlvblNlcnZpY2UuZ2V0KFwiUHJvcGVydHlNYWluXCIsIFwiU2Vjb25kXCIpKSk7XHJcbiAgICB0aGlzLmNvbHVtbnMucHVzaChuZXcgU3RpUmFkaW9CdXR0b25Db2x1bW5JdGVtKFN0aUxvY2FsaXphdGlvblNlcnZpY2UuZ2V0KFwiUHJvcGVydHlNYWluXCIsIFwiVGhpcmRcIikpKTtcclxuICAgIHRoaXMuY29sdW1ucy5wdXNoKG5ldyBTdGlUZXh0Qm94Q29sdW1uSXRlbShTdGlMb2NhbGl6YXRpb25TZXJ2aWNlLmdldChcIlByb3BlcnR5TWFpblwiLCBcIkZvdXJ0aFwiKSkpO1xyXG4gICAgdGhpcy5jb2x1bW5zLnB1c2gobmV3IFN0aU51bWJlckJveENvbHVtbkl0ZW0oU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJQcm9wZXJ0eU1haW5cIiwgXCJGaWZ0aFwiKSkpO1xyXG4gICAgdGhpcy5jb2x1bW5zLnB1c2gobmV3IFN0aUxhYmVsQ29sdW1uSXRlbShTdGlMb2NhbGl6YXRpb25TZXJ2aWNlLmdldChcIlByb3BlcnR5TWFpblwiLCBcIkxhYmVsc1wiKSkpO1xyXG4gICAgdGhpcy5yb3dMYWJlbHMgPSBbXTtcclxuICAgIHRoaXMucm93TGFiZWxzLnB1c2goU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJQcm9wZXJ0eU1haW5cIiwgXCJGaXJzdFwiKSk7XHJcbiAgICB0aGlzLnJvd0xhYmVscy5wdXNoKFN0aUxvY2FsaXphdGlvblNlcnZpY2UuZ2V0KFwiUHJvcGVydHlNYWluXCIsIFwiU2Vjb25kXCIpKTtcclxuICAgIHRoaXMucm93TGFiZWxzLnB1c2goU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJQcm9wZXJ0eU1haW5cIiwgXCJUaGlyZFwiKSk7XHJcbiAgICB0aGlzLnRvdGFsc0ZpZWxkcy5wdXNoKG5ldyBTdGlUb3RhbHNGaWVsZEl0ZW0oU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJQcm9wZXJ0eU1haW5cIiwgXCJGaXJzdFwiKSwgXCJ7Q2VsbCg1LDEpfVwiLCB0aGlzLmZvcm0pKTtcclxuICAgIHRoaXMudG90YWxzRmllbGRzLnB1c2goXHJcbiAgICAgIG5ldyBTdGlUb3RhbHNGaWVsZEl0ZW0oU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJQcm9wZXJ0eU1haW5cIiwgXCJNYXhpbXVtXCIpLCBcIntNYXgoQ29sKDUpKX1cIiwgdGhpcy5mb3JtKVxyXG4gICAgKTtcclxuICAgIHRoaXMudG90YWxzRmllbGRzLnB1c2goXHJcbiAgICAgIG5ldyBTdGlUb3RhbHNGaWVsZEl0ZW0oU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJQcm9wZXJ0eU1haW5cIiwgXCJTdW1tYXJ5XCIpLCBcIntTdW0oQ29sKDUpKX1cIiwgdGhpcy5mb3JtKVxyXG4gICAgKTtcclxuICAgIHRoaXMudG90YWxzRmllbGRzLnB1c2goXHJcbiAgICAgIG5ldyBTdGlUb3RhbHNGaWVsZEl0ZW0oU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJQcm9wZXJ0eU1haW5cIiwgXCJDb3VudFwiKSwgXCJ7Q291bnQoQ29sKDUpKX1cIiwgdGhpcy5mb3JtKVxyXG4gICAgKTtcclxuICAgIHRoaXMuY29sdW1ucy5mb3JFYWNoKChjb2x1bW4pID0+IHtcclxuICAgICAgaWYgKGNvbHVtbi50eXBlID09IFwiQ2hlY2tCb3hDb2x1bW5cIiAmJiBjb2x1bW4gaW5zdGFuY2VvZiBTdGlDaGVja0JveENvbHVtbkl0ZW0pIHtcclxuICAgICAgICB0aGlzLnJvd0xhYmVscy5mb3JFYWNoKChyb3cpID0+IHtcclxuICAgICAgICAgIGNvbHVtbi5jZWxscy5wdXNoKG5ldyBTdGlDaGVja0JveENlbGxJdGVtKFwiXCIsIGZhbHNlKSk7XHJcbiAgICAgICAgfSk7XHJcbiAgICAgIH0gZWxzZSBpZiAoY29sdW1uLnR5cGUgPT0gXCJDb21ib0JveENvbHVtblwiICYmIGNvbHVtbiBpbnN0YW5jZW9mIFN0aUNvbWJvQm94Q29sdW1uSXRlbSkge1xyXG4gICAgICAgIGNvbHVtbi5jb21ib0JveE9wdGlvbnMucHVzaChcInllc1wiKTtcclxuICAgICAgICBjb2x1bW4uY29tYm9Cb3hPcHRpb25zLnB1c2goXCJub1wiKTtcclxuICAgICAgICB0aGlzLnJvd0xhYmVscy5mb3JFYWNoKChyb3cpID0+IHtcclxuICAgICAgICAgIGNvbHVtbi5jZWxscy5wdXNoKG5ldyBTdGlDb21ib0JveENlbGxJdGVtKFwiXCIsIDApKTtcclxuICAgICAgICB9KTtcclxuICAgICAgfSBlbHNlIGlmIChjb2x1bW4udHlwZSA9PSBcIlJhZGlvQnV0dG9uQ29sdW1uXCIgJiYgY29sdW1uIGluc3RhbmNlb2YgU3RpUmFkaW9CdXR0b25Db2x1bW5JdGVtKSB7XHJcbiAgICAgICAgdGhpcy5yb3dMYWJlbHMuZm9yRWFjaCgocm93KSA9PiB7XHJcbiAgICAgICAgICBjb2x1bW4uY2VsbHMucHVzaChuZXcgU3RpUmFkaW9CdXR0b25DZWxsSXRlbShcIlwiLCBmYWxzZSkpO1xyXG4gICAgICAgIH0pO1xyXG4gICAgICB9IGVsc2UgaWYgKGNvbHVtbi50eXBlID09IFwiVGV4dEJveENvbHVtblwiICYmIGNvbHVtbiBpbnN0YW5jZW9mIFN0aVRleHRCb3hDb2x1bW5JdGVtKSB7XHJcbiAgICAgICAgdGhpcy5yb3dMYWJlbHMuZm9yRWFjaCgocm93KSA9PiB7XHJcbiAgICAgICAgICBjb2x1bW4uY2VsbHMucHVzaChuZXcgU3RpVGV4dEJveENlbGxJdGVtKFwiXCIsIFwiXCIpKTtcclxuICAgICAgICB9KTtcclxuICAgICAgfSBlbHNlIGlmIChjb2x1bW4udHlwZSA9PSBcIk51bWJlckJveENvbHVtblwiICYmIGNvbHVtbiBpbnN0YW5jZW9mIFN0aU51bWJlckJveENvbHVtbkl0ZW0pIHtcclxuICAgICAgICB0aGlzLnJvd0xhYmVscy5mb3JFYWNoKChyb3cpID0+IHtcclxuICAgICAgICAgIGNvbHVtbi5jZWxscy5wdXNoKG5ldyBTdGlOdW1iZXJCb3hDZWxsSXRlbShcIlwiLCAwKSk7XHJcbiAgICAgICAgfSk7XHJcbiAgICAgIH0gZWxzZSBpZiAoY29sdW1uLnR5cGUgPT0gXCJMYWJlbENvbHVtblwiICYmIGNvbHVtbiBpbnN0YW5jZW9mIFN0aUxhYmVsQ29sdW1uSXRlbSkge1xyXG4gICAgICAgIHRoaXMucm93TGFiZWxzLmZvckVhY2goKHJvdykgPT4ge1xyXG4gICAgICAgICAgY29sdW1uLmNlbGxzLnB1c2goXCJcIik7XHJcbiAgICAgICAgfSk7XHJcbiAgICAgIH1cclxuICAgIH0pOyovXHJcbiAgfVxyXG5cclxuICBwdWJsaWMgY3JlYXRlQ29sdW1uKHR5cGU6IHN0cmluZywgbGFiZWw/OiBzdHJpbmcsIHBhcmVudEl0ZW0/OiBTdGlDb2x1bW5JdGVtKTogU3RpQ29sdW1uSXRlbSB7XHJcbiAgICB0eXBlID0gdHlwZS50b0xvY2FsZUxvd2VyQ2FzZSgpO1xyXG4gICAgbGFiZWwgPSBsYWJlbCA/PyBcIlwiO1xyXG4gICAgbGV0IGNvbHVtbkl0ZW06IFN0aUNvbHVtbkl0ZW07XHJcbiAgICBpZiAodHlwZS5zdGFydHNXaXRoKFwiY2hlY2tib3hcIikpIHtcclxuICAgICAgY29sdW1uSXRlbSA9IG5ldyBTdGlDaGVja0JveENvbHVtbkl0ZW0obGFiZWwsIHRoaXMuZm9ybSk7XHJcbiAgICB9IGVsc2UgaWYgKHR5cGUuc3RhcnRzV2l0aChcImNvbWJvYm94XCIpKSB7XHJcbiAgICAgIGNvbHVtbkl0ZW0gPSBuZXcgU3RpQ29tYm9Cb3hDb2x1bW5JdGVtKGxhYmVsLCB0aGlzLmZvcm0pO1xyXG4gICAgfSBlbHNlIGlmICh0eXBlLnN0YXJ0c1dpdGgoXCJudW1iZXJib3hcIikpIHtcclxuICAgICAgY29sdW1uSXRlbSA9IG5ldyBTdGlOdW1iZXJCb3hDb2x1bW5JdGVtKGxhYmVsLCB0aGlzLmZvcm0pO1xyXG4gICAgfSBlbHNlIGlmICh0eXBlLnN0YXJ0c1dpdGgoXCJyYWRpb2J1dHRvblwiKSkge1xyXG4gICAgICBjb2x1bW5JdGVtID0gbmV3IFN0aVJhZGlvQnV0dG9uQ29sdW1uSXRlbShsYWJlbCwgdGhpcy5mb3JtKTtcclxuICAgIH0gZWxzZSBpZiAodHlwZS5zdGFydHNXaXRoKFwidGV4dGJveFwiKSkge1xyXG4gICAgICBjb2x1bW5JdGVtID0gbmV3IFN0aVRleHRCb3hDb2x1bW5JdGVtKGxhYmVsLCB0aGlzLmZvcm0pO1xyXG4gICAgfSBlbHNlIGlmICh0eXBlLnN0YXJ0c1dpdGgoXCJsYWJlbFwiKSkge1xyXG4gICAgICBjb2x1bW5JdGVtID0gbmV3IFN0aUxhYmVsQ29sdW1uSXRlbShsYWJlbCwgdGhpcy5mb3JtKTtcclxuICAgIH1cclxuXHJcbiAgICBpZiAocGFyZW50SXRlbSkge1xyXG4gICAgICBjb2x1bW5JdGVtLmNvcHlGcm9tKHBhcmVudEl0ZW0pO1xyXG4gICAgfVxyXG5cclxuICAgIHJldHVybiBjb2x1bW5JdGVtO1xyXG4gIH1cclxuXHJcbiAgc2V0VGFiSW5kZXgodmFsdWU6IG51bWJlcik6IG51bWJlciB7XHJcbiAgICB0aGlzLnRhYkluZGV4ID0gdmFsdWU7XHJcbiAgICByZXR1cm4gdmFsdWUgKyAodGhpcy5jb2x1bW5zPy5sZW5ndGggKiB0aGlzLl9yb3dMYWJlbHM/Lmxlbmd0aCA/PyAwKTtcclxuICB9XHJcbiAgcHVibGljIGdldCBtYXhUYWJsZVdpZHRoKCk6IG51bWJlciB7XHJcbiAgICByZXR1cm4gKFxyXG4gICAgICB0aGlzLndpZHRoIC1cclxuICAgICAgdGhpcy5wYWRkaW5nLmxlZnQgLVxyXG4gICAgICB0aGlzLnBhZGRpbmcucmlnaHQgLVxyXG4gICAgICAodGhpcy5sYWJlbC5hbGlnbm1lbnQgIT0gU3RpTGFiZWxBbGlnbm1lbnQuVG9wICYmIHRoaXMubGFiZWwudmFsdWUubGVuZ3RoID4gMCA/IHRoaXMubGFiZWwud2lkdGggOiAwKVxyXG4gICAgKTtcclxuICB9XHJcbiAgc2V0IHJvd0xhYmVscyh2YWx1ZTogc3RyaW5nW10pIHtcclxuICAgIHRoaXMubmF0aXZlUm93TGFiZWxzID0gdmFsdWU7XHJcbiAgICBsZXQgdGhpc18gPSB0aGlzO1xyXG4gICAgdGhpcy5fcm93TGFiZWxzID0gbmV3IFByb3h5KHZhbHVlLCB7XHJcbiAgICAgIGRlbGV0ZVByb3BlcnR5OiBmdW5jdGlvbiAodGFyZ2V0LCBwcm9wZXJ0eSkge1xyXG4gICAgICAgIHNldFRpbWVvdXQoKCkgPT4ge1xyXG4gICAgICAgICAgdGhpc18udXBkYXRlUm93TGFiZWxzQ29udGVudEVkaXRhYmxlKCk7XHJcbiAgICAgICAgfSwgMCk7XHJcbiAgICAgICAgcmV0dXJuIHRydWU7XHJcbiAgICAgIH0sXHJcbiAgICAgIHNldDogZnVuY3Rpb24gKHRhcmdldCwgcHJvcGVydHksIHZhbHVlLCByZWNlaXZlcikge1xyXG4gICAgICAgIHRhcmdldFtwcm9wZXJ0eV0gPSB2YWx1ZTtcclxuICAgICAgICB0aGlzXy51cGRhdGVSb3dMYWJlbHNDb250ZW50RWRpdGFibGUoKTtcclxuICAgICAgICByZXR1cm4gdHJ1ZTtcclxuICAgICAgfSxcclxuICAgIH0pO1xyXG4gICAgdGhpcy51cGRhdGVSb3dMYWJlbHNDb250ZW50RWRpdGFibGUoKTtcclxuICB9XHJcblxyXG4gIGdldCByb3dMYWJlbHMoKTogc3RyaW5nW10ge1xyXG4gICAgcmV0dXJuIHRoaXMuX3Jvd0xhYmVscztcclxuICB9XHJcbiAgc2V0RGVmYXVsdFZhbHVlcygpIHtcclxuICAgIHRoaXMuY29sdW1ucy5mb3JFYWNoKChjb2x1bW4pID0+IHtcclxuICAgICAgY29sdW1uLnNldERlZmF1bHRWYWx1ZXMoKTtcclxuICAgIH0pO1xyXG4gICAgdGhpcy50b3RhbHNGaWVsZHMuZm9yRWFjaCgodG90YWwpID0+IHtcclxuICAgICAgdG90YWwuc2V0RGVmYXVsdFZhbHVlcygpO1xyXG4gICAgfSk7XHJcbiAgfVxyXG4gIHNldCBjb2x1bW5zKHZhbHVlOiBTdGlDb2x1bW5JdGVtW10pIHtcclxuICAgIGxldCB0aGlzXyA9IHRoaXM7XHJcbiAgICB0aGlzLl9jb2x1bW5zID0gbmV3IFByb3h5KHZhbHVlLCB7XHJcbiAgICAgIGRlbGV0ZVByb3BlcnR5OiBmdW5jdGlvbiAodGFyZ2V0LCBwcm9wZXJ0eSkge1xyXG4gICAgICAgIHNldFRpbWVvdXQoKCkgPT4ge1xyXG4gICAgICAgICAgdGhpc18uZml0VGFibGUoKTtcclxuICAgICAgICB9LCAwKTtcclxuICAgICAgICByZXR1cm4gdHJ1ZTtcclxuICAgICAgfSxcclxuICAgICAgc2V0OiBmdW5jdGlvbiAodGFyZ2V0OiBhbnksIHByb3BlcnR5LCB2YWx1ZSwgcmVjZWl2ZXIpIHtcclxuICAgICAgICB0YXJnZXRbcHJvcGVydHldID0gdmFsdWU7XHJcbiAgICAgICAgbGV0IGNvbHVtbiA9IHZhbHVlIGFzIFN0aUNvbHVtbkl0ZW07XHJcbiAgICAgICAgaWYgKGNvbHVtbiBpbnN0YW5jZW9mIFN0aUNvbHVtbkl0ZW0gJiYgIWNvbHVtbi53aWR0aCkge1xyXG4gICAgICAgICAgY29sdW1uLndpZHRoID0gdGhpc18ubWF4VGFibGVXaWR0aCAvICh0aGlzXy5jb2x1bW5zLmxlbmd0aCArICh0aGlzXy5zaG93Um93TGFiZWxzID8gMSA6IDApKTtcclxuICAgICAgICB9XHJcblxyXG4gICAgICAgIGlmICh2YWx1ZS5jZWxscyAmJiB2YWx1ZS5jZWxscy5sZW5ndGggPCB0aGlzXy5yb3dMYWJlbHMubGVuZ3RoKSB7XHJcbiAgICAgICAgICBmb3IgKGxldCBpID0gdmFsdWUuY2VsbHMubGVuZ3RoOyBpIDwgdGhpc18ucm93TGFiZWxzLmxlbmd0aDsgaSsrKVxyXG4gICAgICAgICAgICB2YWx1ZS5jZWxscy5wdXNoKGNvbHVtbi5jcmVhdGVDZWxsKCkpO1xyXG4gICAgICAgIH1cclxuXHJcbiAgICAgICAgaWYgKCF0YXJnZXQuc3RvcEZpdCkge1xyXG4gICAgICAgICAgdGhpc18uZml0VGFibGUoKTtcclxuICAgICAgICB9XHJcbiAgICAgICAgcmV0dXJuIHRydWU7XHJcbiAgICAgIH0sXHJcbiAgICB9KTtcclxuICAgIHRoaXNfLmZpdFRhYmxlKCk7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZml0VGFibGUoKSB7XHJcbiAgICBpZiAodGhpcy5zdG9wRml0KSB7XHJcbiAgICAgIHJldHVybjtcclxuICAgIH1cclxuICAgIGxldCBjdXJyZW50V2lkdGggPSB0aGlzLnNob3dSb3dMYWJlbHMgPyB0aGlzLnJvd0xhYmVsc1dpZHRoIDogMDtcclxuICAgIHRoaXMuY29sdW1ucy5mb3JFYWNoKChjKSA9PiAoY3VycmVudFdpZHRoICs9IGMud2lkdGgpKTtcclxuICAgIGxldCBwYyA9IHRoaXMubWF4VGFibGVXaWR0aCAvIGN1cnJlbnRXaWR0aDtcclxuICAgIGlmIChjdXJyZW50V2lkdGggIT0gMCAmJiBjdXJyZW50V2lkdGggJiYgcGMpIHtcclxuICAgICAgaWYgKHRoaXMuc2hvd1Jvd0xhYmVscykge1xyXG4gICAgICAgIHRoaXMucm93TGFiZWxzV2lkdGggKj0gcGM7XHJcbiAgICAgIH1cclxuICAgICAgdGhpcy5jb2x1bW5zLmZvckVhY2goKGMpID0+IChjLndpZHRoICo9IHBjKSk7XHJcbiAgICB9XHJcblxyXG4gICAgcGMgPSB0aGlzLm1heFRhYmxlV2lkdGggLyAodGhpcy50b3RhbHNIZWFkZXJzV2lkdGggKyB0aGlzLnRvdGFsc1ZhbHVlc1dpZHRoKTtcclxuICAgIGlmIChwYyA8IDEpIHtcclxuICAgICAgdGhpcy50b3RhbHNIZWFkZXJzV2lkdGggKj0gcGM7XHJcbiAgICAgIHRoaXMudG90YWxzVmFsdWVzV2lkdGggKj0gcGM7XHJcbiAgICB9XHJcbiAgfVxyXG4gIHB1YmxpYyBkZWxldGVMYXN0Um93KCkge1xyXG4gICAgdGhpcy5yb3dMYWJlbHMuc3BsaWNlKHRoaXMucm93TGFiZWxzLmxlbmd0aCAtIDEsIDEpO1xyXG4gIH1cclxuICBwdWJsaWMgZGVsZXRlTGFzdENvbHVtbigpIHtcclxuICAgIHRoaXMuY29sdW1ucy5zcGxpY2UodGhpcy5jb2x1bW5zLmxlbmd0aCAtIDEsIDEpO1xyXG4gIH1cclxuICBwdWJsaWMgYWRkQ29sdW1uTGlrZUxhc3QoKSB7XHJcbiAgICBsZXQgbmV3Q29sdW1uV2lkdGggPSAodGhpcy5tYXhUYWJsZVdpZHRoIC0gdGhpcy5yb3dMYWJlbHNXaWR0aCkgLyAodGhpcy5jb2x1bW5zLmxlbmd0aCArIDEpO1xyXG4gICAgbGV0IG1heENoYW5nZWFibGVXaWR0aCA9IDA7XHJcbiAgICBpZiAodGhpcy5jb2x1bW5zLmxlbmd0aCA+IDApIHtcclxuICAgICAgdGhpcy5jb2x1bW5zLmZvckVhY2goKGNvbHVtbikgPT4ge1xyXG4gICAgICAgIGlmIChjb2x1bW4ud2lkdGggPiB0aGlzLm1pbkNvbHVtbldpZHRoKSB7XHJcbiAgICAgICAgICBtYXhDaGFuZ2VhYmxlV2lkdGggKz0gY29sdW1uLndpZHRoIC0gdGhpcy5taW5Db2x1bW5XaWR0aDtcclxuICAgICAgICB9XHJcbiAgICAgIH0pO1xyXG4gICAgfSBlbHNlIHtcclxuICAgICAgbWF4Q2hhbmdlYWJsZVdpZHRoID0gdGhpcy5tYXhUYWJsZVdpZHRoIC0gdGhpcy5yb3dMYWJlbHNXaWR0aDtcclxuICAgIH1cclxuICAgIGlmIChuZXdDb2x1bW5XaWR0aCA8PSBtYXhDaGFuZ2VhYmxlV2lkdGgpIHtcclxuICAgICAgaWYgKHRoaXMuY29sdW1ucy5sZW5ndGggPiAwKSB7XHJcbiAgICAgICAgbGV0IGxhc3RDb2x1bW4gPSB0aGlzLmNvbHVtbnNbdGhpcy5jb2x1bW5zLmxlbmd0aCAtIDFdXHJcbiAgICAgICAgdGhpcy5jb2x1bW5zLnB1c2godGhpcy5jcmVhdGVDb2x1bW4obGFzdENvbHVtbi50eXBlLCBcIlwiLCBsYXN0Q29sdW1uKSk7XHJcbiAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgdGhpcy5jb2x1bW5zLnB1c2gobmV3IFN0aU51bWJlckJveENvbHVtbkl0ZW0oXCJcIiwgdGhpcy5mb3JtKSk7XHJcbiAgICAgIH1cclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBhZGRSb3coKSB7XHJcbiAgICB0aGlzLnJvd0xhYmVscy5wdXNoKFwiXCIpO1xyXG4gICAgdGhpcy5jb2x1bW5zLmZvckVhY2goKGNvbHVtbikgPT4gKGNvbHVtbiBhcyBhbnkpLmNlbGxzLnB1c2goY29sdW1uLmNyZWF0ZUNlbGwoKSkpO1xyXG4gIH1cclxuXHJcbiAgc2V0UHJvcGVydHkocHJvcE5hbWU6IHN0cmluZywgdmFsdWU6IGFueSwgb2xkVmFsdWU6IGFueSkge1xyXG4gICAgc3VwZXIuc2V0UHJvcGVydHkocHJvcE5hbWUsIHZhbHVlLCBvbGRWYWx1ZSk7XHJcbiAgICBpZiAocHJvcE5hbWUgPT0gXCJ0aG91c2FuZFNlcGFyYXRvclwiKSB7XHJcbiAgICAgIHRoaXMuY29sdW1ucy5mb3JFYWNoKChjb2x1bW4pID0+IHtcclxuICAgICAgICBpZiAoXHJcbiAgICAgICAgICAoY29sdW1uIGluc3RhbmNlb2YgU3RpTnVtYmVyQm94Q29sdW1uSXRlbSB8fCBjb2x1bW4gaW5zdGFuY2VvZiBTdGlMYWJlbENvbHVtbkl0ZW0pICYmXHJcbiAgICAgICAgICAob2xkVmFsdWUgPT09IG51bGwgfHwgY29sdW1uLnRob3VzYW5kU2VwYXJhdG9yID09IG9sZFZhbHVlKVxyXG4gICAgICAgICkge1xyXG4gICAgICAgICAgY29sdW1uLnRob3VzYW5kU2VwYXJhdG9yID0gdmFsdWU7XHJcbiAgICAgICAgfVxyXG4gICAgICB9KTtcclxuICAgICAgdGhpcy50b3RhbHNGaWVsZHMuZm9yRWFjaCgoZmllbGQpID0+IHtcclxuICAgICAgICBpZiAob2xkVmFsdWUgPT09IG51bGwgfHwgb2xkVmFsdWUgPT0gZmllbGQudGhvdXNhbmRTZXBhcmF0b3IpIHtcclxuICAgICAgICAgIGZpZWxkLnRob3VzYW5kU2VwYXJhdG9yID0gdmFsdWU7XHJcbiAgICAgICAgfVxyXG4gICAgICB9KTtcclxuICAgIH0gZWxzZSBpZiAocHJvcE5hbWUgPT0gXCJkZWNpbWFsRGlnaXRzXCIpIHtcclxuICAgICAgdGhpcy5jb2x1bW5zLmZvckVhY2goKGNvbHVtbikgPT4ge1xyXG4gICAgICAgIGlmIChcclxuICAgICAgICAgIChjb2x1bW4gaW5zdGFuY2VvZiBTdGlOdW1iZXJCb3hDb2x1bW5JdGVtIHx8IGNvbHVtbiBpbnN0YW5jZW9mIFN0aUxhYmVsQ29sdW1uSXRlbSkgJiZcclxuICAgICAgICAgIChvbGRWYWx1ZSA9PT0gbnVsbCB8fCBjb2x1bW4uZGVjaW1hbERpZ2l0cyA9PSBvbGRWYWx1ZSlcclxuICAgICAgICApIHtcclxuICAgICAgICAgIGNvbHVtbi5kZWNpbWFsRGlnaXRzID0gdmFsdWU7XHJcbiAgICAgICAgfVxyXG4gICAgICB9KTtcclxuICAgICAgdGhpcy50b3RhbHNGaWVsZHMuZm9yRWFjaCgoZmllbGQpID0+IHtcclxuICAgICAgICBpZiAob2xkVmFsdWUgPT09IG51bGwgfHwgb2xkVmFsdWUgPT0gZmllbGQuZGVjaW1hbERpZ2l0cykge1xyXG4gICAgICAgICAgZmllbGQuZGVjaW1hbERpZ2l0cyA9IHZhbHVlO1xyXG4gICAgICAgIH1cclxuICAgICAgfSk7XHJcbiAgICB9XHJcbiAgfVxyXG4gIHB1YmxpYyBnZXRVc2VkRm9udHModXNlZEZvbnRzOiBTdGlVc2VkRm9udHNMaXN0KSB7XHJcbiAgICBzdXBlci5nZXRVc2VkRm9udHModXNlZEZvbnRzKTtcclxuICAgIHVzZWRGb250cy5hZGQodGhpcy5mb250LmZhbWlseSwgdGhpcy5hcnJheU9mU3R5bGVzVG9TdHJpbmcodGhpcy5mb250LnN0eWxlKSwgdGhpcy5mb250LnNpemUpO1xyXG4gICAgdXNlZEZvbnRzLmFkZChcclxuICAgICAgdGhpcy5kZXNjcmlwdGlvbi5mb250LmZhbWlseSxcclxuICAgICAgdGhpcy5hcnJheU9mU3R5bGVzVG9TdHJpbmcodGhpcy5kZXNjcmlwdGlvbi5mb250LnN0eWxlKSxcclxuICAgICAgdGhpcy5kZXNjcmlwdGlvbi5mb250LnNpemVcclxuICAgICk7XHJcbiAgfVxyXG4gIHByb3BlcnR5Q2hhbmdlZChwcm9wTmFtZTogc3RyaW5nKSB7XHJcbiAgICB0aGlzLmZpdFRhYmxlKCk7XHJcbiAgfVxyXG5cclxuICBnZXQgY29sdW1ucygpOiBTdGlDb2x1bW5JdGVtW10ge1xyXG4gICAgcmV0dXJuIHRoaXMuX2NvbHVtbnM7XHJcbiAgfVxyXG5cclxuICBnZXQgZVZhbHVlKCk6IHN0cmluZyB7XHJcbiAgICByZXR1cm4gdGhpcy50YWJsZUhlYWRlclRleHQ7XHJcbiAgfVxyXG5cclxuICBzZXQgZVZhbHVlKHZhbHVlOiBzdHJpbmcpIHtcclxuICAgIHRoaXMudGFibGVIZWFkZXJUZXh0ID0gdmFsdWU7XHJcbiAgfVxyXG5cclxuICBnZXQgZUZvbnQoKTogRm9udCB7XHJcbiAgICByZXR1cm4gdGhpcy5mb250O1xyXG4gIH1cclxuXHJcbiAgc2V0IGVGb250KHZhbHVlOiBGb250KSB7XHJcbiAgICB0aGlzLmZvbnQgPSB2YWx1ZTtcclxuICB9XHJcblxyXG4gIGdldCBlQ29sb3IoKTogQ29sb3Ige1xyXG4gICAgcmV0dXJuIHRoaXMudGFibGVIZWFkZXJDb2xvcjtcclxuICB9XHJcblxyXG4gIHNldCBlQ29sb3IodmFsdWU6IENvbG9yKSB7XHJcbiAgICB0aGlzLnRhYmxlSGVhZGVyQ29sb3IgPSB2YWx1ZTtcclxuICB9XHJcblxyXG4gIGdldCBlQmFja2dyb3VuZENvbG9yKCk6IENvbG9yIHtcclxuICAgIHJldHVybiB0aGlzLnRhYmxlSGVhZGVyQmFja2dyb3VuZENvbG9yO1xyXG4gIH1cclxuXHJcbiAgc2V0IGVCYWNrZ3JvdW5kQ29sb3IodmFsdWU6IENvbG9yKSB7XHJcbiAgICB0aGlzLnRhYmxlSGVhZGVyQmFja2dyb3VuZENvbG9yID0gdmFsdWU7XHJcbiAgfVxyXG4gIGhhdmVCYWNrZ291bmRDb2xvcigpOiBib29sZWFuIHtcclxuICAgIHJldHVybiB0cnVlO1xyXG4gIH1cclxuICBnZXQgZUNvbnRlbnRBbGlnbm1lbnQoKTogU3RpSG9yaXpvbnRhbEFsaWdubWVudCB7XHJcbiAgICByZXR1cm4gdGhpcy50YWJsZUhlYWRlckFsaWdubWVudDtcclxuICB9XHJcbiAgc2V0IGVDb250ZW50QWxpZ25tZW50KHZhbHVlOiBTdGlIb3Jpem9udGFsQWxpZ25tZW50KSB7XHJcbiAgICB0aGlzLnRhYmxlSGVhZGVyQWxpZ25tZW50ID0gdmFsdWU7XHJcbiAgfVxyXG4gIGhhdmVDb250ZW50QWxpZ25tZW50KCk6IGJvb2xlYW4ge1xyXG4gICAgcmV0dXJuIHRydWU7XHJcbiAgfVxyXG4gIGhhdmVWZXJ0aWNhbEFsaWdubWVudCgpOiBib29sZWFuIHtcclxuICAgIHJldHVybiBmYWxzZTtcclxuICB9XHJcblxyXG4gIGh0bWxTdHlsZSgpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIGAke3RoaXMuZUZvbnQuaHRtbFN0eWxlKCl9O2NvbG9yOiR7dGhpcy5lQ29sb3IudG9IdG1sQ29sb3IoKX07YDtcclxuICB9XHJcblxyXG4gIHVwZGF0ZVJvd0xhYmVsc0NvbnRlbnRFZGl0YWJsZSgpIHtcclxuICAgIHRoaXMucm93TGFiZWxzQ29udGVudEVkaXRhYmxlID0gW107XHJcbiAgICB0aGlzLnJvd0xhYmVscy5mb3JFYWNoKChsLCBpbmRleCkgPT4gdGhpcy5yb3dMYWJlbHNDb250ZW50RWRpdGFibGUucHVzaChuZXcgU3RpUm93TGFiZWwobCwgdGhpcywgaW5kZXgpKSk7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IHdpZHRoKHZhbHVlOiBudW1iZXIpIHtcclxuICAgIGxldCBuZWVkVG9GaXQgPSB0aGlzLmdlb21ldHJ5LndpZHRoICE9IHZhbHVlO1xyXG4gICAgdGhpcy5nZW9tZXRyeS53aWR0aCA9IHZhbHVlO1xyXG4gICAgaWYgKG5lZWRUb0ZpdCkge1xyXG4gICAgICB0aGlzLmZpdFRhYmxlKCk7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0IHdpZHRoKCk6IG51bWJlciB7XHJcbiAgICByZXR1cm4gdGhpcy5nZW9tZXRyeS53aWR0aDtcclxuICB9XHJcblxyXG4gIHByaXZhdGUgbmFtZUNoYW5nZWQob2xkTmFtZTogc3RyaW5nKSB7XHJcbiAgICB0aGlzLmNvbHVtbnMuZmlsdGVyKGMgPT4gYyBpbnN0YW5jZW9mIFN0aUxhYmVsQ29sdW1uSXRlbSkuZm9yRWFjaCgoY29sdW1uOiBTdGlMYWJlbENvbHVtbkl0ZW0pID0+IHtcclxuICAgICAgY29sdW1uLmV4cHJlc3Npb24gPSBjb2x1bW4uZXhwcmVzc2lvbiA/IGNvbHVtbi5leHByZXNzaW9uLnJlcGxhY2UobmV3IFJlZ0V4cChvbGROYW1lLCBcImdcIiksIHRoaXMubmFtZSkgOiBjb2x1bW4uZXhwcmVzc2lvbjtcclxuICAgIH0pO1xyXG5cclxuICAgIHRoaXMudG90YWxzRmllbGRzLmZvckVhY2goKHRvdGFsOiBTdGlUb3RhbHNGaWVsZEl0ZW0pID0+IHtcclxuICAgICAgdG90YWwuZXhwcmVzc2lvbiA9IHRvdGFsLmV4cHJlc3Npb24gPyB0b3RhbC5leHByZXNzaW9uLnJlcGxhY2UobmV3IFJlZ0V4cChvbGROYW1lLCBcImdcIiksIHRoaXMubmFtZSkgOiB0b3RhbC5leHByZXNzaW9uO1xyXG4gICAgfSk7XHJcbiAgfVxyXG5cclxuICBzYXZlVG9Kc29uT2JqZWN0KG9wdGlvbnM6IGFueSk6IFN0aUpzb24ge1xyXG4gICAgdGhpcy50YWJsZUhlYWRlckhlaWdodCA9IHRoaXMuZWxlbWVudD8ubmF0aXZlRWxlbWVudD8ub2Zmc2V0SGVpZ2h0ID8/IHRoaXMudGFibGVIZWFkZXJIZWlnaHQ7XHJcbiAgICB0aGlzLmNvbHVtbnM/LmZvckVhY2goKGNvbHVtbikgPT4ge1xyXG4gICAgICBpZiAoY29sdW1uW1wiY2VsbHNcIl0gJiYgY29sdW1uW1wiY2VsbHNcIl0ubGVuZ3RoICE9IHRoaXMucm93TGFiZWxzLmxlbmd0aCkge1xyXG4gICAgICAgIGNvbHVtbltcImNlbGxzXCJdLnNwbGljZSh0aGlzLnJvd0xhYmVscy5sZW5ndGgsIGNvbHVtbltcImNlbGxzXCJdLmxlbmd0aCk7XHJcbiAgICAgIH1cclxuICAgIH0pO1xyXG4gICAgbGV0IGpPYmplY3QgPSBzdXBlci5zYXZlVG9Kc29uT2JqZWN0KG9wdGlvbnMpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUpPYmplY3QoXCJMYWJlbFwiLCB0aGlzLmxhYmVsLnNhdmVUb0pzb25PYmplY3Qob3B0aW9ucykpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUpPYmplY3QoXCJEZXNjcmlwdGlvblwiLCB0aGlzLmRlc2NyaXB0aW9uLnNhdmVUb0pzb25PYmplY3Qob3B0aW9ucykpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUpPYmplY3QoXCJGb250XCIsIHRoaXMuZm9udC5zYXZlVG9Kc29uT2JqZWN0KG9wdGlvbnMpKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlKT2JqZWN0KFwiQm9yZGVyXCIsIHRoaXMuYm9yZGVyLnNhdmVUb0pzb25PYmplY3Qob3B0aW9ucykpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUpPYmplY3QoXCJHcmlkTGluZXNcIiwgdGhpcy5ncmlkTGluZXMuc2F2ZVRvSnNvbk9iamVjdChvcHRpb25zKSk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5Q29sb3IoXCJCYWNrZ3JvdW5kQ29sb3JcIiwgdGhpcy5iYWNrZ3JvdW5kQ29sb3IpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUJvb2woXCJBbHRlcm5hdGVSb3dDb2xvcnNcIiwgdGhpcy5hbHRlcm5hdGVSb3dDb2xvcnMpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUNvbG9yKFwiRXZlblJvd3NTdHlsZVwiLCB0aGlzLmV2ZW5Sb3dzU3R5bGUpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUNvbG9yKFwiRXZlblJvd3NUZXh0Q29sb3JcIiwgdGhpcy5ldmVuUm93c1RleHRDb2xvcik7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5Q29sb3IoXCJPZGRSb3dzU3R5bGVcIiwgdGhpcy5vZGRSb3dzU3R5bGUpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUNvbG9yKFwiT2RkUm93c1RleHRDb2xvclwiLCB0aGlzLm9kZFJvd3NUZXh0Q29sb3IpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eU51bWJlcihcIlRhYmxlSGVhZGVySGVpZ2h0XCIsIHRoaXMudGFibGVIZWFkZXJIZWlnaHQpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eVN0cmluZyhcIlRhYmxlSGVhZGVyVGV4dFwiLCB0aGlzLnRhYmxlSGVhZGVyVGV4dCk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5RW51bShcIlRhYmxlSGVhZGVyQWxpZ25tZW50XCIsIFN0aUhvcml6b250YWxBbGlnbm1lbnQsIHRoaXMudGFibGVIZWFkZXJBbGlnbm1lbnQpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUNvbG9yKFwiVGFibGVIZWFkZXJDb2xvclwiLCB0aGlzLnRhYmxlSGVhZGVyQ29sb3IpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUNvbG9yKFwiVGFibGVIZWFkZXJCYWNrZ3JvdW5kQ29sb3JcIiwgdGhpcy50YWJsZUhlYWRlckJhY2tncm91bmRDb2xvcik7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5Qm9vbChcIlNob3dSb3dMYWJlbHNcIiwgdGhpcy5zaG93Um93TGFiZWxzKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlBcnJheShcIlJvd0xhYmVsc1wiLCB0aGlzLnJvd0xhYmVscyk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5RW51bShcIlJvd0xhYmVsc0hvcml6b250YWxBbGlnbm1lbnRcIiwgU3RpSG9yaXpvbnRhbEFsaWdubWVudCwgdGhpcy5yb3dMYWJlbHNIb3Jpem9udGFsQWxpZ25tZW50KTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlDb2xvcihcIlJvd0hlYWRlcnNCYWNrZ3JvdW5kXCIsIHRoaXMucm93SGVhZGVyc0JhY2tncm91bmQpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUNvbG9yKFwiUm93SGVhZGVyc0NvbG9yXCIsIHRoaXMucm93SGVhZGVyc0NvbG9yKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlKT2JqZWN0KFwiUm93SGVhZGVyc0JvcmRlclwiLCB0aGlzLnJvd0hlYWRlcnNCb3JkZXIuc2F2ZVRvSnNvbk9iamVjdChvcHRpb25zKSk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5Sk9iamVjdChcIkNvbHVtbkhlYWRlcnNCb3JkZXJcIiwgdGhpcy5jb2x1bW5IZWFkZXJzQm9yZGVyLnNhdmVUb0pzb25PYmplY3Qob3B0aW9ucykpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUFycmF5KFwiQ29sdW1uc1wiLCB0aGlzLmNvbHVtbnMpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUJvb2woXCJVc2VUb3RhbHNcIiwgdGhpcy51c2VUb3RhbHMpO1xyXG4gICAgLy8gak9iamVjdC5hZGRQcm9wZXJ0eUJvb2woXCJEeW5hbWljUm93c1wiLCB0aGlzLmR5bmFtaWNSb3dzKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlCb29sKFwiVXNlV29yZFdyYXBcIiwgdGhpcy51c2VXb3JkV3JhcCk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5U3RyaW5nKFwiVG90YWxzUm93SGVhZGVyXCIsIHRoaXMudG90YWxzUm93SGVhZGVyKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlOdW1iZXIoXCJSb3dMYWJlbHNXaWR0aFwiLCB0aGlzLnJvd0xhYmVsc1dpZHRoKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlFbnVtKFxyXG4gICAgICBcIlRvdGFsc1Jvd0hlYWRlckhvcml6b250YWxBbGlnbm1lbnRcIixcclxuICAgICAgU3RpSG9yaXpvbnRhbEFsaWdubWVudCxcclxuICAgICAgdGhpcy50b3RhbHNSb3dIZWFkZXJIb3Jpem9udGFsQWxpZ25tZW50XHJcbiAgICApO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUVudW0oXHJcbiAgICAgIFwiVG90YWxzUm93SGVhZGVyVmVydGljYWxBbGlnbm1lbnRcIixcclxuICAgICAgU3RpVmVydGljYWxBbGlnbm1lbnQsXHJcbiAgICAgIHRoaXMudG90YWxzUm93SGVhZGVyVmVydGljYWxBbGlnbm1lbnRcclxuICAgICk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5Q29sb3IoXCJUb3RhbHNSb3dIZWFkZXJDb2xvclwiLCB0aGlzLnRvdGFsc1Jvd0hlYWRlckNvbG9yKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlOdW1iZXIoXCJUb3RhbHNWYWx1ZXNXaWR0aFwiLCB0aGlzLnRvdGFsc1ZhbHVlc1dpZHRoKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlOdW1iZXIoXCJUb3RhbHNIZWFkZXJzV2lkdGhcIiwgdGhpcy50b3RhbHNIZWFkZXJzV2lkdGgpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUFycmF5KFwiVG90YWxzRmllbGRzXCIsIHRoaXMudG90YWxzRmllbGRzKTtcclxuICAgIHJldHVybiBqT2JqZWN0O1xyXG4gIH1cclxuXHJcbiAgcHVibGljIGxvYWRGcm9tSnNvbk9iamVjdChqc29uOiBTdGlKc29uKSB7XHJcbiAgICB0aGlzLnN0b3BGaXQgPSB0cnVlO1xyXG4gICAgc3VwZXIubG9hZEZyb21Kc29uT2JqZWN0KGpzb24pO1xyXG4gICAgZm9yIChsZXQgcHJvcGVydHkgb2YganNvbi5wcm9wZXJ0aWVzKCkpIHtcclxuICAgICAgc3dpdGNoIChwcm9wZXJ0eS5uYW1lKSB7XHJcbiAgICAgICAgY2FzZSBcIkxhYmVsXCI6XHJcbiAgICAgICAgICB0aGlzLmxhYmVsID0gbmV3IFN0aUxhYmVsSXRlbSh0aGlzKTtcclxuICAgICAgICAgIHRoaXMubGFiZWwubG9hZEZyb21Kc29uT2JqZWN0KHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJEZXNjcmlwdGlvblwiOlxyXG4gICAgICAgICAgdGhpcy5kZXNjcmlwdGlvbiA9IG5ldyBTdGlUZXh0SXRlbSgpO1xyXG4gICAgICAgICAgdGhpcy5kZXNjcmlwdGlvbi5sb2FkRnJvbUpzb25PYmplY3QocHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkZvbnRcIjpcclxuICAgICAgICAgIHRoaXMuZm9udCA9IG5ldyBGb250KCk7XHJcbiAgICAgICAgICB0aGlzLmZvbnQubG9hZEZyb21Kc29uT2JqZWN0KHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJCb3JkZXJcIjpcclxuICAgICAgICAgIHRoaXMuYm9yZGVyID0gbmV3IFN0aUJvcmRlcigpO1xyXG4gICAgICAgICAgdGhpcy5ib3JkZXIubG9hZEZyb21Kc29uT2JqZWN0KHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJHcmlkTGluZXNcIjpcclxuICAgICAgICAgIHRoaXMuZ3JpZExpbmVzID0gbmV3IFN0aUlubmVyQm9yZGVyKCk7XHJcbiAgICAgICAgICB0aGlzLmdyaWRMaW5lcy5sb2FkRnJvbUpzb25PYmplY3QocHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkJhY2tncm91bmRDb2xvclwiOlxyXG4gICAgICAgICAgdGhpcy5iYWNrZ3JvdW5kQ29sb3IgPSBuZXcgQ29sb3IoKTtcclxuICAgICAgICAgIHRoaXMuYmFja2dyb3VuZENvbG9yLmRlc2VyaWFsaXplRnJvbVN0cmluZyhwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiQWx0ZXJuYXRlUm93Q29sb3JzXCI6XHJcbiAgICAgICAgICB0aGlzLmFsdGVybmF0ZVJvd0NvbG9ycyA9IHByb3BlcnR5LnZhbHVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkV2ZW5Sb3dzU3R5bGVcIjpcclxuICAgICAgICAgIHRoaXMuZXZlblJvd3NTdHlsZSA9IG5ldyBDb2xvcigpO1xyXG4gICAgICAgICAgdGhpcy5ldmVuUm93c1N0eWxlLmRlc2VyaWFsaXplRnJvbVN0cmluZyhwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiRXZlblJvd3NUZXh0Q29sb3JcIjpcclxuICAgICAgICAgIHRoaXMuZXZlblJvd3NUZXh0Q29sb3IgPSBuZXcgQ29sb3IoKTtcclxuICAgICAgICAgIHRoaXMuZXZlblJvd3NUZXh0Q29sb3IuZGVzZXJpYWxpemVGcm9tU3RyaW5nKHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJPZGRSb3dzU3R5bGVcIjpcclxuICAgICAgICAgIHRoaXMub2RkUm93c1N0eWxlID0gbmV3IENvbG9yKCk7XHJcbiAgICAgICAgICB0aGlzLm9kZFJvd3NTdHlsZS5kZXNlcmlhbGl6ZUZyb21TdHJpbmcocHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIk9kZFJvd3NUZXh0Q29sb3JcIjpcclxuICAgICAgICAgIHRoaXMub2RkUm93c1RleHRDb2xvciA9IG5ldyBDb2xvcigpO1xyXG4gICAgICAgICAgdGhpcy5vZGRSb3dzVGV4dENvbG9yLmRlc2VyaWFsaXplRnJvbVN0cmluZyhwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiVGFibGVIZWFkZXJUZXh0XCI6XHJcbiAgICAgICAgICB0aGlzLnRhYmxlSGVhZGVyVGV4dCA9IHByb3BlcnR5LnZhbHVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIlRhYmxlSGVhZGVyQWxpZ25tZW50XCI6XHJcbiAgICAgICAgICB0aGlzLnRhYmxlSGVhZGVyQWxpZ25tZW50ID0gRW51bS5wYXJzZShTdGlIb3Jpem9udGFsQWxpZ25tZW50LCBwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiVGFibGVIZWFkZXJDb2xvclwiOlxyXG4gICAgICAgICAgdGhpcy50YWJsZUhlYWRlckNvbG9yID0gbmV3IENvbG9yKCk7XHJcbiAgICAgICAgICB0aGlzLnRhYmxlSGVhZGVyQ29sb3IuZGVzZXJpYWxpemVGcm9tU3RyaW5nKHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJUYWJsZUhlYWRlckJhY2tncm91bmRDb2xvclwiOlxyXG4gICAgICAgICAgdGhpcy50YWJsZUhlYWRlckJhY2tncm91bmRDb2xvciA9IG5ldyBDb2xvcigpO1xyXG4gICAgICAgICAgdGhpcy50YWJsZUhlYWRlckJhY2tncm91bmRDb2xvci5kZXNlcmlhbGl6ZUZyb21TdHJpbmcocHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIlNob3dSb3dMYWJlbHNcIjpcclxuICAgICAgICAgIHRoaXMuc2hvd1Jvd0xhYmVscyA9IHByb3BlcnR5LnZhbHVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgLyogY2FzZSBcIkR5bmFtaWNSb3dzXCI6XHJcbiAgICAgICAgICB0aGlzLmR5bmFtaWNSb3dzID0gcHJvcGVydHkudmFsdWU7XHJcbiAgICAgICAgICBicmVhazsgKi9cclxuICAgICAgICBjYXNlIFwiUm93TGFiZWxzXCI6XHJcbiAgICAgICAgICB0aGlzLnJvd0xhYmVscyA9IFtdO1xyXG4gICAgICAgICAgKHByb3BlcnR5LnZhbHVlIGFzIFN0aUpzb24pLnByb3BlcnRpZXMoKS5mb3JFYWNoKChwKSA9PiB0aGlzLnJvd0xhYmVscy5wdXNoKHAudmFsdWUpKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJSb3dMYWJlbHNIb3Jpem9udGFsQWxpZ25tZW50XCI6XHJcbiAgICAgICAgICB0aGlzLnJvd0xhYmVsc0hvcml6b250YWxBbGlnbm1lbnQgPSBFbnVtLnBhcnNlKFN0aUhvcml6b250YWxBbGlnbm1lbnQsIHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJSb3dMYWJlbHNXaWR0aFwiOlxyXG4gICAgICAgICAgdGhpcy5yb3dMYWJlbHNXaWR0aCA9IHByb3BlcnR5LnZhbHVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIlJvd0hlYWRlcnNCYWNrZ3JvdW5kXCI6XHJcbiAgICAgICAgICB0aGlzLnJvd0hlYWRlcnNCYWNrZ3JvdW5kID0gbmV3IENvbG9yKCk7XHJcbiAgICAgICAgICB0aGlzLnJvd0hlYWRlcnNCYWNrZ3JvdW5kLmRlc2VyaWFsaXplRnJvbVN0cmluZyhwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiUm93SGVhZGVyc0NvbG9yXCI6XHJcbiAgICAgICAgICB0aGlzLnJvd0hlYWRlcnNDb2xvciA9IG5ldyBDb2xvcigpO1xyXG4gICAgICAgICAgdGhpcy5yb3dIZWFkZXJzQ29sb3IuZGVzZXJpYWxpemVGcm9tU3RyaW5nKHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJSb3dIZWFkZXJzQm9yZGVyXCI6XHJcbiAgICAgICAgICB0aGlzLnJvd0hlYWRlcnNCb3JkZXIgPSBuZXcgU3RpQm9yZGVyKCk7XHJcbiAgICAgICAgICB0aGlzLnJvd0hlYWRlcnNCb3JkZXIubG9hZEZyb21Kc29uT2JqZWN0KHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJDb2x1bW5IZWFkZXJzQm9yZGVyXCI6XHJcbiAgICAgICAgICB0aGlzLmNvbHVtbkhlYWRlcnNCb3JkZXIgPSBuZXcgU3RpQm9yZGVyKCk7XHJcbiAgICAgICAgICB0aGlzLmNvbHVtbkhlYWRlcnNCb3JkZXIubG9hZEZyb21Kc29uT2JqZWN0KHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJDb2x1bW5zXCI6XHJcbiAgICAgICAgY2FzZSBcIkNvbHVtbkNvbGxlY3Rpb25cIjpcclxuICAgICAgICAgIHRoaXMuY29sdW1ucyA9IFtdO1xyXG4gICAgICAgICAgZm9yIChsZXQgY29sSnNvbiBvZiBwcm9wZXJ0eS52YWx1ZS52YWx1ZSkge1xyXG4gICAgICAgICAgICBsZXQgdHlwZSA9IGNvbEpzb24ucHJvcGVydGllcygpLmZpbmQoKHApID0+IHAubmFtZSA9PSBcIlR5cGVcIikudmFsdWU7XHJcbiAgICAgICAgICAgIGxldCBjb2x1bW46IFN0aUNvbHVtbkl0ZW0gPSB0aGlzLmNyZWF0ZUNvbHVtbih0eXBlKTtcclxuICAgICAgICAgICAgY29sdW1uLmVQYXJlbnQgPSB0aGlzO1xyXG4gICAgICAgICAgICBjb2x1bW4ubG9hZEZyb21Kc29uT2JqZWN0KGNvbEpzb24pO1xyXG4gICAgICAgICAgICB0aGlzLmNvbHVtbnMucHVzaChjb2x1bW4pO1xyXG4gICAgICAgICAgfVxyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIlVzZVRvdGFsc1wiOlxyXG4gICAgICAgICAgdGhpcy51c2VUb3RhbHMgPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJVc2VXb3JkV3JhcFwiOlxyXG4gICAgICAgICAgdGhpcy51c2VXb3JkV3JhcCA9IHByb3BlcnR5LnZhbHVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIlRvdGFsc1Jvd0hlYWRlclwiOlxyXG4gICAgICAgICAgdGhpcy50b3RhbHNSb3dIZWFkZXIgPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJUb3RhbHNSb3dIZWFkZXJIb3Jpem9udGFsQWxpZ25tZW50XCI6XHJcbiAgICAgICAgICB0aGlzLnRvdGFsc1Jvd0hlYWRlckhvcml6b250YWxBbGlnbm1lbnQgPSBFbnVtLnBhcnNlKFN0aUhvcml6b250YWxBbGlnbm1lbnQsIHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJUb3RhbHNSb3dIZWFkZXJWZXJ0aWNhbEFsaWdubWVudFwiOlxyXG4gICAgICAgICAgdGhpcy50b3RhbHNSb3dIZWFkZXJWZXJ0aWNhbEFsaWdubWVudCA9IEVudW0ucGFyc2UoU3RpVmVydGljYWxBbGlnbm1lbnQsIHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJUb3RhbHNSb3dIZWFkZXJDb2xvclwiOlxyXG4gICAgICAgICAgdGhpcy50b3RhbHNSb3dIZWFkZXJDb2xvciA9IG5ldyBDb2xvcigpO1xyXG4gICAgICAgICAgdGhpcy50b3RhbHNSb3dIZWFkZXJDb2xvci5kZXNlcmlhbGl6ZUZyb21TdHJpbmcocHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIlRvdGFsc1ZhbHVlc1dpZHRoXCI6XHJcbiAgICAgICAgICB0aGlzLnRvdGFsc1ZhbHVlc1dpZHRoID0gcHJvcGVydHkudmFsdWU7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiVG90YWxzSGVhZGVyc1dpZHRoXCI6XHJcbiAgICAgICAgICB0aGlzLnRvdGFsc0hlYWRlcnNXaWR0aCA9IHByb3BlcnR5LnZhbHVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIlRvdGFsc0ZpZWxkc1wiOlxyXG4gICAgICAgICAgdGhpcy50b3RhbHNGaWVsZHMgPSBbXTtcclxuICAgICAgICAgIGZvciAobGV0IHRvdGFsSnNvbiBvZiBwcm9wZXJ0eS52YWx1ZS52YWx1ZSkge1xyXG4gICAgICAgICAgICBsZXQgdG90YWwgPSBuZXcgU3RpVG90YWxzRmllbGRJdGVtKFwiXCIsIFwiXCIsIHRoaXMuZm9ybSk7XHJcbiAgICAgICAgICAgIHRvdGFsLmxvYWRGcm9tSnNvbk9iamVjdCh0b3RhbEpzb24pO1xyXG4gICAgICAgICAgICB0aGlzLnRvdGFsc0ZpZWxkcy5wdXNoKHRvdGFsKTtcclxuICAgICAgICAgIH1cclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICB9XHJcbiAgICB9XHJcbiAgICB0aGlzLnN0b3BGaXQgPSBmYWxzZTtcclxuICAgIHRoaXMuZml0VGFibGUoKTtcclxuICB9XHJcbn1cclxuIl19