import { StiBorder } from "../properties/StiBorder";
import StiPadding from "../properties/StiPadding";
import { StiPen } from "../properties/StiPen";
import StiRectangleGeometry from "../properties/StiRectangleGeometry";
import Color from "../system/Color";
import { StiLabelAlignment } from "../system/enums";
import { StiFormElement } from "./base/StiFormElement";
import { StiAddressElement } from "./StiAddressElement";
import { StiBarcodeElement } from "./StiBarcodeElement";
import { StiButtonElement } from "./StiButtonElement";
import { StiCheckBoxElement } from "./StiCheckBoxElement";
import { StiComboBoxElement } from "./StiComboBoxElement";
import { StiDateTimeBoxElement } from "./StiDateTimeBoxElement";
import { StiImageElement } from "./StiImageElement";
import { StiLabelElement } from "./StiLabelElement";
import StiLineElement from "./StiLineElement";
import { StiListBoxElement } from "./StiListBoxElement";
import { StiMultipleSelectionElement } from "./StiMultipleSelectionElement";
import { StiNumberBoxElement } from "./StiNumberBoxElement";
import { StiPDFSignatureElement } from "./StiPDFSignatureElement";
import { StiSignatureElement } from "./StiSignatureElement";
import { StiSingleSelectionElement } from "./StiSingleSelectionElement";
import { StiTableElement } from "./StiTableElement";
import { StiTextBoxElement } from "./StiTextBoxElement";
import { StiTextElement } from "./StiTextElement";
import { StiLabelItem } from "./text/StiLabelItem";
import { StiTextItem } from "./text/StiTextItem";
export class StiPanelElement extends StiFormElement {
    constructor(form) {
        super();
        this.type = "PanelElement";
        this.description = new StiTextItem();
        this.Width = 0; //TODO
        this.Height = 0; //TODO
        this.backgroundColor = Color.transparent();
        this.border = new StiBorder(StiPen.dimGraySolid(), true, true, true, true);
        this.showBorderEditor = true;
        this.elements = new Array();
        this.form = form;
        this.geometry = new StiRectangleGeometry(150, 120);
        this.label = new StiLabelItem(this, "");
        this.padding = new StiPadding(0, 0, 0, 0, this);
        this.label.alignment = StiLabelAlignment.Top;
        this.geometry.minWidth = 150;
        this.geometry.minHeight = 90;
    }
    canUpdateProperty(propName) {
        return !(propName.indexOf("padding") >= 0 || propName == "label.alignment");
    }
    get contentAreaWidth() {
        if (this.label.alignment != StiLabelAlignment.Top) {
            return this.width - (this.label.value.length > 0 ? this.label.width : 0) - this.padding.right - this.padding.left;
        }
        else {
            return this.width - this.padding.right - this.padding.left;
        }
    }
    get contentAreaHeight() {
        if (this.label.alignment != StiLabelAlignment.Top) {
            return this.height - this.padding.top - this.padding.bottom;
        }
        else {
            if (this.element?.nativeElement) {
                if (this.element.nativeElement.offsetHeight > 0) {
                    return this.element.nativeElement.offsetHeight + this.padding.bottom;
                }
            }
            else {
                return this.height - this.padding.top - this.padding.bottom - 35;
            }
        }
    }
    getColumnWidth(columnsCount) {
        return Number((this.contentAreaWidth / columnsCount).toFixed(2));
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.description.font.family, this.arrayOfStylesToString(this.description.font.style), this.description.font.size);
    }
    get allElements() {
        let elements = [];
        this.getAllElements(elements);
        return elements;
    }
    getAllElements(elements) {
        this.elements.forEach((element) => {
            if (element instanceof StiPanelElement) {
                element.getAllElements(elements);
            }
            elements.push(element);
        });
    }
    saveToJsonObject(options) {
        if (this.element?.nativeElement) {
            if (this.label.alignment != StiLabelAlignment.Top) {
                this.Width = this.width - (this.label.value.length > 0 ? this.label.width + this.padding.left : 0);
                this.Height = this.height;
            }
            else {
                this.Width = this.width;
                if (this.element.nativeElement.offsetHeight > 0) {
                    this.Height = this.element.nativeElement.offsetHeight + this.padding.bottom;
                }
            }
        }
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyNumber("Width", this.Width);
        jObject.addPropertyNumber("Height", this.Height);
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyArray("Elements", this.elements);
        jObject.addPropertyJObject("Border", this.border.saveToJsonObject(options));
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "Width":
                    this.Width = property.value;
                    break;
                case "Height":
                    this.Height = property.value;
                    break;
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
                case "Elements":
                    this.elements = this.deserializeCollection(property.value);
                    break;
                case "Border":
                    this.border = new StiBorder();
                    this.border.loadFromJsonObject(property.value);
                    break;
            }
        }
    }
    createElementClass(type) {
        type = type.toLowerCase();
        if (type == "textelement" || type == "textelement") {
            return new StiTextElement();
        }
        else if (type == "text_boxelement" || type == "textboxelement") {
            return new StiTextBoxElement();
        }
        else if (type == "tableelement" || type == "tableelement") {
            return new StiTableElement(this.form);
        }
        else if (type == "single_selectionelement" || type == "singleselectionelement") {
            return new StiSingleSelectionElement();
        }
        else if (type == "signatureelement" || type == "signatureelement") {
            return new StiSignatureElement();
        }
        else if (type == "pdfsignatureelement" || type == "pdfsignatureelement") {
            return new StiPDFSignatureElement();
        }
        else if (type == "panelelement" || type == "panelelement") {
            return new StiPanelElement(this.form);
        }
        else if (type == "number_boxelement" || type == "numberboxelement") {
            return new StiNumberBoxElement();
        }
        else if (type == "multiple_selectionelement" || type == "multipleselectionelement") {
            return new StiMultipleSelectionElement();
        }
        else if (type == "list_boxelement" || type == "listboxelement") {
            return new StiListBoxElement();
        }
        else if (type == "lineelement" || type == "lineelement") {
            return new StiLineElement();
        }
        else if (type == "labelelement" || type == "labelelement") {
            return new StiLabelElement();
        }
        else if (type == "imageelement" || type == "imageelement") {
            return new StiImageElement();
        }
        else if (type == "datetime_boxelement" || type == "datetimeboxelement") {
            return new StiDateTimeBoxElement(this.form);
        }
        else if (type == "combo_boxelement" || type == "comboboxelement") {
            return new StiComboBoxElement();
        }
        else if (type == "check_boxelement" || type == "checkboxelement") {
            return new StiCheckBoxElement();
        }
        else if (type == "buttonelement" || type == "buttonelement") {
            return new StiButtonElement();
        }
        else if (type == "barcodeelement" || type == "barcodeelement") {
            return new StiBarcodeElement();
        }
        else if (type == "addresselement" || type == "addresselement") {
            return new StiAddressElement();
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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