import StiPadding from "../properties/StiPadding";
import StiRectangleGeometry from "../properties/StiRectangleGeometry";
import Color from "../system/Color";
import { Enum } from "../system/Enum";
import { StiPenStyle, StiVerticalAlignment } from "../system/enums";
import { StiFormElement } from "./base/StiFormElement";
import { StiTextItem } from "./text/StiTextItem";
export default class StiLineElement extends StiFormElement {
    constructor() {
        super();
        this.type = "LineElement";
        this.description = new StiTextItem();
        this.lineColor = Color.fromArgb(255, 192, 191, 192);
        this.verticalAlignment = StiVerticalAlignment.Center;
        this.style = StiPenStyle.Solid;
        this.lineThickness = 1;
        this.geometry = new StiRectangleGeometry(100, 20);
        this.padding = new StiPadding(0, 0, 0, 0);
    }
    canUpdateProperty(propName) {
        return !propName.startsWith("padding");
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyColor("LineColor", this.lineColor);
        jObject.addPropertyNumber("LineThickness", this.lineThickness);
        jObject.addPropertyEnum("VerticalAlignment", StiVerticalAlignment, this.verticalAlignment);
        jObject.addPropertyEnum("Style", StiPenStyle, this.style);
        return jObject;
    }
    toHtmlBorder() {
        return `${this.lineThickness}px ${this.getHtmlStyle()} ${this.lineColor.toHtmlColor()}`;
    }
    getHtmlStyle() {
        switch (this.style) {
            case StiPenStyle.Solid:
                return "solid";
            case StiPenStyle.Dash:
                return "dashed";
            case StiPenStyle.Dot:
                return "dotted";
        }
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "LineColor":
                    this.lineColor = new Color();
                    this.lineColor.deserializeFromString(property.value);
                    break;
                case "LineThickness":
                    this.lineThickness = property.value;
                    break;
                case "VerticalAlignment":
                    this.verticalAlignment = Enum.parse(StiVerticalAlignment, property.value);
                    break;
                case "Style":
                    this.style = Enum.parse(StiPenStyle, property.value);
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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