import { Subject } from "rxjs";
import { StiStaticHelperService } from "../services/sti-static-helper.service";
import Guid from "../system/Guid";
import StiJson from "../system/StiJson";
import { StiFormSettings } from "./settings/StiFormSettings";
import { StiBarcodeElement } from "./StiBarcodeElement";
import { StiCheckBoxElement } from "./StiCheckBoxElement";
import { StiComboBoxElement } from "./StiComboBoxElement";
import { StiDateTimeBoxElement } from "./StiDateTimeBoxElement";
import { StiFormPageElement } from "./StiFormPageElement";
import { StiImageElement } from "./StiImageElement";
import { StiLabelElement } from "./StiLabelElement";
import { StiListBoxElement } from "./StiListBoxElement";
import { StiMultipleSelectionElement } from "./StiMultipleSelectionElement";
import { StiNumberBoxElement } from "./StiNumberBoxElement";
import { StiSingleSelectionElement } from "./StiSingleSelectionElement";
import { StiTextBoxElement } from "./StiTextBoxElement";
import { StiCheckBoxColumnItem } from "./table/columns/StiCheckBoxColumnItem";
import { StiComboBoxColumnItem } from "./table/columns/StiComboBoxColumnItem";
import { StiLabelColumnItem } from "./table/columns/StiLabelColumnItem";
import { StiNumberBoxColumnItem } from "./table/columns/StiNumberBoxColumnItem";
import { StiRadioButtonColumnItem } from "./table/columns/StiRadioButtonColumnItem";
import { StiTextBoxColumnItem } from "./table/columns/StiTextBoxColumnItem";
import { StiAdditionalField } from "./StiAdditionalFieldItem";
import { StiNameService } from "../services/sti-name.service";
export class StiForm {
    get guid() {
        return this._guid;
    }
    get settings() {
        return this._settings;
    }
    set settings(value) {
        this._settings = value;
    }
    addField(name, value) {
        let field = new StiAdditionalField();
        field.key = name;
        field.value = value;
        this._additionalFormFields.push(field);
    }
    clearAdditionalFields() {
        this._additionalFormFields = [];
    }
    get additionalFormFields() {
        return this._additionalFormFields;
    }
    get allElements() {
        let elements = [];
        this.pages.forEach((page) => {
            elements.push(page);
            elements.push(page.allElements);
        });
        elements = elements.reduce((a, b) => a.concat(b), []);
        return elements;
    }
    get formName() {
        return this._formName;
    }
    set formName(value) {
        this._formName = value;
    }
    get reportVersion() {
        return this._reportVersion;
    }
    set reportVersion(value) {
        this._reportVersion = value;
    }
    get reportName() {
        return this._reportName;
    }
    set reportName(value) {
        this._reportName = value;
    }
    get reportGuid() {
        return this._reportGuid;
    }
    set reportGuid(value) {
        this._reportGuid = value;
    }
    get reportAlias() {
        return this._reportAlias;
    }
    set reportAlias(value) {
        this._reportAlias = value;
    }
    get reportCreated() {
        return this._reportCreated;
    }
    set reportCreated(value) {
        this._reportCreated = value;
    }
    get reportChanged() {
        return this._reportChanged;
    }
    set reportChanged(value) {
        this._reportChanged = value;
    }
    get reportImage() {
        return this._reportImage;
    }
    set reportImage(value) {
        this._reportImage = value;
    }
    get versionKey() {
        return this._versionKey;
    }
    set versionKey(value) {
        this._versionKey = value;
    }
    get userId() {
        return this._userId;
    }
    set userId(value) {
        this._userId = value;
    }
    constructor() {
        this.pages = [];
        this.attachedFiles = [];
        this.formEvents = new Subject();
        this._reportVersion = "";
        this._reportName = "";
        this._reportGuid = "";
        this._reportAlias = "";
        this._reportCreated = "";
        this._reportChanged = "";
        this._reportImage = "";
        this._versionKey = "";
        this._userId = "";
        this._formName = "Form";
        this._guid = Guid.newGuid().toString();
        this._settings = new StiFormSettings(this);
        this._additionalFormFields = new Array();
        let page = new StiFormPageElement(this);
        page.name = "Page";
        this.pages.push(page);
        this.reportCreated = StiStaticHelperService.dateToJsonDate(new Date());
    }
    createTestValues() {
        let jObject = new StiJson();
        jObject.addPropertyString("TextBox", "Hello");
        jObject.addPropertyNumberNotNull("NumberBox", 1);
        jObject.addPropertyBool("Table.Cell-0-0", false);
        jObject.addPropertyBool("Table.Cell-0-1", true);
        return jObject;
    }
    setFormValues(json) {
        let element;
        for (let property of json.properties()) {
            element = { name: property.name, value: property.value };
            this.fillElement(element);
        }
    }
    fillElement(element) {
        let elem;
        let name;
        let isTable = false;
        if (element.name.indexOf(".") != -1) {
            name = element.name.slice(0, element.name.indexOf("."));
            isTable = true;
        }
        else {
            name = element.name;
        }
        this.pages.forEach((page) => {
            elem = page.allElements.find((elem) => elem.name == name);
        });
        if (elem) {
            if (isTable) {
                let cell = element.name.slice(element.name.indexOf(".") + 1, element.name.length);
                this.setTableValue(elem, cell, element.value);
            }
            else {
                this.setValue(elem, element.value);
            }
        }
    }
    setValue(element, value) {
        if (element instanceof StiTextBoxElement) {
            element.text = value;
        }
        else if (element instanceof StiNumberBoxElement) {
            element.value = value;
        }
        else if (element instanceof StiComboBoxElement) {
            element.selectedOption = value;
        }
        else if (element instanceof StiListBoxElement) {
            element.selectedOptions = value;
        }
        else if (element instanceof StiSingleSelectionElement) {
            element.selectedOption = value;
        }
        else if (element instanceof StiMultipleSelectionElement) {
            element.selectedOptions = value;
        }
        else if (element instanceof StiCheckBoxElement) {
            element.isChecked = value;
        } /* else if (element instanceof StiSignatureElement) {
          return { name: element.name ?? element.guid, value: element.contentImage };
        }  */
        else if (element instanceof StiDateTimeBoxElement) {
            element.dateValue = value;
        }
        else if (element instanceof StiImageElement) {
            element.image = value;
        }
        else if (element instanceof StiBarcodeElement) {
            element.img = value;
        }
        else if (element instanceof StiLabelElement) {
            element.text.value = value;
        }
    }
    setTableValue(element, cellPath, value) {
        let column = cellPath.split("-")[1];
        let cell = cellPath.split("-")[2];
        let tableColumn = element.columns[column];
        if (tableColumn instanceof StiTextBoxColumnItem) {
            tableColumn.cells[cell].text = value;
        }
        else if (tableColumn instanceof StiNumberBoxColumnItem) {
            tableColumn.cells[cell].value = value;
        }
        else if (tableColumn instanceof StiComboBoxColumnItem) {
            tableColumn.cells[cell].selectedIndex = value;
        }
        else if (tableColumn instanceof StiCheckBoxColumnItem) {
            tableColumn.cells[cell].isChecked = value;
        }
        else if (tableColumn instanceof StiLabelColumnItem) {
            tableColumn.cells[cell] = value;
        }
        else if (tableColumn instanceof StiRadioButtonColumnItem) {
            tableColumn.cells[cell].isChecked = value;
        }
    }
    getElementByName(elementName) {
        let finded;
        this.pages.forEach((page) => {
            if (!finded) {
                finded = page.allElements.find((e) => e.name == elementName);
            }
        });
        return finded;
    }
    getElementByGuid(guid) {
        let finded;
        this.pages.forEach((page) => {
            if (!finded) {
                finded = page.allElements.find((e) => e.guid == guid);
            }
            if (page.guid == guid) {
                finded = page;
            }
        });
        return finded;
    }
    saveToJsonObject(options = {}) {
        let rootJsonObject = new StiJson("", null, false, options);
        rootJsonObject.addPropertyArray("Pages", this.pages);
        rootJsonObject.addPropertyJObject("Settings", this.settings.saveToJsonObject(options));
        rootJsonObject.addPropertyString("Guid", this.guid);
        rootJsonObject.addPropertyString("FormName", this.formName);
        rootJsonObject.addPropertyString("VersionKey", this.versionKey);
        rootJsonObject.addPropertyString("UserId", this.userId);
        rootJsonObject.addPropertyArray("AdditionalFields", this.additionalFormFields);
        return rootJsonObject;
    }
    saveToReportJsonObject(options = {}) {
        let formJson = this.saveToJsonObject(options);
        let root = new StiJson();
        let pages = new StiJson();
        let formContainer = new StiJson();
        formContainer.addPropertyString("Ident", "StiFormContainer");
        formContainer.addPropertyJObject("Content", formJson);
        pages.addPropertyJObject("0", formContainer);
        root.addPropertyString("ReportVersion", this.reportVersion);
        root.addPropertyString("ReportGuid", this.reportGuid);
        root.addPropertyString("ReportName", this.reportName);
        root.addPropertyString("ReportAlias", this.reportAlias);
        root.addPropertyString("ReportCreated", this.reportCreated);
        root.addPropertyString("ReportChanged", this.reportChanged);
        root.addPropertyString("ReportImage", this.reportImage);
        root.addPropertyJObject("Pages", pages);
        return root;
    }
    loadFormJsonString(text) {
        let jObject = new StiJson();
        jObject.deserialize(text);
        this.loadFromJson(jObject);
    }
    loadFromJson(jObject) {
        var key;
        for (let property of jObject.properties()) {
            if (property.name == "ReportVersion") {
                this.reportVersion = property.value;
            }
            else if (property.name == "ReportGuid") {
                this.reportGuid = property.value;
            }
            else if (property.name == "ReportName") {
                this.reportName = property.value;
            }
            else if (property.name == "ReportAlias") {
                this.reportAlias = property.value;
            }
            else if (property.name == "ReportCreated") {
                this.reportCreated = property.value;
            }
            else if (property.name == "ReportChanged") {
                this.reportChanged = property.value;
            }
            else if (property.name == "ReportImage") {
                this.reportImage = property.value;
            }
            else if (property.name == "Script" && property.value && property.value.length < 40) {
                key = property.value;
            }
        }
        try {
            let formContainer = jObject
                .properties()
                .find((p) => p.name == "Pages")
                .properties()[0]
                .properties();
            if (formContainer.find((p) => p.name == "Ident").value == "StiFormContainer") {
                jObject = formContainer.find((p) => p.name == "Content").value;
            }
        }
        catch { }
        for (let property of jObject.properties()) {
            if (property.name == "Pages") {
                this.pages = this.deserializePages(property.value);
            }
            else if (property.name == "Settings" || property.name == "FormSettings") {
                this._settings = new StiFormSettings(this);
                this._settings.loadFromJsonObject(property.value);
            }
            else if (property.name == "Guid") {
                this._guid = property.value;
            }
            else if (property.name == "FormName") {
                this._formName = property.value;
            }
            else if (property.name == "VersionKey") {
                this._versionKey = property.value;
            }
            else if (property.name == "UserId") {
                this._userId = property.value;
            }
            else if (property.name == "AdditionalFields") {
                this._additionalFormFields = this.deserializeFields(property.value);
            }
        }
        if (key && key.length > 0) {
            this._versionKey = key;
        }
        this.checkElementsName();
    }
    deserializePages(jObject) {
        let result = [];
        for (let property of jObject.properties()) {
            let page = new StiFormPageElement(this);
            page.loadFromJsonObject(property.value);
            result.push(page);
        }
        return result;
    }
    deserializeFields(jObject) {
        let result = [];
        for (let property of jObject.properties()) {
            let field = new StiAdditionalField();
            field.loadFromJsonObject(property.value);
            result.push(field);
        }
        return result;
    }
    updateCultureDependecies() {
        this.pages.forEach((page) => {
            page.allElements.forEach((element) => {
                if (element.type == "DateTime_BoxElement") {
                    element.updateDateValueString();
                }
            });
        });
    }
    updateToViewerMode() {
        this.pages.forEach((page) => {
            page.allElements.forEach((element) => {
                if (element["updateToViewerMode"]) {
                    element.updateToViewerMode();
                }
            });
        });
    }
    checkElementsName() {
        this.allElements.forEach(e => {
            if (e.name == null || e.name.length == 0) {
                e.name = StiNameService.getElementName2(e, this);
            }
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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