import { Component, EventEmitter, Input, Output } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "@angular/forms";
import * as i4 from "../sti-editable-content.component";
import * as i5 from "../sti-tooltip/sti-tooltip.directive";
export class StiSvgRadiobuttonComponent {
    constructor(model) {
        this.model = model;
        this.useCustomOption = false;
        this.buttonClick = new EventEmitter();
        this.isCurrentOption = false;
    }
    get selected() {
        return this.model.selectedComponent?.element == this.element;
    }
    get isMozila() {
        return this.model.getBrowserType() == "firefox" ? true : false;
    }
    get isSafari() {
        return this.model.getBrowserType() == "safari" ? true : false;
    }
    get backColor() {
        return this.element.backgroundColor.toHtmlColor();
    }
    get checkColor() {
        return this.element.checkColor.toHtmlColor();
    }
    get borderColor() {
        return this.element.borderColor.toHtmlColor();
    }
    get textStyle() {
        return this.element?.htmlStyle();
    }
    disableDrag(event) {
        this.model.canDrag = false;
    }
    changeState() {
        this.buttonClick.emit();
    }
    get needToFill() {
        return this.element.required && !this.element.value && this.model.hasEmptyReuiredFields;
    }
    getContent(innerText) {
        if (this.isCurrentOption) {
            this.element.selectedOption = innerText;
        }
        this.element["customOptionText"] = innerText;
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    getCharCode(event) {
        return null === event.which ? event.keyCode : !(0 === event.which || 0 === event.charCode) ? event.which : -1;
    }
    checkOption() {
        if (this.element.selectedOption == this.element.customOptionText) {
            this.isCurrentOption = true;
        }
    }
    disableEnter(event) {
        if (13 === this.getCharCode(event))
            event.preventDefault();
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiSvgRadiobuttonComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiSvgRadiobuttonComponent, selector: "sti-svg-radiobutton-component", inputs: { element: "element", id: "id", text: "text", state: "state", useCustomOption: "useCustomOption", tabIndex: "tabIndex" }, outputs: { buttonClick: "buttonClick" }, ngImport: i0, template: `
    <div
      class="custom-radio"
      *ngIf="!useCustomOption"
      (mousedown)="disableDrag($event)"
      (mouseup)="this.model.canDrag = true"
    >
      <input
        type="radio"
        name="radio +{{ element.name }}"
        id="{{ id }}"
        value=""
        [tabIndex]="tabIndex"
        [disabled]="element?.readOnly ? true : false"
        [required]="element?.required"
        [stiTooltip]="element?.tooltip"
        (click)="changeState()"
      />
      <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
        <circle
          class="box"
          cx="6"
          cy="6"
          r="5.5"
          [attr.fill]="backColor"
          [attr.stroke]="needToFill ? 'red' : borderColor"
        />
        <circle *ngIf="state" class="check" cx="6" cy="6" r="2.5" [attr.fill]="checkColor" />
      </svg>
      <sti-editable-content-component
        [style.display]="'flex'"
        [style.margin-left]="'5px'"
        [style.overflow]="'hidden'"
        [style.maxWidth]="'calc(100% - 17px)'"
        [eParent]="element"
        [editableContent]="text"
        [hideEmpty]="false"
        [active]="selected"
      ></sti-editable-content-component>
    </div>
    <div
      class="custom-radio other"
      *ngIf="useCustomOption"
      [style.width]="'100%'"
      [style.align-items]="'center'"
      (mousedown)="disableDrag($event)"
      (mouseup)="this.model.canDrag = true"
    >
      <input
        type="radio"
        name="radio +{{ element.name }}"
        id="{{ id }}"
        value=""
        [disabled]="element?.readOnly ? true : false"
        [required]="element?.required"
        [stiTooltip]="element?.tooltip"
        (mousedown)="changeState()"
      />
      <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
        <circle class="box" cx="6" cy="6" r="5.5" [attr.fill]="backColor" [attr.stroke]="borderColor" />
        <circle *ngIf="state" class="check" cx="6" cy="6" r="2.5" [attr.fill]="checkColor" />
      </svg>
      <div class="other-option-container" [style.maxWidth]="'calc(100% - 17px)'" [style]="textStyle">
        <span *ngIf="element?.prefix?.length > 0">
          {{ element?.prefix }}
        </span>
        <input
          type="text"
          [style.background-color]="backColor"
          [style.border-color]="borderColor"
          [style.maxWidth]="'100%'"
          [ngModel]="text"
          [tabIndex]="-1"
          (input)="getContent($event.target.value)"
          [style]="textStyle"
          (focus)="checkOption()"
          (blur)="isCurrentOption = false"
        />
        <span *ngIf="element?.suffix?.length > 0" [style.margin-left.px]="3">
          {{ element?.suffix }}
        </span>
      </div>
      <!-- <span
        for="{{ id }}"
        [attr.contenteditable]="true"
        [style.flex]="1"
        class="custom-option"
        [textContent]="text"
        [style.background-color]="backColor"
        [style.border-color]="borderColor"
        [style.-webkit-user-select]="isSafari ? 'text' : ''"
        (input)="!isMozila && !isSafari ? getContent($event.target.textContent) : ''"
        (blur)="isMozila || isSafari ? getContent($event.target.textContent) : ''"
        (keyup.enter)="isMozila || isSafari ? getContent($event.target.textContent) : ''"
        (keypress)="disableEnter($event)"
        [style]="textStyle"
        >{{ text }}</span
      > -->
    </div>
  `, isInline: true, styles: [".other-option-container{display:flex}.other-option-container span{align-self:center}input[type=radio]:hover+svg .box{stroke:#a3bde3!important;fill:#f3f9ff!important}input[type=radio]:active+svg .box{stroke:#3c77dd!important;fill:#d9ecff!important}input[type=radio]:disabled+svg .box{stroke:#bcbcbc!important;fill:#e6e6e6!important}input[type=text]{margin-left:5px;width:100%;outline:none;border:1px solid lightgray;padding:3px 5px}label,span{margin-left:5px}.box:hover:{stroke:#a3bde3!important}.custom-radio{width:100%;position:relative;align-items:center;display:flex}.custom-radio input[type=radio],.other input[type=radio]{position:absolute;width:14px;z-index:10;opacity:0;margin:0}.custom-option{border:1px solid lightgray;padding:3px 5px;z-index:11;white-space:nowrap;outline:none;overflow:hidden;scroll-behavior:smooth}.custom-option:hover{border-color:#a3bde3;cursor:text}.custom-option:focus{border-color:#a3bde3}\n"], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "component", type: i4.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "directive", type: i5.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiSvgRadiobuttonComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-svg-radiobutton-component", template: `
    <div
      class="custom-radio"
      *ngIf="!useCustomOption"
      (mousedown)="disableDrag($event)"
      (mouseup)="this.model.canDrag = true"
    >
      <input
        type="radio"
        name="radio +{{ element.name }}"
        id="{{ id }}"
        value=""
        [tabIndex]="tabIndex"
        [disabled]="element?.readOnly ? true : false"
        [required]="element?.required"
        [stiTooltip]="element?.tooltip"
        (click)="changeState()"
      />
      <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
        <circle
          class="box"
          cx="6"
          cy="6"
          r="5.5"
          [attr.fill]="backColor"
          [attr.stroke]="needToFill ? 'red' : borderColor"
        />
        <circle *ngIf="state" class="check" cx="6" cy="6" r="2.5" [attr.fill]="checkColor" />
      </svg>
      <sti-editable-content-component
        [style.display]="'flex'"
        [style.margin-left]="'5px'"
        [style.overflow]="'hidden'"
        [style.maxWidth]="'calc(100% - 17px)'"
        [eParent]="element"
        [editableContent]="text"
        [hideEmpty]="false"
        [active]="selected"
      ></sti-editable-content-component>
    </div>
    <div
      class="custom-radio other"
      *ngIf="useCustomOption"
      [style.width]="'100%'"
      [style.align-items]="'center'"
      (mousedown)="disableDrag($event)"
      (mouseup)="this.model.canDrag = true"
    >
      <input
        type="radio"
        name="radio +{{ element.name }}"
        id="{{ id }}"
        value=""
        [disabled]="element?.readOnly ? true : false"
        [required]="element?.required"
        [stiTooltip]="element?.tooltip"
        (mousedown)="changeState()"
      />
      <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
        <circle class="box" cx="6" cy="6" r="5.5" [attr.fill]="backColor" [attr.stroke]="borderColor" />
        <circle *ngIf="state" class="check" cx="6" cy="6" r="2.5" [attr.fill]="checkColor" />
      </svg>
      <div class="other-option-container" [style.maxWidth]="'calc(100% - 17px)'" [style]="textStyle">
        <span *ngIf="element?.prefix?.length > 0">
          {{ element?.prefix }}
        </span>
        <input
          type="text"
          [style.background-color]="backColor"
          [style.border-color]="borderColor"
          [style.maxWidth]="'100%'"
          [ngModel]="text"
          [tabIndex]="-1"
          (input)="getContent($event.target.value)"
          [style]="textStyle"
          (focus)="checkOption()"
          (blur)="isCurrentOption = false"
        />
        <span *ngIf="element?.suffix?.length > 0" [style.margin-left.px]="3">
          {{ element?.suffix }}
        </span>
      </div>
      <!-- <span
        for="{{ id }}"
        [attr.contenteditable]="true"
        [style.flex]="1"
        class="custom-option"
        [textContent]="text"
        [style.background-color]="backColor"
        [style.border-color]="borderColor"
        [style.-webkit-user-select]="isSafari ? 'text' : ''"
        (input)="!isMozila && !isSafari ? getContent($event.target.textContent) : ''"
        (blur)="isMozila || isSafari ? getContent($event.target.textContent) : ''"
        (keyup.enter)="isMozila || isSafari ? getContent($event.target.textContent) : ''"
        (keypress)="disableEnter($event)"
        [style]="textStyle"
        >{{ text }}</span
      > -->
    </div>
  `, styles: [".other-option-container{display:flex}.other-option-container span{align-self:center}input[type=radio]:hover+svg .box{stroke:#a3bde3!important;fill:#f3f9ff!important}input[type=radio]:active+svg .box{stroke:#3c77dd!important;fill:#d9ecff!important}input[type=radio]:disabled+svg .box{stroke:#bcbcbc!important;fill:#e6e6e6!important}input[type=text]{margin-left:5px;width:100%;outline:none;border:1px solid lightgray;padding:3px 5px}label,span{margin-left:5px}.box:hover:{stroke:#a3bde3!important}.custom-radio{width:100%;position:relative;align-items:center;display:flex}.custom-radio input[type=radio],.other input[type=radio]{position:absolute;width:14px;z-index:10;opacity:0;margin:0}.custom-option{border:1px solid lightgray;padding:3px 5px;z-index:11;white-space:nowrap;outline:none;overflow:hidden;scroll-behavior:smooth}.custom-option:hover{border-color:#a3bde3;cursor:text}.custom-option:focus{border-color:#a3bde3}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }], propDecorators: { element: [{
                type: Input
            }], id: [{
                type: Input
            }], text: [{
                type: Input
            }], state: [{
                type: Input
            }], useCustomOption: [{
                type: Input
            }], buttonClick: [{
                type: Output
            }], tabIndex: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3ZnLnJhZGlvYnV0dG9uLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtZm9ybXMvc3JjL2xpYi9jb21wb25lbnRzL3N2Zy5jb21wb25lbnRzL3N2Zy5yYWRpb2J1dHRvbi5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFNBQVMsRUFBRSxZQUFZLEVBQUUsS0FBSyxFQUFVLE1BQU0sRUFBRSxNQUFNLGVBQWUsQ0FBQzs7Ozs7OztBQXVML0UsTUFBTSxPQUFPLDBCQUEwQjtJQVNyQyxZQUFtQixLQUFzQjtRQUF0QixVQUFLLEdBQUwsS0FBSyxDQUFpQjtRQUpoQyxvQkFBZSxHQUFZLEtBQUssQ0FBQztRQUNoQyxnQkFBVyxHQUFHLElBQUksWUFBWSxFQUFFLENBQUM7UUFFcEMsb0JBQWUsR0FBWSxLQUFLLENBQUM7SUFDSSxDQUFDO0lBRTdDLElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsaUJBQWlCLEVBQUUsT0FBTyxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUM7SUFDL0QsQ0FBQztJQUNELElBQUksUUFBUTtRQUNWLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQyxjQUFjLEVBQUUsSUFBSSxTQUFTLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDO0lBQ2pFLENBQUM7SUFDRCxJQUFJLFFBQVE7UUFDVixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxFQUFFLElBQUksUUFBUSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQztJQUNoRSxDQUFDO0lBQ0QsSUFBSSxTQUFTO1FBQ1gsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLGVBQWUsQ0FBQyxXQUFXLEVBQUUsQ0FBQztJQUNwRCxDQUFDO0lBQ0QsSUFBSSxVQUFVO1FBQ1osT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxXQUFXLEVBQUUsQ0FBQztJQUMvQyxDQUFDO0lBQ0QsSUFBSSxXQUFXO1FBQ2IsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxXQUFXLEVBQUUsQ0FBQztJQUNoRCxDQUFDO0lBQ0QsSUFBSSxTQUFTO1FBQ1gsT0FBTyxJQUFJLENBQUMsT0FBTyxFQUFFLFNBQVMsRUFBRSxDQUFDO0lBQ25DLENBQUM7SUFDRCxXQUFXLENBQUMsS0FBSztRQUNmLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBQ0QsV0FBVztRQUNULElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDMUIsQ0FBQztJQUNELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsUUFBUSxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQztJQUMxRixDQUFDO0lBQ0QsVUFBVSxDQUFDLFNBQVM7UUFDbEIsSUFBSSxJQUFJLENBQUMsZUFBZSxFQUFFLENBQUM7WUFDekIsSUFBSSxDQUFDLE9BQU8sQ0FBQyxjQUFjLEdBQUcsU0FBUyxDQUFDO1FBQzFDLENBQUM7UUFDRCxJQUFJLENBQUMsT0FBTyxDQUFDLGtCQUFrQixDQUFDLEdBQUcsU0FBUyxDQUFDO1FBQzdDLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksRUFBRSxjQUFjLEVBQUUsQ0FBQyxDQUFDO0lBQ3ZELENBQUM7SUFDRCxXQUFXLENBQUMsS0FBSztRQUNmLE9BQU8sSUFBSSxLQUFLLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssS0FBSyxDQUFDLEtBQUssSUFBSSxDQUFDLEtBQUssS0FBSyxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNoSCxDQUFDO0lBQ0QsV0FBVztRQUNULElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxjQUFjLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO1lBQ2pFLElBQUksQ0FBQyxlQUFlLEdBQUcsSUFBSSxDQUFDO1FBQzlCLENBQUM7SUFDSCxDQUFDO0lBQ0QsWUFBWSxDQUFDLEtBQUs7UUFDaEIsSUFBSSxFQUFFLEtBQUssSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLENBQUM7WUFBRSxLQUFLLENBQUMsY0FBYyxFQUFFLENBQUM7SUFDN0QsQ0FBQztJQUNELFFBQVEsS0FBVSxDQUFDOytHQTNEUiwwQkFBMEI7bUdBQTFCLDBCQUEwQixnUEFoTDNCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0FtR1Q7OzRGQTZFVSwwQkFBMEI7a0JBbEx0QyxTQUFTOytCQUNFLCtCQUErQixZQUMvQjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBbUdUO29GQThFUSxPQUFPO3NCQUFmLEtBQUs7Z0JBQ0csRUFBRTtzQkFBVixLQUFLO2dCQUNHLElBQUk7c0JBQVosS0FBSztnQkFDRyxLQUFLO3NCQUFiLEtBQUs7Z0JBQ0csZUFBZTtzQkFBdkIsS0FBSztnQkFDSSxXQUFXO3NCQUFwQixNQUFNO2dCQUNFLFFBQVE7c0JBQWhCLEtBQUsiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIEV2ZW50RW1pdHRlciwgSW5wdXQsIE9uSW5pdCwgT3V0cHV0IH0gZnJvbSBcIkBhbmd1bGFyL2NvcmVcIjtcclxuaW1wb3J0IHsgU3RpTW9kZWxTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uL3NlcnZpY2VzL21vZGVsLnNlcnZpY2VcIjtcclxuXHJcbmltcG9ydCB7IFN0aVNpbmdsZVNlbGVjdGlvbkVsZW1lbnQgfSBmcm9tIFwiLi4vLi4vZWxlbWVudHMvU3RpU2luZ2xlU2VsZWN0aW9uRWxlbWVudFwiO1xyXG5cclxuQENvbXBvbmVudCh7XHJcbiAgc2VsZWN0b3I6IFwic3RpLXN2Zy1yYWRpb2J1dHRvbi1jb21wb25lbnRcIixcclxuICB0ZW1wbGF0ZTogYFxyXG4gICAgPGRpdlxyXG4gICAgICBjbGFzcz1cImN1c3RvbS1yYWRpb1wiXHJcbiAgICAgICpuZ0lmPVwiIXVzZUN1c3RvbU9wdGlvblwiXHJcbiAgICAgIChtb3VzZWRvd24pPVwiZGlzYWJsZURyYWcoJGV2ZW50KVwiXHJcbiAgICAgIChtb3VzZXVwKT1cInRoaXMubW9kZWwuY2FuRHJhZyA9IHRydWVcIlxyXG4gICAgPlxyXG4gICAgICA8aW5wdXRcclxuICAgICAgICB0eXBlPVwicmFkaW9cIlxyXG4gICAgICAgIG5hbWU9XCJyYWRpbyAre3sgZWxlbWVudC5uYW1lIH19XCJcclxuICAgICAgICBpZD1cInt7IGlkIH19XCJcclxuICAgICAgICB2YWx1ZT1cIlwiXHJcbiAgICAgICAgW3RhYkluZGV4XT1cInRhYkluZGV4XCJcclxuICAgICAgICBbZGlzYWJsZWRdPVwiZWxlbWVudD8ucmVhZE9ubHkgPyB0cnVlIDogZmFsc2VcIlxyXG4gICAgICAgIFtyZXF1aXJlZF09XCJlbGVtZW50Py5yZXF1aXJlZFwiXHJcbiAgICAgICAgW3N0aVRvb2x0aXBdPVwiZWxlbWVudD8udG9vbHRpcFwiXHJcbiAgICAgICAgKGNsaWNrKT1cImNoYW5nZVN0YXRlKClcIlxyXG4gICAgICAvPlxyXG4gICAgICA8c3ZnIHhtbG5zPVwiaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmdcIiB3aWR0aD1cIjEyXCIgaGVpZ2h0PVwiMTJcIiB2aWV3Qm94PVwiMCAwIDEyIDEyXCIgZmlsbD1cIm5vbmVcIj5cclxuICAgICAgICA8Y2lyY2xlXHJcbiAgICAgICAgICBjbGFzcz1cImJveFwiXHJcbiAgICAgICAgICBjeD1cIjZcIlxyXG4gICAgICAgICAgY3k9XCI2XCJcclxuICAgICAgICAgIHI9XCI1LjVcIlxyXG4gICAgICAgICAgW2F0dHIuZmlsbF09XCJiYWNrQ29sb3JcIlxyXG4gICAgICAgICAgW2F0dHIuc3Ryb2tlXT1cIm5lZWRUb0ZpbGwgPyAncmVkJyA6IGJvcmRlckNvbG9yXCJcclxuICAgICAgICAvPlxyXG4gICAgICAgIDxjaXJjbGUgKm5nSWY9XCJzdGF0ZVwiIGNsYXNzPVwiY2hlY2tcIiBjeD1cIjZcIiBjeT1cIjZcIiByPVwiMi41XCIgW2F0dHIuZmlsbF09XCJjaGVja0NvbG9yXCIgLz5cclxuICAgICAgPC9zdmc+XHJcbiAgICAgIDxzdGktZWRpdGFibGUtY29udGVudC1jb21wb25lbnRcclxuICAgICAgICBbc3R5bGUuZGlzcGxheV09XCInZmxleCdcIlxyXG4gICAgICAgIFtzdHlsZS5tYXJnaW4tbGVmdF09XCInNXB4J1wiXHJcbiAgICAgICAgW3N0eWxlLm92ZXJmbG93XT1cIidoaWRkZW4nXCJcclxuICAgICAgICBbc3R5bGUubWF4V2lkdGhdPVwiJ2NhbGMoMTAwJSAtIDE3cHgpJ1wiXHJcbiAgICAgICAgW2VQYXJlbnRdPVwiZWxlbWVudFwiXHJcbiAgICAgICAgW2VkaXRhYmxlQ29udGVudF09XCJ0ZXh0XCJcclxuICAgICAgICBbaGlkZUVtcHR5XT1cImZhbHNlXCJcclxuICAgICAgICBbYWN0aXZlXT1cInNlbGVjdGVkXCJcclxuICAgICAgPjwvc3RpLWVkaXRhYmxlLWNvbnRlbnQtY29tcG9uZW50PlxyXG4gICAgPC9kaXY+XHJcbiAgICA8ZGl2XHJcbiAgICAgIGNsYXNzPVwiY3VzdG9tLXJhZGlvIG90aGVyXCJcclxuICAgICAgKm5nSWY9XCJ1c2VDdXN0b21PcHRpb25cIlxyXG4gICAgICBbc3R5bGUud2lkdGhdPVwiJzEwMCUnXCJcclxuICAgICAgW3N0eWxlLmFsaWduLWl0ZW1zXT1cIidjZW50ZXInXCJcclxuICAgICAgKG1vdXNlZG93bik9XCJkaXNhYmxlRHJhZygkZXZlbnQpXCJcclxuICAgICAgKG1vdXNldXApPVwidGhpcy5tb2RlbC5jYW5EcmFnID0gdHJ1ZVwiXHJcbiAgICA+XHJcbiAgICAgIDxpbnB1dFxyXG4gICAgICAgIHR5cGU9XCJyYWRpb1wiXHJcbiAgICAgICAgbmFtZT1cInJhZGlvICt7eyBlbGVtZW50Lm5hbWUgfX1cIlxyXG4gICAgICAgIGlkPVwie3sgaWQgfX1cIlxyXG4gICAgICAgIHZhbHVlPVwiXCJcclxuICAgICAgICBbZGlzYWJsZWRdPVwiZWxlbWVudD8ucmVhZE9ubHkgPyB0cnVlIDogZmFsc2VcIlxyXG4gICAgICAgIFtyZXF1aXJlZF09XCJlbGVtZW50Py5yZXF1aXJlZFwiXHJcbiAgICAgICAgW3N0aVRvb2x0aXBdPVwiZWxlbWVudD8udG9vbHRpcFwiXHJcbiAgICAgICAgKG1vdXNlZG93bik9XCJjaGFuZ2VTdGF0ZSgpXCJcclxuICAgICAgLz5cclxuICAgICAgPHN2ZyB4bWxucz1cImh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnXCIgd2lkdGg9XCIxMlwiIGhlaWdodD1cIjEyXCIgdmlld0JveD1cIjAgMCAxMiAxMlwiIGZpbGw9XCJub25lXCI+XHJcbiAgICAgICAgPGNpcmNsZSBjbGFzcz1cImJveFwiIGN4PVwiNlwiIGN5PVwiNlwiIHI9XCI1LjVcIiBbYXR0ci5maWxsXT1cImJhY2tDb2xvclwiIFthdHRyLnN0cm9rZV09XCJib3JkZXJDb2xvclwiIC8+XHJcbiAgICAgICAgPGNpcmNsZSAqbmdJZj1cInN0YXRlXCIgY2xhc3M9XCJjaGVja1wiIGN4PVwiNlwiIGN5PVwiNlwiIHI9XCIyLjVcIiBbYXR0ci5maWxsXT1cImNoZWNrQ29sb3JcIiAvPlxyXG4gICAgICA8L3N2Zz5cclxuICAgICAgPGRpdiBjbGFzcz1cIm90aGVyLW9wdGlvbi1jb250YWluZXJcIiBbc3R5bGUubWF4V2lkdGhdPVwiJ2NhbGMoMTAwJSAtIDE3cHgpJ1wiIFtzdHlsZV09XCJ0ZXh0U3R5bGVcIj5cclxuICAgICAgICA8c3BhbiAqbmdJZj1cImVsZW1lbnQ/LnByZWZpeD8ubGVuZ3RoID4gMFwiPlxyXG4gICAgICAgICAge3sgZWxlbWVudD8ucHJlZml4IH19XHJcbiAgICAgICAgPC9zcGFuPlxyXG4gICAgICAgIDxpbnB1dFxyXG4gICAgICAgICAgdHlwZT1cInRleHRcIlxyXG4gICAgICAgICAgW3N0eWxlLmJhY2tncm91bmQtY29sb3JdPVwiYmFja0NvbG9yXCJcclxuICAgICAgICAgIFtzdHlsZS5ib3JkZXItY29sb3JdPVwiYm9yZGVyQ29sb3JcIlxyXG4gICAgICAgICAgW3N0eWxlLm1heFdpZHRoXT1cIicxMDAlJ1wiXHJcbiAgICAgICAgICBbbmdNb2RlbF09XCJ0ZXh0XCJcclxuICAgICAgICAgIFt0YWJJbmRleF09XCItMVwiXHJcbiAgICAgICAgICAoaW5wdXQpPVwiZ2V0Q29udGVudCgkZXZlbnQudGFyZ2V0LnZhbHVlKVwiXHJcbiAgICAgICAgICBbc3R5bGVdPVwidGV4dFN0eWxlXCJcclxuICAgICAgICAgIChmb2N1cyk9XCJjaGVja09wdGlvbigpXCJcclxuICAgICAgICAgIChibHVyKT1cImlzQ3VycmVudE9wdGlvbiA9IGZhbHNlXCJcclxuICAgICAgICAvPlxyXG4gICAgICAgIDxzcGFuICpuZ0lmPVwiZWxlbWVudD8uc3VmZml4Py5sZW5ndGggPiAwXCIgW3N0eWxlLm1hcmdpbi1sZWZ0LnB4XT1cIjNcIj5cclxuICAgICAgICAgIHt7IGVsZW1lbnQ/LnN1ZmZpeCB9fVxyXG4gICAgICAgIDwvc3Bhbj5cclxuICAgICAgPC9kaXY+XHJcbiAgICAgIDwhLS0gPHNwYW5cclxuICAgICAgICBmb3I9XCJ7eyBpZCB9fVwiXHJcbiAgICAgICAgW2F0dHIuY29udGVudGVkaXRhYmxlXT1cInRydWVcIlxyXG4gICAgICAgIFtzdHlsZS5mbGV4XT1cIjFcIlxyXG4gICAgICAgIGNsYXNzPVwiY3VzdG9tLW9wdGlvblwiXHJcbiAgICAgICAgW3RleHRDb250ZW50XT1cInRleHRcIlxyXG4gICAgICAgIFtzdHlsZS5iYWNrZ3JvdW5kLWNvbG9yXT1cImJhY2tDb2xvclwiXHJcbiAgICAgICAgW3N0eWxlLmJvcmRlci1jb2xvcl09XCJib3JkZXJDb2xvclwiXHJcbiAgICAgICAgW3N0eWxlLi13ZWJraXQtdXNlci1zZWxlY3RdPVwiaXNTYWZhcmkgPyAndGV4dCcgOiAnJ1wiXHJcbiAgICAgICAgKGlucHV0KT1cIiFpc01vemlsYSAmJiAhaXNTYWZhcmkgPyBnZXRDb250ZW50KCRldmVudC50YXJnZXQudGV4dENvbnRlbnQpIDogJydcIlxyXG4gICAgICAgIChibHVyKT1cImlzTW96aWxhIHx8IGlzU2FmYXJpID8gZ2V0Q29udGVudCgkZXZlbnQudGFyZ2V0LnRleHRDb250ZW50KSA6ICcnXCJcclxuICAgICAgICAoa2V5dXAuZW50ZXIpPVwiaXNNb3ppbGEgfHwgaXNTYWZhcmkgPyBnZXRDb250ZW50KCRldmVudC50YXJnZXQudGV4dENvbnRlbnQpIDogJydcIlxyXG4gICAgICAgIChrZXlwcmVzcyk9XCJkaXNhYmxlRW50ZXIoJGV2ZW50KVwiXHJcbiAgICAgICAgW3N0eWxlXT1cInRleHRTdHlsZVwiXHJcbiAgICAgICAgPnt7IHRleHQgfX08L3NwYW5cclxuICAgICAgPiAtLT5cclxuICAgIDwvZGl2PlxyXG4gIGAsXHJcbiAgc3R5bGVzOiBbXHJcbiAgICBgXHJcbiAgICAgIC5vdGhlci1vcHRpb24tY29udGFpbmVyIHtcclxuICAgICAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgICB9XHJcbiAgICAgIC5vdGhlci1vcHRpb24tY29udGFpbmVyIHNwYW4ge1xyXG4gICAgICAgIGFsaWduLXNlbGY6IGNlbnRlcjtcclxuICAgICAgfVxyXG4gICAgICBpbnB1dFt0eXBlPVwicmFkaW9cIl06aG92ZXIgKyBzdmcgLmJveCB7XHJcbiAgICAgICAgc3Ryb2tlOiByZ2IoMTYzLCAxODksIDIyNykgIWltcG9ydGFudDtcclxuICAgICAgICBmaWxsOiByZ2IoMjQzLCAyNDksIDI1NSkgIWltcG9ydGFudDtcclxuICAgICAgfVxyXG4gICAgICBpbnB1dFt0eXBlPVwicmFkaW9cIl06YWN0aXZlICsgc3ZnIC5ib3gge1xyXG4gICAgICAgIHN0cm9rZTogcmdiKDYwLCAxMTksIDIyMSkgIWltcG9ydGFudDtcclxuICAgICAgICBmaWxsOiByZ2IoMjE3LCAyMzYsIDI1NSkgIWltcG9ydGFudDtcclxuICAgICAgfVxyXG4gICAgICBpbnB1dFt0eXBlPVwicmFkaW9cIl06ZGlzYWJsZWQgKyBzdmcgLmJveCB7XHJcbiAgICAgICAgc3Ryb2tlOiByZ2IoMTg4LCAxODgsIDE4OCkgIWltcG9ydGFudDtcclxuICAgICAgICBmaWxsOiByZ2IoMjMwLCAyMzAsIDIzMCkgIWltcG9ydGFudDtcclxuICAgICAgfVxyXG4gICAgICBpbnB1dFt0eXBlPVwidGV4dFwiXSB7XHJcbiAgICAgICAgbWFyZ2luLWxlZnQ6IDVweDtcclxuICAgICAgICB3aWR0aDogMTAwJTtcclxuICAgICAgICBvdXRsaW5lOiBub25lO1xyXG4gICAgICAgIGJvcmRlcjogMXB4IHNvbGlkIGxpZ2h0Z3JheTtcclxuICAgICAgICBwYWRkaW5nOiAzcHggNXB4O1xyXG4gICAgICB9XHJcbiAgICAgIGxhYmVsIHtcclxuICAgICAgICBtYXJnaW4tbGVmdDogNXB4O1xyXG4gICAgICB9XHJcbiAgICAgIHNwYW4ge1xyXG4gICAgICAgIG1hcmdpbi1sZWZ0OiA1cHg7XHJcbiAgICAgIH1cclxuXHJcbiAgICAgIC5ib3g6aG92ZXI6IHtcclxuICAgICAgICBzdHJva2U6IHJnYigxNjMsIDE4OSwgMjI3KSAhaW1wb3J0YW50O1xyXG4gICAgICB9XHJcbiAgICAgIC5jdXN0b20tcmFkaW8ge1xyXG4gICAgICAgIHdpZHRoOiAxMDAlO1xyXG4gICAgICAgIHBvc2l0aW9uOiByZWxhdGl2ZTtcclxuICAgICAgICBhbGlnbi1pdGVtczogY2VudGVyO1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgIH1cclxuICAgICAgLmN1c3RvbS1yYWRpbyBpbnB1dFt0eXBlPVwicmFkaW9cIl0ge1xyXG4gICAgICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuICAgICAgICB3aWR0aDogMTRweDtcclxuICAgICAgICB6LWluZGV4OiAxMDtcclxuICAgICAgICBvcGFjaXR5OiAwO1xyXG4gICAgICAgIG1hcmdpbjogMDtcclxuICAgICAgfVxyXG4gICAgICAub3RoZXIgaW5wdXRbdHlwZT1cInJhZGlvXCJdIHtcclxuICAgICAgICBwb3NpdGlvbjogYWJzb2x1dGU7XHJcbiAgICAgICAgd2lkdGg6IDE0cHg7XHJcbiAgICAgICAgei1pbmRleDogMTA7XHJcbiAgICAgICAgb3BhY2l0eTogMDtcclxuICAgICAgICBtYXJnaW46IDA7XHJcbiAgICAgIH1cclxuICAgICAgLmN1c3RvbS1vcHRpb24ge1xyXG4gICAgICAgIGJvcmRlcjogMXB4IHNvbGlkIGxpZ2h0Z3JheTtcclxuICAgICAgICBwYWRkaW5nOiAzcHggNXB4O1xyXG4gICAgICAgIHotaW5kZXg6IDExO1xyXG4gICAgICAgIHdoaXRlLXNwYWNlOiBub3dyYXA7XHJcbiAgICAgICAgb3V0bGluZTogbm9uZTtcclxuICAgICAgICBvdmVyZmxvdzogaGlkZGVuO1xyXG4gICAgICAgIHNjcm9sbC1iZWhhdmlvcjogc21vb3RoO1xyXG4gICAgICB9XHJcbiAgICAgIC5jdXN0b20tb3B0aW9uOmhvdmVyIHtcclxuICAgICAgICBib3JkZXItY29sb3I6IHJnYigxNjMsIDE4OSwgMjI3KTtcclxuICAgICAgICBjdXJzb3I6IHRleHQ7XHJcbiAgICAgIH1cclxuICAgICAgLmN1c3RvbS1vcHRpb246Zm9jdXMge1xyXG4gICAgICAgIGJvcmRlci1jb2xvcjogcmdiKDE2MywgMTg5LCAyMjcpO1xyXG4gICAgICB9XHJcbiAgICBgLFxyXG4gIF0sXHJcbn0pXHJcbmV4cG9ydCBjbGFzcyBTdGlTdmdSYWRpb2J1dHRvbkNvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCB7XHJcbiAgQElucHV0KCkgZWxlbWVudDogU3RpU2luZ2xlU2VsZWN0aW9uRWxlbWVudDtcclxuICBASW5wdXQoKSBpZDogc3RyaW5nO1xyXG4gIEBJbnB1dCgpIHRleHQ6IHN0cmluZztcclxuICBASW5wdXQoKSBzdGF0ZTogYm9vbGVhbjtcclxuICBASW5wdXQoKSB1c2VDdXN0b21PcHRpb246IGJvb2xlYW4gPSBmYWxzZTtcclxuICBAT3V0cHV0KCkgYnV0dG9uQ2xpY2sgPSBuZXcgRXZlbnRFbWl0dGVyKCk7XHJcbiAgQElucHV0KCkgdGFiSW5kZXg6IG51bWJlcjtcclxuICBwdWJsaWMgaXNDdXJyZW50T3B0aW9uOiBib29sZWFuID0gZmFsc2U7XHJcbiAgY29uc3RydWN0b3IocHVibGljIG1vZGVsOiBTdGlNb2RlbFNlcnZpY2UpIHt9XHJcblxyXG4gIHB1YmxpYyBnZXQgc2VsZWN0ZWQoKTogYm9vbGVhbiB7XHJcbiAgICByZXR1cm4gdGhpcy5tb2RlbC5zZWxlY3RlZENvbXBvbmVudD8uZWxlbWVudCA9PSB0aGlzLmVsZW1lbnQ7XHJcbiAgfVxyXG4gIGdldCBpc01vemlsYSgpOiBib29sZWFuIHtcclxuICAgIHJldHVybiB0aGlzLm1vZGVsLmdldEJyb3dzZXJUeXBlKCkgPT0gXCJmaXJlZm94XCIgPyB0cnVlIDogZmFsc2U7XHJcbiAgfVxyXG4gIGdldCBpc1NhZmFyaSgpOiBib29sZWFuIHtcclxuICAgIHJldHVybiB0aGlzLm1vZGVsLmdldEJyb3dzZXJUeXBlKCkgPT0gXCJzYWZhcmlcIiA/IHRydWUgOiBmYWxzZTtcclxuICB9XHJcbiAgZ2V0IGJhY2tDb2xvcigpIHtcclxuICAgIHJldHVybiB0aGlzLmVsZW1lbnQuYmFja2dyb3VuZENvbG9yLnRvSHRtbENvbG9yKCk7XHJcbiAgfVxyXG4gIGdldCBjaGVja0NvbG9yKCkge1xyXG4gICAgcmV0dXJuIHRoaXMuZWxlbWVudC5jaGVja0NvbG9yLnRvSHRtbENvbG9yKCk7XHJcbiAgfVxyXG4gIGdldCBib3JkZXJDb2xvcigpIHtcclxuICAgIHJldHVybiB0aGlzLmVsZW1lbnQuYm9yZGVyQ29sb3IudG9IdG1sQ29sb3IoKTtcclxuICB9XHJcbiAgZ2V0IHRleHRTdHlsZSgpIHtcclxuICAgIHJldHVybiB0aGlzLmVsZW1lbnQ/Lmh0bWxTdHlsZSgpO1xyXG4gIH1cclxuICBkaXNhYmxlRHJhZyhldmVudCkge1xyXG4gICAgdGhpcy5tb2RlbC5jYW5EcmFnID0gZmFsc2U7XHJcbiAgfVxyXG4gIGNoYW5nZVN0YXRlKCkge1xyXG4gICAgdGhpcy5idXR0b25DbGljay5lbWl0KCk7XHJcbiAgfVxyXG4gIHB1YmxpYyBnZXQgbmVlZFRvRmlsbCgpIHtcclxuICAgIHJldHVybiB0aGlzLmVsZW1lbnQucmVxdWlyZWQgJiYgIXRoaXMuZWxlbWVudC52YWx1ZSAmJiB0aGlzLm1vZGVsLmhhc0VtcHR5UmV1aXJlZEZpZWxkcztcclxuICB9XHJcbiAgZ2V0Q29udGVudChpbm5lclRleHQpIHtcclxuICAgIGlmICh0aGlzLmlzQ3VycmVudE9wdGlvbikge1xyXG4gICAgICB0aGlzLmVsZW1lbnQuc2VsZWN0ZWRPcHRpb24gPSBpbm5lclRleHQ7XHJcbiAgICB9XHJcbiAgICB0aGlzLmVsZW1lbnRbXCJjdXN0b21PcHRpb25UZXh0XCJdID0gaW5uZXJUZXh0O1xyXG4gICAgdGhpcy5tb2RlbC5mb3JtRXZlbnRzLm5leHQoeyBuYW1lOiBcIlZhbHVlQ2hhbmdlZFwiIH0pO1xyXG4gIH1cclxuICBnZXRDaGFyQ29kZShldmVudCkge1xyXG4gICAgcmV0dXJuIG51bGwgPT09IGV2ZW50LndoaWNoID8gZXZlbnQua2V5Q29kZSA6ICEoMCA9PT0gZXZlbnQud2hpY2ggfHwgMCA9PT0gZXZlbnQuY2hhckNvZGUpID8gZXZlbnQud2hpY2ggOiAtMTtcclxuICB9XHJcbiAgY2hlY2tPcHRpb24oKSB7XHJcbiAgICBpZiAodGhpcy5lbGVtZW50LnNlbGVjdGVkT3B0aW9uID09IHRoaXMuZWxlbWVudC5jdXN0b21PcHRpb25UZXh0KSB7XHJcbiAgICAgIHRoaXMuaXNDdXJyZW50T3B0aW9uID0gdHJ1ZTtcclxuICAgIH1cclxuICB9XHJcbiAgZGlzYWJsZUVudGVyKGV2ZW50KSB7XHJcbiAgICBpZiAoMTMgPT09IHRoaXMuZ2V0Q2hhckNvZGUoZXZlbnQpKSBldmVudC5wcmV2ZW50RGVmYXVsdCgpO1xyXG4gIH1cclxuICBuZ09uSW5pdCgpOiB2b2lkIHt9XHJcbn1cclxuIl19