import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-localization.service";
import * as i3 from "../../services/sti-user-service";
export class StiTrialTimerWindowComponent {
    isRusLocalization() {
        if (this.loc.currentLocalization?.cultureName?.toLowerCase() == "ru") {
            return true;
        }
        else {
            return false;
        }
    }
    upgradeClick() {
        window.open("https://www.stimulsoft.com/en/online-store#embedded/forms/web", "_blank");
    }
    getRemainingDays() {
        let user = this.userService?.currentUser;
        if (!user || user?.days <= 0) {
            return "0";
        }
        let today = new Date();
        let created = new Date(user.created);
        let oneDay = 24 * 60 * 60 * 1000;
        let differenceInTime = today.getTime() - created.getTime();
        let diffDays = user?.days - differenceInTime / oneDay;
        return Math.trunc(Math.max(0, diffDays)).toString();
    }
    constructor(model, loc, userService) {
        this.model = model;
        this.loc = loc;
        this.userService = userService;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTrialTimerWindowComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }, { token: i3.StiUserService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiTrialTimerWindowComponent, selector: "sti-trial-timer-window", ngImport: i0, template: `<div class="trial-timer-window">
    <div class="trial-timer-window-navbar">
      <span [style.flex]="1">{{ loc.get2("Permissions", "ItemForms") }}</span>
      <div
        class="close-button {{ getRemainingDays() == '0' ? 'disabled' : '' }}"
        (click)="model.showTrialTimerWindow = false"
      >
        <img [src]="model.getImage('images.Other.CloseForm.png')" />
      </div>
    </div>
    <div class="trial-timer-window-content">
      <div class="trial-timer-window-interface">
        <div class="trial-timer-image">
          <img
            [style.width.px]="isRusLocalization() ? 239 : 197"
            [src]="
              isRusLocalization()
                ? model.getImage('images.Other.TrialDaysLeft_Ru.png')
                : model.getImage('images.Other.TrialDaysLeft_En.png')
            "
          />
          <div
            class="timer-remaining-days"
            [style.left]="isRusLocalization() ? 'calc(50% - 93px)' : 'calc(50% - 72px)'"
          >
            {{ getRemainingDays() }}
          </div>
        </div>
        <div class="trial-timer-warnings">
          <span class="blue description">{{
            loc.get2("Notices", "YourTrialWillExpire").replace("{0}", getRemainingDays())
          }}</span>
          <span class="lightgray description">{{ loc.get2("Notices", "ActivationTrialExpired") }}</span>
        </div>
      </div>
      <div class="trial-timer-window-navigation">
        <div
          class="button gray {{ getRemainingDays() == '0' ? 'disabled' : '' }}"
          (click)="model.showTrialTimerWindow = false"
        >
          <span>{{ "Continue" }}</span>
        </div>
        <div class="button navy" (click)="upgradeClick()">
          <span>{{ "Upgrade" }}</span>
        </div>
      </div>
    </div>
  </div>`, isInline: true, styles: [".disabled{opacity:.5;pointer-events:none}.gray{background:#ddd;border:1px solid #dddddd;color:#444}.gray:hover{background:#d5d5d5;border:1px solid #d5d5d5}.navy{background:#19478a;border:1px solid #19478a;color:#fff}.navy:hover{background:#3b629b;border:1px solid #3b629b}.trial-timer-window-navigation{display:flex;align-items:center;justify-content:center;margin-top:10px}.button{width:150px;height:32px;font-size:14px;font-family:Arial;display:flex;align-items:center;justify-content:center;margin:10px;border-radius:3px;-webkit-user-select:none}.blue{font-size:16px;color:#19478a}.lightgray{font-size:14px;color:#888}.trial-timer-warnings{display:flex;flex-direction:column;justify-content:center;align-items:center}.description{padding:10px 25px;font-family:Arial}.timer-remaining-days{position:absolute;display:inline-block;color:#76a797;font-family:Arial;font-size:30px;text-align:center;width:50px;top:calc(50% - 13px);left:calc(50% - 72px)}.trial-timer-window-interface{display:flex;flex-direction:column;justify-content:center;align-items:center}.trial-timer-image{position:relative;margin-top:20px}.trial-timer-image img{height:112px;width:197px}.trial-timer-window{background-color:var(--back-color);position:absolute;left:calc(50% - 275px);top:calc(50% - 176px);z-index:999;width:550px;height:352px;overflow:hidden;-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d;border:1px solid rgb(25,71,138);color:var(--text-color);font-size:13px;border-radius:5px;font-family:Arial;-webkit-user-select:none}.trial-timer-window-navbar{display:flex;height:30px;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;-webkit-user-select:none;color:#fff;align-items:center}.trial-timer-window-navbar span{font-size:13px}.close-button{height:30px;width:30px;border-radius:3px;display:flex;align-items:center;justify-content:center}span{margin-left:5px;font-size:12px}.close-button:hover{background-color:#dadada}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}\n"] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTrialTimerWindowComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-trial-timer-window", template: `<div class="trial-timer-window">
    <div class="trial-timer-window-navbar">
      <span [style.flex]="1">{{ loc.get2("Permissions", "ItemForms") }}</span>
      <div
        class="close-button {{ getRemainingDays() == '0' ? 'disabled' : '' }}"
        (click)="model.showTrialTimerWindow = false"
      >
        <img [src]="model.getImage('images.Other.CloseForm.png')" />
      </div>
    </div>
    <div class="trial-timer-window-content">
      <div class="trial-timer-window-interface">
        <div class="trial-timer-image">
          <img
            [style.width.px]="isRusLocalization() ? 239 : 197"
            [src]="
              isRusLocalization()
                ? model.getImage('images.Other.TrialDaysLeft_Ru.png')
                : model.getImage('images.Other.TrialDaysLeft_En.png')
            "
          />
          <div
            class="timer-remaining-days"
            [style.left]="isRusLocalization() ? 'calc(50% - 93px)' : 'calc(50% - 72px)'"
          >
            {{ getRemainingDays() }}
          </div>
        </div>
        <div class="trial-timer-warnings">
          <span class="blue description">{{
            loc.get2("Notices", "YourTrialWillExpire").replace("{0}", getRemainingDays())
          }}</span>
          <span class="lightgray description">{{ loc.get2("Notices", "ActivationTrialExpired") }}</span>
        </div>
      </div>
      <div class="trial-timer-window-navigation">
        <div
          class="button gray {{ getRemainingDays() == '0' ? 'disabled' : '' }}"
          (click)="model.showTrialTimerWindow = false"
        >
          <span>{{ "Continue" }}</span>
        </div>
        <div class="button navy" (click)="upgradeClick()">
          <span>{{ "Upgrade" }}</span>
        </div>
      </div>
    </div>
  </div>`, styles: [".disabled{opacity:.5;pointer-events:none}.gray{background:#ddd;border:1px solid #dddddd;color:#444}.gray:hover{background:#d5d5d5;border:1px solid #d5d5d5}.navy{background:#19478a;border:1px solid #19478a;color:#fff}.navy:hover{background:#3b629b;border:1px solid #3b629b}.trial-timer-window-navigation{display:flex;align-items:center;justify-content:center;margin-top:10px}.button{width:150px;height:32px;font-size:14px;font-family:Arial;display:flex;align-items:center;justify-content:center;margin:10px;border-radius:3px;-webkit-user-select:none}.blue{font-size:16px;color:#19478a}.lightgray{font-size:14px;color:#888}.trial-timer-warnings{display:flex;flex-direction:column;justify-content:center;align-items:center}.description{padding:10px 25px;font-family:Arial}.timer-remaining-days{position:absolute;display:inline-block;color:#76a797;font-family:Arial;font-size:30px;text-align:center;width:50px;top:calc(50% - 13px);left:calc(50% - 72px)}.trial-timer-window-interface{display:flex;flex-direction:column;justify-content:center;align-items:center}.trial-timer-image{position:relative;margin-top:20px}.trial-timer-image img{height:112px;width:197px}.trial-timer-window{background-color:var(--back-color);position:absolute;left:calc(50% - 275px);top:calc(50% - 176px);z-index:999;width:550px;height:352px;overflow:hidden;-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d;border:1px solid rgb(25,71,138);color:var(--text-color);font-size:13px;border-radius:5px;font-family:Arial;-webkit-user-select:none}.trial-timer-window-navbar{display:flex;height:30px;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;-webkit-user-select:none;color:#fff;align-items:center}.trial-timer-window-navbar span{font-size:13px}.close-button{height:30px;width:30px;border-radius:3px;display:flex;align-items:center;justify-content:center}span{margin-left:5px;font-size:12px}.close-button:hover{background-color:#dadada}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }, { type: i3.StiUserService }] });
//# sourceMappingURL=data:application/json;base64,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