import { Component, Input, ViewChild, } from "@angular/core";
import StiRectangleGeometryLayout from "../../computed/StiRectangleGeometryLayout";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-rich-text.service";
import * as i3 from "../../services/sti-component-resizer.service";
import * as i4 from "@angular/common";
import * as i5 from "../sti-component";
export class StiTextComponent {
    //component: StiComponent;
    get borderInnerWidth() {
        return Number(this.element.width) + Number(this.element.border.pen.width);
    }
    get borderInnerHeight() {
        return Number(this.element.height) + Number(this.element.border.pen.width);
    }
    constructor(model, richTextService, componentResizerService, render) {
        this.model = model;
        this.richTextService = richTextService;
        this.componentResizerService = componentResizerService;
        this.render = render;
        this.isClone = false;
    }
    ngAfterViewChecked() {
        let frameElement = document.getElementById("iframe" + this.element?.guid);
        let doc = frameElement?.contentWindow?.document;
    }
    changeMode(value) {
        let frameElement = document.getElementById("iframe" + this.element?.guid);
        let doc = frameElement?.contentWindow?.document;
        doc.body.contentEditable = value.toString();
    }
    get currentVerticalStep() {
        return this.model.form?.settings?.gridVerticalStep != 1 ? this.model.form?.settings?.gridVerticalStep : 5;
    }
    getIframeHeight(iframe) {
        if (this.getIframeMinHeight(iframe) > this.element?.height) {
            setTimeout(() => {
                if (!this.isClone) {
                    let height = this.getIframeMinHeight(iframe) + this.element.padding.top + this.element.padding.bottom;
                    this.element.height = Math.ceil(height / this.currentVerticalStep) * this.currentVerticalStep;
                    this.updateFormGeometry();
                }
            });
            return this.getIframeMinHeight(iframe);
        }
        else {
            return this.element.height;
        }
    }
    updateFormGeometry() {
        this.render.insertElement(this.element);
    }
    getIframeMinHeight(iframe) {
        if (iframe) {
            let firstChild = iframe?.contentDocument?.body?.firstChild;
            if (firstChild) {
                return firstChild.offsetHeight;
            }
            else {
                return 0;
            }
        }
        else {
            return 0;
        }
    }
    ngOnDestroy() {
        if (this.observer) {
            this.observer.disconnect();
        }
        this.changeModeSubscription?.unsubscribe();
    }
    ngAfterViewInit() {
        if (this.element.isAdded && !this.isClone) {
            if (this.model.getBrowserType() == "firefox") {
                let frameElements = document.querySelectorAll("#iframe" + this.element?.guid);
                frameElements.forEach((frameElement) => {
                    let this_ = this;
                    frameElement?.contentWindow?.addEventListener("load", () => {
                        let doc = frameElement?.contentWindow?.document;
                        doc.body.contentEditable = "true";
                        doc.body.style.margin = "0";
                        doc.body.style.overflowWrap = "break-word";
                        doc.body.innerHTML = this_.element.htmlTextString;
                        this_.richTextService.convertHtmlAttributesForWysiwyg(doc);
                        let element = this_.element;
                        const targetNode = doc.body;
                        this_.observer = new MutationObserver(() => (element.htmlTextString = this_.richTextService.convertDocumentToForm(doc)));
                        doc.body.addEventListener("mouseup", () => this_.richTextService.showCurrentState());
                        doc.body.addEventListener("keyup", () => this_.richTextService.showCurrentState());
                        doc.body.addEventListener("focus", () => {
                            this_.richTextService.initFont(this_.element.htmlTextString);
                            this_.richTextService.showCurrentState();
                        });
                        doc.body.addEventListener("mousedown", () => {
                            this_.model.selectedComponent = this_.component;
                        });
                        this_.observer.observe(targetNode, {
                            childList: true,
                            subtree: true,
                            attributes: true,
                            characterData: true,
                        });
                    });
                });
            }
            else {
                let frameElements = document.querySelectorAll("#iframe" + this.element?.guid);
                frameElements.forEach((frameElement) => {
                    let doc = frameElement?.contentWindow?.document;
                    doc.body.contentEditable = "true";
                    doc.body.style.margin = "0";
                    doc.body.innerHTML = this.element.htmlTextString;
                    this.richTextService.convertHtmlAttributesForWysiwyg(doc);
                    let element = this.element;
                    const targetNode = doc.body;
                    let this_ = this;
                    this.observer = new MutationObserver(() => (element.htmlTextString = this_.richTextService.convertDocumentToForm(doc)));
                    this.observer.observe(targetNode, {
                        childList: true,
                        subtree: true,
                        attributes: true,
                        characterData: true,
                    });
                    doc.body.addEventListener("mouseup", () => this.richTextService.showCurrentState());
                    doc.body.addEventListener("keyup", () => this.richTextService.showCurrentState());
                    doc.body.addEventListener("focus", () => {
                        this.richTextService.initFont(this.element.htmlTextString);
                        this.richTextService.showCurrentState();
                    });
                    doc.body.addEventListener("mousedown", () => {
                        this_.model.selectedComponent = this_.component;
                    });
                });
            }
        }
    }
    ngOnInit() {
        this.changeModeSubscription = this.model.interfaceEvent.subscribe((event) => {
            if (event.name == "setRibbon" && event.data?.ribbon === "Preview") {
                this.changeMode(false);
            }
            else if (event.name == "setRibbon" && event.data?.oldRibbon === "Preview") {
                this.changeMode(true);
            }
        });
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTextComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiRichTextService }, { token: i3.StiComponentResizerService }, { token: StiRectangleGeometryLayout }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiTextComponent, selector: "sti-text-component", inputs: { element: "element", isClone: "isClone" }, viewQueries: [{ propertyName: "richTextEditor", first: true, predicate: ["richTextEditor"], descendants: true }, { propertyName: "component", first: true, predicate: ["component"], descendants: true }], ngImport: i0, template: ` <sti-component [element]="element" #component [isClone]="isClone" class="sti-text">
    <div
      style="position: absolute;pointer-events:none;width:100%;height:100%; left:0; top:0;z-index:999"
      [style.height.px]="borderInnerHeight"
      [style.width.px]="borderInnerWidth"
      [style.left.px]="-(element.border.pen.width / 2)"
      [style.top.px]="-(element.border.pen.width / 2)"
      [style.border-top]="element.border.drawTop ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-left]="element.border.drawLeft ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-right]="element.border.drawRight ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-bottom]="element.border.drawBottom ? element.border.pen.toHtmlBorder() : 'transparent'"
    ></div>
    <iframe
      #iframe
      *ngIf="element.isAdded"
      id="{{ 'iframe' + element.guid }}"
      src="about:blank"
      frameborder="0"
      [style.height.px]="getIframeHeight(iframe)"
      [style.width]="'100%'"
      (mouseup)="model.canDrag = true"
      [style.pointer-events]="componentResizerService.isResizing ? 'none' : ''"
    >
    </iframe>
  </sti-component>`, isInline: true, styles: [".rich-text-editor{height:100%;width:100%;outline:none;font-weight:400;overflow:hidden}.rich-text-editor:hover{cursor:text}\n"], dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTextComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-text-component", template: ` <sti-component [element]="element" #component [isClone]="isClone" class="sti-text">
    <div
      style="position: absolute;pointer-events:none;width:100%;height:100%; left:0; top:0;z-index:999"
      [style.height.px]="borderInnerHeight"
      [style.width.px]="borderInnerWidth"
      [style.left.px]="-(element.border.pen.width / 2)"
      [style.top.px]="-(element.border.pen.width / 2)"
      [style.border-top]="element.border.drawTop ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-left]="element.border.drawLeft ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-right]="element.border.drawRight ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-bottom]="element.border.drawBottom ? element.border.pen.toHtmlBorder() : 'transparent'"
    ></div>
    <iframe
      #iframe
      *ngIf="element.isAdded"
      id="{{ 'iframe' + element.guid }}"
      src="about:blank"
      frameborder="0"
      [style.height.px]="getIframeHeight(iframe)"
      [style.width]="'100%'"
      (mouseup)="model.canDrag = true"
      [style.pointer-events]="componentResizerService.isResizing ? 'none' : ''"
    >
    </iframe>
  </sti-component>`, styles: [".rich-text-editor{height:100%;width:100%;outline:none;font-weight:400;overflow:hidden}.rich-text-editor:hover{cursor:text}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiRichTextService }, { type: i3.StiComponentResizerService }, { type: StiRectangleGeometryLayout }], propDecorators: { richTextEditor: [{
                type: ViewChild,
                args: ["richTextEditor"]
            }], component: [{
                type: ViewChild,
                args: ["component"]
            }], element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLXRleHQuY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3RpbXVsc29mdC1mb3Jtcy9zcmMvbGliL2NvbXBvbmVudHMvc3RpLXRleHQvc3RpLXRleHQuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFHTCxTQUFTLEVBRVQsS0FBSyxFQUdMLFNBQVMsR0FDVixNQUFNLGVBQWUsQ0FBQztBQVF2QixPQUFPLDBCQUEwQixNQUFNLDJDQUEyQyxDQUFDOzs7Ozs7O0FBNENuRixNQUFNLE9BQU8sZ0JBQWdCO0lBVzNCLDBCQUEwQjtJQUMxQixJQUFXLGdCQUFnQjtRQUN6QixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDNUUsQ0FBQztJQUNELElBQVcsaUJBQWlCO1FBQzFCLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUM3RSxDQUFDO0lBQ0QsWUFDUyxLQUFzQixFQUN0QixlQUFtQyxFQUNuQyx1QkFBbUQsRUFDbkQsTUFBa0M7UUFIbEMsVUFBSyxHQUFMLEtBQUssQ0FBaUI7UUFDdEIsb0JBQWUsR0FBZixlQUFlLENBQW9CO1FBQ25DLDRCQUF1QixHQUF2Qix1QkFBdUIsQ0FBNEI7UUFDbkQsV0FBTSxHQUFOLE1BQU0sQ0FBNEI7UUFqQmxDLFlBQU8sR0FBWSxLQUFLLENBQUM7SUFrQjlCLENBQUM7SUFDTCxrQkFBa0I7UUFDaEIsSUFBSSxZQUFZLEdBQUcsUUFBUSxDQUFDLGNBQWMsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLE9BQU8sRUFBRSxJQUFJLENBQVEsQ0FBQztRQUNqRixJQUFJLEdBQUcsR0FBRyxZQUFZLEVBQUUsYUFBYSxFQUFFLFFBQVEsQ0FBQztJQUNsRCxDQUFDO0lBQ0QsVUFBVSxDQUFDLEtBQWM7UUFDdkIsSUFBSSxZQUFZLEdBQUcsUUFBUSxDQUFDLGNBQWMsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLE9BQU8sRUFBRSxJQUFJLENBQVEsQ0FBQztRQUNqRixJQUFJLEdBQUcsR0FBRyxZQUFZLEVBQUUsYUFBYSxFQUFFLFFBQVEsQ0FBQztRQUNoRCxHQUFHLENBQUMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsUUFBUSxFQUFFLENBQUM7SUFDOUMsQ0FBQztJQUNELElBQUksbUJBQW1CO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsUUFBUSxFQUFFLGdCQUFnQixJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsUUFBUSxFQUFFLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDNUcsQ0FBQztJQUNELGVBQWUsQ0FBQyxNQUFNO1FBQ3BCLElBQUksSUFBSSxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxHQUFHLElBQUksQ0FBQyxPQUFPLEVBQUUsTUFBTSxFQUFFLENBQUM7WUFDM0QsVUFBVSxDQUFDLEdBQUcsRUFBRTtnQkFDZCxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDO29CQUNsQixJQUFJLE1BQU0sR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsR0FBRyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQztvQkFDdEcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUFDO29CQUM5RixJQUFJLENBQUMsa0JBQWtCLEVBQUUsQ0FBQztnQkFDNUIsQ0FBQztZQUNILENBQUMsQ0FBQyxDQUFDO1lBQ0gsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDekMsQ0FBQzthQUFNLENBQUM7WUFDTixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDO1FBQzdCLENBQUM7SUFDSCxDQUFDO0lBQ0Qsa0JBQWtCO1FBQ2hCLElBQUksQ0FBQyxNQUFNLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBQ0Qsa0JBQWtCLENBQUMsTUFBTTtRQUN2QixJQUFJLE1BQU0sRUFBRSxDQUFDO1lBQ1gsSUFBSSxVQUFVLEdBQUcsTUFBTSxFQUFFLGVBQWUsRUFBRSxJQUFJLEVBQUUsVUFBVSxDQUFDO1lBQzNELElBQUksVUFBVSxFQUFFLENBQUM7Z0JBQ2YsT0FBTyxVQUFVLENBQUMsWUFBWSxDQUFDO1lBQ2pDLENBQUM7aUJBQU0sQ0FBQztnQkFDTixPQUFPLENBQUMsQ0FBQztZQUNYLENBQUM7UUFDSCxDQUFDO2FBQU0sQ0FBQztZQUNOLE9BQU8sQ0FBQyxDQUFDO1FBQ1gsQ0FBQztJQUNILENBQUM7SUFDRCxXQUFXO1FBQ1QsSUFBSSxJQUFJLENBQUMsUUFBUSxFQUFFLENBQUM7WUFDbEIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxVQUFVLEVBQUUsQ0FBQztRQUM3QixDQUFDO1FBQ0QsSUFBSSxDQUFDLHNCQUFzQixFQUFFLFdBQVcsRUFBRSxDQUFDO0lBQzdDLENBQUM7SUFFRCxlQUFlO1FBQ2IsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsQ0FBQztZQUMxQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxFQUFFLElBQUksU0FBUyxFQUFFLENBQUM7Z0JBQzdDLElBQUksYUFBYSxHQUFHLFFBQVEsQ0FBQyxnQkFBZ0IsQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLE9BQU8sRUFBRSxJQUFJLENBQUMsQ0FBQztnQkFDOUUsYUFBYSxDQUFDLE9BQU8sQ0FBQyxDQUFDLFlBQVksRUFBRSxFQUFFO29CQUNyQyxJQUFJLEtBQUssR0FBRyxJQUFJLENBQUM7b0JBQ2hCLFlBQW9CLEVBQUUsYUFBYSxFQUFFLGdCQUFnQixDQUFDLE1BQU0sRUFBRSxHQUFHLEVBQUU7d0JBQ2xFLElBQUksR0FBRyxHQUFJLFlBQW9CLEVBQUUsYUFBYSxFQUFFLFFBQVEsQ0FBQzt3QkFDekQsR0FBRyxDQUFDLElBQUksQ0FBQyxlQUFlLEdBQUcsTUFBTSxDQUFDO3dCQUNsQyxHQUFHLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNLEdBQUcsR0FBRyxDQUFDO3dCQUM1QixHQUFHLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLEdBQUcsWUFBWSxDQUFDO3dCQUMzQyxHQUFHLENBQUMsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDLGNBQWMsQ0FBQzt3QkFDbEQsS0FBSyxDQUFDLGVBQWUsQ0FBQywrQkFBK0IsQ0FBQyxHQUFHLENBQUMsQ0FBQzt3QkFFM0QsSUFBSSxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQzt3QkFDNUIsTUFBTSxVQUFVLEdBQUcsR0FBRyxDQUFDLElBQUksQ0FBQzt3QkFFNUIsS0FBSyxDQUFDLFFBQVEsR0FBRyxJQUFJLGdCQUFnQixDQUNuQyxHQUFHLEVBQUUsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQyxxQkFBcUIsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUNsRixDQUFDO3dCQUNGLEdBQUcsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsU0FBUyxFQUFFLEdBQUcsRUFBRSxDQUFDLEtBQUssQ0FBQyxlQUFlLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQyxDQUFDO3dCQUNyRixHQUFHLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLE9BQU8sRUFBRSxHQUFHLEVBQUUsQ0FBQyxLQUFLLENBQUMsZUFBZSxDQUFDLGdCQUFnQixFQUFFLENBQUMsQ0FBQzt3QkFDbkYsR0FBRyxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUsR0FBRyxFQUFFOzRCQUN0QyxLQUFLLENBQUMsZUFBZSxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLGNBQWMsQ0FBQyxDQUFDOzRCQUM3RCxLQUFLLENBQUMsZUFBZSxDQUFDLGdCQUFnQixFQUFFLENBQUM7d0JBQzNDLENBQUMsQ0FBQyxDQUFDO3dCQUNILEdBQUcsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsV0FBVyxFQUFFLEdBQUcsRUFBRTs0QkFDMUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO3dCQUNsRCxDQUFDLENBQUMsQ0FBQzt3QkFDSCxLQUFLLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxVQUFVLEVBQUU7NEJBQ2pDLFNBQVMsRUFBRSxJQUFJOzRCQUNmLE9BQU8sRUFBRSxJQUFJOzRCQUNiLFVBQVUsRUFBRSxJQUFJOzRCQUNoQixhQUFhLEVBQUUsSUFBSTt5QkFDcEIsQ0FBQyxDQUFDO29CQUNMLENBQUMsQ0FBQyxDQUFDO2dCQUNMLENBQUMsQ0FBQyxDQUFDO1lBQ0wsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLElBQUksYUFBYSxHQUFHLFFBQVEsQ0FBQyxnQkFBZ0IsQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLE9BQU8sRUFBRSxJQUFJLENBQUMsQ0FBQztnQkFDOUUsYUFBYSxDQUFDLE9BQU8sQ0FBQyxDQUFDLFlBQVksRUFBRSxFQUFFO29CQUNyQyxJQUFJLEdBQUcsR0FBSSxZQUFvQixFQUFFLGFBQWEsRUFBRSxRQUFRLENBQUM7b0JBQ3pELEdBQUcsQ0FBQyxJQUFJLENBQUMsZUFBZSxHQUFHLE1BQU0sQ0FBQztvQkFDbEMsR0FBRyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxHQUFHLEdBQUcsQ0FBQztvQkFDNUIsR0FBRyxDQUFDLElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxjQUFjLENBQUM7b0JBQ2pELElBQUksQ0FBQyxlQUFlLENBQUMsK0JBQStCLENBQUMsR0FBRyxDQUFDLENBQUM7b0JBRTFELElBQUksT0FBTyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUM7b0JBQzNCLE1BQU0sVUFBVSxHQUFHLEdBQUcsQ0FBQyxJQUFJLENBQUM7b0JBQzVCLElBQUksS0FBSyxHQUFHLElBQUksQ0FBQztvQkFFakIsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLGdCQUFnQixDQUNsQyxHQUFHLEVBQUUsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQyxxQkFBcUIsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUNsRixDQUFDO29CQUNGLElBQUksQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLFVBQVUsRUFBRTt3QkFDaEMsU0FBUyxFQUFFLElBQUk7d0JBQ2YsT0FBTyxFQUFFLElBQUk7d0JBQ2IsVUFBVSxFQUFFLElBQUk7d0JBQ2hCLGFBQWEsRUFBRSxJQUFJO3FCQUNwQixDQUFDLENBQUM7b0JBRUgsR0FBRyxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxTQUFTLEVBQUUsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDLENBQUM7b0JBQ3BGLEdBQUcsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxFQUFFLEdBQUcsRUFBRSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQyxDQUFDO29CQUNsRixHQUFHLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLE9BQU8sRUFBRSxHQUFHLEVBQUU7d0JBQ3RDLElBQUksQ0FBQyxlQUFlLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsY0FBYyxDQUFDLENBQUM7d0JBQzNELElBQUksQ0FBQyxlQUFlLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztvQkFDMUMsQ0FBQyxDQUFDLENBQUM7b0JBRUgsR0FBRyxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxXQUFXLEVBQUUsR0FBRyxFQUFFO3dCQUMxQyxLQUFLLENBQUMsS0FBSyxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7b0JBQ2xELENBQUMsQ0FBQyxDQUFDO2dCQUNMLENBQUMsQ0FBQyxDQUFDO1lBQ0wsQ0FBQztRQUNILENBQUM7SUFDSCxDQUFDO0lBRUQsUUFBUTtRQUNOLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLGNBQWMsQ0FBQyxTQUFTLENBQUMsQ0FBQyxLQUFLLEVBQUUsRUFBRTtZQUMxRSxJQUFJLEtBQUssQ0FBQyxJQUFJLElBQUksV0FBVyxJQUFJLEtBQUssQ0FBQyxJQUFJLEVBQUUsTUFBTSxLQUFLLFNBQVMsRUFBRSxDQUFDO2dCQUNsRSxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQ3pCLENBQUM7aUJBQU0sSUFBSSxLQUFLLENBQUMsSUFBSSxJQUFJLFdBQVcsSUFBSSxLQUFLLENBQUMsSUFBSSxFQUFFLFNBQVMsS0FBSyxTQUFTLEVBQUUsQ0FBQztnQkFDNUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUN4QixDQUFDO1FBQ0gsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDOytHQTNKVSxnQkFBZ0IsNkhBNUN0QiwwQkFBMEI7bUdBNENwQixnQkFBZ0IseVRBeENqQjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O21CQXdCTzs7NEZBZ0JOLGdCQUFnQjtrQkExQzVCLFNBQVM7K0JBQ0Usb0JBQW9CLFlBQ3BCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7bUJBd0JPO21KQTVCWiwwQkFBMEIsdUJBNkNGLGNBQWM7c0JBQTFDLFNBQVM7dUJBQUMsZ0JBQWdCO2dCQUNILFNBQVM7c0JBQWhDLFNBQVM7dUJBQUMsV0FBVztnQkFFYixPQUFPO3NCQUFmLEtBQUs7Z0JBQ0csT0FBTztzQkFBZixLQUFLIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcclxuICBBZnRlclZpZXdDaGVja2VkLFxyXG4gIEFmdGVyVmlld0luaXQsXHJcbiAgQ29tcG9uZW50LFxyXG4gIEVsZW1lbnRSZWYsXHJcbiAgSW5wdXQsXHJcbiAgT25EZXN0cm95LFxyXG4gIE9uSW5pdCxcclxuICBWaWV3Q2hpbGQsXHJcbn0gZnJvbSBcIkBhbmd1bGFyL2NvcmVcIjtcclxuaW1wb3J0IHsgU3RpTW9kZWxTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uL3NlcnZpY2VzL21vZGVsLnNlcnZpY2VcIjtcclxuXHJcbmltcG9ydCB7IFN0aVRleHRFbGVtZW50IH0gZnJvbSBcIi4uLy4uL2VsZW1lbnRzL1N0aVRleHRFbGVtZW50XCI7XHJcbmltcG9ydCB7IFN0aVJpY2hUZXh0U2VydmljZSB9IGZyb20gXCIuLi8uLi9zZXJ2aWNlcy9zdGktcmljaC10ZXh0LnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpQ29tcG9uZW50IH0gZnJvbSBcIi4uL3N0aS1jb21wb25lbnRcIjtcclxuaW1wb3J0IHsgU3RpQ29tcG9uZW50UmVzaXplclNlcnZpY2UgfSBmcm9tIFwiLi4vLi4vc2VydmljZXMvc3RpLWNvbXBvbmVudC1yZXNpemVyLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3Vic2NyaXB0aW9uIH0gZnJvbSBcInJ4anNcIjtcclxuaW1wb3J0IFN0aVJlY3RhbmdsZUdlb21ldHJ5TGF5b3V0IGZyb20gXCIuLi8uLi9jb21wdXRlZC9TdGlSZWN0YW5nbGVHZW9tZXRyeUxheW91dFwiO1xyXG5cclxuQENvbXBvbmVudCh7XHJcbiAgc2VsZWN0b3I6IFwic3RpLXRleHQtY29tcG9uZW50XCIsXHJcbiAgdGVtcGxhdGU6IGAgPHN0aS1jb21wb25lbnQgW2VsZW1lbnRdPVwiZWxlbWVudFwiICNjb21wb25lbnQgW2lzQ2xvbmVdPVwiaXNDbG9uZVwiIGNsYXNzPVwic3RpLXRleHRcIj5cclxuICAgIDxkaXZcclxuICAgICAgc3R5bGU9XCJwb3NpdGlvbjogYWJzb2x1dGU7cG9pbnRlci1ldmVudHM6bm9uZTt3aWR0aDoxMDAlO2hlaWdodDoxMDAlOyBsZWZ0OjA7IHRvcDowO3otaW5kZXg6OTk5XCJcclxuICAgICAgW3N0eWxlLmhlaWdodC5weF09XCJib3JkZXJJbm5lckhlaWdodFwiXHJcbiAgICAgIFtzdHlsZS53aWR0aC5weF09XCJib3JkZXJJbm5lcldpZHRoXCJcclxuICAgICAgW3N0eWxlLmxlZnQucHhdPVwiLShlbGVtZW50LmJvcmRlci5wZW4ud2lkdGggLyAyKVwiXHJcbiAgICAgIFtzdHlsZS50b3AucHhdPVwiLShlbGVtZW50LmJvcmRlci5wZW4ud2lkdGggLyAyKVwiXHJcbiAgICAgIFtzdHlsZS5ib3JkZXItdG9wXT1cImVsZW1lbnQuYm9yZGVyLmRyYXdUb3AgPyBlbGVtZW50LmJvcmRlci5wZW4udG9IdG1sQm9yZGVyKCkgOiAndHJhbnNwYXJlbnQnXCJcclxuICAgICAgW3N0eWxlLmJvcmRlci1sZWZ0XT1cImVsZW1lbnQuYm9yZGVyLmRyYXdMZWZ0ID8gZWxlbWVudC5ib3JkZXIucGVuLnRvSHRtbEJvcmRlcigpIDogJ3RyYW5zcGFyZW50J1wiXHJcbiAgICAgIFtzdHlsZS5ib3JkZXItcmlnaHRdPVwiZWxlbWVudC5ib3JkZXIuZHJhd1JpZ2h0ID8gZWxlbWVudC5ib3JkZXIucGVuLnRvSHRtbEJvcmRlcigpIDogJ3RyYW5zcGFyZW50J1wiXHJcbiAgICAgIFtzdHlsZS5ib3JkZXItYm90dG9tXT1cImVsZW1lbnQuYm9yZGVyLmRyYXdCb3R0b20gPyBlbGVtZW50LmJvcmRlci5wZW4udG9IdG1sQm9yZGVyKCkgOiAndHJhbnNwYXJlbnQnXCJcclxuICAgID48L2Rpdj5cclxuICAgIDxpZnJhbWVcclxuICAgICAgI2lmcmFtZVxyXG4gICAgICAqbmdJZj1cImVsZW1lbnQuaXNBZGRlZFwiXHJcbiAgICAgIGlkPVwie3sgJ2lmcmFtZScgKyBlbGVtZW50Lmd1aWQgfX1cIlxyXG4gICAgICBzcmM9XCJhYm91dDpibGFua1wiXHJcbiAgICAgIGZyYW1lYm9yZGVyPVwiMFwiXHJcbiAgICAgIFtzdHlsZS5oZWlnaHQucHhdPVwiZ2V0SWZyYW1lSGVpZ2h0KGlmcmFtZSlcIlxyXG4gICAgICBbc3R5bGUud2lkdGhdPVwiJzEwMCUnXCJcclxuICAgICAgKG1vdXNldXApPVwibW9kZWwuY2FuRHJhZyA9IHRydWVcIlxyXG4gICAgICBbc3R5bGUucG9pbnRlci1ldmVudHNdPVwiY29tcG9uZW50UmVzaXplclNlcnZpY2UuaXNSZXNpemluZyA/ICdub25lJyA6ICcnXCJcclxuICAgID5cclxuICAgIDwvaWZyYW1lPlxyXG4gIDwvc3RpLWNvbXBvbmVudD5gLFxyXG4gIHN0eWxlczogW1xyXG4gICAgYFxyXG4gICAgICAucmljaC10ZXh0LWVkaXRvciB7XHJcbiAgICAgICAgaGVpZ2h0OiAxMDAlO1xyXG4gICAgICAgIHdpZHRoOiAxMDAlO1xyXG4gICAgICAgIG91dGxpbmU6IG5vbmU7XHJcbiAgICAgICAgZm9udC13ZWlnaHQ6IG5vcm1hbDtcclxuICAgICAgICBvdmVyZmxvdzogaGlkZGVuO1xyXG4gICAgICB9XHJcbiAgICAgIC5yaWNoLXRleHQtZWRpdG9yOmhvdmVyIHtcclxuICAgICAgICBjdXJzb3I6IHRleHQ7XHJcbiAgICAgIH1cclxuICAgIGAsXHJcbiAgXSxcclxufSlcclxuZXhwb3J0IGNsYXNzIFN0aVRleHRDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQsIEFmdGVyVmlld0luaXQsIE9uRGVzdHJveSwgQWZ0ZXJWaWV3Q2hlY2tlZCB7XHJcbiAgQFZpZXdDaGlsZChcInJpY2hUZXh0RWRpdG9yXCIpIHJpY2hUZXh0RWRpdG9yOiBFbGVtZW50UmVmO1xyXG4gIEBWaWV3Q2hpbGQoXCJjb21wb25lbnRcIikgY29tcG9uZW50OiBTdGlDb21wb25lbnQ7XHJcblxyXG4gIEBJbnB1dCgpIGVsZW1lbnQ6IFN0aVRleHRFbGVtZW50O1xyXG4gIEBJbnB1dCgpIGlzQ2xvbmU6IGJvb2xlYW4gPSBmYWxzZTtcclxuXHJcbiAgY2hhbmdlTW9kZVN1YnNjcmlwdGlvbjogU3Vic2NyaXB0aW9uO1xyXG5cclxuICBwdWJsaWMgc2VsZWN0ZWRDb21wb25lbnQ7XHJcbiAgcHJpdmF0ZSBvYnNlcnZlcjogTXV0YXRpb25PYnNlcnZlcjtcclxuICAvL2NvbXBvbmVudDogU3RpQ29tcG9uZW50O1xyXG4gIHB1YmxpYyBnZXQgYm9yZGVySW5uZXJXaWR0aCgpOiBOdW1iZXIge1xyXG4gICAgcmV0dXJuIE51bWJlcih0aGlzLmVsZW1lbnQud2lkdGgpICsgTnVtYmVyKHRoaXMuZWxlbWVudC5ib3JkZXIucGVuLndpZHRoKTtcclxuICB9XHJcbiAgcHVibGljIGdldCBib3JkZXJJbm5lckhlaWdodCgpOiBOdW1iZXIge1xyXG4gICAgcmV0dXJuIE51bWJlcih0aGlzLmVsZW1lbnQuaGVpZ2h0KSArIE51bWJlcih0aGlzLmVsZW1lbnQuYm9yZGVyLnBlbi53aWR0aCk7XHJcbiAgfVxyXG4gIGNvbnN0cnVjdG9yKFxyXG4gICAgcHVibGljIG1vZGVsOiBTdGlNb2RlbFNlcnZpY2UsXHJcbiAgICBwdWJsaWMgcmljaFRleHRTZXJ2aWNlOiBTdGlSaWNoVGV4dFNlcnZpY2UsXHJcbiAgICBwdWJsaWMgY29tcG9uZW50UmVzaXplclNlcnZpY2U6IFN0aUNvbXBvbmVudFJlc2l6ZXJTZXJ2aWNlLFxyXG4gICAgcHVibGljIHJlbmRlcjogU3RpUmVjdGFuZ2xlR2VvbWV0cnlMYXlvdXRcclxuICApIHsgfVxyXG4gIG5nQWZ0ZXJWaWV3Q2hlY2tlZCgpOiB2b2lkIHtcclxuICAgIGxldCBmcmFtZUVsZW1lbnQgPSBkb2N1bWVudC5nZXRFbGVtZW50QnlJZChcImlmcmFtZVwiICsgdGhpcy5lbGVtZW50Py5ndWlkKSBhcyBhbnk7XHJcbiAgICBsZXQgZG9jID0gZnJhbWVFbGVtZW50Py5jb250ZW50V2luZG93Py5kb2N1bWVudDtcclxuICB9XHJcbiAgY2hhbmdlTW9kZSh2YWx1ZTogYm9vbGVhbikge1xyXG4gICAgbGV0IGZyYW1lRWxlbWVudCA9IGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKFwiaWZyYW1lXCIgKyB0aGlzLmVsZW1lbnQ/Lmd1aWQpIGFzIGFueTtcclxuICAgIGxldCBkb2MgPSBmcmFtZUVsZW1lbnQ/LmNvbnRlbnRXaW5kb3c/LmRvY3VtZW50O1xyXG4gICAgZG9jLmJvZHkuY29udGVudEVkaXRhYmxlID0gdmFsdWUudG9TdHJpbmcoKTtcclxuICB9XHJcbiAgZ2V0IGN1cnJlbnRWZXJ0aWNhbFN0ZXAoKTogbnVtYmVyIHtcclxuICAgIHJldHVybiB0aGlzLm1vZGVsLmZvcm0/LnNldHRpbmdzPy5ncmlkVmVydGljYWxTdGVwICE9IDEgPyB0aGlzLm1vZGVsLmZvcm0/LnNldHRpbmdzPy5ncmlkVmVydGljYWxTdGVwIDogNTtcclxuICB9XHJcbiAgZ2V0SWZyYW1lSGVpZ2h0KGlmcmFtZSkge1xyXG4gICAgaWYgKHRoaXMuZ2V0SWZyYW1lTWluSGVpZ2h0KGlmcmFtZSkgPiB0aGlzLmVsZW1lbnQ/LmhlaWdodCkge1xyXG4gICAgICBzZXRUaW1lb3V0KCgpID0+IHtcclxuICAgICAgICBpZiAoIXRoaXMuaXNDbG9uZSkge1xyXG4gICAgICAgICAgbGV0IGhlaWdodCA9IHRoaXMuZ2V0SWZyYW1lTWluSGVpZ2h0KGlmcmFtZSkgKyB0aGlzLmVsZW1lbnQucGFkZGluZy50b3AgKyB0aGlzLmVsZW1lbnQucGFkZGluZy5ib3R0b207XHJcbiAgICAgICAgICB0aGlzLmVsZW1lbnQuaGVpZ2h0ID0gTWF0aC5jZWlsKGhlaWdodCAvIHRoaXMuY3VycmVudFZlcnRpY2FsU3RlcCkgKiB0aGlzLmN1cnJlbnRWZXJ0aWNhbFN0ZXA7XHJcbiAgICAgICAgICB0aGlzLnVwZGF0ZUZvcm1HZW9tZXRyeSgpO1xyXG4gICAgICAgIH1cclxuICAgICAgfSk7XHJcbiAgICAgIHJldHVybiB0aGlzLmdldElmcmFtZU1pbkhlaWdodChpZnJhbWUpO1xyXG4gICAgfSBlbHNlIHtcclxuICAgICAgcmV0dXJuIHRoaXMuZWxlbWVudC5oZWlnaHQ7XHJcbiAgICB9XHJcbiAgfVxyXG4gIHVwZGF0ZUZvcm1HZW9tZXRyeSgpIHtcclxuICAgIHRoaXMucmVuZGVyLmluc2VydEVsZW1lbnQodGhpcy5lbGVtZW50KTtcclxuICB9XHJcbiAgZ2V0SWZyYW1lTWluSGVpZ2h0KGlmcmFtZSkge1xyXG4gICAgaWYgKGlmcmFtZSkge1xyXG4gICAgICBsZXQgZmlyc3RDaGlsZCA9IGlmcmFtZT8uY29udGVudERvY3VtZW50Py5ib2R5Py5maXJzdENoaWxkO1xyXG4gICAgICBpZiAoZmlyc3RDaGlsZCkge1xyXG4gICAgICAgIHJldHVybiBmaXJzdENoaWxkLm9mZnNldEhlaWdodDtcclxuICAgICAgfSBlbHNlIHtcclxuICAgICAgICByZXR1cm4gMDtcclxuICAgICAgfVxyXG4gICAgfSBlbHNlIHtcclxuICAgICAgcmV0dXJuIDA7XHJcbiAgICB9XHJcbiAgfVxyXG4gIG5nT25EZXN0cm95KCk6IHZvaWQge1xyXG4gICAgaWYgKHRoaXMub2JzZXJ2ZXIpIHtcclxuICAgICAgdGhpcy5vYnNlcnZlci5kaXNjb25uZWN0KCk7XHJcbiAgICB9XHJcbiAgICB0aGlzLmNoYW5nZU1vZGVTdWJzY3JpcHRpb24/LnVuc3Vic2NyaWJlKCk7XHJcbiAgfVxyXG5cclxuICBuZ0FmdGVyVmlld0luaXQoKTogdm9pZCB7XHJcbiAgICBpZiAodGhpcy5lbGVtZW50LmlzQWRkZWQgJiYgIXRoaXMuaXNDbG9uZSkge1xyXG4gICAgICBpZiAodGhpcy5tb2RlbC5nZXRCcm93c2VyVHlwZSgpID09IFwiZmlyZWZveFwiKSB7XHJcbiAgICAgICAgbGV0IGZyYW1lRWxlbWVudHMgPSBkb2N1bWVudC5xdWVyeVNlbGVjdG9yQWxsKFwiI2lmcmFtZVwiICsgdGhpcy5lbGVtZW50Py5ndWlkKTtcclxuICAgICAgICBmcmFtZUVsZW1lbnRzLmZvckVhY2goKGZyYW1lRWxlbWVudCkgPT4ge1xyXG4gICAgICAgICAgbGV0IHRoaXNfID0gdGhpcztcclxuICAgICAgICAgIChmcmFtZUVsZW1lbnQgYXMgYW55KT8uY29udGVudFdpbmRvdz8uYWRkRXZlbnRMaXN0ZW5lcihcImxvYWRcIiwgKCkgPT4ge1xyXG4gICAgICAgICAgICBsZXQgZG9jID0gKGZyYW1lRWxlbWVudCBhcyBhbnkpPy5jb250ZW50V2luZG93Py5kb2N1bWVudDtcclxuICAgICAgICAgICAgZG9jLmJvZHkuY29udGVudEVkaXRhYmxlID0gXCJ0cnVlXCI7XHJcbiAgICAgICAgICAgIGRvYy5ib2R5LnN0eWxlLm1hcmdpbiA9IFwiMFwiO1xyXG4gICAgICAgICAgICBkb2MuYm9keS5zdHlsZS5vdmVyZmxvd1dyYXAgPSBcImJyZWFrLXdvcmRcIjtcclxuICAgICAgICAgICAgZG9jLmJvZHkuaW5uZXJIVE1MID0gdGhpc18uZWxlbWVudC5odG1sVGV4dFN0cmluZztcclxuICAgICAgICAgICAgdGhpc18ucmljaFRleHRTZXJ2aWNlLmNvbnZlcnRIdG1sQXR0cmlidXRlc0Zvcld5c2l3eWcoZG9jKTtcclxuXHJcbiAgICAgICAgICAgIGxldCBlbGVtZW50ID0gdGhpc18uZWxlbWVudDtcclxuICAgICAgICAgICAgY29uc3QgdGFyZ2V0Tm9kZSA9IGRvYy5ib2R5O1xyXG5cclxuICAgICAgICAgICAgdGhpc18ub2JzZXJ2ZXIgPSBuZXcgTXV0YXRpb25PYnNlcnZlcihcclxuICAgICAgICAgICAgICAoKSA9PiAoZWxlbWVudC5odG1sVGV4dFN0cmluZyA9IHRoaXNfLnJpY2hUZXh0U2VydmljZS5jb252ZXJ0RG9jdW1lbnRUb0Zvcm0oZG9jKSlcclxuICAgICAgICAgICAgKTtcclxuICAgICAgICAgICAgZG9jLmJvZHkuYWRkRXZlbnRMaXN0ZW5lcihcIm1vdXNldXBcIiwgKCkgPT4gdGhpc18ucmljaFRleHRTZXJ2aWNlLnNob3dDdXJyZW50U3RhdGUoKSk7XHJcbiAgICAgICAgICAgIGRvYy5ib2R5LmFkZEV2ZW50TGlzdGVuZXIoXCJrZXl1cFwiLCAoKSA9PiB0aGlzXy5yaWNoVGV4dFNlcnZpY2Uuc2hvd0N1cnJlbnRTdGF0ZSgpKTtcclxuICAgICAgICAgICAgZG9jLmJvZHkuYWRkRXZlbnRMaXN0ZW5lcihcImZvY3VzXCIsICgpID0+IHtcclxuICAgICAgICAgICAgICB0aGlzXy5yaWNoVGV4dFNlcnZpY2UuaW5pdEZvbnQodGhpc18uZWxlbWVudC5odG1sVGV4dFN0cmluZyk7XHJcbiAgICAgICAgICAgICAgdGhpc18ucmljaFRleHRTZXJ2aWNlLnNob3dDdXJyZW50U3RhdGUoKTtcclxuICAgICAgICAgICAgfSk7XHJcbiAgICAgICAgICAgIGRvYy5ib2R5LmFkZEV2ZW50TGlzdGVuZXIoXCJtb3VzZWRvd25cIiwgKCkgPT4ge1xyXG4gICAgICAgICAgICAgIHRoaXNfLm1vZGVsLnNlbGVjdGVkQ29tcG9uZW50ID0gdGhpc18uY29tcG9uZW50O1xyXG4gICAgICAgICAgICB9KTtcclxuICAgICAgICAgICAgdGhpc18ub2JzZXJ2ZXIub2JzZXJ2ZSh0YXJnZXROb2RlLCB7XHJcbiAgICAgICAgICAgICAgY2hpbGRMaXN0OiB0cnVlLFxyXG4gICAgICAgICAgICAgIHN1YnRyZWU6IHRydWUsXHJcbiAgICAgICAgICAgICAgYXR0cmlidXRlczogdHJ1ZSxcclxuICAgICAgICAgICAgICBjaGFyYWN0ZXJEYXRhOiB0cnVlLFxyXG4gICAgICAgICAgICB9KTtcclxuICAgICAgICAgIH0pO1xyXG4gICAgICAgIH0pO1xyXG4gICAgICB9IGVsc2Uge1xyXG4gICAgICAgIGxldCBmcmFtZUVsZW1lbnRzID0gZG9jdW1lbnQucXVlcnlTZWxlY3RvckFsbChcIiNpZnJhbWVcIiArIHRoaXMuZWxlbWVudD8uZ3VpZCk7XHJcbiAgICAgICAgZnJhbWVFbGVtZW50cy5mb3JFYWNoKChmcmFtZUVsZW1lbnQpID0+IHtcclxuICAgICAgICAgIGxldCBkb2MgPSAoZnJhbWVFbGVtZW50IGFzIGFueSk/LmNvbnRlbnRXaW5kb3c/LmRvY3VtZW50O1xyXG4gICAgICAgICAgZG9jLmJvZHkuY29udGVudEVkaXRhYmxlID0gXCJ0cnVlXCI7XHJcbiAgICAgICAgICBkb2MuYm9keS5zdHlsZS5tYXJnaW4gPSBcIjBcIjtcclxuICAgICAgICAgIGRvYy5ib2R5LmlubmVySFRNTCA9IHRoaXMuZWxlbWVudC5odG1sVGV4dFN0cmluZztcclxuICAgICAgICAgIHRoaXMucmljaFRleHRTZXJ2aWNlLmNvbnZlcnRIdG1sQXR0cmlidXRlc0Zvcld5c2l3eWcoZG9jKTtcclxuXHJcbiAgICAgICAgICBsZXQgZWxlbWVudCA9IHRoaXMuZWxlbWVudDtcclxuICAgICAgICAgIGNvbnN0IHRhcmdldE5vZGUgPSBkb2MuYm9keTtcclxuICAgICAgICAgIGxldCB0aGlzXyA9IHRoaXM7XHJcblxyXG4gICAgICAgICAgdGhpcy5vYnNlcnZlciA9IG5ldyBNdXRhdGlvbk9ic2VydmVyKFxyXG4gICAgICAgICAgICAoKSA9PiAoZWxlbWVudC5odG1sVGV4dFN0cmluZyA9IHRoaXNfLnJpY2hUZXh0U2VydmljZS5jb252ZXJ0RG9jdW1lbnRUb0Zvcm0oZG9jKSlcclxuICAgICAgICAgICk7XHJcbiAgICAgICAgICB0aGlzLm9ic2VydmVyLm9ic2VydmUodGFyZ2V0Tm9kZSwge1xyXG4gICAgICAgICAgICBjaGlsZExpc3Q6IHRydWUsXHJcbiAgICAgICAgICAgIHN1YnRyZWU6IHRydWUsXHJcbiAgICAgICAgICAgIGF0dHJpYnV0ZXM6IHRydWUsXHJcbiAgICAgICAgICAgIGNoYXJhY3RlckRhdGE6IHRydWUsXHJcbiAgICAgICAgICB9KTtcclxuXHJcbiAgICAgICAgICBkb2MuYm9keS5hZGRFdmVudExpc3RlbmVyKFwibW91c2V1cFwiLCAoKSA9PiB0aGlzLnJpY2hUZXh0U2VydmljZS5zaG93Q3VycmVudFN0YXRlKCkpO1xyXG4gICAgICAgICAgZG9jLmJvZHkuYWRkRXZlbnRMaXN0ZW5lcihcImtleXVwXCIsICgpID0+IHRoaXMucmljaFRleHRTZXJ2aWNlLnNob3dDdXJyZW50U3RhdGUoKSk7XHJcbiAgICAgICAgICBkb2MuYm9keS5hZGRFdmVudExpc3RlbmVyKFwiZm9jdXNcIiwgKCkgPT4ge1xyXG4gICAgICAgICAgICB0aGlzLnJpY2hUZXh0U2VydmljZS5pbml0Rm9udCh0aGlzLmVsZW1lbnQuaHRtbFRleHRTdHJpbmcpO1xyXG4gICAgICAgICAgICB0aGlzLnJpY2hUZXh0U2VydmljZS5zaG93Q3VycmVudFN0YXRlKCk7XHJcbiAgICAgICAgICB9KTtcclxuXHJcbiAgICAgICAgICBkb2MuYm9keS5hZGRFdmVudExpc3RlbmVyKFwibW91c2Vkb3duXCIsICgpID0+IHtcclxuICAgICAgICAgICAgdGhpc18ubW9kZWwuc2VsZWN0ZWRDb21wb25lbnQgPSB0aGlzXy5jb21wb25lbnQ7XHJcbiAgICAgICAgICB9KTtcclxuICAgICAgICB9KTtcclxuICAgICAgfVxyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgbmdPbkluaXQoKTogdm9pZCB7XHJcbiAgICB0aGlzLmNoYW5nZU1vZGVTdWJzY3JpcHRpb24gPSB0aGlzLm1vZGVsLmludGVyZmFjZUV2ZW50LnN1YnNjcmliZSgoZXZlbnQpID0+IHtcclxuICAgICAgaWYgKGV2ZW50Lm5hbWUgPT0gXCJzZXRSaWJib25cIiAmJiBldmVudC5kYXRhPy5yaWJib24gPT09IFwiUHJldmlld1wiKSB7XHJcbiAgICAgICAgdGhpcy5jaGFuZ2VNb2RlKGZhbHNlKTtcclxuICAgICAgfSBlbHNlIGlmIChldmVudC5uYW1lID09IFwic2V0UmliYm9uXCIgJiYgZXZlbnQuZGF0YT8ub2xkUmliYm9uID09PSBcIlByZXZpZXdcIikge1xyXG4gICAgICAgIHRoaXMuY2hhbmdlTW9kZSh0cnVlKTtcclxuICAgICAgfVxyXG4gICAgfSk7XHJcbiAgfVxyXG59XHJcbiJdfQ==