import { Component, Input, ViewChild, } from "@angular/core";
import { StiHorizontalAlignment, StiLabelAlignment, StiVerticalAlignment } from "../../system/enums";
import { StiRadioButtonColumnItem } from "../../elements/table/columns/StiRadioButtonColumnItem";
import { Enum } from "../../system/Enum";
import Color from "../../system/Color";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-draggable.service";
import * as i3 from "../../services/sti-column-draggable.service";
import * as i4 from "../../services/sti-editable-content.service";
import * as i5 from "../../services/mouse.service";
import * as i6 from "@angular/common";
import * as i7 from "../sti-component";
import * as i8 from "../sti-editable-content.component";
import * as i9 from "./sti-table-totals-field/sti-table-totals-field.component";
import * as i10 from "../sti-table-column-resizer.component";
import * as i11 from "./sti-table-column/sti-table-column.component";
export class StiTableComponent {
    get selected() {
        return this.model.selectedComponent?.element == this.element;
    }
    get canAddRow() {
        return this._canAddRow;
    }
    set canAddRow(value) {
        let oldValue = this._canAddRow;
        if (oldValue != value) {
            this._canAddRow = value;
            this.cdr.detectChanges();
        }
    }
    get canDeleteRow() {
        return this._canDeleteRow;
    }
    set canDeleteRow(value) {
        let oldValue = this._canDeleteRow;
        if (oldValue != value) {
            this._canDeleteRow = value;
            this.cdr.detectChanges();
        }
    }
    checkAbilityToAddRow() {
        if (this.isInitialized) {
            let tableRect = this.model.getPositionRelativeToForm(this.table?.nativeElement);
            let totalsRect = this.model.getPositionRelativeToForm(this.totals?.nativeElement);
            let tableRowRect = this.model.getPositionRelativeToForm(this.tableRow?.nativeElement);
            let componentLabelRect = this.model.getPositionRelativeToForm(this.componentLabel?.nativeElement);
            let componentDescriptionRect = this.model.getPositionRelativeToForm(this.componentDescription?.nativeElement);
            if (this.model.previewMode) {
                let componentInnerHeight = this.element.height - this.element.padding.top - this.element.padding.bottom;
                this.canAddRow =
                    componentInnerHeight -
                        (this.element.label.value && this.element.label.alignment == StiLabelAlignment.Top
                            ? componentLabelRect?.height
                            : 0) -
                        (this.element.description.value ? componentDescriptionRect?.height : 0) -
                        (this.element.useTotals ? totalsRect?.height : 0) -
                        tableRect?.height >
                        tableRowRect?.height;
            }
            else {
                let parentContainer = this.model.getElementPage(this.element) ?? this.model.getElementPanel(this.element);
                this.canAddRow =
                    parentContainer.contentAreaHeight -
                        (this.element.label.value && this.element.label.alignment == StiLabelAlignment.Top
                            ? componentLabelRect?.height
                            : 0) -
                        (this.element.description.value ? componentDescriptionRect?.height : 0) -
                        (this.element.useTotals ? totalsRect?.height : 0) -
                        tableRect?.height >
                        tableRowRect?.height;
            }
        }
        else {
            this.canAddRow = false;
        }
    }
    getMaxHeight() {
        if (!this.isInitialized) {
            return 0;
        }
        let tBodyRec = this.tBody ? this.model.getPositionRelativeToForm(this.tBody?.nativeElement) : 0;
        let totalsRec = this.totals ? this.model.getPositionRelativeToForm(this.totals?.nativeElement) : 0;
        return Number((this.element.geometry.bottom -
            this.element.padding.bottom -
            this.element.padding.top -
            this.getSizeWithZoom(tBodyRec instanceof DOMRect ? tBodyRec.height : 0) -
            this.getSizeWithZoom(totalsRec instanceof DOMRect ? totalsRec.height : 0) -
            this.innerMargin).toFixed(2));
    }
    checkAbilityToDeleteRow() {
        this.canDeleteRow = this.element.rowLabels.length > 1;
    }
    canDeleteColumn() {
        return this.element.columns.length > 0 && this.isInitialized ? true : false;
    }
    getSizeWithZoom(size) {
        return size / this.model.zoom;
    }
    isOverMaxHeight() {
        if (!this.isInitialized) {
            return false;
        }
        let parentContainer = this.model.getElementPage(this.element) ?? this.model.getElementPanel(this.element);
        return this.element.height == parentContainer.contentAreaHeight - this.element.y;
    }
    updatePropertyGrid(column, event) {
        if (!this.element.showColumnsEditor) {
            this.element.showColumnsEditor = true;
            this.model.needToRefresh.next(true);
        }
        setTimeout(() => {
            let index = this.element.columns.findIndex((item) => item == column);
            if (this.model.currentContentEditableItemIndex != index ||
                this.model.previousSelectedComponent?.element != this.element) {
                this.model.currentContentEditableItem.next(index);
                this.model.currentContentEditableItemIndex = index;
            }
        }, 0);
    }
    get totalsWidth() {
        return this.element?.label?.alignment == StiLabelAlignment.Top
            ? this.element?.width - this.element.padding.left - this.element.padding.right
            : this.element?.width - this.element?.label?.width - this.element.padding.left - this.element.padding.right;
    }
    getPageColor() {
        if (this.model.selectedComponent.element == this.element) {
            if (this.model.getElementPage(this.element)) {
                return this.model.getElementPage(this.element)?.backgroundColor?.toHtmlColor();
            }
            else {
                let currentElement = this.model.getElementPanel(this.element);
                if (this.model.getElementPage(currentElement)) {
                    return this.model.getElementPage(currentElement)?.backgroundColor?.toHtmlColor();
                }
                else {
                    while (this.model.getElementPage(currentElement)) {
                        currentElement = this.model.getElementPanel(currentElement);
                    }
                    return this.model.getElementPage(currentElement)?.backgroundColor?.toHtmlColor();
                }
            }
        }
        else {
            return "transparent";
        }
    }
    get align() {
        return "start";
    }
    get contentAlign() {
        return this.element["label"]["alignment"] == StiLabelAlignment.Right ? "flex-end" : "start";
    }
    get width() {
        if (this.element.label.alignment == StiLabelAlignment.Top) {
            return "100%";
        }
        else {
            return this.element.label.width + "px";
        }
    }
    get margin() {
        return this.element["label"]["alignment"] == StiLabelAlignment.Top && this.element.label.value ? "10" : "0";
    }
    get headerAlignment() {
        return Enum.getName(StiHorizontalAlignment, this.element.tableHeaderAlignment);
    }
    get rowAlignment() {
        return Enum.getName(StiHorizontalAlignment, this.element.rowLabelsHorizontalAlignment);
    }
    get totalVerticalAlignment() {
        if (this.element.totalsRowHeaderVerticalAlignment == StiVerticalAlignment.Top) {
            return "flex-start";
        }
        else if (this.element.totalsRowHeaderVerticalAlignment == StiVerticalAlignment.Bottom) {
            return "flex-end";
        }
        else {
            return "center";
        }
    }
    get totalHorizontalAlignment() {
        if (this.element.totalsRowHeaderHorizontalAlignment == StiHorizontalAlignment.Left) {
            return "flex-start";
        }
        else if (this.element.totalsRowHeaderHorizontalAlignment == StiHorizontalAlignment.Right) {
            return "flex-end";
        }
        else {
            return "center";
        }
    }
    onHeaderClick(event, item) {
        if (this.model.previewMode) {
            return;
        }
        let form = document.querySelector("stimulsoft-forms");
        form?.classList.add("unselectable");
        this.model.canDrag = false;
        if (this.editableContentService.editableContent != item) {
            this.columnDraggableService.onHeaderClick(event, item, this.element.columns, true, this.element);
        }
    }
    changeStyle(elem) { }
    get tableBackColor() {
        return this.element?.backgroundColor.toHtmlColor()
            ? this.element.backgroundColor.toHtmlColor()
            : Color.transparent().toHtmlColor();
    }
    addColumn() {
        this.element.addColumnLikeLast();
        this.model.showColumnPreview(this.element.columns.length - 1);
    }
    addRow() {
        this.element.addRow();
    }
    deleteColumn() {
        this.element.deleteLastColumn();
    }
    deleteRow() {
        this.element.deleteLastRow();
    }
    getColumnAlignment(column) {
        return Enum.getName(StiHorizontalAlignment, column.cellAlignment);
    }
    getBorder(pen, isVisible, isDragPreview = false) {
        return isVisible || isDragPreview ? pen.toHtmlBorder() : "transparent";
    }
    getBorderWidth(pen, isDragPreview) {
        let res = isDragPreview ? Number(pen.width) + 2 : pen.width;
        return res + "px";
    }
    getColumnBackColor(column, index) {
        if (this.element.alternateRowColors) {
            if (index % 2 === 0) {
                return this.element.oddRowsStyle.toHtmlColor();
            }
            else {
                return this.element.evenRowsStyle.toHtmlColor();
            }
        }
        else {
            return column.backgroundColor?.toHtmlColor() ?? column.eBackgroundColor.toHtmlColor();
        }
    }
    getColumnForeColor(column, index) {
        if (this.element.alternateRowColors) {
            if (index % 2 === 0) {
                return this.element.oddRowsTextColor.toHtmlColor();
            }
            else {
                return this.element.evenRowsTextColor.toHtmlColor();
            }
        }
        else {
            return column.cellForeColor?.toHtmlColor() ?? column.eColor.toHtmlColor();
        }
    }
    constructor(model, draggableService, columnDraggableService, editableContentService, cdr, mouseService) {
        this.model = model;
        this.draggableService = draggableService;
        this.columnDraggableService = columnDraggableService;
        this.editableContentService = editableContentService;
        this.cdr = cdr;
        this.mouseService = mouseService;
        this.isClone = false;
        this.minWidth = 40;
        this.isDrag = false;
        this.canDrag = false;
        this.isInitialized = false;
        this.isActive = false;
        this._canAddRow = false;
        this._canDeleteRow = false;
        this.innerMargin = 5;
    }
    ngAfterContentChecked() {
        if (!this.model.draggingElement &&
            !this.isClone &&
            (this.model?.selectedComponent?.element == this.element || this.isActive)) {
            this.checkAbilityToAddRow();
            this.checkAbilityToDeleteRow();
        }
    }
    ngOnDestroy() {
        this.isInitialized = false;
    }
    ngAfterViewInit() {
        if (this.element && !this.isClone) {
            this.element.element = this.tableTr;
            if (this.element != this.model.draggingElement) {
                setTimeout(() => {
                    this.isInitialized = true;
                });
            }
        }
    }
    ngOnInit() { }
    changeState(column, i) {
        if (column instanceof StiRadioButtonColumnItem) {
            column.cells.forEach((cell) => {
                cell.isChecked = false;
            });
        }
        column.cells[i].isChecked = !column.cells[i].isChecked;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiDraggableService }, { token: i3.StiColumnDraggableService }, { token: i4.StiEditableContentService }, { token: i0.ChangeDetectorRef }, { token: i5.StiMouseService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiTableComponent, selector: "sti-table-component", inputs: { element: "element", isClone: "isClone" }, viewQueries: [{ propertyName: "tableTr", first: true, predicate: ["tableTr"], descendants: true }, { propertyName: "tBody", first: true, predicate: ["tBody"], descendants: true }, { propertyName: "totals", first: true, predicate: ["totals"], descendants: true }, { propertyName: "table", first: true, predicate: ["table"], descendants: true }, { propertyName: "tableRow", first: true, predicate: ["tableRow"], descendants: true }, { propertyName: "componentDescription", first: true, predicate: ["description"], descendants: true }, { propertyName: "componentLabel", first: true, predicate: ["label"], descendants: true }], ngImport: i0, template: ` <sti-component
    [element]="element"
    [isClone]="isClone"
    (mouseenter)="model.previewMode ? (isActive = true) : ''"
    (mouseleave)="model.previewMode ? (isActive = false) : ''"
  >
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [style.align-self]="align"
      [style.text-align]="contentAlign"
      [editableContent]="element.label"
      [style.width]="width"
    ></sti-editable-content-component>
    <table
      class="outer-table"
      [style.width]="'100%'"
      [style.height]="'max-content'"
      [style.margin-top.px]="element?.getTopMargin()"
    >
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
          #label
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <div class="sti-table" #table>
            <div [style.display]="'flex'">
              <table
                class="column-drop-area"
                [style.background-color]="element?.backgroundColor.toHtmlColor()"
                [style.align-self]="align"
              >
                <thead>
                  <tr #tableTr>
                    <th
                      *ngIf="element?.showRowLabels"
                      [id]="0"
                      (mousemove)="columnDraggableService.fromTable ? (columnDraggableService.insertIndex = 0) : return"
                      [style.justify-content]="headerAlignment"
                      [style.color]="element?.tableHeaderColor.toHtmlColor()"
                      [style.background-color]="element?.tableHeaderBackgroundColor.toHtmlColor()"
                      [style.width.px]="!isClone ? element?.rowLabelsWidth : 0"
                      [style.max-height.px]="
                        !isClone && !model.pdfPreviewMode && isInitialized && isOverMaxHeight()
                          ? getMaxHeight()
                          : 'auto'
                      "
                      [style.border-top]="getBorder(element?.border.pen, element?.border.drawTop)"
                      [style.border-left]="getBorder(element?.border.pen, element?.border.drawLeft)"
                      [style.border-bottom]="
                        getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawTop)
                      "
                      [style.border-right]="
                        element.columns.length > 0 ? '' : getBorder(element?.border.pen, element?.border.drawRight)
                      "
                      [style.padding]="'5px 0px 5px 5px'"
                    >
                      <sti-editable-content-component
                        [editableContent]="element"
                        [alignment]="element?.tableHeaderAlignment"
                        [isTableHeader]="true"
                        [style.width]="'100%'"
                        [hideEmpty]="false"
                        [active]="selected"
                      ></sti-editable-content-component>
                      <sti-table-column-resizer
                        [resizableItem]="element"
                        [element]="element"
                        [style.height]="'100%'"
                      ></sti-table-column-resizer>
                    </th>
                    <th
                      *ngFor="let column of element.columns; index as idx"
                      [id]="idx + 1"
                      (mousemove)="
                        columnDraggableService.fromTable ? (columnDraggableService.insertIndex = idx + 1) : return
                      "
                      class="drag-item sti-table-th"
                      (click)="model.showColumnPreview(idx)"
                      [style]="element.font.htmlStyle()"
                      [style.justify-content]="getColumnAlignment(column)"
                      (mousedown)="onHeaderClick($event, column)"
                      [style.color]="column?.headerForeColor.toHtmlColor()"
                      [style.background-color]="column?.headerBackColor.toHtmlColor()"
                      [style.width.px]="!isClone ? column?.width : 0"
                      [style.height.px]="
                        isClone && !model.pdfPreviewMode ? element?.element?.nativeElement?.clientHeight : 'auto'
                      "
                      [style.max-height.px]="
                        !isClone && !model.pdfPreviewMode && isInitialized && isOverMaxHeight()
                          ? getMaxHeight()
                          : 'auto'
                      "
                      [style.transition]="columnDraggableService.fromTable ? 'border-width 50ms linear' : ''"
                      [style.border-top]="
                        getBorder(element?.columnHeadersBorder.pen, element?.columnHeadersBorder.drawTop) !=
                        'transparent'
                          ? getBorder(element?.columnHeadersBorder.pen, element?.columnHeadersBorder.drawTop)
                          : getBorder(element?.border.pen, element?.border.drawTop)
                      "
                      [style.border-bottom]="
                        getBorder(element?.columnHeadersBorder.pen, element?.columnHeadersBorder.drawBottom)
                      "
                      [style.border-right]="
                        getBorder(
                          element?.columnHeadersBorder.pen,
                          element?.columnHeadersBorder.drawRight,
                          columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == idx + 1
                            ? true
                            : false
                        ) != 'transparent'
                          ? idx == element.columns.length - 1
                            ? getBorder(
                                element?.columnHeadersBorder.pen,
                                element?.columnHeadersBorder.drawRight,
                                columnDraggableService.parentElement == element &&
                                  columnDraggableService.fromTable &&
                                  columnDraggableService.insertIndex == idx + 1
                                  ? true
                                  : false
                              )
                            : getBorder(
                                element?.gridLines.pen,
                                element?.gridLines.drawVertical,
                                columnDraggableService.parentElement == element &&
                                  columnDraggableService.fromTable &&
                                  columnDraggableService.insertIndex == idx + 1
                                  ? true
                                  : false
                              )
                          : idx == element.columns.length - 1
                          ? getBorder(
                              element?.border.pen,
                              element?.border.drawRight,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == idx + 1
                                ? true
                                : false
                            )
                          : getBorder(
                              element?.gridLines.pen,
                              element?.gridLines.drawVertical,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == idx + 1
                                ? true
                                : false
                            )
                      "
                      [style.border-left]="
                        idx == 0
                          ? getBorder(
                              element?.columnHeadersBorder.pen,
                              element?.columnHeadersBorder.drawLeft,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == 0 &&
                                idx == 0
                                ? true
                                : false
                            )
                          : ''
                      "
                      [style.border-left-width]="
                        columnDraggableService.parentElement == element &&
                        columnDraggableService.fromTable &&
                        columnDraggableService.insertIndex == 0 &&
                        idx == 0
                          ? getBorderWidth(element?.columnHeadersBorder.pen, true)
                          : getBorderWidth(element?.columnHeadersBorder.pen, false)
                      "
                      [style.border-right-width]="
                        idx != element.columns.length - 1
                          ? columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == idx + 1
                            ? getBorderWidth(element?.gridLines.pen, true)
                            : getBorderWidth(element?.gridLines.pen, false)
                          : element?.columnHeadersBorder.drawRight
                          ? columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == idx + 1
                            ? getBorderWidth(element?.columnHeadersBorder.pen, true)
                            : getBorderWidth(element?.columnHeadersBorder.pen, false)
                          : columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == idx + 1
                          ? getBorderWidth(element?.border.pen, true)
                          : getBorderWidth(element?.border.pen, false)
                      "
                      [style.padding]="'5px 0px 5px 5px'"
                    >
                      <sti-editable-content-component
                        [eParent]="element"
                        [editableContent]="column"
                        [alignment]="column?.headerAlignment"
                        [isTableHeader]="true"
                        [style.width]="'100%'"
                        [hideEmpty]="false"
                        [active]="selected"
                      ></sti-editable-content-component>
                      <sti-table-column-resizer
                        [resizableItem]="column"
                        [element]="element"
                        [index]="idx"
                        *ngIf="idx != element.columns.length - 1"
                        [style.height]="'100%'"
                      ></sti-table-column-resizer>
                    </th>
                  </tr>
                </thead>
                <tbody #tBody>
                  <tr *ngFor="let rowLabel of element.rowLabelsContentEditable; index as i" #tableRow>
                    <td
                      *ngIf="element?.showRowLabels"
                      [attr.data-label]="element.tableHeaderText"
                      [id]="0"
                      (mousemove)="columnDraggableService.fromTable ? (columnDraggableService.insertIndex = 0) : return"
                      [style]="element.font.htmlStyle()"
                      [style.justify-content]="rowAlignment"
                      [style.color]="getColumnForeColor(rowLabel, i)"
                      [style.width.px]="!isClone ? element?.rowLabelsWidth : 0"
                      [style.background-color]="getColumnBackColor(rowLabel, i)"
                      [style.border-left]="
                        getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawLeft) != 'transparent'
                          ? getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawLeft)
                          : getBorder(element?.border.pen, element?.border.drawLeft)
                      "
                      [style.border-bottom]="
                        getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawBottom) != 'transparent'
                          ? i == element.rowLabels.length - 1
                            ? getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawBottom)
                            : getBorder(element?.gridLines.pen, element?.gridLines.drawHorizontal)
                          : i == element.rowLabels.length - 1
                          ? getBorder(element?.border.pen, element?.border.drawBottom)
                          : getBorder(element?.gridLines.pen, element?.gridLines.drawHorizontal)
                      "
                      [style.border-right]="
                        element.columns.length > 0
                          ? ''
                          : getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawRight) !=
                            'transparent'
                          ? getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawRight)
                          : getBorder(element?.border.pen, element?.border.drawRight)
                      "
                    >
                      <sti-editable-content-component
                        [eParent]="element"
                        [editableContent]="rowLabel"
                        [displayContent]="rowLabel?.displayValue"
                        [alignment]="element?.rowLabelsHorizontalAlignment"
                        [style.width]="'100%'"
                        [hideEmpty]="false"
                        [active]="selected"
                      ></sti-editable-content-component>
                    </td>
                    <td
                      *ngFor="let column of element.columns; index as ind"
                      [attr.data-label]="column.label"
                      [id]="ind + 1"
                      (mousedown)="updatePropertyGrid(column, $event)"
                      (mousemove)="
                        columnDraggableService.fromTable ? (columnDraggableService.insertIndex = ind + 1) : return
                      "
                      class="drag-item sti-table-td"
                      [style.justify-content]="getColumnAlignment(column)"
                      [style.color]="getColumnForeColor(column, i)"
                      [style.background-color]="getColumnBackColor(column, i)"
                      [style.width.px]="
                        !isClone ? (ind == element.columns.length - 1 ? column?.width + 0.04 : column?.width) : 0
                      "
                      [style.transition]="columnDraggableService.fromTable ? 'border-width 50ms linear' : ''"
                      [style.border-left]="
                        ind == 0
                          ? getBorder(
                              element?.rowHeadersBorder.pen,
                              element?.rowHeadersBorder.drawRight,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == 0 &&
                                ind == 0
                                ? true
                                : false
                            )
                          : ''
                      "
                      [style.border-bottom]="
                        i == element.rowLabels.length - 1
                          ? getBorder(element?.border.pen, element?.border.drawBottom)
                          : getBorder(element?.gridLines.pen, element?.gridLines.drawHorizontal)
                      "
                      [style.border-right]="
                        ind == element.columns.length - 1
                          ? getBorder(
                              element?.border.pen,
                              element?.border.drawRight,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == ind + 1
                                ? true
                                : false
                            )
                          : getBorder(
                              element?.gridLines.pen,
                              element?.gridLines.drawVertical,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == ind + 1
                                ? true
                                : false
                            )
                      "
                      [style.border-left-width]="
                        columnDraggableService.parentElement == element &&
                        columnDraggableService.fromTable &&
                        columnDraggableService.insertIndex == 0 &&
                        ind == 0
                          ? getBorderWidth(element?.rowHeadersBorder.pen, true)
                          : getBorderWidth(element?.rowHeadersBorder.pen, false)
                      "
                      [style.border-right-width]="
                        ind != element.columns.length - 1
                          ? columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == ind + 1
                            ? getBorderWidth(element?.gridLines.pen, true)
                            : getBorderWidth(element?.gridLines.pen, false)
                          : element?.columnHeadersBorder.drawRight
                          ? columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == ind + 1
                            ? getBorderWidth(element?.border.pen, true)
                            : getBorderWidth(element?.border.pen, false)
                          : columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == ind + 1
                          ? getBorderWidth(element?.border.pen, true)
                          : getBorderWidth(element?.border.pen, false)
                      "
                    >
                      <sti-table-column-component
                        [column]="column"
                        [index]="i"
                        [element]="element"
                        [style.width]="'100%'"
                      ></sti-table-column-component>
                    </td>
                  </tr>
                </tbody>
              </table>
              <div
                class="right"
                *ngIf="
                  element == model.selectedComponent?.element &&
                  model.draggingElement != element &&
                  !model.previewMode
                "
              >
                <div class="right-control-panel">
                  <div
                    class="add control-button"
                    [style.margin-bottom.px]="5"
                    [style.background-color]="getPageColor()"
                    (click)="addColumn()"
                  >
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                      <rect class="plus" width="16" height="16" [attr.fill]="getPageColor()" />
                      <path
                        d="M11.5656 8.905H8.97358V11.5656H7.16329V8.905H4.57129V7.23186H7.16329V4.57129H8.97358V7.23186H11.5656V8.905Z"
                        fill="#898989"
                      />
                    </svg>
                  </div>
                  <div
                    class="delete control-button {{ canDeleteColumn() ? '' : 'disabled' }}"
                    [style.background-color]="getPageColor()"
                    (click)="deleteColumn()"
                  >
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                      <path
                        d="M6 8H8H10"
                        stroke="#898989"
                        stroke-width="2"
                        stroke-linecap="square"
                        stroke-linejoin="round"
                      />
                    </svg>
                  </div>
                </div>
              </div>
            </div>
            <div
              class="bottom"
              *ngIf="
                (element == model.selectedComponent?.element &&
                  model.draggingElement != element &&
                  !model.previewMode) ||
                (model.previewMode && !element.readOnly && element.dynamicRows && isActive)
              "
            >
              <div class="bottom-control-panel">
                <div
                  class="add control-button {{ canAddRow ? '' : 'disabled' }}"
                  [style.margin-right.px]="5"
                  [style.background-color]="getPageColor()"
                  (click)="addRow()"
                >
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <rect class="plus" width="16" height="16" [attr.fill]="getPageColor()" />
                    <path
                      d="M11.5656 8.905H8.97358V11.5656H7.16329V8.905H4.57129V7.23186H7.16329V4.57129H8.97358V7.23186H11.5656V8.905Z"
                      fill="#898989"
                    />
                  </svg>
                </div>
                <div
                  class="delete control-button {{ canDeleteRow ? '' : 'disabled' }}"
                  [style.background-color]="getPageColor()"
                  (click)="deleteRow()"
                >
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <path
                      d="M6 8H8H10"
                      stroke="#898989"
                      stroke-width="2"
                      stroke-linecap="square"
                      stroke-linejoin="round"
                    />
                  </svg>
                </div>
              </div>
            </div>
          </div>
          <div class="totals" *ngIf="element?.useTotals" #totals>
            <div
              class="totals-header"
              [style.align-items]="totalVerticalAlignment"
              [style.justify-content]="totalHorizontalAlignment"
            >
              <sti-editable-content-component
                [editableContent]="element.totalsRowHeaderEditableContent"
                [hideEmpty]="false"
                [active]="selected"
                [isTableTotalHeader]="true"
              ></sti-editable-content-component>
            </div>
            <div class="totals-fields">
              <sti-table-totals-field-component
                [fields]="element.totalsFields"
                [object]="element"
              ></sti-table-totals-field-component>
            </div>
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0" #description>
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, isInline: true, styles: [".outer-table table{border-spacing:0}.outer-table tr{height:max-content;padding:0;margin:0}.outer-table td{height:100%;padding:0;margin:0}.add{border-radius:3px;background-color:transparent;display:flex;border:1px solid lightGray;justify-content:center;align-items:center;z-index:100}.disabled{opacity:.5;pointer-events:none}.right{width:0px;background-color:transparent;position:relative}.right-control-panel{height:55px;width:18px;left:3px;top:calc(50% - 22.5px);position:absolute;display:flex;flex-direction:column}.right-control-panel .control-button{height:25px}.control-button{border-radius:3px;background-color:transparent;display:flex;border:1px solid lightGray;justify-content:center;align-items:center;z-index:100}.control-button:hover{background-color:#d3d3d3!important;cursor:default}.control-button:hover .plus{fill:#d3d3d3!important;cursor:default}.bottom-control-panel{height:18px;width:55px;top:3px;left:calc(50% - 22.5px);position:absolute;display:flex}.bottom-control-panel .control-button{width:25px}.bottom{width:calc(100% - 5px);height:0px;background-color:transparent;position:relative}.table-content{min-width:260px;width:100%;display:inline-block;flex-direction:column;flex:1}table,th,td{border-collapse:collapse}th{position:relative}.sti-table th,.sti-table td{display:flex;flex-direction:row;align-items:center;overflow:hidden;padding:4px;height:auto}.sti-table table{width:100%;margin:0;padding:0;display:inline-table;table-layout:auto;border-collapse:collapse;border-spacing:0;overflow:hidden}.sti-table th{padding:3px}.sti-table tr{display:flex;flex-direction:row;flex:1}.totals{width:100%;display:flex;min-height:5px;margin-top:5px;overflow:hidden}.totals-header{display:flex;flex:1;padding:4px 0}\n"], dependencies: [{ kind: "directive", type: i6.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i6.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i7.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i8.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "component", type: i9.StiTableTotalsFieldComponent, selector: "sti-table-totals-field-component", inputs: ["fields", "object", "isClone"] }, { kind: "component", type: i10.StiTableColumnResizerComponent, selector: "sti-table-column-resizer", inputs: ["resizableItem", "element", "index"] }, { kind: "component", type: i11.StiTableColumnComponent, selector: "sti-table-column-component", inputs: ["column", "index", "element"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-table-component", template: ` <sti-component
    [element]="element"
    [isClone]="isClone"
    (mouseenter)="model.previewMode ? (isActive = true) : ''"
    (mouseleave)="model.previewMode ? (isActive = false) : ''"
  >
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [style.align-self]="align"
      [style.text-align]="contentAlign"
      [editableContent]="element.label"
      [style.width]="width"
    ></sti-editable-content-component>
    <table
      class="outer-table"
      [style.width]="'100%'"
      [style.height]="'max-content'"
      [style.margin-top.px]="element?.getTopMargin()"
    >
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
          #label
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <div class="sti-table" #table>
            <div [style.display]="'flex'">
              <table
                class="column-drop-area"
                [style.background-color]="element?.backgroundColor.toHtmlColor()"
                [style.align-self]="align"
              >
                <thead>
                  <tr #tableTr>
                    <th
                      *ngIf="element?.showRowLabels"
                      [id]="0"
                      (mousemove)="columnDraggableService.fromTable ? (columnDraggableService.insertIndex = 0) : return"
                      [style.justify-content]="headerAlignment"
                      [style.color]="element?.tableHeaderColor.toHtmlColor()"
                      [style.background-color]="element?.tableHeaderBackgroundColor.toHtmlColor()"
                      [style.width.px]="!isClone ? element?.rowLabelsWidth : 0"
                      [style.max-height.px]="
                        !isClone && !model.pdfPreviewMode && isInitialized && isOverMaxHeight()
                          ? getMaxHeight()
                          : 'auto'
                      "
                      [style.border-top]="getBorder(element?.border.pen, element?.border.drawTop)"
                      [style.border-left]="getBorder(element?.border.pen, element?.border.drawLeft)"
                      [style.border-bottom]="
                        getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawTop)
                      "
                      [style.border-right]="
                        element.columns.length > 0 ? '' : getBorder(element?.border.pen, element?.border.drawRight)
                      "
                      [style.padding]="'5px 0px 5px 5px'"
                    >
                      <sti-editable-content-component
                        [editableContent]="element"
                        [alignment]="element?.tableHeaderAlignment"
                        [isTableHeader]="true"
                        [style.width]="'100%'"
                        [hideEmpty]="false"
                        [active]="selected"
                      ></sti-editable-content-component>
                      <sti-table-column-resizer
                        [resizableItem]="element"
                        [element]="element"
                        [style.height]="'100%'"
                      ></sti-table-column-resizer>
                    </th>
                    <th
                      *ngFor="let column of element.columns; index as idx"
                      [id]="idx + 1"
                      (mousemove)="
                        columnDraggableService.fromTable ? (columnDraggableService.insertIndex = idx + 1) : return
                      "
                      class="drag-item sti-table-th"
                      (click)="model.showColumnPreview(idx)"
                      [style]="element.font.htmlStyle()"
                      [style.justify-content]="getColumnAlignment(column)"
                      (mousedown)="onHeaderClick($event, column)"
                      [style.color]="column?.headerForeColor.toHtmlColor()"
                      [style.background-color]="column?.headerBackColor.toHtmlColor()"
                      [style.width.px]="!isClone ? column?.width : 0"
                      [style.height.px]="
                        isClone && !model.pdfPreviewMode ? element?.element?.nativeElement?.clientHeight : 'auto'
                      "
                      [style.max-height.px]="
                        !isClone && !model.pdfPreviewMode && isInitialized && isOverMaxHeight()
                          ? getMaxHeight()
                          : 'auto'
                      "
                      [style.transition]="columnDraggableService.fromTable ? 'border-width 50ms linear' : ''"
                      [style.border-top]="
                        getBorder(element?.columnHeadersBorder.pen, element?.columnHeadersBorder.drawTop) !=
                        'transparent'
                          ? getBorder(element?.columnHeadersBorder.pen, element?.columnHeadersBorder.drawTop)
                          : getBorder(element?.border.pen, element?.border.drawTop)
                      "
                      [style.border-bottom]="
                        getBorder(element?.columnHeadersBorder.pen, element?.columnHeadersBorder.drawBottom)
                      "
                      [style.border-right]="
                        getBorder(
                          element?.columnHeadersBorder.pen,
                          element?.columnHeadersBorder.drawRight,
                          columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == idx + 1
                            ? true
                            : false
                        ) != 'transparent'
                          ? idx == element.columns.length - 1
                            ? getBorder(
                                element?.columnHeadersBorder.pen,
                                element?.columnHeadersBorder.drawRight,
                                columnDraggableService.parentElement == element &&
                                  columnDraggableService.fromTable &&
                                  columnDraggableService.insertIndex == idx + 1
                                  ? true
                                  : false
                              )
                            : getBorder(
                                element?.gridLines.pen,
                                element?.gridLines.drawVertical,
                                columnDraggableService.parentElement == element &&
                                  columnDraggableService.fromTable &&
                                  columnDraggableService.insertIndex == idx + 1
                                  ? true
                                  : false
                              )
                          : idx == element.columns.length - 1
                          ? getBorder(
                              element?.border.pen,
                              element?.border.drawRight,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == idx + 1
                                ? true
                                : false
                            )
                          : getBorder(
                              element?.gridLines.pen,
                              element?.gridLines.drawVertical,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == idx + 1
                                ? true
                                : false
                            )
                      "
                      [style.border-left]="
                        idx == 0
                          ? getBorder(
                              element?.columnHeadersBorder.pen,
                              element?.columnHeadersBorder.drawLeft,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == 0 &&
                                idx == 0
                                ? true
                                : false
                            )
                          : ''
                      "
                      [style.border-left-width]="
                        columnDraggableService.parentElement == element &&
                        columnDraggableService.fromTable &&
                        columnDraggableService.insertIndex == 0 &&
                        idx == 0
                          ? getBorderWidth(element?.columnHeadersBorder.pen, true)
                          : getBorderWidth(element?.columnHeadersBorder.pen, false)
                      "
                      [style.border-right-width]="
                        idx != element.columns.length - 1
                          ? columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == idx + 1
                            ? getBorderWidth(element?.gridLines.pen, true)
                            : getBorderWidth(element?.gridLines.pen, false)
                          : element?.columnHeadersBorder.drawRight
                          ? columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == idx + 1
                            ? getBorderWidth(element?.columnHeadersBorder.pen, true)
                            : getBorderWidth(element?.columnHeadersBorder.pen, false)
                          : columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == idx + 1
                          ? getBorderWidth(element?.border.pen, true)
                          : getBorderWidth(element?.border.pen, false)
                      "
                      [style.padding]="'5px 0px 5px 5px'"
                    >
                      <sti-editable-content-component
                        [eParent]="element"
                        [editableContent]="column"
                        [alignment]="column?.headerAlignment"
                        [isTableHeader]="true"
                        [style.width]="'100%'"
                        [hideEmpty]="false"
                        [active]="selected"
                      ></sti-editable-content-component>
                      <sti-table-column-resizer
                        [resizableItem]="column"
                        [element]="element"
                        [index]="idx"
                        *ngIf="idx != element.columns.length - 1"
                        [style.height]="'100%'"
                      ></sti-table-column-resizer>
                    </th>
                  </tr>
                </thead>
                <tbody #tBody>
                  <tr *ngFor="let rowLabel of element.rowLabelsContentEditable; index as i" #tableRow>
                    <td
                      *ngIf="element?.showRowLabels"
                      [attr.data-label]="element.tableHeaderText"
                      [id]="0"
                      (mousemove)="columnDraggableService.fromTable ? (columnDraggableService.insertIndex = 0) : return"
                      [style]="element.font.htmlStyle()"
                      [style.justify-content]="rowAlignment"
                      [style.color]="getColumnForeColor(rowLabel, i)"
                      [style.width.px]="!isClone ? element?.rowLabelsWidth : 0"
                      [style.background-color]="getColumnBackColor(rowLabel, i)"
                      [style.border-left]="
                        getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawLeft) != 'transparent'
                          ? getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawLeft)
                          : getBorder(element?.border.pen, element?.border.drawLeft)
                      "
                      [style.border-bottom]="
                        getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawBottom) != 'transparent'
                          ? i == element.rowLabels.length - 1
                            ? getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawBottom)
                            : getBorder(element?.gridLines.pen, element?.gridLines.drawHorizontal)
                          : i == element.rowLabels.length - 1
                          ? getBorder(element?.border.pen, element?.border.drawBottom)
                          : getBorder(element?.gridLines.pen, element?.gridLines.drawHorizontal)
                      "
                      [style.border-right]="
                        element.columns.length > 0
                          ? ''
                          : getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawRight) !=
                            'transparent'
                          ? getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawRight)
                          : getBorder(element?.border.pen, element?.border.drawRight)
                      "
                    >
                      <sti-editable-content-component
                        [eParent]="element"
                        [editableContent]="rowLabel"
                        [displayContent]="rowLabel?.displayValue"
                        [alignment]="element?.rowLabelsHorizontalAlignment"
                        [style.width]="'100%'"
                        [hideEmpty]="false"
                        [active]="selected"
                      ></sti-editable-content-component>
                    </td>
                    <td
                      *ngFor="let column of element.columns; index as ind"
                      [attr.data-label]="column.label"
                      [id]="ind + 1"
                      (mousedown)="updatePropertyGrid(column, $event)"
                      (mousemove)="
                        columnDraggableService.fromTable ? (columnDraggableService.insertIndex = ind + 1) : return
                      "
                      class="drag-item sti-table-td"
                      [style.justify-content]="getColumnAlignment(column)"
                      [style.color]="getColumnForeColor(column, i)"
                      [style.background-color]="getColumnBackColor(column, i)"
                      [style.width.px]="
                        !isClone ? (ind == element.columns.length - 1 ? column?.width + 0.04 : column?.width) : 0
                      "
                      [style.transition]="columnDraggableService.fromTable ? 'border-width 50ms linear' : ''"
                      [style.border-left]="
                        ind == 0
                          ? getBorder(
                              element?.rowHeadersBorder.pen,
                              element?.rowHeadersBorder.drawRight,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == 0 &&
                                ind == 0
                                ? true
                                : false
                            )
                          : ''
                      "
                      [style.border-bottom]="
                        i == element.rowLabels.length - 1
                          ? getBorder(element?.border.pen, element?.border.drawBottom)
                          : getBorder(element?.gridLines.pen, element?.gridLines.drawHorizontal)
                      "
                      [style.border-right]="
                        ind == element.columns.length - 1
                          ? getBorder(
                              element?.border.pen,
                              element?.border.drawRight,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == ind + 1
                                ? true
                                : false
                            )
                          : getBorder(
                              element?.gridLines.pen,
                              element?.gridLines.drawVertical,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == ind + 1
                                ? true
                                : false
                            )
                      "
                      [style.border-left-width]="
                        columnDraggableService.parentElement == element &&
                        columnDraggableService.fromTable &&
                        columnDraggableService.insertIndex == 0 &&
                        ind == 0
                          ? getBorderWidth(element?.rowHeadersBorder.pen, true)
                          : getBorderWidth(element?.rowHeadersBorder.pen, false)
                      "
                      [style.border-right-width]="
                        ind != element.columns.length - 1
                          ? columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == ind + 1
                            ? getBorderWidth(element?.gridLines.pen, true)
                            : getBorderWidth(element?.gridLines.pen, false)
                          : element?.columnHeadersBorder.drawRight
                          ? columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == ind + 1
                            ? getBorderWidth(element?.border.pen, true)
                            : getBorderWidth(element?.border.pen, false)
                          : columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == ind + 1
                          ? getBorderWidth(element?.border.pen, true)
                          : getBorderWidth(element?.border.pen, false)
                      "
                    >
                      <sti-table-column-component
                        [column]="column"
                        [index]="i"
                        [element]="element"
                        [style.width]="'100%'"
                      ></sti-table-column-component>
                    </td>
                  </tr>
                </tbody>
              </table>
              <div
                class="right"
                *ngIf="
                  element == model.selectedComponent?.element &&
                  model.draggingElement != element &&
                  !model.previewMode
                "
              >
                <div class="right-control-panel">
                  <div
                    class="add control-button"
                    [style.margin-bottom.px]="5"
                    [style.background-color]="getPageColor()"
                    (click)="addColumn()"
                  >
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                      <rect class="plus" width="16" height="16" [attr.fill]="getPageColor()" />
                      <path
                        d="M11.5656 8.905H8.97358V11.5656H7.16329V8.905H4.57129V7.23186H7.16329V4.57129H8.97358V7.23186H11.5656V8.905Z"
                        fill="#898989"
                      />
                    </svg>
                  </div>
                  <div
                    class="delete control-button {{ canDeleteColumn() ? '' : 'disabled' }}"
                    [style.background-color]="getPageColor()"
                    (click)="deleteColumn()"
                  >
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                      <path
                        d="M6 8H8H10"
                        stroke="#898989"
                        stroke-width="2"
                        stroke-linecap="square"
                        stroke-linejoin="round"
                      />
                    </svg>
                  </div>
                </div>
              </div>
            </div>
            <div
              class="bottom"
              *ngIf="
                (element == model.selectedComponent?.element &&
                  model.draggingElement != element &&
                  !model.previewMode) ||
                (model.previewMode && !element.readOnly && element.dynamicRows && isActive)
              "
            >
              <div class="bottom-control-panel">
                <div
                  class="add control-button {{ canAddRow ? '' : 'disabled' }}"
                  [style.margin-right.px]="5"
                  [style.background-color]="getPageColor()"
                  (click)="addRow()"
                >
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <rect class="plus" width="16" height="16" [attr.fill]="getPageColor()" />
                    <path
                      d="M11.5656 8.905H8.97358V11.5656H7.16329V8.905H4.57129V7.23186H7.16329V4.57129H8.97358V7.23186H11.5656V8.905Z"
                      fill="#898989"
                    />
                  </svg>
                </div>
                <div
                  class="delete control-button {{ canDeleteRow ? '' : 'disabled' }}"
                  [style.background-color]="getPageColor()"
                  (click)="deleteRow()"
                >
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <path
                      d="M6 8H8H10"
                      stroke="#898989"
                      stroke-width="2"
                      stroke-linecap="square"
                      stroke-linejoin="round"
                    />
                  </svg>
                </div>
              </div>
            </div>
          </div>
          <div class="totals" *ngIf="element?.useTotals" #totals>
            <div
              class="totals-header"
              [style.align-items]="totalVerticalAlignment"
              [style.justify-content]="totalHorizontalAlignment"
            >
              <sti-editable-content-component
                [editableContent]="element.totalsRowHeaderEditableContent"
                [hideEmpty]="false"
                [active]="selected"
                [isTableTotalHeader]="true"
              ></sti-editable-content-component>
            </div>
            <div class="totals-fields">
              <sti-table-totals-field-component
                [fields]="element.totalsFields"
                [object]="element"
              ></sti-table-totals-field-component>
            </div>
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0" #description>
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, styles: [".outer-table table{border-spacing:0}.outer-table tr{height:max-content;padding:0;margin:0}.outer-table td{height:100%;padding:0;margin:0}.add{border-radius:3px;background-color:transparent;display:flex;border:1px solid lightGray;justify-content:center;align-items:center;z-index:100}.disabled{opacity:.5;pointer-events:none}.right{width:0px;background-color:transparent;position:relative}.right-control-panel{height:55px;width:18px;left:3px;top:calc(50% - 22.5px);position:absolute;display:flex;flex-direction:column}.right-control-panel .control-button{height:25px}.control-button{border-radius:3px;background-color:transparent;display:flex;border:1px solid lightGray;justify-content:center;align-items:center;z-index:100}.control-button:hover{background-color:#d3d3d3!important;cursor:default}.control-button:hover .plus{fill:#d3d3d3!important;cursor:default}.bottom-control-panel{height:18px;width:55px;top:3px;left:calc(50% - 22.5px);position:absolute;display:flex}.bottom-control-panel .control-button{width:25px}.bottom{width:calc(100% - 5px);height:0px;background-color:transparent;position:relative}.table-content{min-width:260px;width:100%;display:inline-block;flex-direction:column;flex:1}table,th,td{border-collapse:collapse}th{position:relative}.sti-table th,.sti-table td{display:flex;flex-direction:row;align-items:center;overflow:hidden;padding:4px;height:auto}.sti-table table{width:100%;margin:0;padding:0;display:inline-table;table-layout:auto;border-collapse:collapse;border-spacing:0;overflow:hidden}.sti-table th{padding:3px}.sti-table tr{display:flex;flex-direction:row;flex:1}.totals{width:100%;display:flex;min-height:5px;margin-top:5px;overflow:hidden}.totals-header{display:flex;flex:1;padding:4px 0}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiDraggableService }, { type: i3.StiColumnDraggableService }, { type: i4.StiEditableContentService }, { type: i0.ChangeDetectorRef }, { type: i5.StiMouseService }], propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }], tableTr: [{
                type: ViewChild,
                args: ["tableTr"]
            }], tBody: [{
                type: ViewChild,
                args: ["tBody"]
            }], totals: [{
                type: ViewChild,
                args: ["totals"]
            }], table: [{
                type: ViewChild,
                args: ["table"]
            }], tableRow: [{
                type: ViewChild,
                args: ["tableRow"]
            }], componentDescription: [{
                type: ViewChild,
                args: ["description"]
            }], componentLabel: [{
                type: ViewChild,
                args: ["label"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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