import { Component, Input } from "@angular/core";
import { StiHorizontalAlignment, StiLabelAlignment } from "../../../system/enums";
import { StiTableElement } from "../../../elements/StiTableElement";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/model.service";
import * as i2 from "../../../services/mouse.service";
import * as i3 from "@angular/common";
import * as i4 from "../../sti-editable-content.component";
export class StiTableTotalsFieldComponent {
    get showResizePreview() {
        return this.object instanceof StiTableElement &&
            !this.object.gridLines.drawVertical &&
            this.model.selectedComponent.element == this.object
            ? true
            : false;
    }
    showPropertyInfo(field) {
        setTimeout(() => {
            if (this.model.selectedComponent?.element instanceof StiTableElement &&
                !this.model.selectedComponent?.element.showTotalsEditor) {
                this.model.selectedComponent.element.showTotalsEditor = true;
                this.model.needToRefresh.next(true);
            }
            setTimeout(() => {
                if (this.model.selectedComponent?.element instanceof StiTableElement) {
                    let index = this.model.selectedComponent.element.totalsFields.findIndex((column) => column == field);
                    this.model.currentContentEditableItem.next(index);
                }
            }, 0);
        }, 0);
    }
    getAlignment(value) {
        if (value == StiHorizontalAlignment.Left) {
            return "flex-start";
        }
        else if (value == StiHorizontalAlignment.Right) {
            return "flex-end";
        }
        else {
            return "center";
        }
    }
    get selected() {
        return this.model.selectedComponent?.element == this.object;
    }
    getValue(field) {
        let value = this.model.getFormattedValue(field, field.value);
        return `${field.prefix}${value != null && value != undefined ? value : ""}${field.suffix}`;
    }
    initResize(event, columnType) {
        event.stopPropagation();
        this.isResizing = true;
        this.startPoint = event.clientX;
        this.currentColumnType = columnType;
        if (columnType == "totalHeader") {
            this.startColumnWidth = this.object.totalsHeadersWidth;
            let tableWidth = this.object.label.alignment == StiLabelAlignment.Top || this.object.label.value.length == 0
                ? this.object.width - this.object.padding.left - this.object.padding.right
                : this.object.width - this.object.padding.left - this.object.padding.right - this.object.label.width;
            this.maxWidth = tableWidth - this.object.totalsValuesWidth;
            this.adjacentColumnWidth = this.maxWidth - this.object.totalsHeadersWidth;
        }
        else {
            this.startColumnWidth = this.object.totalsValuesWidth;
            this.maxWidth = this.object.totalsHeadersWidth + this.object.totalsValuesWidth;
            this.adjacentColumnWidth = this.object.totalsHeadersWidth;
        }
    }
    resize(event) {
        if (this.isResizing) {
            let delta = event.clientX - this.startPoint;
            if (this.startColumnWidth - delta >= this.minWidth && this.adjacentColumnWidth + delta >= this.minWidth) {
                if (this.currentColumnType == "totalHeader") {
                    this.object.totalsHeadersWidth = this.startColumnWidth - delta;
                }
                else {
                    this.object.totalsValuesWidth = this.startColumnWidth - delta;
                    this.object.totalsHeadersWidth = this.adjacentColumnWidth + delta;
                }
            }
            else {
                if (this.currentColumnType == "totalHeader") {
                    if (this.startColumnWidth - delta <= this.minWidth) {
                        this.object.totalsHeadersWidth = this.minWidth;
                    }
                    else if (this.adjacentColumnWidth + delta <= this.minWidth) {
                        this.object.totalsHeadersWidth = this.maxWidth - this.minWidth;
                    }
                }
                else {
                    if (this.startColumnWidth - delta <= this.minWidth) {
                        this.object.totalsValuesWidth = this.minWidth;
                        this.object.totalsHeadersWidth = this.maxWidth - this.minWidth;
                    }
                    else if (this.adjacentColumnWidth + delta <= this.minWidth) {
                        this.object.totalsValuesWidth = this.maxWidth - this.minWidth;
                        this.object.totalsHeadersWidth = this.minWidth;
                    }
                }
            }
        }
    }
    constructor(model, mouseService) {
        this.model = model;
        this.mouseService = mouseService;
        this.isClone = false;
        this.minWidth = 40;
        this.isResizing = false;
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe((event) => {
            this.isResizing = false;
        });
        this.mouseMoveSubscription = this.mouseService.getDocumentMouseMove().subscribe((event) => {
            this.resize(event);
        });
    }
    ngOnDestroy() {
        this.mouseUpSubscription?.unsubscribe();
        this.mouseMoveSubscription?.unsubscribe();
    }
    ngOnInit() {
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe((event) => {
            this.isResizing = false;
        });
        this.mouseMoveSubscription = this.mouseService.getDocumentMouseMove().subscribe((event) => {
            this.resize(event);
        });
        /*  if (this.object.loadedFromJson) {
          this.object.totalsFields.forEach((totalField) => {
            totalField.calculationAlgorithm.expression = StiAlgorithmExpression.NumberColumnSum;
    
          });
        } */
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableTotalsFieldComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiMouseService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiTableTotalsFieldComponent, selector: "sti-table-totals-field-component", inputs: { fields: "fields", object: "object", isClone: "isClone" }, ngImport: i0, template: ` <table>
    <tr *ngFor="let field of fields; index as i">
      <td
        class="field-header"
        [style.border-top]="
          i == 0 && selected && !model.previewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-bottom]="
          selected && !model.previewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-right]="
          selected && !model.previewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-left]="
          selected && !model.previewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.width.px]="object.totalsHeadersWidth"
        [style.justify-content]="getAlignment(field.headerAlignment)"
      >
        <div class="total-resizer" *ngIf="selected" (mousedown)="initResize($event, 'totalHeader')"></div>
        <sti-editable-content-component
          [editableContent]="field"
          [eParent]="object"
          [hideEmpty]="false"
          [active]="selected"
        ></sti-editable-content-component>
      </td>
      <td
        class="field-value"
        [style.border-top]="
          i == 0 && selected && !model.previewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-bottom]="
          selected && !model.previewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-right]="
          selected && !model.previewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.width.px]="object.totalsValuesWidth"
        [style.justify-content]="getAlignment(field.valueAlignment)"
      >
        <div class="total-resizer" *ngIf="selected" (mousedown)="initResize($event, 'totalValue')"></div>
        <label
          [style]="object.font.htmlStyle()"
          [style.text-decoration]="'none'"
          [style.color]="field.headerColor.toHtmlColor()"
          (mousedown)="showPropertyInfo(field)"
          >{{ getValue(field) }}
        </label>
      </td>
    </tr>
  </table>`, isInline: true, styles: ["table{border-spacing:0;border-collapse:collapse;overflow:hidden}td{padding:3px 1px;display:flex;position:relative;white-space:nowrap;overflow:hidden}tr{display:flex}label{width:max-content}.total-resizer{height:100%;width:5px;position:absolute;left:0;top:0}.total-resizer:hover{cursor:ew-resize}\n"], dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableTotalsFieldComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-table-totals-field-component", template: ` <table>
    <tr *ngFor="let field of fields; index as i">
      <td
        class="field-header"
        [style.border-top]="
          i == 0 && selected && !model.previewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-bottom]="
          selected && !model.previewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-right]="
          selected && !model.previewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-left]="
          selected && !model.previewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.width.px]="object.totalsHeadersWidth"
        [style.justify-content]="getAlignment(field.headerAlignment)"
      >
        <div class="total-resizer" *ngIf="selected" (mousedown)="initResize($event, 'totalHeader')"></div>
        <sti-editable-content-component
          [editableContent]="field"
          [eParent]="object"
          [hideEmpty]="false"
          [active]="selected"
        ></sti-editable-content-component>
      </td>
      <td
        class="field-value"
        [style.border-top]="
          i == 0 && selected && !model.previewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-bottom]="
          selected && !model.previewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-right]="
          selected && !model.previewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.width.px]="object.totalsValuesWidth"
        [style.justify-content]="getAlignment(field.valueAlignment)"
      >
        <div class="total-resizer" *ngIf="selected" (mousedown)="initResize($event, 'totalValue')"></div>
        <label
          [style]="object.font.htmlStyle()"
          [style.text-decoration]="'none'"
          [style.color]="field.headerColor.toHtmlColor()"
          (mousedown)="showPropertyInfo(field)"
          >{{ getValue(field) }}
        </label>
      </td>
    </tr>
  </table>`, styles: ["table{border-spacing:0;border-collapse:collapse;overflow:hidden}td{padding:3px 1px;display:flex;position:relative;white-space:nowrap;overflow:hidden}tr{display:flex}label{width:max-content}.total-resizer{height:100%;width:5px;position:absolute;left:0;top:0}.total-resizer:hover{cursor:ew-resize}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiMouseService }], propDecorators: { fields: [{
                type: Input
            }], object: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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