import { Component, EventEmitter, Input, Output } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/model.service";
import * as i2 from "@angular/common";
export class StiTableRadioButtonComponent {
    get cell() {
        return this.item.cells[this.index];
    }
    constructor(model) {
        this.model = model;
        this.isClone = false;
        this.buttonClick = new EventEmitter();
    }
    changeState() {
        this.buttonClick.emit();
    }
    ngOnInit() { }
    get tabIndex() {
        try {
            let columns = this.object.columns;
            return this.object["tabIndex"] + columns.indexOf(this.item) + columns.length * this.index;
        }
        catch { }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableRadioButtonComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiTableRadioButtonComponent, selector: "sti-table-radio-button-component", inputs: { item: "item", index: "index", disabled: "disabled", isClone: "isClone", object: "object", alignment: "alignment" }, outputs: { buttonClick: "buttonClick" }, ngImport: i0, template: `<div
    class="custom-radio"
    [style.justify-content]="alignment"
    (mousedown)="model.canDrag = false"
    (mouseup)="model.canDrag = true"
  >
    <input type="radio" (click)="changeState()" [disabled]="disabled" [tabIndex]="tabIndex" />
    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
      <circle
        class="box"
        cx="6"
        cy="6"
        r="5.5"
        [attr.fill]="item.cellBackColor.toHtmlColor()"
        [attr.stroke]="item.cellBorderColor.toHtmlColor()"
      />
      <circle
        *ngIf="cell?.isChecked"
        class="check"
        cx="6"
        cy="6"
        r="2.5"
        [attr.fill]="item.cellForeColor.toHtmlColor()"
      />
    </svg>
  </div>`, isInline: true, styles: ["input[type=radio]:hover+svg .box{stroke:#a3bde3!important;fill:#f3f9ff!important}input[type=radio]:active+svg .box{stroke:#3c77dd!important;fill:#d9ecff!important}input[type=radio]:disabled+svg .box{stroke:#bcbcbc!important;fill:#e6e6e6!important}label,span{margin-left:5px}.box:hover:{stroke:#a3bde3!important}.custom-radio{width:fit-content;position:relative;align-items:center;display:flex;width:100%}.custom-radio input[type=radio]{position:absolute;width:100%;z-index:10;opacity:0}.other input[type=radio]{position:absolute;width:16px;z-index:10;opacity:0}\n"], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableRadioButtonComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-table-radio-button-component", template: `<div
    class="custom-radio"
    [style.justify-content]="alignment"
    (mousedown)="model.canDrag = false"
    (mouseup)="model.canDrag = true"
  >
    <input type="radio" (click)="changeState()" [disabled]="disabled" [tabIndex]="tabIndex" />
    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
      <circle
        class="box"
        cx="6"
        cy="6"
        r="5.5"
        [attr.fill]="item.cellBackColor.toHtmlColor()"
        [attr.stroke]="item.cellBorderColor.toHtmlColor()"
      />
      <circle
        *ngIf="cell?.isChecked"
        class="check"
        cx="6"
        cy="6"
        r="2.5"
        [attr.fill]="item.cellForeColor.toHtmlColor()"
      />
    </svg>
  </div>`, styles: ["input[type=radio]:hover+svg .box{stroke:#a3bde3!important;fill:#f3f9ff!important}input[type=radio]:active+svg .box{stroke:#3c77dd!important;fill:#d9ecff!important}input[type=radio]:disabled+svg .box{stroke:#bcbcbc!important;fill:#e6e6e6!important}label,span{margin-left:5px}.box:hover:{stroke:#a3bde3!important}.custom-radio{width:fit-content;position:relative;align-items:center;display:flex;width:100%}.custom-radio input[type=radio]{position:absolute;width:100%;z-index:10;opacity:0}.other input[type=radio]{position:absolute;width:16px;z-index:10;opacity:0}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }], propDecorators: { item: [{
                type: Input
            }], index: [{
                type: Input
            }], disabled: [{
                type: Input
            }], isClone: [{
                type: Input
            }], object: [{
                type: Input
            }], alignment: [{
                type: Input
            }], buttonClick: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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