import { Component, Input, ViewChild, } from "@angular/core";
import { StiHorizontalAlignment, StiLabelAlignment } from "../../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/mouse.service";
import * as i3 from "../../services/sti-component-resizer.service";
import * as i4 from "../../services/sti-localization.service";
import * as i5 from "../../services/sti-signature.service";
import * as i6 from "../../services/sti-helper.service";
import * as i7 from "../../services/sti-font.service";
import * as i8 from "@angular/common";
import * as i9 from "../sti-component";
import * as i10 from "../sti-editable-content.component";
export class StiSignatureComponent {
    isDrawingMode() {
        if (this.isCurrentEditableSignature) {
            return this.signatureService.selectedMode == "Draw";
        }
        else {
            return this.element.currentSignatureMode == "Draw";
        }
    }
    get isAspectRatio() {
        if (this.isCurrentEditableSignature) {
            return (this.signatureService?.currentEditableImage?.aspectRatio && this.signatureService?.currentEditableImage?.stretch);
        }
        else {
            return this.element?.insertedImage?.aspectRatio && this.element?.insertedImage?.stretch;
        }
    }
    get align() {
        return "start";
    }
    get isCurrentEditableSignature() {
        return (this.signatureService?.currentEditableSignatureElement == this.element &&
            this.model.showSignatureEditor &&
            !this.element.readOnly &&
            !this.isClone);
    }
    getImageWidth(parentContainer) {
        if (this.isInitialized && parentContainer) {
            return this.isAspectRatio
                ? parentContainer.clientHeight > parentContainer.clientWidth
                    ? parentContainer.clientWidth
                    : parentContainer.clientHeight
                : parentContainer.clientWidth;
        }
        else {
            return 0;
        }
    }
    get cursor() {
        return this.signatureService.drawingMode
            ? `url(${this.model.getImage("signature.Brush.png")}) 8 ${16 * window.devicePixelRatio - 4 * window.devicePixelRatio}, auto`
            : "";
    }
    isOldVersion() {
        if (this.element.backgroundImage &&
            !this.element.insertedImage.loadedImage &&
            !this.element.drawedImage &&
            !this.element.insertedText.value &&
            !this.element.fullName &&
            !this.element.initials) {
            return true;
        }
        else
            return false;
    }
    getInsertedTextValue() {
        if (this.isCurrentEditableSignature) {
            return this.signatureService.selectedMode === "Draw" ? this.signatureService?.currentEditableText?.value : "";
        }
        else {
            return this.element.currentSignatureMode === "Draw" ? this.element?.insertedText?.value : "";
        }
    }
    getTypeTextValue() {
        if (this.isCurrentEditableSignature) {
            return this.signatureService.selectedMode === "Type"
                ? `${this.signatureService.currentEditableFullName} ${this.signatureService.currentEditableInitials}`
                : "";
        }
        else {
            return this.element.currentSignatureMode === "Type" ? `${this.element?.fullName} ${this.element?.initials}` : "";
        }
    }
    showSignatureEditor() {
        if (!this.isClone) {
            this.signatureService.currentSignatureElement = this.helper.clone(this.element);
            this.signatureService.currentEditableImage = this.signatureService.currentSignatureElement.insertedImage;
            this.signatureService.currentEditableText = this.signatureService.currentSignatureElement.insertedText;
            this.signatureService.currentCanvasContent = this.element.drawedImage;
            this.signatureService.currentEditableFullName = this.element.fullName;
            this.signatureService.currentEditableInitials = this.element.initials;
            this.signatureService.selectedMode = this.element.currentSignatureMode;
            this.signatureService.currentPreviewFont = this.element.specialFont;
            this.signatureService.currentEditableSignatureElement = this.element;
            this.model.showSignatureEditor = !this.model.showSignatureEditor;
        }
    }
    get canvasWidth() {
        if (this.isClone) {
            return 0;
        }
        else {
            if (this.element["label"]["alignment"] != StiLabelAlignment.Top && this.element["label"]["value"]) {
                return (this.element.width - this.element.label.width - this.element.padding.right - this.element.padding.left - 2);
            }
            else {
                return this.element.width - this.element.padding.right - this.element.padding.left;
            }
        }
    }
    get oldBackgroundImage() {
        return this.getUrlImage(this.element.backgroundImage);
    }
    get image() {
        return this.isCurrentEditableSignature && this.signatureService.selectedMode == "Draw"
            ? this.getUrlImage(this.signatureService?.currentEditableImage?.loadedImage)
            : this.isCurrentEditableSignature && this.signatureService.selectedMode == "Type"
                ? ""
                : this.getUrlImage(this.element?.insertedImage?.loadedImage);
    }
    get drawedImage() {
        return this.isCurrentEditableSignature && this.signatureService.selectedMode == "Draw"
            ? this.getUrlImage(this.signatureService?.currentCanvasContent)
            : this.isCurrentEditableSignature && this.signatureService.selectedMode == "Type"
                ? ""
                : this.getUrlImage(this.element?.drawedImage);
    }
    getUrlImage(image) {
        return image ? "url(" + image + ")" : null;
    }
    get alignment() {
        if (this.isCurrentEditableSignature) {
            if (this.signatureService.selectedMode == "Type") {
                return "start";
            }
            else {
                if (this.signatureService?.currentEditableText?.horizontalAlignment == StiHorizontalAlignment.Center) {
                    return "center";
                }
                else if (this.signatureService?.currentEditableText?.horizontalAlignment == StiHorizontalAlignment.Right) {
                    return "end";
                }
                else {
                    return "start";
                }
            }
        }
        else {
            if (this.element.currentSignatureMode == "Type") {
                return "start";
            }
            else {
                if (this.element?.insertedText?.horizontalAlignment == StiHorizontalAlignment.Center) {
                    return "center";
                }
                else if (this.element?.insertedText?.horizontalAlignment == StiHorizontalAlignment.Right) {
                    return "end";
                }
                else {
                    return "start";
                }
            }
        }
    }
    getHorizontalAlignment() {
        if (this.isCurrentEditableSignature) {
            if (this.signatureService?.currentEditableImage?.horizontalAlignment == StiHorizontalAlignment.Center) {
                return "center";
            }
            else if (this.signatureService?.currentEditableImage?.horizontalAlignment == StiHorizontalAlignment.Left) {
                return "start";
            }
            else {
                return "end";
            }
        }
        else {
            if (this.element?.insertedImage?.horizontalAlignment == StiHorizontalAlignment.Center) {
                return "center";
            }
            else if (this.element?.insertedImage?.horizontalAlignment == StiHorizontalAlignment.Left) {
                return "start";
            }
            else {
                return "end";
            }
        }
    }
    getBackgroundSize(container) {
        if (this.isCurrentEditableSignature) {
            if (!this.signatureService?.currentEditableImage?.loadedImage) {
                return;
            }
            if (this.signatureService?.currentEditableImage?.aspectRatio &&
                this.signatureService?.currentEditableImage?.stretch) {
                return "contain";
            }
            if (this.signatureService?.currentEditableImage?.stretch) {
                return `${container.offsetWidth}px ${container.offsetHeight}px`;
            }
            else {
                return `${this.signatureService?.currentEditableImage?.naturalWidth}px ${this.signatureService?.currentEditableImage?.naturalHeight}px`;
            }
        }
        else {
            if (!this.element?.insertedImage?.loadedImage) {
                return;
            }
            if (this.element?.insertedImage?.aspectRatio && this.element?.insertedImage?.stretch) {
                return "contain";
            }
            if (this.element?.insertedImage?.stretch) {
                return `${container.offsetWidth}px ${container.offsetHeight}px`;
            }
            else {
                return `${this.element?.insertedImage?.naturalWidth}px ${this.element?.insertedImage?.naturalHeight}px`;
            }
        }
    }
    getCanvasSize(container) {
        return `${container.offsetWidth}px ${container.offsetHeight}px`;
    }
    getBackgroundPosition() {
        if (this.isCurrentEditableSignature) {
            if (this.signatureService?.currentEditableImage?.stretch &&
                !this.signatureService?.currentEditableImage?.aspectRatio) {
                return `center`;
            }
            else {
                return `${this.signatureService.getVerticalPosition(this.signatureService?.currentEditableImage?.verticalAlignment)} ${this.signatureService.getHorizontalPosition(this.signatureService?.currentEditableImage?.horizontalAlignment)}`;
            }
        }
        else {
            if (this.element?.insertedImage?.stretch && !this.element?.insertedImage?.aspectRatio) {
                return `center`;
            }
            else {
                return `${this.signatureService.getVerticalPosition(this.element?.insertedImage?.verticalAlignment)} ${this.signatureService.getHorizontalPosition(this.element?.insertedImage?.horizontalAlignment)}`;
            }
        }
    }
    get canvasHeight() {
        if (this.isClone) {
            return 0;
        }
        else {
            if (this.element["label"]["alignment"] != StiLabelAlignment.Top) {
                return this.element.height - this.element.padding.top - this.element.padding.bottom;
            }
            else {
                return (this.element.height -
                    (this.labelRef?.offsetHeight ? this.labelRef?.offsetHeight : 0) -
                    this.element.padding.top -
                    this.element.padding.bottom -
                    (this.labelRef?.offsetHeight ? this.topMargin : 0));
            }
        }
    }
    constructor(model, mouse, resize, loc, signatureService, helper, fontService, cdr) {
        this.model = model;
        this.mouse = mouse;
        this.resize = resize;
        this.loc = loc;
        this.signatureService = signatureService;
        this.helper = helper;
        this.fontService = fontService;
        this.cdr = cdr;
        this.isClone = false;
        this.topMargin = 8;
        this.drawingMode = false;
        this.textMode = false;
        this.isDrawing = false;
        this.loadedImage = false;
        this.isInitialized = false;
    }
    ngOnDestroy() {
        this.mouseUpSubscription?.unsubscribe();
        this.buttonClickSubscribe?.unsubscribe();
        this.loadedImageSubscribe?.unsubscribe();
    }
    ngDoCheck() {
        this.labelRef = this.label ? this.label["elementRef"]["nativeElement"] : null;
    }
    isCanvasBlank(canvas) {
        const context = canvas.getContext("2d");
        const pixelBuffer = new Uint32Array(context.getImageData(0, 0, canvas.width, canvas.height).data.buffer);
        return !pixelBuffer.some((color) => color !== 0);
    }
    ngAfterViewInit() {
        if (!this.isClone) {
            this.element.element = this.sigPad;
            this.cdr.detectChanges();
            this.sigPadElement = this.sigPad?.nativeElement;
            if (this.element.backgroundImage && this.context) {
                // this.drawImage(this.element.backgroundImage);
            }
            setTimeout(() => {
                this.isInitialized = true;
            });
        }
    }
    ngOnInit() {
        this.resize.EndResizeSubj.subscribe(() => this.UpdateState());
        this.loadedImageSubscribe = this.signatureService.loadedImage.subscribe((any) => {
            if (this.element == this.model.selectedComponent?.element) {
                this.loadedImage = true;
                // this.drawImage(any);
            }
        });
        this.fontService.loadSignatureFonts();
    }
    UpdateState() {
        if (!this.isClone) {
            // this.drawImage(this.element.backgroundImage);
        }
    }
    relativeCoords(event) {
        const bounds = this.model.getPositionRelativeToForm(this.sigPad.nativeElement);
        const x = (event.clientX - bounds.left) / this.model.zoom;
        const y = (event.clientY - bounds.top) / this.model.zoom;
        return { x: x, y: y };
    }
    clear() {
        if (!this.isClone) {
            this.context.clearRect(0, 0, this.sigPadElement.width, this.sigPadElement.height);
            this.context.beginPath();
            this.element.backgroundImage = "";
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiSignatureComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiMouseService }, { token: i3.StiComponentResizerService }, { token: i4.StiLocalizationService }, { token: i5.SignatureService }, { token: i6.StiHelperService }, { token: i7.StiFontService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiSignatureComponent, selector: "sti-signature-component", inputs: { element: "element", isClone: "isClone" }, viewQueries: [{ propertyName: "sigPad", first: true, predicate: ["sigPad"], descendants: true }, { propertyName: "ref", first: true, predicate: ["ref"], descendants: true }, { propertyName: "label", first: true, predicate: ["label"], descendants: true }], ngImport: i0, template: ` <sti-component
    [element]="element"
    [isClone]="isClone"
    class="sti-signature"
    (dblclick)="!model.previewMode ? showSignatureEditor() : ''"
    (click)="model.previewMode && !element.readOnly ? showSignatureEditor() : ''"
  >
    <div class="component-container" #previewContainer>
      <div
        class="signature-image-container"
        *ngIf="isOldVersion() && !isCurrentEditableSignature"
        [style.justify-content]="getHorizontalAlignment()"
      >
        <div
          class="signature-image"
          [style.background-image]="oldBackgroundImage"
          [style.background-position]="'center'"
          [style.background-size]="'contain'"
          [style.background-repeat]="'no-repeat'"
        ></div>
      </div>
      <div class="inserted-image-container" [style.justify-content]="getHorizontalAlignment()">
        <div
          class="preview-inserted-image"
          *ngIf="isDrawingMode()"
          [style.width.px]="getImageWidth(previewContainer)"
          [style.height.px]="previewContainer.clientHeight"
          [style.background-image]="image"
          [style.background-position]="getBackgroundPosition()"
          [style.background-size]="getBackgroundSize(previewContainer)"
          [style.background-repeat]="image ? 'no-repeat' : ''"
        ></div>
        <div
          *ngIf="isDrawingMode()"
          class="preview-drawed-image"
          [style.background-size]="'contain'"
          [style.background-image]="drawedImage"
        ></div>
      </div>
      <div
        class="preview-inserted-text"
        [style]="
          isCurrentEditableSignature
            ? signatureService?.currentEditableText?.htmlStyle()
            : element?.insertedText?.htmlStyle()
        "
        [style.justify-content]="alignment"
      >
        <span>{{ getInsertedTextValue() }}</span>
      </div>
      <div class="signature-content">
        <div
          class="preview-inserted-type-text"
          [style.font-family]="isCurrentEditableSignature ? signatureService.currentPreviewFont : element.specialFont"
          [style.font-size]="'16pt'"
          [style.justify-content]="alignment"
        >
          <span #sigPad>{{ getTypeTextValue() }}</span>
        </div>
      </div>
      <div class="signature-description" [style]="element?.description?.htmlStyle()">
        <sti-editable-content-component
          *ngIf="element?.description.value?.length > 0"
          [editableContent]="element.description"
        >
        </sti-editable-content-component>
      </div>
    </div>
  </sti-component>`, isInline: true, styles: [".signature-image,.preview-inserted-image{position:absolute;height:100%;width:100%}.preview-inserted-type-text{height:100%;width:100%;display:flex;align-items:flex-end;overflow:hidden;white-space:nowrap}.preview-inserted-text{position:absolute;width:100%;height:100%;display:flex;align-items:center;justify-content:center;overflow:hidden;white-space:nowrap}.signature-description{width:calc(100% - 10px);height:50px;margin:0 5px;padding:0 5px;border-top:1px solid lightgray;display:flex;align-items:center;overflow:hidden;z-index:100}.signature-content{z-index:9999;height:100%;width:100%}.preview-drawed-image{position:absolute;width:100%;height:100%;background-position:center;background-repeat:no-repeat;z-index:100}.signature-image-container{position:absolute;left:0;top:0;display:flex;height:100%;width:100%;z-index:999}.inserted-image-container{position:absolute;left:0;top:0;display:flex;height:100%;width:100%}.component-container{width:100%;height:100%;display:flex;flex-direction:column;position:relative}table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.canvas{position:relative;cursor:inherit}.text-preview:focus{outline:none}.text-preview{position:absolute;white-space:nowrap;display:flex;align-items:center;justify-content:center;text-align:center;width:100%;height:100%;overflow-x:hidden;z-index:100;font-size:28px;cursor:text}input{visibility:hidden;width:0px}\n"], dependencies: [{ kind: "directive", type: i8.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i9.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i10.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiSignatureComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-signature-component", template: ` <sti-component
    [element]="element"
    [isClone]="isClone"
    class="sti-signature"
    (dblclick)="!model.previewMode ? showSignatureEditor() : ''"
    (click)="model.previewMode && !element.readOnly ? showSignatureEditor() : ''"
  >
    <div class="component-container" #previewContainer>
      <div
        class="signature-image-container"
        *ngIf="isOldVersion() && !isCurrentEditableSignature"
        [style.justify-content]="getHorizontalAlignment()"
      >
        <div
          class="signature-image"
          [style.background-image]="oldBackgroundImage"
          [style.background-position]="'center'"
          [style.background-size]="'contain'"
          [style.background-repeat]="'no-repeat'"
        ></div>
      </div>
      <div class="inserted-image-container" [style.justify-content]="getHorizontalAlignment()">
        <div
          class="preview-inserted-image"
          *ngIf="isDrawingMode()"
          [style.width.px]="getImageWidth(previewContainer)"
          [style.height.px]="previewContainer.clientHeight"
          [style.background-image]="image"
          [style.background-position]="getBackgroundPosition()"
          [style.background-size]="getBackgroundSize(previewContainer)"
          [style.background-repeat]="image ? 'no-repeat' : ''"
        ></div>
        <div
          *ngIf="isDrawingMode()"
          class="preview-drawed-image"
          [style.background-size]="'contain'"
          [style.background-image]="drawedImage"
        ></div>
      </div>
      <div
        class="preview-inserted-text"
        [style]="
          isCurrentEditableSignature
            ? signatureService?.currentEditableText?.htmlStyle()
            : element?.insertedText?.htmlStyle()
        "
        [style.justify-content]="alignment"
      >
        <span>{{ getInsertedTextValue() }}</span>
      </div>
      <div class="signature-content">
        <div
          class="preview-inserted-type-text"
          [style.font-family]="isCurrentEditableSignature ? signatureService.currentPreviewFont : element.specialFont"
          [style.font-size]="'16pt'"
          [style.justify-content]="alignment"
        >
          <span #sigPad>{{ getTypeTextValue() }}</span>
        </div>
      </div>
      <div class="signature-description" [style]="element?.description?.htmlStyle()">
        <sti-editable-content-component
          *ngIf="element?.description.value?.length > 0"
          [editableContent]="element.description"
        >
        </sti-editable-content-component>
      </div>
    </div>
  </sti-component>`, styles: [".signature-image,.preview-inserted-image{position:absolute;height:100%;width:100%}.preview-inserted-type-text{height:100%;width:100%;display:flex;align-items:flex-end;overflow:hidden;white-space:nowrap}.preview-inserted-text{position:absolute;width:100%;height:100%;display:flex;align-items:center;justify-content:center;overflow:hidden;white-space:nowrap}.signature-description{width:calc(100% - 10px);height:50px;margin:0 5px;padding:0 5px;border-top:1px solid lightgray;display:flex;align-items:center;overflow:hidden;z-index:100}.signature-content{z-index:9999;height:100%;width:100%}.preview-drawed-image{position:absolute;width:100%;height:100%;background-position:center;background-repeat:no-repeat;z-index:100}.signature-image-container{position:absolute;left:0;top:0;display:flex;height:100%;width:100%;z-index:999}.inserted-image-container{position:absolute;left:0;top:0;display:flex;height:100%;width:100%}.component-container{width:100%;height:100%;display:flex;flex-direction:column;position:relative}table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.canvas{position:relative;cursor:inherit}.text-preview:focus{outline:none}.text-preview{position:absolute;white-space:nowrap;display:flex;align-items:center;justify-content:center;text-align:center;width:100%;height:100%;overflow-x:hidden;z-index:100;font-size:28px;cursor:text}input{visibility:hidden;width:0px}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiMouseService }, { type: i3.StiComponentResizerService }, { type: i4.StiLocalizationService }, { type: i5.SignatureService }, { type: i6.StiHelperService }, { type: i7.StiFontService }, { type: i0.ChangeDetectorRef }], propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }], sigPad: [{
                type: ViewChild,
                args: ["sigPad"]
            }], ref: [{
                type: ViewChild,
                args: ["ref"]
            }], label: [{
                type: ViewChild,
                args: ["label"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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