import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/sti-form-events-service";
import * as i3 from "../services/sti-helper.service";
import * as i4 from "../services/sti-localization.service";
import * as i5 from "./sti-tooltip/sti-tooltip.directive";
export class StiPageNavigationComponent {
    constructor(model, formEvents, helper, loc) {
        this.model = model;
        this.formEvents = formEvents;
        this.helper = helper;
        this.loc = loc;
    }
    getTranslate() {
        return `translate(${1 - this.model.zoom > 0 ? Math.abs(1 - this.model.zoom) * 25 : -(Math.abs(1 - this.model.zoom) * 25)}px, ${1 - this.model.zoom > 0 ? Math.abs(1 - this.model.zoom) * 120 : -(Math.abs(1 - this.model.zoom) * 120)}px)`;
    }
    setProperties(newPage, currentPage) {
        newPage.paperKind = currentPage.paperKind;
        newPage.padding = currentPage.padding;
        newPage.backgroundColor = currentPage.backgroundColor;
        newPage.visible = currentPage.visible;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiPageNavigationComponent, deps: [{ token: i1.StiModelService }, { token: i2.FormEventsService }, { token: i3.StiHelperService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiPageNavigationComponent, selector: "sti-page-navigation", inputs: { currentPage: "currentPage" }, ngImport: i0, template: `
    <div class="page-navigation" [style.scale]="1 / model.zoom" [style.transform]="getTranslate()">
      <div
        class="button-navigation {{ !formEvents.canMoveUp ? 'disabled' : '' }}"
        [stiTooltip]="loc.get2('QueryBuilder', 'MoveUp')"
        tooltipPosition="bottom"
        showDelay="500"
        (click)="formEvents.moveUp()"
      >
        <img
          [style.filter]="!formEvents.canMoveUp ? 'grayscale(1)' : ''"
          [src]="model.getImage('images.Page.MovePageUp.png')"
        />
      </div>
      <div
        class="button-navigation {{ !formEvents.canMoveDown ? 'disabled' : '' }}"
        [stiTooltip]="loc.get2('QueryBuilder', 'MoveDown')"
        tooltipPosition="bottom"
        showDelay="500"
        (click)="formEvents.moveDown()"
      >
        <img
          [style.filter]="!formEvents.canMoveDown ? 'grayscale(1)' : ''"
          [src]="model.getImage('images.Page.MovePageDown.png')"
        />
      </div>
      <div
        class="button-navigation"
        [stiTooltip]="loc.get2('TableRibbon', 'InsertAbove')"
        tooltipPosition="bottom"
        showDelay="500"
        (click)="formEvents.insertBefore()"
      >
        <img [src]="model.getImage('images.Page.InsertPageBefore.png')" />
      </div>
      <div
        class="button-navigation"
        [stiTooltip]="loc.get2('TableRibbon', 'InsertBelow')"
        tooltipPosition="bottom"
        showDelay="500"
        (click)="formEvents.insertAfter()"
      >
        <img [src]="model.getImage('images.Page.InsertPageAfter.png')" />
      </div>
      <div
        class="button-navigation {{ !formEvents.canClear ? 'disabled' : '' }}"
        [stiTooltip]="loc.get2('MainMenu', 'menuEditClearContents')"
        tooltipPosition="bottom"
        showDelay="500"
        (click)="formEvents.clear()"
      >
        <img
          [style.filter]="!formEvents.canClear ? 'grayscale(1)' : ''"
          [src]="model.getImage('images.Page.ClearContent.png')"
        />
      </div>
      <div
        class="button-navigation {{ !formEvents.canDelete ? 'disabled' : '' }}"
        [stiTooltip]="loc.get2('FormViewer', 'PageDelete')"
        tooltipPosition="bottom"
        showDelay="500"
        [style.border-bottom]="'1px solid var(--pageNavBorder-color)'"
        (click)="formEvents.delete(); $event.stopPropagation()"
      >
        <img
          [style.filter]="!formEvents.canDelete ? 'grayscale(1)' : ''"
          [src]="model.getImage('images.Page.DeletePage.png')"
        />
      </div>
    </div>

    <style>
      .page-navigation {
        display: flex;
        flex-direction: column;
      }
      .button-navigation {
        background-color: var(--pageNavBackground-color);
        border-top: 1px solid var(--pageNavBorder-color);
        border-left: 1px solid var(--pageNavBorder-color);
        border-right: 1px solid var(--pageNavBorder-color);
        width: 40px;
        height: 40px;
        margin: 0;
        display: flex;
        align-items: center;
        justify-content: center;
        user-select: none;
      }
      .button-navigation img {
        height: 16px;
        width: 16px;
      }
      .button-navigation:hover {
        background-color: var(--hover-color);
      }
      .disabled {
        background-color: var(--pageNavDisable-color);
        pointer-events: none;
      }
      .disabled:hover {
        background-color: var(--pageNavDisable-color);
      }
    </style>
  `, isInline: true, styles: ["\n      .page-navigation {\n        display: flex;\n        flex-direction: column;\n      }\n      .button-navigation {\n        background-color: var(--pageNavBackground-color);\n        border-top: 1px solid var(--pageNavBorder-color);\n        border-left: 1px solid var(--pageNavBorder-color);\n        border-right: 1px solid var(--pageNavBorder-color);\n        width: 40px;\n        height: 40px;\n        margin: 0;\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        user-select: none;\n      }\n      .button-navigation img {\n        height: 16px;\n        width: 16px;\n      }\n      .button-navigation:hover {\n        background-color: var(--hover-color);\n      }\n      .disabled {\n        background-color: var(--pageNavDisable-color);\n        pointer-events: none;\n      }\n      .disabled:hover {\n        background-color: var(--pageNavDisable-color);\n      }\n    "], dependencies: [{ kind: "directive", type: i5.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiPageNavigationComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-page-navigation",
                    template: `
    <div class="page-navigation" [style.scale]="1 / model.zoom" [style.transform]="getTranslate()">
      <div
        class="button-navigation {{ !formEvents.canMoveUp ? 'disabled' : '' }}"
        [stiTooltip]="loc.get2('QueryBuilder', 'MoveUp')"
        tooltipPosition="bottom"
        showDelay="500"
        (click)="formEvents.moveUp()"
      >
        <img
          [style.filter]="!formEvents.canMoveUp ? 'grayscale(1)' : ''"
          [src]="model.getImage('images.Page.MovePageUp.png')"
        />
      </div>
      <div
        class="button-navigation {{ !formEvents.canMoveDown ? 'disabled' : '' }}"
        [stiTooltip]="loc.get2('QueryBuilder', 'MoveDown')"
        tooltipPosition="bottom"
        showDelay="500"
        (click)="formEvents.moveDown()"
      >
        <img
          [style.filter]="!formEvents.canMoveDown ? 'grayscale(1)' : ''"
          [src]="model.getImage('images.Page.MovePageDown.png')"
        />
      </div>
      <div
        class="button-navigation"
        [stiTooltip]="loc.get2('TableRibbon', 'InsertAbove')"
        tooltipPosition="bottom"
        showDelay="500"
        (click)="formEvents.insertBefore()"
      >
        <img [src]="model.getImage('images.Page.InsertPageBefore.png')" />
      </div>
      <div
        class="button-navigation"
        [stiTooltip]="loc.get2('TableRibbon', 'InsertBelow')"
        tooltipPosition="bottom"
        showDelay="500"
        (click)="formEvents.insertAfter()"
      >
        <img [src]="model.getImage('images.Page.InsertPageAfter.png')" />
      </div>
      <div
        class="button-navigation {{ !formEvents.canClear ? 'disabled' : '' }}"
        [stiTooltip]="loc.get2('MainMenu', 'menuEditClearContents')"
        tooltipPosition="bottom"
        showDelay="500"
        (click)="formEvents.clear()"
      >
        <img
          [style.filter]="!formEvents.canClear ? 'grayscale(1)' : ''"
          [src]="model.getImage('images.Page.ClearContent.png')"
        />
      </div>
      <div
        class="button-navigation {{ !formEvents.canDelete ? 'disabled' : '' }}"
        [stiTooltip]="loc.get2('FormViewer', 'PageDelete')"
        tooltipPosition="bottom"
        showDelay="500"
        [style.border-bottom]="'1px solid var(--pageNavBorder-color)'"
        (click)="formEvents.delete(); $event.stopPropagation()"
      >
        <img
          [style.filter]="!formEvents.canDelete ? 'grayscale(1)' : ''"
          [src]="model.getImage('images.Page.DeletePage.png')"
        />
      </div>
    </div>

    <style>
      .page-navigation {
        display: flex;
        flex-direction: column;
      }
      .button-navigation {
        background-color: var(--pageNavBackground-color);
        border-top: 1px solid var(--pageNavBorder-color);
        border-left: 1px solid var(--pageNavBorder-color);
        border-right: 1px solid var(--pageNavBorder-color);
        width: 40px;
        height: 40px;
        margin: 0;
        display: flex;
        align-items: center;
        justify-content: center;
        user-select: none;
      }
      .button-navigation img {
        height: 16px;
        width: 16px;
      }
      .button-navigation:hover {
        background-color: var(--hover-color);
      }
      .disabled {
        background-color: var(--pageNavDisable-color);
        pointer-events: none;
      }
      .disabled:hover {
        background-color: var(--pageNavDisable-color);
      }
    </style>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.FormEventsService }, { type: i3.StiHelperService }, { type: i4.StiLocalizationService }], propDecorators: { currentPage: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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