import { Component, Input } from "@angular/core";
import { StiNumberBoxElement } from "../elements/StiNumberBoxElement";
import { StiInputTextItem } from "../helper/StiInputTextItem";
import { StiDisplayCurrencyAs, StiNumberType, StiUnitAlignment } from "../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/sti-helper.service";
import * as i3 from "../services/sti-editable-content.service";
import * as i4 from "../services/mouse.service";
import * as i5 from "@angular/common";
import * as i6 from "./sti-tooltip/sti-tooltip.directive";
export class StiNumberComponent {
    get isNumberBox() {
        return this.element instanceof StiNumberBoxElement;
    }
    get needToFill() {
        return this.element["required"] && !this.element["value"] && this.model.hasEmptyReuiredFields;
    }
    get disabled() {
        return (this.element.type == "Number_BoxElement" && this.element.readOnly) ||
            (this.element.type != "Number_BoxElement" && this.element.eParent?.readOnly)
            ? true
            : false;
    }
    constructor(model, helper, editableService, mouseService) {
        this.model = model;
        this.helper = helper;
        this.editableService = editableService;
        this.mouseService = mouseService;
        this.buttonDown = 0;
        this.mouseOver = false;
        this.focused = false;
    }
    get tabIndex() {
        try {
            let columns = this.table?.columns;
            return columns
                ? this.table["tabIndex"] + columns.indexOf(this.element) + columns.length * this.index
                : this.element["tabIndex"];
        }
        catch { }
    }
    ngOnDestroy() {
        this.mouseUpSubscription?.unsubscribe();
    }
    clear() {
        setTimeout(() => {
            this.buttonDown = 0;
        }, 0);
    }
    ngOnInit() {
        this.mouseUpSubscription = this.mouseService.getCaptureMouseUp().subscribe(() => {
            this.buttonDown = 0;
        });
    }
    onFocus(event) {
        this.focused = true;
        setTimeout(() => {
            let editableContent;
            if (this.element.type == "Number_BoxElement") {
                let nbe = this.element;
                editableContent = new StiInputTextItem(this.elementValue?.toString(), nbe.font, nbe.textColor, nbe.backgroundColor, nbe.contentAlignment);
            }
            else {
                let nbce = this.element;
                editableContent = new StiInputTextItem(this.elementValue?.toString(), this.table.font, nbce.cellForeColor, nbce.cellBackColor, nbce.cellAlignment);
            }
            editableContent.element = this.element;
            this.editableService.editableContent = editableContent;
            this.editableService.usedElement = this.element;
        }, 0);
        event.currentTarget.value = this.elementValue?.toString();
    }
    get elementBorderColor() {
        return this.element.type == "Number_BoxElement"
            ? this.element.borderColor
            : this.element.cellBorderColor;
    }
    get readonly() {
        return this.element.type == "Number_BoxElement"
            ? this.element.readOnly
            : this.element.eParent?.readOnly;
    }
    get cellBackgroundColor() {
        return this.element.type == "Number_BoxElement"
            ? this.element.backgroundColor
            : this.element.cellBackColor;
    }
    get elementTextColor() {
        return this.element.type == "Number_BoxElement"
            ? this.element.textColor
            : this.element.cellForeColor;
    }
    get elementHtmlStyle() {
        return this.element.type == "Number_BoxElement"
            ? this.element.htmlStyle()
            : this.table.font.htmlStyle();
    }
    get elementValue() {
        return this.element.type == "Number_BoxElement"
            ? this.element.value
            : this.element.cells[this.index].value;
    }
    set elementValue(value) {
        if (this.element.type == "Number_BoxElement") {
            this.element.value = value;
            if (this.element.useRange) {
                this.model.checkNumberRange(this.element);
            }
        }
        else {
            this.element.cells[this.index].value = value;
        }
    }
    onLostFocus(event) {
        if (this.model.selectedComponent?.element != this.element) {
            this.editableService.editableContent = null;
        }
        this.editableService.usedElement = this.element;
        let value = 0;
        try {
            value = parseFloat(event.currentTarget.value);
        }
        catch { }
        this.focused = false;
        this.elementValue = !isNaN(value) ? value : 0;
        event.currentTarget.value = this.value;
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    setIncDec(value) {
        if (!this.readonly) {
            if (this.incTimeout) {
                clearTimeout(this.incTimeout);
                this.incTimeout = null;
            }
            setTimeout(() => {
                this.elementValue += value;
                this.buttonDown = value;
                this.incDecTimer();
                this.model.formEvents.next({ name: "ValueChanged" });
            }, 0);
        }
    }
    incDecTimer(first = true) {
        let this_ = this;
        this.incTimeout = setTimeout(() => {
            if (this_.buttonDown != 0) {
                this_.elementValue += this_.buttonDown;
                this_.incDecTimer(false);
                this.model.formEvents.next({ name: "ValueChanged" });
            }
        }, first ? 400 : 50);
    }
    get isCurrency() {
        return this.element?.numberType == StiNumberType.Currency ? true : false;
    }
    getCurrency(currency) {
        if (this.isCurrency) {
            let value = this.helper.currencyInfo.find((item) => item.code == currency);
            if (this.element.currencyLabelFormat == StiDisplayCurrencyAs.Symbol) {
                return value.symbol;
            }
            else {
                return value.code;
            }
        }
    }
    get value() {
        let unit = this.element.numberType == StiNumberType.Decimal
            ? this.element.unitLabel
            : this.getCurrency(this.element.currency);
        return this.focused
            ? this.elementValue?.toString()
            : this.model.formatNumber(this.elementValue, this.element.thousandSeparator, this.element.decimalDigits, this.element.unitAlignment, unit);
    }
    get isPrefix() {
        return this.element.unitAlignment == StiUnitAlignment.Prefix;
    }
    get isSuffix() {
        return this.element.unitAlignment == StiUnitAlignment.Suffix;
    }
    borderWidth() {
        return `${this.element["borderWeight"]}px`;
    }
    disableDrag(event) {
        this.model.canDrag = false;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiNumberComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiEditableContentService }, { token: i4.StiMouseService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiNumberComponent, selector: "sti-number-component", inputs: { element: "element", index: "index", table: "table" }, ngImport: i0, template: `
    <div class="number-component" [style.align-self]="'start'" [style.flexDirection]="isPrefix ? 'row' : 'row-reverse'">
      <div
        class="unit"
        *ngIf="(element.unitLabel && !isCurrency && (isPrefix || isSuffix)) || (isCurrency && (isPrefix || isSuffix))"
      >
        <span [style]="element?.htmlStyle()" [style.color]="element.unitForeground?.toHtmlColor()">{{
          isCurrency ? getCurrency(element.currency) : element.unitLabel
        }}</span>
      </div>

      <div
        class="number-box"
        [stiTooltip]="element['tooltip']"
        tooltipPosition="bottom"
        showDelay="500"
        [style.border-width]="borderWidth()"
        [style.border-color]="needToFill ? 'red' : elementBorderColor.toHtmlColor()"
        [style.background-color]="element['backgroundColor'].toHtmlColor()"
        (mouseover)="mouseOver = true"
        (mouseleave)="mouseOver = false"
      >
        <input
          type="text"
          (focus)="onFocus($event)"
          (blur)="onLostFocus($event)"
          [value]="value"
          [required]="element['required']"
          [style.border-width]="borderWidth()"
          [readonly]="readonly"
          [tabIndex]="tabIndex"
          [style]="elementHtmlStyle"
          [style.color]="elementTextColor.toHtmlColor()"
          [style.background-color]="cellBackgroundColor.toHtmlColor()"
          [style.pointer-events]="disabled ? 'none' : ''"
          (mousedown)="disableDrag($event)"
          (mouseup)="this.model.canDrag = true"
        />
        <div
          class="buttons"
          [style.width.px]="isNumberBox ? 28 : 20"
          *ngIf="((focused || mouseOver) && !disabled) || isNumberBox"
        >
          <div class="button-up" (mousedown)="setIncDec(1)" (mouseup)="clear()">
            <i class="pi pi-angle-up"></i>
          </div>
          <div class="button-down" (mousedown)="setIncDec(-1)" (mouseup)="clear()">
            <i class="pi pi-angle-down"></i>
          </div>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".number-component{display:flex;width:100%}.unit{align-self:center;padding-left:1px;padding-right:1px}.number-box{width:100%;height:auto;border:1px solid rgb(171,170,169);background-color:#fff;position:relative;display:flex}.number-box:hover{border-color:#a3bde3!important}input{outline:none;border:0px;width:100%;height:auto;padding:3px 5px}.buttons{width:20px;height:100%;align-self:flex-end;display:flex;flex-direction:column;color:#bab9b8}.button-up{width:100%;height:50%;display:flex;justify-content:center}.button-up i{margin-top:.4px}.button-up:hover{cursor:default;background-color:#d5e1f2}.button-up:active{background-color:#a3bde3}.button-down{width:100%;height:50%;display:flex;align-items:center;justify-content:center}.button-down i{margin-bottom:2px}.button-down:hover{cursor:default;background-color:#d5e1f2}.button-down:active{background-color:#a3bde3}i{margin:0;height:8px}\n"], dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i6.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiNumberComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-number-component", template: `
    <div class="number-component" [style.align-self]="'start'" [style.flexDirection]="isPrefix ? 'row' : 'row-reverse'">
      <div
        class="unit"
        *ngIf="(element.unitLabel && !isCurrency && (isPrefix || isSuffix)) || (isCurrency && (isPrefix || isSuffix))"
      >
        <span [style]="element?.htmlStyle()" [style.color]="element.unitForeground?.toHtmlColor()">{{
          isCurrency ? getCurrency(element.currency) : element.unitLabel
        }}</span>
      </div>

      <div
        class="number-box"
        [stiTooltip]="element['tooltip']"
        tooltipPosition="bottom"
        showDelay="500"
        [style.border-width]="borderWidth()"
        [style.border-color]="needToFill ? 'red' : elementBorderColor.toHtmlColor()"
        [style.background-color]="element['backgroundColor'].toHtmlColor()"
        (mouseover)="mouseOver = true"
        (mouseleave)="mouseOver = false"
      >
        <input
          type="text"
          (focus)="onFocus($event)"
          (blur)="onLostFocus($event)"
          [value]="value"
          [required]="element['required']"
          [style.border-width]="borderWidth()"
          [readonly]="readonly"
          [tabIndex]="tabIndex"
          [style]="elementHtmlStyle"
          [style.color]="elementTextColor.toHtmlColor()"
          [style.background-color]="cellBackgroundColor.toHtmlColor()"
          [style.pointer-events]="disabled ? 'none' : ''"
          (mousedown)="disableDrag($event)"
          (mouseup)="this.model.canDrag = true"
        />
        <div
          class="buttons"
          [style.width.px]="isNumberBox ? 28 : 20"
          *ngIf="((focused || mouseOver) && !disabled) || isNumberBox"
        >
          <div class="button-up" (mousedown)="setIncDec(1)" (mouseup)="clear()">
            <i class="pi pi-angle-up"></i>
          </div>
          <div class="button-down" (mousedown)="setIncDec(-1)" (mouseup)="clear()">
            <i class="pi pi-angle-down"></i>
          </div>
        </div>
      </div>
    </div>
  `, styles: [".number-component{display:flex;width:100%}.unit{align-self:center;padding-left:1px;padding-right:1px}.number-box{width:100%;height:auto;border:1px solid rgb(171,170,169);background-color:#fff;position:relative;display:flex}.number-box:hover{border-color:#a3bde3!important}input{outline:none;border:0px;width:100%;height:auto;padding:3px 5px}.buttons{width:20px;height:100%;align-self:flex-end;display:flex;flex-direction:column;color:#bab9b8}.button-up{width:100%;height:50%;display:flex;justify-content:center}.button-up i{margin-top:.4px}.button-up:hover{cursor:default;background-color:#d5e1f2}.button-up:active{background-color:#a3bde3}.button-down{width:100%;height:50%;display:flex;align-items:center;justify-content:center}.button-down i{margin-bottom:2px}.button-down:hover{cursor:default;background-color:#d5e1f2}.button-down:active{background-color:#a3bde3}i{margin:0;height:8px}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiEditableContentService }, { type: i4.StiMouseService }], propDecorators: { element: [{
                type: Input
            }], index: [{
                type: Input
            }], table: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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