import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-helper.service";
import * as i3 from "../../services/sti-editable-content.service";
import * as i4 from "../../services/mouse.service";
import * as i5 from "@angular/common";
import * as i6 from "../sti-number.component";
import * as i7 from "../sti-component";
import * as i8 from "../sti-editable-content.component";
export class StiNumberBoxComponent {
    get align() {
        return "start";
    }
    constructor(model, helper, editableService, mouseService) {
        this.model = model;
        this.helper = helper;
        this.editableService = editableService;
        this.mouseService = mouseService;
        this.isClone = false;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiNumberBoxComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiEditableContentService }, { token: i4.StiMouseService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiNumberBoxComponent, selector: "sti-numberbox-component", inputs: { element: "element", isClone: "isClone" }, ngImport: i0, template: ` <sti-component [element]="element" [isClone]="isClone" class="StiNumberBox">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
            [editableContent]="element.label"
            [style.text-align]="element?.getContentAlign()"
            [required]="element.required"
            [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
            [style.width]="element?.getLabelWidth()"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <sti-number-component [element]="element"> </sti-number-component>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, isInline: true, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}\n"], dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.StiNumberComponent, selector: "sti-number-component", inputs: ["element", "index", "table"] }, { kind: "component", type: i7.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i8.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiNumberBoxComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-numberbox-component", template: ` <sti-component [element]="element" [isClone]="isClone" class="StiNumberBox">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
            [editableContent]="element.label"
            [style.text-align]="element?.getContentAlign()"
            [required]="element.required"
            [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
            [style.width]="element?.getLabelWidth()"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <sti-number-component [element]="element"> </sti-number-component>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiEditableContentService }, { type: i4.StiMouseService }], propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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