import { Component, EventEmitter, Input, Output } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
export class StiLoginComponent {
    constructor() {
        this.onLogin = new EventEmitter();
    }
    ngOnInit() { }
    get window() {
        return window;
    }
    doLogin() {
        if (this.login?.length > 0 && this.password?.length > 0) {
            this.onLogin.emit({ login: this.login, password: this.password });
        }
    }
    keydown(event) {
        if (event.key === 'Enter') {
            this.doLogin();
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiLoginComponent, deps: [], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiLoginComponent, selector: "sti-login", inputs: { loginInfo: "loginInfo" }, outputs: { onLogin: "onLogin" }, ngImport: i0, template: `
  <div id="cd334261b95f4a98802f0b2b478f726e" class="stiJsViewerForm"
	style="z-index: 21; width: 380px; background-color: white; left: 0px; opacity: 1;"
  [style.left.px]="window.innerWidth / 2 - 140"
  [style.top.px]="window.innerHeight / 2 - 200">
	<div class="stiJsViewerAuthFormHeader" style="position: relative;">
		<table class="stiJsViewerClearAllStyles" cellpadding="0"
			cellspacing="0" style="width: 100%;">
			<tbody>
				<tr class="stiJsViewerClearAllStyles">
					<td class="stiJsViewerAuthFormCaption"
						style="text-align: left; padding: 45px 133px 45px 33px;">{{loginInfo.AuthorizationWindowTitleLogin.toUpperCase()}}</td>
					<td class="stiJsViewerClearAllStyles"
						style="vertical-align: top; width: 30px; text-align: right; padding: 2px 2px 1px 1px;"><div
							class="stiJsViewerStandartSmallButton stiJsViewerStandartSmallButtonDefault"
							style="font-family: Arial; height: 23px; box-sizing: content-box; display: none;">
							<table class="stiJsViewerClearAllStyles" cellpadding="0"
								cellspacing="0" style="width: 100%; height: 100%;">
								<tbody>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"
											style="line-height: 0; text-align: center; padding: 0px 4px;"><img
											src="data:image/png;base64,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"
											style="width: 16px; height: 16px; margin: 0px 2px;"></td>
									</tr>
								</tbody>
							</table>
						</div></td>
				</tr>
			</tbody>
		</table>
		<img
			src="data:image/png;base64,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"
			style="position: absolute; top: 50px; right: 42px; width: 87px; height: 21px;">
	</div>
	<div class="stiJsViewerAuthFormContainer"
		style="overflow: hidden; padding: 0px;">
		<div>
			<table class="stiJsViewerClearAllStyles" cellpadding="0"
				cellspacing="0" style="width: 100%;">
				<tbody>
					<tr class="stiJsViewerClearAllStyles">
						<td class="stiJsViewerClearAllStyles" style="width: 50%;"><table
								class="stiJsViewerClearAllStyles" cellpadding="0"
								cellspacing="0" style="margin: 0px auto;">
								<tbody>
									<tr class="stiJsViewerClearAllStyles"></tr>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"><table
												class="stiJsViewerClearAllStyles" cellpadding="0"
												cellspacing="0">
												<tbody>
													<tr class="stiJsViewerClearAllStyles">
														<td class="stiJsViewerClearAllStyles"
															style="line-height: 0; background-color: rgb(242, 241, 241); width: 30px; text-align: center;"><img
															src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyNpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDYuMC1jMDAyIDc5LjE2NDM1MiwgMjAyMC8wMS8zMC0xNTo1MDozOCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIxLjEgKFdpbmRvd3MpIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOkNGQzNFQTREQTQ2OTExRUFBQzFBQjcwQUVCQUVFNURFIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOkNGQzNFQTRFQTQ2OTExRUFBQzFBQjcwQUVCQUVFNURFIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6Q0ZDM0VBNEJBNDY5MTFFQUFDMUFCNzBBRUJBRUU1REUiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6Q0ZDM0VBNENBNDY5MTFFQUFDMUFCNzBBRUJBRUU1REUiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz7qFruUAAAApUlEQVR42mL8//8/AwhIeXQzIAFXIE4FYlkgfgzEs4F4N0zy2Y5SuEIWBkzgDMTtSHwlJP5udMVMWAxIZ8AOUrEJYjNAFocBssQa8BiHAY+JNWAWDgPmEGvAHiCuAuL7QPwHSoP4u7AZwILDtl24NBBywRkojkMTj0OSI+gFEMgF4iAoOwjKZyDFC4xAXAHEmkDsD+WTZADMdYGkhgHJYBgYABBgAAcgHJxJDtSoAAAAAElFTkSuQmCC"
															style="vertical-align: middle; opacity: 0.8; width: 16px; height: 16px;"></td>
														<td class="stiJsViewerClearAllStyles"><input
                              [(ngModel)]="login"
															name="null" title="{{loginInfo.AuthorizationTextUserName}}"
															class="stiJsViewerTextBox stiJsViewerTextBoxDefault"
															placeholder="{{loginInfo.AuthorizationTextUserName}}"
															style="font-family: Arial; width: 280px; height: 30px; line-height: 21px; box-sizing: content-box; background-color: rgb(242, 241, 241); border: none;"></td>
													</tr>
												</tbody>
											</table></td>
									</tr>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"
											style="padding-top: 17px;"><table
												class="stiJsViewerClearAllStyles" cellpadding="0"
												cellspacing="0">
												<tbody>
													<tr class="stiJsViewerClearAllStyles">
														<td class="stiJsViewerClearAllStyles"
															style="line-height: 0; background-color: rgb(242, 241, 241); width: 30px; text-align: center;"><img
															src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyNpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDYuMC1jMDAyIDc5LjE2NDM1MiwgMjAyMC8wMS8zMC0xNTo1MDozOCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIxLjEgKFdpbmRvd3MpIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOkNBNjE4NDExQTQ2OTExRUE4Qjg4OUQyMDc0MzI4QjQzIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOkNBNjE4NDEyQTQ2OTExRUE4Qjg4OUQyMDc0MzI4QjQzIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6Q0E2MTg0MEZBNDY5MTFFQThCODg5RDIwNzQzMjhCNDMiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6Q0E2MTg0MTBBNDY5MTFFQThCODg5RDIwNzQzMjhCNDMiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz6i/NOXAAAA5UlEQVR42mKUdO9igAI7II4CYi0o/xoQLwXiwwx4AAuUzgLiJDQ5EyieB8TTcBnABMS2UM0TgNgSiPvQ1CRBXYfTgGgoex0Q/wbijVjUReEzAObnQCDmBGJ/LOq0CIUBCBRCMUmACRrahMBbfAYsI8IAWVzhwMyr4voQ6hVDAoZYQsPCAYiPAPEfmAsYoPFcBMRngPg7FD/GYogNELsghx1yIB6CYmQQjSNgQd5+AMR5LAScvRQphpCBFBD/gIUBoQC8DMRfoGGADASB+BsxBuAzxIKJhDSzDEs+YWAiMeFhGAIQYABSSCj4eeytwAAAAABJRU5ErkJggg=="
															style="vertical-align: middle; opacity: 0.8; width: 16px; height: 16px;"></td>
														<td class="stiJsViewerClearAllStyles"><input
                              [(ngModel)]="password"
                              (keydown)="keydown($event)"
															name="null" title="{{loginInfo.AuthorizationTextPassword}}"
															class="stiJsViewerTextBox stiJsViewerTextBoxDefault"
															placeholder="{{loginInfo.AuthorizationTextPassword}}" type="password"
															style="font-family: Arial; width: 280px; height: 30px; line-height: 21px; box-sizing: content-box; background-color: rgb(242, 241, 241); border: none;"></td>
													</tr>
												</tbody>
											</table></td>
									</tr>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"><table
												class="stiJsViewerClearAllStyles" cellpadding="0"
												cellspacing="0" style="width: 100%;">
												<tbody>
													<tr class="stiJsViewerClearAllStyles">
														<td class="stiJsViewerClearAllStyles"
															style="padding-top: 20px;"><div
																class="stiJsViewerLoginButton stiJsViewerLoginButtonDefault"
																style="font-family: Arial; height: 40px; box-sizing: content-box; min-width: 80px; cursor: pointer; margin: 8px 0px 80px; display: inline-block;">
																<table class="stiJsViewerClearAllStyles" cellpadding="0"
                                (click)="doLogin()"
																	cellspacing="0" style="width: 100%; height: 100%;">
																	<tbody>
																		<tr class="stiJsViewerClearAllStyles">
																			<td class="stiJsViewerClearAllStyles"
																				style="padding: 0px 10px; white-space: nowrap; text-align: center;">{{loginInfo.AuthorizationWindowTitleLogin}}</td>
																		</tr>
																	</tbody>
																</table>
															</div></td>
													</tr>
												</tbody>
											</table></td>
									</tr>
								</tbody>
							</table></td>
					</tr>
					<tr class="stiJsViewerClearAllStyles">
						<td class="stiJsViewerClearAllStyles" colspan="2"
							style="text-align: center;"><div
								style="width: 380px; margin: 0px auto;"></div></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	<div class="stiJsViewerFormButtonsPanel" style="display: none;">
		<table class="stiJsViewerClearAllStyles" cellpadding="0"
			cellspacing="0">
			<tbody>
				<tr class="stiJsViewerClearAllStyles">
					<td class="stiJsViewerClearAllStyles" style="padding: 12px;"><div
							class="stiJsViewerFormButtonTheme stiJsViewerFormButtonThemeDefault"
							style="font-family: Arial; height: 23px; box-sizing: content-box; min-width: 80px;">
							<table class="stiJsViewerClearAllStyles" cellpadding="0"
								cellspacing="0" style="width: 100%; height: 100%;">
								<tbody>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"
											style="padding: 0px 10px; white-space: nowrap; text-align: center; width: 100%;">OK</td>
									</tr>
								</tbody>
							</table>
						</div></td>
					<td class="stiJsViewerClearAllStyles"
						style="padding: 12px 12px 12px 0px;"><div
							class="stiJsViewerFormButton stiJsViewerFormButtonDefault"
							style="font-family: Arial; height: 23px; box-sizing: content-box; min-width: 80px;">
							<table class="stiJsViewerClearAllStyles" cellpadding="0"
								cellspacing="0" style="width: 100%; height: 100%;">
								<tbody>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"
											style="padding: 0px 10px; white-space: nowrap; text-align: center; width: 100%;">Cancel</td>
									</tr>
								</tbody>
							</table>
						</div></td>
				</tr>
			</tbody>
		</table>
	</div>
</div>
<style>
  .stiJsViewerMainPanel *, .stiJsViewerMainPanel *:before, .stiJsViewerMainPanel *:after {
    box-sizing: content-box;
    border-collapse: initial;
}

.stiJsViewerForm {
    position: absolute;
    border: 1px solid #19478a;
    background: #ffffff;
    -moz-box-shadow: 0px 0px 7px rgba(0,0,0,0.6);
    -webkit-box-shadow: 0px 0px 7px rgb(0 0 0 / 60%);
    box-shadow: 0 0 7px rgb(0 0 0 / 30%);
    cursor: default;
    -moz-user-select: none;
    -khtml-user-select: none;
    -webkit-user-select: none;
    -ms-user-select: none;
    text-align: left;
    color: #202020;
}

.stiJsViewerClearAllStyles {
    padding: 0px;
    margin: 0px;
    border: 0px;
    margin-top: 0px;
    margin-bottom: 0px;
    margin-left: 0px;
    margin-right: 0px;
    line-height: normal;
}

.stiJsViewerAuthFormCaption {
    font-family: Arial;
    color: #7a8d8e;
    font-size: 28px;
}

.stiJsViewerAuthFormContainer {
    padding: 5px 10px 0px 10px;
    background: #ffffff;
    overflow-y: auto;
    overflow-x: hidden;
}

.stiJsViewerTextBoxDefault {
    border-radius: 3px;
    border: 1px solid #ababab;
}

.stiJsViewerTextBox {
    font-size: 12px;
    margin: 0px;
    padding: 0px 0px 0px 4px;
    -webkit-border-radius: 0px;
    outline: none;
    background-image: -webkit-gradient(linear, 0% 0%, 0% 100%, from(hsla(0,0%,100%,0)), to(hsla(0,0%,100%,0)));
    background-image: -webkit-linear-gradient(hsla(0,0%,100%,0), hsla(0,0%,100%,0));
    background: #ffffff;
    color: #202020;
}

.stiJsViewerLoginButtonDefault {
    background: #19478a;
}

.stiJsViewerLoginButton {
    border: none;
    border-radius: 3px;
    height: 40px;
    color: white;
    cursor: default;
    font-family: Arial;
    font-size: 19px;
    width: 100%;
    -moz-user-select: none;
    -khtml-user-select: none;
    -webkit-user-select: none;
    -ms-user-select: none;
}

.stiJsViewerLoginButton:hover {
    background: #3b629b;
}
</style>
  `, isInline: true, styles: ["\n  .stiJsViewerMainPanel *, .stiJsViewerMainPanel *:before, .stiJsViewerMainPanel *:after {\n    box-sizing: content-box;\n    border-collapse: initial;\n}\n\n.stiJsViewerForm {\n    position: absolute;\n    border: 1px solid #19478a;\n    background: #ffffff;\n    -moz-box-shadow: 0px 0px 7px rgba(0,0,0,0.6);\n    -webkit-box-shadow: 0px 0px 7px rgb(0 0 0 / 60%);\n    box-shadow: 0 0 7px rgb(0 0 0 / 30%);\n    cursor: default;\n    -moz-user-select: none;\n    -khtml-user-select: none;\n    -webkit-user-select: none;\n    -ms-user-select: none;\n    text-align: left;\n    color: #202020;\n}\n\n.stiJsViewerClearAllStyles {\n    padding: 0px;\n    margin: 0px;\n    border: 0px;\n    margin-top: 0px;\n    margin-bottom: 0px;\n    margin-left: 0px;\n    margin-right: 0px;\n    line-height: normal;\n}\n\n.stiJsViewerAuthFormCaption {\n    font-family: Arial;\n    color: #7a8d8e;\n    font-size: 28px;\n}\n\n.stiJsViewerAuthFormContainer {\n    padding: 5px 10px 0px 10px;\n    background: #ffffff;\n    overflow-y: auto;\n    overflow-x: hidden;\n}\n\n.stiJsViewerTextBoxDefault {\n    border-radius: 3px;\n    border: 1px solid #ababab;\n}\n\n.stiJsViewerTextBox {\n    font-size: 12px;\n    margin: 0px;\n    padding: 0px 0px 0px 4px;\n    -webkit-border-radius: 0px;\n    outline: none;\n    background-image: -webkit-gradient(linear, 0% 0%, 0% 100%, from(hsla(0,0%,100%,0)), to(hsla(0,0%,100%,0)));\n    background-image: -webkit-linear-gradient(hsla(0,0%,100%,0), hsla(0,0%,100%,0));\n    background: #ffffff;\n    color: #202020;\n}\n\n.stiJsViewerLoginButtonDefault {\n    background: #19478a;\n}\n\n.stiJsViewerLoginButton {\n    border: none;\n    border-radius: 3px;\n    height: 40px;\n    color: white;\n    cursor: default;\n    font-family: Arial;\n    font-size: 19px;\n    width: 100%;\n    -moz-user-select: none;\n    -khtml-user-select: none;\n    -webkit-user-select: none;\n    -ms-user-select: none;\n}\n\n.stiJsViewerLoginButton:hover {\n    background: #3b629b;\n}\n"], dependencies: [{ kind: "directive", type: i1.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i1.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i1.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiLoginComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-login',
                    template: `
  <div id="cd334261b95f4a98802f0b2b478f726e" class="stiJsViewerForm"
	style="z-index: 21; width: 380px; background-color: white; left: 0px; opacity: 1;"
  [style.left.px]="window.innerWidth / 2 - 140"
  [style.top.px]="window.innerHeight / 2 - 200">
	<div class="stiJsViewerAuthFormHeader" style="position: relative;">
		<table class="stiJsViewerClearAllStyles" cellpadding="0"
			cellspacing="0" style="width: 100%;">
			<tbody>
				<tr class="stiJsViewerClearAllStyles">
					<td class="stiJsViewerAuthFormCaption"
						style="text-align: left; padding: 45px 133px 45px 33px;">{{loginInfo.AuthorizationWindowTitleLogin.toUpperCase()}}</td>
					<td class="stiJsViewerClearAllStyles"
						style="vertical-align: top; width: 30px; text-align: right; padding: 2px 2px 1px 1px;"><div
							class="stiJsViewerStandartSmallButton stiJsViewerStandartSmallButtonDefault"
							style="font-family: Arial; height: 23px; box-sizing: content-box; display: none;">
							<table class="stiJsViewerClearAllStyles" cellpadding="0"
								cellspacing="0" style="width: 100%; height: 100%;">
								<tbody>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"
											style="line-height: 0; text-align: center; padding: 0px 4px;"><img
											src="data:image/png;base64,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"
											style="width: 16px; height: 16px; margin: 0px 2px;"></td>
									</tr>
								</tbody>
							</table>
						</div></td>
				</tr>
			</tbody>
		</table>
		<img
			src="data:image/png;base64,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"
			style="position: absolute; top: 50px; right: 42px; width: 87px; height: 21px;">
	</div>
	<div class="stiJsViewerAuthFormContainer"
		style="overflow: hidden; padding: 0px;">
		<div>
			<table class="stiJsViewerClearAllStyles" cellpadding="0"
				cellspacing="0" style="width: 100%;">
				<tbody>
					<tr class="stiJsViewerClearAllStyles">
						<td class="stiJsViewerClearAllStyles" style="width: 50%;"><table
								class="stiJsViewerClearAllStyles" cellpadding="0"
								cellspacing="0" style="margin: 0px auto;">
								<tbody>
									<tr class="stiJsViewerClearAllStyles"></tr>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"><table
												class="stiJsViewerClearAllStyles" cellpadding="0"
												cellspacing="0">
												<tbody>
													<tr class="stiJsViewerClearAllStyles">
														<td class="stiJsViewerClearAllStyles"
															style="line-height: 0; background-color: rgb(242, 241, 241); width: 30px; text-align: center;"><img
															src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyNpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDYuMC1jMDAyIDc5LjE2NDM1MiwgMjAyMC8wMS8zMC0xNTo1MDozOCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIxLjEgKFdpbmRvd3MpIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOkNGQzNFQTREQTQ2OTExRUFBQzFBQjcwQUVCQUVFNURFIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOkNGQzNFQTRFQTQ2OTExRUFBQzFBQjcwQUVCQUVFNURFIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6Q0ZDM0VBNEJBNDY5MTFFQUFDMUFCNzBBRUJBRUU1REUiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6Q0ZDM0VBNENBNDY5MTFFQUFDMUFCNzBBRUJBRUU1REUiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz7qFruUAAAApUlEQVR42mL8//8/AwhIeXQzIAFXIE4FYlkgfgzEs4F4N0zy2Y5SuEIWBkzgDMTtSHwlJP5udMVMWAxIZ8AOUrEJYjNAFocBssQa8BiHAY+JNWAWDgPmEGvAHiCuAuL7QPwHSoP4u7AZwILDtl24NBBywRkojkMTj0OSI+gFEMgF4iAoOwjKZyDFC4xAXAHEmkDsD+WTZADMdYGkhgHJYBgYABBgAAcgHJxJDtSoAAAAAElFTkSuQmCC"
															style="vertical-align: middle; opacity: 0.8; width: 16px; height: 16px;"></td>
														<td class="stiJsViewerClearAllStyles"><input
                              [(ngModel)]="login"
															name="null" title="{{loginInfo.AuthorizationTextUserName}}"
															class="stiJsViewerTextBox stiJsViewerTextBoxDefault"
															placeholder="{{loginInfo.AuthorizationTextUserName}}"
															style="font-family: Arial; width: 280px; height: 30px; line-height: 21px; box-sizing: content-box; background-color: rgb(242, 241, 241); border: none;"></td>
													</tr>
												</tbody>
											</table></td>
									</tr>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"
											style="padding-top: 17px;"><table
												class="stiJsViewerClearAllStyles" cellpadding="0"
												cellspacing="0">
												<tbody>
													<tr class="stiJsViewerClearAllStyles">
														<td class="stiJsViewerClearAllStyles"
															style="line-height: 0; background-color: rgb(242, 241, 241); width: 30px; text-align: center;"><img
															src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyNpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDYuMC1jMDAyIDc5LjE2NDM1MiwgMjAyMC8wMS8zMC0xNTo1MDozOCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIxLjEgKFdpbmRvd3MpIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOkNBNjE4NDExQTQ2OTExRUE4Qjg4OUQyMDc0MzI4QjQzIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOkNBNjE4NDEyQTQ2OTExRUE4Qjg4OUQyMDc0MzI4QjQzIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6Q0E2MTg0MEZBNDY5MTFFQThCODg5RDIwNzQzMjhCNDMiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6Q0E2MTg0MTBBNDY5MTFFQThCODg5RDIwNzQzMjhCNDMiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz6i/NOXAAAA5UlEQVR42mKUdO9igAI7II4CYi0o/xoQLwXiwwx4AAuUzgLiJDQ5EyieB8TTcBnABMS2UM0TgNgSiPvQ1CRBXYfTgGgoex0Q/wbijVjUReEzAObnQCDmBGJ/LOq0CIUBCBRCMUmACRrahMBbfAYsI8IAWVzhwMyr4voQ6hVDAoZYQsPCAYiPAPEfmAsYoPFcBMRngPg7FD/GYogNELsghx1yIB6CYmQQjSNgQd5+AMR5LAScvRQphpCBFBD/gIUBoQC8DMRfoGGADASB+BsxBuAzxIKJhDSzDEs+YWAiMeFhGAIQYABSSCj4eeytwAAAAABJRU5ErkJggg=="
															style="vertical-align: middle; opacity: 0.8; width: 16px; height: 16px;"></td>
														<td class="stiJsViewerClearAllStyles"><input
                              [(ngModel)]="password"
                              (keydown)="keydown($event)"
															name="null" title="{{loginInfo.AuthorizationTextPassword}}"
															class="stiJsViewerTextBox stiJsViewerTextBoxDefault"
															placeholder="{{loginInfo.AuthorizationTextPassword}}" type="password"
															style="font-family: Arial; width: 280px; height: 30px; line-height: 21px; box-sizing: content-box; background-color: rgb(242, 241, 241); border: none;"></td>
													</tr>
												</tbody>
											</table></td>
									</tr>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"><table
												class="stiJsViewerClearAllStyles" cellpadding="0"
												cellspacing="0" style="width: 100%;">
												<tbody>
													<tr class="stiJsViewerClearAllStyles">
														<td class="stiJsViewerClearAllStyles"
															style="padding-top: 20px;"><div
																class="stiJsViewerLoginButton stiJsViewerLoginButtonDefault"
																style="font-family: Arial; height: 40px; box-sizing: content-box; min-width: 80px; cursor: pointer; margin: 8px 0px 80px; display: inline-block;">
																<table class="stiJsViewerClearAllStyles" cellpadding="0"
                                (click)="doLogin()"
																	cellspacing="0" style="width: 100%; height: 100%;">
																	<tbody>
																		<tr class="stiJsViewerClearAllStyles">
																			<td class="stiJsViewerClearAllStyles"
																				style="padding: 0px 10px; white-space: nowrap; text-align: center;">{{loginInfo.AuthorizationWindowTitleLogin}}</td>
																		</tr>
																	</tbody>
																</table>
															</div></td>
													</tr>
												</tbody>
											</table></td>
									</tr>
								</tbody>
							</table></td>
					</tr>
					<tr class="stiJsViewerClearAllStyles">
						<td class="stiJsViewerClearAllStyles" colspan="2"
							style="text-align: center;"><div
								style="width: 380px; margin: 0px auto;"></div></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	<div class="stiJsViewerFormButtonsPanel" style="display: none;">
		<table class="stiJsViewerClearAllStyles" cellpadding="0"
			cellspacing="0">
			<tbody>
				<tr class="stiJsViewerClearAllStyles">
					<td class="stiJsViewerClearAllStyles" style="padding: 12px;"><div
							class="stiJsViewerFormButtonTheme stiJsViewerFormButtonThemeDefault"
							style="font-family: Arial; height: 23px; box-sizing: content-box; min-width: 80px;">
							<table class="stiJsViewerClearAllStyles" cellpadding="0"
								cellspacing="0" style="width: 100%; height: 100%;">
								<tbody>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"
											style="padding: 0px 10px; white-space: nowrap; text-align: center; width: 100%;">OK</td>
									</tr>
								</tbody>
							</table>
						</div></td>
					<td class="stiJsViewerClearAllStyles"
						style="padding: 12px 12px 12px 0px;"><div
							class="stiJsViewerFormButton stiJsViewerFormButtonDefault"
							style="font-family: Arial; height: 23px; box-sizing: content-box; min-width: 80px;">
							<table class="stiJsViewerClearAllStyles" cellpadding="0"
								cellspacing="0" style="width: 100%; height: 100%;">
								<tbody>
									<tr class="stiJsViewerClearAllStyles">
										<td class="stiJsViewerClearAllStyles"
											style="padding: 0px 10px; white-space: nowrap; text-align: center; width: 100%;">Cancel</td>
									</tr>
								</tbody>
							</table>
						</div></td>
				</tr>
			</tbody>
		</table>
	</div>
</div>
<style>
  .stiJsViewerMainPanel *, .stiJsViewerMainPanel *:before, .stiJsViewerMainPanel *:after {
    box-sizing: content-box;
    border-collapse: initial;
}

.stiJsViewerForm {
    position: absolute;
    border: 1px solid #19478a;
    background: #ffffff;
    -moz-box-shadow: 0px 0px 7px rgba(0,0,0,0.6);
    -webkit-box-shadow: 0px 0px 7px rgb(0 0 0 / 60%);
    box-shadow: 0 0 7px rgb(0 0 0 / 30%);
    cursor: default;
    -moz-user-select: none;
    -khtml-user-select: none;
    -webkit-user-select: none;
    -ms-user-select: none;
    text-align: left;
    color: #202020;
}

.stiJsViewerClearAllStyles {
    padding: 0px;
    margin: 0px;
    border: 0px;
    margin-top: 0px;
    margin-bottom: 0px;
    margin-left: 0px;
    margin-right: 0px;
    line-height: normal;
}

.stiJsViewerAuthFormCaption {
    font-family: Arial;
    color: #7a8d8e;
    font-size: 28px;
}

.stiJsViewerAuthFormContainer {
    padding: 5px 10px 0px 10px;
    background: #ffffff;
    overflow-y: auto;
    overflow-x: hidden;
}

.stiJsViewerTextBoxDefault {
    border-radius: 3px;
    border: 1px solid #ababab;
}

.stiJsViewerTextBox {
    font-size: 12px;
    margin: 0px;
    padding: 0px 0px 0px 4px;
    -webkit-border-radius: 0px;
    outline: none;
    background-image: -webkit-gradient(linear, 0% 0%, 0% 100%, from(hsla(0,0%,100%,0)), to(hsla(0,0%,100%,0)));
    background-image: -webkit-linear-gradient(hsla(0,0%,100%,0), hsla(0,0%,100%,0));
    background: #ffffff;
    color: #202020;
}

.stiJsViewerLoginButtonDefault {
    background: #19478a;
}

.stiJsViewerLoginButton {
    border: none;
    border-radius: 3px;
    height: 40px;
    color: white;
    cursor: default;
    font-family: Arial;
    font-size: 19px;
    width: 100%;
    -moz-user-select: none;
    -khtml-user-select: none;
    -webkit-user-select: none;
    -ms-user-select: none;
}

.stiJsViewerLoginButton:hover {
    background: #3b629b;
}
</style>
  `
                }]
        }], ctorParameters: () => [], propDecorators: { loginInfo: [{
                type: Input
            }], onLogin: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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