import { Component } from "@angular/core";
import { StiLocalizationService } from "../services/sti-localization.service";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/http-client.service";
import * as i3 from "../services/sti-user-service";
import * as i4 from "../services/sti-localization.service";
import * as i5 from "../services/sti-helper.service";
import * as i6 from "../services/sti-local-storage.service";
import * as i7 from "@angular/common";
export class StiLocalizationPreviewComponent {
    constructor(model, httpService, userService, loc, helper, stiLocalStorage) {
        this.model = model;
        this.httpService = httpService;
        this.userService = userService;
        this.loc = loc;
        this.helper = helper;
        this.stiLocalStorage = stiLocalStorage;
        this.itemWidth = 150;
    }
    get items() {
        return this.loc.localizationList ? this.loc.localizationList : [];
    }
    get itemsInRow() {
        return new Array(3).fill(1);
    }
    get rows() {
        return this.items ? new Array(Math.ceil(this.items.length / this.itemsInRow.length)).fill(2) : new Array(0).fill(0);
    }
    setEvent(event) {
        let localization;
        if (event != "Default") {
            localization = this.loc.localizationList?.find((item) => this.model.isWebView ? item.language == event : item.fileName == event);
        }
        else {
            localization = this.loc.defaultLocalization;
        }
        this.loc.currentLocalization = localization;
        if (event == "Default") {
            this.httpService
                .post("", {
                action: "InterfaceEvent",
                event: "LocalizationButtonClick",
                localization: this.model.isWebView
                    ? this.loc.defaultLocalization.language
                    : this.loc.defaultLocalization.fileName,
            })
                .subscribe(() => { });
            this.loc.currentLocalization = this.loc.defaultLocalization;
        }
        else {
            this.httpService
                .post("", { action: "InterfaceEvent", event: "LocalizationButtonClick", localization: event })
                .subscribe(() => { });
            this.loc.currentLocalization = this.loc.localizationList?.find((item) => this.model.isWebView ? item.language == event : item.fileName == event);
        }
        this.stiLocalStorage.setItem("StiFormsLocalization", JSON.stringify(this.loc.currentLocalization));
        this.httpService
            .post(this.model.requestUrl, { action: "GetLocalization", localization: localization.cultureName })
            .subscribe((data) => {
            StiLocalizationService.setLocalization(data.localization);
            this.model.needToRefresh.next(true);
            this.helper.updateHelper();
        });
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiLocalizationPreviewComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHttpClientService }, { token: i3.StiUserService }, { token: i4.StiLocalizationService }, { token: i5.StiHelperService }, { token: i6.StiLocalStorageService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiLocalizationPreviewComponent, selector: "sti-localization-preview", ngImport: i0, template: `
    <div
      class="parent-localization-container"
      [style.visibility]="userService.showLocalizationPreview ? 'visible' : 'hidden'"
      [style.left.px]="userService.previewX"
      [style.top.px]="userService.previewY"
      [style.width.px]="loc.localizationList?.length > 0 ? 465 : 155"
    >
      <div class="default" [style.width.px]="loc.localizationList?.length > 0 ? 460 : 155">
        <div class="item" (click)="setEvent('Default')" [style.margin.px]="1">
          <span>{{ loc.getP("Default") }}</span>
        </div>
        <div
          *ngIf="loc.localizationList?.length > 0"
          class="item {{ loc.defaultLocalization?.language == loc.currentLocalization?.language ? 'current' : '' }}"
          [style.margin.px]="1"
          (click)="setEvent('Default')"
        >
          <span>{{ loc.defaultLocalization?.description }}</span>
        </div>
      </div>
      <div *ngIf="loc.localizationList?.length > 0" class="localization-list">
        <table class="sti-clear" [style.width]="'100%'">
          <tr *ngFor="let row of rows; index as i" class="row-container">
            <td *ngFor="let item of itemsInRow; index as ind">
              <div
                *ngIf="items[i * itemsInRow.length + ind]"
                (click)="
                  model.isWebView
                    ? setEvent(items[i * itemsInRow.length + ind]?.language)
                    : setEvent(items[i * itemsInRow.length + ind]?.fileName)
                "
                class="item {{
                  items[i * itemsInRow.length + ind]?.language == loc.currentLocalization?.language ? 'current' : ''
                }}"
              >
                <span>{{ items[i * itemsInRow.length + ind]?.description }}</span>
              </div>
            </td>
          </tr>
        </table>
      </div>
    </div>
  `, isInline: true, styles: ["table{border-spacing:2px}td{padding:0;max-width:150px;height:32px}.parent-localization-container{position:absolute;z-index:999;background-color:var(--back-color);-webkit-touch-callout:none;-webkit-user-select:none;height:max-content;padding:1px;border:1px solid #c6c6c6;border-radius:3px;font-size:12px;font-family:Arial;color:#444;overflow:hidden;max-height:600px;box-shadow:0 0 7px #0000004d}.localization-list{width:460px;display:flex;flex-wrap:wrap;padding-top:1px}.default{width:460px;display:flex;flex-wrap:wrap;padding-bottom:1px;border-bottom:1px dotted #c6c6c6}.item{width:151.2px;border-radius:3px;height:32px;display:flex;align-items:center;justify-content:center;background-color:var(--back-color);border:1px solid #c6c6c6}.item:hover{background-color:#dadada;border-color:#c6c6c6}.current{background-color:#e5e5e5}\n"], dependencies: [{ kind: "directive", type: i7.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i7.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiLocalizationPreviewComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-localization-preview", template: `
    <div
      class="parent-localization-container"
      [style.visibility]="userService.showLocalizationPreview ? 'visible' : 'hidden'"
      [style.left.px]="userService.previewX"
      [style.top.px]="userService.previewY"
      [style.width.px]="loc.localizationList?.length > 0 ? 465 : 155"
    >
      <div class="default" [style.width.px]="loc.localizationList?.length > 0 ? 460 : 155">
        <div class="item" (click)="setEvent('Default')" [style.margin.px]="1">
          <span>{{ loc.getP("Default") }}</span>
        </div>
        <div
          *ngIf="loc.localizationList?.length > 0"
          class="item {{ loc.defaultLocalization?.language == loc.currentLocalization?.language ? 'current' : '' }}"
          [style.margin.px]="1"
          (click)="setEvent('Default')"
        >
          <span>{{ loc.defaultLocalization?.description }}</span>
        </div>
      </div>
      <div *ngIf="loc.localizationList?.length > 0" class="localization-list">
        <table class="sti-clear" [style.width]="'100%'">
          <tr *ngFor="let row of rows; index as i" class="row-container">
            <td *ngFor="let item of itemsInRow; index as ind">
              <div
                *ngIf="items[i * itemsInRow.length + ind]"
                (click)="
                  model.isWebView
                    ? setEvent(items[i * itemsInRow.length + ind]?.language)
                    : setEvent(items[i * itemsInRow.length + ind]?.fileName)
                "
                class="item {{
                  items[i * itemsInRow.length + ind]?.language == loc.currentLocalization?.language ? 'current' : ''
                }}"
              >
                <span>{{ items[i * itemsInRow.length + ind]?.description }}</span>
              </div>
            </td>
          </tr>
        </table>
      </div>
    </div>
  `, styles: ["table{border-spacing:2px}td{padding:0;max-width:150px;height:32px}.parent-localization-container{position:absolute;z-index:999;background-color:var(--back-color);-webkit-touch-callout:none;-webkit-user-select:none;height:max-content;padding:1px;border:1px solid #c6c6c6;border-radius:3px;font-size:12px;font-family:Arial;color:#444;overflow:hidden;max-height:600px;box-shadow:0 0 7px #0000004d}.localization-list{width:460px;display:flex;flex-wrap:wrap;padding-top:1px}.default{width:460px;display:flex;flex-wrap:wrap;padding-bottom:1px;border-bottom:1px dotted #c6c6c6}.item{width:151.2px;border-radius:3px;height:32px;display:flex;align-items:center;justify-content:center;background-color:var(--back-color);border:1px solid #c6c6c6}.item:hover{background-color:#dadada;border-color:#c6c6c6}.current{background-color:#e5e5e5}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHttpClientService }, { type: i3.StiUserService }, { type: i4.StiLocalizationService }, { type: i5.StiHelperService }, { type: i6.StiLocalStorageService }] });
//# sourceMappingURL=data:application/json;base64,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