import { Component, Input, ViewChild } from "@angular/core";
import { StiLabelAlignment } from "../../system/enums";
import { StiBorderArea } from "../../properties/StiBorderArea";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "../sti-component";
import * as i4 from "../sti-editable-content.component";
import * as i5 from "../sti-tooltip/sti-tooltip.directive";
export class StiImageComponent {
    get align() {
        return "start";
    }
    get image() {
        return this.element.image ? "url(" + this.element.image + ")" : null;
    }
    get imageWidth() {
        if (this.isClone) {
            return 0;
        }
        else {
            if (this.element["label"]["alignment"] != StiLabelAlignment.Top && this.element["label"]["value"]) {
                return this.element.width - this.element.label.width - this.element.padding.right - this.element.padding.left;
            }
            else {
                return this.element.width - this.element.padding.right - this.element.padding.left /*borderWidth */;
            }
        }
    }
    get imageHeight() {
        return this.element.canvasHeight;
    }
    get borderArea() {
        if (!this.isClone) {
            let borderArea = new StiBorderArea();
            borderArea.top =
                this.ref?.nativeElement?.offsetTop -
                    (this.element.label.alignment != StiLabelAlignment.Top ? this.element.padding.top : 0);
            borderArea.left = this.ref?.nativeElement?.offsetLeft;
            borderArea.width = this.ref?.nativeElement?.offsetWidth - this.element.padding.left - this.element.padding.right;
            borderArea.height = this.ref?.nativeElement?.offsetHeight;
            borderArea.border = this.element.border;
            return borderArea;
        }
    }
    onFileSelected(event) {
        if (event.files && event.files[0]) {
            var reader = new FileReader();
            reader.onload = (e) => {
                this.element.image = e.target.result;
            };
            reader.readAsDataURL(event.files[0]);
        }
    }
    openLink() {
        if (this.element.hyperlink.length > 0 && this.model.previewMode) {
            window.open(this.element.hyperlink, "_blank");
        }
    }
    get backgroundSize() {
        if (this.element.preserveAspectRatio) {
            return "contain";
        }
        else {
            return this.imageWidth + "px " + this.imageHeight + "px";
        }
    }
    constructor(model) {
        this.model = model;
        this.isClone = false;
    }
    ngAfterViewInit() {
        if (!this.isClone) {
            this.element.element = this.ref?.nativeElement;
        }
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiImageComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiImageComponent, selector: "sti-image-component", inputs: { element: "element", isClone: "isClone" }, viewQueries: [{ propertyName: "ref", first: true, predicate: ["ref"], descendants: true }], ngImport: i0, template: ` <sti-component [element]="element" [borderArea]="borderArea" [isClone]="isClone" class="sti-image">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'100%'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'" [style.height]="'100%'">
          <div
            #ref
            (dblclick)="!model.previewMode ? inputFile.click() : ''"
            (click)="openLink()"
            class="image"
            [style.align-self]="'center'"
            [style.width]="'100%'"
            [style.height]="'100%'"
            [style.min-width.px]="isClone ? 30 : 0"
            [style.min-height.px]="isClone ? 30 : 0"
            [style.background-image]="image"
            [style.background-position]="element.preserveAspectRatio ? '' : 'center'"
            [style.background-size]="backgroundSize"
            [style.background-repeat]="image ? 'no-repeat' : ''"
            [stiTooltip]="element?.tooltip"
            tooltipPosition="bottom"
            showDelay="500"
            [style.cursor]="element.hyperlink.length > 0 ? 'pointer' : model.previewMode ? 'default' : 'move'"
          ></div>
          <input
            type="file"
            [style.display]="'none'"
            accept=".jpg, .jpeg, .png"
            (change)="onFileSelected($event.target)"
            #inputFile
          />
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, isInline: true, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.sti-image .image{position:relative}\n"], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i3.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i4.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "directive", type: i5.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiImageComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-image-component", template: ` <sti-component [element]="element" [borderArea]="borderArea" [isClone]="isClone" class="sti-image">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [required]="element.required"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'100%'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'" [style.height]="'100%'">
          <div
            #ref
            (dblclick)="!model.previewMode ? inputFile.click() : ''"
            (click)="openLink()"
            class="image"
            [style.align-self]="'center'"
            [style.width]="'100%'"
            [style.height]="'100%'"
            [style.min-width.px]="isClone ? 30 : 0"
            [style.min-height.px]="isClone ? 30 : 0"
            [style.background-image]="image"
            [style.background-position]="element.preserveAspectRatio ? '' : 'center'"
            [style.background-size]="backgroundSize"
            [style.background-repeat]="image ? 'no-repeat' : ''"
            [stiTooltip]="element?.tooltip"
            tooltipPosition="bottom"
            showDelay="500"
            [style.cursor]="element.hyperlink.length > 0 ? 'pointer' : model.previewMode ? 'default' : 'move'"
          ></div>
          <input
            type="file"
            [style.display]="'none'"
            accept=".jpg, .jpeg, .png"
            (change)="onFileSelected($event.target)"
            #inputFile
          />
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.sti-image .image{position:relative}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }], propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }], ref: [{
                type: ViewChild,
                args: ["ref"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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