import { Component, ViewChild } from "@angular/core";
import { StiHorizontalAlignment } from "../../system/enums";
import { StiTextItem } from "../../elements/text/StiTextItem";
import StiJson from "../../system/StiJson";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-helper.service";
import * as i3 from "../../services/sti-localization.service";
import * as i4 from "../../services/sti-color-dialog.service";
import * as i5 from "../../services/sti-signature.service";
import * as i6 from "../sti-dropdown-component/sti-dropdown-component";
import * as i7 from "../sti-tooltip/sti-tooltip.directive";
import * as i8 from "../sti-select-button/sti-select-button.component";
export class StiEmbedTextEditorComponent {
    constructor(model, helper, loc, colorService, signatureService) {
        this.model = model;
        this.helper = helper;
        this.loc = loc;
        this.colorService = colorService;
        this.signatureService = signatureService;
        this.currentText = new StiTextItem();
    }
    get alignment() {
        if (this.currentText.horizontalAlignment == StiHorizontalAlignment.Center) {
            return "center";
        }
        else if (this.currentText.horizontalAlignment == StiHorizontalAlignment.Right) {
            return "end";
        }
        else {
            return "start";
        }
    }
    ngAfterViewInit() {
        setTimeout(() => {
            this.textInput.nativeElement.focus();
        });
    }
    showColorPicker(element, object, isRichText = false) {
        this.colorService.openDialog(element, object, isRichText);
    }
    setContent(innerText) {
        /* if ((this.model.getBrowserType() == "safari" || this.model.getBrowserType() == "firefox") && this.showPlaceholder) {
          this.editableContentService.startEdit();
        }
        if (
          this.model.getBrowserType() == "safari" ||
          (this.model.getBrowserType() == "firefox" && !this.showPlaceholder)
        ) {
          this.cdr.detach();
        } */
        this.currentText.value = innerText;
    }
    ngOnInit() {
        this.currentText = this.cloneTextItem(this.signatureService.currentEditableText);
        this.updateSignatureSubscription = this.signatureService.getInsertedInformation.subscribe((event) => {
            if (event.eventName == "TextEditor") {
                this.signatureService.updateSignature.next({ type: "Text", value: this.currentText });
            }
        });
    }
    cloneTextItem(textItem) {
        let result = new StiTextItem();
        let jObject = new StiJson();
        jObject.deserialize(textItem.saveToJsonObject({}).serialize());
        result.loadFromJsonObject(jObject);
        return result;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiEmbedTextEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiLocalizationService }, { token: i4.StiColorDialogService }, { token: i5.SignatureService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiEmbedTextEditorComponent, selector: "embed-text-editor", viewQueries: [{ propertyName: "textInput", first: true, predicate: ["textInput"], descendants: true }], ngImport: i0, template: ` <div class="editor-container">
    <div class="editor-navigation">
      <sti-dropdown-component
        [id]="4"
        [options]="model.fontFamilies"
        [(value)]="currentText.font.family"
        [tooltip]="loc.get2('HelpDesigner', 'FontName')"
        [isMinVersion]="true"
        [optionLabel]="'name'"
        [optionValue]="'name'"
        [style]="{
          width: '100px',
          height: '24px',
          alignItems: 'center',
          marginRight: '5px',
          fontSize: '12px'
        }"
      ></sti-dropdown-component>
      <sti-dropdown-component
        [id]="5"
        [options]="helper.fontSizes"
        [(value)]="currentText.font.size"
        [tooltip]="loc.getP('FontSize')"
        [isMinVersion]="true"
        [style]="{
          width: '45px',
          height: '24px',
          alignItems: 'center',
          marginRight: '5px',
          fontSize: '12px'
        }"
      ></sti-dropdown-component>
      <sti-selectButton
        [options]="helper.styleOptions"
        [(value)]="currentText.font.style"
        [multiple]="true"
        optionValue="value"
        [style]="{ height: '26px', minWidth: '87px' }"
        ><ng-template let-item>
          <img
            [src]="model.getImage(item.image)"
            [stiTooltip]="loc.getP(item.value)"
            tooltipPosition="bottom"
            showDelay="500"
          /> </ng-template
      ></sti-selectButton>
      <div class="vertical-line"></div>
      <div
        class="button-container"
        [stiTooltip]="loc.getP('ForeColor')"
        tooltipPosition="bottom"
        showDelay="500"
        (click)="showColorPicker(fontColorEditor, currentText.color)"
        (mousedown)="$event.preventDefault()"
        #fontColorEditor
      >
        <div class="preview-container">
          <div class="foreground" [style]="{ backgroundPosition: 'center', backgroundRepeat: 'no-repeat' }">
            <img [src]="model.getImage('images.Brush.png')" alt="" />
          </div>
          <span
            class="color-preview"
            [style.background-color]="
              currentText.color != null ? currentText.color?.toHtmlColor() : 'rgb(182, 181, 180)'
            "
          ></span>
        </div>
        <div [style]="{ position: 'relative', alignSelf: 'center' }">
          <i class="pi pi-chevron-down"></i>
        </div>
      </div>
      <div class="vertical-line"></div>
      <sti-selectButton
        [options]="helper.justifyOptions"
        [(value)]="currentText.eContentAlignment"
        optionValue="value"
        [style]="{ height: '26px', minWidth: '94px' }"
      >
        <ng-template let-item>
          <img
            [src]="model.getImage(item.image)"
            [stiTooltip]="loc.getP(item.name)"
            tooltipPosition="bottom"
            showDelay="500"
            [style]="{ height: '16px', width: '16px' }"
          />
        </ng-template>
      </sti-selectButton>
    </div>
    <div class="text-container" (click)="textInput.focus()">
      <label
        class="text-input"
        #textInput
        spellcheck="false"
        [attr.contenteditable]="'plaintext-only'"
        [style]="currentText.htmlStyle()"
        [textContent]="currentText.value"
        [style.text-align]="alignment"
        (input)="setContent($event.target.textContent)"
      ></label>
    </div>
  </div>`, isInline: true, styles: [".text-input{width:100%;height:100%;min-width:10px;margin:0;outline:none;max-width:100%;overflow:hidden;scroll-behavior:smooth;padding:4px}.text-container:hover{cursor:text}.text-container{display:flex}.preview-container{display:flex;width:100%;position:relative;flex-direction:column}.button-container{display:flex;height:26px;width:40px;position:relative;margin:0 2px;border-radius:3px}.button-container:hover{background-color:var(--hover-color)}.button-container:active{background-color:var(--columnDeleteHover-color)}.color-preview{width:20px;height:5px;margin-left:4px}i{height:12px;width:12px;right:3px;top:50%;vertical-align:middle;color:var(--text-color)}.button-container:hover i{color:#fff}.foreground{margin-left:8px;margin-top:2px;width:16px;height:18px}.vertical-line{height:26px;width:1px;background-color:#d3d3d3;margin:0 3px}img{max-width:16px}.text-container{border-radius:3px;border:1px dashed lightgray;height:100%;width:100%}.editor-container{height:calc(100% - 20px);width:calc(100% - 20px);margin:10px;display:flex;flex-direction:column}.editor-navigation{height:26px;margin-bottom:5px;margin-top:10px;display:flex}.navigation-button:hover{background-color:#d3d3d3}.navigation-button{height:26px;width:26px;margin-right:2px;border-radius:3px;display:flex;align-items:center;justify-content:center}.navigation-button img{height:16px;width:16px}\n"], dependencies: [{ kind: "component", type: i6.StiDropdownComponent, selector: "sti-dropdown-component", inputs: ["id", "options", "value", "disabled", "optionLabel", "optionValue", "isMinVersion", "tooltip"], outputs: ["valueChange"] }, { kind: "directive", type: i7.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }, { kind: "component", type: i8.StiSelectButtonComponent, selector: "sti-selectButton", inputs: ["options", "value", "optionLabel", "optionValue", "multiple", "disabled"], outputs: ["onOptionClick", "onChange", "valueChange"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiEmbedTextEditorComponent, decorators: [{
            type: Component,
            args: [{ selector: "embed-text-editor", template: ` <div class="editor-container">
    <div class="editor-navigation">
      <sti-dropdown-component
        [id]="4"
        [options]="model.fontFamilies"
        [(value)]="currentText.font.family"
        [tooltip]="loc.get2('HelpDesigner', 'FontName')"
        [isMinVersion]="true"
        [optionLabel]="'name'"
        [optionValue]="'name'"
        [style]="{
          width: '100px',
          height: '24px',
          alignItems: 'center',
          marginRight: '5px',
          fontSize: '12px'
        }"
      ></sti-dropdown-component>
      <sti-dropdown-component
        [id]="5"
        [options]="helper.fontSizes"
        [(value)]="currentText.font.size"
        [tooltip]="loc.getP('FontSize')"
        [isMinVersion]="true"
        [style]="{
          width: '45px',
          height: '24px',
          alignItems: 'center',
          marginRight: '5px',
          fontSize: '12px'
        }"
      ></sti-dropdown-component>
      <sti-selectButton
        [options]="helper.styleOptions"
        [(value)]="currentText.font.style"
        [multiple]="true"
        optionValue="value"
        [style]="{ height: '26px', minWidth: '87px' }"
        ><ng-template let-item>
          <img
            [src]="model.getImage(item.image)"
            [stiTooltip]="loc.getP(item.value)"
            tooltipPosition="bottom"
            showDelay="500"
          /> </ng-template
      ></sti-selectButton>
      <div class="vertical-line"></div>
      <div
        class="button-container"
        [stiTooltip]="loc.getP('ForeColor')"
        tooltipPosition="bottom"
        showDelay="500"
        (click)="showColorPicker(fontColorEditor, currentText.color)"
        (mousedown)="$event.preventDefault()"
        #fontColorEditor
      >
        <div class="preview-container">
          <div class="foreground" [style]="{ backgroundPosition: 'center', backgroundRepeat: 'no-repeat' }">
            <img [src]="model.getImage('images.Brush.png')" alt="" />
          </div>
          <span
            class="color-preview"
            [style.background-color]="
              currentText.color != null ? currentText.color?.toHtmlColor() : 'rgb(182, 181, 180)'
            "
          ></span>
        </div>
        <div [style]="{ position: 'relative', alignSelf: 'center' }">
          <i class="pi pi-chevron-down"></i>
        </div>
      </div>
      <div class="vertical-line"></div>
      <sti-selectButton
        [options]="helper.justifyOptions"
        [(value)]="currentText.eContentAlignment"
        optionValue="value"
        [style]="{ height: '26px', minWidth: '94px' }"
      >
        <ng-template let-item>
          <img
            [src]="model.getImage(item.image)"
            [stiTooltip]="loc.getP(item.name)"
            tooltipPosition="bottom"
            showDelay="500"
            [style]="{ height: '16px', width: '16px' }"
          />
        </ng-template>
      </sti-selectButton>
    </div>
    <div class="text-container" (click)="textInput.focus()">
      <label
        class="text-input"
        #textInput
        spellcheck="false"
        [attr.contenteditable]="'plaintext-only'"
        [style]="currentText.htmlStyle()"
        [textContent]="currentText.value"
        [style.text-align]="alignment"
        (input)="setContent($event.target.textContent)"
      ></label>
    </div>
  </div>`, styles: [".text-input{width:100%;height:100%;min-width:10px;margin:0;outline:none;max-width:100%;overflow:hidden;scroll-behavior:smooth;padding:4px}.text-container:hover{cursor:text}.text-container{display:flex}.preview-container{display:flex;width:100%;position:relative;flex-direction:column}.button-container{display:flex;height:26px;width:40px;position:relative;margin:0 2px;border-radius:3px}.button-container:hover{background-color:var(--hover-color)}.button-container:active{background-color:var(--columnDeleteHover-color)}.color-preview{width:20px;height:5px;margin-left:4px}i{height:12px;width:12px;right:3px;top:50%;vertical-align:middle;color:var(--text-color)}.button-container:hover i{color:#fff}.foreground{margin-left:8px;margin-top:2px;width:16px;height:18px}.vertical-line{height:26px;width:1px;background-color:#d3d3d3;margin:0 3px}img{max-width:16px}.text-container{border-radius:3px;border:1px dashed lightgray;height:100%;width:100%}.editor-container{height:calc(100% - 20px);width:calc(100% - 20px);margin:10px;display:flex;flex-direction:column}.editor-navigation{height:26px;margin-bottom:5px;margin-top:10px;display:flex}.navigation-button:hover{background-color:#d3d3d3}.navigation-button{height:26px;width:26px;margin-right:2px;border-radius:3px;display:flex;align-items:center;justify-content:center}.navigation-button img{height:16px;width:16px}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiLocalizationService }, { type: i4.StiColorDialogService }, { type: i5.SignatureService }], propDecorators: { textInput: [{
                type: ViewChild,
                args: ["textInput"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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