import { Component } from "@angular/core";
import { StiHorizontalAlignment, StiVerticalAlignment } from "../../system/enums";
import { StiImageEditorResult } from "../../elements/signature/StiImageEditorResult";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-localization.service";
import * as i3 from "../../services/sti-helper.service";
import * as i4 from "../../services/sti-signature.service";
import * as i5 from "../sti-universal-checkbox/sti-universal-checkbox.component";
import * as i6 from "../sti-tooltip/sti-tooltip.directive";
import * as i7 from "../sti-select-button/sti-select-button.component";
export class StiEmbedImageEditorComponent {
    get hasImage() {
        return this.loadedImage ? true : false;
    }
    get image() {
        return "url(" + this.loadedImage + ")";
    }
    clear() {
        this.loadedImage = null;
    }
    getBackgroundSize(container) {
        if (!this.loadedImage) {
            return;
        }
        if (this.useAspectRatio && this.useStretch) {
            return "contain";
        }
        if (this.useStretch) {
            return `${container.offsetWidth}px ${container.offsetHeight}px`;
        }
        else {
            return `${this.currentImageNaturalWidth}px ${this.currentImageNaturalHeight}px`;
        }
    }
    getBackgroundPosition() {
        if (this.useStretch && !this.useAspectRatio) {
            return `center`;
        }
        else {
            return `${this.signatureService.getVerticalPosition(this.currentVerticalAlignment)} ${this.signatureService.getHorizontalPosition(this.currentHorizontalAlignment)}`;
        }
    }
    getHorizontalAlignment() {
        if (this.currentHorizontalAlignment == StiHorizontalAlignment.Center) {
            return "center";
        }
        else if (this.currentHorizontalAlignment == StiHorizontalAlignment.Left) {
            return "start";
        }
        else {
            return "end";
        }
    }
    onFileSelected(event) {
        if (event.files && event.files[0]) {
            var reader = new FileReader();
            reader.onload = (e) => {
                let image = new Image();
                image.onload = () => {
                    this.currentImageNaturalHeight = image.naturalHeight;
                    this.currentImageNaturalWidth = image.naturalWidth;
                };
                image.src = e.target.result;
                setTimeout(() => {
                    this.loadedImage = e.target.result;
                });
            };
            reader.readAsDataURL(event.files[0]);
        }
    }
    constructor(model, loc, helper, signatureService) {
        this.model = model;
        this.loc = loc;
        this.helper = helper;
        this.signatureService = signatureService;
        this.currentVerticalAlignment = StiVerticalAlignment.Center;
        this.currentHorizontalAlignment = StiHorizontalAlignment.Center;
        this.useAspectRatio = false;
        this.useStretch = false;
        this.currentImageNaturalWidth = 0;
        this.currentImageNaturalHeight = 0;
    }
    ngOnInit() {
        if (this.signatureService.currentEditableImage) {
            this.loadedImage = this.signatureService.currentEditableImage.loadedImage;
            this.currentVerticalAlignment = this.signatureService.currentEditableImage.verticalAlignment;
            this.currentHorizontalAlignment = this.signatureService.currentEditableImage.horizontalAlignment;
            this.useAspectRatio = this.signatureService.currentEditableImage.aspectRatio;
            this.useStretch = this.signatureService.currentEditableImage.stretch;
            this.currentImageNaturalHeight = this.signatureService.currentEditableImage.naturalHeight;
            this.currentImageNaturalWidth = this.signatureService.currentEditableImage.naturalWidth;
        }
        this.updateSignatureSubscription = this.signatureService.getInsertedInformation.subscribe((event) => {
            if (event.eventName == "ImageEditor") {
                let resultObject = new StiImageEditorResult();
                resultObject.loadedImage = this.loadedImage;
                resultObject.verticalAlignment = this.currentVerticalAlignment;
                resultObject.horizontalAlignment = this.currentHorizontalAlignment;
                resultObject.aspectRatio = this.useAspectRatio;
                resultObject.stretch = this.useStretch;
                resultObject.naturalHeight = this.currentImageNaturalHeight;
                resultObject.naturalWidth = this.currentImageNaturalWidth;
                this.signatureService.updateSignature.next({ type: "Image", value: resultObject });
            }
        });
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiEmbedImageEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }, { token: i3.StiHelperService }, { token: i4.SignatureService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiEmbedImageEditorComponent, selector: "embed-image-editor", ngImport: i0, template: `<div class="editor-container">
    <div class="editor-navigation">
      <div
        class="navigation-button"
        [style.min-width.px]="50"
        [style.padding]="'0px 10px'"
        [style.width]="'auto'"
        (click)="inputFile.click()"
      >
        <img [src]="model.getImage('images.Other.Open.png')" />
        <span [style.margin-left.px]="2"> {{ loc.get2("Buttons", "Open") }}</span>
      </div>
      <div class="navigation-button {{ hasImage ? '' : 'disabled' }}" (click)="clear()">
        <img [src]="model.getImage('images.Ribbon.Delete.png')" />
      </div>
      <sti-selectButton
        [options]="helper.justifyOptions"
        [(value)]="currentHorizontalAlignment"
        [disabled]="!hasImage"
        optionValue="value"
        [style]="{ height: '26px', minWidth: '94px' }"
      >
        <ng-template let-item>
          <img
            [src]="model.getImage(item.image)"
            [stiTooltip]="loc.getP(item.name)"
            tooltipPosition="bottom"
            showDelay="500"
            [style]="{ height: '16px', width: '16px' }"
          />
        </ng-template>
      </sti-selectButton>
      <sti-selectButton
        [options]="helper.verticalAlignment"
        [(value)]="currentVerticalAlignment"
        [disabled]="!hasImage"
        optionValue="value"
        [style]="{ height: '26px', minWidth: '94px' }"
      >
        <ng-template let-item>
          <img
            [src]="model.getImage(item.image)"
            [stiTooltip]="loc.getP(item.name)"
            tooltipPosition="bottom"
            showDelay="500"
            [style]="{ height: '16px', width: '16px' }"
          />
        </ng-template>
      </sti-selectButton>
      <sti-checkbox
        class="min-version"
        [(value)]="useAspectRatio"
        [disabled]="!hasImage"
        [label]="'Aspect Ratio'"
      ></sti-checkbox>
      <sti-checkbox
        class="min-version"
        [(value)]="useStretch"
        [disabled]="!hasImage"
        [label]="'Stretch'"
      ></sti-checkbox>
    </div>
    <div class="image-container" #imageContainer [style.justify-content]="getHorizontalAlignment()">
      <input
        type="file"
        [style.display]="'none'"
        accept=".jpg, .jpeg, .png"
        (click)="$event.target.value = null"
        (change)="onFileSelected($event.target)"
        #inputFile
      />
      <div
        class="image-preview"
        [style.width.px]="useStretch && useAspectRatio ? imageContainer.clientHeight : imageContainer.clientWidth"
        [style.height.px]="imageContainer.clientHeight"
        [style.background-image]="image"
        [style.background-position]="getBackgroundPosition()"
        [style.background-size]="getBackgroundSize(imageContainer)"
        [style.background-repeat]="image ? 'no-repeat' : ''"
      ></div>
    </div>
  </div>`, isInline: true, styles: [".image-preview{width:100%;height:100%}.disabled{pointer-events:none;opacity:.6}sti-checkbox{font-size:12px!important;font-family:Arial!important;margin:0 5px}sti-checkbox .label{font-size:12px!important}.image-container{border-radius:3px;border:1px dashed lightgray;height:100%;width:100%;display:flex}.editor-container{height:calc(100% - 20px);width:calc(100% - 20px);margin:10px;display:flex;flex-direction:column}.editor-navigation{height:26px;margin-bottom:5px;margin-top:10px;display:flex}.navigation-button:hover{background-color:#d3d3d3}.navigation-button{height:26px;width:26px;margin-right:2px;border-radius:3px;display:flex;align-items:center;justify-content:center}.navigation-button img{height:16px;width:16px}\n"], dependencies: [{ kind: "component", type: i5.StiUniversalCheckboxComponent, selector: "sti-checkbox", inputs: ["value", "disabled", "label"], outputs: ["valueChange"] }, { kind: "directive", type: i6.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }, { kind: "component", type: i7.StiSelectButtonComponent, selector: "sti-selectButton", inputs: ["options", "value", "optionLabel", "optionValue", "multiple", "disabled"], outputs: ["onOptionClick", "onChange", "valueChange"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiEmbedImageEditorComponent, decorators: [{
            type: Component,
            args: [{ selector: "embed-image-editor", template: `<div class="editor-container">
    <div class="editor-navigation">
      <div
        class="navigation-button"
        [style.min-width.px]="50"
        [style.padding]="'0px 10px'"
        [style.width]="'auto'"
        (click)="inputFile.click()"
      >
        <img [src]="model.getImage('images.Other.Open.png')" />
        <span [style.margin-left.px]="2"> {{ loc.get2("Buttons", "Open") }}</span>
      </div>
      <div class="navigation-button {{ hasImage ? '' : 'disabled' }}" (click)="clear()">
        <img [src]="model.getImage('images.Ribbon.Delete.png')" />
      </div>
      <sti-selectButton
        [options]="helper.justifyOptions"
        [(value)]="currentHorizontalAlignment"
        [disabled]="!hasImage"
        optionValue="value"
        [style]="{ height: '26px', minWidth: '94px' }"
      >
        <ng-template let-item>
          <img
            [src]="model.getImage(item.image)"
            [stiTooltip]="loc.getP(item.name)"
            tooltipPosition="bottom"
            showDelay="500"
            [style]="{ height: '16px', width: '16px' }"
          />
        </ng-template>
      </sti-selectButton>
      <sti-selectButton
        [options]="helper.verticalAlignment"
        [(value)]="currentVerticalAlignment"
        [disabled]="!hasImage"
        optionValue="value"
        [style]="{ height: '26px', minWidth: '94px' }"
      >
        <ng-template let-item>
          <img
            [src]="model.getImage(item.image)"
            [stiTooltip]="loc.getP(item.name)"
            tooltipPosition="bottom"
            showDelay="500"
            [style]="{ height: '16px', width: '16px' }"
          />
        </ng-template>
      </sti-selectButton>
      <sti-checkbox
        class="min-version"
        [(value)]="useAspectRatio"
        [disabled]="!hasImage"
        [label]="'Aspect Ratio'"
      ></sti-checkbox>
      <sti-checkbox
        class="min-version"
        [(value)]="useStretch"
        [disabled]="!hasImage"
        [label]="'Stretch'"
      ></sti-checkbox>
    </div>
    <div class="image-container" #imageContainer [style.justify-content]="getHorizontalAlignment()">
      <input
        type="file"
        [style.display]="'none'"
        accept=".jpg, .jpeg, .png"
        (click)="$event.target.value = null"
        (change)="onFileSelected($event.target)"
        #inputFile
      />
      <div
        class="image-preview"
        [style.width.px]="useStretch && useAspectRatio ? imageContainer.clientHeight : imageContainer.clientWidth"
        [style.height.px]="imageContainer.clientHeight"
        [style.background-image]="image"
        [style.background-position]="getBackgroundPosition()"
        [style.background-size]="getBackgroundSize(imageContainer)"
        [style.background-repeat]="image ? 'no-repeat' : ''"
      ></div>
    </div>
  </div>`, styles: [".image-preview{width:100%;height:100%}.disabled{pointer-events:none;opacity:.6}sti-checkbox{font-size:12px!important;font-family:Arial!important;margin:0 5px}sti-checkbox .label{font-size:12px!important}.image-container{border-radius:3px;border:1px dashed lightgray;height:100%;width:100%;display:flex}.editor-container{height:calc(100% - 20px);width:calc(100% - 20px);margin:10px;display:flex;flex-direction:column}.editor-navigation{height:26px;margin-bottom:5px;margin-top:10px;display:flex}.navigation-button:hover{background-color:#d3d3d3}.navigation-button{height:26px;width:26px;margin-right:2px;border-radius:3px;display:flex;align-items:center;justify-content:center}.navigation-button img{height:16px;width:16px}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }, { type: i3.StiHelperService }, { type: i4.SignatureService }] });
//# sourceMappingURL=data:application/json;base64,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