import { Component, Input, ViewChild, } from "@angular/core";
import { StiHorizontalAlignment, StiLabelAlignment } from "../system/enums";
import { Enum } from "../system/Enum";
import { StiTableElement } from "../elements/StiTableElement";
import { StiColumnItem } from "../elements/table/StiColumnItem";
import { StiRowLabel } from "../elements/table/StiRowLabel";
import { StiTotalsFieldItem } from "../elements/table/StiTotalsFieldItem";
import { StiLabelItem } from "../elements/text/StiLabelItem";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/sti-editable-content.service";
import * as i3 from "../services/mouse.service";
import * as i4 from "@angular/common";
////
export class StiEditableContentComponent {
    get cursor() {
        if (this.model.previewMode) {
            return "default";
        }
        else {
            return this.showPlaceholder ? "text" : "";
        }
    }
    get showPlaceholder() {
        return (!this.hideEmpty &&
            !(!this.focused && this.displayContent != null ? this.displayContent : this.editableContent?.eValue) &&
            this.active &&
            !this.model.previewMode /* &&
        this.editableContentService.editableContent != this.editableContent */);
    }
    hasWordWrap() {
        return this.editableContent["useWordWrap"] ? true : false;
    }
    get showNonActivePlaceholder() {
        return (!this.hideEmpty &&
            !(!this.focused && this.displayContent != null ? this.displayContent : this.editableContent?.eValue) &&
            ((!this.active && !this.model.previewMode) ||
                (!this.active && this.model.previewMode) ||
                (this.active && this.model.previewMode)) /* &&
      this.editableContentService.editableContent != this.editableContent */);
    }
    get placeholderOutline() {
        if (this.showPlaceholder) {
            return !this.fromButton ? "1px dashed rgba(213, 213, 213, 0.8)" : "1px dashed rgba(255, 255, 255, 1)";
        }
        else {
            return "";
        }
    }
    click() {
        if (this.showPlaceholder) {
            this.elementRef.nativeElement.focus();
        }
    }
    get isEditable() {
        return (!this.model.previewMode &&
            (this.editableContentService.editableContent == this.editableContent || this.showPlaceholder));
    }
    get width() {
        if (this.editableContent instanceof StiLabelItem && this.editableContent.alignment != StiLabelAlignment.Top) {
            return this.editableContent.width + "px";
        }
        else {
            return "100%";
        }
    }
    get align() {
        if (this.alignment) {
            return Enum.getName(StiHorizontalAlignment, this.alignment);
        }
        else {
            return "";
        }
    }
    constructor(model, editableContentService, mouseService, cdr) {
        this.model = model;
        this.editableContentService = editableContentService;
        this.mouseService = mouseService;
        this.cdr = cdr;
        this.required = false;
        this.hideEmpty = true;
        this.active = true;
        this.isTableTotalHeader = false;
        this.disablePadding = false;
        this.fromButton = false;
        this.isTableHeader = false;
        this.isInitialize = false;
        this.focused = false;
    }
    ngOnDestroy() {
        this.mouseUpSubscription?.unsubscribe();
    }
    ngAfterContentInit() {
        setTimeout(() => {
            if (this.editableContent && this.eParent) {
                this.editableContent.eParent = this.eParent;
            }
        }, 0);
    }
    needToUpdate(event) {
        let elements = document.elementsFromPoint(event.clientX, event.clientY);
        let needToUpdate = true;
        elements.forEach((element) => {
            if (element.className == "Properties") {
                needToUpdate = false;
            }
        });
        if (needToUpdate &&
            typeof this.editableContentService.editableContent != typeof this.editableContent &&
            this.isInitialize &&
            !this.editableContentService.activeControl) {
            this.closeAll(this.model.selectedComponent?.element);
            this.isInitialize = false;
            needToUpdate = true;
            this.model.needToRefresh.next(true);
        }
    }
    focus() {
        this.editableContentService.editableContent = this.editableContent;
        this.editableContentService.editableElementRef = this.elementRef;
        if (this.model.selectedComponent?.element instanceof StiTableElement) {
            // this.closeAll(this.model.selectedComponent.element);
            // this.model.currentTablePropertyHeader.next("Table");
            if (this.editableContent instanceof StiColumnItem) {
                if (!this.model.selectedComponent?.element.showColumnsEditor) {
                    this.model.selectedComponent.element.showColumnsEditor = true;
                    this.model.needToRefresh.next(true);
                }
                // this.model.currentTablePropertyHeader.next("Columns");
                setTimeout(() => {
                    if (this.model.selectedComponent?.element instanceof StiTableElement) {
                        let index = this.model.selectedComponent.element.columns.findIndex((column) => column == this.editableContent);
                        if (this.model.currentContentEditableItemIndex != index ||
                            this.model.previousSelectedComponent != this.model.selectedComponent)
                            this.model.currentContentEditableItem.next(index);
                        this.model.currentContentEditableItemIndex = index;
                    }
                }, 0);
            }
            else if (this.editableContent instanceof StiRowLabel) {
                this.model.selectedComponent.element.showRowsEditor = true;
                this.model.needToRefresh.next(true);
                // this.model.currentTablePropertyHeader.next("Rows");
                /*  setTimeout(() => {
                  if (this.model.selectedComponent.element instanceof StiTableElement) {
                    this.model.currentContentEditableItem.next(
                      this.model.selectedComponent.element.rowLabelsContentEditable.findIndex(
                        (column) => column == this.editableContent
                      )
                    );
                  }
                }, 0); */
            }
            else if (this.editableContent instanceof StiTotalsFieldItem) {
                if (!this.model.selectedComponent.element.showTotalsEditor) {
                    this.model.selectedComponent.element.showTotalsEditor = true;
                    this.model.needToRefresh.next(true);
                }
                // this.model.currentTablePropertyHeader.next("Totals");
                setTimeout(() => {
                    if (this.model.selectedComponent.element instanceof StiTableElement) {
                        let index = this.model.selectedComponent.element.totalsFields.findIndex((column) => column == this.editableContent);
                        this.model.currentContentEditableItem.next(index);
                    }
                }, 0);
            }
            else if (this.isTableTotalHeader) {
                this.model.selectedComponent.element.showTotalsEditor = true;
                this.model.needToRefresh.next(true);
            }
            else {
                this.model.selectedComponent.element.showHeaderEditor = true;
                this.model.needToRefresh.next(true);
            }
        }
        this.isInitialize = true;
        this.focused = true;
    }
    blur() {
        if (!this.editableContentService.activeControl) {
            setTimeout(() => {
                if (this.editableContentService.editableContent == this.editableContent) {
                    this.editableContentService.editableContent = null;
                    this.editableContentService.editableElementRef = null;
                    if (this.model.getBrowserType() == "safari" ||
                        (this.model.getBrowserType() == "firefox" && !this.showPlaceholder)) {
                        this.cdr.reattach();
                        this.cdr.detectChanges();
                    }
                    this.model.formEvents.next({ name: "ValueChanged" });
                }
                this.focused = false;
            }, 0);
        }
    }
    setContent(innerText) {
        if ((this.model.getBrowserType() == "safari" || this.model.getBrowserType() == "firefox") && this.showPlaceholder) {
            this.editableContentService.startEdit();
        }
        if (this.model.getBrowserType() == "safari" ||
            (this.model.getBrowserType() == "firefox" && !this.showPlaceholder)) {
            this.cdr.detach();
        }
        this.editableContent.eValue = innerText;
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    getCharCode(event) {
        return null === event.which ? event.keyCode : !(0 === event.which || 0 === event.charCode) ? event.which : -1;
    }
    disableEnter(event) {
        if (13 === this.getCharCode(event)) {
            event.preventDefault();
            this.blur();
        }
    }
    disableDrag(event) {
        event.fromEditableContent = true;
        this.focus();
    }
    closeAll(element) {
        if (element instanceof StiTableElement) {
            element.showTotalsEditor = false;
            element.showRowsEditor = false;
            element.showColumnsEditor = false;
        }
    }
    ngOnInit() {
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe((event) => {
            this.needToUpdate(event);
        });
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiEditableContentComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiEditableContentService }, { token: i3.StiMouseService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiEditableContentComponent, selector: "sti-editable-content-component", inputs: { editableContent: "editableContent", displayContent: "displayContent", required: "required", eParent: "eParent", hideEmpty: "hideEmpty", active: "active", alignment: "alignment", isTableTotalHeader: "isTableTotalHeader", disablePadding: "disablePadding", fromButton: "fromButton", parentCursor: "parentCursor", isTableHeader: "isTableHeader" }, viewQueries: [{ propertyName: "elementRef", first: true, predicate: ["elementRef"], descendants: true }], ngImport: i0, template: ` <div
    style="-webkit-user-select: {{ model.getBrowserType() == 'safari' ? 'text' : '' }}"
    [style.width]="width"
    [style.overflow]="'hidden'"
  >
    <div
      class="editable-content"
      [style.display]="alignment ? 'flex' : ''"
      [style.justify-content]="align"
      [style.width]="showPlaceholder ? '10px' : width"
      [style.minWidth.px]="showPlaceholder ? 10 : 0"
      [style.outline]="placeholderOutline"
      [style.outline-offset]="'-1px'"
      [style.cursor]="cursor"
      (click)="click()"
    >
      <label
        #elementRef
        *ngIf="!focused && displayContent != null ? displayContent : editableContent?.eValue || !hideEmpty"
        [style]="editableContent?.htmlStyle() ? editableContent?.htmlStyle() : ''"
        [style.padding-right.px]="disablePadding || required ? 0.1 : showNonActivePlaceholder ? 0 : 5"
        spellcheck="false"
        [style.cursor]="parentCursor ? parentCursor : !model.previewMode ? 'text' : 'default'"
        [attr.contenteditable]="isEditable ? 'plaintext-only' : false"
        [textContent]="!focused && displayContent != null ? displayContent : editableContent?.eValue"
        [style.word-wrap]="hasWordWrap() ? 'break-word' : ''"
        [style.white-space]="hasWordWrap() ? '' : 'nowrap'"
        [style.width]="showPlaceholder ? '100%' : ''"
        [style.text-align]="isTableHeader ? align : ''"
        (input)="setContent($event.target.textContent)"
        (keypress)="disableEnter($event)"
        (focus)="focus()"
        (mousedown)="disableDrag($event)"
        (blur)="blur()"
      >
      </label>
      <span
        class="required"
        [style]="editableContent?.htmlStyle() ? editableContent?.htmlStyle() : ''"
        *ngIf="required"
        [style.color]="'red'"
        [style.font-style]="'normal'"
        [style.font-weight]="'normal'"
        >*</span
      >
      <div
        *ngIf="showNonActivePlaceholder"
        [style]="editableContent?.htmlStyle() ? editableContent?.htmlStyle() : ''"
        class="empty-content"
      >
        .
      </div>
    </div>
  </div>`, isInline: true, styles: [".empty-content{position:relative;left:0;top:0;opacity:0;max-height:1px}label{margin:0;outline:none;max-width:100%;overflow:hidden;scroll-behavior:smooth}.required{color:red;position:relative;margin:0 2px}label:hover{cursor:text}.editable-content{overflow:hidden}\n"], dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiEditableContentComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-editable-content-component", template: ` <div
    style="-webkit-user-select: {{ model.getBrowserType() == 'safari' ? 'text' : '' }}"
    [style.width]="width"
    [style.overflow]="'hidden'"
  >
    <div
      class="editable-content"
      [style.display]="alignment ? 'flex' : ''"
      [style.justify-content]="align"
      [style.width]="showPlaceholder ? '10px' : width"
      [style.minWidth.px]="showPlaceholder ? 10 : 0"
      [style.outline]="placeholderOutline"
      [style.outline-offset]="'-1px'"
      [style.cursor]="cursor"
      (click)="click()"
    >
      <label
        #elementRef
        *ngIf="!focused && displayContent != null ? displayContent : editableContent?.eValue || !hideEmpty"
        [style]="editableContent?.htmlStyle() ? editableContent?.htmlStyle() : ''"
        [style.padding-right.px]="disablePadding || required ? 0.1 : showNonActivePlaceholder ? 0 : 5"
        spellcheck="false"
        [style.cursor]="parentCursor ? parentCursor : !model.previewMode ? 'text' : 'default'"
        [attr.contenteditable]="isEditable ? 'plaintext-only' : false"
        [textContent]="!focused && displayContent != null ? displayContent : editableContent?.eValue"
        [style.word-wrap]="hasWordWrap() ? 'break-word' : ''"
        [style.white-space]="hasWordWrap() ? '' : 'nowrap'"
        [style.width]="showPlaceholder ? '100%' : ''"
        [style.text-align]="isTableHeader ? align : ''"
        (input)="setContent($event.target.textContent)"
        (keypress)="disableEnter($event)"
        (focus)="focus()"
        (mousedown)="disableDrag($event)"
        (blur)="blur()"
      >
      </label>
      <span
        class="required"
        [style]="editableContent?.htmlStyle() ? editableContent?.htmlStyle() : ''"
        *ngIf="required"
        [style.color]="'red'"
        [style.font-style]="'normal'"
        [style.font-weight]="'normal'"
        >*</span
      >
      <div
        *ngIf="showNonActivePlaceholder"
        [style]="editableContent?.htmlStyle() ? editableContent?.htmlStyle() : ''"
        class="empty-content"
      >
        .
      </div>
    </div>
  </div>`, styles: [".empty-content{position:relative;left:0;top:0;opacity:0;max-height:1px}label{margin:0;outline:none;max-width:100%;overflow:hidden;scroll-behavior:smooth}.required{color:red;position:relative;margin:0 2px}label:hover{cursor:text}.editable-content{overflow:hidden}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiEditableContentService }, { type: i3.StiMouseService }, { type: i0.ChangeDetectorRef }], propDecorators: { elementRef: [{
                type: ViewChild,
                args: ["elementRef"]
            }], editableContent: [{
                type: Input
            }], displayContent: [{
                type: Input
            }], required: [{
                type: Input
            }], eParent: [{
                type: Input
            }], hideEmpty: [{
                type: Input
            }], active: [{
                type: Input
            }], alignment: [{
                type: Input
            }], isTableTotalHeader: [{
                type: Input
            }], disablePadding: [{
                type: Input
            }], fromButton: [{
                type: Input
            }], parentCursor: [{
                type: Input
            }], isTableHeader: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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