import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "./sti-dropdown-service";
import * as i2 from "../../services/sti-editable-content.service";
import * as i3 from "@angular/common";
export class StiDropdownListComponent {
    get list() {
        return this.dropdownService.currentOptionList;
    }
    getValue(index) {
        let value = this.list[index][this.dropdownService.optionLabel ? this.dropdownService.optionLabel : index.toString()];
        return value ? value : this.list[index];
    }
    isActive(index) {
        let value = this.list[index][this.dropdownService.optionLabel ? this.dropdownService.optionLabel : index.toString()];
        return value ? value == this.dropdownService.currentValue : this.list[index] == this.dropdownService.currentValue;
    }
    setItem(index) {
        let item = this.dropdownService.currentOptionList[index][this.dropdownService.optionValue ? this.dropdownService.optionValue : index.toString()];
        this.dropdownService.valueChanged.next(item ? item : this.dropdownService.currentOptionList[index]);
        this.dropdownService.showDropdownList = false;
        this.dropdownService.optionLabel = null;
        this.dropdownService.optionValue = null;
    }
    constructor(dropdownService, editableContentService) {
        this.dropdownService = dropdownService;
        this.editableContentService = editableContentService;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiDropdownListComponent, deps: [{ token: i1.StiDropdownService }, { token: i2.StiEditableContentService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiDropdownListComponent, selector: "sti-dropdown-list-component", ngImport: i0, template: `<div
    class="sti-dropdown-list"
    [style.left.px]="dropdownService.dropdownX"
    [style.top.px]="dropdownService.dropdownY + 2"
  >
    <span
      class="list-item {{ isActive(i) ? 'active' : '' }}"
      *ngFor="let item of list; let i = index"
      (click)="setItem(i)"
      (mousedown)="$event.preventDefault()"
      (mouseup)="editableContentService.startEdit()"
      >{{ getValue(i) }}</span
    >
  </div>`, isInline: true, styles: [".active{background-color:#efefef!important}.sti-dropdown-list{position:absolute;display:flex;flex-direction:column;max-height:400px;max-width:202px;overflow-x:hidden;overflow-y:auto;background:var(--input-color);color:var(--text-color);border:1px solid #c8c8c8;border-radius:3px;font-size:13px;z-index:999999999999999;box-shadow:0 3px 6px #00000029;-webkit-touch-callout:none;-webkit-user-select:none;-khtml-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.list-item{font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif,\"Apple Color Emoji\",\"Segoe UI Emoji\",Segoe UI Symbol;margin:0;padding:.429rem .857rem;border:0 none;color:var(--text-color);background:transparent;transition:background-color .2s,box-shadow .2s;border-radius:0;cursor:pointer;font-weight:400;position:relative;white-space:nowrap}.list-item:hover{background-color:#d3d3d3!important}\n"], dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiDropdownListComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-dropdown-list-component", template: `<div
    class="sti-dropdown-list"
    [style.left.px]="dropdownService.dropdownX"
    [style.top.px]="dropdownService.dropdownY + 2"
  >
    <span
      class="list-item {{ isActive(i) ? 'active' : '' }}"
      *ngFor="let item of list; let i = index"
      (click)="setItem(i)"
      (mousedown)="$event.preventDefault()"
      (mouseup)="editableContentService.startEdit()"
      >{{ getValue(i) }}</span
    >
  </div>`, styles: [".active{background-color:#efefef!important}.sti-dropdown-list{position:absolute;display:flex;flex-direction:column;max-height:400px;max-width:202px;overflow-x:hidden;overflow-y:auto;background:var(--input-color);color:var(--text-color);border:1px solid #c8c8c8;border-radius:3px;font-size:13px;z-index:999999999999999;box-shadow:0 3px 6px #00000029;-webkit-touch-callout:none;-webkit-user-select:none;-khtml-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.list-item{font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif,\"Apple Color Emoji\",\"Segoe UI Emoji\",Segoe UI Symbol;margin:0;padding:.429rem .857rem;border:0 none;color:var(--text-color);background:transparent;transition:background-color .2s,box-shadow .2s;border-radius:0;cursor:pointer;font-weight:400;position:relative;white-space:nowrap}.list-item:hover{background-color:#d3d3d3!important}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiDropdownService }, { type: i2.StiEditableContentService }] });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLWRyb3Bkb3duLWxpc3QuY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3RpbXVsc29mdC1mb3Jtcy9zcmMvbGliL2NvbXBvbmVudHMvc3RpLWRyb3Bkb3duLWNvbXBvbmVudC9zdGktZHJvcGRvd24tbGlzdC5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFNBQVMsRUFBVSxNQUFNLGVBQWUsQ0FBQzs7Ozs7QUFvRWxELE1BQU0sT0FBTyx3QkFBd0I7SUFDbkMsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDLGlCQUFpQixDQUFDO0lBQ2hELENBQUM7SUFDTSxRQUFRLENBQUMsS0FBSztRQUNuQixJQUFJLEtBQUssR0FDUCxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7UUFDM0csT0FBTyxLQUFLLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBQ00sUUFBUSxDQUFDLEtBQUs7UUFDbkIsSUFBSSxLQUFLLEdBQ1AsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxRQUFRLEVBQUUsQ0FBQyxDQUFDO1FBQzNHLE9BQU8sS0FBSyxDQUFDLENBQUMsQ0FBQyxLQUFLLElBQUksSUFBSSxDQUFDLGVBQWUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksSUFBSSxDQUFDLGVBQWUsQ0FBQyxZQUFZLENBQUM7SUFDcEgsQ0FBQztJQUNELE9BQU8sQ0FBQyxLQUFLO1FBQ1gsSUFBSSxJQUFJLEdBQ04sSUFBSSxDQUFDLGVBQWUsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsQ0FDM0MsSUFBSSxDQUFDLGVBQWUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsUUFBUSxFQUFFLENBQ3ZGLENBQUM7UUFDSixJQUFJLENBQUMsZUFBZSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsaUJBQWlCLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztRQUNwRyxJQUFJLENBQUMsZUFBZSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQztRQUM5QyxJQUFJLENBQUMsZUFBZSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUM7UUFDeEMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDO0lBQzFDLENBQUM7SUFDRCxZQUFtQixlQUFtQyxFQUFTLHNCQUFpRDtRQUE3RixvQkFBZSxHQUFmLGVBQWUsQ0FBb0I7UUFBUywyQkFBc0IsR0FBdEIsc0JBQXNCLENBQTJCO0lBQUcsQ0FBQztJQUVwSCxRQUFRLEtBQUksQ0FBQzsrR0ExQkYsd0JBQXdCO21HQUF4Qix3QkFBd0IsbUVBOUR6Qjs7Ozs7Ozs7Ozs7OztTQWFIOzs0RkFpREksd0JBQXdCO2tCQWhFcEMsU0FBUzsrQkFDRSw2QkFBNkIsWUFDN0I7Ozs7Ozs7Ozs7Ozs7U0FhSCIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCwgT25Jbml0IH0gZnJvbSBcIkBhbmd1bGFyL2NvcmVcIjtcclxuaW1wb3J0IHsgU3RpRWRpdGFibGVDb250ZW50U2VydmljZSB9IGZyb20gXCIuLi8uLi9zZXJ2aWNlcy9zdGktZWRpdGFibGUtY29udGVudC5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aURyb3Bkb3duU2VydmljZSB9IGZyb20gXCIuL3N0aS1kcm9wZG93bi1zZXJ2aWNlXCI7XHJcblxyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogXCJzdGktZHJvcGRvd24tbGlzdC1jb21wb25lbnRcIixcclxuICB0ZW1wbGF0ZTogYDxkaXZcclxuICAgIGNsYXNzPVwic3RpLWRyb3Bkb3duLWxpc3RcIlxyXG4gICAgW3N0eWxlLmxlZnQucHhdPVwiZHJvcGRvd25TZXJ2aWNlLmRyb3Bkb3duWFwiXHJcbiAgICBbc3R5bGUudG9wLnB4XT1cImRyb3Bkb3duU2VydmljZS5kcm9wZG93blkgKyAyXCJcclxuICA+XHJcbiAgICA8c3BhblxyXG4gICAgICBjbGFzcz1cImxpc3QtaXRlbSB7eyBpc0FjdGl2ZShpKSA/ICdhY3RpdmUnIDogJycgfX1cIlxyXG4gICAgICAqbmdGb3I9XCJsZXQgaXRlbSBvZiBsaXN0OyBsZXQgaSA9IGluZGV4XCJcclxuICAgICAgKGNsaWNrKT1cInNldEl0ZW0oaSlcIlxyXG4gICAgICAobW91c2Vkb3duKT1cIiRldmVudC5wcmV2ZW50RGVmYXVsdCgpXCJcclxuICAgICAgKG1vdXNldXApPVwiZWRpdGFibGVDb250ZW50U2VydmljZS5zdGFydEVkaXQoKVwiXHJcbiAgICAgID57eyBnZXRWYWx1ZShpKSB9fTwvc3BhblxyXG4gICAgPlxyXG4gIDwvZGl2PmAsXHJcbiAgc3R5bGVzOiBbXHJcbiAgICBgXHJcbiAgICAgIC5hY3RpdmUge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHJnYigyMzksIDIzOSwgMjM5KSAhaW1wb3J0YW50O1xyXG4gICAgICB9XHJcbiAgICAgIC5zdGktZHJvcGRvd24tbGlzdCB7XHJcbiAgICAgICAgcG9zaXRpb246IGFic29sdXRlO1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcclxuICAgICAgICBtYXgtaGVpZ2h0OiA0MDBweDtcclxuICAgICAgICBtYXgtd2lkdGg6IDIwMnB4O1xyXG4gICAgICAgIG92ZXJmbG93LXg6IGhpZGRlbjtcclxuICAgICAgICBvdmVyZmxvdy15OiBhdXRvO1xyXG4gICAgICAgIGJhY2tncm91bmQ6IHZhcigtLWlucHV0LWNvbG9yKTtcclxuICAgICAgICBjb2xvcjogdmFyKC0tdGV4dC1jb2xvcik7XHJcbiAgICAgICAgYm9yZGVyOiAxcHggc29saWQgI2M4YzhjODtcclxuICAgICAgICBib3JkZXItcmFkaXVzOiAzcHg7XHJcbiAgICAgICAgZm9udC1zaXplOiAxM3B4O1xyXG4gICAgICAgIHotaW5kZXg6IDk5OTk5OTk5OTk5OTk5OTtcclxuICAgICAgICBib3gtc2hhZG93OiAwIDNweCA2cHggMCByZ2JhKDAsIDAsIDAsIDAuMTYpO1xyXG4gICAgICAgIC13ZWJraXQtdG91Y2gtY2FsbG91dDogbm9uZTtcclxuICAgICAgICAtd2Via2l0LXVzZXItc2VsZWN0OiBub25lO1xyXG4gICAgICAgIC1raHRtbC11c2VyLXNlbGVjdDogbm9uZTtcclxuICAgICAgICAtbW96LXVzZXItc2VsZWN0OiBub25lO1xyXG4gICAgICAgIC1tcy11c2VyLXNlbGVjdDogbm9uZTtcclxuICAgICAgICB1c2VyLXNlbGVjdDogbm9uZTtcclxuICAgICAgfVxyXG4gICAgICAubGlzdC1pdGVtIHtcclxuICAgICAgICBmb250LWZhbWlseTogLWFwcGxlLXN5c3RlbSwgQmxpbmtNYWNTeXN0ZW1Gb250LCBcIlNlZ29lIFVJXCIsIFJvYm90bywgSGVsdmV0aWNhLCBBcmlhbCwgc2Fucy1zZXJpZixcclxuICAgICAgICAgIFwiQXBwbGUgQ29sb3IgRW1vamlcIiwgXCJTZWdvZSBVSSBFbW9qaVwiLCBcIlNlZ29lIFVJIFN5bWJvbFwiO1xyXG4gICAgICAgIG1hcmdpbjogMDtcclxuICAgICAgICBwYWRkaW5nOiAwLjQyOXJlbSAwLjg1N3JlbTtcclxuICAgICAgICBib3JkZXI6IDAgbm9uZTtcclxuICAgICAgICBjb2xvcjogdmFyKC0tdGV4dC1jb2xvcik7XHJcbiAgICAgICAgYmFja2dyb3VuZDogdHJhbnNwYXJlbnQ7XHJcbiAgICAgICAgdHJhbnNpdGlvbjogYmFja2dyb3VuZC1jb2xvciAwLjJzLCBib3gtc2hhZG93IDAuMnM7XHJcbiAgICAgICAgYm9yZGVyLXJhZGl1czogMDtcclxuICAgICAgICBjdXJzb3I6IHBvaW50ZXI7XHJcbiAgICAgICAgZm9udC13ZWlnaHQ6IDQwMDtcclxuICAgICAgICBwb3NpdGlvbjogcmVsYXRpdmU7XHJcbiAgICAgICAgd2hpdGUtc3BhY2U6IG5vd3JhcDtcclxuICAgICAgfVxyXG4gICAgICAubGlzdC1pdGVtOmhvdmVyIHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiBsaWdodGdyYXkgIWltcG9ydGFudDtcclxuICAgICAgfVxyXG4gICAgYCxcclxuICBdLFxyXG59KVxyXG5leHBvcnQgY2xhc3MgU3RpRHJvcGRvd25MaXN0Q29tcG9uZW50IGltcGxlbWVudHMgT25Jbml0IHtcclxuICBwdWJsaWMgZ2V0IGxpc3QoKSB7XHJcbiAgICByZXR1cm4gdGhpcy5kcm9wZG93blNlcnZpY2UuY3VycmVudE9wdGlvbkxpc3Q7XHJcbiAgfVxyXG4gIHB1YmxpYyBnZXRWYWx1ZShpbmRleCkge1xyXG4gICAgbGV0IHZhbHVlID1cclxuICAgICAgdGhpcy5saXN0W2luZGV4XVt0aGlzLmRyb3Bkb3duU2VydmljZS5vcHRpb25MYWJlbCA/IHRoaXMuZHJvcGRvd25TZXJ2aWNlLm9wdGlvbkxhYmVsIDogaW5kZXgudG9TdHJpbmcoKV07XHJcbiAgICByZXR1cm4gdmFsdWUgPyB2YWx1ZSA6IHRoaXMubGlzdFtpbmRleF07XHJcbiAgfVxyXG4gIHB1YmxpYyBpc0FjdGl2ZShpbmRleCkge1xyXG4gICAgbGV0IHZhbHVlID1cclxuICAgICAgdGhpcy5saXN0W2luZGV4XVt0aGlzLmRyb3Bkb3duU2VydmljZS5vcHRpb25MYWJlbCA/IHRoaXMuZHJvcGRvd25TZXJ2aWNlLm9wdGlvbkxhYmVsIDogaW5kZXgudG9TdHJpbmcoKV07XHJcbiAgICByZXR1cm4gdmFsdWUgPyB2YWx1ZSA9PSB0aGlzLmRyb3Bkb3duU2VydmljZS5jdXJyZW50VmFsdWUgOiB0aGlzLmxpc3RbaW5kZXhdID09IHRoaXMuZHJvcGRvd25TZXJ2aWNlLmN1cnJlbnRWYWx1ZTtcclxuICB9XHJcbiAgc2V0SXRlbShpbmRleCkge1xyXG4gICAgbGV0IGl0ZW0gPVxyXG4gICAgICB0aGlzLmRyb3Bkb3duU2VydmljZS5jdXJyZW50T3B0aW9uTGlzdFtpbmRleF1bXHJcbiAgICAgICAgdGhpcy5kcm9wZG93blNlcnZpY2Uub3B0aW9uVmFsdWUgPyB0aGlzLmRyb3Bkb3duU2VydmljZS5vcHRpb25WYWx1ZSA6IGluZGV4LnRvU3RyaW5nKClcclxuICAgICAgXTtcclxuICAgIHRoaXMuZHJvcGRvd25TZXJ2aWNlLnZhbHVlQ2hhbmdlZC5uZXh0KGl0ZW0gPyBpdGVtIDogdGhpcy5kcm9wZG93blNlcnZpY2UuY3VycmVudE9wdGlvbkxpc3RbaW5kZXhdKTtcclxuICAgIHRoaXMuZHJvcGRvd25TZXJ2aWNlLnNob3dEcm9wZG93bkxpc3QgPSBmYWxzZTtcclxuICAgIHRoaXMuZHJvcGRvd25TZXJ2aWNlLm9wdGlvbkxhYmVsID0gbnVsbDtcclxuICAgIHRoaXMuZHJvcGRvd25TZXJ2aWNlLm9wdGlvblZhbHVlID0gbnVsbDtcclxuICB9XHJcbiAgY29uc3RydWN0b3IocHVibGljIGRyb3Bkb3duU2VydmljZTogU3RpRHJvcGRvd25TZXJ2aWNlLCBwdWJsaWMgZWRpdGFibGVDb250ZW50U2VydmljZTogU3RpRWRpdGFibGVDb250ZW50U2VydmljZSkge31cclxuXHJcbiAgbmdPbkluaXQoKSB7fVxyXG59XHJcbiJdfQ==