import { animate, state, style, transition, trigger } from "@angular/animations";
import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/sti-component-resizer.service";
export class StiComponentResizerComponent {
    constructor(model, componentResizerService) {
        this.model = model;
        this.componentResizerService = componentResizerService;
        this.size = 5;
        this.leftOffset = 2;
        this.rightOffset = 3;
    }
    get visible() {
        return (this.model.selectedComponent == this.component &&
            !this.model.previewMode &&
            this.component.element.position == "absolute");
    }
    get width() {
        return this.component.element.width;
    }
    get height() {
        return this.component.element.height;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiComponentResizerComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiComponentResizerService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiComponentResizerComponent, selector: "sti-component-resizer", inputs: { left: "left", top: "top", size: "size", component: "component" }, ngImport: i0, template: `
    <div
      class="bottom-right resizer"
      style="position: absolute;cursor: nwse-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - rightOffset"
      [style.top.px]="top - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromBottomRight')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
    <div
      class="right resizer"
      style="position: absolute;cursor: ew-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - rightOffset"
      [style.top.px]="top - height / 2 - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromRight')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
    <div
      class="bottom resizer"
      style="position: absolute;cursor: ns-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - width / 2 - rightOffset"
      [style.top.px]="top - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromBottom')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
    <div
      class="bottom-left resizer"
      style="position: absolute;cursor: nesw-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - width - leftOffset"
      [style.top.px]="top - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromBottomLeft')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
    <div
      class="left resizer"
      style="position: absolute;cursor: ew-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - width - leftOffset"
      [style.top.px]="top - height / 2 - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromLeft')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
  `, isInline: true, animations: [
            trigger("visibility", [
                // ...
                state("visible", style({
                    visibility: "",
                })),
                state("hidden", style({
                    visibility: "hidden",
                })),
                transition("visible => hidden", [animate("0s 0.2s")]),
                transition("hidden => visible", [animate("0s")]),
            ]),
        ] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiComponentResizerComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-component-resizer",
                    template: `
    <div
      class="bottom-right resizer"
      style="position: absolute;cursor: nwse-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - rightOffset"
      [style.top.px]="top - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromBottomRight')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
    <div
      class="right resizer"
      style="position: absolute;cursor: ew-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - rightOffset"
      [style.top.px]="top - height / 2 - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromRight')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
    <div
      class="bottom resizer"
      style="position: absolute;cursor: ns-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - width / 2 - rightOffset"
      [style.top.px]="top - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromBottom')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
    <div
      class="bottom-left resizer"
      style="position: absolute;cursor: nesw-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - width - leftOffset"
      [style.top.px]="top - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromBottomLeft')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
    <div
      class="left resizer"
      style="position: absolute;cursor: ew-resize;background: rgb(105, 105, 105);transition: opacity 0.2s ease; z-index: 100"
      draggable="false"
      [style.opacity]="visible ? 1 : 0"
      [style.left.px]="left - width - leftOffset"
      [style.top.px]="top - height / 2 - rightOffset"
      [style.width.px]="size"
      [style.height.px]="size"
      (mousedown)="componentResizerService.initResize(component.element, $event, 'fromLeft')"
      (dragstart)="$event.preventDefault()"
      [@visibility]="visible ? 'visible' : 'hidden'"
    ></div>
  `,
                    animations: [
                        trigger("visibility", [
                            // ...
                            state("visible", style({
                                visibility: "",
                            })),
                            state("hidden", style({
                                visibility: "hidden",
                            })),
                            transition("visible => hidden", [animate("0s 0.2s")]),
                            transition("hidden => visible", [animate("0s")]),
                        ]),
                    ],
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiComponentResizerService }], propDecorators: { left: [{
                type: Input
            }], top: [{
                type: Input
            }], size: [{
                type: Input
            }], component: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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