import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-color-dialog.service";
import * as i3 from "../../services/sti-localization.service";
import * as i4 from "../../services/sti-rich-text.service";
import * as i5 from "@angular/common";
import * as i6 from "@angular/forms";
export class StiColorOptionsDialogComponent {
    constructor(model, colorService, loc, richText) {
        this.model = model;
        this.colorService = colorService;
        this.loc = loc;
        this.richText = richText;
        this.currentState = "custom";
        this.currentSelectedItem = "Transparent";
    }
    checkRange(event, object, property) {
        if (parseInt(event.target.value)) {
            if (parseInt(event.target.value) > 255) {
                object[property] = 255;
            }
            else if (parseInt(event.target.value) < 0) {
                object[property] = 0;
            }
            else {
                object[property] = parseInt(event.target.value);
            }
        }
        else {
            object[property] = 0;
        }
        event.target.value = object[property];
    }
    checkHex(event) {
        if (event.target.value) {
            if (event.target.value.length > 7) {
                let value = event.target.value.slice(0, 6);
                this.hex = value;
            }
            else {
                this.hex = event.target.value;
            }
        }
        else {
            this.hex = "#000000";
        }
        event.target.value = this.hex;
    }
    changeState(state) {
        this.currentState = state;
    }
    get hex() {
        return this.colorService.cloneOfCurrentColorObject.toHexColor();
    }
    set hex(value) {
        this.colorService.cloneOfCurrentColorObject.hexColor = value;
    }
    changeColor() {
        if (this.currentState == "custom") {
            this.colorService.currentColorObject.hexColor = this.colorService.cloneOfCurrentColorObject.hexColor;
        }
        else {
            let colorObj = this.colorService.browserColors.find((color) => color.name == this.currentSelectedItem);
            if (colorObj.name != "Transparent") {
                this.colorService.currentColorObject.hexColor = this.colorService.rgbToHex(colorObj.color);
            }
            else {
                this.colorService.currentColorObject.a = 0;
            }
        }
        if (this.colorService.isRichText) {
            this.richText.insertForeColor();
        }
        this.model.showMoreColorDialog = false;
        this.model.showColorDialog = false;
    }
    getColor(color) {
        return `rgb(${color})`;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiColorOptionsDialogComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiColorDialogService }, { token: i3.StiLocalizationService }, { token: i4.StiRichTextService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiColorOptionsDialogComponent, selector: "sti-color-options-dialog", ngImport: i0, template: `
    <div class="color-options-dialog">
      <div class="dialog-navigation">
        <div class="header-navigation">
          <span> {{ loc.get2("Gui", "colorpickerdialog_caption") }}</span>
          <div class="close-button" (click)="model.showMoreColorDialog = false">
            <i class="pi pi-times"></i>
          </div>
        </div>
        <div class="content-navigation">
          <div class="content-button {{ currentState == 'custom' ? 'current' : '' }}" (click)="changeState('custom')">
            <span>{{ loc.get2("Gui", "colorpickerdialog_tabcustom") }}</span>
            <div class="horizontal-line"></div>
          </div>
          <div class="content-button {{ currentState == 'web' ? 'current' : '' }}" (click)="changeState('web')">
            <span>{{ "Web" }}</span>
            <div class="horizontal-line"></div>
          </div>
        </div>
      </div>
      <div class="dialog-content">
        <div class="custom-dialog" *ngIf="currentState == 'custom'">
          <div class="input-fields">
            <div class="field">
              <span>{{
                loc.get2("Gui", "colorpickerdialog_alphalabel").replace("&amp", "").replace(";", "").replace(":", "")
              }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="colorService.cloneOfCurrentColorObject.a"
                (keyup.enter)="checkRange($event, colorService.cloneOfCurrentColorObject, 'a')"
                (blur)="checkRange($event, colorService.cloneOfCurrentColorObject, 'a')"
              />
            </div>
            <div class="field">
              <span>{{
                loc.get2("Gui", "colorpickerdialog_redlabel").replace("&amp", "").replace(";", "").replace(":", "")
              }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="colorService.cloneOfCurrentColorObject.r"
                (keyup.enter)="checkRange($event, colorService.cloneOfCurrentColorObject, 'r')"
                (blur)="checkRange($event, colorService.cloneOfCurrentColorObject, 'r')"
              />
            </div>
            <div class="field">
              <span>{{
                loc.get2("Gui", "colorpickerdialog_greenlabel").replace("&amp", "").replace(";", "").replace(":", "")
              }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="colorService.cloneOfCurrentColorObject.g"
                (keyup.enter)="checkRange($event, colorService.cloneOfCurrentColorObject, 'g')"
                (blur)="checkRange($event, colorService.cloneOfCurrentColorObject, 'g')"
              />
            </div>
            <div class="field">
              <span>{{
                loc.get2("Gui", "colorpickerdialog_bluelabel").replace("&amp", "").replace(";", "").replace(":", "")
              }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="colorService.cloneOfCurrentColorObject.b"
                (keyup.enter)="checkRange($event, colorService.cloneOfCurrentColorObject, 'b')"
                (blur)="checkRange($event, colorService.cloneOfCurrentColorObject, 'b')"
              />
            </div>
            <div class="field">
              <span>{{ "Hex" }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="hex"
                (keyup.enter)="checkHex($event)"
                (blur)="checkHex($event)"
              />
            </div>
          </div>
          <div class="color-preview">
            <div class="preview" [style.background-color]="colorService.cloneOfCurrentColorObject.toHtmlColor()"></div>
          </div>
        </div>
        <div class="web-dialog" *ngIf="currentState == 'web'">
          <div
            class="color-item {{ currentSelectedItem == item.name ? 'selected' : '' }}"
            *ngFor="let item of colorService.browserColors"
            (click)="currentSelectedItem = item.name"
          >
            <div class="mini-color-preview" [style.background-color]="getColor(item.color)"></div>
            <span> {{ item.name }}</span>
          </div>
        </div>
      </div>
      <div class="footer-navigation">
        <div class="footer-button accept" (click)="changeColor()">
          <span>{{ loc.get2("Buttons", "Ok").replace("&amp", "").replace(";", "") }}</span>
        </div>
        <div class="footer-button cancel" [style.margin-right.px]="10" (click)="model.showMoreColorDialog = false">
          <span>{{ loc.get2("PropertyMain", "Cancel") }}</span>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".selected{background-color:#e5e5e5}.web-dialog{height:190px;overflow:auto;width:calc(100% - 20px);margin:5px 10px}.mini-color-preview{width:64px;height:15px;border-radius:3px;border:1px solid #ababab;cursor:default;margin:0 4px}.color-item span{color:#444;font-family:Arial;font-size:12px;font-weight:400;cursor:default}.color-item{height:24px;display:flex;width:calc(100% - 2px);align-items:center;border-radius:3px;margin:1px}.color-item:hover{background-color:#dadada}.field{display:flex;width:100%;flex:1;align-items:center}.field span{width:100%;color:#444;font-family:Arial;font-size:12px;font-weight:400;cursor:default}.field input{width:80px;height:21px;font-size:12px;margin:0;padding:0 0 0 4px;border-radius:3px;font-family:Arial;outline:none;max-width:inherit;border:1px solid #ababab;color:#444}.custom-dialog{display:flex;padding-left:19px;padding-top:5px}.input-fields{width:140px;height:180px;display:flex;flex-direction:column}.preview{height:128px;width:128px;border:1px solid #c6c6c6}.color-preview{height:180px;width:180px;display:flex;align-items:center;justify-content:center}.pi{font-size:.5rem}.color-options-dialog{min-height:315px;-webkit-user-select:none;-moz-user-select:none;width:345px;left:calc(50% - 172.5px);top:calc(50% - 157.5px);position:absolute;border:1px solid #19478a;background:#fff;color:#444;-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d;cursor:default;display:flex;flex-direction:column;z-index:99999}.header-navigation{display:flex;width:100%;height:30px;align-items:center;padding-left:15px;padding-right:3px}.header-navigation span{font-family:Arial;font-size:13px;font-weight:700;color:#19478a;cursor:default;width:100%}.close-button{width:28px;height:24px;border-radius:3px;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#d3d3d3}.content-navigation{width:calc(100% - 20px);height:40px;display:flex;border-bottom:1px solid lightgray;align-items:center;margin:0 12px}.content-button{min-width:35px;height:26px;border-radius:3px;display:flex;flex-direction:column;justify-content:center;margin-right:2px}.content-button:hover{background-color:#dadada}.content-button span{color:#444;font-family:Arial;font-size:12px;font-weight:400;cursor:default;text-align:center;margin:0 10px}.horizontal-line{height:3px;border-radius:3px;margin:0 10px}.current{background-color:#e5e5e5}.current .horizontal-line{background-color:#19478a}.footer-button{width:80px;height:24px;border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 5px 10px;-webkit-user-select:none;font-family:Arial;font-size:12px}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}.footer-navigation{display:flex;justify-content:end}.dialog-content{height:100%;width:100%;flex:1}\n"], dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i6.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i6.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i6.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiColorOptionsDialogComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-color-options-dialog", template: `
    <div class="color-options-dialog">
      <div class="dialog-navigation">
        <div class="header-navigation">
          <span> {{ loc.get2("Gui", "colorpickerdialog_caption") }}</span>
          <div class="close-button" (click)="model.showMoreColorDialog = false">
            <i class="pi pi-times"></i>
          </div>
        </div>
        <div class="content-navigation">
          <div class="content-button {{ currentState == 'custom' ? 'current' : '' }}" (click)="changeState('custom')">
            <span>{{ loc.get2("Gui", "colorpickerdialog_tabcustom") }}</span>
            <div class="horizontal-line"></div>
          </div>
          <div class="content-button {{ currentState == 'web' ? 'current' : '' }}" (click)="changeState('web')">
            <span>{{ "Web" }}</span>
            <div class="horizontal-line"></div>
          </div>
        </div>
      </div>
      <div class="dialog-content">
        <div class="custom-dialog" *ngIf="currentState == 'custom'">
          <div class="input-fields">
            <div class="field">
              <span>{{
                loc.get2("Gui", "colorpickerdialog_alphalabel").replace("&amp", "").replace(";", "").replace(":", "")
              }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="colorService.cloneOfCurrentColorObject.a"
                (keyup.enter)="checkRange($event, colorService.cloneOfCurrentColorObject, 'a')"
                (blur)="checkRange($event, colorService.cloneOfCurrentColorObject, 'a')"
              />
            </div>
            <div class="field">
              <span>{{
                loc.get2("Gui", "colorpickerdialog_redlabel").replace("&amp", "").replace(";", "").replace(":", "")
              }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="colorService.cloneOfCurrentColorObject.r"
                (keyup.enter)="checkRange($event, colorService.cloneOfCurrentColorObject, 'r')"
                (blur)="checkRange($event, colorService.cloneOfCurrentColorObject, 'r')"
              />
            </div>
            <div class="field">
              <span>{{
                loc.get2("Gui", "colorpickerdialog_greenlabel").replace("&amp", "").replace(";", "").replace(":", "")
              }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="colorService.cloneOfCurrentColorObject.g"
                (keyup.enter)="checkRange($event, colorService.cloneOfCurrentColorObject, 'g')"
                (blur)="checkRange($event, colorService.cloneOfCurrentColorObject, 'g')"
              />
            </div>
            <div class="field">
              <span>{{
                loc.get2("Gui", "colorpickerdialog_bluelabel").replace("&amp", "").replace(";", "").replace(":", "")
              }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="colorService.cloneOfCurrentColorObject.b"
                (keyup.enter)="checkRange($event, colorService.cloneOfCurrentColorObject, 'b')"
                (blur)="checkRange($event, colorService.cloneOfCurrentColorObject, 'b')"
              />
            </div>
            <div class="field">
              <span>{{ "Hex" }}</span>
              <input
                type="text"
                name=""
                id=""
                [ngModel]="hex"
                (keyup.enter)="checkHex($event)"
                (blur)="checkHex($event)"
              />
            </div>
          </div>
          <div class="color-preview">
            <div class="preview" [style.background-color]="colorService.cloneOfCurrentColorObject.toHtmlColor()"></div>
          </div>
        </div>
        <div class="web-dialog" *ngIf="currentState == 'web'">
          <div
            class="color-item {{ currentSelectedItem == item.name ? 'selected' : '' }}"
            *ngFor="let item of colorService.browserColors"
            (click)="currentSelectedItem = item.name"
          >
            <div class="mini-color-preview" [style.background-color]="getColor(item.color)"></div>
            <span> {{ item.name }}</span>
          </div>
        </div>
      </div>
      <div class="footer-navigation">
        <div class="footer-button accept" (click)="changeColor()">
          <span>{{ loc.get2("Buttons", "Ok").replace("&amp", "").replace(";", "") }}</span>
        </div>
        <div class="footer-button cancel" [style.margin-right.px]="10" (click)="model.showMoreColorDialog = false">
          <span>{{ loc.get2("PropertyMain", "Cancel") }}</span>
        </div>
      </div>
    </div>
  `, styles: [".selected{background-color:#e5e5e5}.web-dialog{height:190px;overflow:auto;width:calc(100% - 20px);margin:5px 10px}.mini-color-preview{width:64px;height:15px;border-radius:3px;border:1px solid #ababab;cursor:default;margin:0 4px}.color-item span{color:#444;font-family:Arial;font-size:12px;font-weight:400;cursor:default}.color-item{height:24px;display:flex;width:calc(100% - 2px);align-items:center;border-radius:3px;margin:1px}.color-item:hover{background-color:#dadada}.field{display:flex;width:100%;flex:1;align-items:center}.field span{width:100%;color:#444;font-family:Arial;font-size:12px;font-weight:400;cursor:default}.field input{width:80px;height:21px;font-size:12px;margin:0;padding:0 0 0 4px;border-radius:3px;font-family:Arial;outline:none;max-width:inherit;border:1px solid #ababab;color:#444}.custom-dialog{display:flex;padding-left:19px;padding-top:5px}.input-fields{width:140px;height:180px;display:flex;flex-direction:column}.preview{height:128px;width:128px;border:1px solid #c6c6c6}.color-preview{height:180px;width:180px;display:flex;align-items:center;justify-content:center}.pi{font-size:.5rem}.color-options-dialog{min-height:315px;-webkit-user-select:none;-moz-user-select:none;width:345px;left:calc(50% - 172.5px);top:calc(50% - 157.5px);position:absolute;border:1px solid #19478a;background:#fff;color:#444;-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d;cursor:default;display:flex;flex-direction:column;z-index:99999}.header-navigation{display:flex;width:100%;height:30px;align-items:center;padding-left:15px;padding-right:3px}.header-navigation span{font-family:Arial;font-size:13px;font-weight:700;color:#19478a;cursor:default;width:100%}.close-button{width:28px;height:24px;border-radius:3px;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#d3d3d3}.content-navigation{width:calc(100% - 20px);height:40px;display:flex;border-bottom:1px solid lightgray;align-items:center;margin:0 12px}.content-button{min-width:35px;height:26px;border-radius:3px;display:flex;flex-direction:column;justify-content:center;margin-right:2px}.content-button:hover{background-color:#dadada}.content-button span{color:#444;font-family:Arial;font-size:12px;font-weight:400;cursor:default;text-align:center;margin:0 10px}.horizontal-line{height:3px;border-radius:3px;margin:0 10px}.current{background-color:#e5e5e5}.current .horizontal-line{background-color:#19478a}.footer-button{width:80px;height:24px;border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 5px 10px;-webkit-user-select:none;font-family:Arial;font-size:12px}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}.footer-navigation{display:flex;justify-content:end}.dialog-content{height:100%;width:100%;flex:1}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiColorDialogService }, { type: i3.StiLocalizationService }, { type: i4.StiRichTextService }] });
//# sourceMappingURL=data:application/json;base64,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