import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "../sti-component";
import * as i4 from "../sti-editable-content.component";
import * as i5 from "../svg.components/svg.checkbox.component";
export class StiCheckBoxComponent {
    get align() {
        return "start";
    }
    constructor(model) {
        this.model = model;
    }
    disableDrag(event) {
        this.model.canDrag = false;
    }
    changeState() {
        this.element.isChecked = !this.element.isChecked;
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiCheckBoxComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiCheckBoxComponent, selector: "sti-checkbox-component", inputs: { element: "element", isClone: "isClone" }, ngImport: i0, template: `
    <sti-component [element]="element" [isClone]="isClone" class="sti-check-box">
      <sti-editable-content-component
        *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
        [editableContent]="element.label"
        [style.align-self]="align"
        [style.text-align]="element?.getContentAlign()"
        [required]="element.required"
        [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
        [style.width]="element?.getLabelWidth()"
      ></sti-editable-content-component>
      <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
        <tr>
          <td
            *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
            [style.display]="'flex'"
            [style.height]="'100%'"
            [style.width]="element?.getLabelWidth()"
            [style.align-items]="element?.getVerticalAlignment()"
          >
            <sti-editable-content-component
              *ngIf="element?.label.value?.length > 0"
              [editableContent]="element?.label"
              [required]="element.required"
              [style.text-align]="element?.getContentAlign()"
              [style.width]="element?.getLabelWidth()"
              [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
            ></sti-editable-content-component>
          </td>
          <td [style.width]="'100%'" [style.maxWidth.px]="element.maxWidth + 1">
            <sti-svg-checkbox-component
              [element]="element"
              [tabIndex]="element['tabIndex']"
              [id]="element?.name"
              [text]="element?.text"
              [state]="element?.isChecked"
              (buttonClick)="changeState()"
            ></sti-svg-checkbox-component>
          </td>
        </tr>
        <tr *ngIf="element?.description.value?.length > 0">
          <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
          <td [style.maxWidth.px]="element.maxWidth + 1">
            <sti-editable-content-component
              *ngIf="element?.description.value?.length > 0"
              [editableContent]="element.description"
            >
            </sti-editable-content-component>
          </td>
        </tr>
      </table>
    </sti-component>
    <style>
      table {
        border-spacing: 0;
      }
      tr {
        height: max-content;
        padding: 0;
        margin: 0;
      }
      td {
        height: 100%;
        padding: 0;
        margin: 0;
      }
    </style>
  `, isInline: true, styles: ["\n      table {\n        border-spacing: 0;\n      }\n      tr {\n        height: max-content;\n        padding: 0;\n        margin: 0;\n      }\n      td {\n        height: 100%;\n        padding: 0;\n        margin: 0;\n      }\n    "], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i3.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i4.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "component", type: i5.StiSvgCheckBoxComponent, selector: "sti-svg-checkbox-component", inputs: ["element", "id", "text", "state", "useCustomOption", "disablePlaceHolder", "tabIndex"], outputs: ["buttonClick"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiCheckBoxComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-checkbox-component",
                    template: `
    <sti-component [element]="element" [isClone]="isClone" class="sti-check-box">
      <sti-editable-content-component
        *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
        [editableContent]="element.label"
        [style.align-self]="align"
        [style.text-align]="element?.getContentAlign()"
        [required]="element.required"
        [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
        [style.width]="element?.getLabelWidth()"
      ></sti-editable-content-component>
      <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
        <tr>
          <td
            *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
            [style.display]="'flex'"
            [style.height]="'100%'"
            [style.width]="element?.getLabelWidth()"
            [style.align-items]="element?.getVerticalAlignment()"
          >
            <sti-editable-content-component
              *ngIf="element?.label.value?.length > 0"
              [editableContent]="element?.label"
              [required]="element.required"
              [style.text-align]="element?.getContentAlign()"
              [style.width]="element?.getLabelWidth()"
              [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
            ></sti-editable-content-component>
          </td>
          <td [style.width]="'100%'" [style.maxWidth.px]="element.maxWidth + 1">
            <sti-svg-checkbox-component
              [element]="element"
              [tabIndex]="element['tabIndex']"
              [id]="element?.name"
              [text]="element?.text"
              [state]="element?.isChecked"
              (buttonClick)="changeState()"
            ></sti-svg-checkbox-component>
          </td>
        </tr>
        <tr *ngIf="element?.description.value?.length > 0">
          <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
          <td [style.maxWidth.px]="element.maxWidth + 1">
            <sti-editable-content-component
              *ngIf="element?.description.value?.length > 0"
              [editableContent]="element.description"
            >
            </sti-editable-content-component>
          </td>
        </tr>
      </table>
    </sti-component>
    <style>
      table {
        border-spacing: 0;
      }
      tr {
        height: max-content;
        padding: 0;
        margin: 0;
      }
      td {
        height: 100%;
        padding: 0;
        margin: 0;
      }
    </style>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }], propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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