import { Component, ViewChild } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-localization.service";
import * as i3 from "@angular/common";
export class StiButtonMessageWindowComponent {
    get left() {
        if (this.messageWindow) {
            return `calc(50% - ${this.windowWidth / 2}px)`;
        }
        else {
            return `calc(50% - 125px)`;
        }
    }
    get top() {
        if (this.messageWindow) {
            return `calc(50% - ${this.windowHeight / 2}px)`;
        }
        else {
            return `calc(50% - 65px)`;
        }
    }
    constructor(model, loc) {
        this.model = model;
        this.loc = loc;
        this.windowWidth = 250;
        this.windowHeight = 130;
    }
    retry() {
        this.model.showButtonMessageWindow = false;
        this.model.showErrorWindow = false;
        this.model.sendedFromButton = false;
        this.model.retryButtonRequest.next(this.model.currentUsedButtonElement);
    }
    ngAfterViewInit() {
        if (this.messageWindow) {
            this.windowWidth = this.messageWindow.nativeElement.offsetWidth;
            this.windowHeight = this.messageWindow.nativeElement.offsetHeight;
        }
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiButtonMessageWindowComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiButtonMessageWindowComponent, selector: "button-message-window", viewQueries: [{ propertyName: "messageWindow", first: true, predicate: ["messageWindow"], descendants: true }], ngImport: i0, template: `
    <div #messageWindow [style.left]="left" [style.top]="top" class="message-window">
      <div class="navigation">
        <div class="navigation-title">
          <span>{{ loc.get2("Permissions", "ItemForms") }}</span>
        </div>
        <div
          class="close-button"
          *ngIf="!model.showErrorWindow"
          (click)="model.showButtonMessageWindow = !model.showButtonMessageWindow"
        >
          <img [src]="model.getImage('images.Other.CloseForm.png')" />
        </div>
      </div>
      <div class="content">
        <span>{{ model.errorWindowMessage }}</span>
      </div>
      <div class="accept-container">
        <div
          class="accept button"
          *ngIf="!model.sendedFromButton"
          (click)="model.showButtonMessageWindow = false; model.showErrorWindow = false"
        >
          <span>{{ loc.get2("Buttons", "Ok").replace("&amp", "").replace(";", "") }}</span>
        </div>
        <div class="error button" *ngIf="model.sendedFromButton" (click)="retry()">
          <span>{{ loc.get2("PropertyEnum", "DialogResultRetry") }}</span>
        </div>
        <div
          class="error button"
          *ngIf="model.sendedFromButton"
          (click)="model.showButtonMessageWindow = false; model.showErrorWindow = false; model.sendedFromButton = false"
        >
          <span>{{ loc.get2("PropertyMain", "Cancel") }}</span>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".message-window{position:absolute;z-index:99999999;background-color:var(--back-color);border:1px solid rgb(25,71,138);min-width:250px;max-width:1000px;min-height:130px;max-height:1000px;top:calc(50% - 65px);display:flex;flex-direction:column;overflow:hidden;border-radius:5px;-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d}.navigation{height:30px;width:100%;display:flex;justify-content:flex-end;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a}.navigation-title{flex:1;color:#fff;font-family:Arial;font-size:13px;display:flex;align-items:center;padding-left:10px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none}.close-button{width:30px;height:100%;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#d3d3d3}.close-button:active{background-color:var(--active-color)}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}.content{width:100%;height:100%;flex:1;display:flex;align-items:center;justify-content:center;padding:10px}.content span{color:var(--text-color);font-size:12px;font-family:Segoe UI;word-wrap:break-word;cursor:default;-webkit-user-select:none;user-select:none}.accept-container{height:50px;width:100%;display:flex;justify-content:center;align-items:center}.accept{width:80px;height:30px}.error{width:70px;height:30px;margin:5px}.button{background-color:#19478a;color:#fff;border-radius:3px;display:flex;align-items:center;justify-content:center}.button:hover{background-color:#3d6298}.button span{font-size:12px;font-family:Segoe UI;cursor:default;-webkit-user-select:none;user-select:none}\n"], dependencies: [{ kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiButtonMessageWindowComponent, decorators: [{
            type: Component,
            args: [{ selector: "button-message-window", template: `
    <div #messageWindow [style.left]="left" [style.top]="top" class="message-window">
      <div class="navigation">
        <div class="navigation-title">
          <span>{{ loc.get2("Permissions", "ItemForms") }}</span>
        </div>
        <div
          class="close-button"
          *ngIf="!model.showErrorWindow"
          (click)="model.showButtonMessageWindow = !model.showButtonMessageWindow"
        >
          <img [src]="model.getImage('images.Other.CloseForm.png')" />
        </div>
      </div>
      <div class="content">
        <span>{{ model.errorWindowMessage }}</span>
      </div>
      <div class="accept-container">
        <div
          class="accept button"
          *ngIf="!model.sendedFromButton"
          (click)="model.showButtonMessageWindow = false; model.showErrorWindow = false"
        >
          <span>{{ loc.get2("Buttons", "Ok").replace("&amp", "").replace(";", "") }}</span>
        </div>
        <div class="error button" *ngIf="model.sendedFromButton" (click)="retry()">
          <span>{{ loc.get2("PropertyEnum", "DialogResultRetry") }}</span>
        </div>
        <div
          class="error button"
          *ngIf="model.sendedFromButton"
          (click)="model.showButtonMessageWindow = false; model.showErrorWindow = false; model.sendedFromButton = false"
        >
          <span>{{ loc.get2("PropertyMain", "Cancel") }}</span>
        </div>
      </div>
    </div>
  `, styles: [".message-window{position:absolute;z-index:99999999;background-color:var(--back-color);border:1px solid rgb(25,71,138);min-width:250px;max-width:1000px;min-height:130px;max-height:1000px;top:calc(50% - 65px);display:flex;flex-direction:column;overflow:hidden;border-radius:5px;-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d}.navigation{height:30px;width:100%;display:flex;justify-content:flex-end;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a}.navigation-title{flex:1;color:#fff;font-family:Arial;font-size:13px;display:flex;align-items:center;padding-left:10px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none}.close-button{width:30px;height:100%;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#d3d3d3}.close-button:active{background-color:var(--active-color)}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}.content{width:100%;height:100%;flex:1;display:flex;align-items:center;justify-content:center;padding:10px}.content span{color:var(--text-color);font-size:12px;font-family:Segoe UI;word-wrap:break-word;cursor:default;-webkit-user-select:none;user-select:none}.accept-container{height:50px;width:100%;display:flex;justify-content:center;align-items:center}.accept{width:80px;height:30px}.error{width:70px;height:30px;margin:5px}.button{background-color:#19478a;color:#fff;border-radius:3px;display:flex;align-items:center;justify-content:center}.button:hover{background-color:#3d6298}.button span{font-size:12px;font-family:Segoe UI;cursor:default;-webkit-user-select:none;user-select:none}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }], propDecorators: { messageWindow: [{
                type: ViewChild,
                args: ["messageWindow"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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